# Magento2\CatalogProductAttributeOptionManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogProductAttributeOptionManagementV1AddPost()**](CatalogProductAttributeOptionManagementV1Api.md#catalogProductAttributeOptionManagementV1AddPost) | **POST** /V1/products/attributes/{attributeCode}/options | 
[**catalogProductAttributeOptionManagementV1DeleteDelete()**](CatalogProductAttributeOptionManagementV1Api.md#catalogProductAttributeOptionManagementV1DeleteDelete) | **DELETE** /V1/products/attributes/{attributeCode}/options/{optionId} | 
[**catalogProductAttributeOptionManagementV1GetItemsGet()**](CatalogProductAttributeOptionManagementV1Api.md#catalogProductAttributeOptionManagementV1GetItemsGet) | **GET** /V1/products/attributes/{attributeCode}/options | 


## `catalogProductAttributeOptionManagementV1AddPost()`

```php
catalogProductAttributeOptionManagementV1AddPost($attribute_code, $catalog_product_attribute_option_management_v1_add_post_body): string
```



Add option to attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductAttributeOptionManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$attribute_code = 'attribute_code_example'; // string
$catalog_product_attribute_option_management_v1_add_post_body = new \Magento2\Model\CatalogProductAttributeOptionManagementV1AddPostRequest(); // \Magento2\Model\CatalogProductAttributeOptionManagementV1AddPostRequest

try {
    $result = $apiInstance->catalogProductAttributeOptionManagementV1AddPost($attribute_code, $catalog_product_attribute_option_management_v1_add_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductAttributeOptionManagementV1Api->catalogProductAttributeOptionManagementV1AddPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_code** | **string**|  |
 **catalog_product_attribute_option_management_v1_add_post_body** | [**\Magento2\Model\CatalogProductAttributeOptionManagementV1AddPostRequest**](../Model/CatalogProductAttributeOptionManagementV1AddPostRequest.md)|  | [optional]

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogProductAttributeOptionManagementV1DeleteDelete()`

```php
catalogProductAttributeOptionManagementV1DeleteDelete($attribute_code, $option_id): bool
```



Delete option from attribute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductAttributeOptionManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$attribute_code = 'attribute_code_example'; // string
$option_id = 'option_id_example'; // string

try {
    $result = $apiInstance->catalogProductAttributeOptionManagementV1DeleteDelete($attribute_code, $option_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductAttributeOptionManagementV1Api->catalogProductAttributeOptionManagementV1DeleteDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_code** | **string**|  |
 **option_id** | **string**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogProductAttributeOptionManagementV1GetItemsGet()`

```php
catalogProductAttributeOptionManagementV1GetItemsGet($attribute_code): \Magento2\Model\EavDataAttributeOptionInterface[]
```



Retrieve list of attribute options

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductAttributeOptionManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$attribute_code = 'attribute_code_example'; // string

try {
    $result = $apiInstance->catalogProductAttributeOptionManagementV1GetItemsGet($attribute_code);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductAttributeOptionManagementV1Api->catalogProductAttributeOptionManagementV1GetItemsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attribute_code** | **string**|  |

### Return type

[**\Magento2\Model\EavDataAttributeOptionInterface[]**](../Model/EavDataAttributeOptionInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
