# Magento2\CatalogProductAttributeMediaGalleryManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogProductAttributeMediaGalleryManagementV1CreatePost()**](CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogProductAttributeMediaGalleryManagementV1CreatePost) | **POST** /V1/products/{sku}/media | 
[**catalogProductAttributeMediaGalleryManagementV1GetGet()**](CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogProductAttributeMediaGalleryManagementV1GetGet) | **GET** /V1/products/{sku}/media/{entryId} | 
[**catalogProductAttributeMediaGalleryManagementV1GetListGet()**](CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogProductAttributeMediaGalleryManagementV1GetListGet) | **GET** /V1/products/{sku}/media | 
[**catalogProductAttributeMediaGalleryManagementV1RemoveDelete()**](CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogProductAttributeMediaGalleryManagementV1RemoveDelete) | **DELETE** /V1/products/{sku}/media/{entryId} | 
[**catalogProductAttributeMediaGalleryManagementV1UpdatePut()**](CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogProductAttributeMediaGalleryManagementV1UpdatePut) | **PUT** /V1/products/{sku}/media/{entryId} | 


## `catalogProductAttributeMediaGalleryManagementV1CreatePost()`

```php
catalogProductAttributeMediaGalleryManagementV1CreatePost($sku, $catalog_product_attribute_media_gallery_management_v1_create_post_body): int
```



Create new gallery entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductAttributeMediaGalleryManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$catalog_product_attribute_media_gallery_management_v1_create_post_body = new \Magento2\Model\CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest(); // \Magento2\Model\CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest

try {
    $result = $apiInstance->catalogProductAttributeMediaGalleryManagementV1CreatePost($sku, $catalog_product_attribute_media_gallery_management_v1_create_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductAttributeMediaGalleryManagementV1Api->catalogProductAttributeMediaGalleryManagementV1CreatePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **catalog_product_attribute_media_gallery_management_v1_create_post_body** | [**\Magento2\Model\CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest**](../Model/CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest.md)|  | [optional]

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogProductAttributeMediaGalleryManagementV1GetGet()`

```php
catalogProductAttributeMediaGalleryManagementV1GetGet($sku, $entry_id): \Magento2\Model\CatalogDataProductAttributeMediaGalleryEntryInterface
```



Return information about gallery entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductAttributeMediaGalleryManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$entry_id = 56; // int

try {
    $result = $apiInstance->catalogProductAttributeMediaGalleryManagementV1GetGet($sku, $entry_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductAttributeMediaGalleryManagementV1Api->catalogProductAttributeMediaGalleryManagementV1GetGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **entry_id** | **int**|  |

### Return type

[**\Magento2\Model\CatalogDataProductAttributeMediaGalleryEntryInterface**](../Model/CatalogDataProductAttributeMediaGalleryEntryInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogProductAttributeMediaGalleryManagementV1GetListGet()`

```php
catalogProductAttributeMediaGalleryManagementV1GetListGet($sku): \Magento2\Model\CatalogDataProductAttributeMediaGalleryEntryInterface[]
```



Retrieve the list of gallery entries associated with given product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductAttributeMediaGalleryManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->catalogProductAttributeMediaGalleryManagementV1GetListGet($sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductAttributeMediaGalleryManagementV1Api->catalogProductAttributeMediaGalleryManagementV1GetListGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |

### Return type

[**\Magento2\Model\CatalogDataProductAttributeMediaGalleryEntryInterface[]**](../Model/CatalogDataProductAttributeMediaGalleryEntryInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogProductAttributeMediaGalleryManagementV1RemoveDelete()`

```php
catalogProductAttributeMediaGalleryManagementV1RemoveDelete($sku, $entry_id): bool
```



Remove gallery entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductAttributeMediaGalleryManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$entry_id = 56; // int

try {
    $result = $apiInstance->catalogProductAttributeMediaGalleryManagementV1RemoveDelete($sku, $entry_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductAttributeMediaGalleryManagementV1Api->catalogProductAttributeMediaGalleryManagementV1RemoveDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **entry_id** | **int**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogProductAttributeMediaGalleryManagementV1UpdatePut()`

```php
catalogProductAttributeMediaGalleryManagementV1UpdatePut($sku, $entry_id, $catalog_product_attribute_media_gallery_management_v1_update_put_body): bool
```



Update gallery entry

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogProductAttributeMediaGalleryManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$entry_id = 'entry_id_example'; // string
$catalog_product_attribute_media_gallery_management_v1_update_put_body = new \Magento2\Model\CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest(); // \Magento2\Model\CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest

try {
    $result = $apiInstance->catalogProductAttributeMediaGalleryManagementV1UpdatePut($sku, $entry_id, $catalog_product_attribute_media_gallery_management_v1_update_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogProductAttributeMediaGalleryManagementV1Api->catalogProductAttributeMediaGalleryManagementV1UpdatePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **entry_id** | **string**|  |
 **catalog_product_attribute_media_gallery_management_v1_update_put_body** | [**\Magento2\Model\CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest**](../Model/CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
