# Magento2\CatalogInventoryStockRegistryV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogInventoryStockRegistryV1GetLowStockItemsGet()**](CatalogInventoryStockRegistryV1Api.md#catalogInventoryStockRegistryV1GetLowStockItemsGet) | **GET** /V1/stockItems/lowStock/ | 
[**catalogInventoryStockRegistryV1GetStockItemBySkuGet()**](CatalogInventoryStockRegistryV1Api.md#catalogInventoryStockRegistryV1GetStockItemBySkuGet) | **GET** /V1/stockItems/{productSku} | 
[**catalogInventoryStockRegistryV1GetStockStatusBySkuGet()**](CatalogInventoryStockRegistryV1Api.md#catalogInventoryStockRegistryV1GetStockStatusBySkuGet) | **GET** /V1/stockStatuses/{productSku} | 
[**catalogInventoryStockRegistryV1UpdateStockItemBySkuPut()**](CatalogInventoryStockRegistryV1Api.md#catalogInventoryStockRegistryV1UpdateStockItemBySkuPut) | **PUT** /V1/products/{productSku}/stockItems/{itemId} | 


## `catalogInventoryStockRegistryV1GetLowStockItemsGet()`

```php
catalogInventoryStockRegistryV1GetLowStockItemsGet($scope_id, $qty, $current_page, $page_size): \Magento2\Model\CatalogInventoryDataStockItemCollectionInterface
```



Retrieves a list of SKU's with low inventory qty

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogInventoryStockRegistryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$scope_id = 56; // int
$qty = 3.4; // float
$current_page = 56; // int
$page_size = 56; // int

try {
    $result = $apiInstance->catalogInventoryStockRegistryV1GetLowStockItemsGet($scope_id, $qty, $current_page, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogInventoryStockRegistryV1Api->catalogInventoryStockRegistryV1GetLowStockItemsGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **scope_id** | **int**|  |
 **qty** | **float**|  |
 **current_page** | **int**|  | [optional]
 **page_size** | **int**|  | [optional]

### Return type

[**\Magento2\Model\CatalogInventoryDataStockItemCollectionInterface**](../Model/CatalogInventoryDataStockItemCollectionInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogInventoryStockRegistryV1GetStockItemBySkuGet()`

```php
catalogInventoryStockRegistryV1GetStockItemBySkuGet($product_sku, $scope_id): \Magento2\Model\CatalogInventoryDataStockItemInterface
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogInventoryStockRegistryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_sku = 'product_sku_example'; // string
$scope_id = 56; // int

try {
    $result = $apiInstance->catalogInventoryStockRegistryV1GetStockItemBySkuGet($product_sku, $scope_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogInventoryStockRegistryV1Api->catalogInventoryStockRegistryV1GetStockItemBySkuGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_sku** | **string**|  |
 **scope_id** | **int**|  | [optional]

### Return type

[**\Magento2\Model\CatalogInventoryDataStockItemInterface**](../Model/CatalogInventoryDataStockItemInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogInventoryStockRegistryV1GetStockStatusBySkuGet()`

```php
catalogInventoryStockRegistryV1GetStockStatusBySkuGet($product_sku, $scope_id): \Magento2\Model\CatalogInventoryDataStockStatusInterface
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogInventoryStockRegistryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_sku = 'product_sku_example'; // string
$scope_id = 56; // int

try {
    $result = $apiInstance->catalogInventoryStockRegistryV1GetStockStatusBySkuGet($product_sku, $scope_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogInventoryStockRegistryV1Api->catalogInventoryStockRegistryV1GetStockStatusBySkuGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_sku** | **string**|  |
 **scope_id** | **int**|  | [optional]

### Return type

[**\Magento2\Model\CatalogInventoryDataStockStatusInterface**](../Model/CatalogInventoryDataStockStatusInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogInventoryStockRegistryV1UpdateStockItemBySkuPut()`

```php
catalogInventoryStockRegistryV1UpdateStockItemBySkuPut($product_sku, $item_id, $catalog_inventory_stock_registry_v1_update_stock_item_by_sku_put_body): int
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogInventoryStockRegistryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_sku = 'product_sku_example'; // string
$item_id = 'item_id_example'; // string
$catalog_inventory_stock_registry_v1_update_stock_item_by_sku_put_body = new \Magento2\Model\CatalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest(); // \Magento2\Model\CatalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest

try {
    $result = $apiInstance->catalogInventoryStockRegistryV1UpdateStockItemBySkuPut($product_sku, $item_id, $catalog_inventory_stock_registry_v1_update_stock_item_by_sku_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogInventoryStockRegistryV1Api->catalogInventoryStockRegistryV1UpdateStockItemBySkuPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_sku** | **string**|  |
 **item_id** | **string**|  |
 **catalog_inventory_stock_registry_v1_update_stock_item_by_sku_put_body** | [**\Magento2\Model\CatalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest**](../Model/CatalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest.md)|  | [optional]

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
