# Magento2\CatalogCostStorageV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogCostStorageV1DeletePost()**](CatalogCostStorageV1Api.md#catalogCostStorageV1DeletePost) | **POST** /V1/products/cost-delete | 
[**catalogCostStorageV1GetPost()**](CatalogCostStorageV1Api.md#catalogCostStorageV1GetPost) | **POST** /V1/products/cost-information | 
[**catalogCostStorageV1UpdatePost()**](CatalogCostStorageV1Api.md#catalogCostStorageV1UpdatePost) | **POST** /V1/products/cost | 


## `catalogCostStorageV1DeletePost()`

```php
catalogCostStorageV1DeletePost($catalog_cost_storage_v1_delete_post_body): bool
```



Delete product cost. In case of at least one of skus is not found exception will be thrown. If error occurred during the delete exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogCostStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_cost_storage_v1_delete_post_body = new \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest(); // \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest

try {
    $result = $apiInstance->catalogCostStorageV1DeletePost($catalog_cost_storage_v1_delete_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogCostStorageV1Api->catalogCostStorageV1DeletePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_cost_storage_v1_delete_post_body** | [**\Magento2\Model\CatalogTierPriceStorageV1GetPostRequest**](../Model/CatalogTierPriceStorageV1GetPostRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogCostStorageV1GetPost()`

```php
catalogCostStorageV1GetPost($catalog_cost_storage_v1_get_post_body): \Magento2\Model\CatalogDataCostInterface[]
```



Return product prices. In case of at least one of skus is not found exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogCostStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_cost_storage_v1_get_post_body = new \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest(); // \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest

try {
    $result = $apiInstance->catalogCostStorageV1GetPost($catalog_cost_storage_v1_get_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogCostStorageV1Api->catalogCostStorageV1GetPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_cost_storage_v1_get_post_body** | [**\Magento2\Model\CatalogTierPriceStorageV1GetPostRequest**](../Model/CatalogTierPriceStorageV1GetPostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataCostInterface[]**](../Model/CatalogDataCostInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogCostStorageV1UpdatePost()`

```php
catalogCostStorageV1UpdatePost($catalog_cost_storage_v1_update_post_body): \Magento2\Model\CatalogDataPriceUpdateResultInterface[]
```



Add or update product cost. Input item should correspond to \\Magento\\Catalog\\Api\\Data\\CostInterface. If any items will have invalid cost, store id or sku, they will be marked as failed and excluded from update list and \\Magento\\Catalog\\Api\\Data\\PriceUpdateResultInterface[] with problem description will be returned. If there were no failed items during update empty array will be returned. If error occurred during the update exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogCostStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_cost_storage_v1_update_post_body = new \Magento2\Model\CatalogCostStorageV1UpdatePostRequest(); // \Magento2\Model\CatalogCostStorageV1UpdatePostRequest

try {
    $result = $apiInstance->catalogCostStorageV1UpdatePost($catalog_cost_storage_v1_update_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogCostStorageV1Api->catalogCostStorageV1UpdatePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_cost_storage_v1_update_post_body** | [**\Magento2\Model\CatalogCostStorageV1UpdatePostRequest**](../Model/CatalogCostStorageV1UpdatePostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataPriceUpdateResultInterface[]**](../Model/CatalogDataPriceUpdateResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
