# Magento2\CatalogCategoryLinkRepositoryV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogCategoryLinkRepositoryV1DeleteByIdsDelete()**](CatalogCategoryLinkRepositoryV1Api.md#catalogCategoryLinkRepositoryV1DeleteByIdsDelete) | **DELETE** /V1/categories/{categoryId}/products/{sku} | 
[**catalogCategoryLinkRepositoryV1SavePost()**](CatalogCategoryLinkRepositoryV1Api.md#catalogCategoryLinkRepositoryV1SavePost) | **POST** /V1/categories/{categoryId}/products | 
[**catalogCategoryLinkRepositoryV1SavePut()**](CatalogCategoryLinkRepositoryV1Api.md#catalogCategoryLinkRepositoryV1SavePut) | **PUT** /V1/categories/{categoryId}/products | 


## `catalogCategoryLinkRepositoryV1DeleteByIdsDelete()`

```php
catalogCategoryLinkRepositoryV1DeleteByIdsDelete($category_id, $sku): bool
```



Remove the product assignment from the category by category id and sku

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogCategoryLinkRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$category_id = 56; // int
$sku = 'sku_example'; // string

try {
    $result = $apiInstance->catalogCategoryLinkRepositoryV1DeleteByIdsDelete($category_id, $sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogCategoryLinkRepositoryV1Api->catalogCategoryLinkRepositoryV1DeleteByIdsDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **category_id** | **int**|  |
 **sku** | **string**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogCategoryLinkRepositoryV1SavePost()`

```php
catalogCategoryLinkRepositoryV1SavePost($category_id, $catalog_category_link_repository_v1_save_post_body): bool
```



Assign a product to the required category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogCategoryLinkRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$category_id = 'category_id_example'; // string
$catalog_category_link_repository_v1_save_post_body = new \Magento2\Model\CatalogCategoryLinkRepositoryV1SavePutRequest(); // \Magento2\Model\CatalogCategoryLinkRepositoryV1SavePutRequest

try {
    $result = $apiInstance->catalogCategoryLinkRepositoryV1SavePost($category_id, $catalog_category_link_repository_v1_save_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogCategoryLinkRepositoryV1Api->catalogCategoryLinkRepositoryV1SavePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **category_id** | **string**|  |
 **catalog_category_link_repository_v1_save_post_body** | [**\Magento2\Model\CatalogCategoryLinkRepositoryV1SavePutRequest**](../Model/CatalogCategoryLinkRepositoryV1SavePutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogCategoryLinkRepositoryV1SavePut()`

```php
catalogCategoryLinkRepositoryV1SavePut($category_id, $catalog_category_link_repository_v1_save_put_body): bool
```



Assign a product to the required category

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogCategoryLinkRepositoryV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$category_id = 'category_id_example'; // string
$catalog_category_link_repository_v1_save_put_body = new \Magento2\Model\CatalogCategoryLinkRepositoryV1SavePutRequest(); // \Magento2\Model\CatalogCategoryLinkRepositoryV1SavePutRequest

try {
    $result = $apiInstance->catalogCategoryLinkRepositoryV1SavePut($category_id, $catalog_category_link_repository_v1_save_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogCategoryLinkRepositoryV1Api->catalogCategoryLinkRepositoryV1SavePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **category_id** | **string**|  |
 **catalog_category_link_repository_v1_save_put_body** | [**\Magento2\Model\CatalogCategoryLinkRepositoryV1SavePutRequest**](../Model/CatalogCategoryLinkRepositoryV1SavePutRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
