# Magento2\CatalogBasePriceStorageV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**catalogBasePriceStorageV1GetPost()**](CatalogBasePriceStorageV1Api.md#catalogBasePriceStorageV1GetPost) | **POST** /V1/products/base-prices-information | 
[**catalogBasePriceStorageV1UpdatePost()**](CatalogBasePriceStorageV1Api.md#catalogBasePriceStorageV1UpdatePost) | **POST** /V1/products/base-prices | 


## `catalogBasePriceStorageV1GetPost()`

```php
catalogBasePriceStorageV1GetPost($catalog_base_price_storage_v1_get_post_body): \Magento2\Model\CatalogDataBasePriceInterface[]
```



Return product prices. In case of at least one of skus is not found exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogBasePriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_base_price_storage_v1_get_post_body = new \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest(); // \Magento2\Model\CatalogTierPriceStorageV1GetPostRequest

try {
    $result = $apiInstance->catalogBasePriceStorageV1GetPost($catalog_base_price_storage_v1_get_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogBasePriceStorageV1Api->catalogBasePriceStorageV1GetPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_base_price_storage_v1_get_post_body** | [**\Magento2\Model\CatalogTierPriceStorageV1GetPostRequest**](../Model/CatalogTierPriceStorageV1GetPostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataBasePriceInterface[]**](../Model/CatalogDataBasePriceInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `catalogBasePriceStorageV1UpdatePost()`

```php
catalogBasePriceStorageV1UpdatePost($catalog_base_price_storage_v1_update_post_body): \Magento2\Model\CatalogDataPriceUpdateResultInterface[]
```



Add or update product prices. Input item should correspond \\Magento\\Catalog\\Api\\Data\\CostInterface. If any items will have invalid price, store id or sku, they will be marked as failed and excluded from update list and \\Magento\\Catalog\\Api\\Data\\PriceUpdateResultInterface[] with problem description will be returned. If there were no failed items during update empty array will be returned. If error occurred during the update exception will be thrown.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\CatalogBasePriceStorageV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$catalog_base_price_storage_v1_update_post_body = new \Magento2\Model\CatalogBasePriceStorageV1UpdatePostRequest(); // \Magento2\Model\CatalogBasePriceStorageV1UpdatePostRequest

try {
    $result = $apiInstance->catalogBasePriceStorageV1UpdatePost($catalog_base_price_storage_v1_update_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CatalogBasePriceStorageV1Api->catalogBasePriceStorageV1UpdatePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **catalog_base_price_storage_v1_update_post_body** | [**\Magento2\Model\CatalogBasePriceStorageV1UpdatePostRequest**](../Model/CatalogBasePriceStorageV1UpdatePostRequest.md)|  | [optional]

### Return type

[**\Magento2\Model\CatalogDataPriceUpdateResultInterface[]**](../Model/CatalogDataPriceUpdateResultInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
