# Magento2\BundleProductOptionManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**bundleProductOptionManagementV1SavePost()**](BundleProductOptionManagementV1Api.md#bundleProductOptionManagementV1SavePost) | **POST** /V1/bundle-products/options/add | 
[**bundleProductOptionManagementV1SavePut()**](BundleProductOptionManagementV1Api.md#bundleProductOptionManagementV1SavePut) | **PUT** /V1/bundle-products/options/{optionId} | 


## `bundleProductOptionManagementV1SavePost()`

```php
bundleProductOptionManagementV1SavePost($bundle_product_option_management_v1_save_post_body): int
```



Add new option for bundle product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\BundleProductOptionManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bundle_product_option_management_v1_save_post_body = new \Magento2\Model\BundleProductOptionManagementV1SavePostRequest(); // \Magento2\Model\BundleProductOptionManagementV1SavePostRequest

try {
    $result = $apiInstance->bundleProductOptionManagementV1SavePost($bundle_product_option_management_v1_save_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BundleProductOptionManagementV1Api->bundleProductOptionManagementV1SavePost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bundle_product_option_management_v1_save_post_body** | [**\Magento2\Model\BundleProductOptionManagementV1SavePostRequest**](../Model/BundleProductOptionManagementV1SavePostRequest.md)|  | [optional]

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `bundleProductOptionManagementV1SavePut()`

```php
bundleProductOptionManagementV1SavePut($option_id, $bundle_product_option_management_v1_save_put_body): int
```



Add new option for bundle product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\BundleProductOptionManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$option_id = 'option_id_example'; // string
$bundle_product_option_management_v1_save_put_body = new \Magento2\Model\BundleProductOptionManagementV1SavePostRequest(); // \Magento2\Model\BundleProductOptionManagementV1SavePostRequest

try {
    $result = $apiInstance->bundleProductOptionManagementV1SavePut($option_id, $bundle_product_option_management_v1_save_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BundleProductOptionManagementV1Api->bundleProductOptionManagementV1SavePut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **option_id** | **string**|  |
 **bundle_product_option_management_v1_save_put_body** | [**\Magento2\Model\BundleProductOptionManagementV1SavePostRequest**](../Model/BundleProductOptionManagementV1SavePostRequest.md)|  | [optional]

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
