# Magento2\BundleProductLinkManagementV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**bundleProductLinkManagementV1AddChildByProductSkuPost()**](BundleProductLinkManagementV1Api.md#bundleProductLinkManagementV1AddChildByProductSkuPost) | **POST** /V1/bundle-products/{sku}/links/{optionId} | 
[**bundleProductLinkManagementV1GetChildrenGet()**](BundleProductLinkManagementV1Api.md#bundleProductLinkManagementV1GetChildrenGet) | **GET** /V1/bundle-products/{productSku}/children | 
[**bundleProductLinkManagementV1RemoveChildDelete()**](BundleProductLinkManagementV1Api.md#bundleProductLinkManagementV1RemoveChildDelete) | **DELETE** /V1/bundle-products/{sku}/options/{optionId}/children/{childSku} | 
[**bundleProductLinkManagementV1SaveChildPut()**](BundleProductLinkManagementV1Api.md#bundleProductLinkManagementV1SaveChildPut) | **PUT** /V1/bundle-products/{sku}/links/{id} | 


## `bundleProductLinkManagementV1AddChildByProductSkuPost()`

```php
bundleProductLinkManagementV1AddChildByProductSkuPost($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body): int
```



Add child product to specified Bundle option by product sku

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\BundleProductLinkManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$option_id = 56; // int
$bundle_product_link_management_v1_add_child_by_product_sku_post_body = new \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest(); // \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest

try {
    $result = $apiInstance->bundleProductLinkManagementV1AddChildByProductSkuPost($sku, $option_id, $bundle_product_link_management_v1_add_child_by_product_sku_post_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BundleProductLinkManagementV1Api->bundleProductLinkManagementV1AddChildByProductSkuPost: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **option_id** | **int**|  |
 **bundle_product_link_management_v1_add_child_by_product_sku_post_body** | [**\Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest**](../Model/BundleProductLinkManagementV1AddChildByProductSkuPostRequest.md)|  | [optional]

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `bundleProductLinkManagementV1GetChildrenGet()`

```php
bundleProductLinkManagementV1GetChildrenGet($product_sku, $option_id): \Magento2\Model\BundleDataLinkInterface[]
```



Get all children for Bundle product

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\BundleProductLinkManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product_sku = 'product_sku_example'; // string
$option_id = 56; // int

try {
    $result = $apiInstance->bundleProductLinkManagementV1GetChildrenGet($product_sku, $option_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BundleProductLinkManagementV1Api->bundleProductLinkManagementV1GetChildrenGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_sku** | **string**|  |
 **option_id** | **int**|  | [optional]

### Return type

[**\Magento2\Model\BundleDataLinkInterface[]**](../Model/BundleDataLinkInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `bundleProductLinkManagementV1RemoveChildDelete()`

```php
bundleProductLinkManagementV1RemoveChildDelete($sku, $option_id, $child_sku): bool
```



Remove product from Bundle product option

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\BundleProductLinkManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$option_id = 56; // int
$child_sku = 'child_sku_example'; // string

try {
    $result = $apiInstance->bundleProductLinkManagementV1RemoveChildDelete($sku, $option_id, $child_sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BundleProductLinkManagementV1Api->bundleProductLinkManagementV1RemoveChildDelete: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **option_id** | **int**|  |
 **child_sku** | **string**|  |

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `bundleProductLinkManagementV1SaveChildPut()`

```php
bundleProductLinkManagementV1SaveChildPut($sku, $id, $bundle_product_link_management_v1_save_child_put_body): bool
```



### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\BundleProductLinkManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$sku = 'sku_example'; // string
$id = 'id_example'; // string
$bundle_product_link_management_v1_save_child_put_body = new \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest(); // \Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest

try {
    $result = $apiInstance->bundleProductLinkManagementV1SaveChildPut($sku, $id, $bundle_product_link_management_v1_save_child_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling BundleProductLinkManagementV1Api->bundleProductLinkManagementV1SaveChildPut: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sku** | **string**|  |
 **id** | **string**|  |
 **bundle_product_link_management_v1_save_child_put_body** | [**\Magento2\Model\BundleProductLinkManagementV1AddChildByProductSkuPostRequest**](../Model/BundleProductLinkManagementV1AddChildByProductSkuPostRequest.md)|  | [optional]

### Return type

**bool**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
