# Magento2\AsynchronousOperationsBulkStatusV1Api

All URIs are relative to https://magento2.talisman-innovations.com/rest/default.

Method | HTTP request | Description
------------- | ------------- | -------------
[**asynchronousOperationsBulkStatusV1GetBulkDetailedStatusGet()**](AsynchronousOperationsBulkStatusV1Api.md#asynchronousOperationsBulkStatusV1GetBulkDetailedStatusGet) | **GET** /V1/bulk/{bulkUuid}/detailed-status | 
[**asynchronousOperationsBulkStatusV1GetBulkShortStatusGet()**](AsynchronousOperationsBulkStatusV1Api.md#asynchronousOperationsBulkStatusV1GetBulkShortStatusGet) | **GET** /V1/bulk/{bulkUuid}/status | 
[**asynchronousOperationsBulkStatusV1GetOperationsCountByBulkIdAndStatusGet()**](AsynchronousOperationsBulkStatusV1Api.md#asynchronousOperationsBulkStatusV1GetOperationsCountByBulkIdAndStatusGet) | **GET** /V1/bulk/{bulkUuid}/operation-status/{status} | 


## `asynchronousOperationsBulkStatusV1GetBulkDetailedStatusGet()`

```php
asynchronousOperationsBulkStatusV1GetBulkDetailedStatusGet($bulk_uuid): \Magento2\Model\AsynchronousOperationsDataDetailedBulkOperationsStatusInterface
```



Get Bulk summary data with list of operations items full data.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\AsynchronousOperationsBulkStatusV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bulk_uuid = 'bulk_uuid_example'; // string

try {
    $result = $apiInstance->asynchronousOperationsBulkStatusV1GetBulkDetailedStatusGet($bulk_uuid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AsynchronousOperationsBulkStatusV1Api->asynchronousOperationsBulkStatusV1GetBulkDetailedStatusGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bulk_uuid** | **string**|  |

### Return type

[**\Magento2\Model\AsynchronousOperationsDataDetailedBulkOperationsStatusInterface**](../Model/AsynchronousOperationsDataDetailedBulkOperationsStatusInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `asynchronousOperationsBulkStatusV1GetBulkShortStatusGet()`

```php
asynchronousOperationsBulkStatusV1GetBulkShortStatusGet($bulk_uuid): \Magento2\Model\AsynchronousOperationsDataBulkOperationsStatusInterface
```



Get Bulk summary data with list of operations items short data.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\AsynchronousOperationsBulkStatusV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bulk_uuid = 'bulk_uuid_example'; // string

try {
    $result = $apiInstance->asynchronousOperationsBulkStatusV1GetBulkShortStatusGet($bulk_uuid);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AsynchronousOperationsBulkStatusV1Api->asynchronousOperationsBulkStatusV1GetBulkShortStatusGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bulk_uuid** | **string**|  |

### Return type

[**\Magento2\Model\AsynchronousOperationsDataBulkOperationsStatusInterface**](../Model/AsynchronousOperationsDataBulkOperationsStatusInterface.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `asynchronousOperationsBulkStatusV1GetOperationsCountByBulkIdAndStatusGet()`

```php
asynchronousOperationsBulkStatusV1GetOperationsCountByBulkIdAndStatusGet($bulk_uuid, $status): int
```



Get operations count by bulk uuid and status.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Magento2\Api\AsynchronousOperationsBulkStatusV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$bulk_uuid = 'bulk_uuid_example'; // string
$status = 56; // int

try {
    $result = $apiInstance->asynchronousOperationsBulkStatusV1GetOperationsCountByBulkIdAndStatusGet($bulk_uuid, $status);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AsynchronousOperationsBulkStatusV1Api->asynchronousOperationsBulkStatusV1GetOperationsCountByBulkIdAndStatusGet: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **bulk_uuid** | **string**|  |
 **status** | **int**|  |

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `*/*`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
