# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/magento2.git"
    }
  ],
  "require": {
    "talisman/magento2": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');




$apiInstance = new Magento2\Api\AmazonPaymentAddressManagementV1Api(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$amazon_order_reference_id = 'amazon_order_reference_id_example'; // string
$amazon_payment_address_management_v1_get_billing_address_put_body = new \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest(); // \Magento2\Model\AmazonPaymentAddressManagementV1GetShippingAddressPutRequest

try {
    $result = $apiInstance->amazonPaymentAddressManagementV1GetBillingAddressPut($amazon_order_reference_id, $amazon_payment_address_management_v1_get_billing_address_put_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AmazonPaymentAddressManagementV1Api->amazonPaymentAddressManagementV1GetBillingAddressPut: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://magento2.talisman-innovations.com/rest/default*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AmazonPaymentAddressManagementV1Api* | [**amazonPaymentAddressManagementV1GetBillingAddressPut**](docs/Api/AmazonPaymentAddressManagementV1Api.md#amazonpaymentaddressmanagementv1getbillingaddressput) | **PUT** /V1/amazon-billing-address/{amazonOrderReferenceId} | 
*AmazonPaymentAddressManagementV1Api* | [**amazonPaymentAddressManagementV1GetShippingAddressPut**](docs/Api/AmazonPaymentAddressManagementV1Api.md#amazonpaymentaddressmanagementv1getshippingaddressput) | **PUT** /V1/amazon-shipping-address/{amazonOrderReferenceId} | 
*AmazonPaymentOrderInformationManagementV1Api* | [**amazonPaymentOrderInformationManagementV1RemoveOrderReferenceDelete**](docs/Api/AmazonPaymentOrderInformationManagementV1Api.md#amazonpaymentorderinformationmanagementv1removeorderreferencedelete) | **DELETE** /V1/amazon/order-ref | 
*AnalyticsLinkProviderV1Api* | [**analyticsLinkProviderV1GetGet**](docs/Api/AnalyticsLinkProviderV1Api.md#analyticslinkproviderv1getget) | **GET** /V1/analytics/link | 
*AsynchronousOperationsBulkStatusV1Api* | [**asynchronousOperationsBulkStatusV1GetBulkDetailedStatusGet**](docs/Api/AsynchronousOperationsBulkStatusV1Api.md#asynchronousoperationsbulkstatusv1getbulkdetailedstatusget) | **GET** /V1/bulk/{bulkUuid}/detailed-status | 
*AsynchronousOperationsBulkStatusV1Api* | [**asynchronousOperationsBulkStatusV1GetBulkShortStatusGet**](docs/Api/AsynchronousOperationsBulkStatusV1Api.md#asynchronousoperationsbulkstatusv1getbulkshortstatusget) | **GET** /V1/bulk/{bulkUuid}/status | 
*AsynchronousOperationsBulkStatusV1Api* | [**asynchronousOperationsBulkStatusV1GetOperationsCountByBulkIdAndStatusGet**](docs/Api/AsynchronousOperationsBulkStatusV1Api.md#asynchronousoperationsbulkstatusv1getoperationscountbybulkidandstatusget) | **GET** /V1/bulk/{bulkUuid}/operation-status/{status} | 
*AsynchronousOperationsOperationRepositoryV1Api* | [**asynchronousOperationsOperationRepositoryV1GetListGet**](docs/Api/AsynchronousOperationsOperationRepositoryV1Api.md#asynchronousoperationsoperationrepositoryv1getlistget) | **GET** /V1/bulk | 
*BackendModuleServiceV1Api* | [**backendModuleServiceV1GetModulesGet**](docs/Api/BackendModuleServiceV1Api.md#backendmoduleservicev1getmodulesget) | **GET** /V1/modules | 
*BundleProductLinkManagementV1Api* | [**bundleProductLinkManagementV1AddChildByProductSkuPost**](docs/Api/BundleProductLinkManagementV1Api.md#bundleproductlinkmanagementv1addchildbyproductskupost) | **POST** /V1/bundle-products/{sku}/links/{optionId} | 
*BundleProductLinkManagementV1Api* | [**bundleProductLinkManagementV1GetChildrenGet**](docs/Api/BundleProductLinkManagementV1Api.md#bundleproductlinkmanagementv1getchildrenget) | **GET** /V1/bundle-products/{productSku}/children | 
*BundleProductLinkManagementV1Api* | [**bundleProductLinkManagementV1RemoveChildDelete**](docs/Api/BundleProductLinkManagementV1Api.md#bundleproductlinkmanagementv1removechilddelete) | **DELETE** /V1/bundle-products/{sku}/options/{optionId}/children/{childSku} | 
*BundleProductLinkManagementV1Api* | [**bundleProductLinkManagementV1SaveChildPut**](docs/Api/BundleProductLinkManagementV1Api.md#bundleproductlinkmanagementv1savechildput) | **PUT** /V1/bundle-products/{sku}/links/{id} | 
*BundleProductOptionManagementV1Api* | [**bundleProductOptionManagementV1SavePost**](docs/Api/BundleProductOptionManagementV1Api.md#bundleproductoptionmanagementv1savepost) | **POST** /V1/bundle-products/options/add | 
*BundleProductOptionManagementV1Api* | [**bundleProductOptionManagementV1SavePut**](docs/Api/BundleProductOptionManagementV1Api.md#bundleproductoptionmanagementv1saveput) | **PUT** /V1/bundle-products/options/{optionId} | 
*BundleProductOptionRepositoryV1Api* | [**bundleProductOptionRepositoryV1DeleteByIdDelete**](docs/Api/BundleProductOptionRepositoryV1Api.md#bundleproductoptionrepositoryv1deletebyiddelete) | **DELETE** /V1/bundle-products/{sku}/options/{optionId} | 
*BundleProductOptionRepositoryV1Api* | [**bundleProductOptionRepositoryV1GetGet**](docs/Api/BundleProductOptionRepositoryV1Api.md#bundleproductoptionrepositoryv1getget) | **GET** /V1/bundle-products/{sku}/options/{optionId} | 
*BundleProductOptionRepositoryV1Api* | [**bundleProductOptionRepositoryV1GetListGet**](docs/Api/BundleProductOptionRepositoryV1Api.md#bundleproductoptionrepositoryv1getlistget) | **GET** /V1/bundle-products/{sku}/options/all | 
*BundleProductOptionTypeListV1Api* | [**bundleProductOptionTypeListV1GetItemsGet**](docs/Api/BundleProductOptionTypeListV1Api.md#bundleproductoptiontypelistv1getitemsget) | **GET** /V1/bundle-products/options/types | 
*CatalogAttributeSetManagementV1Api* | [**catalogAttributeSetManagementV1CreatePost**](docs/Api/CatalogAttributeSetManagementV1Api.md#catalogattributesetmanagementv1createpost) | **POST** /V1/products/attribute-sets | 
*CatalogAttributeSetRepositoryV1Api* | [**catalogAttributeSetRepositoryV1DeleteByIdDelete**](docs/Api/CatalogAttributeSetRepositoryV1Api.md#catalogattributesetrepositoryv1deletebyiddelete) | **DELETE** /V1/products/attribute-sets/{attributeSetId} | 
*CatalogAttributeSetRepositoryV1Api* | [**catalogAttributeSetRepositoryV1GetGet**](docs/Api/CatalogAttributeSetRepositoryV1Api.md#catalogattributesetrepositoryv1getget) | **GET** /V1/products/attribute-sets/{attributeSetId} | 
*CatalogAttributeSetRepositoryV1Api* | [**catalogAttributeSetRepositoryV1GetListGet**](docs/Api/CatalogAttributeSetRepositoryV1Api.md#catalogattributesetrepositoryv1getlistget) | **GET** /V1/products/attribute-sets/sets/list | 
*CatalogAttributeSetRepositoryV1Api* | [**catalogAttributeSetRepositoryV1SavePut**](docs/Api/CatalogAttributeSetRepositoryV1Api.md#catalogattributesetrepositoryv1saveput) | **PUT** /V1/products/attribute-sets/{attributeSetId} | 
*CatalogBasePriceStorageV1Api* | [**catalogBasePriceStorageV1GetPost**](docs/Api/CatalogBasePriceStorageV1Api.md#catalogbasepricestoragev1getpost) | **POST** /V1/products/base-prices-information | 
*CatalogBasePriceStorageV1Api* | [**catalogBasePriceStorageV1UpdatePost**](docs/Api/CatalogBasePriceStorageV1Api.md#catalogbasepricestoragev1updatepost) | **POST** /V1/products/base-prices | 
*CatalogCategoryAttributeOptionManagementV1Api* | [**catalogCategoryAttributeOptionManagementV1GetItemsGet**](docs/Api/CatalogCategoryAttributeOptionManagementV1Api.md#catalogcategoryattributeoptionmanagementv1getitemsget) | **GET** /V1/categories/attributes/{attributeCode}/options | 
*CatalogCategoryAttributeRepositoryV1Api* | [**catalogCategoryAttributeRepositoryV1GetGet**](docs/Api/CatalogCategoryAttributeRepositoryV1Api.md#catalogcategoryattributerepositoryv1getget) | **GET** /V1/categories/attributes/{attributeCode} | 
*CatalogCategoryAttributeRepositoryV1Api* | [**catalogCategoryAttributeRepositoryV1GetListGet**](docs/Api/CatalogCategoryAttributeRepositoryV1Api.md#catalogcategoryattributerepositoryv1getlistget) | **GET** /V1/categories/attributes | 
*CatalogCategoryLinkManagementV1Api* | [**catalogCategoryLinkManagementV1GetAssignedProductsGet**](docs/Api/CatalogCategoryLinkManagementV1Api.md#catalogcategorylinkmanagementv1getassignedproductsget) | **GET** /V1/categories/{categoryId}/products | 
*CatalogCategoryLinkRepositoryV1Api* | [**catalogCategoryLinkRepositoryV1DeleteByIdsDelete**](docs/Api/CatalogCategoryLinkRepositoryV1Api.md#catalogcategorylinkrepositoryv1deletebyidsdelete) | **DELETE** /V1/categories/{categoryId}/products/{sku} | 
*CatalogCategoryLinkRepositoryV1Api* | [**catalogCategoryLinkRepositoryV1SavePost**](docs/Api/CatalogCategoryLinkRepositoryV1Api.md#catalogcategorylinkrepositoryv1savepost) | **POST** /V1/categories/{categoryId}/products | 
*CatalogCategoryLinkRepositoryV1Api* | [**catalogCategoryLinkRepositoryV1SavePut**](docs/Api/CatalogCategoryLinkRepositoryV1Api.md#catalogcategorylinkrepositoryv1saveput) | **PUT** /V1/categories/{categoryId}/products | 
*CatalogCategoryListV1Api* | [**catalogCategoryListV1GetListGet**](docs/Api/CatalogCategoryListV1Api.md#catalogcategorylistv1getlistget) | **GET** /V1/categories/list | 
*CatalogCategoryManagementV1Api* | [**catalogCategoryManagementV1GetTreeGet**](docs/Api/CatalogCategoryManagementV1Api.md#catalogcategorymanagementv1gettreeget) | **GET** /V1/categories | 
*CatalogCategoryManagementV1Api* | [**catalogCategoryManagementV1MovePut**](docs/Api/CatalogCategoryManagementV1Api.md#catalogcategorymanagementv1moveput) | **PUT** /V1/categories/{categoryId}/move | 
*CatalogCategoryRepositoryV1Api* | [**catalogCategoryRepositoryV1DeleteByIdentifierDelete**](docs/Api/CatalogCategoryRepositoryV1Api.md#catalogcategoryrepositoryv1deletebyidentifierdelete) | **DELETE** /V1/categories/{categoryId} | 
*CatalogCategoryRepositoryV1Api* | [**catalogCategoryRepositoryV1GetGet**](docs/Api/CatalogCategoryRepositoryV1Api.md#catalogcategoryrepositoryv1getget) | **GET** /V1/categories/{categoryId} | 
*CatalogCategoryRepositoryV1Api* | [**catalogCategoryRepositoryV1SavePost**](docs/Api/CatalogCategoryRepositoryV1Api.md#catalogcategoryrepositoryv1savepost) | **POST** /V1/categories | 
*CatalogCategoryRepositoryV1Api* | [**catalogCategoryRepositoryV1SavePut**](docs/Api/CatalogCategoryRepositoryV1Api.md#catalogcategoryrepositoryv1saveput) | **PUT** /V1/categories/{id} | 
*CatalogCostStorageV1Api* | [**catalogCostStorageV1DeletePost**](docs/Api/CatalogCostStorageV1Api.md#catalogcoststoragev1deletepost) | **POST** /V1/products/cost-delete | 
*CatalogCostStorageV1Api* | [**catalogCostStorageV1GetPost**](docs/Api/CatalogCostStorageV1Api.md#catalogcoststoragev1getpost) | **POST** /V1/products/cost-information | 
*CatalogCostStorageV1Api* | [**catalogCostStorageV1UpdatePost**](docs/Api/CatalogCostStorageV1Api.md#catalogcoststoragev1updatepost) | **POST** /V1/products/cost | 
*CatalogInventoryStockRegistryV1Api* | [**catalogInventoryStockRegistryV1GetLowStockItemsGet**](docs/Api/CatalogInventoryStockRegistryV1Api.md#cataloginventorystockregistryv1getlowstockitemsget) | **GET** /V1/stockItems/lowStock/ | 
*CatalogInventoryStockRegistryV1Api* | [**catalogInventoryStockRegistryV1GetStockItemBySkuGet**](docs/Api/CatalogInventoryStockRegistryV1Api.md#cataloginventorystockregistryv1getstockitembyskuget) | **GET** /V1/stockItems/{productSku} | 
*CatalogInventoryStockRegistryV1Api* | [**catalogInventoryStockRegistryV1GetStockStatusBySkuGet**](docs/Api/CatalogInventoryStockRegistryV1Api.md#cataloginventorystockregistryv1getstockstatusbyskuget) | **GET** /V1/stockStatuses/{productSku} | 
*CatalogInventoryStockRegistryV1Api* | [**catalogInventoryStockRegistryV1UpdateStockItemBySkuPut**](docs/Api/CatalogInventoryStockRegistryV1Api.md#cataloginventorystockregistryv1updatestockitembyskuput) | **PUT** /V1/products/{productSku}/stockItems/{itemId} | 
*CatalogProductAttributeGroupRepositoryV1Api* | [**catalogProductAttributeGroupRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductAttributeGroupRepositoryV1Api.md#catalogproductattributegrouprepositoryv1deletebyiddelete) | **DELETE** /V1/products/attribute-sets/groups/{groupId} | 
*CatalogProductAttributeGroupRepositoryV1Api* | [**catalogProductAttributeGroupRepositoryV1GetListGet**](docs/Api/CatalogProductAttributeGroupRepositoryV1Api.md#catalogproductattributegrouprepositoryv1getlistget) | **GET** /V1/products/attribute-sets/groups/list | 
*CatalogProductAttributeGroupRepositoryV1Api* | [**catalogProductAttributeGroupRepositoryV1SavePost**](docs/Api/CatalogProductAttributeGroupRepositoryV1Api.md#catalogproductattributegrouprepositoryv1savepost) | **POST** /V1/products/attribute-sets/groups | 
*CatalogProductAttributeGroupRepositoryV1Api* | [**catalogProductAttributeGroupRepositoryV1SavePut**](docs/Api/CatalogProductAttributeGroupRepositoryV1Api.md#catalogproductattributegrouprepositoryv1saveput) | **PUT** /V1/products/attribute-sets/{attributeSetId}/groups | 
*CatalogProductAttributeManagementV1Api* | [**catalogProductAttributeManagementV1AssignPost**](docs/Api/CatalogProductAttributeManagementV1Api.md#catalogproductattributemanagementv1assignpost) | **POST** /V1/products/attribute-sets/attributes | 
*CatalogProductAttributeManagementV1Api* | [**catalogProductAttributeManagementV1GetAttributesGet**](docs/Api/CatalogProductAttributeManagementV1Api.md#catalogproductattributemanagementv1getattributesget) | **GET** /V1/products/attribute-sets/{attributeSetId}/attributes | 
*CatalogProductAttributeManagementV1Api* | [**catalogProductAttributeManagementV1UnassignDelete**](docs/Api/CatalogProductAttributeManagementV1Api.md#catalogproductattributemanagementv1unassigndelete) | **DELETE** /V1/products/attribute-sets/{attributeSetId}/attributes/{attributeCode} | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1CreatePost**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1createpost) | **POST** /V1/products/{sku}/media | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1GetGet**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1getget) | **GET** /V1/products/{sku}/media/{entryId} | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1GetListGet**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1getlistget) | **GET** /V1/products/{sku}/media | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1RemoveDelete**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1removedelete) | **DELETE** /V1/products/{sku}/media/{entryId} | 
*CatalogProductAttributeMediaGalleryManagementV1Api* | [**catalogProductAttributeMediaGalleryManagementV1UpdatePut**](docs/Api/CatalogProductAttributeMediaGalleryManagementV1Api.md#catalogproductattributemediagallerymanagementv1updateput) | **PUT** /V1/products/{sku}/media/{entryId} | 
*CatalogProductAttributeOptionManagementV1Api* | [**catalogProductAttributeOptionManagementV1AddPost**](docs/Api/CatalogProductAttributeOptionManagementV1Api.md#catalogproductattributeoptionmanagementv1addpost) | **POST** /V1/products/attributes/{attributeCode}/options | 
*CatalogProductAttributeOptionManagementV1Api* | [**catalogProductAttributeOptionManagementV1DeleteDelete**](docs/Api/CatalogProductAttributeOptionManagementV1Api.md#catalogproductattributeoptionmanagementv1deletedelete) | **DELETE** /V1/products/attributes/{attributeCode}/options/{optionId} | 
*CatalogProductAttributeOptionManagementV1Api* | [**catalogProductAttributeOptionManagementV1GetItemsGet**](docs/Api/CatalogProductAttributeOptionManagementV1Api.md#catalogproductattributeoptionmanagementv1getitemsget) | **GET** /V1/products/attributes/{attributeCode}/options | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1deletebyiddelete) | **DELETE** /V1/products/attributes/{attributeCode} | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1GetGet**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1getget) | **GET** /V1/products/attributes/{attributeCode} | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1GetListGet**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1getlistget) | **GET** /V1/products/attributes | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1SavePost**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1savepost) | **POST** /V1/products/attributes | 
*CatalogProductAttributeRepositoryV1Api* | [**catalogProductAttributeRepositoryV1SavePut**](docs/Api/CatalogProductAttributeRepositoryV1Api.md#catalogproductattributerepositoryv1saveput) | **PUT** /V1/products/attributes/{attributeCode} | 
*CatalogProductAttributeTypesListV1Api* | [**catalogProductAttributeTypesListV1GetItemsGet**](docs/Api/CatalogProductAttributeTypesListV1Api.md#catalogproductattributetypeslistv1getitemsget) | **GET** /V1/products/attributes/types | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1DeleteByIdentifierDelete**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1deletebyidentifierdelete) | **DELETE** /V1/products/{sku}/options/{optionId} | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1GetGet**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1getget) | **GET** /V1/products/{sku}/options/{optionId} | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1GetListGet**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1getlistget) | **GET** /V1/products/{sku}/options | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1SavePost**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1savepost) | **POST** /V1/products/options | 
*CatalogProductCustomOptionRepositoryV1Api* | [**catalogProductCustomOptionRepositoryV1SavePut**](docs/Api/CatalogProductCustomOptionRepositoryV1Api.md#catalogproductcustomoptionrepositoryv1saveput) | **PUT** /V1/products/options/{optionId} | 
*CatalogProductCustomOptionTypeListV1Api* | [**catalogProductCustomOptionTypeListV1GetItemsGet**](docs/Api/CatalogProductCustomOptionTypeListV1Api.md#catalogproductcustomoptiontypelistv1getitemsget) | **GET** /V1/products/options/types | 
*CatalogProductLinkManagementV1Api* | [**catalogProductLinkManagementV1GetLinkedItemsByTypeGet**](docs/Api/CatalogProductLinkManagementV1Api.md#catalogproductlinkmanagementv1getlinkeditemsbytypeget) | **GET** /V1/products/{sku}/links/{type} | 
*CatalogProductLinkManagementV1Api* | [**catalogProductLinkManagementV1SetProductLinksPost**](docs/Api/CatalogProductLinkManagementV1Api.md#catalogproductlinkmanagementv1setproductlinkspost) | **POST** /V1/products/{sku}/links | 
*CatalogProductLinkRepositoryV1Api* | [**catalogProductLinkRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductLinkRepositoryV1Api.md#catalogproductlinkrepositoryv1deletebyiddelete) | **DELETE** /V1/products/{sku}/links/{type}/{linkedProductSku} | 
*CatalogProductLinkRepositoryV1Api* | [**catalogProductLinkRepositoryV1SavePut**](docs/Api/CatalogProductLinkRepositoryV1Api.md#catalogproductlinkrepositoryv1saveput) | **PUT** /V1/products/{sku}/links | 
*CatalogProductLinkTypeListV1Api* | [**catalogProductLinkTypeListV1GetItemAttributesGet**](docs/Api/CatalogProductLinkTypeListV1Api.md#catalogproductlinktypelistv1getitemattributesget) | **GET** /V1/products/links/{type}/attributes | 
*CatalogProductLinkTypeListV1Api* | [**catalogProductLinkTypeListV1GetItemsGet**](docs/Api/CatalogProductLinkTypeListV1Api.md#catalogproductlinktypelistv1getitemsget) | **GET** /V1/products/links/types | 
*CatalogProductMediaAttributeManagementV1Api* | [**catalogProductMediaAttributeManagementV1GetListGet**](docs/Api/CatalogProductMediaAttributeManagementV1Api.md#catalogproductmediaattributemanagementv1getlistget) | **GET** /V1/products/media/types/{attributeSetName} | 
*CatalogProductRenderListV1Api* | [**catalogProductRenderListV1GetListGet**](docs/Api/CatalogProductRenderListV1Api.md#catalogproductrenderlistv1getlistget) | **GET** /V1/products-render-info | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1deletebyiddelete) | **DELETE** /V1/products/{sku} | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1GetGet**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1getget) | **GET** /V1/products/{sku} | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1GetListGet**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1getlistget) | **GET** /V1/products | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1SavePost**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1savepost) | **POST** /V1/products | 
*CatalogProductRepositoryV1Api* | [**catalogProductRepositoryV1SavePut**](docs/Api/CatalogProductRepositoryV1Api.md#catalogproductrepositoryv1saveput) | **PUT** /V1/products/{sku} | 
*CatalogProductTierPriceManagementV1Api* | [**catalogProductTierPriceManagementV1AddPost**](docs/Api/CatalogProductTierPriceManagementV1Api.md#catalogproducttierpricemanagementv1addpost) | **POST** /V1/products/{sku}/group-prices/{customerGroupId}/tiers/{qty}/price/{price} | 
*CatalogProductTierPriceManagementV1Api* | [**catalogProductTierPriceManagementV1GetListGet**](docs/Api/CatalogProductTierPriceManagementV1Api.md#catalogproducttierpricemanagementv1getlistget) | **GET** /V1/products/{sku}/group-prices/{customerGroupId}/tiers | 
*CatalogProductTierPriceManagementV1Api* | [**catalogProductTierPriceManagementV1RemoveDelete**](docs/Api/CatalogProductTierPriceManagementV1Api.md#catalogproducttierpricemanagementv1removedelete) | **DELETE** /V1/products/{sku}/group-prices/{customerGroupId}/tiers/{qty} | 
*CatalogProductTypeListV1Api* | [**catalogProductTypeListV1GetProductTypesGet**](docs/Api/CatalogProductTypeListV1Api.md#catalogproducttypelistv1getproducttypesget) | **GET** /V1/products/types | 
*CatalogProductWebsiteLinkRepositoryV1Api* | [**catalogProductWebsiteLinkRepositoryV1DeleteByIdDelete**](docs/Api/CatalogProductWebsiteLinkRepositoryV1Api.md#catalogproductwebsitelinkrepositoryv1deletebyiddelete) | **DELETE** /V1/products/{sku}/websites/{websiteId} | 
*CatalogProductWebsiteLinkRepositoryV1Api* | [**catalogProductWebsiteLinkRepositoryV1SavePost**](docs/Api/CatalogProductWebsiteLinkRepositoryV1Api.md#catalogproductwebsitelinkrepositoryv1savepost) | **POST** /V1/products/{sku}/websites | 
*CatalogProductWebsiteLinkRepositoryV1Api* | [**catalogProductWebsiteLinkRepositoryV1SavePut**](docs/Api/CatalogProductWebsiteLinkRepositoryV1Api.md#catalogproductwebsitelinkrepositoryv1saveput) | **PUT** /V1/products/{sku}/websites | 
*CatalogSpecialPriceStorageV1Api* | [**catalogSpecialPriceStorageV1DeletePost**](docs/Api/CatalogSpecialPriceStorageV1Api.md#catalogspecialpricestoragev1deletepost) | **POST** /V1/products/special-price-delete | 
*CatalogSpecialPriceStorageV1Api* | [**catalogSpecialPriceStorageV1GetPost**](docs/Api/CatalogSpecialPriceStorageV1Api.md#catalogspecialpricestoragev1getpost) | **POST** /V1/products/special-price-information | 
*CatalogSpecialPriceStorageV1Api* | [**catalogSpecialPriceStorageV1UpdatePost**](docs/Api/CatalogSpecialPriceStorageV1Api.md#catalogspecialpricestoragev1updatepost) | **POST** /V1/products/special-price | 
*CatalogTierPriceStorageV1Api* | [**catalogTierPriceStorageV1DeletePost**](docs/Api/CatalogTierPriceStorageV1Api.md#catalogtierpricestoragev1deletepost) | **POST** /V1/products/tier-prices-delete | 
*CatalogTierPriceStorageV1Api* | [**catalogTierPriceStorageV1GetPost**](docs/Api/CatalogTierPriceStorageV1Api.md#catalogtierpricestoragev1getpost) | **POST** /V1/products/tier-prices-information | 
*CatalogTierPriceStorageV1Api* | [**catalogTierPriceStorageV1ReplacePut**](docs/Api/CatalogTierPriceStorageV1Api.md#catalogtierpricestoragev1replaceput) | **PUT** /V1/products/tier-prices | 
*CatalogTierPriceStorageV1Api* | [**catalogTierPriceStorageV1UpdatePost**](docs/Api/CatalogTierPriceStorageV1Api.md#catalogtierpricestoragev1updatepost) | **POST** /V1/products/tier-prices | 
*CheckoutAgreementsCheckoutAgreementsListV1Api* | [**checkoutAgreementsCheckoutAgreementsListV1GetListGet**](docs/Api/CheckoutAgreementsCheckoutAgreementsListV1Api.md#checkoutagreementscheckoutagreementslistv1getlistget) | **GET** /V1/carts/licence/list | 
*CheckoutAgreementsCheckoutAgreementsRepositoryV1Api* | [**checkoutAgreementsCheckoutAgreementsRepositoryV1GetListGet**](docs/Api/CheckoutAgreementsCheckoutAgreementsRepositoryV1Api.md#checkoutagreementscheckoutagreementsrepositoryv1getlistget) | **GET** /V1/carts/licence | 
*CheckoutGuestPaymentInformationManagementV1Api* | [**checkoutGuestPaymentInformationManagementV1GetPaymentInformationGet**](docs/Api/CheckoutGuestPaymentInformationManagementV1Api.md#checkoutguestpaymentinformationmanagementv1getpaymentinformationget) | **GET** /V1/guest-carts/{cartId}/payment-information | 
*CheckoutGuestPaymentInformationManagementV1Api* | [**checkoutGuestPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPost**](docs/Api/CheckoutGuestPaymentInformationManagementV1Api.md#checkoutguestpaymentinformationmanagementv1savepaymentinformationandplaceorderpost) | **POST** /V1/guest-carts/{cartId}/payment-information | 
*CheckoutGuestPaymentInformationManagementV1Api* | [**checkoutGuestPaymentInformationManagementV1SavePaymentInformationPost**](docs/Api/CheckoutGuestPaymentInformationManagementV1Api.md#checkoutguestpaymentinformationmanagementv1savepaymentinformationpost) | **POST** /V1/guest-carts/{cartId}/set-payment-information | 
*CheckoutGuestShippingInformationManagementV1Api* | [**checkoutGuestShippingInformationManagementV1SaveAddressInformationPost**](docs/Api/CheckoutGuestShippingInformationManagementV1Api.md#checkoutguestshippinginformationmanagementv1saveaddressinformationpost) | **POST** /V1/guest-carts/{cartId}/shipping-information | 
*CheckoutGuestTotalsInformationManagementV1Api* | [**checkoutGuestTotalsInformationManagementV1CalculatePost**](docs/Api/CheckoutGuestTotalsInformationManagementV1Api.md#checkoutguesttotalsinformationmanagementv1calculatepost) | **POST** /V1/guest-carts/{cartId}/totals-information | 
*CheckoutPaymentInformationManagementV1Api* | [**checkoutPaymentInformationManagementV1GetPaymentInformationGet**](docs/Api/CheckoutPaymentInformationManagementV1Api.md#checkoutpaymentinformationmanagementv1getpaymentinformationget) | **GET** /V1/carts/mine/payment-information | 
*CheckoutPaymentInformationManagementV1Api* | [**checkoutPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPost**](docs/Api/CheckoutPaymentInformationManagementV1Api.md#checkoutpaymentinformationmanagementv1savepaymentinformationandplaceorderpost) | **POST** /V1/carts/mine/payment-information | 
*CheckoutPaymentInformationManagementV1Api* | [**checkoutPaymentInformationManagementV1SavePaymentInformationPost**](docs/Api/CheckoutPaymentInformationManagementV1Api.md#checkoutpaymentinformationmanagementv1savepaymentinformationpost) | **POST** /V1/carts/mine/set-payment-information | 
*CheckoutShippingInformationManagementV1Api* | [**checkoutShippingInformationManagementV1SaveAddressInformationPost**](docs/Api/CheckoutShippingInformationManagementV1Api.md#checkoutshippinginformationmanagementv1saveaddressinformationpost) | **POST** /V1/carts/mine/shipping-information | 
*CheckoutShippingInformationManagementV1Api* | [**checkoutShippingInformationManagementV1SaveAddressInformationPost_0**](docs/Api/CheckoutShippingInformationManagementV1Api.md#checkoutshippinginformationmanagementv1saveaddressinformationpost_0) | **POST** /V1/carts/{cartId}/shipping-information | 
*CheckoutTotalsInformationManagementV1Api* | [**checkoutTotalsInformationManagementV1CalculatePost**](docs/Api/CheckoutTotalsInformationManagementV1Api.md#checkouttotalsinformationmanagementv1calculatepost) | **POST** /V1/carts/{cartId}/totals-information | 
*CheckoutTotalsInformationManagementV1Api* | [**checkoutTotalsInformationManagementV1CalculatePost_0**](docs/Api/CheckoutTotalsInformationManagementV1Api.md#checkouttotalsinformationmanagementv1calculatepost_0) | **POST** /V1/carts/mine/totals-information | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1DeleteByIdDelete**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1deletebyiddelete) | **DELETE** /V1/cmsBlock/{blockId} | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1GetByIdGet**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1getbyidget) | **GET** /V1/cmsBlock/{blockId} | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1GetListGet**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1getlistget) | **GET** /V1/cmsBlock/search | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1SavePost**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1savepost) | **POST** /V1/cmsBlock | 
*CmsBlockRepositoryV1Api* | [**cmsBlockRepositoryV1SavePut**](docs/Api/CmsBlockRepositoryV1Api.md#cmsblockrepositoryv1saveput) | **PUT** /V1/cmsBlock/{id} | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1DeleteByIdDelete**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1deletebyiddelete) | **DELETE** /V1/cmsPage/{pageId} | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1GetByIdGet**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1getbyidget) | **GET** /V1/cmsPage/{pageId} | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1GetListGet**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1getlistget) | **GET** /V1/cmsPage/search | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1SavePost**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1savepost) | **POST** /V1/cmsPage | 
*CmsPageRepositoryV1Api* | [**cmsPageRepositoryV1SavePut**](docs/Api/CmsPageRepositoryV1Api.md#cmspagerepositoryv1saveput) | **PUT** /V1/cmsPage/{id} | 
*ConfigurableProductConfigurableProductManagementV1Api* | [**configurableProductConfigurableProductManagementV1GenerateVariationPut**](docs/Api/ConfigurableProductConfigurableProductManagementV1Api.md#configurableproductconfigurableproductmanagementv1generatevariationput) | **PUT** /V1/configurable-products/variation | 
*ConfigurableProductLinkManagementV1Api* | [**configurableProductLinkManagementV1AddChildPost**](docs/Api/ConfigurableProductLinkManagementV1Api.md#configurableproductlinkmanagementv1addchildpost) | **POST** /V1/configurable-products/{sku}/child | 
*ConfigurableProductLinkManagementV1Api* | [**configurableProductLinkManagementV1GetChildrenGet**](docs/Api/ConfigurableProductLinkManagementV1Api.md#configurableproductlinkmanagementv1getchildrenget) | **GET** /V1/configurable-products/{sku}/children | 
*ConfigurableProductLinkManagementV1Api* | [**configurableProductLinkManagementV1RemoveChildDelete**](docs/Api/ConfigurableProductLinkManagementV1Api.md#configurableproductlinkmanagementv1removechilddelete) | **DELETE** /V1/configurable-products/{sku}/children/{childSku} | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1DeleteByIdDelete**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1deletebyiddelete) | **DELETE** /V1/configurable-products/{sku}/options/{id} | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1GetGet**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1getget) | **GET** /V1/configurable-products/{sku}/options/{id} | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1GetListGet**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1getlistget) | **GET** /V1/configurable-products/{sku}/options/all | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1SavePost**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1savepost) | **POST** /V1/configurable-products/{sku}/options | 
*ConfigurableProductOptionRepositoryV1Api* | [**configurableProductOptionRepositoryV1SavePut**](docs/Api/ConfigurableProductOptionRepositoryV1Api.md#configurableproductoptionrepositoryv1saveput) | **PUT** /V1/configurable-products/{sku}/options/{id} | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ActivateByIdPut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1activatebyidput) | **PUT** /V1/customers/me/activate | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ActivatePut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1activateput) | **PUT** /V1/customers/{email}/activate | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ChangePasswordByIdPut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1changepasswordbyidput) | **PUT** /V1/customers/me/password | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1CreateAccountPost**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1createaccountpost) | **POST** /V1/customers | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetConfirmationStatusGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getconfirmationstatusget) | **GET** /V1/customers/{customerId}/confirm | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetDefaultBillingAddressGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getdefaultbillingaddressget) | **GET** /V1/customers/me/billingAddress | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetDefaultBillingAddressGet_0**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getdefaultbillingaddressget_0) | **GET** /V1/customers/{customerId}/billingAddress | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetDefaultShippingAddressGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getdefaultshippingaddressget) | **GET** /V1/customers/me/shippingAddress | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1GetDefaultShippingAddressGet_0**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1getdefaultshippingaddressget_0) | **GET** /V1/customers/{customerId}/shippingAddress | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1InitiatePasswordResetPut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1initiatepasswordresetput) | **PUT** /V1/customers/password | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1IsEmailAvailablePost**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1isemailavailablepost) | **POST** /V1/customers/isEmailAvailable | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1IsReadonlyGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1isreadonlyget) | **GET** /V1/customers/{customerId}/permissions/readonly | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ResendConfirmationPost**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1resendconfirmationpost) | **POST** /V1/customers/confirm | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ResetPasswordPost**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1resetpasswordpost) | **POST** /V1/customers/resetPassword | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ValidatePut**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1validateput) | **PUT** /V1/customers/validate | 
*CustomerAccountManagementV1Api* | [**customerAccountManagementV1ValidateResetPasswordLinkTokenGet**](docs/Api/CustomerAccountManagementV1Api.md#customeraccountmanagementv1validateresetpasswordlinktokenget) | **GET** /V1/customers/{customerId}/password/resetLinkToken/{resetPasswordLinkToken} | 
*CustomerAddressMetadataV1Api* | [**customerAddressMetadataV1GetAllAttributesMetadataGet**](docs/Api/CustomerAddressMetadataV1Api.md#customeraddressmetadatav1getallattributesmetadataget) | **GET** /V1/attributeMetadata/customerAddress | 
*CustomerAddressMetadataV1Api* | [**customerAddressMetadataV1GetAttributeMetadataGet**](docs/Api/CustomerAddressMetadataV1Api.md#customeraddressmetadatav1getattributemetadataget) | **GET** /V1/attributeMetadata/customerAddress/attribute/{attributeCode} | 
*CustomerAddressMetadataV1Api* | [**customerAddressMetadataV1GetAttributesGet**](docs/Api/CustomerAddressMetadataV1Api.md#customeraddressmetadatav1getattributesget) | **GET** /V1/attributeMetadata/customerAddress/form/{formCode} | 
*CustomerAddressMetadataV1Api* | [**customerAddressMetadataV1GetCustomAttributesMetadataGet**](docs/Api/CustomerAddressMetadataV1Api.md#customeraddressmetadatav1getcustomattributesmetadataget) | **GET** /V1/attributeMetadata/customerAddress/custom | 
*CustomerAddressRepositoryV1Api* | [**customerAddressRepositoryV1DeleteByIdDelete**](docs/Api/CustomerAddressRepositoryV1Api.md#customeraddressrepositoryv1deletebyiddelete) | **DELETE** /V1/addresses/{addressId} | 
*CustomerAddressRepositoryV1Api* | [**customerAddressRepositoryV1GetByIdGet**](docs/Api/CustomerAddressRepositoryV1Api.md#customeraddressrepositoryv1getbyidget) | **GET** /V1/customers/addresses/{addressId} | 
*CustomerCustomerGroupConfigV1Api* | [**customerCustomerGroupConfigV1SetDefaultCustomerGroupPut**](docs/Api/CustomerCustomerGroupConfigV1Api.md#customercustomergroupconfigv1setdefaultcustomergroupput) | **PUT** /V1/customerGroups/default/{id} | 
*CustomerCustomerMetadataV1Api* | [**customerCustomerMetadataV1GetAllAttributesMetadataGet**](docs/Api/CustomerCustomerMetadataV1Api.md#customercustomermetadatav1getallattributesmetadataget) | **GET** /V1/attributeMetadata/customer | 
*CustomerCustomerMetadataV1Api* | [**customerCustomerMetadataV1GetAttributeMetadataGet**](docs/Api/CustomerCustomerMetadataV1Api.md#customercustomermetadatav1getattributemetadataget) | **GET** /V1/attributeMetadata/customer/attribute/{attributeCode} | 
*CustomerCustomerMetadataV1Api* | [**customerCustomerMetadataV1GetAttributesGet**](docs/Api/CustomerCustomerMetadataV1Api.md#customercustomermetadatav1getattributesget) | **GET** /V1/attributeMetadata/customer/form/{formCode} | 
*CustomerCustomerMetadataV1Api* | [**customerCustomerMetadataV1GetCustomAttributesMetadataGet**](docs/Api/CustomerCustomerMetadataV1Api.md#customercustomermetadatav1getcustomattributesmetadataget) | **GET** /V1/attributeMetadata/customer/custom | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1DeleteByIdDelete**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1deletebyiddelete) | **DELETE** /V1/customers/{customerId} | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1GetByIdGet**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1getbyidget) | **GET** /V1/customers/{customerId} | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1GetByIdGet_0**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1getbyidget_0) | **GET** /V1/customers/me | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1GetListGet**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1getlistget) | **GET** /V1/customers/search | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1SavePut**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1saveput) | **PUT** /V1/customers/{customerId} | 
*CustomerCustomerRepositoryV1Api* | [**customerCustomerRepositoryV1SavePut_0**](docs/Api/CustomerCustomerRepositoryV1Api.md#customercustomerrepositoryv1saveput_0) | **PUT** /V1/customers/me | 
*CustomerGroupManagementV1Api* | [**customerGroupManagementV1GetDefaultGroupGet**](docs/Api/CustomerGroupManagementV1Api.md#customergroupmanagementv1getdefaultgroupget) | **GET** /V1/customerGroups/default/{storeId} | 
*CustomerGroupManagementV1Api* | [**customerGroupManagementV1GetDefaultGroupGet_0**](docs/Api/CustomerGroupManagementV1Api.md#customergroupmanagementv1getdefaultgroupget_0) | **GET** /V1/customerGroups/default | 
*CustomerGroupManagementV1Api* | [**customerGroupManagementV1IsReadonlyGet**](docs/Api/CustomerGroupManagementV1Api.md#customergroupmanagementv1isreadonlyget) | **GET** /V1/customerGroups/{id}/permissions | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1DeleteByIdDelete**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1deletebyiddelete) | **DELETE** /V1/customerGroups/{id} | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1GetByIdGet**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1getbyidget) | **GET** /V1/customerGroups/{id} | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1GetListGet**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1getlistget) | **GET** /V1/customerGroups/search | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1SavePost**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1savepost) | **POST** /V1/customerGroups | 
*CustomerGroupRepositoryV1Api* | [**customerGroupRepositoryV1SavePut**](docs/Api/CustomerGroupRepositoryV1Api.md#customergrouprepositoryv1saveput) | **PUT** /V1/customerGroups/{id} | 
*DirectoryCountryInformationAcquirerV1Api* | [**directoryCountryInformationAcquirerV1GetCountriesInfoGet**](docs/Api/DirectoryCountryInformationAcquirerV1Api.md#directorycountryinformationacquirerv1getcountriesinfoget) | **GET** /V1/directory/countries | 
*DirectoryCountryInformationAcquirerV1Api* | [**directoryCountryInformationAcquirerV1GetCountryInfoGet**](docs/Api/DirectoryCountryInformationAcquirerV1Api.md#directorycountryinformationacquirerv1getcountryinfoget) | **GET** /V1/directory/countries/{countryId} | 
*DirectoryCurrencyInformationAcquirerV1Api* | [**directoryCurrencyInformationAcquirerV1GetCurrencyInfoGet**](docs/Api/DirectoryCurrencyInformationAcquirerV1Api.md#directorycurrencyinformationacquirerv1getcurrencyinfoget) | **GET** /V1/directory/currency | 
*DownloadableLinkRepositoryV1Api* | [**downloadableLinkRepositoryV1DeleteDelete**](docs/Api/DownloadableLinkRepositoryV1Api.md#downloadablelinkrepositoryv1deletedelete) | **DELETE** /V1/products/downloadable-links/{id} | 
*DownloadableLinkRepositoryV1Api* | [**downloadableLinkRepositoryV1GetListGet**](docs/Api/DownloadableLinkRepositoryV1Api.md#downloadablelinkrepositoryv1getlistget) | **GET** /V1/products/{sku}/downloadable-links | 
*DownloadableLinkRepositoryV1Api* | [**downloadableLinkRepositoryV1SavePost**](docs/Api/DownloadableLinkRepositoryV1Api.md#downloadablelinkrepositoryv1savepost) | **POST** /V1/products/{sku}/downloadable-links | 
*DownloadableLinkRepositoryV1Api* | [**downloadableLinkRepositoryV1SavePut**](docs/Api/DownloadableLinkRepositoryV1Api.md#downloadablelinkrepositoryv1saveput) | **PUT** /V1/products/{sku}/downloadable-links/{id} | 
*DownloadableSampleRepositoryV1Api* | [**downloadableSampleRepositoryV1DeleteDelete**](docs/Api/DownloadableSampleRepositoryV1Api.md#downloadablesamplerepositoryv1deletedelete) | **DELETE** /V1/products/downloadable-links/samples/{id} | 
*DownloadableSampleRepositoryV1Api* | [**downloadableSampleRepositoryV1GetListGet**](docs/Api/DownloadableSampleRepositoryV1Api.md#downloadablesamplerepositoryv1getlistget) | **GET** /V1/products/{sku}/downloadable-links/samples | 
*DownloadableSampleRepositoryV1Api* | [**downloadableSampleRepositoryV1SavePost**](docs/Api/DownloadableSampleRepositoryV1Api.md#downloadablesamplerepositoryv1savepost) | **POST** /V1/products/{sku}/downloadable-links/samples | 
*DownloadableSampleRepositoryV1Api* | [**downloadableSampleRepositoryV1SavePut**](docs/Api/DownloadableSampleRepositoryV1Api.md#downloadablesamplerepositoryv1saveput) | **PUT** /V1/products/{sku}/downloadable-links/samples/{id} | 
*EavAttributeSetManagementV1Api* | [**eavAttributeSetManagementV1CreatePost**](docs/Api/EavAttributeSetManagementV1Api.md#eavattributesetmanagementv1createpost) | **POST** /V1/eav/attribute-sets | 
*EavAttributeSetRepositoryV1Api* | [**eavAttributeSetRepositoryV1DeleteByIdDelete**](docs/Api/EavAttributeSetRepositoryV1Api.md#eavattributesetrepositoryv1deletebyiddelete) | **DELETE** /V1/eav/attribute-sets/{attributeSetId} | 
*EavAttributeSetRepositoryV1Api* | [**eavAttributeSetRepositoryV1GetGet**](docs/Api/EavAttributeSetRepositoryV1Api.md#eavattributesetrepositoryv1getget) | **GET** /V1/eav/attribute-sets/{attributeSetId} | 
*EavAttributeSetRepositoryV1Api* | [**eavAttributeSetRepositoryV1GetListGet**](docs/Api/EavAttributeSetRepositoryV1Api.md#eavattributesetrepositoryv1getlistget) | **GET** /V1/eav/attribute-sets/list | 
*EavAttributeSetRepositoryV1Api* | [**eavAttributeSetRepositoryV1SavePut**](docs/Api/EavAttributeSetRepositoryV1Api.md#eavattributesetrepositoryv1saveput) | **PUT** /V1/eav/attribute-sets/{attributeSetId} | 
*GiftMessageCartRepositoryV1Api* | [**giftMessageCartRepositoryV1GetGet**](docs/Api/GiftMessageCartRepositoryV1Api.md#giftmessagecartrepositoryv1getget) | **GET** /V1/carts/{cartId}/gift-message | 
*GiftMessageCartRepositoryV1Api* | [**giftMessageCartRepositoryV1GetGet_0**](docs/Api/GiftMessageCartRepositoryV1Api.md#giftmessagecartrepositoryv1getget_0) | **GET** /V1/carts/mine/gift-message | 
*GiftMessageCartRepositoryV1Api* | [**giftMessageCartRepositoryV1SavePost**](docs/Api/GiftMessageCartRepositoryV1Api.md#giftmessagecartrepositoryv1savepost) | **POST** /V1/carts/{cartId}/gift-message | 
*GiftMessageCartRepositoryV1Api* | [**giftMessageCartRepositoryV1SavePost_0**](docs/Api/GiftMessageCartRepositoryV1Api.md#giftmessagecartrepositoryv1savepost_0) | **POST** /V1/carts/mine/gift-message | 
*GiftMessageGuestCartRepositoryV1Api* | [**giftMessageGuestCartRepositoryV1GetGet**](docs/Api/GiftMessageGuestCartRepositoryV1Api.md#giftmessageguestcartrepositoryv1getget) | **GET** /V1/guest-carts/{cartId}/gift-message | 
*GiftMessageGuestCartRepositoryV1Api* | [**giftMessageGuestCartRepositoryV1SavePost**](docs/Api/GiftMessageGuestCartRepositoryV1Api.md#giftmessageguestcartrepositoryv1savepost) | **POST** /V1/guest-carts/{cartId}/gift-message | 
*GiftMessageGuestItemRepositoryV1Api* | [**giftMessageGuestItemRepositoryV1GetGet**](docs/Api/GiftMessageGuestItemRepositoryV1Api.md#giftmessageguestitemrepositoryv1getget) | **GET** /V1/guest-carts/{cartId}/gift-message/{itemId} | 
*GiftMessageGuestItemRepositoryV1Api* | [**giftMessageGuestItemRepositoryV1SavePost**](docs/Api/GiftMessageGuestItemRepositoryV1Api.md#giftmessageguestitemrepositoryv1savepost) | **POST** /V1/guest-carts/{cartId}/gift-message/{itemId} | 
*GiftMessageItemRepositoryV1Api* | [**giftMessageItemRepositoryV1GetGet**](docs/Api/GiftMessageItemRepositoryV1Api.md#giftmessageitemrepositoryv1getget) | **GET** /V1/carts/{cartId}/gift-message/{itemId} | 
*GiftMessageItemRepositoryV1Api* | [**giftMessageItemRepositoryV1GetGet_0**](docs/Api/GiftMessageItemRepositoryV1Api.md#giftmessageitemrepositoryv1getget_0) | **GET** /V1/carts/mine/gift-message/{itemId} | 
*GiftMessageItemRepositoryV1Api* | [**giftMessageItemRepositoryV1SavePost**](docs/Api/GiftMessageItemRepositoryV1Api.md#giftmessageitemrepositoryv1savepost) | **POST** /V1/carts/{cartId}/gift-message/{itemId} | 
*GiftMessageItemRepositoryV1Api* | [**giftMessageItemRepositoryV1SavePost_0**](docs/Api/GiftMessageItemRepositoryV1Api.md#giftmessageitemrepositoryv1savepost_0) | **POST** /V1/carts/mine/gift-message/{itemId} | 
*IntegrationAdminTokenServiceV1Api* | [**integrationAdminTokenServiceV1CreateAdminAccessTokenPost**](docs/Api/IntegrationAdminTokenServiceV1Api.md#integrationadmintokenservicev1createadminaccesstokenpost) | **POST** /V1/integration/admin/token | 
*IntegrationCustomerTokenServiceV1Api* | [**integrationCustomerTokenServiceV1CreateCustomerAccessTokenPost**](docs/Api/IntegrationCustomerTokenServiceV1Api.md#integrationcustomertokenservicev1createcustomeraccesstokenpost) | **POST** /V1/integration/customer/token | 
*InventoryApiGetSourcesAssignedToStockOrderedByPriorityV1Api* | [**inventoryApiGetSourcesAssignedToStockOrderedByPriorityV1ExecuteGet**](docs/Api/InventoryApiGetSourcesAssignedToStockOrderedByPriorityV1Api.md#inventoryapigetsourcesassignedtostockorderedbypriorityv1executeget) | **GET** /V1/inventory/get-sources-assigned-to-stock-ordered-by-priority/{stockId} | 
*InventoryApiGetStockSourceLinksV1Api* | [**inventoryApiGetStockSourceLinksV1ExecuteGet**](docs/Api/InventoryApiGetStockSourceLinksV1Api.md#inventoryapigetstocksourcelinksv1executeget) | **GET** /V1/inventory/stock-source-links | 
*InventoryApiSourceItemRepositoryV1Api* | [**inventoryApiSourceItemRepositoryV1GetListGet**](docs/Api/InventoryApiSourceItemRepositoryV1Api.md#inventoryapisourceitemrepositoryv1getlistget) | **GET** /V1/inventory/source-items | 
*InventoryApiSourceItemsDeleteV1Api* | [**inventoryApiSourceItemsDeleteV1ExecutePost**](docs/Api/InventoryApiSourceItemsDeleteV1Api.md#inventoryapisourceitemsdeletev1executepost) | **POST** /V1/inventory/source-items-delete | 
*InventoryApiSourceItemsSaveV1Api* | [**inventoryApiSourceItemsSaveV1ExecutePost**](docs/Api/InventoryApiSourceItemsSaveV1Api.md#inventoryapisourceitemssavev1executepost) | **POST** /V1/inventory/source-items | 
*InventoryApiSourceRepositoryV1Api* | [**inventoryApiSourceRepositoryV1GetGet**](docs/Api/InventoryApiSourceRepositoryV1Api.md#inventoryapisourcerepositoryv1getget) | **GET** /V1/inventory/sources/{sourceCode} | 
*InventoryApiSourceRepositoryV1Api* | [**inventoryApiSourceRepositoryV1GetListGet**](docs/Api/InventoryApiSourceRepositoryV1Api.md#inventoryapisourcerepositoryv1getlistget) | **GET** /V1/inventory/sources | 
*InventoryApiSourceRepositoryV1Api* | [**inventoryApiSourceRepositoryV1SavePost**](docs/Api/InventoryApiSourceRepositoryV1Api.md#inventoryapisourcerepositoryv1savepost) | **POST** /V1/inventory/sources | 
*InventoryApiSourceRepositoryV1Api* | [**inventoryApiSourceRepositoryV1SavePut**](docs/Api/InventoryApiSourceRepositoryV1Api.md#inventoryapisourcerepositoryv1saveput) | **PUT** /V1/inventory/sources/{sourceCode} | 
*InventoryApiStockRepositoryV1Api* | [**inventoryApiStockRepositoryV1DeleteByIdDelete**](docs/Api/InventoryApiStockRepositoryV1Api.md#inventoryapistockrepositoryv1deletebyiddelete) | **DELETE** /V1/inventory/stocks/{stockId} | 
*InventoryApiStockRepositoryV1Api* | [**inventoryApiStockRepositoryV1GetGet**](docs/Api/InventoryApiStockRepositoryV1Api.md#inventoryapistockrepositoryv1getget) | **GET** /V1/inventory/stocks/{stockId} | 
*InventoryApiStockRepositoryV1Api* | [**inventoryApiStockRepositoryV1GetListGet**](docs/Api/InventoryApiStockRepositoryV1Api.md#inventoryapistockrepositoryv1getlistget) | **GET** /V1/inventory/stocks | 
*InventoryApiStockRepositoryV1Api* | [**inventoryApiStockRepositoryV1SavePost**](docs/Api/InventoryApiStockRepositoryV1Api.md#inventoryapistockrepositoryv1savepost) | **POST** /V1/inventory/stocks | 
*InventoryApiStockRepositoryV1Api* | [**inventoryApiStockRepositoryV1SavePut**](docs/Api/InventoryApiStockRepositoryV1Api.md#inventoryapistockrepositoryv1saveput) | **PUT** /V1/inventory/stocks/{stockId} | 
*InventoryApiStockSourceLinksDeleteV1Api* | [**inventoryApiStockSourceLinksDeleteV1ExecutePost**](docs/Api/InventoryApiStockSourceLinksDeleteV1Api.md#inventoryapistocksourcelinksdeletev1executepost) | **POST** /V1/inventory/stock-source-links-delete | 
*InventoryApiStockSourceLinksSaveV1Api* | [**inventoryApiStockSourceLinksSaveV1ExecutePost**](docs/Api/InventoryApiStockSourceLinksSaveV1Api.md#inventoryapistocksourcelinkssavev1executepost) | **POST** /V1/inventory/stock-source-links | 
*InventoryCatalogApiBulkInventoryTransferV1Api* | [**inventoryCatalogApiBulkInventoryTransferV1ExecutePost**](docs/Api/InventoryCatalogApiBulkInventoryTransferV1Api.md#inventorycatalogapibulkinventorytransferv1executepost) | **POST** /V1/inventory/bulk-product-source-transfer | 
*InventoryCatalogApiBulkPartialInventoryTransferV1Api* | [**inventoryCatalogApiBulkPartialInventoryTransferV1ExecutePost**](docs/Api/InventoryCatalogApiBulkPartialInventoryTransferV1Api.md#inventorycatalogapibulkpartialinventorytransferv1executepost) | **POST** /V1/inventory/bulk-partial-source-transfer | 
*InventoryCatalogApiBulkSourceAssignV1Api* | [**inventoryCatalogApiBulkSourceAssignV1ExecutePost**](docs/Api/InventoryCatalogApiBulkSourceAssignV1Api.md#inventorycatalogapibulksourceassignv1executepost) | **POST** /V1/inventory/bulk-product-source-assign | 
*InventoryCatalogApiBulkSourceUnassignV1Api* | [**inventoryCatalogApiBulkSourceUnassignV1ExecutePost**](docs/Api/InventoryCatalogApiBulkSourceUnassignV1Api.md#inventorycatalogapibulksourceunassignv1executepost) | **POST** /V1/inventory/bulk-product-source-unassign | 
*InventoryDistanceBasedSourceSelectionApiGetDistanceProviderCodeV1Api* | [**inventoryDistanceBasedSourceSelectionApiGetDistanceProviderCodeV1ExecuteGet**](docs/Api/InventoryDistanceBasedSourceSelectionApiGetDistanceProviderCodeV1Api.md#inventorydistancebasedsourceselectionapigetdistanceprovidercodev1executeget) | **GET** /V1/inventory/get-distance-provider-code | 
*InventoryDistanceBasedSourceSelectionApiGetDistanceV1Api* | [**inventoryDistanceBasedSourceSelectionApiGetDistanceV1ExecuteGet**](docs/Api/InventoryDistanceBasedSourceSelectionApiGetDistanceV1Api.md#inventorydistancebasedsourceselectionapigetdistancev1executeget) | **GET** /V1/inventory/get-distance | 
*InventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1Api* | [**inventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1ExecuteGet**](docs/Api/InventoryDistanceBasedSourceSelectionApiGetLatLngFromAddressV1Api.md#inventorydistancebasedsourceselectionapigetlatlngfromaddressv1executeget) | **GET** /V1/inventory/get-latlng-from-address | 
*InventoryExportStockApiExportStockIndexDataV1Api* | [**inventoryExportStockApiExportStockIndexDataV1ExecuteGet**](docs/Api/InventoryExportStockApiExportStockIndexDataV1Api.md#inventoryexportstockapiexportstockindexdatav1executeget) | **GET** /V1/inventory/dump-stock-index-data/{salesChannelType}/{salesChannelCode} | 
*InventoryExportStockApiExportStockSalableQtyV1Api* | [**inventoryExportStockApiExportStockSalableQtyV1ExecuteGet**](docs/Api/InventoryExportStockApiExportStockSalableQtyV1Api.md#inventoryexportstockapiexportstocksalableqtyv1executeget) | **GET** /V1/inventory/export-stock-salable-qty/{salesChannelType}/{salesChannelCode} | 
*InventoryLowQuantityNotificationApiDeleteSourceItemsConfigurationV1Api* | [**inventoryLowQuantityNotificationApiDeleteSourceItemsConfigurationV1ExecutePost**](docs/Api/InventoryLowQuantityNotificationApiDeleteSourceItemsConfigurationV1Api.md#inventorylowquantitynotificationapideletesourceitemsconfigurationv1executepost) | **POST** /V1/inventory/low-quantity-notifications-delete | 
*InventoryLowQuantityNotificationApiGetSourceItemConfigurationV1Api* | [**inventoryLowQuantityNotificationApiGetSourceItemConfigurationV1ExecuteGet**](docs/Api/InventoryLowQuantityNotificationApiGetSourceItemConfigurationV1Api.md#inventorylowquantitynotificationapigetsourceitemconfigurationv1executeget) | **GET** /V1/inventory/low-quantity-notification/{sourceCode}/{sku} | 
*InventoryLowQuantityNotificationApiSourceItemConfigurationsSaveV1Api* | [**inventoryLowQuantityNotificationApiSourceItemConfigurationsSaveV1ExecutePost**](docs/Api/InventoryLowQuantityNotificationApiSourceItemConfigurationsSaveV1Api.md#inventorylowquantitynotificationapisourceitemconfigurationssavev1executepost) | **POST** /V1/inventory/low-quantity-notification | 
*InventorySalesApiGetProductSalableQtyV1Api* | [**inventorySalesApiGetProductSalableQtyV1ExecuteGet**](docs/Api/InventorySalesApiGetProductSalableQtyV1Api.md#inventorysalesapigetproductsalableqtyv1executeget) | **GET** /V1/inventory/get-product-salable-quantity/{sku}/{stockId} | 
*InventorySalesApiIsProductSalableForRequestedQtyV1Api* | [**inventorySalesApiIsProductSalableForRequestedQtyV1ExecuteGet**](docs/Api/InventorySalesApiIsProductSalableForRequestedQtyV1Api.md#inventorysalesapiisproductsalableforrequestedqtyv1executeget) | **GET** /V1/inventory/is-product-salable-for-requested-qty/{sku}/{stockId}/{requestedQty} | 
*InventorySalesApiIsProductSalableV1Api* | [**inventorySalesApiIsProductSalableV1ExecuteGet**](docs/Api/InventorySalesApiIsProductSalableV1Api.md#inventorysalesapiisproductsalablev1executeget) | **GET** /V1/inventory/is-product-salable/{sku}/{stockId} | 
*InventorySalesApiStockResolverV1Api* | [**inventorySalesApiStockResolverV1ExecuteGet**](docs/Api/InventorySalesApiStockResolverV1Api.md#inventorysalesapistockresolverv1executeget) | **GET** /V1/inventory/stock-resolver/{type}/{code} | 
*InventorySourceSelectionApiGetSourceSelectionAlgorithmListV1Api* | [**inventorySourceSelectionApiGetSourceSelectionAlgorithmListV1ExecuteGet**](docs/Api/InventorySourceSelectionApiGetSourceSelectionAlgorithmListV1Api.md#inventorysourceselectionapigetsourceselectionalgorithmlistv1executeget) | **GET** /V1/inventory/source-selection-algorithm-list | 
*InventorySourceSelectionApiSourceSelectionServiceV1Api* | [**inventorySourceSelectionApiSourceSelectionServiceV1ExecutePost**](docs/Api/InventorySourceSelectionApiSourceSelectionServiceV1Api.md#inventorysourceselectionapisourceselectionservicev1executepost) | **POST** /V1/inventory/source-selection-algorithm-result | 
*MSPTwoFactorAuthTfaV1Api* | [**mSPTwoFactorAuthTfaV1GetAllProvidersGet**](docs/Api/MSPTwoFactorAuthTfaV1Api.md#msptwofactorauthtfav1getallprovidersget) | **GET** /V1/msp-2fa/installed-providers | 
*MSPTwoFactorAuthTfaV1Api* | [**mSPTwoFactorAuthTfaV1GetForcedProvidersGet**](docs/Api/MSPTwoFactorAuthTfaV1Api.md#msptwofactorauthtfav1getforcedprovidersget) | **GET** /V1/msp-2fa/forced-providers | 
*MSPTwoFactorAuthTfaV1Api* | [**mSPTwoFactorAuthTfaV1GetProvidersToActivateGet**](docs/Api/MSPTwoFactorAuthTfaV1Api.md#msptwofactorauthtfav1getproviderstoactivateget) | **GET** /V1/msp-2fa/providers-to-activate/{userId} | 
*MSPTwoFactorAuthTfaV1Api* | [**mSPTwoFactorAuthTfaV1GetTrustedDevicesGet**](docs/Api/MSPTwoFactorAuthTfaV1Api.md#msptwofactorauthtfav1gettrusteddevicesget) | **GET** /V1/msp-2fa/trusted-devices/{userId} | 
*MSPTwoFactorAuthTfaV1Api* | [**mSPTwoFactorAuthTfaV1GetUserProvidersGet**](docs/Api/MSPTwoFactorAuthTfaV1Api.md#msptwofactorauthtfav1getuserprovidersget) | **GET** /V1/msp-2fa/user-providers/{userId} | 
*MSPTwoFactorAuthTfaV1Api* | [**mSPTwoFactorAuthTfaV1ResetProviderConfigPost**](docs/Api/MSPTwoFactorAuthTfaV1Api.md#msptwofactorauthtfav1resetproviderconfigpost) | **POST** /V1/msp-2fa/reset-provider/{userId}/{providerCode} | 
*MSPTwoFactorAuthTfaV1Api* | [**mSPTwoFactorAuthTfaV1SetDefaultProviderCodePut**](docs/Api/MSPTwoFactorAuthTfaV1Api.md#msptwofactorauthtfav1setdefaultprovidercodeput) | **PUT** /V1/msp-2fa/default-provider-code/{userId} | 
*MSPTwoFactorAuthTfaV1Api* | [**mSPTwoFactorAuthTfaV1SetProvidersCodesPut**](docs/Api/MSPTwoFactorAuthTfaV1Api.md#msptwofactorauthtfav1setproviderscodesput) | **PUT** /V1/msp-2fa/user-providers/{userId} | 
*MSPTwoFactorAuthTrustedManagerV1Api* | [**mSPTwoFactorAuthTrustedManagerV1RevokeTrustedDeviceDelete**](docs/Api/MSPTwoFactorAuthTrustedManagerV1Api.md#msptwofactorauthtrustedmanagerv1revoketrusteddevicedelete) | **DELETE** /V1/msp-2fa/trusted-devices/{tokenId} | 
*MSPTwoFactorAuthUserConfigManagerV1Api* | [**mSPTwoFactorAuthUserConfigManagerV1GetDefaultProviderGet**](docs/Api/MSPTwoFactorAuthUserConfigManagerV1Api.md#msptwofactorauthuserconfigmanagerv1getdefaultproviderget) | **GET** /V1/msp-2fa/default-provider-code/{userId} | 
*QuoteBillingAddressManagementV1Api* | [**quoteBillingAddressManagementV1AssignPost**](docs/Api/QuoteBillingAddressManagementV1Api.md#quotebillingaddressmanagementv1assignpost) | **POST** /V1/carts/{cartId}/billing-address | 
*QuoteBillingAddressManagementV1Api* | [**quoteBillingAddressManagementV1AssignPost_0**](docs/Api/QuoteBillingAddressManagementV1Api.md#quotebillingaddressmanagementv1assignpost_0) | **POST** /V1/carts/mine/billing-address | 
*QuoteBillingAddressManagementV1Api* | [**quoteBillingAddressManagementV1GetGet**](docs/Api/QuoteBillingAddressManagementV1Api.md#quotebillingaddressmanagementv1getget) | **GET** /V1/carts/{cartId}/billing-address | 
*QuoteBillingAddressManagementV1Api* | [**quoteBillingAddressManagementV1GetGet_0**](docs/Api/QuoteBillingAddressManagementV1Api.md#quotebillingaddressmanagementv1getget_0) | **GET** /V1/carts/mine/billing-address | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1DeleteByIdDelete**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1deletebyiddelete) | **DELETE** /V1/carts/{cartId}/items/{itemId} | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1DeleteByIdDelete_0**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1deletebyiddelete_0) | **DELETE** /V1/carts/mine/items/{itemId} | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1GetListGet**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1getlistget) | **GET** /V1/carts/{cartId}/items | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1GetListGet_0**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1getlistget_0) | **GET** /V1/carts/mine/items | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1SavePost**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1savepost) | **POST** /V1/carts/{quoteId}/items | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1SavePost_0**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1savepost_0) | **POST** /V1/carts/mine/items | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1SavePut**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1saveput) | **PUT** /V1/carts/{cartId}/items/{itemId} | 
*QuoteCartItemRepositoryV1Api* | [**quoteCartItemRepositoryV1SavePut_0**](docs/Api/QuoteCartItemRepositoryV1Api.md#quotecartitemrepositoryv1saveput_0) | **PUT** /V1/carts/mine/items/{itemId} | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1AssignCustomerPut**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1assigncustomerput) | **PUT** /V1/carts/{cartId} | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1CreateEmptyCartForCustomerPost**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1createemptycartforcustomerpost) | **POST** /V1/carts/mine | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1CreateEmptyCartForCustomerPost_0**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1createemptycartforcustomerpost_0) | **POST** /V1/customers/{customerId}/carts | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1CreateEmptyCartPost**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1createemptycartpost) | **POST** /V1/carts/ | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1GetCartForCustomerGet**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1getcartforcustomerget) | **GET** /V1/carts/mine | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1PlaceOrderPut**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1placeorderput) | **PUT** /V1/carts/mine/order | 
*QuoteCartManagementV1Api* | [**quoteCartManagementV1PlaceOrderPut_0**](docs/Api/QuoteCartManagementV1Api.md#quotecartmanagementv1placeorderput_0) | **PUT** /V1/carts/{cartId}/order | 
*QuoteCartRepositoryV1Api* | [**quoteCartRepositoryV1GetGet**](docs/Api/QuoteCartRepositoryV1Api.md#quotecartrepositoryv1getget) | **GET** /V1/carts/{cartId} | 
*QuoteCartRepositoryV1Api* | [**quoteCartRepositoryV1GetListGet**](docs/Api/QuoteCartRepositoryV1Api.md#quotecartrepositoryv1getlistget) | **GET** /V1/carts/search | 
*QuoteCartRepositoryV1Api* | [**quoteCartRepositoryV1SavePut**](docs/Api/QuoteCartRepositoryV1Api.md#quotecartrepositoryv1saveput) | **PUT** /V1/carts/mine | 
*QuoteCartTotalManagementV1Api* | [**quoteCartTotalManagementV1CollectTotalsPut**](docs/Api/QuoteCartTotalManagementV1Api.md#quotecarttotalmanagementv1collecttotalsput) | **PUT** /V1/carts/mine/collect-totals | 
*QuoteCartTotalRepositoryV1Api* | [**quoteCartTotalRepositoryV1GetGet**](docs/Api/QuoteCartTotalRepositoryV1Api.md#quotecarttotalrepositoryv1getget) | **GET** /V1/carts/{cartId}/totals | 
*QuoteCartTotalRepositoryV1Api* | [**quoteCartTotalRepositoryV1GetGet_0**](docs/Api/QuoteCartTotalRepositoryV1Api.md#quotecarttotalrepositoryv1getget_0) | **GET** /V1/carts/mine/totals | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1GetGet**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1getget) | **GET** /V1/carts/{cartId}/coupons | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1GetGet_0**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1getget_0) | **GET** /V1/carts/mine/coupons | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1RemoveDelete**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1removedelete) | **DELETE** /V1/carts/{cartId}/coupons | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1RemoveDelete_0**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1removedelete_0) | **DELETE** /V1/carts/mine/coupons | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1SetPut**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1setput) | **PUT** /V1/carts/{cartId}/coupons/{couponCode} | 
*QuoteCouponManagementV1Api* | [**quoteCouponManagementV1SetPut_0**](docs/Api/QuoteCouponManagementV1Api.md#quotecouponmanagementv1setput_0) | **PUT** /V1/carts/mine/coupons/{couponCode} | 
*QuoteGuestBillingAddressManagementV1Api* | [**quoteGuestBillingAddressManagementV1AssignPost**](docs/Api/QuoteGuestBillingAddressManagementV1Api.md#quoteguestbillingaddressmanagementv1assignpost) | **POST** /V1/guest-carts/{cartId}/billing-address | 
*QuoteGuestBillingAddressManagementV1Api* | [**quoteGuestBillingAddressManagementV1GetGet**](docs/Api/QuoteGuestBillingAddressManagementV1Api.md#quoteguestbillingaddressmanagementv1getget) | **GET** /V1/guest-carts/{cartId}/billing-address | 
*QuoteGuestCartItemRepositoryV1Api* | [**quoteGuestCartItemRepositoryV1DeleteByIdDelete**](docs/Api/QuoteGuestCartItemRepositoryV1Api.md#quoteguestcartitemrepositoryv1deletebyiddelete) | **DELETE** /V1/guest-carts/{cartId}/items/{itemId} | 
*QuoteGuestCartItemRepositoryV1Api* | [**quoteGuestCartItemRepositoryV1GetListGet**](docs/Api/QuoteGuestCartItemRepositoryV1Api.md#quoteguestcartitemrepositoryv1getlistget) | **GET** /V1/guest-carts/{cartId}/items | 
*QuoteGuestCartItemRepositoryV1Api* | [**quoteGuestCartItemRepositoryV1SavePost**](docs/Api/QuoteGuestCartItemRepositoryV1Api.md#quoteguestcartitemrepositoryv1savepost) | **POST** /V1/guest-carts/{cartId}/items | 
*QuoteGuestCartItemRepositoryV1Api* | [**quoteGuestCartItemRepositoryV1SavePut**](docs/Api/QuoteGuestCartItemRepositoryV1Api.md#quoteguestcartitemrepositoryv1saveput) | **PUT** /V1/guest-carts/{cartId}/items/{itemId} | 
*QuoteGuestCartManagementV1Api* | [**quoteGuestCartManagementV1AssignCustomerPut**](docs/Api/QuoteGuestCartManagementV1Api.md#quoteguestcartmanagementv1assigncustomerput) | **PUT** /V1/guest-carts/{cartId} | 
*QuoteGuestCartManagementV1Api* | [**quoteGuestCartManagementV1CreateEmptyCartPost**](docs/Api/QuoteGuestCartManagementV1Api.md#quoteguestcartmanagementv1createemptycartpost) | **POST** /V1/guest-carts | 
*QuoteGuestCartManagementV1Api* | [**quoteGuestCartManagementV1PlaceOrderPut**](docs/Api/QuoteGuestCartManagementV1Api.md#quoteguestcartmanagementv1placeorderput) | **PUT** /V1/guest-carts/{cartId}/order | 
*QuoteGuestCartRepositoryV1Api* | [**quoteGuestCartRepositoryV1GetGet**](docs/Api/QuoteGuestCartRepositoryV1Api.md#quoteguestcartrepositoryv1getget) | **GET** /V1/guest-carts/{cartId} | 
*QuoteGuestCartTotalManagementV1Api* | [**quoteGuestCartTotalManagementV1CollectTotalsPut**](docs/Api/QuoteGuestCartTotalManagementV1Api.md#quoteguestcarttotalmanagementv1collecttotalsput) | **PUT** /V1/guest-carts/{cartId}/collect-totals | 
*QuoteGuestCartTotalRepositoryV1Api* | [**quoteGuestCartTotalRepositoryV1GetGet**](docs/Api/QuoteGuestCartTotalRepositoryV1Api.md#quoteguestcarttotalrepositoryv1getget) | **GET** /V1/guest-carts/{cartId}/totals | 
*QuoteGuestCouponManagementV1Api* | [**quoteGuestCouponManagementV1GetGet**](docs/Api/QuoteGuestCouponManagementV1Api.md#quoteguestcouponmanagementv1getget) | **GET** /V1/guest-carts/{cartId}/coupons | 
*QuoteGuestCouponManagementV1Api* | [**quoteGuestCouponManagementV1RemoveDelete**](docs/Api/QuoteGuestCouponManagementV1Api.md#quoteguestcouponmanagementv1removedelete) | **DELETE** /V1/guest-carts/{cartId}/coupons | 
*QuoteGuestCouponManagementV1Api* | [**quoteGuestCouponManagementV1SetPut**](docs/Api/QuoteGuestCouponManagementV1Api.md#quoteguestcouponmanagementv1setput) | **PUT** /V1/guest-carts/{cartId}/coupons/{couponCode} | 
*QuoteGuestPaymentMethodManagementV1Api* | [**quoteGuestPaymentMethodManagementV1GetGet**](docs/Api/QuoteGuestPaymentMethodManagementV1Api.md#quoteguestpaymentmethodmanagementv1getget) | **GET** /V1/guest-carts/{cartId}/selected-payment-method | 
*QuoteGuestPaymentMethodManagementV1Api* | [**quoteGuestPaymentMethodManagementV1GetListGet**](docs/Api/QuoteGuestPaymentMethodManagementV1Api.md#quoteguestpaymentmethodmanagementv1getlistget) | **GET** /V1/guest-carts/{cartId}/payment-methods | 
*QuoteGuestPaymentMethodManagementV1Api* | [**quoteGuestPaymentMethodManagementV1SetPut**](docs/Api/QuoteGuestPaymentMethodManagementV1Api.md#quoteguestpaymentmethodmanagementv1setput) | **PUT** /V1/guest-carts/{cartId}/selected-payment-method | 
*QuoteGuestShipmentEstimationV1Api* | [**quoteGuestShipmentEstimationV1EstimateByExtendedAddressPost**](docs/Api/QuoteGuestShipmentEstimationV1Api.md#quoteguestshipmentestimationv1estimatebyextendedaddresspost) | **POST** /V1/guest-carts/{cartId}/estimate-shipping-methods | 
*QuoteGuestShippingMethodManagementV1Api* | [**quoteGuestShippingMethodManagementV1GetListGet**](docs/Api/QuoteGuestShippingMethodManagementV1Api.md#quoteguestshippingmethodmanagementv1getlistget) | **GET** /V1/guest-carts/{cartId}/shipping-methods | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1GetGet**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1getget) | **GET** /V1/carts/{cartId}/selected-payment-method | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1GetGet_0**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1getget_0) | **GET** /V1/carts/mine/selected-payment-method | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1GetListGet**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1getlistget) | **GET** /V1/carts/{cartId}/payment-methods | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1GetListGet_0**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1getlistget_0) | **GET** /V1/carts/mine/payment-methods | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1SetPut**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1setput) | **PUT** /V1/carts/{cartId}/selected-payment-method | 
*QuotePaymentMethodManagementV1Api* | [**quotePaymentMethodManagementV1SetPut_0**](docs/Api/QuotePaymentMethodManagementV1Api.md#quotepaymentmethodmanagementv1setput_0) | **PUT** /V1/carts/mine/selected-payment-method | 
*QuoteShipmentEstimationV1Api* | [**quoteShipmentEstimationV1EstimateByExtendedAddressPost**](docs/Api/QuoteShipmentEstimationV1Api.md#quoteshipmentestimationv1estimatebyextendedaddresspost) | **POST** /V1/carts/{cartId}/estimate-shipping-methods | 
*QuoteShipmentEstimationV1Api* | [**quoteShipmentEstimationV1EstimateByExtendedAddressPost_0**](docs/Api/QuoteShipmentEstimationV1Api.md#quoteshipmentestimationv1estimatebyextendedaddresspost_0) | **POST** /V1/carts/mine/estimate-shipping-methods | 
*QuoteShippingMethodManagementV1Api* | [**quoteShippingMethodManagementV1EstimateByAddressIdPost**](docs/Api/QuoteShippingMethodManagementV1Api.md#quoteshippingmethodmanagementv1estimatebyaddressidpost) | **POST** /V1/carts/{cartId}/estimate-shipping-methods-by-address-id | 
*QuoteShippingMethodManagementV1Api* | [**quoteShippingMethodManagementV1EstimateByAddressIdPost_0**](docs/Api/QuoteShippingMethodManagementV1Api.md#quoteshippingmethodmanagementv1estimatebyaddressidpost_0) | **POST** /V1/carts/mine/estimate-shipping-methods-by-address-id | 
*QuoteShippingMethodManagementV1Api* | [**quoteShippingMethodManagementV1GetListGet**](docs/Api/QuoteShippingMethodManagementV1Api.md#quoteshippingmethodmanagementv1getlistget) | **GET** /V1/carts/{cartId}/shipping-methods | 
*QuoteShippingMethodManagementV1Api* | [**quoteShippingMethodManagementV1GetListGet_0**](docs/Api/QuoteShippingMethodManagementV1Api.md#quoteshippingmethodmanagementv1getlistget_0) | **GET** /V1/carts/mine/shipping-methods | 
*SalesCreditmemoCommentRepositoryV1Api* | [**salesCreditmemoCommentRepositoryV1SavePost**](docs/Api/SalesCreditmemoCommentRepositoryV1Api.md#salescreditmemocommentrepositoryv1savepost) | **POST** /V1/creditmemo/{id}/comments | 
*SalesCreditmemoManagementV1Api* | [**salesCreditmemoManagementV1CancelPut**](docs/Api/SalesCreditmemoManagementV1Api.md#salescreditmemomanagementv1cancelput) | **PUT** /V1/creditmemo/{id} | 
*SalesCreditmemoManagementV1Api* | [**salesCreditmemoManagementV1GetCommentsListGet**](docs/Api/SalesCreditmemoManagementV1Api.md#salescreditmemomanagementv1getcommentslistget) | **GET** /V1/creditmemo/{id}/comments | 
*SalesCreditmemoManagementV1Api* | [**salesCreditmemoManagementV1NotifyPost**](docs/Api/SalesCreditmemoManagementV1Api.md#salescreditmemomanagementv1notifypost) | **POST** /V1/creditmemo/{id}/emails | 
*SalesCreditmemoManagementV1Api* | [**salesCreditmemoManagementV1RefundPost**](docs/Api/SalesCreditmemoManagementV1Api.md#salescreditmemomanagementv1refundpost) | **POST** /V1/creditmemo/refund | 
*SalesCreditmemoRepositoryV1Api* | [**salesCreditmemoRepositoryV1GetGet**](docs/Api/SalesCreditmemoRepositoryV1Api.md#salescreditmemorepositoryv1getget) | **GET** /V1/creditmemo/{id} | 
*SalesCreditmemoRepositoryV1Api* | [**salesCreditmemoRepositoryV1GetListGet**](docs/Api/SalesCreditmemoRepositoryV1Api.md#salescreditmemorepositoryv1getlistget) | **GET** /V1/creditmemos | 
*SalesCreditmemoRepositoryV1Api* | [**salesCreditmemoRepositoryV1SavePost**](docs/Api/SalesCreditmemoRepositoryV1Api.md#salescreditmemorepositoryv1savepost) | **POST** /V1/creditmemo | 
*SalesInvoiceCommentRepositoryV1Api* | [**salesInvoiceCommentRepositoryV1SavePost**](docs/Api/SalesInvoiceCommentRepositoryV1Api.md#salesinvoicecommentrepositoryv1savepost) | **POST** /V1/invoices/comments | 
*SalesInvoiceManagementV1Api* | [**salesInvoiceManagementV1GetCommentsListGet**](docs/Api/SalesInvoiceManagementV1Api.md#salesinvoicemanagementv1getcommentslistget) | **GET** /V1/invoices/{id}/comments | 
*SalesInvoiceManagementV1Api* | [**salesInvoiceManagementV1NotifyPost**](docs/Api/SalesInvoiceManagementV1Api.md#salesinvoicemanagementv1notifypost) | **POST** /V1/invoices/{id}/emails | 
*SalesInvoiceManagementV1Api* | [**salesInvoiceManagementV1SetCapturePost**](docs/Api/SalesInvoiceManagementV1Api.md#salesinvoicemanagementv1setcapturepost) | **POST** /V1/invoices/{id}/capture | 
*SalesInvoiceManagementV1Api* | [**salesInvoiceManagementV1SetVoidPost**](docs/Api/SalesInvoiceManagementV1Api.md#salesinvoicemanagementv1setvoidpost) | **POST** /V1/invoices/{id}/void | 
*SalesInvoiceOrderV1Api* | [**salesInvoiceOrderV1ExecutePost**](docs/Api/SalesInvoiceOrderV1Api.md#salesinvoiceorderv1executepost) | **POST** /V1/order/{orderId}/invoice | 
*SalesInvoiceRepositoryV1Api* | [**salesInvoiceRepositoryV1GetGet**](docs/Api/SalesInvoiceRepositoryV1Api.md#salesinvoicerepositoryv1getget) | **GET** /V1/invoices/{id} | 
*SalesInvoiceRepositoryV1Api* | [**salesInvoiceRepositoryV1GetListGet**](docs/Api/SalesInvoiceRepositoryV1Api.md#salesinvoicerepositoryv1getlistget) | **GET** /V1/invoices | 
*SalesInvoiceRepositoryV1Api* | [**salesInvoiceRepositoryV1SavePost**](docs/Api/SalesInvoiceRepositoryV1Api.md#salesinvoicerepositoryv1savepost) | **POST** /V1/invoices/ | 
*SalesOrderAddressRepositoryV1Api* | [**salesOrderAddressRepositoryV1SavePut**](docs/Api/SalesOrderAddressRepositoryV1Api.md#salesorderaddressrepositoryv1saveput) | **PUT** /V1/orders/{parent_id} | 
*SalesOrderItemRepositoryV1Api* | [**salesOrderItemRepositoryV1GetGet**](docs/Api/SalesOrderItemRepositoryV1Api.md#salesorderitemrepositoryv1getget) | **GET** /V1/orders/items/{id} | 
*SalesOrderItemRepositoryV1Api* | [**salesOrderItemRepositoryV1GetListGet**](docs/Api/SalesOrderItemRepositoryV1Api.md#salesorderitemrepositoryv1getlistget) | **GET** /V1/orders/items | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1AddCommentPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1addcommentpost) | **POST** /V1/orders/{id}/comments | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1CancelPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1cancelpost) | **POST** /V1/orders/{id}/cancel | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1GetCommentsListGet**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1getcommentslistget) | **GET** /V1/orders/{id}/comments | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1GetStatusGet**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1getstatusget) | **GET** /V1/orders/{id}/statuses | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1HoldPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1holdpost) | **POST** /V1/orders/{id}/hold | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1NotifyPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1notifypost) | **POST** /V1/orders/{id}/emails | 
*SalesOrderManagementV1Api* | [**salesOrderManagementV1UnHoldPost**](docs/Api/SalesOrderManagementV1Api.md#salesordermanagementv1unholdpost) | **POST** /V1/orders/{id}/unhold | 
*SalesOrderRepositoryV1Api* | [**salesOrderRepositoryV1GetGet**](docs/Api/SalesOrderRepositoryV1Api.md#salesorderrepositoryv1getget) | **GET** /V1/orders/{id} | 
*SalesOrderRepositoryV1Api* | [**salesOrderRepositoryV1GetListGet**](docs/Api/SalesOrderRepositoryV1Api.md#salesorderrepositoryv1getlistget) | **GET** /V1/orders | 
*SalesOrderRepositoryV1Api* | [**salesOrderRepositoryV1SavePost**](docs/Api/SalesOrderRepositoryV1Api.md#salesorderrepositoryv1savepost) | **POST** /V1/orders/ | 
*SalesOrderRepositoryV1Api* | [**salesOrderRepositoryV1SavePut**](docs/Api/SalesOrderRepositoryV1Api.md#salesorderrepositoryv1saveput) | **PUT** /V1/orders/create | 
*SalesRefundInvoiceV1Api* | [**salesRefundInvoiceV1ExecutePost**](docs/Api/SalesRefundInvoiceV1Api.md#salesrefundinvoicev1executepost) | **POST** /V1/invoice/{invoiceId}/refund | 
*SalesRefundOrderV1Api* | [**salesRefundOrderV1ExecutePost**](docs/Api/SalesRefundOrderV1Api.md#salesrefundorderv1executepost) | **POST** /V1/order/{orderId}/refund | 
*SalesRuleCouponManagementV1Api* | [**salesRuleCouponManagementV1DeleteByCodesPost**](docs/Api/SalesRuleCouponManagementV1Api.md#salesrulecouponmanagementv1deletebycodespost) | **POST** /V1/coupons/deleteByCodes | 
*SalesRuleCouponManagementV1Api* | [**salesRuleCouponManagementV1DeleteByIdsPost**](docs/Api/SalesRuleCouponManagementV1Api.md#salesrulecouponmanagementv1deletebyidspost) | **POST** /V1/coupons/deleteByIds | 
*SalesRuleCouponManagementV1Api* | [**salesRuleCouponManagementV1GeneratePost**](docs/Api/SalesRuleCouponManagementV1Api.md#salesrulecouponmanagementv1generatepost) | **POST** /V1/coupons/generate | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1DeleteByIdDelete**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1deletebyiddelete) | **DELETE** /V1/coupons/{couponId} | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1GetByIdGet**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1getbyidget) | **GET** /V1/coupons/{couponId} | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1GetListGet**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1getlistget) | **GET** /V1/coupons/search | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1SavePost**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1savepost) | **POST** /V1/coupons | 
*SalesRuleCouponRepositoryV1Api* | [**salesRuleCouponRepositoryV1SavePut**](docs/Api/SalesRuleCouponRepositoryV1Api.md#salesrulecouponrepositoryv1saveput) | **PUT** /V1/coupons/{couponId} | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1DeleteByIdDelete**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1deletebyiddelete) | **DELETE** /V1/salesRules/{ruleId} | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1GetByIdGet**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1getbyidget) | **GET** /V1/salesRules/{ruleId} | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1GetListGet**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1getlistget) | **GET** /V1/salesRules/search | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1SavePost**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1savepost) | **POST** /V1/salesRules | 
*SalesRuleRuleRepositoryV1Api* | [**salesRuleRuleRepositoryV1SavePut**](docs/Api/SalesRuleRuleRepositoryV1Api.md#salesrulerulerepositoryv1saveput) | **PUT** /V1/salesRules/{ruleId} | 
*SalesShipOrderV1Api* | [**salesShipOrderV1ExecutePost**](docs/Api/SalesShipOrderV1Api.md#salesshiporderv1executepost) | **POST** /V1/order/{orderId}/ship | 
*SalesShipmentCommentRepositoryV1Api* | [**salesShipmentCommentRepositoryV1SavePost**](docs/Api/SalesShipmentCommentRepositoryV1Api.md#salesshipmentcommentrepositoryv1savepost) | **POST** /V1/shipment/{id}/comments | 
*SalesShipmentManagementV1Api* | [**salesShipmentManagementV1GetCommentsListGet**](docs/Api/SalesShipmentManagementV1Api.md#salesshipmentmanagementv1getcommentslistget) | **GET** /V1/shipment/{id}/comments | 
*SalesShipmentManagementV1Api* | [**salesShipmentManagementV1GetLabelGet**](docs/Api/SalesShipmentManagementV1Api.md#salesshipmentmanagementv1getlabelget) | **GET** /V1/shipment/{id}/label | 
*SalesShipmentManagementV1Api* | [**salesShipmentManagementV1NotifyPost**](docs/Api/SalesShipmentManagementV1Api.md#salesshipmentmanagementv1notifypost) | **POST** /V1/shipment/{id}/emails | 
*SalesShipmentRepositoryV1Api* | [**salesShipmentRepositoryV1GetGet**](docs/Api/SalesShipmentRepositoryV1Api.md#salesshipmentrepositoryv1getget) | **GET** /V1/shipment/{id} | 
*SalesShipmentRepositoryV1Api* | [**salesShipmentRepositoryV1GetListGet**](docs/Api/SalesShipmentRepositoryV1Api.md#salesshipmentrepositoryv1getlistget) | **GET** /V1/shipments | 
*SalesShipmentRepositoryV1Api* | [**salesShipmentRepositoryV1SavePost**](docs/Api/SalesShipmentRepositoryV1Api.md#salesshipmentrepositoryv1savepost) | **POST** /V1/shipment/ | 
*SalesShipmentTrackRepositoryV1Api* | [**salesShipmentTrackRepositoryV1DeleteByIdDelete**](docs/Api/SalesShipmentTrackRepositoryV1Api.md#salesshipmenttrackrepositoryv1deletebyiddelete) | **DELETE** /V1/shipment/track/{id} | 
*SalesShipmentTrackRepositoryV1Api* | [**salesShipmentTrackRepositoryV1SavePost**](docs/Api/SalesShipmentTrackRepositoryV1Api.md#salesshipmenttrackrepositoryv1savepost) | **POST** /V1/shipment/track | 
*SalesTransactionRepositoryV1Api* | [**salesTransactionRepositoryV1GetGet**](docs/Api/SalesTransactionRepositoryV1Api.md#salestransactionrepositoryv1getget) | **GET** /V1/transactions/{id} | 
*SalesTransactionRepositoryV1Api* | [**salesTransactionRepositoryV1GetListGet**](docs/Api/SalesTransactionRepositoryV1Api.md#salestransactionrepositoryv1getlistget) | **GET** /V1/transactions | 
*SearchV1Api* | [**searchV1SearchGet**](docs/Api/SearchV1Api.md#searchv1searchget) | **GET** /V1/search | 
*StoreGroupRepositoryV1Api* | [**storeGroupRepositoryV1GetListGet**](docs/Api/StoreGroupRepositoryV1Api.md#storegrouprepositoryv1getlistget) | **GET** /V1/store/storeGroups | 
*StoreStoreConfigManagerV1Api* | [**storeStoreConfigManagerV1GetStoreConfigsGet**](docs/Api/StoreStoreConfigManagerV1Api.md#storestoreconfigmanagerv1getstoreconfigsget) | **GET** /V1/store/storeConfigs | 
*StoreStoreRepositoryV1Api* | [**storeStoreRepositoryV1GetListGet**](docs/Api/StoreStoreRepositoryV1Api.md#storestorerepositoryv1getlistget) | **GET** /V1/store/storeViews | 
*StoreWebsiteRepositoryV1Api* | [**storeWebsiteRepositoryV1GetListGet**](docs/Api/StoreWebsiteRepositoryV1Api.md#storewebsiterepositoryv1getlistget) | **GET** /V1/store/websites | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1DeleteByIdDelete**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1deletebyiddelete) | **DELETE** /V1/taxClasses/{taxClassId} | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1GetGet**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1getget) | **GET** /V1/taxClasses/{taxClassId} | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1GetListGet**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1getlistget) | **GET** /V1/taxClasses/search | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1SavePost**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1savepost) | **POST** /V1/taxClasses | 
*TaxTaxClassRepositoryV1Api* | [**taxTaxClassRepositoryV1SavePut**](docs/Api/TaxTaxClassRepositoryV1Api.md#taxtaxclassrepositoryv1saveput) | **PUT** /V1/taxClasses/{classId} | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1DeleteByIdDelete**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1deletebyiddelete) | **DELETE** /V1/taxRates/{rateId} | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1GetGet**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1getget) | **GET** /V1/taxRates/{rateId} | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1GetListGet**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1getlistget) | **GET** /V1/taxRates/search | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1SavePost**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1savepost) | **POST** /V1/taxRates | 
*TaxTaxRateRepositoryV1Api* | [**taxTaxRateRepositoryV1SavePut**](docs/Api/TaxTaxRateRepositoryV1Api.md#taxtaxraterepositoryv1saveput) | **PUT** /V1/taxRates | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1DeleteByIdDelete**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1deletebyiddelete) | **DELETE** /V1/taxRules/{ruleId} | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1GetGet**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1getget) | **GET** /V1/taxRules/{ruleId} | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1GetListGet**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1getlistget) | **GET** /V1/taxRules/search | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1SavePost**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1savepost) | **POST** /V1/taxRules | 
*TaxTaxRuleRepositoryV1Api* | [**taxTaxRuleRepositoryV1SavePut**](docs/Api/TaxTaxRuleRepositoryV1Api.md#taxtaxrulerepositoryv1saveput) | **PUT** /V1/taxRules | 
*TemandoShippingCheckoutCartCollectionPointManagementV1Api* | [**temandoShippingCheckoutCartCollectionPointManagementV1DeleteSearchRequestDelete**](docs/Api/TemandoShippingCheckoutCartCollectionPointManagementV1Api.md#temandoshippingcheckoutcartcollectionpointmanagementv1deletesearchrequestdelete) | **DELETE** /V1/carts/mine/collection-point/search-request | 
*TemandoShippingCheckoutCartCollectionPointManagementV1Api* | [**temandoShippingCheckoutCartCollectionPointManagementV1GetCollectionPointsGet**](docs/Api/TemandoShippingCheckoutCartCollectionPointManagementV1Api.md#temandoshippingcheckoutcartcollectionpointmanagementv1getcollectionpointsget) | **GET** /V1/carts/mine/collection-point/search-result | 
*TemandoShippingCheckoutCartCollectionPointManagementV1Api* | [**temandoShippingCheckoutCartCollectionPointManagementV1SaveSearchRequestPut**](docs/Api/TemandoShippingCheckoutCartCollectionPointManagementV1Api.md#temandoshippingcheckoutcartcollectionpointmanagementv1savesearchrequestput) | **PUT** /V1/carts/mine/collection-point/search-request | 
*TemandoShippingCheckoutCartCollectionPointManagementV1Api* | [**temandoShippingCheckoutCartCollectionPointManagementV1SelectCollectionPointPost**](docs/Api/TemandoShippingCheckoutCartCollectionPointManagementV1Api.md#temandoshippingcheckoutcartcollectionpointmanagementv1selectcollectionpointpost) | **POST** /V1/carts/mine/checkout-collection-point/select | 
*TemandoShippingCheckoutCartPickupLocationManagementV1Api* | [**temandoShippingCheckoutCartPickupLocationManagementV1SelectPickupLocationPost**](docs/Api/TemandoShippingCheckoutCartPickupLocationManagementV1Api.md#temandoshippingcheckoutcartpickuplocationmanagementv1selectpickuplocationpost) | **POST** /V1/carts/mine/checkout-pickup-location/select | 
*TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api* | [**temandoShippingCheckoutGuestCartCollectionPointManagementV1DeleteSearchRequestDelete**](docs/Api/TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api.md#temandoshippingcheckoutguestcartcollectionpointmanagementv1deletesearchrequestdelete) | **DELETE** /V1/guest-carts/{cartId}/collection-point/search-request | 
*TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api* | [**temandoShippingCheckoutGuestCartCollectionPointManagementV1GetCollectionPointsGet**](docs/Api/TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api.md#temandoshippingcheckoutguestcartcollectionpointmanagementv1getcollectionpointsget) | **GET** /V1/guest-carts/{cartId}/collection-point/search-result | 
*TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api* | [**temandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPut**](docs/Api/TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api.md#temandoshippingcheckoutguestcartcollectionpointmanagementv1savesearchrequestput) | **PUT** /V1/guest-carts/{cartId}/collection-point/search-request | 
*TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api* | [**temandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPost**](docs/Api/TemandoShippingCheckoutGuestCartCollectionPointManagementV1Api.md#temandoshippingcheckoutguestcartcollectionpointmanagementv1selectcollectionpointpost) | **POST** /V1/guest-carts/{cartId}/checkout-collection-point/select | 
*TemandoShippingCheckoutGuestCartPickupLocationManagementV1Api* | [**temandoShippingCheckoutGuestCartPickupLocationManagementV1SelectPickupLocationPost**](docs/Api/TemandoShippingCheckoutGuestCartPickupLocationManagementV1Api.md#temandoshippingcheckoutguestcartpickuplocationmanagementv1selectpickuplocationpost) | **POST** /V1/guest-carts/{cartId}/checkout-pickup-location/select | 
*TemandoShippingDeliveryCartCollectionPointManagementV1Api* | [**temandoShippingDeliveryCartCollectionPointManagementV1SelectCollectionPointPost**](docs/Api/TemandoShippingDeliveryCartCollectionPointManagementV1Api.md#temandoshippingdeliverycartcollectionpointmanagementv1selectcollectionpointpost) | **POST** /V1/carts/mine/collection-point/select | 
*TemandoShippingDeliveryCartPickupLocationManagementV1Api* | [**temandoShippingDeliveryCartPickupLocationManagementV1SelectPickupLocationPost**](docs/Api/TemandoShippingDeliveryCartPickupLocationManagementV1Api.md#temandoshippingdeliverycartpickuplocationmanagementv1selectpickuplocationpost) | **POST** /V1/carts/mine/pickup-location/select | 
*TemandoShippingDeliveryGuestCartCollectionPointManagementV1Api* | [**temandoShippingDeliveryGuestCartCollectionPointManagementV1SelectCollectionPointPost**](docs/Api/TemandoShippingDeliveryGuestCartCollectionPointManagementV1Api.md#temandoshippingdeliveryguestcartcollectionpointmanagementv1selectcollectionpointpost) | **POST** /V1/guest-carts/{cartId}/collection-point/select | 
*TemandoShippingDeliveryGuestCartPickupLocationManagementV1Api* | [**temandoShippingDeliveryGuestCartPickupLocationManagementV1SelectPickupLocationPost**](docs/Api/TemandoShippingDeliveryGuestCartPickupLocationManagementV1Api.md#temandoshippingdeliveryguestcartpickuplocationmanagementv1selectpickuplocationpost) | **POST** /V1/guest-carts/{cartId}/pickup-location/select | 
*TemandoShippingQuoteCartCheckoutFieldManagementV1Api* | [**temandoShippingQuoteCartCheckoutFieldManagementV1SaveCheckoutFieldsPost**](docs/Api/TemandoShippingQuoteCartCheckoutFieldManagementV1Api.md#temandoshippingquotecartcheckoutfieldmanagementv1savecheckoutfieldspost) | **POST** /V1/carts/mine/checkout-fields | 
*TemandoShippingQuoteCartDeliveryOptionManagementV1Api* | [**temandoShippingQuoteCartDeliveryOptionManagementV1SavePost**](docs/Api/TemandoShippingQuoteCartDeliveryOptionManagementV1Api.md#temandoshippingquotecartdeliveryoptionmanagementv1savepost) | **POST** /V1/carts/mine/delivery-option | 
*TemandoShippingQuoteGuestCartCheckoutFieldManagementV1Api* | [**temandoShippingQuoteGuestCartCheckoutFieldManagementV1SaveCheckoutFieldsPost**](docs/Api/TemandoShippingQuoteGuestCartCheckoutFieldManagementV1Api.md#temandoshippingquoteguestcartcheckoutfieldmanagementv1savecheckoutfieldspost) | **POST** /V1/guest-carts/{cartId}/checkout-fields | 
*TemandoShippingQuoteGuestCartDeliveryOptionManagementV1Api* | [**temandoShippingQuoteGuestCartDeliveryOptionManagementV1SavePost**](docs/Api/TemandoShippingQuoteGuestCartDeliveryOptionManagementV1Api.md#temandoshippingquoteguestcartdeliveryoptionmanagementv1savepost) | **POST** /V1/guest-carts/{cartId}/delivery-option | 
*TemandoShippingRmaRmaShipmentManagementV1Api* | [**temandoShippingRmaRmaShipmentManagementV1AssignShipmentIdsPut**](docs/Api/TemandoShippingRmaRmaShipmentManagementV1Api.md#temandoshippingrmarmashipmentmanagementv1assignshipmentidsput) | **PUT** /V1/temando/rma/{rmaId}/shipments | 

## Models

- [AmazonPaymentAddressManagementV1GetShippingAddressPutRequest](docs/Model/AmazonPaymentAddressManagementV1GetShippingAddressPutRequest.md)
- [AmazonPaymentDataOrderLinkInterface](docs/Model/AmazonPaymentDataOrderLinkInterface.md)
- [AmazonPaymentDataQuoteLinkInterface](docs/Model/AmazonPaymentDataQuoteLinkInterface.md)
- [AnalyticsDataLinkInterface](docs/Model/AnalyticsDataLinkInterface.md)
- [AsynchronousOperationsDataBulkOperationsStatusInterface](docs/Model/AsynchronousOperationsDataBulkOperationsStatusInterface.md)
- [AsynchronousOperationsDataDetailedBulkOperationsStatusInterface](docs/Model/AsynchronousOperationsDataDetailedBulkOperationsStatusInterface.md)
- [AsynchronousOperationsDataOperationExtensionInterface](docs/Model/AsynchronousOperationsDataOperationExtensionInterface.md)
- [AsynchronousOperationsDataOperationInterface](docs/Model/AsynchronousOperationsDataOperationInterface.md)
- [AsynchronousOperationsDataOperationSearchResultsInterface](docs/Model/AsynchronousOperationsDataOperationSearchResultsInterface.md)
- [AsynchronousOperationsDataSummaryOperationStatusInterface](docs/Model/AsynchronousOperationsDataSummaryOperationStatusInterface.md)
- [BundleDataBundleOptionInterface](docs/Model/BundleDataBundleOptionInterface.md)
- [BundleDataLinkInterface](docs/Model/BundleDataLinkInterface.md)
- [BundleDataOptionInterface](docs/Model/BundleDataOptionInterface.md)
- [BundleDataOptionTypeInterface](docs/Model/BundleDataOptionTypeInterface.md)
- [BundleProductLinkManagementV1AddChildByProductSkuPostRequest](docs/Model/BundleProductLinkManagementV1AddChildByProductSkuPostRequest.md)
- [BundleProductOptionManagementV1SavePostRequest](docs/Model/BundleProductOptionManagementV1SavePostRequest.md)
- [CatalogAttributeSetManagementV1CreatePostRequest](docs/Model/CatalogAttributeSetManagementV1CreatePostRequest.md)
- [CatalogBasePriceStorageV1UpdatePostRequest](docs/Model/CatalogBasePriceStorageV1UpdatePostRequest.md)
- [CatalogCategoryLinkRepositoryV1SavePutRequest](docs/Model/CatalogCategoryLinkRepositoryV1SavePutRequest.md)
- [CatalogCategoryManagementV1MovePutRequest](docs/Model/CatalogCategoryManagementV1MovePutRequest.md)
- [CatalogCategoryRepositoryV1SavePostRequest](docs/Model/CatalogCategoryRepositoryV1SavePostRequest.md)
- [CatalogCostStorageV1UpdatePostRequest](docs/Model/CatalogCostStorageV1UpdatePostRequest.md)
- [CatalogDataBasePriceInterface](docs/Model/CatalogDataBasePriceInterface.md)
- [CatalogDataCategoryAttributeInterface](docs/Model/CatalogDataCategoryAttributeInterface.md)
- [CatalogDataCategoryAttributeSearchResultsInterface](docs/Model/CatalogDataCategoryAttributeSearchResultsInterface.md)
- [CatalogDataCategoryInterface](docs/Model/CatalogDataCategoryInterface.md)
- [CatalogDataCategoryLinkInterface](docs/Model/CatalogDataCategoryLinkInterface.md)
- [CatalogDataCategoryProductLinkInterface](docs/Model/CatalogDataCategoryProductLinkInterface.md)
- [CatalogDataCategorySearchResultsInterface](docs/Model/CatalogDataCategorySearchResultsInterface.md)
- [CatalogDataCategoryTreeInterface](docs/Model/CatalogDataCategoryTreeInterface.md)
- [CatalogDataCostInterface](docs/Model/CatalogDataCostInterface.md)
- [CatalogDataCustomOptionExtensionInterface](docs/Model/CatalogDataCustomOptionExtensionInterface.md)
- [CatalogDataCustomOptionInterface](docs/Model/CatalogDataCustomOptionInterface.md)
- [CatalogDataPriceUpdateResultInterface](docs/Model/CatalogDataPriceUpdateResultInterface.md)
- [CatalogDataProductAttributeInterface](docs/Model/CatalogDataProductAttributeInterface.md)
- [CatalogDataProductAttributeMediaGalleryEntryExtensionInterface](docs/Model/CatalogDataProductAttributeMediaGalleryEntryExtensionInterface.md)
- [CatalogDataProductAttributeMediaGalleryEntryInterface](docs/Model/CatalogDataProductAttributeMediaGalleryEntryInterface.md)
- [CatalogDataProductAttributeSearchResultsInterface](docs/Model/CatalogDataProductAttributeSearchResultsInterface.md)
- [CatalogDataProductAttributeTypeInterface](docs/Model/CatalogDataProductAttributeTypeInterface.md)
- [CatalogDataProductCustomOptionInterface](docs/Model/CatalogDataProductCustomOptionInterface.md)
- [CatalogDataProductCustomOptionTypeInterface](docs/Model/CatalogDataProductCustomOptionTypeInterface.md)
- [CatalogDataProductCustomOptionValuesInterface](docs/Model/CatalogDataProductCustomOptionValuesInterface.md)
- [CatalogDataProductExtensionInterface](docs/Model/CatalogDataProductExtensionInterface.md)
- [CatalogDataProductInterface](docs/Model/CatalogDataProductInterface.md)
- [CatalogDataProductLinkAttributeInterface](docs/Model/CatalogDataProductLinkAttributeInterface.md)
- [CatalogDataProductLinkExtensionInterface](docs/Model/CatalogDataProductLinkExtensionInterface.md)
- [CatalogDataProductLinkInterface](docs/Model/CatalogDataProductLinkInterface.md)
- [CatalogDataProductLinkTypeInterface](docs/Model/CatalogDataProductLinkTypeInterface.md)
- [CatalogDataProductOptionExtensionInterface](docs/Model/CatalogDataProductOptionExtensionInterface.md)
- [CatalogDataProductOptionInterface](docs/Model/CatalogDataProductOptionInterface.md)
- [CatalogDataProductRenderButtonInterface](docs/Model/CatalogDataProductRenderButtonInterface.md)
- [CatalogDataProductRenderExtensionInterface](docs/Model/CatalogDataProductRenderExtensionInterface.md)
- [CatalogDataProductRenderFormattedPriceInfoInterface](docs/Model/CatalogDataProductRenderFormattedPriceInfoInterface.md)
- [CatalogDataProductRenderImageInterface](docs/Model/CatalogDataProductRenderImageInterface.md)
- [CatalogDataProductRenderInterface](docs/Model/CatalogDataProductRenderInterface.md)
- [CatalogDataProductRenderPriceInfoExtensionInterface](docs/Model/CatalogDataProductRenderPriceInfoExtensionInterface.md)
- [CatalogDataProductRenderPriceInfoInterface](docs/Model/CatalogDataProductRenderPriceInfoInterface.md)
- [CatalogDataProductRenderSearchResultsInterface](docs/Model/CatalogDataProductRenderSearchResultsInterface.md)
- [CatalogDataProductSearchResultsInterface](docs/Model/CatalogDataProductSearchResultsInterface.md)
- [CatalogDataProductTierPriceExtensionInterface](docs/Model/CatalogDataProductTierPriceExtensionInterface.md)
- [CatalogDataProductTierPriceInterface](docs/Model/CatalogDataProductTierPriceInterface.md)
- [CatalogDataProductTypeInterface](docs/Model/CatalogDataProductTypeInterface.md)
- [CatalogDataProductWebsiteLinkInterface](docs/Model/CatalogDataProductWebsiteLinkInterface.md)
- [CatalogDataSpecialPriceInterface](docs/Model/CatalogDataSpecialPriceInterface.md)
- [CatalogDataTierPriceInterface](docs/Model/CatalogDataTierPriceInterface.md)
- [CatalogInventoryDataStockItemCollectionInterface](docs/Model/CatalogInventoryDataStockItemCollectionInterface.md)
- [CatalogInventoryDataStockItemInterface](docs/Model/CatalogInventoryDataStockItemInterface.md)
- [CatalogInventoryDataStockStatusInterface](docs/Model/CatalogInventoryDataStockStatusInterface.md)
- [CatalogInventoryStockItemCriteriaInterface](docs/Model/CatalogInventoryStockItemCriteriaInterface.md)
- [CatalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest](docs/Model/CatalogInventoryStockRegistryV1UpdateStockItemBySkuPutRequest.md)
- [CatalogProductAttributeGroupRepositoryV1SavePostRequest](docs/Model/CatalogProductAttributeGroupRepositoryV1SavePostRequest.md)
- [CatalogProductAttributeManagementV1AssignPostRequest](docs/Model/CatalogProductAttributeManagementV1AssignPostRequest.md)
- [CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest](docs/Model/CatalogProductAttributeMediaGalleryManagementV1UpdatePutRequest.md)
- [CatalogProductAttributeOptionManagementV1AddPostRequest](docs/Model/CatalogProductAttributeOptionManagementV1AddPostRequest.md)
- [CatalogProductAttributeRepositoryV1SavePutRequest](docs/Model/CatalogProductAttributeRepositoryV1SavePutRequest.md)
- [CatalogProductCustomOptionRepositoryV1SavePostRequest](docs/Model/CatalogProductCustomOptionRepositoryV1SavePostRequest.md)
- [CatalogProductLinkManagementV1SetProductLinksPostRequest](docs/Model/CatalogProductLinkManagementV1SetProductLinksPostRequest.md)
- [CatalogProductLinkRepositoryV1SavePutRequest](docs/Model/CatalogProductLinkRepositoryV1SavePutRequest.md)
- [CatalogProductRepositoryV1SavePostRequest](docs/Model/CatalogProductRepositoryV1SavePostRequest.md)
- [CatalogProductWebsiteLinkRepositoryV1SavePutRequest](docs/Model/CatalogProductWebsiteLinkRepositoryV1SavePutRequest.md)
- [CatalogSpecialPriceStorageV1UpdatePostRequest](docs/Model/CatalogSpecialPriceStorageV1UpdatePostRequest.md)
- [CatalogTierPriceStorageV1GetPostRequest](docs/Model/CatalogTierPriceStorageV1GetPostRequest.md)
- [CatalogTierPriceStorageV1ReplacePutRequest](docs/Model/CatalogTierPriceStorageV1ReplacePutRequest.md)
- [CheckoutAgreementsDataAgreementInterface](docs/Model/CheckoutAgreementsDataAgreementInterface.md)
- [CheckoutDataPaymentDetailsInterface](docs/Model/CheckoutDataPaymentDetailsInterface.md)
- [CheckoutDataShippingInformationInterface](docs/Model/CheckoutDataShippingInformationInterface.md)
- [CheckoutDataTotalsInformationInterface](docs/Model/CheckoutDataTotalsInformationInterface.md)
- [CheckoutGuestPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPostRequest](docs/Model/CheckoutGuestPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPostRequest.md)
- [CheckoutGuestShippingInformationManagementV1SaveAddressInformationPostRequest](docs/Model/CheckoutGuestShippingInformationManagementV1SaveAddressInformationPostRequest.md)
- [CheckoutPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPostRequest](docs/Model/CheckoutPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPostRequest.md)
- [CheckoutTotalsInformationManagementV1CalculatePostRequest](docs/Model/CheckoutTotalsInformationManagementV1CalculatePostRequest.md)
- [CmsBlockRepositoryV1SavePostRequest](docs/Model/CmsBlockRepositoryV1SavePostRequest.md)
- [CmsDataBlockInterface](docs/Model/CmsDataBlockInterface.md)
- [CmsDataBlockSearchResultsInterface](docs/Model/CmsDataBlockSearchResultsInterface.md)
- [CmsDataPageInterface](docs/Model/CmsDataPageInterface.md)
- [CmsDataPageSearchResultsInterface](docs/Model/CmsDataPageSearchResultsInterface.md)
- [CmsPageRepositoryV1SavePostRequest](docs/Model/CmsPageRepositoryV1SavePostRequest.md)
- [ConfigurableProductConfigurableProductManagementV1GenerateVariationPutRequest](docs/Model/ConfigurableProductConfigurableProductManagementV1GenerateVariationPutRequest.md)
- [ConfigurableProductDataConfigurableItemOptionValueInterface](docs/Model/ConfigurableProductDataConfigurableItemOptionValueInterface.md)
- [ConfigurableProductDataOptionInterface](docs/Model/ConfigurableProductDataOptionInterface.md)
- [ConfigurableProductDataOptionValueInterface](docs/Model/ConfigurableProductDataOptionValueInterface.md)
- [ConfigurableProductLinkManagementV1AddChildPostRequest](docs/Model/ConfigurableProductLinkManagementV1AddChildPostRequest.md)
- [ConfigurableProductOptionRepositoryV1SavePutRequest](docs/Model/ConfigurableProductOptionRepositoryV1SavePutRequest.md)
- [CustomerAccountManagementV1ActivateByIdPutRequest](docs/Model/CustomerAccountManagementV1ActivateByIdPutRequest.md)
- [CustomerAccountManagementV1ChangePasswordByIdPutRequest](docs/Model/CustomerAccountManagementV1ChangePasswordByIdPutRequest.md)
- [CustomerAccountManagementV1CreateAccountPostRequest](docs/Model/CustomerAccountManagementV1CreateAccountPostRequest.md)
- [CustomerAccountManagementV1InitiatePasswordResetPutRequest](docs/Model/CustomerAccountManagementV1InitiatePasswordResetPutRequest.md)
- [CustomerAccountManagementV1IsEmailAvailablePostRequest](docs/Model/CustomerAccountManagementV1IsEmailAvailablePostRequest.md)
- [CustomerAccountManagementV1ResendConfirmationPostRequest](docs/Model/CustomerAccountManagementV1ResendConfirmationPostRequest.md)
- [CustomerAccountManagementV1ResetPasswordPostRequest](docs/Model/CustomerAccountManagementV1ResetPasswordPostRequest.md)
- [CustomerAccountManagementV1ValidatePutRequest](docs/Model/CustomerAccountManagementV1ValidatePutRequest.md)
- [CustomerCustomerRepositoryV1SavePutRequest](docs/Model/CustomerCustomerRepositoryV1SavePutRequest.md)
- [CustomerDataAddressInterface](docs/Model/CustomerDataAddressInterface.md)
- [CustomerDataAttributeMetadataInterface](docs/Model/CustomerDataAttributeMetadataInterface.md)
- [CustomerDataCustomerExtensionInterface](docs/Model/CustomerDataCustomerExtensionInterface.md)
- [CustomerDataCustomerInterface](docs/Model/CustomerDataCustomerInterface.md)
- [CustomerDataCustomerSearchResultsInterface](docs/Model/CustomerDataCustomerSearchResultsInterface.md)
- [CustomerDataGroupInterface](docs/Model/CustomerDataGroupInterface.md)
- [CustomerDataGroupSearchResultsInterface](docs/Model/CustomerDataGroupSearchResultsInterface.md)
- [CustomerDataOptionInterface](docs/Model/CustomerDataOptionInterface.md)
- [CustomerDataRegionInterface](docs/Model/CustomerDataRegionInterface.md)
- [CustomerDataValidationResultsInterface](docs/Model/CustomerDataValidationResultsInterface.md)
- [CustomerDataValidationRuleInterface](docs/Model/CustomerDataValidationRuleInterface.md)
- [CustomerGroupRepositoryV1SavePutRequest](docs/Model/CustomerGroupRepositoryV1SavePutRequest.md)
- [DirectoryDataCountryInformationInterface](docs/Model/DirectoryDataCountryInformationInterface.md)
- [DirectoryDataCurrencyInformationInterface](docs/Model/DirectoryDataCurrencyInformationInterface.md)
- [DirectoryDataExchangeRateInterface](docs/Model/DirectoryDataExchangeRateInterface.md)
- [DirectoryDataRegionInformationInterface](docs/Model/DirectoryDataRegionInformationInterface.md)
- [DownloadableDataDownloadableOptionInterface](docs/Model/DownloadableDataDownloadableOptionInterface.md)
- [DownloadableDataFileContentInterface](docs/Model/DownloadableDataFileContentInterface.md)
- [DownloadableDataLinkInterface](docs/Model/DownloadableDataLinkInterface.md)
- [DownloadableDataSampleInterface](docs/Model/DownloadableDataSampleInterface.md)
- [DownloadableLinkRepositoryV1SavePostRequest](docs/Model/DownloadableLinkRepositoryV1SavePostRequest.md)
- [DownloadableSampleRepositoryV1SavePostRequest](docs/Model/DownloadableSampleRepositoryV1SavePostRequest.md)
- [EavAttributeSetManagementV1CreatePostRequest](docs/Model/EavAttributeSetManagementV1CreatePostRequest.md)
- [EavAttributeSetRepositoryV1SavePutRequest](docs/Model/EavAttributeSetRepositoryV1SavePutRequest.md)
- [EavDataAttributeFrontendLabelInterface](docs/Model/EavDataAttributeFrontendLabelInterface.md)
- [EavDataAttributeGroupExtensionInterface](docs/Model/EavDataAttributeGroupExtensionInterface.md)
- [EavDataAttributeGroupInterface](docs/Model/EavDataAttributeGroupInterface.md)
- [EavDataAttributeGroupSearchResultsInterface](docs/Model/EavDataAttributeGroupSearchResultsInterface.md)
- [EavDataAttributeOptionInterface](docs/Model/EavDataAttributeOptionInterface.md)
- [EavDataAttributeOptionLabelInterface](docs/Model/EavDataAttributeOptionLabelInterface.md)
- [EavDataAttributeSetInterface](docs/Model/EavDataAttributeSetInterface.md)
- [EavDataAttributeSetSearchResultsInterface](docs/Model/EavDataAttributeSetSearchResultsInterface.md)
- [EavDataAttributeValidationRuleInterface](docs/Model/EavDataAttributeValidationRuleInterface.md)
- [ErrorErrorsItem](docs/Model/ErrorErrorsItem.md)
- [ErrorParametersItem](docs/Model/ErrorParametersItem.md)
- [ErrorResponse](docs/Model/ErrorResponse.md)
- [FrameworkAttributeInterface](docs/Model/FrameworkAttributeInterface.md)
- [FrameworkCriteriaInterface](docs/Model/FrameworkCriteriaInterface.md)
- [FrameworkDataImageContentInterface](docs/Model/FrameworkDataImageContentInterface.md)
- [FrameworkDataVideoContentInterface](docs/Model/FrameworkDataVideoContentInterface.md)
- [FrameworkFilter](docs/Model/FrameworkFilter.md)
- [FrameworkSearchAggregationInterface](docs/Model/FrameworkSearchAggregationInterface.md)
- [FrameworkSearchAggregationValueInterface](docs/Model/FrameworkSearchAggregationValueInterface.md)
- [FrameworkSearchBucketInterface](docs/Model/FrameworkSearchBucketInterface.md)
- [FrameworkSearchCriteriaInterface](docs/Model/FrameworkSearchCriteriaInterface.md)
- [FrameworkSearchDocumentInterface](docs/Model/FrameworkSearchDocumentInterface.md)
- [FrameworkSearchFilterGroup](docs/Model/FrameworkSearchFilterGroup.md)
- [FrameworkSearchSearchCriteriaInterface](docs/Model/FrameworkSearchSearchCriteriaInterface.md)
- [FrameworkSearchSearchResultInterface](docs/Model/FrameworkSearchSearchResultInterface.md)
- [FrameworkSortOrder](docs/Model/FrameworkSortOrder.md)
- [GiftMessageCartRepositoryV1SavePostRequest](docs/Model/GiftMessageCartRepositoryV1SavePostRequest.md)
- [GiftMessageDataMessageExtensionInterface](docs/Model/GiftMessageDataMessageExtensionInterface.md)
- [GiftMessageDataMessageInterface](docs/Model/GiftMessageDataMessageInterface.md)
- [IntegrationAdminTokenServiceV1CreateAdminAccessTokenPostRequest](docs/Model/IntegrationAdminTokenServiceV1CreateAdminAccessTokenPostRequest.md)
- [InventoryApiDataSourceCarrierLinkInterface](docs/Model/InventoryApiDataSourceCarrierLinkInterface.md)
- [InventoryApiDataSourceInterface](docs/Model/InventoryApiDataSourceInterface.md)
- [InventoryApiDataSourceItemInterface](docs/Model/InventoryApiDataSourceItemInterface.md)
- [InventoryApiDataSourceItemSearchResultsInterface](docs/Model/InventoryApiDataSourceItemSearchResultsInterface.md)
- [InventoryApiDataSourceSearchResultsInterface](docs/Model/InventoryApiDataSourceSearchResultsInterface.md)
- [InventoryApiDataStockExtensionInterface](docs/Model/InventoryApiDataStockExtensionInterface.md)
- [InventoryApiDataStockInterface](docs/Model/InventoryApiDataStockInterface.md)
- [InventoryApiDataStockSearchResultsInterface](docs/Model/InventoryApiDataStockSearchResultsInterface.md)
- [InventoryApiDataStockSourceLinkInterface](docs/Model/InventoryApiDataStockSourceLinkInterface.md)
- [InventoryApiDataStockSourceLinkSearchResultsInterface](docs/Model/InventoryApiDataStockSourceLinkSearchResultsInterface.md)
- [InventoryApiSourceItemsSaveV1ExecutePostRequest](docs/Model/InventoryApiSourceItemsSaveV1ExecutePostRequest.md)
- [InventoryApiSourceRepositoryV1SavePostRequest](docs/Model/InventoryApiSourceRepositoryV1SavePostRequest.md)
- [InventoryApiStockRepositoryV1SavePostRequest](docs/Model/InventoryApiStockRepositoryV1SavePostRequest.md)
- [InventoryApiStockSourceLinksSaveV1ExecutePostRequest](docs/Model/InventoryApiStockSourceLinksSaveV1ExecutePostRequest.md)
- [InventoryCatalogApiBulkInventoryTransferV1ExecutePostRequest](docs/Model/InventoryCatalogApiBulkInventoryTransferV1ExecutePostRequest.md)
- [InventoryCatalogApiBulkPartialInventoryTransferV1ExecutePostRequest](docs/Model/InventoryCatalogApiBulkPartialInventoryTransferV1ExecutePostRequest.md)
- [InventoryCatalogApiBulkSourceAssignV1ExecutePostRequest](docs/Model/InventoryCatalogApiBulkSourceAssignV1ExecutePostRequest.md)
- [InventoryCatalogApiDataPartialInventoryTransferItemInterface](docs/Model/InventoryCatalogApiDataPartialInventoryTransferItemInterface.md)
- [InventoryDistanceBasedSourceSelectionApiDataLatLngInterface](docs/Model/InventoryDistanceBasedSourceSelectionApiDataLatLngInterface.md)
- [InventoryExportStockApiDataExportStockSalableQtySearchResultInterface](docs/Model/InventoryExportStockApiDataExportStockSalableQtySearchResultInterface.md)
- [InventoryExportStockApiDataProductStockIndexDataInterface](docs/Model/InventoryExportStockApiDataProductStockIndexDataInterface.md)
- [InventoryLowQuantityNotificationApiDataSourceItemConfigurationInterface](docs/Model/InventoryLowQuantityNotificationApiDataSourceItemConfigurationInterface.md)
- [InventoryLowQuantityNotificationApiSourceItemConfigurationsSaveV1ExecutePostRequest](docs/Model/InventoryLowQuantityNotificationApiSourceItemConfigurationsSaveV1ExecutePostRequest.md)
- [InventorySalesApiDataProductSalabilityErrorInterface](docs/Model/InventorySalesApiDataProductSalabilityErrorInterface.md)
- [InventorySalesApiDataProductSalableResultInterface](docs/Model/InventorySalesApiDataProductSalableResultInterface.md)
- [InventorySalesApiDataSalesChannelInterface](docs/Model/InventorySalesApiDataSalesChannelInterface.md)
- [InventorySourceSelectionApiDataAddressInterface](docs/Model/InventorySourceSelectionApiDataAddressInterface.md)
- [InventorySourceSelectionApiDataInventoryRequestExtensionInterface](docs/Model/InventorySourceSelectionApiDataInventoryRequestExtensionInterface.md)
- [InventorySourceSelectionApiDataInventoryRequestInterface](docs/Model/InventorySourceSelectionApiDataInventoryRequestInterface.md)
- [InventorySourceSelectionApiDataItemRequestInterface](docs/Model/InventorySourceSelectionApiDataItemRequestInterface.md)
- [InventorySourceSelectionApiDataSourceSelectionAlgorithmInterface](docs/Model/InventorySourceSelectionApiDataSourceSelectionAlgorithmInterface.md)
- [InventorySourceSelectionApiDataSourceSelectionItemInterface](docs/Model/InventorySourceSelectionApiDataSourceSelectionItemInterface.md)
- [InventorySourceSelectionApiDataSourceSelectionResultInterface](docs/Model/InventorySourceSelectionApiDataSourceSelectionResultInterface.md)
- [InventorySourceSelectionApiSourceSelectionServiceV1ExecutePostRequest](docs/Model/InventorySourceSelectionApiSourceSelectionServiceV1ExecutePostRequest.md)
- [MSPTwoFactorAuthTfaV1SetDefaultProviderCodePutRequest](docs/Model/MSPTwoFactorAuthTfaV1SetDefaultProviderCodePutRequest.md)
- [MSPTwoFactorAuthTfaV1SetProvidersCodesPutRequest](docs/Model/MSPTwoFactorAuthTfaV1SetProvidersCodesPutRequest.md)
- [MSpTwoFactorAuthDataTrustedInterface](docs/Model/MSpTwoFactorAuthDataTrustedInterface.md)
- [MSpTwoFactorAuthEngineInterface](docs/Model/MSpTwoFactorAuthEngineInterface.md)
- [MSpTwoFactorAuthProviderInterface](docs/Model/MSpTwoFactorAuthProviderInterface.md)
- [MsrpDataProductRenderMsrpPriceInfoInterface](docs/Model/MsrpDataProductRenderMsrpPriceInfoInterface.md)
- [PaymentDataPaymentAdditionalInfoInterface](docs/Model/PaymentDataPaymentAdditionalInfoInterface.md)
- [QuoteBillingAddressManagementV1AssignPostRequest](docs/Model/QuoteBillingAddressManagementV1AssignPostRequest.md)
- [QuoteCartItemRepositoryV1SavePostRequest](docs/Model/QuoteCartItemRepositoryV1SavePostRequest.md)
- [QuoteCartManagementV1AssignCustomerPutRequest](docs/Model/QuoteCartManagementV1AssignCustomerPutRequest.md)
- [QuoteCartManagementV1PlaceOrderPutRequest](docs/Model/QuoteCartManagementV1PlaceOrderPutRequest.md)
- [QuoteCartRepositoryV1SavePutRequest](docs/Model/QuoteCartRepositoryV1SavePutRequest.md)
- [QuoteDataAddressExtensionInterface](docs/Model/QuoteDataAddressExtensionInterface.md)
- [QuoteDataAddressInterface](docs/Model/QuoteDataAddressInterface.md)
- [QuoteDataCartExtensionInterface](docs/Model/QuoteDataCartExtensionInterface.md)
- [QuoteDataCartInterface](docs/Model/QuoteDataCartInterface.md)
- [QuoteDataCartItemInterface](docs/Model/QuoteDataCartItemInterface.md)
- [QuoteDataCartSearchResultsInterface](docs/Model/QuoteDataCartSearchResultsInterface.md)
- [QuoteDataCurrencyInterface](docs/Model/QuoteDataCurrencyInterface.md)
- [QuoteDataPaymentExtensionInterface](docs/Model/QuoteDataPaymentExtensionInterface.md)
- [QuoteDataPaymentInterface](docs/Model/QuoteDataPaymentInterface.md)
- [QuoteDataPaymentMethodInterface](docs/Model/QuoteDataPaymentMethodInterface.md)
- [QuoteDataProductOptionExtensionInterface](docs/Model/QuoteDataProductOptionExtensionInterface.md)
- [QuoteDataProductOptionInterface](docs/Model/QuoteDataProductOptionInterface.md)
- [QuoteDataShippingAssignmentInterface](docs/Model/QuoteDataShippingAssignmentInterface.md)
- [QuoteDataShippingInterface](docs/Model/QuoteDataShippingInterface.md)
- [QuoteDataShippingMethodInterface](docs/Model/QuoteDataShippingMethodInterface.md)
- [QuoteDataTotalSegmentExtensionInterface](docs/Model/QuoteDataTotalSegmentExtensionInterface.md)
- [QuoteDataTotalSegmentInterface](docs/Model/QuoteDataTotalSegmentInterface.md)
- [QuoteDataTotalsAdditionalDataExtensionInterface](docs/Model/QuoteDataTotalsAdditionalDataExtensionInterface.md)
- [QuoteDataTotalsAdditionalDataInterface](docs/Model/QuoteDataTotalsAdditionalDataInterface.md)
- [QuoteDataTotalsExtensionInterface](docs/Model/QuoteDataTotalsExtensionInterface.md)
- [QuoteDataTotalsInterface](docs/Model/QuoteDataTotalsInterface.md)
- [QuoteDataTotalsItemInterface](docs/Model/QuoteDataTotalsItemInterface.md)
- [QuoteGuestCartTotalManagementV1CollectTotalsPutRequest](docs/Model/QuoteGuestCartTotalManagementV1CollectTotalsPutRequest.md)
- [QuotePaymentMethodManagementV1SetPutRequest](docs/Model/QuotePaymentMethodManagementV1SetPutRequest.md)
- [QuoteShipmentEstimationV1EstimateByExtendedAddressPostRequest](docs/Model/QuoteShipmentEstimationV1EstimateByExtendedAddressPostRequest.md)
- [QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest](docs/Model/QuoteShippingMethodManagementV1EstimateByAddressIdPostRequest.md)
- [SalesCreditmemoCommentRepositoryV1SavePostRequest](docs/Model/SalesCreditmemoCommentRepositoryV1SavePostRequest.md)
- [SalesCreditmemoManagementV1RefundPostRequest](docs/Model/SalesCreditmemoManagementV1RefundPostRequest.md)
- [SalesCreditmemoRepositoryV1SavePostRequest](docs/Model/SalesCreditmemoRepositoryV1SavePostRequest.md)
- [SalesDataCreditmemoCommentCreationInterface](docs/Model/SalesDataCreditmemoCommentCreationInterface.md)
- [SalesDataCreditmemoCommentInterface](docs/Model/SalesDataCreditmemoCommentInterface.md)
- [SalesDataCreditmemoCommentSearchResultInterface](docs/Model/SalesDataCreditmemoCommentSearchResultInterface.md)
- [SalesDataCreditmemoCreationArgumentsExtensionInterface](docs/Model/SalesDataCreditmemoCreationArgumentsExtensionInterface.md)
- [SalesDataCreditmemoCreationArgumentsInterface](docs/Model/SalesDataCreditmemoCreationArgumentsInterface.md)
- [SalesDataCreditmemoExtensionInterface](docs/Model/SalesDataCreditmemoExtensionInterface.md)
- [SalesDataCreditmemoInterface](docs/Model/SalesDataCreditmemoInterface.md)
- [SalesDataCreditmemoItemCreationInterface](docs/Model/SalesDataCreditmemoItemCreationInterface.md)
- [SalesDataCreditmemoItemExtensionInterface](docs/Model/SalesDataCreditmemoItemExtensionInterface.md)
- [SalesDataCreditmemoItemInterface](docs/Model/SalesDataCreditmemoItemInterface.md)
- [SalesDataCreditmemoSearchResultInterface](docs/Model/SalesDataCreditmemoSearchResultInterface.md)
- [SalesDataInvoiceCommentCreationInterface](docs/Model/SalesDataInvoiceCommentCreationInterface.md)
- [SalesDataInvoiceCommentInterface](docs/Model/SalesDataInvoiceCommentInterface.md)
- [SalesDataInvoiceCommentSearchResultInterface](docs/Model/SalesDataInvoiceCommentSearchResultInterface.md)
- [SalesDataInvoiceCreationArgumentsInterface](docs/Model/SalesDataInvoiceCreationArgumentsInterface.md)
- [SalesDataInvoiceExtensionInterface](docs/Model/SalesDataInvoiceExtensionInterface.md)
- [SalesDataInvoiceInterface](docs/Model/SalesDataInvoiceInterface.md)
- [SalesDataInvoiceItemCreationInterface](docs/Model/SalesDataInvoiceItemCreationInterface.md)
- [SalesDataInvoiceItemExtensionInterface](docs/Model/SalesDataInvoiceItemExtensionInterface.md)
- [SalesDataInvoiceItemInterface](docs/Model/SalesDataInvoiceItemInterface.md)
- [SalesDataInvoiceSearchResultInterface](docs/Model/SalesDataInvoiceSearchResultInterface.md)
- [SalesDataOrderAddressExtensionInterface](docs/Model/SalesDataOrderAddressExtensionInterface.md)
- [SalesDataOrderAddressInterface](docs/Model/SalesDataOrderAddressInterface.md)
- [SalesDataOrderExtensionInterface](docs/Model/SalesDataOrderExtensionInterface.md)
- [SalesDataOrderInterface](docs/Model/SalesDataOrderInterface.md)
- [SalesDataOrderItemExtensionInterface](docs/Model/SalesDataOrderItemExtensionInterface.md)
- [SalesDataOrderItemInterface](docs/Model/SalesDataOrderItemInterface.md)
- [SalesDataOrderItemSearchResultInterface](docs/Model/SalesDataOrderItemSearchResultInterface.md)
- [SalesDataOrderPaymentExtensionInterface](docs/Model/SalesDataOrderPaymentExtensionInterface.md)
- [SalesDataOrderPaymentInterface](docs/Model/SalesDataOrderPaymentInterface.md)
- [SalesDataOrderSearchResultInterface](docs/Model/SalesDataOrderSearchResultInterface.md)
- [SalesDataOrderStatusHistoryInterface](docs/Model/SalesDataOrderStatusHistoryInterface.md)
- [SalesDataOrderStatusHistorySearchResultInterface](docs/Model/SalesDataOrderStatusHistorySearchResultInterface.md)
- [SalesDataShipmentCommentCreationInterface](docs/Model/SalesDataShipmentCommentCreationInterface.md)
- [SalesDataShipmentCommentInterface](docs/Model/SalesDataShipmentCommentInterface.md)
- [SalesDataShipmentCommentSearchResultInterface](docs/Model/SalesDataShipmentCommentSearchResultInterface.md)
- [SalesDataShipmentCreationArgumentsExtensionInterface](docs/Model/SalesDataShipmentCreationArgumentsExtensionInterface.md)
- [SalesDataShipmentCreationArgumentsInterface](docs/Model/SalesDataShipmentCreationArgumentsInterface.md)
- [SalesDataShipmentExtensionInterface](docs/Model/SalesDataShipmentExtensionInterface.md)
- [SalesDataShipmentInterface](docs/Model/SalesDataShipmentInterface.md)
- [SalesDataShipmentItemCreationInterface](docs/Model/SalesDataShipmentItemCreationInterface.md)
- [SalesDataShipmentItemInterface](docs/Model/SalesDataShipmentItemInterface.md)
- [SalesDataShipmentPackageCreationInterface](docs/Model/SalesDataShipmentPackageCreationInterface.md)
- [SalesDataShipmentPackageInterface](docs/Model/SalesDataShipmentPackageInterface.md)
- [SalesDataShipmentSearchResultInterface](docs/Model/SalesDataShipmentSearchResultInterface.md)
- [SalesDataShipmentTrackCreationInterface](docs/Model/SalesDataShipmentTrackCreationInterface.md)
- [SalesDataShipmentTrackInterface](docs/Model/SalesDataShipmentTrackInterface.md)
- [SalesDataShippingAssignmentInterface](docs/Model/SalesDataShippingAssignmentInterface.md)
- [SalesDataShippingExtensionInterface](docs/Model/SalesDataShippingExtensionInterface.md)
- [SalesDataShippingInterface](docs/Model/SalesDataShippingInterface.md)
- [SalesDataTotalInterface](docs/Model/SalesDataTotalInterface.md)
- [SalesDataTransactionInterface](docs/Model/SalesDataTransactionInterface.md)
- [SalesDataTransactionSearchResultInterface](docs/Model/SalesDataTransactionSearchResultInterface.md)
- [SalesInvoiceCommentRepositoryV1SavePostRequest](docs/Model/SalesInvoiceCommentRepositoryV1SavePostRequest.md)
- [SalesInvoiceOrderV1ExecutePostRequest](docs/Model/SalesInvoiceOrderV1ExecutePostRequest.md)
- [SalesInvoiceRepositoryV1SavePostRequest](docs/Model/SalesInvoiceRepositoryV1SavePostRequest.md)
- [SalesOrderAddressRepositoryV1SavePutRequest](docs/Model/SalesOrderAddressRepositoryV1SavePutRequest.md)
- [SalesOrderManagementV1AddCommentPostRequest](docs/Model/SalesOrderManagementV1AddCommentPostRequest.md)
- [SalesOrderRepositoryV1SavePutRequest](docs/Model/SalesOrderRepositoryV1SavePutRequest.md)
- [SalesRefundInvoiceV1ExecutePostRequest](docs/Model/SalesRefundInvoiceV1ExecutePostRequest.md)
- [SalesRefundOrderV1ExecutePostRequest](docs/Model/SalesRefundOrderV1ExecutePostRequest.md)
- [SalesRuleCouponManagementV1DeleteByCodesPostRequest](docs/Model/SalesRuleCouponManagementV1DeleteByCodesPostRequest.md)
- [SalesRuleCouponManagementV1DeleteByIdsPostRequest](docs/Model/SalesRuleCouponManagementV1DeleteByIdsPostRequest.md)
- [SalesRuleCouponManagementV1GeneratePostRequest](docs/Model/SalesRuleCouponManagementV1GeneratePostRequest.md)
- [SalesRuleCouponRepositoryV1SavePutRequest](docs/Model/SalesRuleCouponRepositoryV1SavePutRequest.md)
- [SalesRuleDataConditionInterface](docs/Model/SalesRuleDataConditionInterface.md)
- [SalesRuleDataCouponGenerationSpecInterface](docs/Model/SalesRuleDataCouponGenerationSpecInterface.md)
- [SalesRuleDataCouponInterface](docs/Model/SalesRuleDataCouponInterface.md)
- [SalesRuleDataCouponMassDeleteResultInterface](docs/Model/SalesRuleDataCouponMassDeleteResultInterface.md)
- [SalesRuleDataCouponSearchResultInterface](docs/Model/SalesRuleDataCouponSearchResultInterface.md)
- [SalesRuleDataRuleInterface](docs/Model/SalesRuleDataRuleInterface.md)
- [SalesRuleDataRuleLabelInterface](docs/Model/SalesRuleDataRuleLabelInterface.md)
- [SalesRuleDataRuleSearchResultInterface](docs/Model/SalesRuleDataRuleSearchResultInterface.md)
- [SalesRuleRuleRepositoryV1SavePutRequest](docs/Model/SalesRuleRuleRepositoryV1SavePutRequest.md)
- [SalesShipOrderV1ExecutePostRequest](docs/Model/SalesShipOrderV1ExecutePostRequest.md)
- [SalesShipmentCommentRepositoryV1SavePostRequest](docs/Model/SalesShipmentCommentRepositoryV1SavePostRequest.md)
- [SalesShipmentRepositoryV1SavePostRequest](docs/Model/SalesShipmentRepositoryV1SavePostRequest.md)
- [SalesShipmentTrackRepositoryV1SavePostRequest](docs/Model/SalesShipmentTrackRepositoryV1SavePostRequest.md)
- [StoreDataGroupInterface](docs/Model/StoreDataGroupInterface.md)
- [StoreDataStoreConfigInterface](docs/Model/StoreDataStoreConfigInterface.md)
- [StoreDataStoreInterface](docs/Model/StoreDataStoreInterface.md)
- [StoreDataWebsiteInterface](docs/Model/StoreDataWebsiteInterface.md)
- [TaxDataAppliedTaxRateInterface](docs/Model/TaxDataAppliedTaxRateInterface.md)
- [TaxDataGrandTotalDetailsInterface](docs/Model/TaxDataGrandTotalDetailsInterface.md)
- [TaxDataGrandTotalRatesInterface](docs/Model/TaxDataGrandTotalRatesInterface.md)
- [TaxDataOrderTaxDetailsAppliedTaxExtensionInterface](docs/Model/TaxDataOrderTaxDetailsAppliedTaxExtensionInterface.md)
- [TaxDataOrderTaxDetailsAppliedTaxInterface](docs/Model/TaxDataOrderTaxDetailsAppliedTaxInterface.md)
- [TaxDataOrderTaxDetailsItemInterface](docs/Model/TaxDataOrderTaxDetailsItemInterface.md)
- [TaxDataTaxClassInterface](docs/Model/TaxDataTaxClassInterface.md)
- [TaxDataTaxClassSearchResultsInterface](docs/Model/TaxDataTaxClassSearchResultsInterface.md)
- [TaxDataTaxRateInterface](docs/Model/TaxDataTaxRateInterface.md)
- [TaxDataTaxRateSearchResultsInterface](docs/Model/TaxDataTaxRateSearchResultsInterface.md)
- [TaxDataTaxRateTitleInterface](docs/Model/TaxDataTaxRateTitleInterface.md)
- [TaxDataTaxRuleInterface](docs/Model/TaxDataTaxRuleInterface.md)
- [TaxDataTaxRuleSearchResultsInterface](docs/Model/TaxDataTaxRuleSearchResultsInterface.md)
- [TaxTaxClassRepositoryV1SavePostRequest](docs/Model/TaxTaxClassRepositoryV1SavePostRequest.md)
- [TaxTaxRateRepositoryV1SavePutRequest](docs/Model/TaxTaxRateRepositoryV1SavePutRequest.md)
- [TaxTaxRuleRepositoryV1SavePutRequest](docs/Model/TaxTaxRuleRepositoryV1SavePutRequest.md)
- [TemandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPutRequest](docs/Model/TemandoShippingCheckoutGuestCartCollectionPointManagementV1SaveSearchRequestPutRequest.md)
- [TemandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPostRequest](docs/Model/TemandoShippingCheckoutGuestCartCollectionPointManagementV1SelectCollectionPointPostRequest.md)
- [TemandoShippingCheckoutGuestCartPickupLocationManagementV1SelectPickupLocationPostRequest](docs/Model/TemandoShippingCheckoutGuestCartPickupLocationManagementV1SelectPickupLocationPostRequest.md)
- [TemandoShippingDataDeliveryCollectionPointSearchRequestInterface](docs/Model/TemandoShippingDataDeliveryCollectionPointSearchRequestInterface.md)
- [TemandoShippingDataDeliveryOrderCollectionPointInterface](docs/Model/TemandoShippingDataDeliveryOrderCollectionPointInterface.md)
- [TemandoShippingDataDeliveryQuoteCollectionPointInterface](docs/Model/TemandoShippingDataDeliveryQuoteCollectionPointInterface.md)
- [TemandoShippingDataOrderShippingExperienceInterface](docs/Model/TemandoShippingDataOrderShippingExperienceInterface.md)
- [TemandoShippingDeliveryGuestCartCollectionPointManagementV1SelectCollectionPointPostRequest](docs/Model/TemandoShippingDeliveryGuestCartCollectionPointManagementV1SelectCollectionPointPostRequest.md)
- [TemandoShippingQuoteCartDeliveryOptionManagementV1SavePostRequest](docs/Model/TemandoShippingQuoteCartDeliveryOptionManagementV1SavePostRequest.md)
- [TemandoShippingQuoteGuestCartCheckoutFieldManagementV1SaveCheckoutFieldsPostRequest](docs/Model/TemandoShippingQuoteGuestCartCheckoutFieldManagementV1SaveCheckoutFieldsPostRequest.md)
- [TemandoShippingRmaRmaShipmentManagementV1AssignShipmentIdsPutRequest](docs/Model/TemandoShippingRmaRmaShipmentManagementV1AssignShipmentIdsPutRequest.md)
- [VaultDataPaymentTokenInterface](docs/Model/VaultDataPaymentTokenInterface.md)
- [WeeeDataProductRenderWeeeAdjustmentAttributeInterface](docs/Model/WeeeDataProductRenderWeeeAdjustmentAttributeInterface.md)

## Authorization
All endpoints do not require authorization.
## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `2.3`
    - Package version: `2.3`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
