#!/bin/bash

wget  https://raw.githubusercontent.com/LinnSystems/PublicApiSpecs/refs/heads/main/1.0/auth.json
wget https://raw.githubusercontent.com/LinnSystems/PublicApiSpecs/refs/heads/main/1.0/inventory.json
wget https://raw.githubusercontent.com/LinnSystems/PublicApiSpecs/refs/heads/main/1.0/openorders.json
wget https://raw.githubusercontent.com/LinnSystems/PublicApiSpecs/refs/heads/main/1.0/orders.json
wget https://raw.githubusercontent.com/LinnSystems/PublicApiSpecs/refs/heads/main/2.0/orders-v2.json
wget https://raw.githubusercontent.com/LinnSystems/PublicApiSpecs/refs/heads/main/1.0/returnsrefunds.json
wget https://raw.githubusercontent.com/LinnSystems/PublicApiSpecs/refs/heads/main/1.0/settings.json

docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/auth.json -c /local/swagger/config-auth.json -g php -o /local/Auth
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/inventory.json -c /local/swagger/config-inventory.json -g php -o /local/Inventory
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/openorders.json -c /local/swagger/config-openorders.json -g php -o /local/OpenOrders
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/orders.json -c /local/swagger/config-orders.json -g php -o /local/Orders
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/orders-v2.json -c /local/swagger/config-orders-v2.json -g php -o /local/OrdersV2
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/processedorders.json -c /local/swagger/config-processedorders.json -g php -o /local/ProcessedOrders
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/returnsrefunds.json -c /local/swagger/config-returnsrefunds.json -g php -o /local/ReturnsRefunds
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/settings.json -c /local/swagger/config-settings.json -g php -o /local/Settings
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/stock.json -c /local/swagger/config-stock.json -g php -o /local/Stock
docker run --rm -v "D:\linnworks:/local" openapitools/openapi-generator-cli:v7.11.0 generate -i /local/swagger/channel.json -c /local/swagger/config-channel.json -g php -o /local/Channel