<?php
/**
 * WarehouseBinRackType
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * WarehouseBinRackType Class Doc Comment
 *
 * @category Class
 * @description Bin Rack Type
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class WarehouseBinRackType implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WarehouseBinRackType';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'bin_rack_type_id' => 'int',
        'name' => 'string',
        'standard_type' => 'int',
        'location_bound' => 'string',
        'is_volumetric' => 'bool',
        'default_batch_status' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'bin_rack_type_id' => 'int32',
        'name' => null,
        'standard_type' => 'int32',
        'location_bound' => 'uuid',
        'is_volumetric' => null,
        'default_batch_status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'bin_rack_type_id' => false,
        'name' => false,
        'standard_type' => false,
        'location_bound' => false,
        'is_volumetric' => false,
        'default_batch_status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bin_rack_type_id' => 'BinRackTypeId',
        'name' => 'Name',
        'standard_type' => 'StandardType',
        'location_bound' => 'LocationBound',
        'is_volumetric' => 'IsVolumetric',
        'default_batch_status' => 'DefaultBatchStatus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bin_rack_type_id' => 'setBinRackTypeId',
        'name' => 'setName',
        'standard_type' => 'setStandardType',
        'location_bound' => 'setLocationBound',
        'is_volumetric' => 'setIsVolumetric',
        'default_batch_status' => 'setDefaultBatchStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bin_rack_type_id' => 'getBinRackTypeId',
        'name' => 'getName',
        'standard_type' => 'getStandardType',
        'location_bound' => 'getLocationBound',
        'is_volumetric' => 'getIsVolumetric',
        'default_batch_status' => 'getDefaultBatchStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DEFAULT_BATCH_STATUS_UNCHANGED = 'Unchanged';
    public const DEFAULT_BATCH_STATUS_AVAILABLE = 'Available';
    public const DEFAULT_BATCH_STATUS_RESTRICTED = 'Restricted';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDefaultBatchStatusAllowableValues()
    {
        return [
            self::DEFAULT_BATCH_STATUS_UNCHANGED,
            self::DEFAULT_BATCH_STATUS_AVAILABLE,
            self::DEFAULT_BATCH_STATUS_RESTRICTED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('bin_rack_type_id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('standard_type', $data ?? [], null);
        $this->setIfExists('location_bound', $data ?? [], null);
        $this->setIfExists('is_volumetric', $data ?? [], null);
        $this->setIfExists('default_batch_status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getDefaultBatchStatusAllowableValues();
        if (!is_null($this->container['default_batch_status']) && !in_array($this->container['default_batch_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'default_batch_status', must be one of '%s'",
                $this->container['default_batch_status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bin_rack_type_id
     *
     * @return int|null
     */
    public function getBinRackTypeId()
    {
        return $this->container['bin_rack_type_id'];
    }

    /**
     * Sets bin_rack_type_id
     *
     * @param int|null $bin_rack_type_id Binrack type id - unique record identifier
     *
     * @return self
     */
    public function setBinRackTypeId($bin_rack_type_id)
    {
        if (is_null($bin_rack_type_id)) {
            throw new \InvalidArgumentException('non-nullable bin_rack_type_id cannot be null');
        }
        $this->container['bin_rack_type_id'] = $bin_rack_type_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Custom name for bin rack type
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets standard_type
     *
     * @return int|null
     */
    public function getStandardType()
    {
        return $this->container['standard_type'];
    }

    /**
     * Sets standard_type
     *
     * @param int|null $standard_type Binrack Standard Type  Id   1 - Picking  2 - Special Access Picking  3 - Storage  4 - Deep Storage  5 - Putaway  6 - Quality Assurance  7 - Scrap / Quarantine  8 - Returns  0 - Flexible
     *
     * @return self
     */
    public function setStandardType($standard_type)
    {
        if (is_null($standard_type)) {
            throw new \InvalidArgumentException('non-nullable standard_type cannot be null');
        }
        $this->container['standard_type'] = $standard_type;

        return $this;
    }

    /**
     * Gets location_bound
     *
     * @return string|null
     */
    public function getLocationBound()
    {
        return $this->container['location_bound'];
    }

    /**
     * Sets location_bound
     *
     * @param string|null $location_bound Identifies whether the bin rack type is bound to a specific location
     *
     * @return self
     */
    public function setLocationBound($location_bound)
    {
        if (is_null($location_bound)) {
            throw new \InvalidArgumentException('non-nullable location_bound cannot be null');
        }
        $this->container['location_bound'] = $location_bound;

        return $this;
    }

    /**
     * Gets is_volumetric
     *
     * @return bool|null
     */
    public function getIsVolumetric()
    {
        return $this->container['is_volumetric'];
    }

    /**
     * Sets is_volumetric
     *
     * @param bool|null $is_volumetric Is type restricted to volumetric measurements only
     *
     * @return self
     */
    public function setIsVolumetric($is_volumetric)
    {
        if (is_null($is_volumetric)) {
            throw new \InvalidArgumentException('non-nullable is_volumetric cannot be null');
        }
        $this->container['is_volumetric'] = $is_volumetric;

        return $this;
    }

    /**
     * Gets default_batch_status
     *
     * @return string|null
     */
    public function getDefaultBatchStatus()
    {
        return $this->container['default_batch_status'];
    }

    /**
     * Sets default_batch_status
     *
     * @param string|null $default_batch_status Sets the default status for batches in this binrack type
     *
     * @return self
     */
    public function setDefaultBatchStatus($default_batch_status)
    {
        if (is_null($default_batch_status)) {
            throw new \InvalidArgumentException('non-nullable default_batch_status cannot be null');
        }
        $allowedValues = $this->getDefaultBatchStatusAllowableValues();
        if (!in_array($default_batch_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'default_batch_status', must be one of '%s'",
                    $default_batch_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['default_batch_status'] = $default_batch_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


