<?php
/**
 * WarehouseBinRack
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * WarehouseBinRack Class Doc Comment
 *
 * @category Class
 * @description Warehouse binrack
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class WarehouseBinRack implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'WarehouseBinRack';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'bin_rack_id' => 'int',
        'bin_rack_type_id' => 'int',
        'bin_rack' => 'string',
        'geo_position' => '\Linnworks\Stock\Model\GeoPosition',
        'dimension' => '\Linnworks\Stock\Model\Dimension',
        'routing_sequence' => 'int',
        'max_capacity_volumetric' => 'float',
        'current_full_percentage' => 'float',
        'max_quantity_capacity' => 'int',
        'current_quantity' => 'int',
        'current_volumetric' => 'float',
        'optimal_replenish_full_percentage' => 'float',
        'critical_replenish_full_percentage' => 'float',
        'item_restriction' => 'bool',
        'group_restriction' => 'bool',
        'location_id' => 'string',
        'type_name' => 'string',
        'standard_type' => 'int',
        'is_volumetric' => 'bool',
        'access_orientation' => 'string',
        'storage_groups' => 'string[]',
        'unique_skus' => 'int',
        'items_info' => '\Linnworks\Stock\Model\WarehouseBinRackItemsInfo',
        'binrack_type' => '\Linnworks\Stock\Model\WarehouseBinRackType',
        'is_valid_for_stock_item' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'bin_rack_id' => 'int32',
        'bin_rack_type_id' => 'int32',
        'bin_rack' => null,
        'geo_position' => null,
        'dimension' => null,
        'routing_sequence' => 'int32',
        'max_capacity_volumetric' => 'double',
        'current_full_percentage' => 'double',
        'max_quantity_capacity' => 'int32',
        'current_quantity' => 'int32',
        'current_volumetric' => 'double',
        'optimal_replenish_full_percentage' => 'double',
        'critical_replenish_full_percentage' => 'double',
        'item_restriction' => null,
        'group_restriction' => null,
        'location_id' => 'uuid',
        'type_name' => null,
        'standard_type' => 'int32',
        'is_volumetric' => null,
        'access_orientation' => null,
        'storage_groups' => null,
        'unique_skus' => 'int32',
        'items_info' => null,
        'binrack_type' => null,
        'is_valid_for_stock_item' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'bin_rack_id' => false,
        'bin_rack_type_id' => false,
        'bin_rack' => false,
        'geo_position' => false,
        'dimension' => false,
        'routing_sequence' => false,
        'max_capacity_volumetric' => false,
        'current_full_percentage' => false,
        'max_quantity_capacity' => false,
        'current_quantity' => false,
        'current_volumetric' => false,
        'optimal_replenish_full_percentage' => false,
        'critical_replenish_full_percentage' => false,
        'item_restriction' => false,
        'group_restriction' => false,
        'location_id' => false,
        'type_name' => false,
        'standard_type' => false,
        'is_volumetric' => false,
        'access_orientation' => false,
        'storage_groups' => false,
        'unique_skus' => false,
        'items_info' => false,
        'binrack_type' => false,
        'is_valid_for_stock_item' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bin_rack_id' => 'BinRackId',
        'bin_rack_type_id' => 'BinRackTypeId',
        'bin_rack' => 'BinRack',
        'geo_position' => 'GeoPosition',
        'dimension' => 'Dimension',
        'routing_sequence' => 'RoutingSequence',
        'max_capacity_volumetric' => 'MaxCapacityVolumetric',
        'current_full_percentage' => 'CurrentFullPercentage',
        'max_quantity_capacity' => 'MaxQuantityCapacity',
        'current_quantity' => 'CurrentQuantity',
        'current_volumetric' => 'CurrentVolumetric',
        'optimal_replenish_full_percentage' => 'OptimalReplenishFullPercentage',
        'critical_replenish_full_percentage' => 'CriticalReplenishFullPercentage',
        'item_restriction' => 'ItemRestriction',
        'group_restriction' => 'GroupRestriction',
        'location_id' => 'LocationId',
        'type_name' => 'TypeName',
        'standard_type' => 'StandardType',
        'is_volumetric' => 'IsVolumetric',
        'access_orientation' => 'AccessOrientation',
        'storage_groups' => 'StorageGroups',
        'unique_skus' => 'UniqueSkus',
        'items_info' => 'ItemsInfo',
        'binrack_type' => 'BinrackType',
        'is_valid_for_stock_item' => 'IsValidForStockItem'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bin_rack_id' => 'setBinRackId',
        'bin_rack_type_id' => 'setBinRackTypeId',
        'bin_rack' => 'setBinRack',
        'geo_position' => 'setGeoPosition',
        'dimension' => 'setDimension',
        'routing_sequence' => 'setRoutingSequence',
        'max_capacity_volumetric' => 'setMaxCapacityVolumetric',
        'current_full_percentage' => 'setCurrentFullPercentage',
        'max_quantity_capacity' => 'setMaxQuantityCapacity',
        'current_quantity' => 'setCurrentQuantity',
        'current_volumetric' => 'setCurrentVolumetric',
        'optimal_replenish_full_percentage' => 'setOptimalReplenishFullPercentage',
        'critical_replenish_full_percentage' => 'setCriticalReplenishFullPercentage',
        'item_restriction' => 'setItemRestriction',
        'group_restriction' => 'setGroupRestriction',
        'location_id' => 'setLocationId',
        'type_name' => 'setTypeName',
        'standard_type' => 'setStandardType',
        'is_volumetric' => 'setIsVolumetric',
        'access_orientation' => 'setAccessOrientation',
        'storage_groups' => 'setStorageGroups',
        'unique_skus' => 'setUniqueSkus',
        'items_info' => 'setItemsInfo',
        'binrack_type' => 'setBinrackType',
        'is_valid_for_stock_item' => 'setIsValidForStockItem'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bin_rack_id' => 'getBinRackId',
        'bin_rack_type_id' => 'getBinRackTypeId',
        'bin_rack' => 'getBinRack',
        'geo_position' => 'getGeoPosition',
        'dimension' => 'getDimension',
        'routing_sequence' => 'getRoutingSequence',
        'max_capacity_volumetric' => 'getMaxCapacityVolumetric',
        'current_full_percentage' => 'getCurrentFullPercentage',
        'max_quantity_capacity' => 'getMaxQuantityCapacity',
        'current_quantity' => 'getCurrentQuantity',
        'current_volumetric' => 'getCurrentVolumetric',
        'optimal_replenish_full_percentage' => 'getOptimalReplenishFullPercentage',
        'critical_replenish_full_percentage' => 'getCriticalReplenishFullPercentage',
        'item_restriction' => 'getItemRestriction',
        'group_restriction' => 'getGroupRestriction',
        'location_id' => 'getLocationId',
        'type_name' => 'getTypeName',
        'standard_type' => 'getStandardType',
        'is_volumetric' => 'getIsVolumetric',
        'access_orientation' => 'getAccessOrientation',
        'storage_groups' => 'getStorageGroups',
        'unique_skus' => 'getUniqueSkus',
        'items_info' => 'getItemsInfo',
        'binrack_type' => 'getBinrackType',
        'is_valid_for_stock_item' => 'getIsValidForStockItem'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('bin_rack_id', $data ?? [], null);
        $this->setIfExists('bin_rack_type_id', $data ?? [], null);
        $this->setIfExists('bin_rack', $data ?? [], null);
        $this->setIfExists('geo_position', $data ?? [], null);
        $this->setIfExists('dimension', $data ?? [], null);
        $this->setIfExists('routing_sequence', $data ?? [], null);
        $this->setIfExists('max_capacity_volumetric', $data ?? [], null);
        $this->setIfExists('current_full_percentage', $data ?? [], null);
        $this->setIfExists('max_quantity_capacity', $data ?? [], null);
        $this->setIfExists('current_quantity', $data ?? [], null);
        $this->setIfExists('current_volumetric', $data ?? [], null);
        $this->setIfExists('optimal_replenish_full_percentage', $data ?? [], null);
        $this->setIfExists('critical_replenish_full_percentage', $data ?? [], null);
        $this->setIfExists('item_restriction', $data ?? [], null);
        $this->setIfExists('group_restriction', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('type_name', $data ?? [], null);
        $this->setIfExists('standard_type', $data ?? [], null);
        $this->setIfExists('is_volumetric', $data ?? [], null);
        $this->setIfExists('access_orientation', $data ?? [], null);
        $this->setIfExists('storage_groups', $data ?? [], null);
        $this->setIfExists('unique_skus', $data ?? [], null);
        $this->setIfExists('items_info', $data ?? [], null);
        $this->setIfExists('binrack_type', $data ?? [], null);
        $this->setIfExists('is_valid_for_stock_item', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bin_rack_id
     *
     * @return int|null
     */
    public function getBinRackId()
    {
        return $this->container['bin_rack_id'];
    }

    /**
     * Sets bin_rack_id
     *
     * @param int|null $bin_rack_id BinRack internal id
     *
     * @return self
     */
    public function setBinRackId($bin_rack_id)
    {
        if (is_null($bin_rack_id)) {
            throw new \InvalidArgumentException('non-nullable bin_rack_id cannot be null');
        }
        $this->container['bin_rack_id'] = $bin_rack_id;

        return $this;
    }

    /**
     * Gets bin_rack_type_id
     *
     * @return int|null
     */
    public function getBinRackTypeId()
    {
        return $this->container['bin_rack_type_id'];
    }

    /**
     * Sets bin_rack_type_id
     *
     * @param int|null $bin_rack_type_id BinRack type id
     *
     * @return self
     */
    public function setBinRackTypeId($bin_rack_type_id)
    {
        if (is_null($bin_rack_type_id)) {
            throw new \InvalidArgumentException('non-nullable bin_rack_type_id cannot be null');
        }
        $this->container['bin_rack_type_id'] = $bin_rack_type_id;

        return $this;
    }

    /**
     * Gets bin_rack
     *
     * @return string|null
     */
    public function getBinRack()
    {
        return $this->container['bin_rack'];
    }

    /**
     * Sets bin_rack
     *
     * @param string|null $bin_rack BinRack
     *
     * @return self
     */
    public function setBinRack($bin_rack)
    {
        if (is_null($bin_rack)) {
            throw new \InvalidArgumentException('non-nullable bin_rack cannot be null');
        }
        $this->container['bin_rack'] = $bin_rack;

        return $this;
    }

    /**
     * Gets geo_position
     *
     * @return \Linnworks\Stock\Model\GeoPosition|null
     */
    public function getGeoPosition()
    {
        return $this->container['geo_position'];
    }

    /**
     * Sets geo_position
     *
     * @param \Linnworks\Stock\Model\GeoPosition|null $geo_position geo_position
     *
     * @return self
     */
    public function setGeoPosition($geo_position)
    {
        if (is_null($geo_position)) {
            throw new \InvalidArgumentException('non-nullable geo_position cannot be null');
        }
        $this->container['geo_position'] = $geo_position;

        return $this;
    }

    /**
     * Gets dimension
     *
     * @return \Linnworks\Stock\Model\Dimension|null
     */
    public function getDimension()
    {
        return $this->container['dimension'];
    }

    /**
     * Sets dimension
     *
     * @param \Linnworks\Stock\Model\Dimension|null $dimension dimension
     *
     * @return self
     */
    public function setDimension($dimension)
    {
        if (is_null($dimension)) {
            throw new \InvalidArgumentException('non-nullable dimension cannot be null');
        }
        $this->container['dimension'] = $dimension;

        return $this;
    }

    /**
     * Gets routing_sequence
     *
     * @return int|null
     */
    public function getRoutingSequence()
    {
        return $this->container['routing_sequence'];
    }

    /**
     * Sets routing_sequence
     *
     * @param int|null $routing_sequence Sequence in which the picking or stock movement should be done. Routing.
     *
     * @return self
     */
    public function setRoutingSequence($routing_sequence)
    {
        if (is_null($routing_sequence)) {
            throw new \InvalidArgumentException('non-nullable routing_sequence cannot be null');
        }
        $this->container['routing_sequence'] = $routing_sequence;

        return $this;
    }

    /**
     * Gets max_capacity_volumetric
     *
     * @return float|null
     */
    public function getMaxCapacityVolumetric()
    {
        return $this->container['max_capacity_volumetric'];
    }

    /**
     * Sets max_capacity_volumetric
     *
     * @param float|null $max_capacity_volumetric Max capacity volume
     *
     * @return self
     */
    public function setMaxCapacityVolumetric($max_capacity_volumetric)
    {
        if (is_null($max_capacity_volumetric)) {
            throw new \InvalidArgumentException('non-nullable max_capacity_volumetric cannot be null');
        }
        $this->container['max_capacity_volumetric'] = $max_capacity_volumetric;

        return $this;
    }

    /**
     * Gets current_full_percentage
     *
     * @return float|null
     */
    public function getCurrentFullPercentage()
    {
        return $this->container['current_full_percentage'];
    }

    /**
     * Sets current_full_percentage
     *
     * @param float|null $current_full_percentage Maximum volumetric capacity of the location WxDxH = volumetric
     *
     * @return self
     */
    public function setCurrentFullPercentage($current_full_percentage)
    {
        if (is_null($current_full_percentage)) {
            throw new \InvalidArgumentException('non-nullable current_full_percentage cannot be null');
        }
        $this->container['current_full_percentage'] = $current_full_percentage;

        return $this;
    }

    /**
     * Gets max_quantity_capacity
     *
     * @return int|null
     */
    public function getMaxQuantityCapacity()
    {
        return $this->container['max_quantity_capacity'];
    }

    /**
     * Sets max_quantity_capacity
     *
     * @param int|null $max_quantity_capacity How full the bin rack is in percentage 0 to 100, based on the max quantity or max volumetric capacity. Updated everytime stock is moved in or out.
     *
     * @return self
     */
    public function setMaxQuantityCapacity($max_quantity_capacity)
    {
        if (is_null($max_quantity_capacity)) {
            throw new \InvalidArgumentException('non-nullable max_quantity_capacity cannot be null');
        }
        $this->container['max_quantity_capacity'] = $max_quantity_capacity;

        return $this;
    }

    /**
     * Gets current_quantity
     *
     * @return int|null
     */
    public function getCurrentQuantity()
    {
        return $this->container['current_quantity'];
    }

    /**
     * Sets current_quantity
     *
     * @param int|null $current_quantity Current total quantity of all items in the bin rack. Updated everytime stock is moved in or out.
     *
     * @return self
     */
    public function setCurrentQuantity($current_quantity)
    {
        if (is_null($current_quantity)) {
            throw new \InvalidArgumentException('non-nullable current_quantity cannot be null');
        }
        $this->container['current_quantity'] = $current_quantity;

        return $this;
    }

    /**
     * Gets current_volumetric
     *
     * @return float|null
     */
    public function getCurrentVolumetric()
    {
        return $this->container['current_volumetric'];
    }

    /**
     * Sets current_volumetric
     *
     * @param float|null $current_volumetric Current calculation of total volumetric total for all items in the binrack. Updated everytime stock is moved in or out.
     *
     * @return self
     */
    public function setCurrentVolumetric($current_volumetric)
    {
        if (is_null($current_volumetric)) {
            throw new \InvalidArgumentException('non-nullable current_volumetric cannot be null');
        }
        $this->container['current_volumetric'] = $current_volumetric;

        return $this;
    }

    /**
     * Gets optimal_replenish_full_percentage
     *
     * @return float|null
     */
    public function getOptimalReplenishFullPercentage()
    {
        return $this->container['optimal_replenish_full_percentage'];
    }

    /**
     * Sets optimal_replenish_full_percentage
     *
     * @param float|null $optimal_replenish_full_percentage Based on the fill percentage, indicates the bin rack as needs replenishment. Auto recalculated based on the consumption.
     *
     * @return self
     */
    public function setOptimalReplenishFullPercentage($optimal_replenish_full_percentage)
    {
        if (is_null($optimal_replenish_full_percentage)) {
            throw new \InvalidArgumentException('non-nullable optimal_replenish_full_percentage cannot be null');
        }
        $this->container['optimal_replenish_full_percentage'] = $optimal_replenish_full_percentage;

        return $this;
    }

    /**
     * Gets critical_replenish_full_percentage
     *
     * @return float|null
     */
    public function getCriticalReplenishFullPercentage()
    {
        return $this->container['critical_replenish_full_percentage'];
    }

    /**
     * Sets critical_replenish_full_percentage
     *
     * @param float|null $critical_replenish_full_percentage User fixed fill percentage. When it reaches this level the binrack is considered for replenishment.
     *
     * @return self
     */
    public function setCriticalReplenishFullPercentage($critical_replenish_full_percentage)
    {
        if (is_null($critical_replenish_full_percentage)) {
            throw new \InvalidArgumentException('non-nullable critical_replenish_full_percentage cannot be null');
        }
        $this->container['critical_replenish_full_percentage'] = $critical_replenish_full_percentage;

        return $this;
    }

    /**
     * Gets item_restriction
     *
     * @return bool|null
     */
    public function getItemRestriction()
    {
        return $this->container['item_restriction'];
    }

    /**
     * Sets item_restriction
     *
     * @param bool|null $item_restriction Item Restriction
     *
     * @return self
     */
    public function setItemRestriction($item_restriction)
    {
        if (is_null($item_restriction)) {
            throw new \InvalidArgumentException('non-nullable item_restriction cannot be null');
        }
        $this->container['item_restriction'] = $item_restriction;

        return $this;
    }

    /**
     * Gets group_restriction
     *
     * @return bool|null
     */
    public function getGroupRestriction()
    {
        return $this->container['group_restriction'];
    }

    /**
     * Sets group_restriction
     *
     * @param bool|null $group_restriction Group Restriction
     *
     * @return self
     */
    public function setGroupRestriction($group_restriction)
    {
        if (is_null($group_restriction)) {
            throw new \InvalidArgumentException('non-nullable group_restriction cannot be null');
        }
        $this->container['group_restriction'] = $group_restriction;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param string|null $location_id Location of the binrack.
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets type_name
     *
     * @return string|null
     */
    public function getTypeName()
    {
        return $this->container['type_name'];
    }

    /**
     * Sets type_name
     *
     * @param string|null $type_name Readonly value of the TypeName loaded from BinRackTypeId
     *
     * @return self
     */
    public function setTypeName($type_name)
    {
        if (is_null($type_name)) {
            throw new \InvalidArgumentException('non-nullable type_name cannot be null');
        }
        $this->container['type_name'] = $type_name;

        return $this;
    }

    /**
     * Gets standard_type
     *
     * @return int|null
     */
    public function getStandardType()
    {
        return $this->container['standard_type'];
    }

    /**
     * Sets standard_type
     *
     * @param int|null $standard_type Readonly value of the Standard type loaded from BinRackTypeId
     *
     * @return self
     */
    public function setStandardType($standard_type)
    {
        if (is_null($standard_type)) {
            throw new \InvalidArgumentException('non-nullable standard_type cannot be null');
        }
        $this->container['standard_type'] = $standard_type;

        return $this;
    }

    /**
     * Gets is_volumetric
     *
     * @return bool|null
     */
    public function getIsVolumetric()
    {
        return $this->container['is_volumetric'];
    }

    /**
     * Sets is_volumetric
     *
     * @param bool|null $is_volumetric Readonly value indicates if the Type is Volumumetric
     *
     * @return self
     */
    public function setIsVolumetric($is_volumetric)
    {
        if (is_null($is_volumetric)) {
            throw new \InvalidArgumentException('non-nullable is_volumetric cannot be null');
        }
        $this->container['is_volumetric'] = $is_volumetric;

        return $this;
    }

    /**
     * Gets access_orientation
     *
     * @return string|null
     */
    public function getAccessOrientation()
    {
        return $this->container['access_orientation'];
    }

    /**
     * Sets access_orientation
     *
     * @param string|null $access_orientation Direction the item should be accessed from.
     *
     * @return self
     */
    public function setAccessOrientation($access_orientation)
    {
        if (is_null($access_orientation)) {
            throw new \InvalidArgumentException('non-nullable access_orientation cannot be null');
        }
        $this->container['access_orientation'] = $access_orientation;

        return $this;
    }

    /**
     * Gets storage_groups
     *
     * @return string[]|null
     */
    public function getStorageGroups()
    {
        return $this->container['storage_groups'];
    }

    /**
     * Sets storage_groups
     *
     * @param string[]|null $storage_groups List of storage groups either for the whole binrack or relevant to specific stock item.
     *
     * @return self
     */
    public function setStorageGroups($storage_groups)
    {
        if (is_null($storage_groups)) {
            throw new \InvalidArgumentException('non-nullable storage_groups cannot be null');
        }
        $this->container['storage_groups'] = $storage_groups;

        return $this;
    }

    /**
     * Gets unique_skus
     *
     * @return int|null
     */
    public function getUniqueSkus()
    {
        return $this->container['unique_skus'];
    }

    /**
     * Sets unique_skus
     *
     * @param int|null $unique_skus Unique skus in binrack.
     *
     * @return self
     */
    public function setUniqueSkus($unique_skus)
    {
        if (is_null($unique_skus)) {
            throw new \InvalidArgumentException('non-nullable unique_skus cannot be null');
        }
        $this->container['unique_skus'] = $unique_skus;

        return $this;
    }

    /**
     * Gets items_info
     *
     * @return \Linnworks\Stock\Model\WarehouseBinRackItemsInfo|null
     */
    public function getItemsInfo()
    {
        return $this->container['items_info'];
    }

    /**
     * Sets items_info
     *
     * @param \Linnworks\Stock\Model\WarehouseBinRackItemsInfo|null $items_info items_info
     *
     * @return self
     */
    public function setItemsInfo($items_info)
    {
        if (is_null($items_info)) {
            throw new \InvalidArgumentException('non-nullable items_info cannot be null');
        }
        $this->container['items_info'] = $items_info;

        return $this;
    }

    /**
     * Gets binrack_type
     *
     * @return \Linnworks\Stock\Model\WarehouseBinRackType|null
     */
    public function getBinrackType()
    {
        return $this->container['binrack_type'];
    }

    /**
     * Sets binrack_type
     *
     * @param \Linnworks\Stock\Model\WarehouseBinRackType|null $binrack_type binrack_type
     *
     * @return self
     */
    public function setBinrackType($binrack_type)
    {
        if (is_null($binrack_type)) {
            throw new \InvalidArgumentException('non-nullable binrack_type cannot be null');
        }
        $this->container['binrack_type'] = $binrack_type;

        return $this;
    }

    /**
     * Gets is_valid_for_stock_item
     *
     * @return bool|null
     */
    public function getIsValidForStockItem()
    {
        return $this->container['is_valid_for_stock_item'];
    }

    /**
     * Sets is_valid_for_stock_item
     *
     * @param bool|null $is_valid_for_stock_item Indicates if the binrack is valid for the supplied stockitem.
     *
     * @return self
     */
    public function setIsValidForStockItem($is_valid_for_stock_item)
    {
        if (is_null($is_valid_for_stock_item)) {
            throw new \InvalidArgumentException('non-nullable is_valid_for_stock_item cannot be null');
        }
        $this->container['is_valid_for_stock_item'] = $is_valid_for_stock_item;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


