<?php
/**
 * VariationItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * VariationItem Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class VariationItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'VariationItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_row_id' => 'string',
        'pk_stock_item_id' => 'string',
        'item_number' => 'string',
        'item_title' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_row_id' => 'uuid',
        'pk_stock_item_id' => 'uuid',
        'item_number' => null,
        'item_title' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_row_id' => false,
        'pk_stock_item_id' => false,
        'item_number' => false,
        'item_title' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_row_id' => 'pkRowId',
        'pk_stock_item_id' => 'pkStockItemId',
        'item_number' => 'ItemNumber',
        'item_title' => 'ItemTitle'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_row_id' => 'setPkRowId',
        'pk_stock_item_id' => 'setPkStockItemId',
        'item_number' => 'setItemNumber',
        'item_title' => 'setItemTitle'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_row_id' => 'getPkRowId',
        'pk_stock_item_id' => 'getPkStockItemId',
        'item_number' => 'getItemNumber',
        'item_title' => 'getItemTitle'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_row_id', $data ?? [], null);
        $this->setIfExists('pk_stock_item_id', $data ?? [], null);
        $this->setIfExists('item_number', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_row_id
     *
     * @return string|null
     */
    public function getPkRowId()
    {
        return $this->container['pk_row_id'];
    }

    /**
     * Sets pk_row_id
     *
     * @param string|null $pk_row_id Variation item record ID
     *
     * @return self
     */
    public function setPkRowId($pk_row_id)
    {
        if (is_null($pk_row_id)) {
            throw new \InvalidArgumentException('non-nullable pk_row_id cannot be null');
        }
        $this->container['pk_row_id'] = $pk_row_id;

        return $this;
    }

    /**
     * Gets pk_stock_item_id
     *
     * @return string|null
     */
    public function getPkStockItemId()
    {
        return $this->container['pk_stock_item_id'];
    }

    /**
     * Sets pk_stock_item_id
     *
     * @param string|null $pk_stock_item_id Stock item ID (unique identifier)
     *
     * @return self
     */
    public function setPkStockItemId($pk_stock_item_id)
    {
        if (is_null($pk_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable pk_stock_item_id cannot be null');
        }
        $this->container['pk_stock_item_id'] = $pk_stock_item_id;

        return $this;
    }

    /**
     * Gets item_number
     *
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->container['item_number'];
    }

    /**
     * Sets item_number
     *
     * @param string|null $item_number Item SKU
     *
     * @return self
     */
    public function setItemNumber($item_number)
    {
        if (is_null($item_number)) {
            throw new \InvalidArgumentException('non-nullable item_number cannot be null');
        }
        $this->container['item_number'] = $item_number;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title Item title
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


