<?php
/**
 * VariationGroupTemplate
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * VariationGroupTemplate Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class VariationGroupTemplate implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'VariationGroupTemplate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'variation_group_name' => 'string',
        'parent_sku' => 'string',
        'parent_stock_item_id' => 'string',
        'variation_item_ids' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'variation_group_name' => null,
        'parent_sku' => null,
        'parent_stock_item_id' => 'uuid',
        'variation_item_ids' => 'uuid'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'variation_group_name' => false,
        'parent_sku' => false,
        'parent_stock_item_id' => false,
        'variation_item_ids' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'variation_group_name' => 'VariationGroupName',
        'parent_sku' => 'ParentSKU',
        'parent_stock_item_id' => 'ParentStockItemId',
        'variation_item_ids' => 'VariationItemIds'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'variation_group_name' => 'setVariationGroupName',
        'parent_sku' => 'setParentSku',
        'parent_stock_item_id' => 'setParentStockItemId',
        'variation_item_ids' => 'setVariationItemIds'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'variation_group_name' => 'getVariationGroupName',
        'parent_sku' => 'getParentSku',
        'parent_stock_item_id' => 'getParentStockItemId',
        'variation_item_ids' => 'getVariationItemIds'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('variation_group_name', $data ?? [], null);
        $this->setIfExists('parent_sku', $data ?? [], null);
        $this->setIfExists('parent_stock_item_id', $data ?? [], null);
        $this->setIfExists('variation_item_ids', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets variation_group_name
     *
     * @return string|null
     */
    public function getVariationGroupName()
    {
        return $this->container['variation_group_name'];
    }

    /**
     * Sets variation_group_name
     *
     * @param string|null $variation_group_name Variation parent title
     *
     * @return self
     */
    public function setVariationGroupName($variation_group_name)
    {
        if (is_null($variation_group_name)) {
            throw new \InvalidArgumentException('non-nullable variation_group_name cannot be null');
        }
        $this->container['variation_group_name'] = $variation_group_name;

        return $this;
    }

    /**
     * Gets parent_sku
     *
     * @return string|null
     */
    public function getParentSku()
    {
        return $this->container['parent_sku'];
    }

    /**
     * Sets parent_sku
     *
     * @param string|null $parent_sku Variation parent SKU
     *
     * @return self
     */
    public function setParentSku($parent_sku)
    {
        if (is_null($parent_sku)) {
            throw new \InvalidArgumentException('non-nullable parent_sku cannot be null');
        }
        $this->container['parent_sku'] = $parent_sku;

        return $this;
    }

    /**
     * Gets parent_stock_item_id
     *
     * @return string|null
     */
    public function getParentStockItemId()
    {
        return $this->container['parent_stock_item_id'];
    }

    /**
     * Sets parent_stock_item_id
     *
     * @param string|null $parent_stock_item_id Variation parent stock item id
     *
     * @return self
     */
    public function setParentStockItemId($parent_stock_item_id)
    {
        if (is_null($parent_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable parent_stock_item_id cannot be null');
        }
        $this->container['parent_stock_item_id'] = $parent_stock_item_id;

        return $this;
    }

    /**
     * Gets variation_item_ids
     *
     * @return string[]|null
     */
    public function getVariationItemIds()
    {
        return $this->container['variation_item_ids'];
    }

    /**
     * Sets variation_item_ids
     *
     * @param string[]|null $variation_item_ids List of variation children
     *
     * @return self
     */
    public function setVariationItemIds($variation_item_ids)
    {
        if (is_null($variation_item_ids)) {
            throw new \InvalidArgumentException('non-nullable variation_item_ids cannot be null');
        }
        $this->container['variation_item_ids'] = $variation_item_ids;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


