<?php
/**
 * UpdateWarehouseMoveRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * UpdateWarehouseMoveRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateWarehouseMoveRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdateWarehouseMoveRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'move_id' => 'int',
        'batch_inventory_id' => 'int',
        'quantity' => 'int',
        'binrack_id_destination' => 'int',
        'job_id' => 'int',
        'tot_id' => 'int',
        'tx_type' => 'string',
        'user_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'move_id' => 'int32',
        'batch_inventory_id' => 'int32',
        'quantity' => 'int32',
        'binrack_id_destination' => 'int32',
        'job_id' => 'int32',
        'tot_id' => 'int32',
        'tx_type' => null,
        'user_id' => 'uuid'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'move_id' => false,
        'batch_inventory_id' => false,
        'quantity' => false,
        'binrack_id_destination' => false,
        'job_id' => false,
        'tot_id' => false,
        'tx_type' => false,
        'user_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'move_id' => 'MoveId',
        'batch_inventory_id' => 'BatchInventoryId',
        'quantity' => 'Quantity',
        'binrack_id_destination' => 'BinrackIdDestination',
        'job_id' => 'JobId',
        'tot_id' => 'TotId',
        'tx_type' => 'TxType',
        'user_id' => 'UserId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'move_id' => 'setMoveId',
        'batch_inventory_id' => 'setBatchInventoryId',
        'quantity' => 'setQuantity',
        'binrack_id_destination' => 'setBinrackIdDestination',
        'job_id' => 'setJobId',
        'tot_id' => 'setTotId',
        'tx_type' => 'setTxType',
        'user_id' => 'setUserId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'move_id' => 'getMoveId',
        'batch_inventory_id' => 'getBatchInventoryId',
        'quantity' => 'getQuantity',
        'binrack_id_destination' => 'getBinrackIdDestination',
        'job_id' => 'getJobId',
        'tot_id' => 'getTotId',
        'tx_type' => 'getTxType',
        'user_id' => 'getUserId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const TX_TYPE_OPEN = 'Open';
    public const TX_TYPE_IN_TRANSIT = 'InTransit';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTxTypeAllowableValues()
    {
        return [
            self::TX_TYPE_OPEN,
            self::TX_TYPE_IN_TRANSIT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('move_id', $data ?? [], null);
        $this->setIfExists('batch_inventory_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('binrack_id_destination', $data ?? [], null);
        $this->setIfExists('job_id', $data ?? [], null);
        $this->setIfExists('tot_id', $data ?? [], null);
        $this->setIfExists('tx_type', $data ?? [], null);
        $this->setIfExists('user_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTxTypeAllowableValues();
        if (!is_null($this->container['tx_type']) && !in_array($this->container['tx_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'tx_type', must be one of '%s'",
                $this->container['tx_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets move_id
     *
     * @return int|null
     */
    public function getMoveId()
    {
        return $this->container['move_id'];
    }

    /**
     * Sets move_id
     *
     * @param int|null $move_id The Id of the stock move to update
     *
     * @return self
     */
    public function setMoveId($move_id)
    {
        if (is_null($move_id)) {
            throw new \InvalidArgumentException('non-nullable move_id cannot be null');
        }
        $this->container['move_id'] = $move_id;

        return $this;
    }

    /**
     * Gets batch_inventory_id
     *
     * @return int|null
     */
    public function getBatchInventoryId()
    {
        return $this->container['batch_inventory_id'];
    }

    /**
     * Sets batch_inventory_id
     *
     * @param int|null $batch_inventory_id Batch Inventory Id of the stock item you are moving
     *
     * @return self
     */
    public function setBatchInventoryId($batch_inventory_id)
    {
        if (is_null($batch_inventory_id)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory_id cannot be null');
        }
        $this->container['batch_inventory_id'] = $batch_inventory_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity of items being moved
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets binrack_id_destination
     *
     * @return int|null
     */
    public function getBinrackIdDestination()
    {
        return $this->container['binrack_id_destination'];
    }

    /**
     * Sets binrack_id_destination
     *
     * @param int|null $binrack_id_destination Destination if known, can be null
     *
     * @return self
     */
    public function setBinrackIdDestination($binrack_id_destination)
    {
        if (is_null($binrack_id_destination)) {
            throw new \InvalidArgumentException('non-nullable binrack_id_destination cannot be null');
        }
        $this->container['binrack_id_destination'] = $binrack_id_destination;

        return $this;
    }

    /**
     * Gets job_id
     *
     * @return int|null
     */
    public function getJobId()
    {
        return $this->container['job_id'];
    }

    /**
     * Sets job_id
     *
     * @param int|null $job_id If the move is part of a specific job, specify job id so it can be marked off from the job
     *
     * @return self
     */
    public function setJobId($job_id)
    {
        if (is_null($job_id)) {
            throw new \InvalidArgumentException('non-nullable job_id cannot be null');
        }
        $this->container['job_id'] = $job_id;

        return $this;
    }

    /**
     * Gets tot_id
     *
     * @return int|null
     */
    public function getTotId()
    {
        return $this->container['tot_id'];
    }

    /**
     * Sets tot_id
     *
     * @param int|null $tot_id (Optional) Move to TOT id, create or retrive tot scan barcode first. To unassign from Tot send 0
     *
     * @return self
     */
    public function setTotId($tot_id)
    {
        if (is_null($tot_id)) {
            throw new \InvalidArgumentException('non-nullable tot_id cannot be null');
        }
        $this->container['tot_id'] = $tot_id;

        return $this;
    }

    /**
     * Gets tx_type
     *
     * @return string|null
     */
    public function getTxType()
    {
        return $this->container['tx_type'];
    }

    /**
     * Sets tx_type
     *
     * @param string|null $tx_type Type of the move. Open means its an instruction to move, In Transit actually marks the item as unavilable and physically being moved
     *
     * @return self
     */
    public function setTxType($tx_type)
    {
        if (is_null($tx_type)) {
            throw new \InvalidArgumentException('non-nullable tx_type cannot be null');
        }
        $allowedValues = $this->getTxTypeAllowableValues();
        if (!in_array($tx_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'tx_type', must be one of '%s'",
                    $tx_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['tx_type'] = $tx_type;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return string|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param string|null $user_id user_id
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        if (is_null($user_id)) {
            throw new \InvalidArgumentException('non-nullable user_id cannot be null');
        }
        $this->container['user_id'] = $user_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


