<?php
/**
 * UpdateStockLevelsBulkRequestItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * UpdateStockLevelsBulkRequestItem Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateStockLevelsBulkRequestItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdateStockLevelsBulkRequestItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sku' => 'string',
        'stock_item_id' => 'string',
        'stock_location_name' => 'string',
        'stock_location_id' => 'string',
        'stock_level' => 'int',
        'stock_value' => 'float',
        'unit_cost' => 'float',
        'binrack' => 'string',
        'minimum_level' => 'int',
        'row_index' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sku' => null,
        'stock_item_id' => 'uuid',
        'stock_location_name' => null,
        'stock_location_id' => 'uuid',
        'stock_level' => 'int32',
        'stock_value' => 'double',
        'unit_cost' => 'double',
        'binrack' => null,
        'minimum_level' => 'int32',
        'row_index' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sku' => false,
        'stock_item_id' => false,
        'stock_location_name' => false,
        'stock_location_id' => false,
        'stock_level' => false,
        'stock_value' => false,
        'unit_cost' => false,
        'binrack' => false,
        'minimum_level' => false,
        'row_index' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sku' => 'SKU',
        'stock_item_id' => 'StockItemId',
        'stock_location_name' => 'StockLocationName',
        'stock_location_id' => 'StockLocationId',
        'stock_level' => 'StockLevel',
        'stock_value' => 'StockValue',
        'unit_cost' => 'UnitCost',
        'binrack' => 'Binrack',
        'minimum_level' => 'MinimumLevel',
        'row_index' => 'RowIndex'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sku' => 'setSku',
        'stock_item_id' => 'setStockItemId',
        'stock_location_name' => 'setStockLocationName',
        'stock_location_id' => 'setStockLocationId',
        'stock_level' => 'setStockLevel',
        'stock_value' => 'setStockValue',
        'unit_cost' => 'setUnitCost',
        'binrack' => 'setBinrack',
        'minimum_level' => 'setMinimumLevel',
        'row_index' => 'setRowIndex'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sku' => 'getSku',
        'stock_item_id' => 'getStockItemId',
        'stock_location_name' => 'getStockLocationName',
        'stock_location_id' => 'getStockLocationId',
        'stock_level' => 'getStockLevel',
        'stock_value' => 'getStockValue',
        'unit_cost' => 'getUnitCost',
        'binrack' => 'getBinrack',
        'minimum_level' => 'getMinimumLevel',
        'row_index' => 'getRowIndex'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_location_name', $data ?? [], null);
        $this->setIfExists('stock_location_id', $data ?? [], null);
        $this->setIfExists('stock_level', $data ?? [], null);
        $this->setIfExists('stock_value', $data ?? [], null);
        $this->setIfExists('unit_cost', $data ?? [], null);
        $this->setIfExists('binrack', $data ?? [], null);
        $this->setIfExists('minimum_level', $data ?? [], null);
        $this->setIfExists('row_index', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku SKU - Optional if stock item id is provided
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id StockItemId - Optional if stock SKU is provided, calls will be faster if this is provided.
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_location_name
     *
     * @return string|null
     */
    public function getStockLocationName()
    {
        return $this->container['stock_location_name'];
    }

    /**
     * Sets stock_location_name
     *
     * @param string|null $stock_location_name Stock location name, optional if StockLocationId is provided.
     *
     * @return self
     */
    public function setStockLocationName($stock_location_name)
    {
        if (is_null($stock_location_name)) {
            throw new \InvalidArgumentException('non-nullable stock_location_name cannot be null');
        }
        $this->container['stock_location_name'] = $stock_location_name;

        return $this;
    }

    /**
     * Gets stock_location_id
     *
     * @return string|null
     */
    public function getStockLocationId()
    {
        return $this->container['stock_location_id'];
    }

    /**
     * Sets stock_location_id
     *
     * @param string|null $stock_location_id Stock Location Id, optional if StockLocationName is provided, calls will be faster if this is provided.
     *
     * @return self
     */
    public function setStockLocationId($stock_location_id)
    {
        if (is_null($stock_location_id)) {
            throw new \InvalidArgumentException('non-nullable stock_location_id cannot be null');
        }
        $this->container['stock_location_id'] = $stock_location_id;

        return $this;
    }

    /**
     * Gets stock_level
     *
     * @return int|null
     */
    public function getStockLevel()
    {
        return $this->container['stock_level'];
    }

    /**
     * Sets stock_level
     *
     * @param int|null $stock_level StockLevel - Optional
     *
     * @return self
     */
    public function setStockLevel($stock_level)
    {
        if (is_null($stock_level)) {
            throw new \InvalidArgumentException('non-nullable stock_level cannot be null');
        }
        $this->container['stock_level'] = $stock_level;

        return $this;
    }

    /**
     * Gets stock_value
     *
     * @return float|null
     */
    public function getStockValue()
    {
        return $this->container['stock_value'];
    }

    /**
     * Sets stock_value
     *
     * @param float|null $stock_value StockValue - Optional, if unit cost is provided then value will be calculated from this, otherwise existing stock value or purchase price will be used.
     *
     * @return self
     */
    public function setStockValue($stock_value)
    {
        if (is_null($stock_value)) {
            throw new \InvalidArgumentException('non-nullable stock_value cannot be null');
        }
        $this->container['stock_value'] = $stock_value;

        return $this;
    }

    /**
     * Gets unit_cost
     *
     * @return float|null
     */
    public function getUnitCost()
    {
        return $this->container['unit_cost'];
    }

    /**
     * Sets unit_cost
     *
     * @param float|null $unit_cost UnitCost - Optional, if stock value is provided then value will be calculated from this, otherwise existing stock value or purchase price will be used.
     *
     * @return self
     */
    public function setUnitCost($unit_cost)
    {
        if (is_null($unit_cost)) {
            throw new \InvalidArgumentException('non-nullable unit_cost cannot be null');
        }
        $this->container['unit_cost'] = $unit_cost;

        return $this;
    }

    /**
     * Gets binrack
     *
     * @return string|null
     */
    public function getBinrack()
    {
        return $this->container['binrack'];
    }

    /**
     * Sets binrack
     *
     * @param string|null $binrack Binrack - Optional, if not provided or empty exisitng binrack will remain.
     *
     * @return self
     */
    public function setBinrack($binrack)
    {
        if (is_null($binrack)) {
            throw new \InvalidArgumentException('non-nullable binrack cannot be null');
        }
        $this->container['binrack'] = $binrack;

        return $this;
    }

    /**
     * Gets minimum_level
     *
     * @return int|null
     */
    public function getMinimumLevel()
    {
        return $this->container['minimum_level'];
    }

    /**
     * Sets minimum_level
     *
     * @param int|null $minimum_level Minimum level - Optional
     *
     * @return self
     */
    public function setMinimumLevel($minimum_level)
    {
        if (is_null($minimum_level)) {
            throw new \InvalidArgumentException('non-nullable minimum_level cannot be null');
        }
        $this->container['minimum_level'] = $minimum_level;

        return $this;
    }

    /**
     * Gets row_index
     *
     * @return int|null
     */
    public function getRowIndex()
    {
        return $this->container['row_index'];
    }

    /**
     * Sets row_index
     *
     * @param int|null $row_index RowIndex - Optional, can be used to marry up request items with response items.
     *
     * @return self
     */
    public function setRowIndex($row_index)
    {
        if (is_null($row_index)) {
            throw new \InvalidArgumentException('non-nullable row_index cannot be null');
        }
        $this->container['row_index'] = $row_index;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


