<?php
/**
 * StockTakeItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * StockTakeItem Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockTakeItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockTakeItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'bin_rack' => 'string',
        'picking_wave_items' => '\Linnworks\Stock\Model\BatchPickingWaveStockItems[]',
        'stock_item_id' => 'string',
        'quantity' => 'int',
        'original_quantity' => 'int',
        'stock_value' => 'float',
        'batch_inventory_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'bin_rack' => null,
        'picking_wave_items' => null,
        'stock_item_id' => 'uuid',
        'quantity' => 'int32',
        'original_quantity' => 'int32',
        'stock_value' => 'double',
        'batch_inventory_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'bin_rack' => false,
        'picking_wave_items' => false,
        'stock_item_id' => false,
        'quantity' => false,
        'original_quantity' => false,
        'stock_value' => false,
        'batch_inventory_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bin_rack' => 'BinRack',
        'picking_wave_items' => 'PickingWaveItems',
        'stock_item_id' => 'StockItemId',
        'quantity' => 'Quantity',
        'original_quantity' => 'OriginalQuantity',
        'stock_value' => 'StockValue',
        'batch_inventory_id' => 'BatchInventoryId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bin_rack' => 'setBinRack',
        'picking_wave_items' => 'setPickingWaveItems',
        'stock_item_id' => 'setStockItemId',
        'quantity' => 'setQuantity',
        'original_quantity' => 'setOriginalQuantity',
        'stock_value' => 'setStockValue',
        'batch_inventory_id' => 'setBatchInventoryId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bin_rack' => 'getBinRack',
        'picking_wave_items' => 'getPickingWaveItems',
        'stock_item_id' => 'getStockItemId',
        'quantity' => 'getQuantity',
        'original_quantity' => 'getOriginalQuantity',
        'stock_value' => 'getStockValue',
        'batch_inventory_id' => 'getBatchInventoryId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('bin_rack', $data ?? [], null);
        $this->setIfExists('picking_wave_items', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('original_quantity', $data ?? [], null);
        $this->setIfExists('stock_value', $data ?? [], null);
        $this->setIfExists('batch_inventory_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bin_rack
     *
     * @return string|null
     */
    public function getBinRack()
    {
        return $this->container['bin_rack'];
    }

    /**
     * Sets bin_rack
     *
     * @param string|null $bin_rack (optional) Only applicable to non-batched and non-WMS locations. Singular BinRack will be updated for the given item for a given location. Will be ignored for a batched or WMS item.
     *
     * @return self
     */
    public function setBinRack($bin_rack)
    {
        if (is_null($bin_rack)) {
            throw new \InvalidArgumentException('non-nullable bin_rack cannot be null');
        }
        $this->container['bin_rack'] = $bin_rack;

        return $this;
    }

    /**
     * Gets picking_wave_items
     *
     * @return \Linnworks\Stock\Model\BatchPickingWaveStockItems[]|null
     */
    public function getPickingWaveItems()
    {
        return $this->container['picking_wave_items'];
    }

    /**
     * Sets picking_wave_items
     *
     * @param \Linnworks\Stock\Model\BatchPickingWaveStockItems[]|null $picking_wave_items (optional) Pickwave items associated with the batch. This data will be used for concurrency check and validation of data.   Super important stuff when you are submitting batch inventory stock count in WMS location.   Order items will automatically be allocated to a specific batch when the order is placed/printed/added to pickwave. This will normally block stock count,   however it is possible to get the state of pickwave items, and if all items are picked from the location the user can still count them. When stock count is submitted  we need to also submit the state of the pickwave at the point of count, so we can compare state was and the state is, discount any stock from the count that was processed/shipped   If this parameter is not supplied and the batch is allocated to orders, the stock count for this item will be blocked and will not be submitted
     *
     * @return self
     */
    public function setPickingWaveItems($picking_wave_items)
    {
        if (is_null($picking_wave_items)) {
            throw new \InvalidArgumentException('non-nullable picking_wave_items cannot be null');
        }
        $this->container['picking_wave_items'] = $picking_wave_items;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Current stock level
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets original_quantity
     *
     * @return int|null
     */
    public function getOriginalQuantity()
    {
        return $this->container['original_quantity'];
    }

    /**
     * Sets original_quantity
     *
     * @param int|null $original_quantity (Optional) Original quantity, used to validate if the original has changed since the items have been counted. If supplied and different to expected then an error will be returned.
     *
     * @return self
     */
    public function setOriginalQuantity($original_quantity)
    {
        if (is_null($original_quantity)) {
            throw new \InvalidArgumentException('non-nullable original_quantity cannot be null');
        }
        $this->container['original_quantity'] = $original_quantity;

        return $this;
    }

    /**
     * Gets stock_value
     *
     * @return float|null
     */
    public function getStockValue()
    {
        return $this->container['stock_value'];
    }

    /**
     * Sets stock_value
     *
     * @param float|null $stock_value (optional) Stock value (unit cost * quantity). If not provided it will be calculated from current stock value
     *
     * @return self
     */
    public function setStockValue($stock_value)
    {
        if (is_null($stock_value)) {
            throw new \InvalidArgumentException('non-nullable stock_value cannot be null');
        }
        $this->container['stock_value'] = $stock_value;

        return $this;
    }

    /**
     * Gets batch_inventory_id
     *
     * @return int|null
     */
    public function getBatchInventoryId()
    {
        return $this->container['batch_inventory_id'];
    }

    /**
     * Sets batch_inventory_id
     *
     * @param int|null $batch_inventory_id (conditional) If item is batched or in WMS location, you must provide BatchInventoryId which is being updated.   If its newly discovered item, use BookInStockBatch call in Stock controller to create a new batch inventory
     *
     * @return self
     */
    public function setBatchInventoryId($batch_inventory_id)
    {
        if (is_null($batch_inventory_id)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory_id cannot be null');
        }
        $this->container['batch_inventory_id'] = $batch_inventory_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


