<?php
/**
 * StockItemTypeInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * StockItemTypeInfo Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemTypeInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemTypeInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sku' => 'string',
        'stock_item_int_id' => 'int',
        'stock_item_id' => 'string',
        'is_variation_group' => 'bool',
        'is_composite_parent' => 'bool',
        'is_archived' => 'bool',
        'inventory_tracking_type' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sku' => null,
        'stock_item_int_id' => 'int32',
        'stock_item_id' => 'uuid',
        'is_variation_group' => null,
        'is_composite_parent' => null,
        'is_archived' => null,
        'inventory_tracking_type' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sku' => false,
        'stock_item_int_id' => false,
        'stock_item_id' => false,
        'is_variation_group' => false,
        'is_composite_parent' => false,
        'is_archived' => false,
        'inventory_tracking_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sku' => 'SKU',
        'stock_item_int_id' => 'StockItemIntId',
        'stock_item_id' => 'StockItemId',
        'is_variation_group' => 'IsVariationGroup',
        'is_composite_parent' => 'IsCompositeParent',
        'is_archived' => 'IsArchived',
        'inventory_tracking_type' => 'InventoryTrackingType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sku' => 'setSku',
        'stock_item_int_id' => 'setStockItemIntId',
        'stock_item_id' => 'setStockItemId',
        'is_variation_group' => 'setIsVariationGroup',
        'is_composite_parent' => 'setIsCompositeParent',
        'is_archived' => 'setIsArchived',
        'inventory_tracking_type' => 'setInventoryTrackingType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sku' => 'getSku',
        'stock_item_int_id' => 'getStockItemIntId',
        'stock_item_id' => 'getStockItemId',
        'is_variation_group' => 'getIsVariationGroup',
        'is_composite_parent' => 'getIsCompositeParent',
        'is_archived' => 'getIsArchived',
        'inventory_tracking_type' => 'getInventoryTrackingType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('is_variation_group', $data ?? [], null);
        $this->setIfExists('is_composite_parent', $data ?? [], null);
        $this->setIfExists('is_archived', $data ?? [], null);
        $this->setIfExists('inventory_tracking_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku sku
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id stock_item_int_id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id stock_item_id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets is_variation_group
     *
     * @return bool|null
     */
    public function getIsVariationGroup()
    {
        return $this->container['is_variation_group'];
    }

    /**
     * Sets is_variation_group
     *
     * @param bool|null $is_variation_group is_variation_group
     *
     * @return self
     */
    public function setIsVariationGroup($is_variation_group)
    {
        if (is_null($is_variation_group)) {
            throw new \InvalidArgumentException('non-nullable is_variation_group cannot be null');
        }
        $this->container['is_variation_group'] = $is_variation_group;

        return $this;
    }

    /**
     * Gets is_composite_parent
     *
     * @return bool|null
     */
    public function getIsCompositeParent()
    {
        return $this->container['is_composite_parent'];
    }

    /**
     * Sets is_composite_parent
     *
     * @param bool|null $is_composite_parent is_composite_parent
     *
     * @return self
     */
    public function setIsCompositeParent($is_composite_parent)
    {
        if (is_null($is_composite_parent)) {
            throw new \InvalidArgumentException('non-nullable is_composite_parent cannot be null');
        }
        $this->container['is_composite_parent'] = $is_composite_parent;

        return $this;
    }

    /**
     * Gets is_archived
     *
     * @return bool|null
     */
    public function getIsArchived()
    {
        return $this->container['is_archived'];
    }

    /**
     * Sets is_archived
     *
     * @param bool|null $is_archived is_archived
     *
     * @return self
     */
    public function setIsArchived($is_archived)
    {
        if (is_null($is_archived)) {
            throw new \InvalidArgumentException('non-nullable is_archived cannot be null');
        }
        $this->container['is_archived'] = $is_archived;

        return $this;
    }

    /**
     * Gets inventory_tracking_type
     *
     * @return int|null
     */
    public function getInventoryTrackingType()
    {
        return $this->container['inventory_tracking_type'];
    }

    /**
     * Sets inventory_tracking_type
     *
     * @param int|null $inventory_tracking_type inventory_tracking_type
     *
     * @return self
     */
    public function setInventoryTrackingType($inventory_tracking_type)
    {
        if (is_null($inventory_tracking_type)) {
            throw new \InvalidArgumentException('non-nullable inventory_tracking_type cannot be null');
        }
        $this->container['inventory_tracking_type'] = $inventory_tracking_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


