<?php
/**
 * StockItemSupplierStat
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * StockItemSupplierStat Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemSupplierStat implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemSupplierStat';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'is_default' => 'bool',
        'supplier' => 'string',
        'supplier_id' => 'string',
        'code' => 'string',
        'supplier_barcode' => 'string',
        'lead_time' => 'int',
        'purchase_price' => 'float',
        'min_price' => 'float',
        'max_price' => 'float',
        'average_price' => 'float',
        'average_lead_time' => 'float',
        'supplier_min_order_qty' => 'int',
        'supplier_pack_size' => 'int',
        'supplier_currency' => 'string',
        'stock_item_id' => 'string',
        'stock_item_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'is_default' => null,
        'supplier' => null,
        'supplier_id' => 'uuid',
        'code' => null,
        'supplier_barcode' => null,
        'lead_time' => 'int32',
        'purchase_price' => 'double',
        'min_price' => 'double',
        'max_price' => 'double',
        'average_price' => 'double',
        'average_lead_time' => 'double',
        'supplier_min_order_qty' => 'int32',
        'supplier_pack_size' => 'int32',
        'supplier_currency' => null,
        'stock_item_id' => 'uuid',
        'stock_item_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'is_default' => false,
        'supplier' => false,
        'supplier_id' => false,
        'code' => false,
        'supplier_barcode' => false,
        'lead_time' => false,
        'purchase_price' => false,
        'min_price' => false,
        'max_price' => false,
        'average_price' => false,
        'average_lead_time' => false,
        'supplier_min_order_qty' => false,
        'supplier_pack_size' => false,
        'supplier_currency' => false,
        'stock_item_id' => false,
        'stock_item_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'is_default' => 'IsDefault',
        'supplier' => 'Supplier',
        'supplier_id' => 'SupplierID',
        'code' => 'Code',
        'supplier_barcode' => 'SupplierBarcode',
        'lead_time' => 'LeadTime',
        'purchase_price' => 'PurchasePrice',
        'min_price' => 'MinPrice',
        'max_price' => 'MaxPrice',
        'average_price' => 'AveragePrice',
        'average_lead_time' => 'AverageLeadTime',
        'supplier_min_order_qty' => 'SupplierMinOrderQty',
        'supplier_pack_size' => 'SupplierPackSize',
        'supplier_currency' => 'SupplierCurrency',
        'stock_item_id' => 'StockItemId',
        'stock_item_int_id' => 'StockItemIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'is_default' => 'setIsDefault',
        'supplier' => 'setSupplier',
        'supplier_id' => 'setSupplierId',
        'code' => 'setCode',
        'supplier_barcode' => 'setSupplierBarcode',
        'lead_time' => 'setLeadTime',
        'purchase_price' => 'setPurchasePrice',
        'min_price' => 'setMinPrice',
        'max_price' => 'setMaxPrice',
        'average_price' => 'setAveragePrice',
        'average_lead_time' => 'setAverageLeadTime',
        'supplier_min_order_qty' => 'setSupplierMinOrderQty',
        'supplier_pack_size' => 'setSupplierPackSize',
        'supplier_currency' => 'setSupplierCurrency',
        'stock_item_id' => 'setStockItemId',
        'stock_item_int_id' => 'setStockItemIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'is_default' => 'getIsDefault',
        'supplier' => 'getSupplier',
        'supplier_id' => 'getSupplierId',
        'code' => 'getCode',
        'supplier_barcode' => 'getSupplierBarcode',
        'lead_time' => 'getLeadTime',
        'purchase_price' => 'getPurchasePrice',
        'min_price' => 'getMinPrice',
        'max_price' => 'getMaxPrice',
        'average_price' => 'getAveragePrice',
        'average_lead_time' => 'getAverageLeadTime',
        'supplier_min_order_qty' => 'getSupplierMinOrderQty',
        'supplier_pack_size' => 'getSupplierPackSize',
        'supplier_currency' => 'getSupplierCurrency',
        'stock_item_id' => 'getStockItemId',
        'stock_item_int_id' => 'getStockItemIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('is_default', $data ?? [], null);
        $this->setIfExists('supplier', $data ?? [], null);
        $this->setIfExists('supplier_id', $data ?? [], null);
        $this->setIfExists('code', $data ?? [], null);
        $this->setIfExists('supplier_barcode', $data ?? [], null);
        $this->setIfExists('lead_time', $data ?? [], null);
        $this->setIfExists('purchase_price', $data ?? [], null);
        $this->setIfExists('min_price', $data ?? [], null);
        $this->setIfExists('max_price', $data ?? [], null);
        $this->setIfExists('average_price', $data ?? [], null);
        $this->setIfExists('average_lead_time', $data ?? [], null);
        $this->setIfExists('supplier_min_order_qty', $data ?? [], null);
        $this->setIfExists('supplier_pack_size', $data ?? [], null);
        $this->setIfExists('supplier_currency', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets is_default
     *
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->container['is_default'];
    }

    /**
     * Sets is_default
     *
     * @param bool|null $is_default If supplier information is default
     *
     * @return self
     */
    public function setIsDefault($is_default)
    {
        if (is_null($is_default)) {
            throw new \InvalidArgumentException('non-nullable is_default cannot be null');
        }
        $this->container['is_default'] = $is_default;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return string|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param string|null $supplier Supplier name
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        if (is_null($supplier)) {
            throw new \InvalidArgumentException('non-nullable supplier cannot be null');
        }
        $this->container['supplier'] = $supplier;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param string|null $supplier_id Supplier ID
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        if (is_null($supplier_id)) {
            throw new \InvalidArgumentException('non-nullable supplier_id cannot be null');
        }
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets code
     *
     * @return string|null
     */
    public function getCode()
    {
        return $this->container['code'];
    }

    /**
     * Sets code
     *
     * @param string|null $code Supplier code
     *
     * @return self
     */
    public function setCode($code)
    {
        if (is_null($code)) {
            throw new \InvalidArgumentException('non-nullable code cannot be null');
        }
        $this->container['code'] = $code;

        return $this;
    }

    /**
     * Gets supplier_barcode
     *
     * @return string|null
     */
    public function getSupplierBarcode()
    {
        return $this->container['supplier_barcode'];
    }

    /**
     * Sets supplier_barcode
     *
     * @param string|null $supplier_barcode Supplier barcode
     *
     * @return self
     */
    public function setSupplierBarcode($supplier_barcode)
    {
        if (is_null($supplier_barcode)) {
            throw new \InvalidArgumentException('non-nullable supplier_barcode cannot be null');
        }
        $this->container['supplier_barcode'] = $supplier_barcode;

        return $this;
    }

    /**
     * Gets lead_time
     *
     * @return int|null
     */
    public function getLeadTime()
    {
        return $this->container['lead_time'];
    }

    /**
     * Sets lead_time
     *
     * @param int|null $lead_time Supplier lead time
     *
     * @return self
     */
    public function setLeadTime($lead_time)
    {
        if (is_null($lead_time)) {
            throw new \InvalidArgumentException('non-nullable lead_time cannot be null');
        }
        $this->container['lead_time'] = $lead_time;

        return $this;
    }

    /**
     * Gets purchase_price
     *
     * @return float|null
     */
    public function getPurchasePrice()
    {
        return $this->container['purchase_price'];
    }

    /**
     * Sets purchase_price
     *
     * @param float|null $purchase_price Supplier purchase price
     *
     * @return self
     */
    public function setPurchasePrice($purchase_price)
    {
        if (is_null($purchase_price)) {
            throw new \InvalidArgumentException('non-nullable purchase_price cannot be null');
        }
        $this->container['purchase_price'] = $purchase_price;

        return $this;
    }

    /**
     * Gets min_price
     *
     * @return float|null
     */
    public function getMinPrice()
    {
        return $this->container['min_price'];
    }

    /**
     * Sets min_price
     *
     * @param float|null $min_price Minimum price
     *
     * @return self
     */
    public function setMinPrice($min_price)
    {
        if (is_null($min_price)) {
            throw new \InvalidArgumentException('non-nullable min_price cannot be null');
        }
        $this->container['min_price'] = $min_price;

        return $this;
    }

    /**
     * Gets max_price
     *
     * @return float|null
     */
    public function getMaxPrice()
    {
        return $this->container['max_price'];
    }

    /**
     * Sets max_price
     *
     * @param float|null $max_price Maximum price
     *
     * @return self
     */
    public function setMaxPrice($max_price)
    {
        if (is_null($max_price)) {
            throw new \InvalidArgumentException('non-nullable max_price cannot be null');
        }
        $this->container['max_price'] = $max_price;

        return $this;
    }

    /**
     * Gets average_price
     *
     * @return float|null
     */
    public function getAveragePrice()
    {
        return $this->container['average_price'];
    }

    /**
     * Sets average_price
     *
     * @param float|null $average_price Average price
     *
     * @return self
     */
    public function setAveragePrice($average_price)
    {
        if (is_null($average_price)) {
            throw new \InvalidArgumentException('non-nullable average_price cannot be null');
        }
        $this->container['average_price'] = $average_price;

        return $this;
    }

    /**
     * Gets average_lead_time
     *
     * @return float|null
     */
    public function getAverageLeadTime()
    {
        return $this->container['average_lead_time'];
    }

    /**
     * Sets average_lead_time
     *
     * @param float|null $average_lead_time Average lead time
     *
     * @return self
     */
    public function setAverageLeadTime($average_lead_time)
    {
        if (is_null($average_lead_time)) {
            throw new \InvalidArgumentException('non-nullable average_lead_time cannot be null');
        }
        $this->container['average_lead_time'] = $average_lead_time;

        return $this;
    }

    /**
     * Gets supplier_min_order_qty
     *
     * @return int|null
     */
    public function getSupplierMinOrderQty()
    {
        return $this->container['supplier_min_order_qty'];
    }

    /**
     * Sets supplier_min_order_qty
     *
     * @param int|null $supplier_min_order_qty Minimum order quantity from this supplier
     *
     * @return self
     */
    public function setSupplierMinOrderQty($supplier_min_order_qty)
    {
        if (is_null($supplier_min_order_qty)) {
            throw new \InvalidArgumentException('non-nullable supplier_min_order_qty cannot be null');
        }
        $this->container['supplier_min_order_qty'] = $supplier_min_order_qty;

        return $this;
    }

    /**
     * Gets supplier_pack_size
     *
     * @return int|null
     */
    public function getSupplierPackSize()
    {
        return $this->container['supplier_pack_size'];
    }

    /**
     * Sets supplier_pack_size
     *
     * @param int|null $supplier_pack_size Supplier pack size
     *
     * @return self
     */
    public function setSupplierPackSize($supplier_pack_size)
    {
        if (is_null($supplier_pack_size)) {
            throw new \InvalidArgumentException('non-nullable supplier_pack_size cannot be null');
        }
        $this->container['supplier_pack_size'] = $supplier_pack_size;

        return $this;
    }

    /**
     * Gets supplier_currency
     *
     * @return string|null
     */
    public function getSupplierCurrency()
    {
        return $this->container['supplier_currency'];
    }

    /**
     * Sets supplier_currency
     *
     * @param string|null $supplier_currency Supplier's default currency
     *
     * @return self
     */
    public function setSupplierCurrency($supplier_currency)
    {
        if (is_null($supplier_currency)) {
            throw new \InvalidArgumentException('non-nullable supplier_currency cannot be null');
        }
        $this->container['supplier_currency'] = $supplier_currency;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id Stock Item interger Id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


