<?php
/**
 * StockItemLevel
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * StockItemLevel Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemLevel implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemLevel';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'location' => '\Linnworks\Stock\Model\InventoryStockLocation',
        'stock_level' => 'int',
        'stock_value' => 'float',
        'minimum_level' => 'int',
        'in_order_book' => 'int',
        'due' => 'int',
        'jit' => 'bool',
        'in_orders' => 'int',
        'available' => 'int',
        'unit_cost' => 'float',
        'sku' => 'string',
        'auto_adjust' => 'bool',
        'last_update_date' => '\DateTime',
        'last_update_operation' => 'string',
        'rowid' => 'string',
        'pending_update' => 'bool',
        'stock_item_purchase_price' => 'float',
        'stock_item_id' => 'string',
        'stock_item_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'location' => null,
        'stock_level' => 'int32',
        'stock_value' => 'double',
        'minimum_level' => 'int32',
        'in_order_book' => 'int32',
        'due' => 'int32',
        'jit' => null,
        'in_orders' => 'int32',
        'available' => 'int32',
        'unit_cost' => 'double',
        'sku' => null,
        'auto_adjust' => null,
        'last_update_date' => 'date-time',
        'last_update_operation' => null,
        'rowid' => 'uuid',
        'pending_update' => null,
        'stock_item_purchase_price' => 'double',
        'stock_item_id' => 'uuid',
        'stock_item_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'location' => false,
        'stock_level' => false,
        'stock_value' => false,
        'minimum_level' => false,
        'in_order_book' => false,
        'due' => false,
        'jit' => false,
        'in_orders' => false,
        'available' => false,
        'unit_cost' => false,
        'sku' => false,
        'auto_adjust' => false,
        'last_update_date' => false,
        'last_update_operation' => false,
        'rowid' => false,
        'pending_update' => false,
        'stock_item_purchase_price' => false,
        'stock_item_id' => false,
        'stock_item_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'location' => 'Location',
        'stock_level' => 'StockLevel',
        'stock_value' => 'StockValue',
        'minimum_level' => 'MinimumLevel',
        'in_order_book' => 'InOrderBook',
        'due' => 'Due',
        'jit' => 'JIT',
        'in_orders' => 'InOrders',
        'available' => 'Available',
        'unit_cost' => 'UnitCost',
        'sku' => 'SKU',
        'auto_adjust' => 'AutoAdjust',
        'last_update_date' => 'LastUpdateDate',
        'last_update_operation' => 'LastUpdateOperation',
        'rowid' => 'rowid',
        'pending_update' => 'PendingUpdate',
        'stock_item_purchase_price' => 'StockItemPurchasePrice',
        'stock_item_id' => 'StockItemId',
        'stock_item_int_id' => 'StockItemIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'location' => 'setLocation',
        'stock_level' => 'setStockLevel',
        'stock_value' => 'setStockValue',
        'minimum_level' => 'setMinimumLevel',
        'in_order_book' => 'setInOrderBook',
        'due' => 'setDue',
        'jit' => 'setJit',
        'in_orders' => 'setInOrders',
        'available' => 'setAvailable',
        'unit_cost' => 'setUnitCost',
        'sku' => 'setSku',
        'auto_adjust' => 'setAutoAdjust',
        'last_update_date' => 'setLastUpdateDate',
        'last_update_operation' => 'setLastUpdateOperation',
        'rowid' => 'setRowid',
        'pending_update' => 'setPendingUpdate',
        'stock_item_purchase_price' => 'setStockItemPurchasePrice',
        'stock_item_id' => 'setStockItemId',
        'stock_item_int_id' => 'setStockItemIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'location' => 'getLocation',
        'stock_level' => 'getStockLevel',
        'stock_value' => 'getStockValue',
        'minimum_level' => 'getMinimumLevel',
        'in_order_book' => 'getInOrderBook',
        'due' => 'getDue',
        'jit' => 'getJit',
        'in_orders' => 'getInOrders',
        'available' => 'getAvailable',
        'unit_cost' => 'getUnitCost',
        'sku' => 'getSku',
        'auto_adjust' => 'getAutoAdjust',
        'last_update_date' => 'getLastUpdateDate',
        'last_update_operation' => 'getLastUpdateOperation',
        'rowid' => 'getRowid',
        'pending_update' => 'getPendingUpdate',
        'stock_item_purchase_price' => 'getStockItemPurchasePrice',
        'stock_item_id' => 'getStockItemId',
        'stock_item_int_id' => 'getStockItemIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('location', $data ?? [], null);
        $this->setIfExists('stock_level', $data ?? [], null);
        $this->setIfExists('stock_value', $data ?? [], null);
        $this->setIfExists('minimum_level', $data ?? [], null);
        $this->setIfExists('in_order_book', $data ?? [], null);
        $this->setIfExists('due', $data ?? [], null);
        $this->setIfExists('jit', $data ?? [], null);
        $this->setIfExists('in_orders', $data ?? [], null);
        $this->setIfExists('available', $data ?? [], null);
        $this->setIfExists('unit_cost', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('auto_adjust', $data ?? [], null);
        $this->setIfExists('last_update_date', $data ?? [], null);
        $this->setIfExists('last_update_operation', $data ?? [], null);
        $this->setIfExists('rowid', $data ?? [], null);
        $this->setIfExists('pending_update', $data ?? [], null);
        $this->setIfExists('stock_item_purchase_price', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets location
     *
     * @return \Linnworks\Stock\Model\InventoryStockLocation|null
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     *
     * @param \Linnworks\Stock\Model\InventoryStockLocation|null $location location
     *
     * @return self
     */
    public function setLocation($location)
    {
        if (is_null($location)) {
            throw new \InvalidArgumentException('non-nullable location cannot be null');
        }
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets stock_level
     *
     * @return int|null
     */
    public function getStockLevel()
    {
        return $this->container['stock_level'];
    }

    /**
     * Sets stock_level
     *
     * @param int|null $stock_level Stock level
     *
     * @return self
     */
    public function setStockLevel($stock_level)
    {
        if (is_null($stock_level)) {
            throw new \InvalidArgumentException('non-nullable stock_level cannot be null');
        }
        $this->container['stock_level'] = $stock_level;

        return $this;
    }

    /**
     * Gets stock_value
     *
     * @return float|null
     */
    public function getStockValue()
    {
        return $this->container['stock_value'];
    }

    /**
     * Sets stock_value
     *
     * @param float|null $stock_value Stock value
     *
     * @return self
     */
    public function setStockValue($stock_value)
    {
        if (is_null($stock_value)) {
            throw new \InvalidArgumentException('non-nullable stock_value cannot be null');
        }
        $this->container['stock_value'] = $stock_value;

        return $this;
    }

    /**
     * Gets minimum_level
     *
     * @return int|null
     */
    public function getMinimumLevel()
    {
        return $this->container['minimum_level'];
    }

    /**
     * Sets minimum_level
     *
     * @param int|null $minimum_level Minimum level
     *
     * @return self
     */
    public function setMinimumLevel($minimum_level)
    {
        if (is_null($minimum_level)) {
            throw new \InvalidArgumentException('non-nullable minimum_level cannot be null');
        }
        $this->container['minimum_level'] = $minimum_level;

        return $this;
    }

    /**
     * Gets in_order_book
     *
     * @return int|null
     */
    public function getInOrderBook()
    {
        return $this->container['in_order_book'];
    }

    /**
     * Sets in_order_book
     *
     * @param int|null $in_order_book Currently in open orders
     *
     * @return self
     */
    public function setInOrderBook($in_order_book)
    {
        if (is_null($in_order_book)) {
            throw new \InvalidArgumentException('non-nullable in_order_book cannot be null');
        }
        $this->container['in_order_book'] = $in_order_book;

        return $this;
    }

    /**
     * Gets due
     *
     * @return int|null
     */
    public function getDue()
    {
        return $this->container['due'];
    }

    /**
     * Sets due
     *
     * @param int|null $due Due to come in purchase orders
     *
     * @return self
     */
    public function setDue($due)
    {
        if (is_null($due)) {
            throw new \InvalidArgumentException('non-nullable due cannot be null');
        }
        $this->container['due'] = $due;

        return $this;
    }

    /**
     * Gets jit
     *
     * @return bool|null
     */
    public function getJit()
    {
        return $this->container['jit'];
    }

    /**
     * Sets jit
     *
     * @param bool|null $jit Stock Item Just In Time (JIT) status
     *
     * @return self
     */
    public function setJit($jit)
    {
        if (is_null($jit)) {
            throw new \InvalidArgumentException('non-nullable jit cannot be null');
        }
        $this->container['jit'] = $jit;

        return $this;
    }

    /**
     * Gets in_orders
     *
     * @return int|null
     */
    public function getInOrders()
    {
        return $this->container['in_orders'];
    }

    /**
     * Sets in_orders
     *
     * @param int|null $in_orders Currently in open orders
     *
     * @return self
     */
    public function setInOrders($in_orders)
    {
        if (is_null($in_orders)) {
            throw new \InvalidArgumentException('non-nullable in_orders cannot be null');
        }
        $this->container['in_orders'] = $in_orders;

        return $this;
    }

    /**
     * Gets available
     *
     * @return int|null
     */
    public function getAvailable()
    {
        return $this->container['available'];
    }

    /**
     * Sets available
     *
     * @param int|null $available StockLevel - InOrders
     *
     * @return self
     */
    public function setAvailable($available)
    {
        if (is_null($available)) {
            throw new \InvalidArgumentException('non-nullable available cannot be null');
        }
        $this->container['available'] = $available;

        return $this;
    }

    /**
     * Gets unit_cost
     *
     * @return float|null
     */
    public function getUnitCost()
    {
        return $this->container['unit_cost'];
    }

    /**
     * Sets unit_cost
     *
     * @param float|null $unit_cost if( Quantity == 0 )      dbo.StockItem.PurchasePrice  Else  CurrentStockValue / Quantity
     *
     * @return self
     */
    public function setUnitCost($unit_cost)
    {
        if (is_null($unit_cost)) {
            throw new \InvalidArgumentException('non-nullable unit_cost cannot be null');
        }
        $this->container['unit_cost'] = $unit_cost;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets auto_adjust
     *
     * @return bool|null
     */
    public function getAutoAdjust()
    {
        return $this->container['auto_adjust'];
    }

    /**
     * Sets auto_adjust
     *
     * @param bool|null $auto_adjust If level is auto adjusted
     *
     * @return self
     */
    public function setAutoAdjust($auto_adjust)
    {
        if (is_null($auto_adjust)) {
            throw new \InvalidArgumentException('non-nullable auto_adjust cannot be null');
        }
        $this->container['auto_adjust'] = $auto_adjust;

        return $this;
    }

    /**
     * Gets last_update_date
     *
     * @return \DateTime|null
     */
    public function getLastUpdateDate()
    {
        return $this->container['last_update_date'];
    }

    /**
     * Sets last_update_date
     *
     * @param \DateTime|null $last_update_date Last time stock level was adjusted
     *
     * @return self
     */
    public function setLastUpdateDate($last_update_date)
    {
        if (is_null($last_update_date)) {
            throw new \InvalidArgumentException('non-nullable last_update_date cannot be null');
        }
        $this->container['last_update_date'] = $last_update_date;

        return $this;
    }

    /**
     * Gets last_update_operation
     *
     * @return string|null
     */
    public function getLastUpdateOperation()
    {
        return $this->container['last_update_operation'];
    }

    /**
     * Sets last_update_operation
     *
     * @param string|null $last_update_operation Name of last update operation
     *
     * @return self
     */
    public function setLastUpdateOperation($last_update_operation)
    {
        if (is_null($last_update_operation)) {
            throw new \InvalidArgumentException('non-nullable last_update_operation cannot be null');
        }
        $this->container['last_update_operation'] = $last_update_operation;

        return $this;
    }

    /**
     * Gets rowid
     *
     * @return string|null
     */
    public function getRowid()
    {
        return $this->container['rowid'];
    }

    /**
     * Sets rowid
     *
     * @param string|null $rowid dbo.StockLevel.rowid
     *
     * @return self
     */
    public function setRowid($rowid)
    {
        if (is_null($rowid)) {
            throw new \InvalidArgumentException('non-nullable rowid cannot be null');
        }
        $this->container['rowid'] = $rowid;

        return $this;
    }

    /**
     * Gets pending_update
     *
     * @return bool|null
     */
    public function getPendingUpdate()
    {
        return $this->container['pending_update'];
    }

    /**
     * Sets pending_update
     *
     * @param bool|null $pending_update dbo.StockLevel.PendingUpdate
     *
     * @return self
     */
    public function setPendingUpdate($pending_update)
    {
        if (is_null($pending_update)) {
            throw new \InvalidArgumentException('non-nullable pending_update cannot be null');
        }
        $this->container['pending_update'] = $pending_update;

        return $this;
    }

    /**
     * Gets stock_item_purchase_price
     *
     * @return float|null
     */
    public function getStockItemPurchasePrice()
    {
        return $this->container['stock_item_purchase_price'];
    }

    /**
     * Sets stock_item_purchase_price
     *
     * @param float|null $stock_item_purchase_price Stock item purchase price. It's used to calculate UnitCost
     *
     * @return self
     */
    public function setStockItemPurchasePrice($stock_item_purchase_price)
    {
        if (is_null($stock_item_purchase_price)) {
            throw new \InvalidArgumentException('non-nullable stock_item_purchase_price cannot be null');
        }
        $this->container['stock_item_purchase_price'] = $stock_item_purchase_price;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id Stock Item interger Id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


