<?php
/**
 * StockItemChangeHistory
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * StockItemChangeHistory Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemChangeHistory implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemChangeHistory';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'date' => '\DateTime',
        'level' => 'int',
        'stock_value' => 'float',
        'note' => 'string',
        'change_qty' => 'int',
        'change_value' => 'float',
        'stock_item_id' => 'string',
        'stock_item_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'date' => 'date-time',
        'level' => 'int32',
        'stock_value' => 'double',
        'note' => null,
        'change_qty' => 'int32',
        'change_value' => 'double',
        'stock_item_id' => 'uuid',
        'stock_item_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'date' => false,
        'level' => false,
        'stock_value' => false,
        'note' => false,
        'change_qty' => false,
        'change_value' => false,
        'stock_item_id' => false,
        'stock_item_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'date' => 'Date',
        'level' => 'Level',
        'stock_value' => 'StockValue',
        'note' => 'Note',
        'change_qty' => 'ChangeQty',
        'change_value' => 'ChangeValue',
        'stock_item_id' => 'StockItemId',
        'stock_item_int_id' => 'StockItemIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'date' => 'setDate',
        'level' => 'setLevel',
        'stock_value' => 'setStockValue',
        'note' => 'setNote',
        'change_qty' => 'setChangeQty',
        'change_value' => 'setChangeValue',
        'stock_item_id' => 'setStockItemId',
        'stock_item_int_id' => 'setStockItemIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'date' => 'getDate',
        'level' => 'getLevel',
        'stock_value' => 'getStockValue',
        'note' => 'getNote',
        'change_qty' => 'getChangeQty',
        'change_value' => 'getChangeValue',
        'stock_item_id' => 'getStockItemId',
        'stock_item_int_id' => 'getStockItemIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('date', $data ?? [], null);
        $this->setIfExists('level', $data ?? [], null);
        $this->setIfExists('stock_value', $data ?? [], null);
        $this->setIfExists('note', $data ?? [], null);
        $this->setIfExists('change_qty', $data ?? [], null);
        $this->setIfExists('change_value', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets date
     *
     * @return \DateTime|null
     */
    public function getDate()
    {
        return $this->container['date'];
    }

    /**
     * Sets date
     *
     * @param \DateTime|null $date When changes were made
     *
     * @return self
     */
    public function setDate($date)
    {
        if (is_null($date)) {
            throw new \InvalidArgumentException('non-nullable date cannot be null');
        }
        $this->container['date'] = $date;

        return $this;
    }

    /**
     * Gets level
     *
     * @return int|null
     */
    public function getLevel()
    {
        return $this->container['level'];
    }

    /**
     * Sets level
     *
     * @param int|null $level Change level
     *
     * @return self
     */
    public function setLevel($level)
    {
        if (is_null($level)) {
            throw new \InvalidArgumentException('non-nullable level cannot be null');
        }
        $this->container['level'] = $level;

        return $this;
    }

    /**
     * Gets stock_value
     *
     * @return float|null
     */
    public function getStockValue()
    {
        return $this->container['stock_value'];
    }

    /**
     * Sets stock_value
     *
     * @param float|null $stock_value Stock value change
     *
     * @return self
     */
    public function setStockValue($stock_value)
    {
        if (is_null($stock_value)) {
            throw new \InvalidArgumentException('non-nullable stock_value cannot be null');
        }
        $this->container['stock_value'] = $stock_value;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note Change note
     *
     * @return self
     */
    public function setNote($note)
    {
        if (is_null($note)) {
            throw new \InvalidArgumentException('non-nullable note cannot be null');
        }
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets change_qty
     *
     * @return int|null
     */
    public function getChangeQty()
    {
        return $this->container['change_qty'];
    }

    /**
     * Sets change_qty
     *
     * @param int|null $change_qty Changed quantity
     *
     * @return self
     */
    public function setChangeQty($change_qty)
    {
        if (is_null($change_qty)) {
            throw new \InvalidArgumentException('non-nullable change_qty cannot be null');
        }
        $this->container['change_qty'] = $change_qty;

        return $this;
    }

    /**
     * Gets change_value
     *
     * @return float|null
     */
    public function getChangeValue()
    {
        return $this->container['change_value'];
    }

    /**
     * Sets change_value
     *
     * @param float|null $change_value Changed value
     *
     * @return self
     */
    public function setChangeValue($change_value)
    {
        if (is_null($change_value)) {
            throw new \InvalidArgumentException('non-nullable change_value cannot be null');
        }
        $this->container['change_value'] = $change_value;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id Stock Item interger Id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


