<?php
/**
 * StockItemBatch
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * StockItemBatch Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemBatch implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemBatch';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'batch_id' => 'int',
        'sku' => 'string',
        'inventory_tracking_type' => 'int',
        'stock_item_id' => 'string',
        'batch_number' => 'string',
        'expires_on' => '\DateTime',
        'sell_by' => '\DateTime',
        'inventory' => '\Linnworks\Stock\Model\StockItemBatchInventory[]',
        'is_deleted' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'batch_id' => 'int32',
        'sku' => null,
        'inventory_tracking_type' => 'int32',
        'stock_item_id' => 'uuid',
        'batch_number' => null,
        'expires_on' => 'date-time',
        'sell_by' => 'date-time',
        'inventory' => null,
        'is_deleted' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'batch_id' => false,
        'sku' => false,
        'inventory_tracking_type' => false,
        'stock_item_id' => false,
        'batch_number' => false,
        'expires_on' => false,
        'sell_by' => false,
        'inventory' => false,
        'is_deleted' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'batch_id' => 'BatchId',
        'sku' => 'SKU',
        'inventory_tracking_type' => 'InventoryTrackingType',
        'stock_item_id' => 'StockItemId',
        'batch_number' => 'BatchNumber',
        'expires_on' => 'ExpiresOn',
        'sell_by' => 'SellBy',
        'inventory' => 'Inventory',
        'is_deleted' => 'IsDeleted'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'batch_id' => 'setBatchId',
        'sku' => 'setSku',
        'inventory_tracking_type' => 'setInventoryTrackingType',
        'stock_item_id' => 'setStockItemId',
        'batch_number' => 'setBatchNumber',
        'expires_on' => 'setExpiresOn',
        'sell_by' => 'setSellBy',
        'inventory' => 'setInventory',
        'is_deleted' => 'setIsDeleted'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'batch_id' => 'getBatchId',
        'sku' => 'getSku',
        'inventory_tracking_type' => 'getInventoryTrackingType',
        'stock_item_id' => 'getStockItemId',
        'batch_number' => 'getBatchNumber',
        'expires_on' => 'getExpiresOn',
        'sell_by' => 'getSellBy',
        'inventory' => 'getInventory',
        'is_deleted' => 'getIsDeleted'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('batch_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('inventory_tracking_type', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('batch_number', $data ?? [], null);
        $this->setIfExists('expires_on', $data ?? [], null);
        $this->setIfExists('sell_by', $data ?? [], null);
        $this->setIfExists('inventory', $data ?? [], null);
        $this->setIfExists('is_deleted', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets batch_id
     *
     * @return int|null
     */
    public function getBatchId()
    {
        return $this->container['batch_id'];
    }

    /**
     * Sets batch_id
     *
     * @param int|null $batch_id Batch ID
     *
     * @return self
     */
    public function setBatchId($batch_id)
    {
        if (is_null($batch_id)) {
            throw new \InvalidArgumentException('non-nullable batch_id cannot be null');
        }
        $this->container['batch_id'] = $batch_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets inventory_tracking_type
     *
     * @return int|null
     */
    public function getInventoryTrackingType()
    {
        return $this->container['inventory_tracking_type'];
    }

    /**
     * Sets inventory_tracking_type
     *
     * @param int|null $inventory_tracking_type 0 - None, 1 - Order by sell by date, 2 - Ordered by priority sequence
     *
     * @return self
     */
    public function setInventoryTrackingType($inventory_tracking_type)
    {
        if (is_null($inventory_tracking_type)) {
            throw new \InvalidArgumentException('non-nullable inventory_tracking_type cannot be null');
        }
        $this->container['inventory_tracking_type'] = $inventory_tracking_type;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Product ID
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets batch_number
     *
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->container['batch_number'];
    }

    /**
     * Sets batch_number
     *
     * @param string|null $batch_number Batch number
     *
     * @return self
     */
    public function setBatchNumber($batch_number)
    {
        if (is_null($batch_number)) {
            throw new \InvalidArgumentException('non-nullable batch_number cannot be null');
        }
        $this->container['batch_number'] = $batch_number;

        return $this;
    }

    /**
     * Gets expires_on
     *
     * @return \DateTime|null
     */
    public function getExpiresOn()
    {
        return $this->container['expires_on'];
    }

    /**
     * Sets expires_on
     *
     * @param \DateTime|null $expires_on Batch expiry date
     *
     * @return self
     */
    public function setExpiresOn($expires_on)
    {
        if (is_null($expires_on)) {
            throw new \InvalidArgumentException('non-nullable expires_on cannot be null');
        }
        $this->container['expires_on'] = $expires_on;

        return $this;
    }

    /**
     * Gets sell_by
     *
     * @return \DateTime|null
     */
    public function getSellBy()
    {
        return $this->container['sell_by'];
    }

    /**
     * Sets sell_by
     *
     * @param \DateTime|null $sell_by Batch sell by date
     *
     * @return self
     */
    public function setSellBy($sell_by)
    {
        if (is_null($sell_by)) {
            throw new \InvalidArgumentException('non-nullable sell_by cannot be null');
        }
        $this->container['sell_by'] = $sell_by;

        return $this;
    }

    /**
     * Gets inventory
     *
     * @return \Linnworks\Stock\Model\StockItemBatchInventory[]|null
     */
    public function getInventory()
    {
        return $this->container['inventory'];
    }

    /**
     * Sets inventory
     *
     * @param \Linnworks\Stock\Model\StockItemBatchInventory[]|null $inventory Batch records
     *
     * @return self
     */
    public function setInventory($inventory)
    {
        if (is_null($inventory)) {
            throw new \InvalidArgumentException('non-nullable inventory cannot be null');
        }
        $this->container['inventory'] = $inventory;

        return $this;
    }

    /**
     * Gets is_deleted
     *
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return $this->container['is_deleted'];
    }

    /**
     * Sets is_deleted
     *
     * @param bool|null $is_deleted Is the batch deleted
     *
     * @return self
     */
    public function setIsDeleted($is_deleted)
    {
        if (is_null($is_deleted)) {
            throw new \InvalidArgumentException('non-nullable is_deleted cannot be null');
        }
        $this->container['is_deleted'] = $is_deleted;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


