<?php
/**
 * StockItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * StockItem Class Doc Comment
 *
 * @category Class
 * @description Stock Item
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'item_description' => 'string',
        'quantity' => 'int',
        'in_order' => 'int',
        'due' => 'int',
        'minimum_level' => 'int',
        'available' => 'int',
        'is_composite_parent' => 'bool',
        'shipped_separately' => 'bool',
        'item_number' => 'string',
        'item_title' => 'string',
        'barcode_number' => 'string',
        'meta_data' => 'string',
        'is_variation_parent' => 'bool',
        'is_batched_stock_type' => 'bool',
        'purchase_price' => 'float',
        'retail_price' => 'float',
        'tax_rate' => 'float',
        'postal_service_id' => 'string',
        'postal_service_name' => 'string',
        'category_id' => 'string',
        'category_name' => 'string',
        'package_group_id' => 'string',
        'package_group_name' => 'string',
        'height' => 'float',
        'width' => 'float',
        'depth' => 'float',
        'weight' => 'float',
        'creation_date' => '\DateTime',
        'inventory_tracking_type' => 'int',
        'batch_number_scan_required' => 'bool',
        'serial_number_scan_required' => 'bool',
        'stock_item_id' => 'string',
        'stock_item_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'item_description' => null,
        'quantity' => 'int32',
        'in_order' => 'int32',
        'due' => 'int32',
        'minimum_level' => 'int32',
        'available' => 'int32',
        'is_composite_parent' => null,
        'shipped_separately' => null,
        'item_number' => null,
        'item_title' => null,
        'barcode_number' => null,
        'meta_data' => null,
        'is_variation_parent' => null,
        'is_batched_stock_type' => null,
        'purchase_price' => 'double',
        'retail_price' => 'double',
        'tax_rate' => 'double',
        'postal_service_id' => 'uuid',
        'postal_service_name' => null,
        'category_id' => 'uuid',
        'category_name' => null,
        'package_group_id' => 'uuid',
        'package_group_name' => null,
        'height' => 'double',
        'width' => 'double',
        'depth' => 'double',
        'weight' => 'double',
        'creation_date' => 'date-time',
        'inventory_tracking_type' => 'int32',
        'batch_number_scan_required' => null,
        'serial_number_scan_required' => null,
        'stock_item_id' => 'uuid',
        'stock_item_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'item_description' => false,
        'quantity' => false,
        'in_order' => false,
        'due' => false,
        'minimum_level' => false,
        'available' => false,
        'is_composite_parent' => false,
        'shipped_separately' => false,
        'item_number' => false,
        'item_title' => false,
        'barcode_number' => false,
        'meta_data' => false,
        'is_variation_parent' => false,
        'is_batched_stock_type' => false,
        'purchase_price' => false,
        'retail_price' => false,
        'tax_rate' => false,
        'postal_service_id' => false,
        'postal_service_name' => false,
        'category_id' => false,
        'category_name' => false,
        'package_group_id' => false,
        'package_group_name' => false,
        'height' => false,
        'width' => false,
        'depth' => false,
        'weight' => false,
        'creation_date' => false,
        'inventory_tracking_type' => false,
        'batch_number_scan_required' => false,
        'serial_number_scan_required' => false,
        'stock_item_id' => false,
        'stock_item_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'item_description' => 'ItemDescription',
        'quantity' => 'Quantity',
        'in_order' => 'InOrder',
        'due' => 'Due',
        'minimum_level' => 'MinimumLevel',
        'available' => 'Available',
        'is_composite_parent' => 'IsCompositeParent',
        'shipped_separately' => 'ShippedSeparately',
        'item_number' => 'ItemNumber',
        'item_title' => 'ItemTitle',
        'barcode_number' => 'BarcodeNumber',
        'meta_data' => 'MetaData',
        'is_variation_parent' => 'IsVariationParent',
        'is_batched_stock_type' => 'isBatchedStockType',
        'purchase_price' => 'PurchasePrice',
        'retail_price' => 'RetailPrice',
        'tax_rate' => 'TaxRate',
        'postal_service_id' => 'PostalServiceId',
        'postal_service_name' => 'PostalServiceName',
        'category_id' => 'CategoryId',
        'category_name' => 'CategoryName',
        'package_group_id' => 'PackageGroupId',
        'package_group_name' => 'PackageGroupName',
        'height' => 'Height',
        'width' => 'Width',
        'depth' => 'Depth',
        'weight' => 'Weight',
        'creation_date' => 'CreationDate',
        'inventory_tracking_type' => 'InventoryTrackingType',
        'batch_number_scan_required' => 'BatchNumberScanRequired',
        'serial_number_scan_required' => 'SerialNumberScanRequired',
        'stock_item_id' => 'StockItemId',
        'stock_item_int_id' => 'StockItemIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'item_description' => 'setItemDescription',
        'quantity' => 'setQuantity',
        'in_order' => 'setInOrder',
        'due' => 'setDue',
        'minimum_level' => 'setMinimumLevel',
        'available' => 'setAvailable',
        'is_composite_parent' => 'setIsCompositeParent',
        'shipped_separately' => 'setShippedSeparately',
        'item_number' => 'setItemNumber',
        'item_title' => 'setItemTitle',
        'barcode_number' => 'setBarcodeNumber',
        'meta_data' => 'setMetaData',
        'is_variation_parent' => 'setIsVariationParent',
        'is_batched_stock_type' => 'setIsBatchedStockType',
        'purchase_price' => 'setPurchasePrice',
        'retail_price' => 'setRetailPrice',
        'tax_rate' => 'setTaxRate',
        'postal_service_id' => 'setPostalServiceId',
        'postal_service_name' => 'setPostalServiceName',
        'category_id' => 'setCategoryId',
        'category_name' => 'setCategoryName',
        'package_group_id' => 'setPackageGroupId',
        'package_group_name' => 'setPackageGroupName',
        'height' => 'setHeight',
        'width' => 'setWidth',
        'depth' => 'setDepth',
        'weight' => 'setWeight',
        'creation_date' => 'setCreationDate',
        'inventory_tracking_type' => 'setInventoryTrackingType',
        'batch_number_scan_required' => 'setBatchNumberScanRequired',
        'serial_number_scan_required' => 'setSerialNumberScanRequired',
        'stock_item_id' => 'setStockItemId',
        'stock_item_int_id' => 'setStockItemIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'item_description' => 'getItemDescription',
        'quantity' => 'getQuantity',
        'in_order' => 'getInOrder',
        'due' => 'getDue',
        'minimum_level' => 'getMinimumLevel',
        'available' => 'getAvailable',
        'is_composite_parent' => 'getIsCompositeParent',
        'shipped_separately' => 'getShippedSeparately',
        'item_number' => 'getItemNumber',
        'item_title' => 'getItemTitle',
        'barcode_number' => 'getBarcodeNumber',
        'meta_data' => 'getMetaData',
        'is_variation_parent' => 'getIsVariationParent',
        'is_batched_stock_type' => 'getIsBatchedStockType',
        'purchase_price' => 'getPurchasePrice',
        'retail_price' => 'getRetailPrice',
        'tax_rate' => 'getTaxRate',
        'postal_service_id' => 'getPostalServiceId',
        'postal_service_name' => 'getPostalServiceName',
        'category_id' => 'getCategoryId',
        'category_name' => 'getCategoryName',
        'package_group_id' => 'getPackageGroupId',
        'package_group_name' => 'getPackageGroupName',
        'height' => 'getHeight',
        'width' => 'getWidth',
        'depth' => 'getDepth',
        'weight' => 'getWeight',
        'creation_date' => 'getCreationDate',
        'inventory_tracking_type' => 'getInventoryTrackingType',
        'batch_number_scan_required' => 'getBatchNumberScanRequired',
        'serial_number_scan_required' => 'getSerialNumberScanRequired',
        'stock_item_id' => 'getStockItemId',
        'stock_item_int_id' => 'getStockItemIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('item_description', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('in_order', $data ?? [], null);
        $this->setIfExists('due', $data ?? [], null);
        $this->setIfExists('minimum_level', $data ?? [], null);
        $this->setIfExists('available', $data ?? [], null);
        $this->setIfExists('is_composite_parent', $data ?? [], null);
        $this->setIfExists('shipped_separately', $data ?? [], null);
        $this->setIfExists('item_number', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('barcode_number', $data ?? [], null);
        $this->setIfExists('meta_data', $data ?? [], null);
        $this->setIfExists('is_variation_parent', $data ?? [], null);
        $this->setIfExists('is_batched_stock_type', $data ?? [], null);
        $this->setIfExists('purchase_price', $data ?? [], null);
        $this->setIfExists('retail_price', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('postal_service_id', $data ?? [], null);
        $this->setIfExists('postal_service_name', $data ?? [], null);
        $this->setIfExists('category_id', $data ?? [], null);
        $this->setIfExists('category_name', $data ?? [], null);
        $this->setIfExists('package_group_id', $data ?? [], null);
        $this->setIfExists('package_group_name', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('creation_date', $data ?? [], null);
        $this->setIfExists('inventory_tracking_type', $data ?? [], null);
        $this->setIfExists('batch_number_scan_required', $data ?? [], null);
        $this->setIfExists('serial_number_scan_required', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets item_description
     *
     * @return string|null
     */
    public function getItemDescription()
    {
        return $this->container['item_description'];
    }

    /**
     * Sets item_description
     *
     * @param string|null $item_description Item Description(Metadata)
     *
     * @return self
     */
    public function setItemDescription($item_description)
    {
        if (is_null($item_description)) {
            throw new \InvalidArgumentException('non-nullable item_description cannot be null');
        }
        $this->container['item_description'] = $item_description;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity in stock
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets in_order
     *
     * @return int|null
     */
    public function getInOrder()
    {
        return $this->container['in_order'];
    }

    /**
     * Sets in_order
     *
     * @param int|null $in_order Quantity in order book
     *
     * @return self
     */
    public function setInOrder($in_order)
    {
        if (is_null($in_order)) {
            throw new \InvalidArgumentException('non-nullable in_order cannot be null');
        }
        $this->container['in_order'] = $in_order;

        return $this;
    }

    /**
     * Gets due
     *
     * @return int|null
     */
    public function getDue()
    {
        return $this->container['due'];
    }

    /**
     * Sets due
     *
     * @param int|null $due Quantity due in purchase orders
     *
     * @return self
     */
    public function setDue($due)
    {
        if (is_null($due)) {
            throw new \InvalidArgumentException('non-nullable due cannot be null');
        }
        $this->container['due'] = $due;

        return $this;
    }

    /**
     * Gets minimum_level
     *
     * @return int|null
     */
    public function getMinimumLevel()
    {
        return $this->container['minimum_level'];
    }

    /**
     * Sets minimum_level
     *
     * @param int|null $minimum_level Minimum level of stock item. -1 is not tracked. Null value when adding will use user default minimum level
     *
     * @return self
     */
    public function setMinimumLevel($minimum_level)
    {
        if (is_null($minimum_level)) {
            throw new \InvalidArgumentException('non-nullable minimum_level cannot be null');
        }
        $this->container['minimum_level'] = $minimum_level;

        return $this;
    }

    /**
     * Gets available
     *
     * @return int|null
     */
    public function getAvailable()
    {
        return $this->container['available'];
    }

    /**
     * Sets available
     *
     * @param int|null $available Available level. Quantity - InOrder
     *
     * @return self
     */
    public function setAvailable($available)
    {
        if (is_null($available)) {
            throw new \InvalidArgumentException('non-nullable available cannot be null');
        }
        $this->container['available'] = $available;

        return $this;
    }

    /**
     * Gets is_composite_parent
     *
     * @return bool|null
     */
    public function getIsCompositeParent()
    {
        return $this->container['is_composite_parent'];
    }

    /**
     * Sets is_composite_parent
     *
     * @param bool|null $is_composite_parent Item is a composite parent
     *
     * @return self
     */
    public function setIsCompositeParent($is_composite_parent)
    {
        if (is_null($is_composite_parent)) {
            throw new \InvalidArgumentException('non-nullable is_composite_parent cannot be null');
        }
        $this->container['is_composite_parent'] = $is_composite_parent;

        return $this;
    }

    /**
     * Gets shipped_separately
     *
     * @return bool|null
     */
    public function getShippedSeparately()
    {
        return $this->container['shipped_separately'];
    }

    /**
     * Sets shipped_separately
     *
     * @param bool|null $shipped_separately shipped_separately
     *
     * @return self
     */
    public function setShippedSeparately($shipped_separately)
    {
        if (is_null($shipped_separately)) {
            throw new \InvalidArgumentException('non-nullable shipped_separately cannot be null');
        }
        $this->container['shipped_separately'] = $shipped_separately;

        return $this;
    }

    /**
     * Gets item_number
     *
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->container['item_number'];
    }

    /**
     * Sets item_number
     *
     * @param string|null $item_number SKU
     *
     * @return self
     */
    public function setItemNumber($item_number)
    {
        if (is_null($item_number)) {
            throw new \InvalidArgumentException('non-nullable item_number cannot be null');
        }
        $this->container['item_number'] = $item_number;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title Item title
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets barcode_number
     *
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->container['barcode_number'];
    }

    /**
     * Sets barcode_number
     *
     * @param string|null $barcode_number Barcode number
     *
     * @return self
     */
    public function setBarcodeNumber($barcode_number)
    {
        if (is_null($barcode_number)) {
            throw new \InvalidArgumentException('non-nullable barcode_number cannot be null');
        }
        $this->container['barcode_number'] = $barcode_number;

        return $this;
    }

    /**
     * Gets meta_data
     *
     * @return string|null
     */
    public function getMetaData()
    {
        return $this->container['meta_data'];
    }

    /**
     * Sets meta_data
     *
     * @param string|null $meta_data Item description
     *
     * @return self
     */
    public function setMetaData($meta_data)
    {
        if (is_null($meta_data)) {
            throw new \InvalidArgumentException('non-nullable meta_data cannot be null');
        }
        $this->container['meta_data'] = $meta_data;

        return $this;
    }

    /**
     * Gets is_variation_parent
     *
     * @return bool|null
     */
    public function getIsVariationParent()
    {
        return $this->container['is_variation_parent'];
    }

    /**
     * Sets is_variation_parent
     *
     * @param bool|null $is_variation_parent Is Variation Parent
     *
     * @return self
     */
    public function setIsVariationParent($is_variation_parent)
    {
        if (is_null($is_variation_parent)) {
            throw new \InvalidArgumentException('non-nullable is_variation_parent cannot be null');
        }
        $this->container['is_variation_parent'] = $is_variation_parent;

        return $this;
    }

    /**
     * Gets is_batched_stock_type
     *
     * @return bool|null
     */
    public function getIsBatchedStockType()
    {
        return $this->container['is_batched_stock_type'];
    }

    /**
     * Sets is_batched_stock_type
     *
     * @param bool|null $is_batched_stock_type Returns true is the stock item is tracked by batch
     *
     * @return self
     */
    public function setIsBatchedStockType($is_batched_stock_type)
    {
        if (is_null($is_batched_stock_type)) {
            throw new \InvalidArgumentException('non-nullable is_batched_stock_type cannot be null');
        }
        $this->container['is_batched_stock_type'] = $is_batched_stock_type;

        return $this;
    }

    /**
     * Gets purchase_price
     *
     * @return float|null
     */
    public function getPurchasePrice()
    {
        return $this->container['purchase_price'];
    }

    /**
     * Sets purchase_price
     *
     * @param float|null $purchase_price Default item purchase price
     *
     * @return self
     */
    public function setPurchasePrice($purchase_price)
    {
        if (is_null($purchase_price)) {
            throw new \InvalidArgumentException('non-nullable purchase_price cannot be null');
        }
        $this->container['purchase_price'] = $purchase_price;

        return $this;
    }

    /**
     * Gets retail_price
     *
     * @return float|null
     */
    public function getRetailPrice()
    {
        return $this->container['retail_price'];
    }

    /**
     * Sets retail_price
     *
     * @param float|null $retail_price Default item retail price
     *
     * @return self
     */
    public function setRetailPrice($retail_price)
    {
        if (is_null($retail_price)) {
            throw new \InvalidArgumentException('non-nullable retail_price cannot be null');
        }
        $this->container['retail_price'] = $retail_price;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate Default item tax rate. Set -1 to use country tax rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets postal_service_id
     *
     * @return string|null
     */
    public function getPostalServiceId()
    {
        return $this->container['postal_service_id'];
    }

    /**
     * Sets postal_service_id
     *
     * @param string|null $postal_service_id Default postal service id
     *
     * @return self
     */
    public function setPostalServiceId($postal_service_id)
    {
        if (is_null($postal_service_id)) {
            throw new \InvalidArgumentException('non-nullable postal_service_id cannot be null');
        }
        $this->container['postal_service_id'] = $postal_service_id;

        return $this;
    }

    /**
     * Gets postal_service_name
     *
     * @return string|null
     */
    public function getPostalServiceName()
    {
        return $this->container['postal_service_name'];
    }

    /**
     * Sets postal_service_name
     *
     * @param string|null $postal_service_name Default postal service name
     *
     * @return self
     */
    public function setPostalServiceName($postal_service_name)
    {
        if (is_null($postal_service_name)) {
            throw new \InvalidArgumentException('non-nullable postal_service_name cannot be null');
        }
        $this->container['postal_service_name'] = $postal_service_name;

        return $this;
    }

    /**
     * Gets category_id
     *
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->container['category_id'];
    }

    /**
     * Sets category_id
     *
     * @param string|null $category_id Default category id
     *
     * @return self
     */
    public function setCategoryId($category_id)
    {
        if (is_null($category_id)) {
            throw new \InvalidArgumentException('non-nullable category_id cannot be null');
        }
        $this->container['category_id'] = $category_id;

        return $this;
    }

    /**
     * Gets category_name
     *
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->container['category_name'];
    }

    /**
     * Sets category_name
     *
     * @param string|null $category_name Default category name
     *
     * @return self
     */
    public function setCategoryName($category_name)
    {
        if (is_null($category_name)) {
            throw new \InvalidArgumentException('non-nullable category_name cannot be null');
        }
        $this->container['category_name'] = $category_name;

        return $this;
    }

    /**
     * Gets package_group_id
     *
     * @return string|null
     */
    public function getPackageGroupId()
    {
        return $this->container['package_group_id'];
    }

    /**
     * Sets package_group_id
     *
     * @param string|null $package_group_id Default package group id
     *
     * @return self
     */
    public function setPackageGroupId($package_group_id)
    {
        if (is_null($package_group_id)) {
            throw new \InvalidArgumentException('non-nullable package_group_id cannot be null');
        }
        $this->container['package_group_id'] = $package_group_id;

        return $this;
    }

    /**
     * Gets package_group_name
     *
     * @return string|null
     */
    public function getPackageGroupName()
    {
        return $this->container['package_group_name'];
    }

    /**
     * Sets package_group_name
     *
     * @param string|null $package_group_name Default package group name
     *
     * @return self
     */
    public function setPackageGroupName($package_group_name)
    {
        if (is_null($package_group_name)) {
            throw new \InvalidArgumentException('non-nullable package_group_name cannot be null');
        }
        $this->container['package_group_name'] = $package_group_name;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height Item height
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width Item width
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth Item depth
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            throw new \InvalidArgumentException('non-nullable depth cannot be null');
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight Item weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets creation_date
     *
     * @return \DateTime|null
     */
    public function getCreationDate()
    {
        return $this->container['creation_date'];
    }

    /**
     * Sets creation_date
     *
     * @param \DateTime|null $creation_date Stock item creation date
     *
     * @return self
     */
    public function setCreationDate($creation_date)
    {
        if (is_null($creation_date)) {
            throw new \InvalidArgumentException('non-nullable creation_date cannot be null');
        }
        $this->container['creation_date'] = $creation_date;

        return $this;
    }

    /**
     * Gets inventory_tracking_type
     *
     * @return int|null
     */
    public function getInventoryTrackingType()
    {
        return $this->container['inventory_tracking_type'];
    }

    /**
     * Sets inventory_tracking_type
     *
     * @param int|null $inventory_tracking_type Stock item tracking type. 0 = none. 1 = Ordered by Sell by Date. 2 = Ordered by Priority Sequence
     *
     * @return self
     */
    public function setInventoryTrackingType($inventory_tracking_type)
    {
        if (is_null($inventory_tracking_type)) {
            throw new \InvalidArgumentException('non-nullable inventory_tracking_type cannot be null');
        }
        $this->container['inventory_tracking_type'] = $inventory_tracking_type;

        return $this;
    }

    /**
     * Gets batch_number_scan_required
     *
     * @return bool|null
     */
    public function getBatchNumberScanRequired()
    {
        return $this->container['batch_number_scan_required'];
    }

    /**
     * Sets batch_number_scan_required
     *
     * @param bool|null $batch_number_scan_required User must scan batch number when procesing orders
     *
     * @return self
     */
    public function setBatchNumberScanRequired($batch_number_scan_required)
    {
        if (is_null($batch_number_scan_required)) {
            throw new \InvalidArgumentException('non-nullable batch_number_scan_required cannot be null');
        }
        $this->container['batch_number_scan_required'] = $batch_number_scan_required;

        return $this;
    }

    /**
     * Gets serial_number_scan_required
     *
     * @return bool|null
     */
    public function getSerialNumberScanRequired()
    {
        return $this->container['serial_number_scan_required'];
    }

    /**
     * Sets serial_number_scan_required
     *
     * @param bool|null $serial_number_scan_required User must scan item serial number when processing ordesr
     *
     * @return self
     */
    public function setSerialNumberScanRequired($serial_number_scan_required)
    {
        if (is_null($serial_number_scan_required)) {
            throw new \InvalidArgumentException('non-nullable serial_number_scan_required cannot be null');
        }
        $this->container['serial_number_scan_required'] = $serial_number_scan_required;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id Stock Item interger Id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


