<?php
/**
 * StockGetStockItemsFullRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * StockGetStockItemsFullRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockGetStockItemsFullRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Stock_GetStockItemsFullRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'keyword' => 'string',
        'load_composite_parents' => 'bool',
        'load_variation_parents' => 'bool',
        'entries_per_page' => 'int',
        'page_number' => 'int',
        'data_requirements' => 'string[]',
        'search_types' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'keyword' => null,
        'load_composite_parents' => null,
        'load_variation_parents' => null,
        'entries_per_page' => 'int32',
        'page_number' => 'int32',
        'data_requirements' => null,
        'search_types' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'keyword' => false,
        'load_composite_parents' => false,
        'load_variation_parents' => false,
        'entries_per_page' => false,
        'page_number' => false,
        'data_requirements' => false,
        'search_types' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'keyword' => 'keyword',
        'load_composite_parents' => 'loadCompositeParents',
        'load_variation_parents' => 'loadVariationParents',
        'entries_per_page' => 'entriesPerPage',
        'page_number' => 'pageNumber',
        'data_requirements' => 'dataRequirements',
        'search_types' => 'searchTypes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'keyword' => 'setKeyword',
        'load_composite_parents' => 'setLoadCompositeParents',
        'load_variation_parents' => 'setLoadVariationParents',
        'entries_per_page' => 'setEntriesPerPage',
        'page_number' => 'setPageNumber',
        'data_requirements' => 'setDataRequirements',
        'search_types' => 'setSearchTypes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'keyword' => 'getKeyword',
        'load_composite_parents' => 'getLoadCompositeParents',
        'load_variation_parents' => 'getLoadVariationParents',
        'entries_per_page' => 'getEntriesPerPage',
        'page_number' => 'getPageNumber',
        'data_requirements' => 'getDataRequirements',
        'search_types' => 'getSearchTypes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const DATA_REQUIREMENTS_STOCK_LEVELS = 'StockLevels';
    public const DATA_REQUIREMENTS_PRICING = 'Pricing';
    public const DATA_REQUIREMENTS_SUPPLIER = 'Supplier';
    public const DATA_REQUIREMENTS_SHIPPING_INFORMATION = 'ShippingInformation';
    public const DATA_REQUIREMENTS_CHANNEL_TITLE = 'ChannelTitle';
    public const DATA_REQUIREMENTS_CHANNEL_DESCRIPTION = 'ChannelDescription';
    public const DATA_REQUIREMENTS_CHANNEL_PRICE = 'ChannelPrice';
    public const DATA_REQUIREMENTS_EXTENDED_PROPERTIES = 'ExtendedProperties';
    public const DATA_REQUIREMENTS_IMAGES = 'Images';
    public const SEARCH_TYPES_SKU = 'SKU';
    public const SEARCH_TYPES_TITLE = 'Title';
    public const SEARCH_TYPES_BARCODE = 'Barcode';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getDataRequirementsAllowableValues()
    {
        return [
            self::DATA_REQUIREMENTS_STOCK_LEVELS,
            self::DATA_REQUIREMENTS_PRICING,
            self::DATA_REQUIREMENTS_SUPPLIER,
            self::DATA_REQUIREMENTS_SHIPPING_INFORMATION,
            self::DATA_REQUIREMENTS_CHANNEL_TITLE,
            self::DATA_REQUIREMENTS_CHANNEL_DESCRIPTION,
            self::DATA_REQUIREMENTS_CHANNEL_PRICE,
            self::DATA_REQUIREMENTS_EXTENDED_PROPERTIES,
            self::DATA_REQUIREMENTS_IMAGES,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSearchTypesAllowableValues()
    {
        return [
            self::SEARCH_TYPES_SKU,
            self::SEARCH_TYPES_TITLE,
            self::SEARCH_TYPES_BARCODE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('keyword', $data ?? [], null);
        $this->setIfExists('load_composite_parents', $data ?? [], null);
        $this->setIfExists('load_variation_parents', $data ?? [], null);
        $this->setIfExists('entries_per_page', $data ?? [], null);
        $this->setIfExists('page_number', $data ?? [], null);
        $this->setIfExists('data_requirements', $data ?? [], null);
        $this->setIfExists('search_types', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets keyword
     *
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->container['keyword'];
    }

    /**
     * Sets keyword
     *
     * @param string|null $keyword Your seearch term
     *
     * @return self
     */
    public function setKeyword($keyword)
    {
        if (is_null($keyword)) {
            throw new \InvalidArgumentException('non-nullable keyword cannot be null');
        }
        $this->container['keyword'] = $keyword;

        return $this;
    }

    /**
     * Gets load_composite_parents
     *
     * @return bool|null
     */
    public function getLoadCompositeParents()
    {
        return $this->container['load_composite_parents'];
    }

    /**
     * Sets load_composite_parents
     *
     * @param bool|null $load_composite_parents Whether you want to load composite parents or ignore them
     *
     * @return self
     */
    public function setLoadCompositeParents($load_composite_parents)
    {
        if (is_null($load_composite_parents)) {
            throw new \InvalidArgumentException('non-nullable load_composite_parents cannot be null');
        }
        $this->container['load_composite_parents'] = $load_composite_parents;

        return $this;
    }

    /**
     * Gets load_variation_parents
     *
     * @return bool|null
     */
    public function getLoadVariationParents()
    {
        return $this->container['load_variation_parents'];
    }

    /**
     * Sets load_variation_parents
     *
     * @param bool|null $load_variation_parents Whether you want to load variation parents
     *
     * @return self
     */
    public function setLoadVariationParents($load_variation_parents)
    {
        if (is_null($load_variation_parents)) {
            throw new \InvalidArgumentException('non-nullable load_variation_parents cannot be null');
        }
        $this->container['load_variation_parents'] = $load_variation_parents;

        return $this;
    }

    /**
     * Gets entries_per_page
     *
     * @return int|null
     */
    public function getEntriesPerPage()
    {
        return $this->container['entries_per_page'];
    }

    /**
     * Sets entries_per_page
     *
     * @param int|null $entries_per_page The amount of entries you require. Maximum 200.
     *
     * @return self
     */
    public function setEntriesPerPage($entries_per_page)
    {
        if (is_null($entries_per_page)) {
            throw new \InvalidArgumentException('non-nullable entries_per_page cannot be null');
        }
        $this->container['entries_per_page'] = $entries_per_page;

        return $this;
    }

    /**
     * Gets page_number
     *
     * @return int|null
     */
    public function getPageNumber()
    {
        return $this->container['page_number'];
    }

    /**
     * Sets page_number
     *
     * @param int|null $page_number The current page number you are requesting
     *
     * @return self
     */
    public function setPageNumber($page_number)
    {
        if (is_null($page_number)) {
            throw new \InvalidArgumentException('non-nullable page_number cannot be null');
        }
        $this->container['page_number'] = $page_number;

        return $this;
    }

    /**
     * Gets data_requirements
     *
     * @return string[]|null
     */
    public function getDataRequirements()
    {
        return $this->container['data_requirements'];
    }

    /**
     * Sets data_requirements
     *
     * @param string[]|null $data_requirements The data you require. eg. StockLevels will load the stock levels for each location
     *
     * @return self
     */
    public function setDataRequirements($data_requirements)
    {
        if (is_null($data_requirements)) {
            throw new \InvalidArgumentException('non-nullable data_requirements cannot be null');
        }
        $allowedValues = $this->getDataRequirementsAllowableValues();
        if (array_diff($data_requirements, $allowedValues)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'data_requirements', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['data_requirements'] = $data_requirements;

        return $this;
    }

    /**
     * Gets search_types
     *
     * @return string[]|null
     */
    public function getSearchTypes()
    {
        return $this->container['search_types'];
    }

    /**
     * Sets search_types
     *
     * @param string[]|null $search_types The parameters that you would like to search by
     *
     * @return self
     */
    public function setSearchTypes($search_types)
    {
        if (is_null($search_types)) {
            throw new \InvalidArgumentException('non-nullable search_types cannot be null');
        }
        $allowedValues = $this->getSearchTypesAllowableValues();
        if (array_diff($search_types, $allowedValues)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'search_types', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['search_types'] = $search_types;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


