<?php
/**
 * BatchedBookIn
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Model;

use \ArrayAccess;
use \Linnworks\Stock\ObjectSerializer;

/**
 * BatchedBookIn Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BatchedBookIn implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BatchedBookIn';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sku' => 'string',
        'batch_number' => 'string',
        'location_id' => 'string',
        'bin_rack' => 'string',
        'quantity' => 'int',
        'stock_value' => 'float',
        'batch_status' => 'string',
        'priority_sequence' => 'int',
        'expires_on' => '\DateTime',
        'sell_by' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sku' => null,
        'batch_number' => null,
        'location_id' => 'uuid',
        'bin_rack' => null,
        'quantity' => 'int32',
        'stock_value' => 'double',
        'batch_status' => null,
        'priority_sequence' => 'int32',
        'expires_on' => 'date-time',
        'sell_by' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sku' => false,
        'batch_number' => false,
        'location_id' => false,
        'bin_rack' => false,
        'quantity' => false,
        'stock_value' => false,
        'batch_status' => false,
        'priority_sequence' => false,
        'expires_on' => false,
        'sell_by' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sku' => 'SKU',
        'batch_number' => 'BatchNumber',
        'location_id' => 'LocationId',
        'bin_rack' => 'BinRack',
        'quantity' => 'Quantity',
        'stock_value' => 'StockValue',
        'batch_status' => 'BatchStatus',
        'priority_sequence' => 'PrioritySequence',
        'expires_on' => 'ExpiresOn',
        'sell_by' => 'SellBy'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sku' => 'setSku',
        'batch_number' => 'setBatchNumber',
        'location_id' => 'setLocationId',
        'bin_rack' => 'setBinRack',
        'quantity' => 'setQuantity',
        'stock_value' => 'setStockValue',
        'batch_status' => 'setBatchStatus',
        'priority_sequence' => 'setPrioritySequence',
        'expires_on' => 'setExpiresOn',
        'sell_by' => 'setSellBy'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sku' => 'getSku',
        'batch_number' => 'getBatchNumber',
        'location_id' => 'getLocationId',
        'bin_rack' => 'getBinRack',
        'quantity' => 'getQuantity',
        'stock_value' => 'getStockValue',
        'batch_status' => 'getBatchStatus',
        'priority_sequence' => 'getPrioritySequence',
        'expires_on' => 'getExpiresOn',
        'sell_by' => 'getSellBy'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('batch_number', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('bin_rack', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('stock_value', $data ?? [], null);
        $this->setIfExists('batch_status', $data ?? [], null);
        $this->setIfExists('priority_sequence', $data ?? [], null);
        $this->setIfExists('expires_on', $data ?? [], null);
        $this->setIfExists('sell_by', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets batch_number
     *
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->container['batch_number'];
    }

    /**
     * Sets batch_number
     *
     * @param string|null $batch_number Batch number
     *
     * @return self
     */
    public function setBatchNumber($batch_number)
    {
        if (is_null($batch_number)) {
            throw new \InvalidArgumentException('non-nullable batch_number cannot be null');
        }
        $this->container['batch_number'] = $batch_number;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param string|null $location_id Location ID
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets bin_rack
     *
     * @return string|null
     */
    public function getBinRack()
    {
        return $this->container['bin_rack'];
    }

    /**
     * Sets bin_rack
     *
     * @param string|null $bin_rack Bin rack
     *
     * @return self
     */
    public function setBinRack($bin_rack)
    {
        if (is_null($bin_rack)) {
            throw new \InvalidArgumentException('non-nullable bin_rack cannot be null');
        }
        $this->container['bin_rack'] = $bin_rack;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity booked in
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets stock_value
     *
     * @return float|null
     */
    public function getStockValue()
    {
        return $this->container['stock_value'];
    }

    /**
     * Sets stock_value
     *
     * @param float|null $stock_value Stock value
     *
     * @return self
     */
    public function setStockValue($stock_value)
    {
        if (is_null($stock_value)) {
            throw new \InvalidArgumentException('non-nullable stock_value cannot be null');
        }
        $this->container['stock_value'] = $stock_value;

        return $this;
    }

    /**
     * Gets batch_status
     *
     * @return string|null
     */
    public function getBatchStatus()
    {
        return $this->container['batch_status'];
    }

    /**
     * Sets batch_status
     *
     * @param string|null $batch_status Batch status
     *
     * @return self
     */
    public function setBatchStatus($batch_status)
    {
        if (is_null($batch_status)) {
            throw new \InvalidArgumentException('non-nullable batch_status cannot be null');
        }
        $this->container['batch_status'] = $batch_status;

        return $this;
    }

    /**
     * Gets priority_sequence
     *
     * @return int|null
     */
    public function getPrioritySequence()
    {
        return $this->container['priority_sequence'];
    }

    /**
     * Sets priority_sequence
     *
     * @param int|null $priority_sequence priority_sequence
     *
     * @return self
     */
    public function setPrioritySequence($priority_sequence)
    {
        if (is_null($priority_sequence)) {
            throw new \InvalidArgumentException('non-nullable priority_sequence cannot be null');
        }
        $this->container['priority_sequence'] = $priority_sequence;

        return $this;
    }

    /**
     * Gets expires_on
     *
     * @return \DateTime|null
     */
    public function getExpiresOn()
    {
        return $this->container['expires_on'];
    }

    /**
     * Sets expires_on
     *
     * @param \DateTime|null $expires_on Batch expiry date
     *
     * @return self
     */
    public function setExpiresOn($expires_on)
    {
        if (is_null($expires_on)) {
            throw new \InvalidArgumentException('non-nullable expires_on cannot be null');
        }
        $this->container['expires_on'] = $expires_on;

        return $this;
    }

    /**
     * Gets sell_by
     *
     * @return \DateTime|null
     */
    public function getSellBy()
    {
        return $this->container['sell_by'];
    }

    /**
     * Sets sell_by
     *
     * @param \DateTime|null $sell_by Batch sell by date
     *
     * @return self
     */
    public function setSellBy($sell_by)
    {
        if (is_null($sell_by)) {
            throw new \InvalidArgumentException('non-nullable sell_by cannot be null');
        }
        $this->container['sell_by'] = $sell_by;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


