<?php
/**
 * StockApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Stock API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: stock
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Stock\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Linnworks\Stock\ApiException;
use Linnworks\Stock\Configuration;
use Linnworks\Stock\HeaderSelector;
use Linnworks\Stock\ObjectSerializer;

/**
 * StockApi Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Stock
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class StockApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addRollingStockTake' => [
            'application/json',
        ],
        'addVariationItems' => [
            'application/json',
        ],
        'batchStockLevelDelta' => [
            'application/json',
        ],
        'bookInStockBatch' => [
            'application/json',
        ],
        'bookInStockItem' => [
            'application/json',
        ],
        'checkVariationParentSKUExists' => [
            'application/json',
        ],
        'completeWarehouseMove' => [
            'application/json',
        ],
        'createStockBatches' => [
            'application/json',
        ],
        'createVariationGroup' => [
            'application/json',
        ],
        'createWarehouseMove' => [
            'application/json',
        ],
        'deleteMove' => [
            'application/json',
        ],
        'deleteVariationGroup' => [
            'application/json',
        ],
        'deleteVariationGroups' => [
            'application/json',
        ],
        'deleteVariationItem' => [
            'application/json',
        ],
        'deleteVariationItems' => [
            'application/json',
        ],
        'getBinRacksById' => [
            'application/json',
        ],
        'getBinrackSkus' => [
            'application/json',
        ],
        'getItemChangesHistory' => [
            'application/json',
        ],
        'getItemChangesHistoryCSV' => [
            'application/json',
        ],
        'getSoldStat' => [
            'application/json',
        ],
        'getStockConsumption' => [
            'application/json',
        ],
        'getStockDuePO' => [
            'application/json',
        ],
        'getStockItemReturnStat' => [
            'application/json',
        ],
        'getStockItemScrapStat' => [
            'application/json',
        ],
        'getStockItemTypeInfo' => [
            'application/json',
        ],
        'getStockItems' => [
            'application/json',
        ],
        'getStockItemsByIds' => [
            'application/json',
        ],
        'getStockItemsByKey' => [
            'application/json',
        ],
        'getStockItemsFull' => [
            'application/json',
        ],
        'getStockItemsFullByIds' => [
            'application/json',
        ],
        'getStockItemsLocation' => [
            'application/json',
        ],
        'getStockLevel' => [
            'application/json',
        ],
        'getStockLevelBatch' => [
            'application/json',
        ],
        'getStockLevelByLocation' => [
            'application/json',
        ],
        'getStockSold' => [
            'application/json',
        ],
        'getVariationGroupByName' => [
            'application/json',
        ],
        'getVariationGroupByParentId' => [
            'application/json',
        ],
        'getVariationGroupSearchTypes' => [
            'application/json',
        ],
        'getVariationItems' => [
            'application/json',
        ],
        'getWarehouseMove' => [
            'application/json',
        ],
        'getWarehouseMovesByBinrack' => [
            'application/json',
        ],
        'renameVariationGroup' => [
            'application/json',
        ],
        'sKUExists' => [
            'application/json',
        ],
        'searchBinracks' => [
            'application/json',
        ],
        'searchVariationGroups' => [
            'application/json',
        ],
        'setStockLevel' => [
            'application/json',
        ],
        'updateSkuGroupIdentifier' => [
            'application/json',
        ],
        'updateStockLevelsBulk' => [
            'application/json',
        ],
        'updateStockLevelsBySKU' => [
            'application/json',
        ],
        'updateStockMinimumLevel' => [
            'application/json',
        ],
        'updateWarehouseMove' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addRollingStockTake
     *
     * AddRollingStockTake
     *
     * @param  \Linnworks\Stock\Model\AddRollingStockTakeRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addRollingStockTake'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\AddRollingStockTakeResponse
     */
    public function addRollingStockTake($request = null, string $contentType = self::contentTypes['addRollingStockTake'][0])
    {
        list($response) = $this->addRollingStockTakeWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation addRollingStockTakeWithHttpInfo
     *
     * AddRollingStockTake
     *
     * @param  \Linnworks\Stock\Model\AddRollingStockTakeRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addRollingStockTake'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\AddRollingStockTakeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addRollingStockTakeWithHttpInfo($request = null, string $contentType = self::contentTypes['addRollingStockTake'][0])
    {
        $request = $this->addRollingStockTakeRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\AddRollingStockTakeResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\AddRollingStockTakeResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\AddRollingStockTakeResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\AddRollingStockTakeResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\AddRollingStockTakeResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addRollingStockTakeAsync
     *
     * AddRollingStockTake
     *
     * @param  \Linnworks\Stock\Model\AddRollingStockTakeRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addRollingStockTake'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addRollingStockTakeAsync($request = null, string $contentType = self::contentTypes['addRollingStockTake'][0])
    {
        return $this->addRollingStockTakeAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addRollingStockTakeAsyncWithHttpInfo
     *
     * AddRollingStockTake
     *
     * @param  \Linnworks\Stock\Model\AddRollingStockTakeRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addRollingStockTake'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addRollingStockTakeAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['addRollingStockTake'][0])
    {
        $returnType = '\Linnworks\Stock\Model\AddRollingStockTakeResponse';
        $request = $this->addRollingStockTakeRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addRollingStockTake'
     *
     * @param  \Linnworks\Stock\Model\AddRollingStockTakeRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addRollingStockTake'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addRollingStockTakeRequest($request = null, string $contentType = self::contentTypes['addRollingStockTake'][0])
    {



        $resourcePath = '/api/Stock/AddRollingStockTake';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addVariationItems
     *
     * AddVariationItems
     *
     * @param  \Linnworks\Stock\Model\StockAddVariationItemsRequest $stock_add_variation_items_request stock_add_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addVariationItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\VariationItem[]
     */
    public function addVariationItems($stock_add_variation_items_request, string $contentType = self::contentTypes['addVariationItems'][0])
    {
        list($response) = $this->addVariationItemsWithHttpInfo($stock_add_variation_items_request, $contentType);
        return $response;
    }

    /**
     * Operation addVariationItemsWithHttpInfo
     *
     * AddVariationItems
     *
     * @param  \Linnworks\Stock\Model\StockAddVariationItemsRequest $stock_add_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addVariationItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\VariationItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function addVariationItemsWithHttpInfo($stock_add_variation_items_request, string $contentType = self::contentTypes['addVariationItems'][0])
    {
        $request = $this->addVariationItemsRequest($stock_add_variation_items_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\VariationItem[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\VariationItem[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\VariationItem[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\VariationItem[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\VariationItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addVariationItemsAsync
     *
     * AddVariationItems
     *
     * @param  \Linnworks\Stock\Model\StockAddVariationItemsRequest $stock_add_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addVariationItemsAsync($stock_add_variation_items_request, string $contentType = self::contentTypes['addVariationItems'][0])
    {
        return $this->addVariationItemsAsyncWithHttpInfo($stock_add_variation_items_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addVariationItemsAsyncWithHttpInfo
     *
     * AddVariationItems
     *
     * @param  \Linnworks\Stock\Model\StockAddVariationItemsRequest $stock_add_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addVariationItemsAsyncWithHttpInfo($stock_add_variation_items_request, string $contentType = self::contentTypes['addVariationItems'][0])
    {
        $returnType = '\Linnworks\Stock\Model\VariationItem[]';
        $request = $this->addVariationItemsRequest($stock_add_variation_items_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addVariationItems'
     *
     * @param  \Linnworks\Stock\Model\StockAddVariationItemsRequest $stock_add_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addVariationItemsRequest($stock_add_variation_items_request, string $contentType = self::contentTypes['addVariationItems'][0])
    {

        // verify the required parameter 'stock_add_variation_items_request' is set
        if ($stock_add_variation_items_request === null || (is_array($stock_add_variation_items_request) && count($stock_add_variation_items_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_add_variation_items_request when calling addVariationItems'
            );
        }


        $resourcePath = '/api/Stock/AddVariationItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_add_variation_items_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_add_variation_items_request));
            } else {
                $httpBody = $stock_add_variation_items_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation batchStockLevelDelta
     *
     * BatchStockLevelDelta
     *
     * @param  \Linnworks\Stock\Model\StockBatchStockLevelDeltaRequest $stock_batch_stock_level_delta_request stock_batch_stock_level_delta_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchStockLevelDelta'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\BatchStockLevelDeltaResponse
     */
    public function batchStockLevelDelta($stock_batch_stock_level_delta_request, string $contentType = self::contentTypes['batchStockLevelDelta'][0])
    {
        list($response) = $this->batchStockLevelDeltaWithHttpInfo($stock_batch_stock_level_delta_request, $contentType);
        return $response;
    }

    /**
     * Operation batchStockLevelDeltaWithHttpInfo
     *
     * BatchStockLevelDelta
     *
     * @param  \Linnworks\Stock\Model\StockBatchStockLevelDeltaRequest $stock_batch_stock_level_delta_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchStockLevelDelta'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\BatchStockLevelDeltaResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function batchStockLevelDeltaWithHttpInfo($stock_batch_stock_level_delta_request, string $contentType = self::contentTypes['batchStockLevelDelta'][0])
    {
        $request = $this->batchStockLevelDeltaRequest($stock_batch_stock_level_delta_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\BatchStockLevelDeltaResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\BatchStockLevelDeltaResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\BatchStockLevelDeltaResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\BatchStockLevelDeltaResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\BatchStockLevelDeltaResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation batchStockLevelDeltaAsync
     *
     * BatchStockLevelDelta
     *
     * @param  \Linnworks\Stock\Model\StockBatchStockLevelDeltaRequest $stock_batch_stock_level_delta_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchStockLevelDelta'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function batchStockLevelDeltaAsync($stock_batch_stock_level_delta_request, string $contentType = self::contentTypes['batchStockLevelDelta'][0])
    {
        return $this->batchStockLevelDeltaAsyncWithHttpInfo($stock_batch_stock_level_delta_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation batchStockLevelDeltaAsyncWithHttpInfo
     *
     * BatchStockLevelDelta
     *
     * @param  \Linnworks\Stock\Model\StockBatchStockLevelDeltaRequest $stock_batch_stock_level_delta_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchStockLevelDelta'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function batchStockLevelDeltaAsyncWithHttpInfo($stock_batch_stock_level_delta_request, string $contentType = self::contentTypes['batchStockLevelDelta'][0])
    {
        $returnType = '\Linnworks\Stock\Model\BatchStockLevelDeltaResponse';
        $request = $this->batchStockLevelDeltaRequest($stock_batch_stock_level_delta_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'batchStockLevelDelta'
     *
     * @param  \Linnworks\Stock\Model\StockBatchStockLevelDeltaRequest $stock_batch_stock_level_delta_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchStockLevelDelta'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function batchStockLevelDeltaRequest($stock_batch_stock_level_delta_request, string $contentType = self::contentTypes['batchStockLevelDelta'][0])
    {

        // verify the required parameter 'stock_batch_stock_level_delta_request' is set
        if ($stock_batch_stock_level_delta_request === null || (is_array($stock_batch_stock_level_delta_request) && count($stock_batch_stock_level_delta_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_batch_stock_level_delta_request when calling batchStockLevelDelta'
            );
        }


        $resourcePath = '/api/Stock/BatchStockLevelDelta';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_batch_stock_level_delta_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_batch_stock_level_delta_request));
            } else {
                $httpBody = $stock_batch_stock_level_delta_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation bookInStockBatch
     *
     * BookInStockBatch
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockBatchRequest $stock_book_in_stock_batch_request stock_book_in_stock_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockBatch'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemBatch
     */
    public function bookInStockBatch($stock_book_in_stock_batch_request, string $contentType = self::contentTypes['bookInStockBatch'][0])
    {
        list($response) = $this->bookInStockBatchWithHttpInfo($stock_book_in_stock_batch_request, $contentType);
        return $response;
    }

    /**
     * Operation bookInStockBatchWithHttpInfo
     *
     * BookInStockBatch
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockBatchRequest $stock_book_in_stock_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockBatch'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemBatch, HTTP status code, HTTP response headers (array of strings)
     */
    public function bookInStockBatchWithHttpInfo($stock_book_in_stock_batch_request, string $contentType = self::contentTypes['bookInStockBatch'][0])
    {
        $request = $this->bookInStockBatchRequest($stock_book_in_stock_batch_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemBatch' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemBatch' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemBatch', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemBatch';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemBatch',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation bookInStockBatchAsync
     *
     * BookInStockBatch
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockBatchRequest $stock_book_in_stock_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bookInStockBatchAsync($stock_book_in_stock_batch_request, string $contentType = self::contentTypes['bookInStockBatch'][0])
    {
        return $this->bookInStockBatchAsyncWithHttpInfo($stock_book_in_stock_batch_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation bookInStockBatchAsyncWithHttpInfo
     *
     * BookInStockBatch
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockBatchRequest $stock_book_in_stock_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bookInStockBatchAsyncWithHttpInfo($stock_book_in_stock_batch_request, string $contentType = self::contentTypes['bookInStockBatch'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemBatch';
        $request = $this->bookInStockBatchRequest($stock_book_in_stock_batch_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'bookInStockBatch'
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockBatchRequest $stock_book_in_stock_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function bookInStockBatchRequest($stock_book_in_stock_batch_request, string $contentType = self::contentTypes['bookInStockBatch'][0])
    {

        // verify the required parameter 'stock_book_in_stock_batch_request' is set
        if ($stock_book_in_stock_batch_request === null || (is_array($stock_book_in_stock_batch_request) && count($stock_book_in_stock_batch_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_book_in_stock_batch_request when calling bookInStockBatch'
            );
        }


        $resourcePath = '/api/Stock/BookInStockBatch';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_book_in_stock_batch_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_book_in_stock_batch_request));
            } else {
                $httpBody = $stock_book_in_stock_batch_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation bookInStockItem
     *
     * BookInStockItem
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockItemRequest $stock_book_in_stock_item_request stock_book_in_stock_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function bookInStockItem($stock_book_in_stock_item_request, string $contentType = self::contentTypes['bookInStockItem'][0])
    {
        $this->bookInStockItemWithHttpInfo($stock_book_in_stock_item_request, $contentType);
    }

    /**
     * Operation bookInStockItemWithHttpInfo
     *
     * BookInStockItem
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockItemRequest $stock_book_in_stock_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function bookInStockItemWithHttpInfo($stock_book_in_stock_item_request, string $contentType = self::contentTypes['bookInStockItem'][0])
    {
        $request = $this->bookInStockItemRequest($stock_book_in_stock_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation bookInStockItemAsync
     *
     * BookInStockItem
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockItemRequest $stock_book_in_stock_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bookInStockItemAsync($stock_book_in_stock_item_request, string $contentType = self::contentTypes['bookInStockItem'][0])
    {
        return $this->bookInStockItemAsyncWithHttpInfo($stock_book_in_stock_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation bookInStockItemAsyncWithHttpInfo
     *
     * BookInStockItem
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockItemRequest $stock_book_in_stock_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bookInStockItemAsyncWithHttpInfo($stock_book_in_stock_item_request, string $contentType = self::contentTypes['bookInStockItem'][0])
    {
        $returnType = '';
        $request = $this->bookInStockItemRequest($stock_book_in_stock_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'bookInStockItem'
     *
     * @param  \Linnworks\Stock\Model\StockBookInStockItemRequest $stock_book_in_stock_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bookInStockItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function bookInStockItemRequest($stock_book_in_stock_item_request, string $contentType = self::contentTypes['bookInStockItem'][0])
    {

        // verify the required parameter 'stock_book_in_stock_item_request' is set
        if ($stock_book_in_stock_item_request === null || (is_array($stock_book_in_stock_item_request) && count($stock_book_in_stock_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_book_in_stock_item_request when calling bookInStockItem'
            );
        }


        $resourcePath = '/api/Stock/BookInStockItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_book_in_stock_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_book_in_stock_item_request));
            } else {
                $httpBody = $stock_book_in_stock_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation checkVariationParentSKUExists
     *
     * CheckVariationParentSKUExists
     *
     * @param  string|null $parent_sku The SKU (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkVariationParentSKUExists'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function checkVariationParentSKUExists($parent_sku = null, string $contentType = self::contentTypes['checkVariationParentSKUExists'][0])
    {
        list($response) = $this->checkVariationParentSKUExistsWithHttpInfo($parent_sku, $contentType);
        return $response;
    }

    /**
     * Operation checkVariationParentSKUExistsWithHttpInfo
     *
     * CheckVariationParentSKUExists
     *
     * @param  string|null $parent_sku The SKU (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkVariationParentSKUExists'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function checkVariationParentSKUExistsWithHttpInfo($parent_sku = null, string $contentType = self::contentTypes['checkVariationParentSKUExists'][0])
    {
        $request = $this->checkVariationParentSKUExistsRequest($parent_sku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation checkVariationParentSKUExistsAsync
     *
     * CheckVariationParentSKUExists
     *
     * @param  string|null $parent_sku The SKU (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkVariationParentSKUExists'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkVariationParentSKUExistsAsync($parent_sku = null, string $contentType = self::contentTypes['checkVariationParentSKUExists'][0])
    {
        return $this->checkVariationParentSKUExistsAsyncWithHttpInfo($parent_sku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation checkVariationParentSKUExistsAsyncWithHttpInfo
     *
     * CheckVariationParentSKUExists
     *
     * @param  string|null $parent_sku The SKU (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkVariationParentSKUExists'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function checkVariationParentSKUExistsAsyncWithHttpInfo($parent_sku = null, string $contentType = self::contentTypes['checkVariationParentSKUExists'][0])
    {
        $returnType = 'string';
        $request = $this->checkVariationParentSKUExistsRequest($parent_sku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'checkVariationParentSKUExists'
     *
     * @param  string|null $parent_sku The SKU (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['checkVariationParentSKUExists'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function checkVariationParentSKUExistsRequest($parent_sku = null, string $contentType = self::contentTypes['checkVariationParentSKUExists'][0])
    {



        $resourcePath = '/api/Stock/CheckVariationParentSKUExists';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $parent_sku,
            'parentSKU', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation completeWarehouseMove
     *
     * CompleteWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\StockCompleteWarehouseMoveRequest $stock_complete_warehouse_move_request stock_complete_warehouse_move_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeWarehouseMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function completeWarehouseMove($stock_complete_warehouse_move_request, string $contentType = self::contentTypes['completeWarehouseMove'][0])
    {
        $this->completeWarehouseMoveWithHttpInfo($stock_complete_warehouse_move_request, $contentType);
    }

    /**
     * Operation completeWarehouseMoveWithHttpInfo
     *
     * CompleteWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\StockCompleteWarehouseMoveRequest $stock_complete_warehouse_move_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeWarehouseMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function completeWarehouseMoveWithHttpInfo($stock_complete_warehouse_move_request, string $contentType = self::contentTypes['completeWarehouseMove'][0])
    {
        $request = $this->completeWarehouseMoveRequest($stock_complete_warehouse_move_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation completeWarehouseMoveAsync
     *
     * CompleteWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\StockCompleteWarehouseMoveRequest $stock_complete_warehouse_move_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completeWarehouseMoveAsync($stock_complete_warehouse_move_request, string $contentType = self::contentTypes['completeWarehouseMove'][0])
    {
        return $this->completeWarehouseMoveAsyncWithHttpInfo($stock_complete_warehouse_move_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation completeWarehouseMoveAsyncWithHttpInfo
     *
     * CompleteWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\StockCompleteWarehouseMoveRequest $stock_complete_warehouse_move_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function completeWarehouseMoveAsyncWithHttpInfo($stock_complete_warehouse_move_request, string $contentType = self::contentTypes['completeWarehouseMove'][0])
    {
        $returnType = '';
        $request = $this->completeWarehouseMoveRequest($stock_complete_warehouse_move_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'completeWarehouseMove'
     *
     * @param  \Linnworks\Stock\Model\StockCompleteWarehouseMoveRequest $stock_complete_warehouse_move_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['completeWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function completeWarehouseMoveRequest($stock_complete_warehouse_move_request, string $contentType = self::contentTypes['completeWarehouseMove'][0])
    {

        // verify the required parameter 'stock_complete_warehouse_move_request' is set
        if ($stock_complete_warehouse_move_request === null || (is_array($stock_complete_warehouse_move_request) && count($stock_complete_warehouse_move_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_complete_warehouse_move_request when calling completeWarehouseMove'
            );
        }


        $resourcePath = '/api/Stock/CompleteWarehouseMove';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_complete_warehouse_move_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_complete_warehouse_move_request));
            } else {
                $httpBody = $stock_complete_warehouse_move_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createStockBatches
     *
     * CreateStockBatches
     *
     * @param  \Linnworks\Stock\Model\StockCreateStockBatchesRequest $stock_create_stock_batches_request stock_create_stock_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockBatches'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemBatch[]
     */
    public function createStockBatches($stock_create_stock_batches_request, string $contentType = self::contentTypes['createStockBatches'][0])
    {
        list($response) = $this->createStockBatchesWithHttpInfo($stock_create_stock_batches_request, $contentType);
        return $response;
    }

    /**
     * Operation createStockBatchesWithHttpInfo
     *
     * CreateStockBatches
     *
     * @param  \Linnworks\Stock\Model\StockCreateStockBatchesRequest $stock_create_stock_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockBatches'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemBatch[], HTTP status code, HTTP response headers (array of strings)
     */
    public function createStockBatchesWithHttpInfo($stock_create_stock_batches_request, string $contentType = self::contentTypes['createStockBatches'][0])
    {
        $request = $this->createStockBatchesRequest($stock_create_stock_batches_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemBatch[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemBatch[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemBatch[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemBatch[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemBatch[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createStockBatchesAsync
     *
     * CreateStockBatches
     *
     * @param  \Linnworks\Stock\Model\StockCreateStockBatchesRequest $stock_create_stock_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createStockBatchesAsync($stock_create_stock_batches_request, string $contentType = self::contentTypes['createStockBatches'][0])
    {
        return $this->createStockBatchesAsyncWithHttpInfo($stock_create_stock_batches_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createStockBatchesAsyncWithHttpInfo
     *
     * CreateStockBatches
     *
     * @param  \Linnworks\Stock\Model\StockCreateStockBatchesRequest $stock_create_stock_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createStockBatchesAsyncWithHttpInfo($stock_create_stock_batches_request, string $contentType = self::contentTypes['createStockBatches'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemBatch[]';
        $request = $this->createStockBatchesRequest($stock_create_stock_batches_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createStockBatches'
     *
     * @param  \Linnworks\Stock\Model\StockCreateStockBatchesRequest $stock_create_stock_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createStockBatchesRequest($stock_create_stock_batches_request, string $contentType = self::contentTypes['createStockBatches'][0])
    {

        // verify the required parameter 'stock_create_stock_batches_request' is set
        if ($stock_create_stock_batches_request === null || (is_array($stock_create_stock_batches_request) && count($stock_create_stock_batches_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_create_stock_batches_request when calling createStockBatches'
            );
        }


        $resourcePath = '/api/Stock/CreateStockBatches';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_create_stock_batches_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_create_stock_batches_request));
            } else {
                $httpBody = $stock_create_stock_batches_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createVariationGroup
     *
     * CreateVariationGroup
     *
     * @param  \Linnworks\Stock\Model\StockCreateVariationGroupRequest $stock_create_variation_group_request stock_create_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createVariationGroup'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\VariationGroup
     */
    public function createVariationGroup($stock_create_variation_group_request, string $contentType = self::contentTypes['createVariationGroup'][0])
    {
        list($response) = $this->createVariationGroupWithHttpInfo($stock_create_variation_group_request, $contentType);
        return $response;
    }

    /**
     * Operation createVariationGroupWithHttpInfo
     *
     * CreateVariationGroup
     *
     * @param  \Linnworks\Stock\Model\StockCreateVariationGroupRequest $stock_create_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createVariationGroup'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\VariationGroup, HTTP status code, HTTP response headers (array of strings)
     */
    public function createVariationGroupWithHttpInfo($stock_create_variation_group_request, string $contentType = self::contentTypes['createVariationGroup'][0])
    {
        $request = $this->createVariationGroupRequest($stock_create_variation_group_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\VariationGroup' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\VariationGroup' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\VariationGroup', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\VariationGroup';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\VariationGroup',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createVariationGroupAsync
     *
     * CreateVariationGroup
     *
     * @param  \Linnworks\Stock\Model\StockCreateVariationGroupRequest $stock_create_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createVariationGroupAsync($stock_create_variation_group_request, string $contentType = self::contentTypes['createVariationGroup'][0])
    {
        return $this->createVariationGroupAsyncWithHttpInfo($stock_create_variation_group_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createVariationGroupAsyncWithHttpInfo
     *
     * CreateVariationGroup
     *
     * @param  \Linnworks\Stock\Model\StockCreateVariationGroupRequest $stock_create_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createVariationGroupAsyncWithHttpInfo($stock_create_variation_group_request, string $contentType = self::contentTypes['createVariationGroup'][0])
    {
        $returnType = '\Linnworks\Stock\Model\VariationGroup';
        $request = $this->createVariationGroupRequest($stock_create_variation_group_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createVariationGroup'
     *
     * @param  \Linnworks\Stock\Model\StockCreateVariationGroupRequest $stock_create_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createVariationGroupRequest($stock_create_variation_group_request, string $contentType = self::contentTypes['createVariationGroup'][0])
    {

        // verify the required parameter 'stock_create_variation_group_request' is set
        if ($stock_create_variation_group_request === null || (is_array($stock_create_variation_group_request) && count($stock_create_variation_group_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_create_variation_group_request when calling createVariationGroup'
            );
        }


        $resourcePath = '/api/Stock/CreateVariationGroup';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_create_variation_group_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_create_variation_group_request));
            } else {
                $httpBody = $stock_create_variation_group_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createWarehouseMove
     *
     * CreateWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\CreateWarehouseMoveRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWarehouseMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetWarehouseMoveResponse
     */
    public function createWarehouseMove($request = null, string $contentType = self::contentTypes['createWarehouseMove'][0])
    {
        list($response) = $this->createWarehouseMoveWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation createWarehouseMoveWithHttpInfo
     *
     * CreateWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\CreateWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWarehouseMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetWarehouseMoveResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWarehouseMoveWithHttpInfo($request = null, string $contentType = self::contentTypes['createWarehouseMove'][0])
    {
        $request = $this->createWarehouseMoveRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetWarehouseMoveResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetWarehouseMoveResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetWarehouseMoveResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetWarehouseMoveResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetWarehouseMoveResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createWarehouseMoveAsync
     *
     * CreateWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\CreateWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWarehouseMoveAsync($request = null, string $contentType = self::contentTypes['createWarehouseMove'][0])
    {
        return $this->createWarehouseMoveAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createWarehouseMoveAsyncWithHttpInfo
     *
     * CreateWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\CreateWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createWarehouseMoveAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['createWarehouseMove'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetWarehouseMoveResponse';
        $request = $this->createWarehouseMoveRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createWarehouseMove'
     *
     * @param  \Linnworks\Stock\Model\CreateWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createWarehouseMoveRequest($request = null, string $contentType = self::contentTypes['createWarehouseMove'][0])
    {



        $resourcePath = '/api/Stock/CreateWarehouseMove';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteMove
     *
     * DeleteMove
     *
     * @param  \Linnworks\Stock\Model\DeleteMoveRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteMove($request = null, string $contentType = self::contentTypes['deleteMove'][0])
    {
        $this->deleteMoveWithHttpInfo($request, $contentType);
    }

    /**
     * Operation deleteMoveWithHttpInfo
     *
     * DeleteMove
     *
     * @param  \Linnworks\Stock\Model\DeleteMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteMoveWithHttpInfo($request = null, string $contentType = self::contentTypes['deleteMove'][0])
    {
        $request = $this->deleteMoveRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteMoveAsync
     *
     * DeleteMove
     *
     * @param  \Linnworks\Stock\Model\DeleteMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteMoveAsync($request = null, string $contentType = self::contentTypes['deleteMove'][0])
    {
        return $this->deleteMoveAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteMoveAsyncWithHttpInfo
     *
     * DeleteMove
     *
     * @param  \Linnworks\Stock\Model\DeleteMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteMoveAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['deleteMove'][0])
    {
        $returnType = '';
        $request = $this->deleteMoveRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteMove'
     *
     * @param  \Linnworks\Stock\Model\DeleteMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteMoveRequest($request = null, string $contentType = self::contentTypes['deleteMove'][0])
    {



        $resourcePath = '/api/Stock/DeleteMove';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteVariationGroup
     *
     * DeleteVariationGroup
     *
     * @param  string|null $pk_variation_group_id pk_variation_group_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroup'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteVariationGroup($pk_variation_group_id = null, string $contentType = self::contentTypes['deleteVariationGroup'][0])
    {
        $this->deleteVariationGroupWithHttpInfo($pk_variation_group_id, $contentType);
    }

    /**
     * Operation deleteVariationGroupWithHttpInfo
     *
     * DeleteVariationGroup
     *
     * @param  string|null $pk_variation_group_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroup'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVariationGroupWithHttpInfo($pk_variation_group_id = null, string $contentType = self::contentTypes['deleteVariationGroup'][0])
    {
        $request = $this->deleteVariationGroupRequest($pk_variation_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteVariationGroupAsync
     *
     * DeleteVariationGroup
     *
     * @param  string|null $pk_variation_group_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVariationGroupAsync($pk_variation_group_id = null, string $contentType = self::contentTypes['deleteVariationGroup'][0])
    {
        return $this->deleteVariationGroupAsyncWithHttpInfo($pk_variation_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteVariationGroupAsyncWithHttpInfo
     *
     * DeleteVariationGroup
     *
     * @param  string|null $pk_variation_group_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVariationGroupAsyncWithHttpInfo($pk_variation_group_id = null, string $contentType = self::contentTypes['deleteVariationGroup'][0])
    {
        $returnType = '';
        $request = $this->deleteVariationGroupRequest($pk_variation_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteVariationGroup'
     *
     * @param  string|null $pk_variation_group_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteVariationGroupRequest($pk_variation_group_id = null, string $contentType = self::contentTypes['deleteVariationGroup'][0])
    {



        $resourcePath = '/api/Stock/DeleteVariationGroup';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_variation_group_id,
            'pkVariationGroupId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteVariationGroups
     *
     * DeleteVariationGroups
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationGroupsRequest $stock_delete_variation_groups_request stock_delete_variation_groups_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroups'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteVariationGroups($stock_delete_variation_groups_request, string $contentType = self::contentTypes['deleteVariationGroups'][0])
    {
        $this->deleteVariationGroupsWithHttpInfo($stock_delete_variation_groups_request, $contentType);
    }

    /**
     * Operation deleteVariationGroupsWithHttpInfo
     *
     * DeleteVariationGroups
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationGroupsRequest $stock_delete_variation_groups_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroups'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVariationGroupsWithHttpInfo($stock_delete_variation_groups_request, string $contentType = self::contentTypes['deleteVariationGroups'][0])
    {
        $request = $this->deleteVariationGroupsRequest($stock_delete_variation_groups_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteVariationGroupsAsync
     *
     * DeleteVariationGroups
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationGroupsRequest $stock_delete_variation_groups_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVariationGroupsAsync($stock_delete_variation_groups_request, string $contentType = self::contentTypes['deleteVariationGroups'][0])
    {
        return $this->deleteVariationGroupsAsyncWithHttpInfo($stock_delete_variation_groups_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteVariationGroupsAsyncWithHttpInfo
     *
     * DeleteVariationGroups
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationGroupsRequest $stock_delete_variation_groups_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVariationGroupsAsyncWithHttpInfo($stock_delete_variation_groups_request, string $contentType = self::contentTypes['deleteVariationGroups'][0])
    {
        $returnType = '';
        $request = $this->deleteVariationGroupsRequest($stock_delete_variation_groups_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteVariationGroups'
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationGroupsRequest $stock_delete_variation_groups_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteVariationGroupsRequest($stock_delete_variation_groups_request, string $contentType = self::contentTypes['deleteVariationGroups'][0])
    {

        // verify the required parameter 'stock_delete_variation_groups_request' is set
        if ($stock_delete_variation_groups_request === null || (is_array($stock_delete_variation_groups_request) && count($stock_delete_variation_groups_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_delete_variation_groups_request when calling deleteVariationGroups'
            );
        }


        $resourcePath = '/api/Stock/DeleteVariationGroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_delete_variation_groups_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_delete_variation_groups_request));
            } else {
                $httpBody = $stock_delete_variation_groups_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteVariationItem
     *
     * DeleteVariationItem
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemRequest $stock_delete_variation_item_request stock_delete_variation_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteVariationItem($stock_delete_variation_item_request, string $contentType = self::contentTypes['deleteVariationItem'][0])
    {
        $this->deleteVariationItemWithHttpInfo($stock_delete_variation_item_request, $contentType);
    }

    /**
     * Operation deleteVariationItemWithHttpInfo
     *
     * DeleteVariationItem
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemRequest $stock_delete_variation_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVariationItemWithHttpInfo($stock_delete_variation_item_request, string $contentType = self::contentTypes['deleteVariationItem'][0])
    {
        $request = $this->deleteVariationItemRequest($stock_delete_variation_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteVariationItemAsync
     *
     * DeleteVariationItem
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemRequest $stock_delete_variation_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVariationItemAsync($stock_delete_variation_item_request, string $contentType = self::contentTypes['deleteVariationItem'][0])
    {
        return $this->deleteVariationItemAsyncWithHttpInfo($stock_delete_variation_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteVariationItemAsyncWithHttpInfo
     *
     * DeleteVariationItem
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemRequest $stock_delete_variation_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVariationItemAsyncWithHttpInfo($stock_delete_variation_item_request, string $contentType = self::contentTypes['deleteVariationItem'][0])
    {
        $returnType = '';
        $request = $this->deleteVariationItemRequest($stock_delete_variation_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteVariationItem'
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemRequest $stock_delete_variation_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteVariationItemRequest($stock_delete_variation_item_request, string $contentType = self::contentTypes['deleteVariationItem'][0])
    {

        // verify the required parameter 'stock_delete_variation_item_request' is set
        if ($stock_delete_variation_item_request === null || (is_array($stock_delete_variation_item_request) && count($stock_delete_variation_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_delete_variation_item_request when calling deleteVariationItem'
            );
        }


        $resourcePath = '/api/Stock/DeleteVariationItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_delete_variation_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_delete_variation_item_request));
            } else {
                $httpBody = $stock_delete_variation_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteVariationItems
     *
     * DeleteVariationItems
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemsRequest $stock_delete_variation_items_request stock_delete_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteVariationItems($stock_delete_variation_items_request, string $contentType = self::contentTypes['deleteVariationItems'][0])
    {
        $this->deleteVariationItemsWithHttpInfo($stock_delete_variation_items_request, $contentType);
    }

    /**
     * Operation deleteVariationItemsWithHttpInfo
     *
     * DeleteVariationItems
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemsRequest $stock_delete_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteVariationItemsWithHttpInfo($stock_delete_variation_items_request, string $contentType = self::contentTypes['deleteVariationItems'][0])
    {
        $request = $this->deleteVariationItemsRequest($stock_delete_variation_items_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteVariationItemsAsync
     *
     * DeleteVariationItems
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemsRequest $stock_delete_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVariationItemsAsync($stock_delete_variation_items_request, string $contentType = self::contentTypes['deleteVariationItems'][0])
    {
        return $this->deleteVariationItemsAsyncWithHttpInfo($stock_delete_variation_items_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteVariationItemsAsyncWithHttpInfo
     *
     * DeleteVariationItems
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemsRequest $stock_delete_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteVariationItemsAsyncWithHttpInfo($stock_delete_variation_items_request, string $contentType = self::contentTypes['deleteVariationItems'][0])
    {
        $returnType = '';
        $request = $this->deleteVariationItemsRequest($stock_delete_variation_items_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteVariationItems'
     *
     * @param  \Linnworks\Stock\Model\StockDeleteVariationItemsRequest $stock_delete_variation_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteVariationItemsRequest($stock_delete_variation_items_request, string $contentType = self::contentTypes['deleteVariationItems'][0])
    {

        // verify the required parameter 'stock_delete_variation_items_request' is set
        if ($stock_delete_variation_items_request === null || (is_array($stock_delete_variation_items_request) && count($stock_delete_variation_items_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_delete_variation_items_request when calling deleteVariationItems'
            );
        }


        $resourcePath = '/api/Stock/DeleteVariationItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_delete_variation_items_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_delete_variation_items_request));
            } else {
                $httpBody = $stock_delete_variation_items_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBinRacksById
     *
     * GetBinRacksById
     *
     * @param  \Linnworks\Stock\Model\GetBinrackByIdRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinRacksById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\BinracksResponse
     */
    public function getBinRacksById($request = null, string $contentType = self::contentTypes['getBinRacksById'][0])
    {
        list($response) = $this->getBinRacksByIdWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getBinRacksByIdWithHttpInfo
     *
     * GetBinRacksById
     *
     * @param  \Linnworks\Stock\Model\GetBinrackByIdRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinRacksById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\BinracksResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBinRacksByIdWithHttpInfo($request = null, string $contentType = self::contentTypes['getBinRacksById'][0])
    {
        $request = $this->getBinRacksByIdRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\BinracksResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\BinracksResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\BinracksResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\BinracksResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\BinracksResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBinRacksByIdAsync
     *
     * GetBinRacksById
     *
     * @param  \Linnworks\Stock\Model\GetBinrackByIdRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinRacksById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBinRacksByIdAsync($request = null, string $contentType = self::contentTypes['getBinRacksById'][0])
    {
        return $this->getBinRacksByIdAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBinRacksByIdAsyncWithHttpInfo
     *
     * GetBinRacksById
     *
     * @param  \Linnworks\Stock\Model\GetBinrackByIdRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinRacksById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBinRacksByIdAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getBinRacksById'][0])
    {
        $returnType = '\Linnworks\Stock\Model\BinracksResponse';
        $request = $this->getBinRacksByIdRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBinRacksById'
     *
     * @param  \Linnworks\Stock\Model\GetBinrackByIdRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinRacksById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBinRacksByIdRequest($request = null, string $contentType = self::contentTypes['getBinRacksById'][0])
    {



        $resourcePath = '/api/Stock/GetBinRacksById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBinrackSkus
     *
     * GetBinrackSkus
     *
     * @param  \Linnworks\Stock\Model\GetBinRackSkusRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinrackSkus'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\BinrackSkuResponse
     */
    public function getBinrackSkus($request = null, string $contentType = self::contentTypes['getBinrackSkus'][0])
    {
        list($response) = $this->getBinrackSkusWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getBinrackSkusWithHttpInfo
     *
     * GetBinrackSkus
     *
     * @param  \Linnworks\Stock\Model\GetBinRackSkusRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinrackSkus'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\BinrackSkuResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBinrackSkusWithHttpInfo($request = null, string $contentType = self::contentTypes['getBinrackSkus'][0])
    {
        $request = $this->getBinrackSkusRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\BinrackSkuResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\BinrackSkuResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\BinrackSkuResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\BinrackSkuResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\BinrackSkuResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBinrackSkusAsync
     *
     * GetBinrackSkus
     *
     * @param  \Linnworks\Stock\Model\GetBinRackSkusRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinrackSkus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBinrackSkusAsync($request = null, string $contentType = self::contentTypes['getBinrackSkus'][0])
    {
        return $this->getBinrackSkusAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBinrackSkusAsyncWithHttpInfo
     *
     * GetBinrackSkus
     *
     * @param  \Linnworks\Stock\Model\GetBinRackSkusRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinrackSkus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBinrackSkusAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getBinrackSkus'][0])
    {
        $returnType = '\Linnworks\Stock\Model\BinrackSkuResponse';
        $request = $this->getBinrackSkusRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBinrackSkus'
     *
     * @param  \Linnworks\Stock\Model\GetBinRackSkusRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBinrackSkus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBinrackSkusRequest($request = null, string $contentType = self::contentTypes['getBinrackSkus'][0])
    {



        $resourcePath = '/api/Stock/GetBinrackSkus';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getItemChangesHistory
     *
     * GetItemChangesHistory
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string|null $location_id Used to specify report location id. If null then combined (optional)
     * @param  int|null $entries_per_page Used to specify number of entries per page in report (optional)
     * @param  int|null $page_number Used to specify report page number. If -1 then will return all pages (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistory'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory
     */
    public function getItemChangesHistory($stock_item_id = null, $location_id = null, $entries_per_page = null, $page_number = null, string $contentType = self::contentTypes['getItemChangesHistory'][0])
    {
        list($response) = $this->getItemChangesHistoryWithHttpInfo($stock_item_id, $location_id, $entries_per_page, $page_number, $contentType);
        return $response;
    }

    /**
     * Operation getItemChangesHistoryWithHttpInfo
     *
     * GetItemChangesHistory
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string|null $location_id Used to specify report location id. If null then combined (optional)
     * @param  int|null $entries_per_page Used to specify number of entries per page in report (optional)
     * @param  int|null $page_number Used to specify report page number. If -1 then will return all pages (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistory'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemChangesHistoryWithHttpInfo($stock_item_id = null, $location_id = null, $entries_per_page = null, $page_number = null, string $contentType = self::contentTypes['getItemChangesHistory'][0])
    {
        $request = $this->getItemChangesHistoryRequest($stock_item_id, $location_id, $entries_per_page, $page_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getItemChangesHistoryAsync
     *
     * GetItemChangesHistory
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string|null $location_id Used to specify report location id. If null then combined (optional)
     * @param  int|null $entries_per_page Used to specify number of entries per page in report (optional)
     * @param  int|null $page_number Used to specify report page number. If -1 then will return all pages (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getItemChangesHistoryAsync($stock_item_id = null, $location_id = null, $entries_per_page = null, $page_number = null, string $contentType = self::contentTypes['getItemChangesHistory'][0])
    {
        return $this->getItemChangesHistoryAsyncWithHttpInfo($stock_item_id, $location_id, $entries_per_page, $page_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getItemChangesHistoryAsyncWithHttpInfo
     *
     * GetItemChangesHistory
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string|null $location_id Used to specify report location id. If null then combined (optional)
     * @param  int|null $entries_per_page Used to specify number of entries per page in report (optional)
     * @param  int|null $page_number Used to specify report page number. If -1 then will return all pages (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getItemChangesHistoryAsyncWithHttpInfo($stock_item_id = null, $location_id = null, $entries_per_page = null, $page_number = null, string $contentType = self::contentTypes['getItemChangesHistory'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory';
        $request = $this->getItemChangesHistoryRequest($stock_item_id, $location_id, $entries_per_page, $page_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getItemChangesHistory'
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string|null $location_id Used to specify report location id. If null then combined (optional)
     * @param  int|null $entries_per_page Used to specify number of entries per page in report (optional)
     * @param  int|null $page_number Used to specify report page number. If -1 then will return all pages (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getItemChangesHistoryRequest($stock_item_id = null, $location_id = null, $entries_per_page = null, $page_number = null, string $contentType = self::contentTypes['getItemChangesHistory'][0])
    {






        $resourcePath = '/api/Stock/GetItemChangesHistory';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entries_per_page,
            'entriesPerPage', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'pageNumber', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getItemChangesHistoryCSV
     *
     * GetItemChangesHistoryCSV
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string|null $location_id Used to specify location id. If null then combined (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistoryCSV'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\TempFile
     */
    public function getItemChangesHistoryCSV($stock_item_id = null, $location_id = null, string $contentType = self::contentTypes['getItemChangesHistoryCSV'][0])
    {
        list($response) = $this->getItemChangesHistoryCSVWithHttpInfo($stock_item_id, $location_id, $contentType);
        return $response;
    }

    /**
     * Operation getItemChangesHistoryCSVWithHttpInfo
     *
     * GetItemChangesHistoryCSV
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string|null $location_id Used to specify location id. If null then combined (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistoryCSV'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\TempFile, HTTP status code, HTTP response headers (array of strings)
     */
    public function getItemChangesHistoryCSVWithHttpInfo($stock_item_id = null, $location_id = null, string $contentType = self::contentTypes['getItemChangesHistoryCSV'][0])
    {
        $request = $this->getItemChangesHistoryCSVRequest($stock_item_id, $location_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\TempFile' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\TempFile' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\TempFile', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\TempFile';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\TempFile',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getItemChangesHistoryCSVAsync
     *
     * GetItemChangesHistoryCSV
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string|null $location_id Used to specify location id. If null then combined (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistoryCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getItemChangesHistoryCSVAsync($stock_item_id = null, $location_id = null, string $contentType = self::contentTypes['getItemChangesHistoryCSV'][0])
    {
        return $this->getItemChangesHistoryCSVAsyncWithHttpInfo($stock_item_id, $location_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getItemChangesHistoryCSVAsyncWithHttpInfo
     *
     * GetItemChangesHistoryCSV
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string|null $location_id Used to specify location id. If null then combined (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistoryCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getItemChangesHistoryCSVAsyncWithHttpInfo($stock_item_id = null, $location_id = null, string $contentType = self::contentTypes['getItemChangesHistoryCSV'][0])
    {
        $returnType = '\Linnworks\Stock\Model\TempFile';
        $request = $this->getItemChangesHistoryCSVRequest($stock_item_id, $location_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getItemChangesHistoryCSV'
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string|null $location_id Used to specify location id. If null then combined (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getItemChangesHistoryCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getItemChangesHistoryCSVRequest($stock_item_id = null, $location_id = null, string $contentType = self::contentTypes['getItemChangesHistoryCSV'][0])
    {




        $resourcePath = '/api/Stock/GetItemChangesHistoryCSV';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSoldStat
     *
     * GetSoldStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSoldStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemSoldStat[]
     */
    public function getSoldStat($stock_item_id = null, string $contentType = self::contentTypes['getSoldStat'][0])
    {
        list($response) = $this->getSoldStatWithHttpInfo($stock_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getSoldStatWithHttpInfo
     *
     * GetSoldStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSoldStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemSoldStat[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getSoldStatWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getSoldStat'][0])
    {
        $request = $this->getSoldStatRequest($stock_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemSoldStat[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemSoldStat[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemSoldStat[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemSoldStat[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemSoldStat[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSoldStatAsync
     *
     * GetSoldStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSoldStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSoldStatAsync($stock_item_id = null, string $contentType = self::contentTypes['getSoldStat'][0])
    {
        return $this->getSoldStatAsyncWithHttpInfo($stock_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSoldStatAsyncWithHttpInfo
     *
     * GetSoldStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSoldStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSoldStatAsyncWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getSoldStat'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemSoldStat[]';
        $request = $this->getSoldStatRequest($stock_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSoldStat'
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSoldStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSoldStatRequest($stock_item_id = null, string $contentType = self::contentTypes['getSoldStat'][0])
    {



        $resourcePath = '/api/Stock/GetSoldStat';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockConsumption
     *
     * GetStockConsumption
     *
     * @param  string|null $stock_item_id Used to specify report stock id (optional)
     * @param  string|null $location_id Used to specify location id. If null, then will return combined result of every location (optional)
     * @param  \DateTime|null $start_date Used to specify report start date (optional)
     * @param  \DateTime|null $end_date Used to specify report end date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockConsumption'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockConsumption[]
     */
    public function getStockConsumption($stock_item_id = null, $location_id = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getStockConsumption'][0])
    {
        list($response) = $this->getStockConsumptionWithHttpInfo($stock_item_id, $location_id, $start_date, $end_date, $contentType);
        return $response;
    }

    /**
     * Operation getStockConsumptionWithHttpInfo
     *
     * GetStockConsumption
     *
     * @param  string|null $stock_item_id Used to specify report stock id (optional)
     * @param  string|null $location_id Used to specify location id. If null, then will return combined result of every location (optional)
     * @param  \DateTime|null $start_date Used to specify report start date (optional)
     * @param  \DateTime|null $end_date Used to specify report end date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockConsumption'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockConsumption[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockConsumptionWithHttpInfo($stock_item_id = null, $location_id = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getStockConsumption'][0])
    {
        $request = $this->getStockConsumptionRequest($stock_item_id, $location_id, $start_date, $end_date, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockConsumption[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockConsumption[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockConsumption[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockConsumption[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockConsumption[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockConsumptionAsync
     *
     * GetStockConsumption
     *
     * @param  string|null $stock_item_id Used to specify report stock id (optional)
     * @param  string|null $location_id Used to specify location id. If null, then will return combined result of every location (optional)
     * @param  \DateTime|null $start_date Used to specify report start date (optional)
     * @param  \DateTime|null $end_date Used to specify report end date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockConsumption'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockConsumptionAsync($stock_item_id = null, $location_id = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getStockConsumption'][0])
    {
        return $this->getStockConsumptionAsyncWithHttpInfo($stock_item_id, $location_id, $start_date, $end_date, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockConsumptionAsyncWithHttpInfo
     *
     * GetStockConsumption
     *
     * @param  string|null $stock_item_id Used to specify report stock id (optional)
     * @param  string|null $location_id Used to specify location id. If null, then will return combined result of every location (optional)
     * @param  \DateTime|null $start_date Used to specify report start date (optional)
     * @param  \DateTime|null $end_date Used to specify report end date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockConsumption'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockConsumptionAsyncWithHttpInfo($stock_item_id = null, $location_id = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getStockConsumption'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockConsumption[]';
        $request = $this->getStockConsumptionRequest($stock_item_id, $location_id, $start_date, $end_date, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockConsumption'
     *
     * @param  string|null $stock_item_id Used to specify report stock id (optional)
     * @param  string|null $location_id Used to specify location id. If null, then will return combined result of every location (optional)
     * @param  \DateTime|null $start_date Used to specify report start date (optional)
     * @param  \DateTime|null $end_date Used to specify report end date (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockConsumption'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockConsumptionRequest($stock_item_id = null, $location_id = null, $start_date = null, $end_date = null, string $contentType = self::contentTypes['getStockConsumption'][0])
    {






        $resourcePath = '/api/Stock/GetStockConsumption';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockDuePO
     *
     * GetStockDuePO
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockDuePO'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemDuePO[]
     */
    public function getStockDuePO($stock_item_id = null, string $contentType = self::contentTypes['getStockDuePO'][0])
    {
        list($response) = $this->getStockDuePOWithHttpInfo($stock_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getStockDuePOWithHttpInfo
     *
     * GetStockDuePO
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockDuePO'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemDuePO[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockDuePOWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockDuePO'][0])
    {
        $request = $this->getStockDuePORequest($stock_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemDuePO[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemDuePO[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemDuePO[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemDuePO[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemDuePO[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockDuePOAsync
     *
     * GetStockDuePO
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockDuePO'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockDuePOAsync($stock_item_id = null, string $contentType = self::contentTypes['getStockDuePO'][0])
    {
        return $this->getStockDuePOAsyncWithHttpInfo($stock_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockDuePOAsyncWithHttpInfo
     *
     * GetStockDuePO
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockDuePO'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockDuePOAsyncWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockDuePO'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemDuePO[]';
        $request = $this->getStockDuePORequest($stock_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockDuePO'
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockDuePO'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockDuePORequest($stock_item_id = null, string $contentType = self::contentTypes['getStockDuePO'][0])
    {



        $resourcePath = '/api/Stock/GetStockDuePO';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItemReturnStat
     *
     * GetStockItemReturnStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemReturnStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemReturn[]
     */
    public function getStockItemReturnStat($stock_item_id = null, string $contentType = self::contentTypes['getStockItemReturnStat'][0])
    {
        list($response) = $this->getStockItemReturnStatWithHttpInfo($stock_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemReturnStatWithHttpInfo
     *
     * GetStockItemReturnStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemReturnStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemReturn[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemReturnStatWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockItemReturnStat'][0])
    {
        $request = $this->getStockItemReturnStatRequest($stock_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemReturn[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemReturn[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemReturn[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemReturn[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemReturn[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemReturnStatAsync
     *
     * GetStockItemReturnStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemReturnStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemReturnStatAsync($stock_item_id = null, string $contentType = self::contentTypes['getStockItemReturnStat'][0])
    {
        return $this->getStockItemReturnStatAsyncWithHttpInfo($stock_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemReturnStatAsyncWithHttpInfo
     *
     * GetStockItemReturnStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemReturnStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemReturnStatAsyncWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockItemReturnStat'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemReturn[]';
        $request = $this->getStockItemReturnStatRequest($stock_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItemReturnStat'
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemReturnStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemReturnStatRequest($stock_item_id = null, string $contentType = self::contentTypes['getStockItemReturnStat'][0])
    {



        $resourcePath = '/api/Stock/GetStockItemReturnStat';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItemScrapStat
     *
     * GetStockItemScrapStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemScrapStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemScrap[]
     */
    public function getStockItemScrapStat($stock_item_id = null, string $contentType = self::contentTypes['getStockItemScrapStat'][0])
    {
        list($response) = $this->getStockItemScrapStatWithHttpInfo($stock_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemScrapStatWithHttpInfo
     *
     * GetStockItemScrapStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemScrapStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemScrap[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemScrapStatWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockItemScrapStat'][0])
    {
        $request = $this->getStockItemScrapStatRequest($stock_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemScrap[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemScrap[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemScrap[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemScrap[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemScrap[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemScrapStatAsync
     *
     * GetStockItemScrapStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemScrapStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemScrapStatAsync($stock_item_id = null, string $contentType = self::contentTypes['getStockItemScrapStat'][0])
    {
        return $this->getStockItemScrapStatAsyncWithHttpInfo($stock_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemScrapStatAsyncWithHttpInfo
     *
     * GetStockItemScrapStat
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemScrapStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemScrapStatAsyncWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockItemScrapStat'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemScrap[]';
        $request = $this->getStockItemScrapStatRequest($stock_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItemScrapStat'
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemScrapStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemScrapStatRequest($stock_item_id = null, string $contentType = self::contentTypes['getStockItemScrapStat'][0])
    {



        $resourcePath = '/api/Stock/GetStockItemScrapStat';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItemTypeInfo
     *
     * GetStockItemTypeInfo
     *
     * @param  \Linnworks\Stock\Model\GetStockItemTypeInfoRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemTypeInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetStockItemTypeInfoResponse
     */
    public function getStockItemTypeInfo($request = null, string $contentType = self::contentTypes['getStockItemTypeInfo'][0])
    {
        list($response) = $this->getStockItemTypeInfoWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemTypeInfoWithHttpInfo
     *
     * GetStockItemTypeInfo
     *
     * @param  \Linnworks\Stock\Model\GetStockItemTypeInfoRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemTypeInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetStockItemTypeInfoResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemTypeInfoWithHttpInfo($request = null, string $contentType = self::contentTypes['getStockItemTypeInfo'][0])
    {
        $request = $this->getStockItemTypeInfoRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetStockItemTypeInfoResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetStockItemTypeInfoResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetStockItemTypeInfoResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetStockItemTypeInfoResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetStockItemTypeInfoResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemTypeInfoAsync
     *
     * GetStockItemTypeInfo
     *
     * @param  \Linnworks\Stock\Model\GetStockItemTypeInfoRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemTypeInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemTypeInfoAsync($request = null, string $contentType = self::contentTypes['getStockItemTypeInfo'][0])
    {
        return $this->getStockItemTypeInfoAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemTypeInfoAsyncWithHttpInfo
     *
     * GetStockItemTypeInfo
     *
     * @param  \Linnworks\Stock\Model\GetStockItemTypeInfoRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemTypeInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemTypeInfoAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getStockItemTypeInfo'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetStockItemTypeInfoResponse';
        $request = $this->getStockItemTypeInfoRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItemTypeInfo'
     *
     * @param  \Linnworks\Stock\Model\GetStockItemTypeInfoRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemTypeInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemTypeInfoRequest($request = null, string $contentType = self::contentTypes['getStockItemTypeInfo'][0])
    {



        $resourcePath = '/api/Stock/GetStockItemTypeInfo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItems
     *
     * GetStockItems
     *
     * @param  string|null $key_word key_word (optional)
     * @param  string|null $location_id location_id (optional)
     * @param  int|null $entries_per_page entries_per_page (optional)
     * @param  int|null $page_number page_number (optional)
     * @param  bool|null $exclude_composites exclude_composites (optional)
     * @param  bool|null $exclude_variations exclude_variations (optional)
     * @param  bool|null $exclude_batches exclude_batches (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GenericPagedResultStockItem
     */
    public function getStockItems($key_word = null, $location_id = null, $entries_per_page = null, $page_number = null, $exclude_composites = null, $exclude_variations = null, $exclude_batches = null, string $contentType = self::contentTypes['getStockItems'][0])
    {
        list($response) = $this->getStockItemsWithHttpInfo($key_word, $location_id, $entries_per_page, $page_number, $exclude_composites, $exclude_variations, $exclude_batches, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemsWithHttpInfo
     *
     * GetStockItems
     *
     * @param  string|null $key_word (optional)
     * @param  string|null $location_id (optional)
     * @param  int|null $entries_per_page (optional)
     * @param  int|null $page_number (optional)
     * @param  bool|null $exclude_composites (optional)
     * @param  bool|null $exclude_variations (optional)
     * @param  bool|null $exclude_batches (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GenericPagedResultStockItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemsWithHttpInfo($key_word = null, $location_id = null, $entries_per_page = null, $page_number = null, $exclude_composites = null, $exclude_variations = null, $exclude_batches = null, string $contentType = self::contentTypes['getStockItems'][0])
    {
        $request = $this->getStockItemsRequest($key_word, $location_id, $entries_per_page, $page_number, $exclude_composites, $exclude_variations, $exclude_batches, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GenericPagedResultStockItem' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GenericPagedResultStockItem' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GenericPagedResultStockItem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GenericPagedResultStockItem';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GenericPagedResultStockItem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemsAsync
     *
     * GetStockItems
     *
     * @param  string|null $key_word (optional)
     * @param  string|null $location_id (optional)
     * @param  int|null $entries_per_page (optional)
     * @param  int|null $page_number (optional)
     * @param  bool|null $exclude_composites (optional)
     * @param  bool|null $exclude_variations (optional)
     * @param  bool|null $exclude_batches (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsAsync($key_word = null, $location_id = null, $entries_per_page = null, $page_number = null, $exclude_composites = null, $exclude_variations = null, $exclude_batches = null, string $contentType = self::contentTypes['getStockItems'][0])
    {
        return $this->getStockItemsAsyncWithHttpInfo($key_word, $location_id, $entries_per_page, $page_number, $exclude_composites, $exclude_variations, $exclude_batches, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemsAsyncWithHttpInfo
     *
     * GetStockItems
     *
     * @param  string|null $key_word (optional)
     * @param  string|null $location_id (optional)
     * @param  int|null $entries_per_page (optional)
     * @param  int|null $page_number (optional)
     * @param  bool|null $exclude_composites (optional)
     * @param  bool|null $exclude_variations (optional)
     * @param  bool|null $exclude_batches (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsAsyncWithHttpInfo($key_word = null, $location_id = null, $entries_per_page = null, $page_number = null, $exclude_composites = null, $exclude_variations = null, $exclude_batches = null, string $contentType = self::contentTypes['getStockItems'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GenericPagedResultStockItem';
        $request = $this->getStockItemsRequest($key_word, $location_id, $entries_per_page, $page_number, $exclude_composites, $exclude_variations, $exclude_batches, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItems'
     *
     * @param  string|null $key_word (optional)
     * @param  string|null $location_id (optional)
     * @param  int|null $entries_per_page (optional)
     * @param  int|null $page_number (optional)
     * @param  bool|null $exclude_composites (optional)
     * @param  bool|null $exclude_variations (optional)
     * @param  bool|null $exclude_batches (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemsRequest($key_word = null, $location_id = null, $entries_per_page = null, $page_number = null, $exclude_composites = null, $exclude_variations = null, $exclude_batches = null, string $contentType = self::contentTypes['getStockItems'][0])
    {









        $resourcePath = '/api/Stock/GetStockItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $key_word,
            'keyWord', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $location_id,
            'locationId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entries_per_page,
            'entriesPerPage', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'pageNumber', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_composites,
            'excludeComposites', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_variations,
            'excludeVariations', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exclude_batches,
            'excludeBatches', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItemsByIds
     *
     * GetStockItemsByIds
     *
     * @param  \Linnworks\Stock\Model\GetStockItemsByIdsRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetStockItemsByIdsResponse
     */
    public function getStockItemsByIds($request = null, string $contentType = self::contentTypes['getStockItemsByIds'][0])
    {
        list($response) = $this->getStockItemsByIdsWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemsByIdsWithHttpInfo
     *
     * GetStockItemsByIds
     *
     * @param  \Linnworks\Stock\Model\GetStockItemsByIdsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetStockItemsByIdsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemsByIdsWithHttpInfo($request = null, string $contentType = self::contentTypes['getStockItemsByIds'][0])
    {
        $request = $this->getStockItemsByIdsRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetStockItemsByIdsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetStockItemsByIdsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetStockItemsByIdsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetStockItemsByIdsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetStockItemsByIdsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemsByIdsAsync
     *
     * GetStockItemsByIds
     *
     * @param  \Linnworks\Stock\Model\GetStockItemsByIdsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsByIdsAsync($request = null, string $contentType = self::contentTypes['getStockItemsByIds'][0])
    {
        return $this->getStockItemsByIdsAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemsByIdsAsyncWithHttpInfo
     *
     * GetStockItemsByIds
     *
     * @param  \Linnworks\Stock\Model\GetStockItemsByIdsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsByIdsAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getStockItemsByIds'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetStockItemsByIdsResponse';
        $request = $this->getStockItemsByIdsRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItemsByIds'
     *
     * @param  \Linnworks\Stock\Model\GetStockItemsByIdsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemsByIdsRequest($request = null, string $contentType = self::contentTypes['getStockItemsByIds'][0])
    {



        $resourcePath = '/api/Stock/GetStockItemsByIds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItemsByKey
     *
     * GetStockItemsByKey
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsByKeyRequest $stock_get_stock_items_by_key_request stock_get_stock_items_by_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByKey'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItem[]
     */
    public function getStockItemsByKey($stock_get_stock_items_by_key_request, string $contentType = self::contentTypes['getStockItemsByKey'][0])
    {
        list($response) = $this->getStockItemsByKeyWithHttpInfo($stock_get_stock_items_by_key_request, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemsByKeyWithHttpInfo
     *
     * GetStockItemsByKey
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsByKeyRequest $stock_get_stock_items_by_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByKey'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemsByKeyWithHttpInfo($stock_get_stock_items_by_key_request, string $contentType = self::contentTypes['getStockItemsByKey'][0])
    {
        $request = $this->getStockItemsByKeyRequest($stock_get_stock_items_by_key_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItem[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItem[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItem[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItem[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemsByKeyAsync
     *
     * GetStockItemsByKey
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsByKeyRequest $stock_get_stock_items_by_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByKey'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsByKeyAsync($stock_get_stock_items_by_key_request, string $contentType = self::contentTypes['getStockItemsByKey'][0])
    {
        return $this->getStockItemsByKeyAsyncWithHttpInfo($stock_get_stock_items_by_key_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemsByKeyAsyncWithHttpInfo
     *
     * GetStockItemsByKey
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsByKeyRequest $stock_get_stock_items_by_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByKey'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsByKeyAsyncWithHttpInfo($stock_get_stock_items_by_key_request, string $contentType = self::contentTypes['getStockItemsByKey'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItem[]';
        $request = $this->getStockItemsByKeyRequest($stock_get_stock_items_by_key_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItemsByKey'
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsByKeyRequest $stock_get_stock_items_by_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsByKey'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemsByKeyRequest($stock_get_stock_items_by_key_request, string $contentType = self::contentTypes['getStockItemsByKey'][0])
    {

        // verify the required parameter 'stock_get_stock_items_by_key_request' is set
        if ($stock_get_stock_items_by_key_request === null || (is_array($stock_get_stock_items_by_key_request) && count($stock_get_stock_items_by_key_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_get_stock_items_by_key_request when calling getStockItemsByKey'
            );
        }


        $resourcePath = '/api/Stock/GetStockItemsByKey';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_get_stock_items_by_key_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_get_stock_items_by_key_request));
            } else {
                $httpBody = $stock_get_stock_items_by_key_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItemsFull
     *
     * GetStockItemsFull
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullRequest $stock_get_stock_items_full_request stock_get_stock_items_full_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFull'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemFull[]
     */
    public function getStockItemsFull($stock_get_stock_items_full_request, string $contentType = self::contentTypes['getStockItemsFull'][0])
    {
        list($response) = $this->getStockItemsFullWithHttpInfo($stock_get_stock_items_full_request, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemsFullWithHttpInfo
     *
     * GetStockItemsFull
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullRequest $stock_get_stock_items_full_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFull'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemFull[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemsFullWithHttpInfo($stock_get_stock_items_full_request, string $contentType = self::contentTypes['getStockItemsFull'][0])
    {
        $request = $this->getStockItemsFullRequest($stock_get_stock_items_full_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemFull[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemFull[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemFull[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemFull[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemFull[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemsFullAsync
     *
     * GetStockItemsFull
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullRequest $stock_get_stock_items_full_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFull'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsFullAsync($stock_get_stock_items_full_request, string $contentType = self::contentTypes['getStockItemsFull'][0])
    {
        return $this->getStockItemsFullAsyncWithHttpInfo($stock_get_stock_items_full_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemsFullAsyncWithHttpInfo
     *
     * GetStockItemsFull
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullRequest $stock_get_stock_items_full_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFull'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsFullAsyncWithHttpInfo($stock_get_stock_items_full_request, string $contentType = self::contentTypes['getStockItemsFull'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemFull[]';
        $request = $this->getStockItemsFullRequest($stock_get_stock_items_full_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItemsFull'
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullRequest $stock_get_stock_items_full_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFull'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemsFullRequest($stock_get_stock_items_full_request, string $contentType = self::contentTypes['getStockItemsFull'][0])
    {

        // verify the required parameter 'stock_get_stock_items_full_request' is set
        if ($stock_get_stock_items_full_request === null || (is_array($stock_get_stock_items_full_request) && count($stock_get_stock_items_full_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_get_stock_items_full_request when calling getStockItemsFull'
            );
        }


        $resourcePath = '/api/Stock/GetStockItemsFull';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_get_stock_items_full_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_get_stock_items_full_request));
            } else {
                $httpBody = $stock_get_stock_items_full_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItemsFullByIds
     *
     * GetStockItemsFullByIds
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullByIdsRequest $stock_get_stock_items_full_by_ids_request stock_get_stock_items_full_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFullByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetStockItemsFullByIdsResponse
     */
    public function getStockItemsFullByIds($stock_get_stock_items_full_by_ids_request, string $contentType = self::contentTypes['getStockItemsFullByIds'][0])
    {
        list($response) = $this->getStockItemsFullByIdsWithHttpInfo($stock_get_stock_items_full_by_ids_request, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemsFullByIdsWithHttpInfo
     *
     * GetStockItemsFullByIds
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullByIdsRequest $stock_get_stock_items_full_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFullByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetStockItemsFullByIdsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemsFullByIdsWithHttpInfo($stock_get_stock_items_full_by_ids_request, string $contentType = self::contentTypes['getStockItemsFullByIds'][0])
    {
        $request = $this->getStockItemsFullByIdsRequest($stock_get_stock_items_full_by_ids_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetStockItemsFullByIdsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetStockItemsFullByIdsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetStockItemsFullByIdsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetStockItemsFullByIdsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetStockItemsFullByIdsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemsFullByIdsAsync
     *
     * GetStockItemsFullByIds
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullByIdsRequest $stock_get_stock_items_full_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFullByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsFullByIdsAsync($stock_get_stock_items_full_by_ids_request, string $contentType = self::contentTypes['getStockItemsFullByIds'][0])
    {
        return $this->getStockItemsFullByIdsAsyncWithHttpInfo($stock_get_stock_items_full_by_ids_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemsFullByIdsAsyncWithHttpInfo
     *
     * GetStockItemsFullByIds
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullByIdsRequest $stock_get_stock_items_full_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFullByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsFullByIdsAsyncWithHttpInfo($stock_get_stock_items_full_by_ids_request, string $contentType = self::contentTypes['getStockItemsFullByIds'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetStockItemsFullByIdsResponse';
        $request = $this->getStockItemsFullByIdsRequest($stock_get_stock_items_full_by_ids_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItemsFullByIds'
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsFullByIdsRequest $stock_get_stock_items_full_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsFullByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemsFullByIdsRequest($stock_get_stock_items_full_by_ids_request, string $contentType = self::contentTypes['getStockItemsFullByIds'][0])
    {

        // verify the required parameter 'stock_get_stock_items_full_by_ids_request' is set
        if ($stock_get_stock_items_full_by_ids_request === null || (is_array($stock_get_stock_items_full_by_ids_request) && count($stock_get_stock_items_full_by_ids_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_get_stock_items_full_by_ids_request when calling getStockItemsFullByIds'
            );
        }


        $resourcePath = '/api/Stock/GetStockItemsFullByIds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_get_stock_items_full_by_ids_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_get_stock_items_full_by_ids_request));
            } else {
                $httpBody = $stock_get_stock_items_full_by_ids_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockItemsLocation
     *
     * GetStockItemsLocation
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsLocationRequest $stock_get_stock_items_location_request stock_get_stock_items_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsLocation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetStockItemsLocationResponse
     */
    public function getStockItemsLocation($stock_get_stock_items_location_request, string $contentType = self::contentTypes['getStockItemsLocation'][0])
    {
        list($response) = $this->getStockItemsLocationWithHttpInfo($stock_get_stock_items_location_request, $contentType);
        return $response;
    }

    /**
     * Operation getStockItemsLocationWithHttpInfo
     *
     * GetStockItemsLocation
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsLocationRequest $stock_get_stock_items_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsLocation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetStockItemsLocationResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockItemsLocationWithHttpInfo($stock_get_stock_items_location_request, string $contentType = self::contentTypes['getStockItemsLocation'][0])
    {
        $request = $this->getStockItemsLocationRequest($stock_get_stock_items_location_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetStockItemsLocationResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetStockItemsLocationResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetStockItemsLocationResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetStockItemsLocationResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetStockItemsLocationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockItemsLocationAsync
     *
     * GetStockItemsLocation
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsLocationRequest $stock_get_stock_items_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsLocationAsync($stock_get_stock_items_location_request, string $contentType = self::contentTypes['getStockItemsLocation'][0])
    {
        return $this->getStockItemsLocationAsyncWithHttpInfo($stock_get_stock_items_location_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockItemsLocationAsyncWithHttpInfo
     *
     * GetStockItemsLocation
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsLocationRequest $stock_get_stock_items_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockItemsLocationAsyncWithHttpInfo($stock_get_stock_items_location_request, string $contentType = self::contentTypes['getStockItemsLocation'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetStockItemsLocationResponse';
        $request = $this->getStockItemsLocationRequest($stock_get_stock_items_location_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockItemsLocation'
     *
     * @param  \Linnworks\Stock\Model\StockGetStockItemsLocationRequest $stock_get_stock_items_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockItemsLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockItemsLocationRequest($stock_get_stock_items_location_request, string $contentType = self::contentTypes['getStockItemsLocation'][0])
    {

        // verify the required parameter 'stock_get_stock_items_location_request' is set
        if ($stock_get_stock_items_location_request === null || (is_array($stock_get_stock_items_location_request) && count($stock_get_stock_items_location_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_get_stock_items_location_request when calling getStockItemsLocation'
            );
        }


        $resourcePath = '/api/Stock/GetStockItemsLocation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_get_stock_items_location_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_get_stock_items_location_request));
            } else {
                $httpBody = $stock_get_stock_items_location_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockLevel
     *
     * GetStockLevel
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevel'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemLevel[]
     */
    public function getStockLevel($stock_item_id = null, string $contentType = self::contentTypes['getStockLevel'][0])
    {
        list($response) = $this->getStockLevelWithHttpInfo($stock_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getStockLevelWithHttpInfo
     *
     * GetStockLevel
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevel'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemLevel[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockLevelWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockLevel'][0])
    {
        $request = $this->getStockLevelRequest($stock_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemLevel[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemLevel[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemLevel[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemLevel[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemLevel[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockLevelAsync
     *
     * GetStockLevel
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockLevelAsync($stock_item_id = null, string $contentType = self::contentTypes['getStockLevel'][0])
    {
        return $this->getStockLevelAsyncWithHttpInfo($stock_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockLevelAsyncWithHttpInfo
     *
     * GetStockLevel
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockLevelAsyncWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockLevel'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemLevel[]';
        $request = $this->getStockLevelRequest($stock_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockLevel'
     *
     * @param  string|null $stock_item_id Used to specify stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockLevelRequest($stock_item_id = null, string $contentType = self::contentTypes['getStockLevel'][0])
    {



        $resourcePath = '/api/Stock/GetStockLevel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockLevelBatch
     *
     * GetStockLevel_Batch
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelBatchRequest $stock_get_stock_level_batch_request stock_get_stock_level_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelBatch'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetStockLevelBatchResponse[]
     */
    public function getStockLevelBatch($stock_get_stock_level_batch_request, string $contentType = self::contentTypes['getStockLevelBatch'][0])
    {
        list($response) = $this->getStockLevelBatchWithHttpInfo($stock_get_stock_level_batch_request, $contentType);
        return $response;
    }

    /**
     * Operation getStockLevelBatchWithHttpInfo
     *
     * GetStockLevel_Batch
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelBatchRequest $stock_get_stock_level_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelBatch'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetStockLevelBatchResponse[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockLevelBatchWithHttpInfo($stock_get_stock_level_batch_request, string $contentType = self::contentTypes['getStockLevelBatch'][0])
    {
        $request = $this->getStockLevelBatchRequest($stock_get_stock_level_batch_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetStockLevelBatchResponse[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetStockLevelBatchResponse[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetStockLevelBatchResponse[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetStockLevelBatchResponse[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetStockLevelBatchResponse[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockLevelBatchAsync
     *
     * GetStockLevel_Batch
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelBatchRequest $stock_get_stock_level_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockLevelBatchAsync($stock_get_stock_level_batch_request, string $contentType = self::contentTypes['getStockLevelBatch'][0])
    {
        return $this->getStockLevelBatchAsyncWithHttpInfo($stock_get_stock_level_batch_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockLevelBatchAsyncWithHttpInfo
     *
     * GetStockLevel_Batch
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelBatchRequest $stock_get_stock_level_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockLevelBatchAsyncWithHttpInfo($stock_get_stock_level_batch_request, string $contentType = self::contentTypes['getStockLevelBatch'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetStockLevelBatchResponse[]';
        $request = $this->getStockLevelBatchRequest($stock_get_stock_level_batch_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockLevelBatch'
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelBatchRequest $stock_get_stock_level_batch_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelBatch'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockLevelBatchRequest($stock_get_stock_level_batch_request, string $contentType = self::contentTypes['getStockLevelBatch'][0])
    {

        // verify the required parameter 'stock_get_stock_level_batch_request' is set
        if ($stock_get_stock_level_batch_request === null || (is_array($stock_get_stock_level_batch_request) && count($stock_get_stock_level_batch_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_get_stock_level_batch_request when calling getStockLevelBatch'
            );
        }


        $resourcePath = '/api/Stock/GetStockLevel_Batch';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_get_stock_level_batch_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_get_stock_level_batch_request));
            } else {
                $httpBody = $stock_get_stock_level_batch_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockLevelByLocation
     *
     * GetStockLevelByLocation
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelByLocationRequest $stock_get_stock_level_by_location_request stock_get_stock_level_by_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelByLocation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetStockLevelByLocationResponse
     */
    public function getStockLevelByLocation($stock_get_stock_level_by_location_request, string $contentType = self::contentTypes['getStockLevelByLocation'][0])
    {
        list($response) = $this->getStockLevelByLocationWithHttpInfo($stock_get_stock_level_by_location_request, $contentType);
        return $response;
    }

    /**
     * Operation getStockLevelByLocationWithHttpInfo
     *
     * GetStockLevelByLocation
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelByLocationRequest $stock_get_stock_level_by_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelByLocation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetStockLevelByLocationResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockLevelByLocationWithHttpInfo($stock_get_stock_level_by_location_request, string $contentType = self::contentTypes['getStockLevelByLocation'][0])
    {
        $request = $this->getStockLevelByLocationRequest($stock_get_stock_level_by_location_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetStockLevelByLocationResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetStockLevelByLocationResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetStockLevelByLocationResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetStockLevelByLocationResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetStockLevelByLocationResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockLevelByLocationAsync
     *
     * GetStockLevelByLocation
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelByLocationRequest $stock_get_stock_level_by_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelByLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockLevelByLocationAsync($stock_get_stock_level_by_location_request, string $contentType = self::contentTypes['getStockLevelByLocation'][0])
    {
        return $this->getStockLevelByLocationAsyncWithHttpInfo($stock_get_stock_level_by_location_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockLevelByLocationAsyncWithHttpInfo
     *
     * GetStockLevelByLocation
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelByLocationRequest $stock_get_stock_level_by_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelByLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockLevelByLocationAsyncWithHttpInfo($stock_get_stock_level_by_location_request, string $contentType = self::contentTypes['getStockLevelByLocation'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetStockLevelByLocationResponse';
        $request = $this->getStockLevelByLocationRequest($stock_get_stock_level_by_location_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockLevelByLocation'
     *
     * @param  \Linnworks\Stock\Model\StockGetStockLevelByLocationRequest $stock_get_stock_level_by_location_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockLevelByLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockLevelByLocationRequest($stock_get_stock_level_by_location_request, string $contentType = self::contentTypes['getStockLevelByLocation'][0])
    {

        // verify the required parameter 'stock_get_stock_level_by_location_request' is set
        if ($stock_get_stock_level_by_location_request === null || (is_array($stock_get_stock_level_by_location_request) && count($stock_get_stock_level_by_location_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_get_stock_level_by_location_request when calling getStockLevelByLocation'
            );
        }


        $resourcePath = '/api/Stock/GetStockLevelByLocation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_get_stock_level_by_location_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_get_stock_level_by_location_request));
            } else {
                $httpBody = $stock_get_stock_level_by_location_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStockSold
     *
     * GetStockSold
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockSold'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemSold[]
     */
    public function getStockSold($stock_item_id = null, string $contentType = self::contentTypes['getStockSold'][0])
    {
        list($response) = $this->getStockSoldWithHttpInfo($stock_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getStockSoldWithHttpInfo
     *
     * GetStockSold
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockSold'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemSold[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getStockSoldWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockSold'][0])
    {
        $request = $this->getStockSoldRequest($stock_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemSold[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemSold[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemSold[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemSold[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemSold[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getStockSoldAsync
     *
     * GetStockSold
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockSold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockSoldAsync($stock_item_id = null, string $contentType = self::contentTypes['getStockSold'][0])
    {
        return $this->getStockSoldAsyncWithHttpInfo($stock_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getStockSoldAsyncWithHttpInfo
     *
     * GetStockSold
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockSold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStockSoldAsyncWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getStockSold'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemSold[]';
        $request = $this->getStockSoldRequest($stock_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStockSold'
     *
     * @param  string|null $stock_item_id Used to specify report stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getStockSold'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getStockSoldRequest($stock_item_id = null, string $contentType = self::contentTypes['getStockSold'][0])
    {



        $resourcePath = '/api/Stock/GetStockSold';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getVariationGroupByName
     *
     * GetVariationGroupByName
     *
     * @param  string|null $variation_name The group name to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByName'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\VariationGroup
     */
    public function getVariationGroupByName($variation_name = null, string $contentType = self::contentTypes['getVariationGroupByName'][0])
    {
        list($response) = $this->getVariationGroupByNameWithHttpInfo($variation_name, $contentType);
        return $response;
    }

    /**
     * Operation getVariationGroupByNameWithHttpInfo
     *
     * GetVariationGroupByName
     *
     * @param  string|null $variation_name The group name to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByName'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\VariationGroup, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariationGroupByNameWithHttpInfo($variation_name = null, string $contentType = self::contentTypes['getVariationGroupByName'][0])
    {
        $request = $this->getVariationGroupByNameRequest($variation_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\VariationGroup' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\VariationGroup' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\VariationGroup', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\VariationGroup';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\VariationGroup',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getVariationGroupByNameAsync
     *
     * GetVariationGroupByName
     *
     * @param  string|null $variation_name The group name to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVariationGroupByNameAsync($variation_name = null, string $contentType = self::contentTypes['getVariationGroupByName'][0])
    {
        return $this->getVariationGroupByNameAsyncWithHttpInfo($variation_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getVariationGroupByNameAsyncWithHttpInfo
     *
     * GetVariationGroupByName
     *
     * @param  string|null $variation_name The group name to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVariationGroupByNameAsyncWithHttpInfo($variation_name = null, string $contentType = self::contentTypes['getVariationGroupByName'][0])
    {
        $returnType = '\Linnworks\Stock\Model\VariationGroup';
        $request = $this->getVariationGroupByNameRequest($variation_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getVariationGroupByName'
     *
     * @param  string|null $variation_name The group name to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByName'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getVariationGroupByNameRequest($variation_name = null, string $contentType = self::contentTypes['getVariationGroupByName'][0])
    {



        $resourcePath = '/api/Stock/GetVariationGroupByName';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $variation_name,
            'variationName', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getVariationGroupByParentId
     *
     * GetVariationGroupByParentId
     *
     * @param  string|null $pk_stock_item_id The stock item id to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByParentId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\VariationGroup
     */
    public function getVariationGroupByParentId($pk_stock_item_id = null, string $contentType = self::contentTypes['getVariationGroupByParentId'][0])
    {
        list($response) = $this->getVariationGroupByParentIdWithHttpInfo($pk_stock_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getVariationGroupByParentIdWithHttpInfo
     *
     * GetVariationGroupByParentId
     *
     * @param  string|null $pk_stock_item_id The stock item id to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByParentId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\VariationGroup, HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariationGroupByParentIdWithHttpInfo($pk_stock_item_id = null, string $contentType = self::contentTypes['getVariationGroupByParentId'][0])
    {
        $request = $this->getVariationGroupByParentIdRequest($pk_stock_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\VariationGroup' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\VariationGroup' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\VariationGroup', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\VariationGroup';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\VariationGroup',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getVariationGroupByParentIdAsync
     *
     * GetVariationGroupByParentId
     *
     * @param  string|null $pk_stock_item_id The stock item id to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByParentId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVariationGroupByParentIdAsync($pk_stock_item_id = null, string $contentType = self::contentTypes['getVariationGroupByParentId'][0])
    {
        return $this->getVariationGroupByParentIdAsyncWithHttpInfo($pk_stock_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getVariationGroupByParentIdAsyncWithHttpInfo
     *
     * GetVariationGroupByParentId
     *
     * @param  string|null $pk_stock_item_id The stock item id to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByParentId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVariationGroupByParentIdAsyncWithHttpInfo($pk_stock_item_id = null, string $contentType = self::contentTypes['getVariationGroupByParentId'][0])
    {
        $returnType = '\Linnworks\Stock\Model\VariationGroup';
        $request = $this->getVariationGroupByParentIdRequest($pk_stock_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getVariationGroupByParentId'
     *
     * @param  string|null $pk_stock_item_id The stock item id to search by (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupByParentId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getVariationGroupByParentIdRequest($pk_stock_item_id = null, string $contentType = self::contentTypes['getVariationGroupByParentId'][0])
    {



        $resourcePath = '/api/Stock/GetVariationGroupByParentId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_stock_item_id,
            'pkStockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getVariationGroupSearchTypes
     *
     * GetVariationGroupSearchTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupSearchTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GenericEnumDescriptor[]
     */
    public function getVariationGroupSearchTypes(string $contentType = self::contentTypes['getVariationGroupSearchTypes'][0])
    {
        list($response) = $this->getVariationGroupSearchTypesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getVariationGroupSearchTypesWithHttpInfo
     *
     * GetVariationGroupSearchTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupSearchTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GenericEnumDescriptor[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariationGroupSearchTypesWithHttpInfo(string $contentType = self::contentTypes['getVariationGroupSearchTypes'][0])
    {
        $request = $this->getVariationGroupSearchTypesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GenericEnumDescriptor[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GenericEnumDescriptor[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GenericEnumDescriptor[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GenericEnumDescriptor[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GenericEnumDescriptor[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getVariationGroupSearchTypesAsync
     *
     * GetVariationGroupSearchTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupSearchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVariationGroupSearchTypesAsync(string $contentType = self::contentTypes['getVariationGroupSearchTypes'][0])
    {
        return $this->getVariationGroupSearchTypesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getVariationGroupSearchTypesAsyncWithHttpInfo
     *
     * GetVariationGroupSearchTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupSearchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVariationGroupSearchTypesAsyncWithHttpInfo(string $contentType = self::contentTypes['getVariationGroupSearchTypes'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GenericEnumDescriptor[]';
        $request = $this->getVariationGroupSearchTypesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getVariationGroupSearchTypes'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationGroupSearchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getVariationGroupSearchTypesRequest(string $contentType = self::contentTypes['getVariationGroupSearchTypes'][0])
    {


        $resourcePath = '/api/Stock/GetVariationGroupSearchTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getVariationItems
     *
     * GetVariationItems
     *
     * @param  string|null $pk_variation_item_id The variation item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\VariationItem[]
     */
    public function getVariationItems($pk_variation_item_id = null, string $contentType = self::contentTypes['getVariationItems'][0])
    {
        list($response) = $this->getVariationItemsWithHttpInfo($pk_variation_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getVariationItemsWithHttpInfo
     *
     * GetVariationItems
     *
     * @param  string|null $pk_variation_item_id The variation item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\VariationItem[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getVariationItemsWithHttpInfo($pk_variation_item_id = null, string $contentType = self::contentTypes['getVariationItems'][0])
    {
        $request = $this->getVariationItemsRequest($pk_variation_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\VariationItem[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\VariationItem[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\VariationItem[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\VariationItem[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\VariationItem[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getVariationItemsAsync
     *
     * GetVariationItems
     *
     * @param  string|null $pk_variation_item_id The variation item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVariationItemsAsync($pk_variation_item_id = null, string $contentType = self::contentTypes['getVariationItems'][0])
    {
        return $this->getVariationItemsAsyncWithHttpInfo($pk_variation_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getVariationItemsAsyncWithHttpInfo
     *
     * GetVariationItems
     *
     * @param  string|null $pk_variation_item_id The variation item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getVariationItemsAsyncWithHttpInfo($pk_variation_item_id = null, string $contentType = self::contentTypes['getVariationItems'][0])
    {
        $returnType = '\Linnworks\Stock\Model\VariationItem[]';
        $request = $this->getVariationItemsRequest($pk_variation_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getVariationItems'
     *
     * @param  string|null $pk_variation_item_id The variation item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getVariationItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getVariationItemsRequest($pk_variation_item_id = null, string $contentType = self::contentTypes['getVariationItems'][0])
    {



        $resourcePath = '/api/Stock/GetVariationItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $pk_variation_item_id,
            'pkVariationItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWarehouseMove
     *
     * GetWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\GetWarehouseMoveRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetWarehouseMoveResponse
     */
    public function getWarehouseMove($request = null, string $contentType = self::contentTypes['getWarehouseMove'][0])
    {
        list($response) = $this->getWarehouseMoveWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getWarehouseMoveWithHttpInfo
     *
     * GetWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\GetWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetWarehouseMoveResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWarehouseMoveWithHttpInfo($request = null, string $contentType = self::contentTypes['getWarehouseMove'][0])
    {
        $request = $this->getWarehouseMoveRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetWarehouseMoveResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetWarehouseMoveResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetWarehouseMoveResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetWarehouseMoveResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetWarehouseMoveResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWarehouseMoveAsync
     *
     * GetWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\GetWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWarehouseMoveAsync($request = null, string $contentType = self::contentTypes['getWarehouseMove'][0])
    {
        return $this->getWarehouseMoveAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWarehouseMoveAsyncWithHttpInfo
     *
     * GetWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\GetWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWarehouseMoveAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getWarehouseMove'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetWarehouseMoveResponse';
        $request = $this->getWarehouseMoveRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWarehouseMove'
     *
     * @param  \Linnworks\Stock\Model\GetWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWarehouseMoveRequest($request = null, string $contentType = self::contentTypes['getWarehouseMove'][0])
    {



        $resourcePath = '/api/Stock/GetWarehouseMove';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWarehouseMovesByBinrack
     *
     * GetWarehouseMovesByBinrack
     *
     * @param  \Linnworks\Stock\Model\StockGetWarehouseMovesByBinrackRequest $stock_get_warehouse_moves_by_binrack_request stock_get_warehouse_moves_by_binrack_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMovesByBinrack'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse
     */
    public function getWarehouseMovesByBinrack($stock_get_warehouse_moves_by_binrack_request, string $contentType = self::contentTypes['getWarehouseMovesByBinrack'][0])
    {
        list($response) = $this->getWarehouseMovesByBinrackWithHttpInfo($stock_get_warehouse_moves_by_binrack_request, $contentType);
        return $response;
    }

    /**
     * Operation getWarehouseMovesByBinrackWithHttpInfo
     *
     * GetWarehouseMovesByBinrack
     *
     * @param  \Linnworks\Stock\Model\StockGetWarehouseMovesByBinrackRequest $stock_get_warehouse_moves_by_binrack_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMovesByBinrack'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWarehouseMovesByBinrackWithHttpInfo($stock_get_warehouse_moves_by_binrack_request, string $contentType = self::contentTypes['getWarehouseMovesByBinrack'][0])
    {
        $request = $this->getWarehouseMovesByBinrackRequest($stock_get_warehouse_moves_by_binrack_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWarehouseMovesByBinrackAsync
     *
     * GetWarehouseMovesByBinrack
     *
     * @param  \Linnworks\Stock\Model\StockGetWarehouseMovesByBinrackRequest $stock_get_warehouse_moves_by_binrack_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMovesByBinrack'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWarehouseMovesByBinrackAsync($stock_get_warehouse_moves_by_binrack_request, string $contentType = self::contentTypes['getWarehouseMovesByBinrack'][0])
    {
        return $this->getWarehouseMovesByBinrackAsyncWithHttpInfo($stock_get_warehouse_moves_by_binrack_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWarehouseMovesByBinrackAsyncWithHttpInfo
     *
     * GetWarehouseMovesByBinrack
     *
     * @param  \Linnworks\Stock\Model\StockGetWarehouseMovesByBinrackRequest $stock_get_warehouse_moves_by_binrack_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMovesByBinrack'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWarehouseMovesByBinrackAsyncWithHttpInfo($stock_get_warehouse_moves_by_binrack_request, string $contentType = self::contentTypes['getWarehouseMovesByBinrack'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse';
        $request = $this->getWarehouseMovesByBinrackRequest($stock_get_warehouse_moves_by_binrack_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWarehouseMovesByBinrack'
     *
     * @param  \Linnworks\Stock\Model\StockGetWarehouseMovesByBinrackRequest $stock_get_warehouse_moves_by_binrack_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseMovesByBinrack'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWarehouseMovesByBinrackRequest($stock_get_warehouse_moves_by_binrack_request, string $contentType = self::contentTypes['getWarehouseMovesByBinrack'][0])
    {

        // verify the required parameter 'stock_get_warehouse_moves_by_binrack_request' is set
        if ($stock_get_warehouse_moves_by_binrack_request === null || (is_array($stock_get_warehouse_moves_by_binrack_request) && count($stock_get_warehouse_moves_by_binrack_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_get_warehouse_moves_by_binrack_request when calling getWarehouseMovesByBinrack'
            );
        }


        $resourcePath = '/api/Stock/GetWarehouseMovesByBinrack';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_get_warehouse_moves_by_binrack_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_get_warehouse_moves_by_binrack_request));
            } else {
                $httpBody = $stock_get_warehouse_moves_by_binrack_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation renameVariationGroup
     *
     * RenameVariationGroup
     *
     * @param  \Linnworks\Stock\Model\StockRenameVariationGroupRequest $stock_rename_variation_group_request stock_rename_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameVariationGroup'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function renameVariationGroup($stock_rename_variation_group_request, string $contentType = self::contentTypes['renameVariationGroup'][0])
    {
        $this->renameVariationGroupWithHttpInfo($stock_rename_variation_group_request, $contentType);
    }

    /**
     * Operation renameVariationGroupWithHttpInfo
     *
     * RenameVariationGroup
     *
     * @param  \Linnworks\Stock\Model\StockRenameVariationGroupRequest $stock_rename_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameVariationGroup'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function renameVariationGroupWithHttpInfo($stock_rename_variation_group_request, string $contentType = self::contentTypes['renameVariationGroup'][0])
    {
        $request = $this->renameVariationGroupRequest($stock_rename_variation_group_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation renameVariationGroupAsync
     *
     * RenameVariationGroup
     *
     * @param  \Linnworks\Stock\Model\StockRenameVariationGroupRequest $stock_rename_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function renameVariationGroupAsync($stock_rename_variation_group_request, string $contentType = self::contentTypes['renameVariationGroup'][0])
    {
        return $this->renameVariationGroupAsyncWithHttpInfo($stock_rename_variation_group_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation renameVariationGroupAsyncWithHttpInfo
     *
     * RenameVariationGroup
     *
     * @param  \Linnworks\Stock\Model\StockRenameVariationGroupRequest $stock_rename_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function renameVariationGroupAsyncWithHttpInfo($stock_rename_variation_group_request, string $contentType = self::contentTypes['renameVariationGroup'][0])
    {
        $returnType = '';
        $request = $this->renameVariationGroupRequest($stock_rename_variation_group_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'renameVariationGroup'
     *
     * @param  \Linnworks\Stock\Model\StockRenameVariationGroupRequest $stock_rename_variation_group_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameVariationGroup'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function renameVariationGroupRequest($stock_rename_variation_group_request, string $contentType = self::contentTypes['renameVariationGroup'][0])
    {

        // verify the required parameter 'stock_rename_variation_group_request' is set
        if ($stock_rename_variation_group_request === null || (is_array($stock_rename_variation_group_request) && count($stock_rename_variation_group_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_rename_variation_group_request when calling renameVariationGroup'
            );
        }


        $resourcePath = '/api/Stock/RenameVariationGroup';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_rename_variation_group_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_rename_variation_group_request));
            } else {
                $httpBody = $stock_rename_variation_group_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation sKUExists
     *
     * SKUExists
     *
     * @param  string|null $sku The SKU you want to check exists. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sKUExists'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return bool
     */
    public function sKUExists($sku = null, string $contentType = self::contentTypes['sKUExists'][0])
    {
        list($response) = $this->sKUExistsWithHttpInfo($sku, $contentType);
        return $response;
    }

    /**
     * Operation sKUExistsWithHttpInfo
     *
     * SKUExists
     *
     * @param  string|null $sku The SKU you want to check exists. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sKUExists'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of bool, HTTP status code, HTTP response headers (array of strings)
     */
    public function sKUExistsWithHttpInfo($sku = null, string $contentType = self::contentTypes['sKUExists'][0])
    {
        $request = $this->sKUExistsRequest($sku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('bool' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('bool' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'bool', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'bool';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'bool',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation sKUExistsAsync
     *
     * SKUExists
     *
     * @param  string|null $sku The SKU you want to check exists. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sKUExists'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sKUExistsAsync($sku = null, string $contentType = self::contentTypes['sKUExists'][0])
    {
        return $this->sKUExistsAsyncWithHttpInfo($sku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sKUExistsAsyncWithHttpInfo
     *
     * SKUExists
     *
     * @param  string|null $sku The SKU you want to check exists. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sKUExists'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sKUExistsAsyncWithHttpInfo($sku = null, string $contentType = self::contentTypes['sKUExists'][0])
    {
        $returnType = 'bool';
        $request = $this->sKUExistsRequest($sku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'sKUExists'
     *
     * @param  string|null $sku The SKU you want to check exists. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['sKUExists'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function sKUExistsRequest($sku = null, string $contentType = self::contentTypes['sKUExists'][0])
    {



        $resourcePath = '/api/Stock/SKUExists';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sku,
            'SKU', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchBinracks
     *
     * SearchBinracks
     *
     * @param  \Linnworks\Stock\Model\StockSearchBinracksRequest $stock_search_binracks_request stock_search_binracks_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchBinracks'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\BinracksResponse
     */
    public function searchBinracks($stock_search_binracks_request, string $contentType = self::contentTypes['searchBinracks'][0])
    {
        list($response) = $this->searchBinracksWithHttpInfo($stock_search_binracks_request, $contentType);
        return $response;
    }

    /**
     * Operation searchBinracksWithHttpInfo
     *
     * SearchBinracks
     *
     * @param  \Linnworks\Stock\Model\StockSearchBinracksRequest $stock_search_binracks_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchBinracks'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\BinracksResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchBinracksWithHttpInfo($stock_search_binracks_request, string $contentType = self::contentTypes['searchBinracks'][0])
    {
        $request = $this->searchBinracksRequest($stock_search_binracks_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\BinracksResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\BinracksResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\BinracksResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\BinracksResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\BinracksResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchBinracksAsync
     *
     * SearchBinracks
     *
     * @param  \Linnworks\Stock\Model\StockSearchBinracksRequest $stock_search_binracks_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchBinracks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchBinracksAsync($stock_search_binracks_request, string $contentType = self::contentTypes['searchBinracks'][0])
    {
        return $this->searchBinracksAsyncWithHttpInfo($stock_search_binracks_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchBinracksAsyncWithHttpInfo
     *
     * SearchBinracks
     *
     * @param  \Linnworks\Stock\Model\StockSearchBinracksRequest $stock_search_binracks_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchBinracks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchBinracksAsyncWithHttpInfo($stock_search_binracks_request, string $contentType = self::contentTypes['searchBinracks'][0])
    {
        $returnType = '\Linnworks\Stock\Model\BinracksResponse';
        $request = $this->searchBinracksRequest($stock_search_binracks_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchBinracks'
     *
     * @param  \Linnworks\Stock\Model\StockSearchBinracksRequest $stock_search_binracks_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchBinracks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchBinracksRequest($stock_search_binracks_request, string $contentType = self::contentTypes['searchBinracks'][0])
    {

        // verify the required parameter 'stock_search_binracks_request' is set
        if ($stock_search_binracks_request === null || (is_array($stock_search_binracks_request) && count($stock_search_binracks_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_search_binracks_request when calling searchBinracks'
            );
        }


        $resourcePath = '/api/Stock/SearchBinracks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_search_binracks_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_search_binracks_request));
            } else {
                $httpBody = $stock_search_binracks_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchVariationGroups
     *
     * SearchVariationGroups
     *
     * @param  string|null $search_type The search method to use (optional)
     * @param  string|null $search_text The search term (either in part of full) (optional)
     * @param  int|null $page_number The page number (e.g. 1). (optional)
     * @param  int|null $entries_per_page The number of entries to return per page. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchVariationGroups'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GenericPagedResultVariationGroup
     */
    public function searchVariationGroups($search_type = null, $search_text = null, $page_number = null, $entries_per_page = null, string $contentType = self::contentTypes['searchVariationGroups'][0])
    {
        list($response) = $this->searchVariationGroupsWithHttpInfo($search_type, $search_text, $page_number, $entries_per_page, $contentType);
        return $response;
    }

    /**
     * Operation searchVariationGroupsWithHttpInfo
     *
     * SearchVariationGroups
     *
     * @param  string|null $search_type The search method to use (optional)
     * @param  string|null $search_text The search term (either in part of full) (optional)
     * @param  int|null $page_number The page number (e.g. 1). (optional)
     * @param  int|null $entries_per_page The number of entries to return per page. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchVariationGroups'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GenericPagedResultVariationGroup, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchVariationGroupsWithHttpInfo($search_type = null, $search_text = null, $page_number = null, $entries_per_page = null, string $contentType = self::contentTypes['searchVariationGroups'][0])
    {
        $request = $this->searchVariationGroupsRequest($search_type, $search_text, $page_number, $entries_per_page, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GenericPagedResultVariationGroup' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GenericPagedResultVariationGroup' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GenericPagedResultVariationGroup', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GenericPagedResultVariationGroup';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GenericPagedResultVariationGroup',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchVariationGroupsAsync
     *
     * SearchVariationGroups
     *
     * @param  string|null $search_type The search method to use (optional)
     * @param  string|null $search_text The search term (either in part of full) (optional)
     * @param  int|null $page_number The page number (e.g. 1). (optional)
     * @param  int|null $entries_per_page The number of entries to return per page. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchVariationGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchVariationGroupsAsync($search_type = null, $search_text = null, $page_number = null, $entries_per_page = null, string $contentType = self::contentTypes['searchVariationGroups'][0])
    {
        return $this->searchVariationGroupsAsyncWithHttpInfo($search_type, $search_text, $page_number, $entries_per_page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchVariationGroupsAsyncWithHttpInfo
     *
     * SearchVariationGroups
     *
     * @param  string|null $search_type The search method to use (optional)
     * @param  string|null $search_text The search term (either in part of full) (optional)
     * @param  int|null $page_number The page number (e.g. 1). (optional)
     * @param  int|null $entries_per_page The number of entries to return per page. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchVariationGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchVariationGroupsAsyncWithHttpInfo($search_type = null, $search_text = null, $page_number = null, $entries_per_page = null, string $contentType = self::contentTypes['searchVariationGroups'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GenericPagedResultVariationGroup';
        $request = $this->searchVariationGroupsRequest($search_type, $search_text, $page_number, $entries_per_page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchVariationGroups'
     *
     * @param  string|null $search_type The search method to use (optional)
     * @param  string|null $search_text The search term (either in part of full) (optional)
     * @param  int|null $page_number The page number (e.g. 1). (optional)
     * @param  int|null $entries_per_page The number of entries to return per page. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchVariationGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchVariationGroupsRequest($search_type = null, $search_text = null, $page_number = null, $entries_per_page = null, string $contentType = self::contentTypes['searchVariationGroups'][0])
    {






        $resourcePath = '/api/Stock/SearchVariationGroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search_type,
            'searchType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search_text,
            'searchText', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_number,
            'pageNumber', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $entries_per_page,
            'entriesPerPage', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation setStockLevel
     *
     * SetStockLevel
     *
     * @param  \Linnworks\Stock\Model\StockSetStockLevelRequest $stock_set_stock_level_request stock_set_stock_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStockLevel'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemLevel[]
     */
    public function setStockLevel($stock_set_stock_level_request, string $contentType = self::contentTypes['setStockLevel'][0])
    {
        list($response) = $this->setStockLevelWithHttpInfo($stock_set_stock_level_request, $contentType);
        return $response;
    }

    /**
     * Operation setStockLevelWithHttpInfo
     *
     * SetStockLevel
     *
     * @param  \Linnworks\Stock\Model\StockSetStockLevelRequest $stock_set_stock_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStockLevel'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemLevel[], HTTP status code, HTTP response headers (array of strings)
     */
    public function setStockLevelWithHttpInfo($stock_set_stock_level_request, string $contentType = self::contentTypes['setStockLevel'][0])
    {
        $request = $this->setStockLevelRequest($stock_set_stock_level_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemLevel[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemLevel[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemLevel[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemLevel[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemLevel[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation setStockLevelAsync
     *
     * SetStockLevel
     *
     * @param  \Linnworks\Stock\Model\StockSetStockLevelRequest $stock_set_stock_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStockLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setStockLevelAsync($stock_set_stock_level_request, string $contentType = self::contentTypes['setStockLevel'][0])
    {
        return $this->setStockLevelAsyncWithHttpInfo($stock_set_stock_level_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation setStockLevelAsyncWithHttpInfo
     *
     * SetStockLevel
     *
     * @param  \Linnworks\Stock\Model\StockSetStockLevelRequest $stock_set_stock_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStockLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function setStockLevelAsyncWithHttpInfo($stock_set_stock_level_request, string $contentType = self::contentTypes['setStockLevel'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemLevel[]';
        $request = $this->setStockLevelRequest($stock_set_stock_level_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'setStockLevel'
     *
     * @param  \Linnworks\Stock\Model\StockSetStockLevelRequest $stock_set_stock_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['setStockLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function setStockLevelRequest($stock_set_stock_level_request, string $contentType = self::contentTypes['setStockLevel'][0])
    {

        // verify the required parameter 'stock_set_stock_level_request' is set
        if ($stock_set_stock_level_request === null || (is_array($stock_set_stock_level_request) && count($stock_set_stock_level_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_set_stock_level_request when calling setStockLevel'
            );
        }


        $resourcePath = '/api/Stock/SetStockLevel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_set_stock_level_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_set_stock_level_request));
            } else {
                $httpBody = $stock_set_stock_level_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSkuGroupIdentifier
     *
     * UpdateSkuGroupIdentifier
     *
     * @param  \Linnworks\Stock\Model\UpdateSkuGroupIdentifierRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSkuGroupIdentifier'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateSkuGroupIdentifier($request = null, string $contentType = self::contentTypes['updateSkuGroupIdentifier'][0])
    {
        list($response) = $this->updateSkuGroupIdentifierWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation updateSkuGroupIdentifierWithHttpInfo
     *
     * UpdateSkuGroupIdentifier
     *
     * @param  \Linnworks\Stock\Model\UpdateSkuGroupIdentifierRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSkuGroupIdentifier'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSkuGroupIdentifierWithHttpInfo($request = null, string $contentType = self::contentTypes['updateSkuGroupIdentifier'][0])
    {
        $request = $this->updateSkuGroupIdentifierRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateSkuGroupIdentifierAsync
     *
     * UpdateSkuGroupIdentifier
     *
     * @param  \Linnworks\Stock\Model\UpdateSkuGroupIdentifierRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSkuGroupIdentifier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSkuGroupIdentifierAsync($request = null, string $contentType = self::contentTypes['updateSkuGroupIdentifier'][0])
    {
        return $this->updateSkuGroupIdentifierAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateSkuGroupIdentifierAsyncWithHttpInfo
     *
     * UpdateSkuGroupIdentifier
     *
     * @param  \Linnworks\Stock\Model\UpdateSkuGroupIdentifierRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSkuGroupIdentifier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSkuGroupIdentifierAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['updateSkuGroupIdentifier'][0])
    {
        $returnType = 'object';
        $request = $this->updateSkuGroupIdentifierRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSkuGroupIdentifier'
     *
     * @param  \Linnworks\Stock\Model\UpdateSkuGroupIdentifierRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSkuGroupIdentifier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateSkuGroupIdentifierRequest($request = null, string $contentType = self::contentTypes['updateSkuGroupIdentifier'][0])
    {



        $resourcePath = '/api/Stock/UpdateSkuGroupIdentifier';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateStockLevelsBulk
     *
     * UpdateStockLevelsBulk
     *
     * @param  \Linnworks\Stock\Model\UpdateStockLevelsBulkRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\UpdateStockLevelsBulkResponse
     */
    public function updateStockLevelsBulk($request = null, string $contentType = self::contentTypes['updateStockLevelsBulk'][0])
    {
        list($response) = $this->updateStockLevelsBulkWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation updateStockLevelsBulkWithHttpInfo
     *
     * UpdateStockLevelsBulk
     *
     * @param  \Linnworks\Stock\Model\UpdateStockLevelsBulkRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\UpdateStockLevelsBulkResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateStockLevelsBulkWithHttpInfo($request = null, string $contentType = self::contentTypes['updateStockLevelsBulk'][0])
    {
        $request = $this->updateStockLevelsBulkRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\UpdateStockLevelsBulkResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\UpdateStockLevelsBulkResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\UpdateStockLevelsBulkResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\UpdateStockLevelsBulkResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\UpdateStockLevelsBulkResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateStockLevelsBulkAsync
     *
     * UpdateStockLevelsBulk
     *
     * @param  \Linnworks\Stock\Model\UpdateStockLevelsBulkRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateStockLevelsBulkAsync($request = null, string $contentType = self::contentTypes['updateStockLevelsBulk'][0])
    {
        return $this->updateStockLevelsBulkAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateStockLevelsBulkAsyncWithHttpInfo
     *
     * UpdateStockLevelsBulk
     *
     * @param  \Linnworks\Stock\Model\UpdateStockLevelsBulkRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateStockLevelsBulkAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['updateStockLevelsBulk'][0])
    {
        $returnType = '\Linnworks\Stock\Model\UpdateStockLevelsBulkResponse';
        $request = $this->updateStockLevelsBulkRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateStockLevelsBulk'
     *
     * @param  \Linnworks\Stock\Model\UpdateStockLevelsBulkRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateStockLevelsBulkRequest($request = null, string $contentType = self::contentTypes['updateStockLevelsBulk'][0])
    {



        $resourcePath = '/api/Stock/UpdateStockLevelsBulk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateStockLevelsBySKU
     *
     * UpdateStockLevelsBySKU
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockLevelsBySKURequest $stock_update_stock_levels_by_sku_request stock_update_stock_levels_by_sku_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBySKU'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\StockItemLevel[]
     */
    public function updateStockLevelsBySKU($stock_update_stock_levels_by_sku_request, string $contentType = self::contentTypes['updateStockLevelsBySKU'][0])
    {
        list($response) = $this->updateStockLevelsBySKUWithHttpInfo($stock_update_stock_levels_by_sku_request, $contentType);
        return $response;
    }

    /**
     * Operation updateStockLevelsBySKUWithHttpInfo
     *
     * UpdateStockLevelsBySKU
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockLevelsBySKURequest $stock_update_stock_levels_by_sku_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBySKU'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\StockItemLevel[], HTTP status code, HTTP response headers (array of strings)
     */
    public function updateStockLevelsBySKUWithHttpInfo($stock_update_stock_levels_by_sku_request, string $contentType = self::contentTypes['updateStockLevelsBySKU'][0])
    {
        $request = $this->updateStockLevelsBySKURequest($stock_update_stock_levels_by_sku_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\StockItemLevel[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\StockItemLevel[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\StockItemLevel[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\StockItemLevel[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\StockItemLevel[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateStockLevelsBySKUAsync
     *
     * UpdateStockLevelsBySKU
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockLevelsBySKURequest $stock_update_stock_levels_by_sku_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBySKU'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateStockLevelsBySKUAsync($stock_update_stock_levels_by_sku_request, string $contentType = self::contentTypes['updateStockLevelsBySKU'][0])
    {
        return $this->updateStockLevelsBySKUAsyncWithHttpInfo($stock_update_stock_levels_by_sku_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateStockLevelsBySKUAsyncWithHttpInfo
     *
     * UpdateStockLevelsBySKU
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockLevelsBySKURequest $stock_update_stock_levels_by_sku_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBySKU'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateStockLevelsBySKUAsyncWithHttpInfo($stock_update_stock_levels_by_sku_request, string $contentType = self::contentTypes['updateStockLevelsBySKU'][0])
    {
        $returnType = '\Linnworks\Stock\Model\StockItemLevel[]';
        $request = $this->updateStockLevelsBySKURequest($stock_update_stock_levels_by_sku_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateStockLevelsBySKU'
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockLevelsBySKURequest $stock_update_stock_levels_by_sku_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockLevelsBySKU'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateStockLevelsBySKURequest($stock_update_stock_levels_by_sku_request, string $contentType = self::contentTypes['updateStockLevelsBySKU'][0])
    {

        // verify the required parameter 'stock_update_stock_levels_by_sku_request' is set
        if ($stock_update_stock_levels_by_sku_request === null || (is_array($stock_update_stock_levels_by_sku_request) && count($stock_update_stock_levels_by_sku_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_update_stock_levels_by_sku_request when calling updateStockLevelsBySKU'
            );
        }


        $resourcePath = '/api/Stock/UpdateStockLevelsBySKU';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_update_stock_levels_by_sku_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_update_stock_levels_by_sku_request));
            } else {
                $httpBody = $stock_update_stock_levels_by_sku_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateStockMinimumLevel
     *
     * UpdateStockMinimumLevel
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockMinimumLevelRequest $stock_update_stock_minimum_level_request stock_update_stock_minimum_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockMinimumLevel'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateStockMinimumLevel($stock_update_stock_minimum_level_request, string $contentType = self::contentTypes['updateStockMinimumLevel'][0])
    {
        $this->updateStockMinimumLevelWithHttpInfo($stock_update_stock_minimum_level_request, $contentType);
    }

    /**
     * Operation updateStockMinimumLevelWithHttpInfo
     *
     * UpdateStockMinimumLevel
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockMinimumLevelRequest $stock_update_stock_minimum_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockMinimumLevel'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateStockMinimumLevelWithHttpInfo($stock_update_stock_minimum_level_request, string $contentType = self::contentTypes['updateStockMinimumLevel'][0])
    {
        $request = $this->updateStockMinimumLevelRequest($stock_update_stock_minimum_level_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateStockMinimumLevelAsync
     *
     * UpdateStockMinimumLevel
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockMinimumLevelRequest $stock_update_stock_minimum_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockMinimumLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateStockMinimumLevelAsync($stock_update_stock_minimum_level_request, string $contentType = self::contentTypes['updateStockMinimumLevel'][0])
    {
        return $this->updateStockMinimumLevelAsyncWithHttpInfo($stock_update_stock_minimum_level_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateStockMinimumLevelAsyncWithHttpInfo
     *
     * UpdateStockMinimumLevel
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockMinimumLevelRequest $stock_update_stock_minimum_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockMinimumLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateStockMinimumLevelAsyncWithHttpInfo($stock_update_stock_minimum_level_request, string $contentType = self::contentTypes['updateStockMinimumLevel'][0])
    {
        $returnType = '';
        $request = $this->updateStockMinimumLevelRequest($stock_update_stock_minimum_level_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateStockMinimumLevel'
     *
     * @param  \Linnworks\Stock\Model\StockUpdateStockMinimumLevelRequest $stock_update_stock_minimum_level_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateStockMinimumLevel'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateStockMinimumLevelRequest($stock_update_stock_minimum_level_request, string $contentType = self::contentTypes['updateStockMinimumLevel'][0])
    {

        // verify the required parameter 'stock_update_stock_minimum_level_request' is set
        if ($stock_update_stock_minimum_level_request === null || (is_array($stock_update_stock_minimum_level_request) && count($stock_update_stock_minimum_level_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $stock_update_stock_minimum_level_request when calling updateStockMinimumLevel'
            );
        }


        $resourcePath = '/api/Stock/UpdateStockMinimumLevel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($stock_update_stock_minimum_level_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($stock_update_stock_minimum_level_request));
            } else {
                $httpBody = $stock_update_stock_minimum_level_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateWarehouseMove
     *
     * UpdateWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\UpdateWarehouseMoveRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWarehouseMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Stock\Model\GetWarehouseMoveResponse
     */
    public function updateWarehouseMove($request = null, string $contentType = self::contentTypes['updateWarehouseMove'][0])
    {
        list($response) = $this->updateWarehouseMoveWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation updateWarehouseMoveWithHttpInfo
     *
     * UpdateWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\UpdateWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWarehouseMove'] to see the possible values for this operation
     *
     * @throws \Linnworks\Stock\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Stock\Model\GetWarehouseMoveResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWarehouseMoveWithHttpInfo($request = null, string $contentType = self::contentTypes['updateWarehouseMove'][0])
    {
        $request = $this->updateWarehouseMoveRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Stock\Model\GetWarehouseMoveResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Stock\Model\GetWarehouseMoveResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Stock\Model\GetWarehouseMoveResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Stock\Model\GetWarehouseMoveResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Stock\Model\GetWarehouseMoveResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateWarehouseMoveAsync
     *
     * UpdateWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\UpdateWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWarehouseMoveAsync($request = null, string $contentType = self::contentTypes['updateWarehouseMove'][0])
    {
        return $this->updateWarehouseMoveAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateWarehouseMoveAsyncWithHttpInfo
     *
     * UpdateWarehouseMove
     *
     * @param  \Linnworks\Stock\Model\UpdateWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateWarehouseMoveAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['updateWarehouseMove'][0])
    {
        $returnType = '\Linnworks\Stock\Model\GetWarehouseMoveResponse';
        $request = $this->updateWarehouseMoveRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateWarehouseMove'
     *
     * @param  \Linnworks\Stock\Model\UpdateWarehouseMoveRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateWarehouseMove'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateWarehouseMoveRequest($request = null, string $contentType = self::contentTypes['updateWarehouseMove'][0])
    {



        $resourcePath = '/api/Stock/UpdateWarehouseMove';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
