# Linnworks\Stock\StockApi

All URIs are relative to https://eu-ext.linnworks.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**addRollingStockTake()**](StockApi.md#addRollingStockTake) | **POST** /api/Stock/AddRollingStockTake | AddRollingStockTake |
| [**addVariationItems()**](StockApi.md#addVariationItems) | **POST** /api/Stock/AddVariationItems | AddVariationItems |
| [**batchStockLevelDelta()**](StockApi.md#batchStockLevelDelta) | **POST** /api/Stock/BatchStockLevelDelta | BatchStockLevelDelta |
| [**bookInStockBatch()**](StockApi.md#bookInStockBatch) | **POST** /api/Stock/BookInStockBatch | BookInStockBatch |
| [**bookInStockItem()**](StockApi.md#bookInStockItem) | **POST** /api/Stock/BookInStockItem | BookInStockItem |
| [**checkVariationParentSKUExists()**](StockApi.md#checkVariationParentSKUExists) | **GET** /api/Stock/CheckVariationParentSKUExists | CheckVariationParentSKUExists |
| [**completeWarehouseMove()**](StockApi.md#completeWarehouseMove) | **POST** /api/Stock/CompleteWarehouseMove | CompleteWarehouseMove |
| [**createStockBatches()**](StockApi.md#createStockBatches) | **POST** /api/Stock/CreateStockBatches | CreateStockBatches |
| [**createVariationGroup()**](StockApi.md#createVariationGroup) | **POST** /api/Stock/CreateVariationGroup | CreateVariationGroup |
| [**createWarehouseMove()**](StockApi.md#createWarehouseMove) | **POST** /api/Stock/CreateWarehouseMove | CreateWarehouseMove |
| [**deleteMove()**](StockApi.md#deleteMove) | **POST** /api/Stock/DeleteMove | DeleteMove |
| [**deleteVariationGroup()**](StockApi.md#deleteVariationGroup) | **GET** /api/Stock/DeleteVariationGroup | DeleteVariationGroup |
| [**deleteVariationGroups()**](StockApi.md#deleteVariationGroups) | **POST** /api/Stock/DeleteVariationGroups | DeleteVariationGroups |
| [**deleteVariationItem()**](StockApi.md#deleteVariationItem) | **POST** /api/Stock/DeleteVariationItem | DeleteVariationItem |
| [**deleteVariationItems()**](StockApi.md#deleteVariationItems) | **POST** /api/Stock/DeleteVariationItems | DeleteVariationItems |
| [**getBinRacksById()**](StockApi.md#getBinRacksById) | **POST** /api/Stock/GetBinRacksById | GetBinRacksById |
| [**getBinrackSkus()**](StockApi.md#getBinrackSkus) | **POST** /api/Stock/GetBinrackSkus | GetBinrackSkus |
| [**getItemChangesHistory()**](StockApi.md#getItemChangesHistory) | **GET** /api/Stock/GetItemChangesHistory | GetItemChangesHistory |
| [**getItemChangesHistoryCSV()**](StockApi.md#getItemChangesHistoryCSV) | **GET** /api/Stock/GetItemChangesHistoryCSV | GetItemChangesHistoryCSV |
| [**getSoldStat()**](StockApi.md#getSoldStat) | **GET** /api/Stock/GetSoldStat | GetSoldStat |
| [**getStockConsumption()**](StockApi.md#getStockConsumption) | **GET** /api/Stock/GetStockConsumption | GetStockConsumption |
| [**getStockDuePO()**](StockApi.md#getStockDuePO) | **GET** /api/Stock/GetStockDuePO | GetStockDuePO |
| [**getStockItemReturnStat()**](StockApi.md#getStockItemReturnStat) | **GET** /api/Stock/GetStockItemReturnStat | GetStockItemReturnStat |
| [**getStockItemScrapStat()**](StockApi.md#getStockItemScrapStat) | **GET** /api/Stock/GetStockItemScrapStat | GetStockItemScrapStat |
| [**getStockItemTypeInfo()**](StockApi.md#getStockItemTypeInfo) | **POST** /api/Stock/GetStockItemTypeInfo | GetStockItemTypeInfo |
| [**getStockItems()**](StockApi.md#getStockItems) | **GET** /api/Stock/GetStockItems | GetStockItems |
| [**getStockItemsByIds()**](StockApi.md#getStockItemsByIds) | **POST** /api/Stock/GetStockItemsByIds | GetStockItemsByIds |
| [**getStockItemsByKey()**](StockApi.md#getStockItemsByKey) | **POST** /api/Stock/GetStockItemsByKey | GetStockItemsByKey |
| [**getStockItemsFull()**](StockApi.md#getStockItemsFull) | **POST** /api/Stock/GetStockItemsFull | GetStockItemsFull |
| [**getStockItemsFullByIds()**](StockApi.md#getStockItemsFullByIds) | **POST** /api/Stock/GetStockItemsFullByIds | GetStockItemsFullByIds |
| [**getStockItemsLocation()**](StockApi.md#getStockItemsLocation) | **POST** /api/Stock/GetStockItemsLocation | GetStockItemsLocation |
| [**getStockLevel()**](StockApi.md#getStockLevel) | **GET** /api/Stock/GetStockLevel | GetStockLevel |
| [**getStockLevelBatch()**](StockApi.md#getStockLevelBatch) | **POST** /api/Stock/GetStockLevel_Batch | GetStockLevel_Batch |
| [**getStockLevelByLocation()**](StockApi.md#getStockLevelByLocation) | **POST** /api/Stock/GetStockLevelByLocation | GetStockLevelByLocation |
| [**getStockSold()**](StockApi.md#getStockSold) | **GET** /api/Stock/GetStockSold | GetStockSold |
| [**getVariationGroupByName()**](StockApi.md#getVariationGroupByName) | **GET** /api/Stock/GetVariationGroupByName | GetVariationGroupByName |
| [**getVariationGroupByParentId()**](StockApi.md#getVariationGroupByParentId) | **GET** /api/Stock/GetVariationGroupByParentId | GetVariationGroupByParentId |
| [**getVariationGroupSearchTypes()**](StockApi.md#getVariationGroupSearchTypes) | **GET** /api/Stock/GetVariationGroupSearchTypes | GetVariationGroupSearchTypes |
| [**getVariationItems()**](StockApi.md#getVariationItems) | **GET** /api/Stock/GetVariationItems | GetVariationItems |
| [**getWarehouseMove()**](StockApi.md#getWarehouseMove) | **POST** /api/Stock/GetWarehouseMove | GetWarehouseMove |
| [**getWarehouseMovesByBinrack()**](StockApi.md#getWarehouseMovesByBinrack) | **POST** /api/Stock/GetWarehouseMovesByBinrack | GetWarehouseMovesByBinrack |
| [**renameVariationGroup()**](StockApi.md#renameVariationGroup) | **POST** /api/Stock/RenameVariationGroup | RenameVariationGroup |
| [**sKUExists()**](StockApi.md#sKUExists) | **GET** /api/Stock/SKUExists | SKUExists |
| [**searchBinracks()**](StockApi.md#searchBinracks) | **POST** /api/Stock/SearchBinracks | SearchBinracks |
| [**searchVariationGroups()**](StockApi.md#searchVariationGroups) | **GET** /api/Stock/SearchVariationGroups | SearchVariationGroups |
| [**setStockLevel()**](StockApi.md#setStockLevel) | **POST** /api/Stock/SetStockLevel | SetStockLevel |
| [**updateSkuGroupIdentifier()**](StockApi.md#updateSkuGroupIdentifier) | **POST** /api/Stock/UpdateSkuGroupIdentifier | UpdateSkuGroupIdentifier |
| [**updateStockLevelsBulk()**](StockApi.md#updateStockLevelsBulk) | **POST** /api/Stock/UpdateStockLevelsBulk | UpdateStockLevelsBulk |
| [**updateStockLevelsBySKU()**](StockApi.md#updateStockLevelsBySKU) | **POST** /api/Stock/UpdateStockLevelsBySKU | UpdateStockLevelsBySKU |
| [**updateStockMinimumLevel()**](StockApi.md#updateStockMinimumLevel) | **POST** /api/Stock/UpdateStockMinimumLevel | UpdateStockMinimumLevel |
| [**updateWarehouseMove()**](StockApi.md#updateWarehouseMove) | **POST** /api/Stock/UpdateWarehouseMove | UpdateWarehouseMove |


## `addRollingStockTake()`

```php
addRollingStockTake($request): \Linnworks\Stock\Model\AddRollingStockTakeResponse
```

AddRollingStockTake

Add rolling stock take/count. Rolling stock count will create a stock count header for every day (UTC based). Every request will create a session, adds all entries into the stock count  recounts all totals and discrepancies. WMS location or batched items requires BatchInventoryId to be specified. If you are submitting stock level for item that doesn't have batch inventory you must create it first, get its id and submit in the count  The method validates all entries, if any errors encountered the whole request will be rejected. <b>Permissions Required: </b> GlobalPermissions.Inventory.StockTake.RollingStockCountNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\AddRollingStockTakeRequest(); // \Linnworks\Stock\Model\AddRollingStockTakeRequest

try {
    $result = $apiInstance->addRollingStockTake($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->addRollingStockTake: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\AddRollingStockTakeRequest**](../Model/AddRollingStockTakeRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\AddRollingStockTakeResponse**](../Model/AddRollingStockTakeResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addVariationItems()`

```php
addVariationItems($stock_add_variation_items_request): \Linnworks\Stock\Model\VariationItem[]
```

AddVariationItems

Use this call to add a new item to a variation group <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_add_variation_items_request = new \Linnworks\Stock\Model\StockAddVariationItemsRequest(); // \Linnworks\Stock\Model\StockAddVariationItemsRequest

try {
    $result = $apiInstance->addVariationItems($stock_add_variation_items_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->addVariationItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_add_variation_items_request** | [**\Linnworks\Stock\Model\StockAddVariationItemsRequest**](../Model/StockAddVariationItemsRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\VariationItem[]**](../Model/VariationItem.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `batchStockLevelDelta()`

```php
batchStockLevelDelta($stock_batch_stock_level_delta_request): \Linnworks\Stock\Model\BatchStockLevelDeltaResponse
```

BatchStockLevelDelta

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_batch_stock_level_delta_request = new \Linnworks\Stock\Model\StockBatchStockLevelDeltaRequest(); // \Linnworks\Stock\Model\StockBatchStockLevelDeltaRequest

try {
    $result = $apiInstance->batchStockLevelDelta($stock_batch_stock_level_delta_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->batchStockLevelDelta: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_batch_stock_level_delta_request** | [**\Linnworks\Stock\Model\StockBatchStockLevelDeltaRequest**](../Model/StockBatchStockLevelDeltaRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\BatchStockLevelDeltaResponse**](../Model/BatchStockLevelDeltaResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `bookInStockBatch()`

```php
bookInStockBatch($stock_book_in_stock_batch_request): \Linnworks\Stock\Model\StockItemBatch
```

BookInStockBatch

Increases the stock level and current stock value of a batched stock item by the specified quantity <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_book_in_stock_batch_request = new \Linnworks\Stock\Model\StockBookInStockBatchRequest(); // \Linnworks\Stock\Model\StockBookInStockBatchRequest

try {
    $result = $apiInstance->bookInStockBatch($stock_book_in_stock_batch_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->bookInStockBatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_book_in_stock_batch_request** | [**\Linnworks\Stock\Model\StockBookInStockBatchRequest**](../Model/StockBookInStockBatchRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\StockItemBatch**](../Model/StockItemBatch.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `bookInStockItem()`

```php
bookInStockItem($stock_book_in_stock_item_request)
```

BookInStockItem

Increases the stock level and current stock value of a stock item by the specified quantity. <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockLevelsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_book_in_stock_item_request = new \Linnworks\Stock\Model\StockBookInStockItemRequest(); // \Linnworks\Stock\Model\StockBookInStockItemRequest

try {
    $apiInstance->bookInStockItem($stock_book_in_stock_item_request);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->bookInStockItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_book_in_stock_item_request** | [**\Linnworks\Stock\Model\StockBookInStockItemRequest**](../Model/StockBookInStockItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `checkVariationParentSKUExists()`

```php
checkVariationParentSKUExists($parent_sku): string
```

CheckVariationParentSKUExists

Use this call to check if a potential parent SKU exist and its current status. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$parent_sku = 'parent_sku_example'; // string | The SKU

try {
    $result = $apiInstance->checkVariationParentSKUExists($parent_sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->checkVariationParentSKUExists: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **parent_sku** | **string**| The SKU | [optional] |

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `completeWarehouseMove()`

```php
completeWarehouseMove($stock_complete_warehouse_move_request)
```

CompleteWarehouseMove

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_complete_warehouse_move_request = new \Linnworks\Stock\Model\StockCompleteWarehouseMoveRequest(); // \Linnworks\Stock\Model\StockCompleteWarehouseMoveRequest

try {
    $apiInstance->completeWarehouseMove($stock_complete_warehouse_move_request);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->completeWarehouseMove: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_complete_warehouse_move_request** | [**\Linnworks\Stock\Model\StockCompleteWarehouseMoveRequest**](../Model/StockCompleteWarehouseMoveRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createStockBatches()`

```php
createStockBatches($stock_create_stock_batches_request): \Linnworks\Stock\Model\StockItemBatch[]
```

CreateStockBatches

Creates stock item batches <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockLevelsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_create_stock_batches_request = new \Linnworks\Stock\Model\StockCreateStockBatchesRequest(); // \Linnworks\Stock\Model\StockCreateStockBatchesRequest

try {
    $result = $apiInstance->createStockBatches($stock_create_stock_batches_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->createStockBatches: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_create_stock_batches_request** | [**\Linnworks\Stock\Model\StockCreateStockBatchesRequest**](../Model/StockCreateStockBatchesRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\StockItemBatch[]**](../Model/StockItemBatch.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createVariationGroup()`

```php
createVariationGroup($stock_create_variation_group_request): \Linnworks\Stock\Model\VariationGroup
```

CreateVariationGroup

Use this call to create a variation group <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_create_variation_group_request = new \Linnworks\Stock\Model\StockCreateVariationGroupRequest(); // \Linnworks\Stock\Model\StockCreateVariationGroupRequest

try {
    $result = $apiInstance->createVariationGroup($stock_create_variation_group_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->createVariationGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_create_variation_group_request** | [**\Linnworks\Stock\Model\StockCreateVariationGroupRequest**](../Model/StockCreateVariationGroupRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\VariationGroup**](../Model/VariationGroup.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createWarehouseMove()`

```php
createWarehouseMove($request): \Linnworks\Stock\Model\GetWarehouseMoveResponse
```

CreateWarehouseMove

Create a new warehouse move in state of In Transit or Open.   To create a new move you need the exact batch inventory id and bin rack id of the destination. However it is possible to create a move without knowing where it is going specifically,   in which case don't supply BinrackIdDestination (or send null) <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseManagement.StockMoveNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\CreateWarehouseMoveRequest(); // \Linnworks\Stock\Model\CreateWarehouseMoveRequest

try {
    $result = $apiInstance->createWarehouseMove($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->createWarehouseMove: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\CreateWarehouseMoveRequest**](../Model/CreateWarehouseMoveRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\GetWarehouseMoveResponse**](../Model/GetWarehouseMoveResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteMove()`

```php
deleteMove($request)
```

DeleteMove

Use this call to delete a stock move <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\DeleteMoveRequest(); // \Linnworks\Stock\Model\DeleteMoveRequest

try {
    $apiInstance->deleteMove($request);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->deleteMove: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\DeleteMoveRequest**](../Model/DeleteMoveRequest.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteVariationGroup()`

```php
deleteVariationGroup($pk_variation_group_id)
```

DeleteVariationGroup

Use this call to delete variation group by id <b>Permissions Required: </b> GlobalPermissions.Inventory.DeleteMyInventoryItems.DeleteItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_variation_group_id = 'pk_variation_group_id_example'; // string

try {
    $apiInstance->deleteVariationGroup($pk_variation_group_id);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->deleteVariationGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_variation_group_id** | **string**|  | [optional] |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteVariationGroups()`

```php
deleteVariationGroups($stock_delete_variation_groups_request)
```

DeleteVariationGroups

Use this call to delete variation groups by ids <b>Permissions Required: </b> GlobalPermissions.Inventory.DeleteMyInventoryItems.DeleteItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_delete_variation_groups_request = new \Linnworks\Stock\Model\StockDeleteVariationGroupsRequest(); // \Linnworks\Stock\Model\StockDeleteVariationGroupsRequest

try {
    $apiInstance->deleteVariationGroups($stock_delete_variation_groups_request);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->deleteVariationGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_delete_variation_groups_request** | [**\Linnworks\Stock\Model\StockDeleteVariationGroupsRequest**](../Model/StockDeleteVariationGroupsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteVariationItem()`

```php
deleteVariationItem($stock_delete_variation_item_request)
```

DeleteVariationItem

Use this call to add a new item to a variation group <b>Permissions Required: </b> GlobalPermissions.Inventory.DeleteMyInventoryItems.DeleteItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_delete_variation_item_request = new \Linnworks\Stock\Model\StockDeleteVariationItemRequest(); // \Linnworks\Stock\Model\StockDeleteVariationItemRequest

try {
    $apiInstance->deleteVariationItem($stock_delete_variation_item_request);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->deleteVariationItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_delete_variation_item_request** | [**\Linnworks\Stock\Model\StockDeleteVariationItemRequest**](../Model/StockDeleteVariationItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteVariationItems()`

```php
deleteVariationItems($stock_delete_variation_items_request)
```

DeleteVariationItems

Use this call to delete variation items in bulk <b>Permissions Required: </b> GlobalPermissions.Inventory.DeleteMyInventoryItems.DeleteItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_delete_variation_items_request = new \Linnworks\Stock\Model\StockDeleteVariationItemsRequest(); // \Linnworks\Stock\Model\StockDeleteVariationItemsRequest

try {
    $apiInstance->deleteVariationItems($stock_delete_variation_items_request);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->deleteVariationItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_delete_variation_items_request** | [**\Linnworks\Stock\Model\StockDeleteVariationItemsRequest**](../Model/StockDeleteVariationItemsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBinRacksById()`

```php
getBinRacksById($request): \Linnworks\Stock\Model\BinracksResponse
```

GetBinRacksById

Returns the list of BinRacks by BinRack Ids for WMS locations. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\GetBinrackByIdRequest(); // \Linnworks\Stock\Model\GetBinrackByIdRequest

try {
    $result = $apiInstance->getBinRacksById($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getBinRacksById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\GetBinrackByIdRequest**](../Model/GetBinrackByIdRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\BinracksResponse**](../Model/BinracksResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBinrackSkus()`

```php
getBinrackSkus($request): \Linnworks\Stock\Model\BinrackSkuResponse
```

GetBinrackSkus

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\GetBinRackSkusRequest(); // \Linnworks\Stock\Model\GetBinRackSkusRequest

try {
    $result = $apiInstance->getBinrackSkus($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getBinrackSkus: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\GetBinRackSkusRequest**](../Model/GetBinRackSkusRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\BinrackSkuResponse**](../Model/BinrackSkuResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getItemChangesHistory()`

```php
getItemChangesHistory($stock_item_id, $location_id, $entries_per_page, $page_number): \Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory
```

GetItemChangesHistory

Use this call to retrieve report about \"stock changes of an item\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify report stock item id
$location_id = 'location_id_example'; // string | Used to specify report location id. If null then combined
$entries_per_page = 56; // int | Used to specify number of entries per page in report
$page_number = 56; // int | Used to specify report page number. If -1 then will return all pages

try {
    $result = $apiInstance->getItemChangesHistory($stock_item_id, $location_id, $entries_per_page, $page_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getItemChangesHistory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify report stock item id | [optional] |
| **location_id** | **string**| Used to specify report location id. If null then combined | [optional] |
| **entries_per_page** | **int**| Used to specify number of entries per page in report | [optional] |
| **page_number** | **int**| Used to specify report page number. If -1 then will return all pages | [optional] |

### Return type

[**\Linnworks\Stock\Model\GenericPagedResultStockItemChangeHistory**](../Model/GenericPagedResultStockItemChangeHistory.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getItemChangesHistoryCSV()`

```php
getItemChangesHistoryCSV($stock_item_id, $location_id): \Linnworks\Stock\Model\TempFile
```

GetItemChangesHistoryCSV

Use this call to retrieve link to csv file report about \"Stock changes of an item\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify stock item id
$location_id = 'location_id_example'; // string | Used to specify location id. If null then combined

try {
    $result = $apiInstance->getItemChangesHistoryCSV($stock_item_id, $location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getItemChangesHistoryCSV: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify stock item id | [optional] |
| **location_id** | **string**| Used to specify location id. If null then combined | [optional] |

### Return type

[**\Linnworks\Stock\Model\TempFile**](../Model/TempFile.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSoldStat()`

```php
getSoldStat($stock_item_id): \Linnworks\Stock\Model\StockItemSoldStat[]
```

GetSoldStat

Use this call to retrieve report about \"item sold stat\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify report stock item id

try {
    $result = $apiInstance->getSoldStat($stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getSoldStat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify report stock item id | [optional] |

### Return type

[**\Linnworks\Stock\Model\StockItemSoldStat[]**](../Model/StockItemSoldStat.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockConsumption()`

```php
getStockConsumption($stock_item_id, $location_id, $start_date, $end_date): \Linnworks\Stock\Model\StockConsumption[]
```

GetStockConsumption

Use this call to retrieve report about \"stock consumption between two dates\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify report stock id
$location_id = 'location_id_example'; // string | Used to specify location id. If null, then will return combined result of every location
$start_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Used to specify report start date
$end_date = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | Used to specify report end date

try {
    $result = $apiInstance->getStockConsumption($stock_item_id, $location_id, $start_date, $end_date);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockConsumption: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify report stock id | [optional] |
| **location_id** | **string**| Used to specify location id. If null, then will return combined result of every location | [optional] |
| **start_date** | **\DateTime**| Used to specify report start date | [optional] |
| **end_date** | **\DateTime**| Used to specify report end date | [optional] |

### Return type

[**\Linnworks\Stock\Model\StockConsumption[]**](../Model/StockConsumption.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockDuePO()`

```php
getStockDuePO($stock_item_id): \Linnworks\Stock\Model\StockItemDuePO[]
```

GetStockDuePO

Use this call to retrieve report about \"item stock due po\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify report stock item id

try {
    $result = $apiInstance->getStockDuePO($stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockDuePO: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify report stock item id | [optional] |

### Return type

[**\Linnworks\Stock\Model\StockItemDuePO[]**](../Model/StockItemDuePO.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemReturnStat()`

```php
getStockItemReturnStat($stock_item_id): \Linnworks\Stock\Model\StockItemReturn[]
```

GetStockItemReturnStat

Use this call to retrieve report about \"item return stat\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify report stock item id

try {
    $result = $apiInstance->getStockItemReturnStat($stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItemReturnStat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify report stock item id | [optional] |

### Return type

[**\Linnworks\Stock\Model\StockItemReturn[]**](../Model/StockItemReturn.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemScrapStat()`

```php
getStockItemScrapStat($stock_item_id): \Linnworks\Stock\Model\StockItemScrap[]
```

GetStockItemScrapStat

Use this call to retrieve report about \"item stock scrap stat\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify report stock item id

try {
    $result = $apiInstance->getStockItemScrapStat($stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItemScrapStat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify report stock item id | [optional] |

### Return type

[**\Linnworks\Stock\Model\StockItemScrap[]**](../Model/StockItemScrap.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemTypeInfo()`

```php
getStockItemTypeInfo($request): \Linnworks\Stock\Model\GetStockItemTypeInfoResponse
```

GetStockItemTypeInfo

<b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\GetStockItemTypeInfoRequest(); // \Linnworks\Stock\Model\GetStockItemTypeInfoRequest

try {
    $result = $apiInstance->getStockItemTypeInfo($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItemTypeInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\GetStockItemTypeInfoRequest**](../Model/GetStockItemTypeInfoRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\GetStockItemTypeInfoResponse**](../Model/GetStockItemTypeInfoResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItems()`

```php
getStockItems($key_word, $location_id, $entries_per_page, $page_number, $exclude_composites, $exclude_variations, $exclude_batches): \Linnworks\Stock\Model\GenericPagedResultStockItem
```

GetStockItems

Use this call to retrieve report about \"Found stock items\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$key_word = 'key_word_example'; // string
$location_id = 'location_id_example'; // string
$entries_per_page = 56; // int
$page_number = 56; // int
$exclude_composites = True; // bool
$exclude_variations = True; // bool
$exclude_batches = True; // bool

try {
    $result = $apiInstance->getStockItems($key_word, $location_id, $entries_per_page, $page_number, $exclude_composites, $exclude_variations, $exclude_batches);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **key_word** | **string**|  | [optional] |
| **location_id** | **string**|  | [optional] |
| **entries_per_page** | **int**|  | [optional] |
| **page_number** | **int**|  | [optional] |
| **exclude_composites** | **bool**|  | [optional] |
| **exclude_variations** | **bool**|  | [optional] |
| **exclude_batches** | **bool**|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\GenericPagedResultStockItem**](../Model/GenericPagedResultStockItem.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemsByIds()`

```php
getStockItemsByIds($request): \Linnworks\Stock\Model\GetStockItemsByIdsResponse
```

GetStockItemsByIds

<b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\GetStockItemsByIdsRequest(); // \Linnworks\Stock\Model\GetStockItemsByIdsRequest

try {
    $result = $apiInstance->getStockItemsByIds($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItemsByIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\GetStockItemsByIdsRequest**](../Model/GetStockItemsByIdsRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\GetStockItemsByIdsResponse**](../Model/GetStockItemsByIdsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemsByKey()`

```php
getStockItemsByKey($stock_get_stock_items_by_key_request): \Linnworks\Stock\Model\StockItem[]
```

GetStockItemsByKey

Returns a list of Stock Items for the provided key and location <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_get_stock_items_by_key_request = new \Linnworks\Stock\Model\StockGetStockItemsByKeyRequest(); // \Linnworks\Stock\Model\StockGetStockItemsByKeyRequest

try {
    $result = $apiInstance->getStockItemsByKey($stock_get_stock_items_by_key_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItemsByKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_get_stock_items_by_key_request** | [**\Linnworks\Stock\Model\StockGetStockItemsByKeyRequest**](../Model/StockGetStockItemsByKeyRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\StockItem[]**](../Model/StockItem.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemsFull()`

```php
getStockItemsFull($stock_get_stock_items_full_request): \Linnworks\Stock\Model\StockItemFull[]
```

GetStockItemsFull

Used to get inventory information at a basic level <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_get_stock_items_full_request = new \Linnworks\Stock\Model\StockGetStockItemsFullRequest(); // \Linnworks\Stock\Model\StockGetStockItemsFullRequest

try {
    $result = $apiInstance->getStockItemsFull($stock_get_stock_items_full_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItemsFull: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_get_stock_items_full_request** | [**\Linnworks\Stock\Model\StockGetStockItemsFullRequest**](../Model/StockGetStockItemsFullRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\StockItemFull[]**](../Model/StockItemFull.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemsFullByIds()`

```php
getStockItemsFullByIds($stock_get_stock_items_full_by_ids_request): \Linnworks\Stock\Model\GetStockItemsFullByIdsResponse
```

GetStockItemsFullByIds

Used to get inventory item information at a basic level from ids. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_get_stock_items_full_by_ids_request = new \Linnworks\Stock\Model\StockGetStockItemsFullByIdsRequest(); // \Linnworks\Stock\Model\StockGetStockItemsFullByIdsRequest

try {
    $result = $apiInstance->getStockItemsFullByIds($stock_get_stock_items_full_by_ids_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItemsFullByIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_get_stock_items_full_by_ids_request** | [**\Linnworks\Stock\Model\StockGetStockItemsFullByIdsRequest**](../Model/StockGetStockItemsFullByIdsRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\GetStockItemsFullByIdsResponse**](../Model/GetStockItemsFullByIdsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemsLocation()`

```php
getStockItemsLocation($stock_get_stock_items_location_request): \Linnworks\Stock\Model\GetStockItemsLocationResponse
```

GetStockItemsLocation

Get the location (including binrack) of a given list of stockItemIds and stockLocationIds <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_get_stock_items_location_request = new \Linnworks\Stock\Model\StockGetStockItemsLocationRequest(); // \Linnworks\Stock\Model\StockGetStockItemsLocationRequest

try {
    $result = $apiInstance->getStockItemsLocation($stock_get_stock_items_location_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockItemsLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_get_stock_items_location_request** | [**\Linnworks\Stock\Model\StockGetStockItemsLocationRequest**](../Model/StockGetStockItemsLocationRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\GetStockItemsLocationResponse**](../Model/GetStockItemsLocationResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockLevel()`

```php
getStockLevel($stock_item_id): \Linnworks\Stock\Model\StockItemLevel[]
```

GetStockLevel

Use this call to retrieve report about \"item stock level\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify stock item id

try {
    $result = $apiInstance->getStockLevel($stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockLevel: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify stock item id | [optional] |

### Return type

[**\Linnworks\Stock\Model\StockItemLevel[]**](../Model/StockItemLevel.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockLevelBatch()`

```php
getStockLevelBatch($stock_get_stock_level_batch_request): \Linnworks\Stock\Model\GetStockLevelBatchResponse[]
```

GetStockLevel_Batch

Use this call to retrieve report about \"item stock level\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_get_stock_level_batch_request = new \Linnworks\Stock\Model\StockGetStockLevelBatchRequest(); // \Linnworks\Stock\Model\StockGetStockLevelBatchRequest

try {
    $result = $apiInstance->getStockLevelBatch($stock_get_stock_level_batch_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockLevelBatch: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_get_stock_level_batch_request** | [**\Linnworks\Stock\Model\StockGetStockLevelBatchRequest**](../Model/StockGetStockLevelBatchRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\GetStockLevelBatchResponse[]**](../Model/GetStockLevelBatchResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockLevelByLocation()`

```php
getStockLevelByLocation($stock_get_stock_level_by_location_request): \Linnworks\Stock\Model\GetStockLevelByLocationResponse
```

GetStockLevelByLocation

Use this call to retrieve report about \"item stock level\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_get_stock_level_by_location_request = new \Linnworks\Stock\Model\StockGetStockLevelByLocationRequest(); // \Linnworks\Stock\Model\StockGetStockLevelByLocationRequest

try {
    $result = $apiInstance->getStockLevelByLocation($stock_get_stock_level_by_location_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockLevelByLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_get_stock_level_by_location_request** | [**\Linnworks\Stock\Model\StockGetStockLevelByLocationRequest**](../Model/StockGetStockLevelByLocationRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\GetStockLevelByLocationResponse**](../Model/GetStockLevelByLocationResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockSold()`

```php
getStockSold($stock_item_id): \Linnworks\Stock\Model\StockItemSold[]
```

GetStockSold

Use this call to retrieve report about \"item stock sold\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Used to specify report stock item id

try {
    $result = $apiInstance->getStockSold($stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getStockSold: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Used to specify report stock item id | [optional] |

### Return type

[**\Linnworks\Stock\Model\StockItemSold[]**](../Model/StockItemSold.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVariationGroupByName()`

```php
getVariationGroupByName($variation_name): \Linnworks\Stock\Model\VariationGroup
```

GetVariationGroupByName

Use this call to search for a variation group by the group name <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$variation_name = 'variation_name_example'; // string | The group name to search by

try {
    $result = $apiInstance->getVariationGroupByName($variation_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getVariationGroupByName: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **variation_name** | **string**| The group name to search by | [optional] |

### Return type

[**\Linnworks\Stock\Model\VariationGroup**](../Model/VariationGroup.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVariationGroupByParentId()`

```php
getVariationGroupByParentId($pk_stock_item_id): \Linnworks\Stock\Model\VariationGroup
```

GetVariationGroupByParentId

Use this call to search for a variation group by the parent SKU's stock item id <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_stock_item_id = 'pk_stock_item_id_example'; // string | The stock item id to search by

try {
    $result = $apiInstance->getVariationGroupByParentId($pk_stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getVariationGroupByParentId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_stock_item_id** | **string**| The stock item id to search by | [optional] |

### Return type

[**\Linnworks\Stock\Model\VariationGroup**](../Model/VariationGroup.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVariationGroupSearchTypes()`

```php
getVariationGroupSearchTypes(): \Linnworks\Stock\Model\GenericEnumDescriptor[]
```

GetVariationGroupSearchTypes

Use this call to retrieve a list of the search types for searching for variation groups <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getVariationGroupSearchTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getVariationGroupSearchTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Stock\Model\GenericEnumDescriptor[]**](../Model/GenericEnumDescriptor.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getVariationItems()`

```php
getVariationItems($pk_variation_item_id): \Linnworks\Stock\Model\VariationItem[]
```

GetVariationItems

Use this call to retrieve the items in this variation <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$pk_variation_item_id = 'pk_variation_item_id_example'; // string | The variation item id

try {
    $result = $apiInstance->getVariationItems($pk_variation_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getVariationItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **pk_variation_item_id** | **string**| The variation item id | [optional] |

### Return type

[**\Linnworks\Stock\Model\VariationItem[]**](../Model/VariationItem.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWarehouseMove()`

```php
getWarehouseMove($request): \Linnworks\Stock\Model\GetWarehouseMoveResponse
```

GetWarehouseMove

Use this call to get details for a stock move. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\GetWarehouseMoveRequest(); // \Linnworks\Stock\Model\GetWarehouseMoveRequest

try {
    $result = $apiInstance->getWarehouseMove($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getWarehouseMove: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\GetWarehouseMoveRequest**](../Model/GetWarehouseMoveRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\GetWarehouseMoveResponse**](../Model/GetWarehouseMoveResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWarehouseMovesByBinrack()`

```php
getWarehouseMovesByBinrack($stock_get_warehouse_moves_by_binrack_request): \Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse
```

GetWarehouseMovesByBinrack

Use this call to get details for stock moves within a specific binrack. Returns both incoming and outgoing stock. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_get_warehouse_moves_by_binrack_request = new \Linnworks\Stock\Model\StockGetWarehouseMovesByBinrackRequest(); // \Linnworks\Stock\Model\StockGetWarehouseMovesByBinrackRequest

try {
    $result = $apiInstance->getWarehouseMovesByBinrack($stock_get_warehouse_moves_by_binrack_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->getWarehouseMovesByBinrack: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_get_warehouse_moves_by_binrack_request** | [**\Linnworks\Stock\Model\StockGetWarehouseMovesByBinrackRequest**](../Model/StockGetWarehouseMovesByBinrackRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\GetWarehouseMovesByBinrackResponse**](../Model/GetWarehouseMovesByBinrackResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `renameVariationGroup()`

```php
renameVariationGroup($stock_rename_variation_group_request)
```

RenameVariationGroup

Use this call to rename a variation group <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_rename_variation_group_request = new \Linnworks\Stock\Model\StockRenameVariationGroupRequest(); // \Linnworks\Stock\Model\StockRenameVariationGroupRequest

try {
    $apiInstance->renameVariationGroup($stock_rename_variation_group_request);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->renameVariationGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_rename_variation_group_request** | [**\Linnworks\Stock\Model\StockRenameVariationGroupRequest**](../Model/StockRenameVariationGroupRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `sKUExists()`

```php
sKUExists($sku): bool
```

SKUExists

Use this call to check if a SKU exists within Linnworks. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sku = 'sku_example'; // string | The SKU you want to check exists.

try {
    $result = $apiInstance->sKUExists($sku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->sKUExists: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **sku** | **string**| The SKU you want to check exists. | [optional] |

### Return type

**bool**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchBinracks()`

```php
searchBinracks($stock_search_binracks_request): \Linnworks\Stock\Model\BinracksResponse
```

SearchBinracks

Finds all binracks where an item can be placed. Filters out the result by group and binrack restrictions for a particular stock item.  List of BinRack Type Ids which should be searched can be supplied for a particular location, if null all binracktypes will be considered. You can get the list from Get Stock/GetBinrackTypes  The response will be ordered by where the system thinks the item should be moved. The logic is determined by one of the default behaviours of the system or by custom configuration of the warehouse stock flow <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseManagementNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_search_binracks_request = new \Linnworks\Stock\Model\StockSearchBinracksRequest(); // \Linnworks\Stock\Model\StockSearchBinracksRequest

try {
    $result = $apiInstance->searchBinracks($stock_search_binracks_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->searchBinracks: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_search_binracks_request** | [**\Linnworks\Stock\Model\StockSearchBinracksRequest**](../Model/StockSearchBinracksRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\BinracksResponse**](../Model/BinracksResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchVariationGroups()`

```php
searchVariationGroups($search_type, $search_text, $page_number, $entries_per_page): \Linnworks\Stock\Model\GenericPagedResultVariationGroup
```

SearchVariationGroups

Use this call to search for a variation group <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$search_type = 'search_type_example'; // string | The search method to use
$search_text = 'search_text_example'; // string | The search term (either in part of full)
$page_number = 56; // int | The page number (e.g. 1).
$entries_per_page = 56; // int | The number of entries to return per page.

try {
    $result = $apiInstance->searchVariationGroups($search_type, $search_text, $page_number, $entries_per_page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->searchVariationGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **search_type** | **string**| The search method to use | [optional] |
| **search_text** | **string**| The search term (either in part of full) | [optional] |
| **page_number** | **int**| The page number (e.g. 1). | [optional] |
| **entries_per_page** | **int**| The number of entries to return per page. | [optional] |

### Return type

[**\Linnworks\Stock\Model\GenericPagedResultVariationGroup**](../Model/GenericPagedResultVariationGroup.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setStockLevel()`

```php
setStockLevel($stock_set_stock_level_request): \Linnworks\Stock\Model\StockItemLevel[]
```

SetStockLevel

Set the stock level of a list of stock items identified by its SKU to the value provided <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockLevelsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_set_stock_level_request = new \Linnworks\Stock\Model\StockSetStockLevelRequest(); // \Linnworks\Stock\Model\StockSetStockLevelRequest

try {
    $result = $apiInstance->setStockLevel($stock_set_stock_level_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->setStockLevel: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_set_stock_level_request** | [**\Linnworks\Stock\Model\StockSetStockLevelRequest**](../Model/StockSetStockLevelRequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\StockItemLevel[]**](../Model/StockItemLevel.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateSkuGroupIdentifier()`

```php
updateSkuGroupIdentifier($request): object
```

UpdateSkuGroupIdentifier

<b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWriteNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\UpdateSkuGroupIdentifierRequest(); // \Linnworks\Stock\Model\UpdateSkuGroupIdentifierRequest

try {
    $result = $apiInstance->updateSkuGroupIdentifier($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->updateSkuGroupIdentifier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\UpdateSkuGroupIdentifierRequest**](../Model/UpdateSkuGroupIdentifierRequest.md)|  | [optional] |

### Return type

**object**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateStockLevelsBulk()`

```php
updateStockLevelsBulk($request): \Linnworks\Stock\Model\UpdateStockLevelsBulkResponse
```

UpdateStockLevelsBulk

Allows the change of non batched / composite stock levels in build. Accepts either StockItemId or SKU and Stock location name or id <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockLevelsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\UpdateStockLevelsBulkRequest(); // \Linnworks\Stock\Model\UpdateStockLevelsBulkRequest

try {
    $result = $apiInstance->updateStockLevelsBulk($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->updateStockLevelsBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\UpdateStockLevelsBulkRequest**](../Model/UpdateStockLevelsBulkRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\UpdateStockLevelsBulkResponse**](../Model/UpdateStockLevelsBulkResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateStockLevelsBySKU()`

```php
updateStockLevelsBySKU($stock_update_stock_levels_by_sku_request): \Linnworks\Stock\Model\StockItemLevel[]
```

UpdateStockLevelsBySKU

Change the stock level of a list of stock items by the provided value <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockLevelsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_update_stock_levels_by_sku_request = new \Linnworks\Stock\Model\StockUpdateStockLevelsBySKURequest(); // \Linnworks\Stock\Model\StockUpdateStockLevelsBySKURequest

try {
    $result = $apiInstance->updateStockLevelsBySKU($stock_update_stock_levels_by_sku_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->updateStockLevelsBySKU: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_update_stock_levels_by_sku_request** | [**\Linnworks\Stock\Model\StockUpdateStockLevelsBySKURequest**](../Model/StockUpdateStockLevelsBySKURequest.md)|  | |

### Return type

[**\Linnworks\Stock\Model\StockItemLevel[]**](../Model/StockItemLevel.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateStockMinimumLevel()`

```php
updateStockMinimumLevel($stock_update_stock_minimum_level_request)
```

UpdateStockMinimumLevel

Use this call to update stock minimum level <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_update_stock_minimum_level_request = new \Linnworks\Stock\Model\StockUpdateStockMinimumLevelRequest(); // \Linnworks\Stock\Model\StockUpdateStockMinimumLevelRequest

try {
    $apiInstance->updateStockMinimumLevel($stock_update_stock_minimum_level_request);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->updateStockMinimumLevel: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_update_stock_minimum_level_request** | [**\Linnworks\Stock\Model\StockUpdateStockMinimumLevelRequest**](../Model/StockUpdateStockMinimumLevelRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateWarehouseMove()`

```php
updateWarehouseMove($request): \Linnworks\Stock\Model\GetWarehouseMoveResponse
```

UpdateWarehouseMove

Use this call to update a stock move <b>Permissions Required: </b> GlobalPermissions.Inventory.WarehouseManagement.StockMoveNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\UpdateWarehouseMoveRequest(); // \Linnworks\Stock\Model\UpdateWarehouseMoveRequest

try {
    $result = $apiInstance->updateWarehouseMove($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->updateWarehouseMove: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Stock\Model\UpdateWarehouseMoveRequest**](../Model/UpdateWarehouseMoveRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Stock\Model\GetWarehouseMoveResponse**](../Model/GetWarehouseMoveResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
