# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: token
$config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Stock\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Stock\Api\StockApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Stock\Model\AddRollingStockTakeRequest(); // \Linnworks\Stock\Model\AddRollingStockTakeRequest

try {
    $result = $apiInstance->addRollingStockTake($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling StockApi->addRollingStockTake: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://eu-ext.linnworks.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*StockApi* | [**addRollingStockTake**](docs/Api/StockApi.md#addrollingstocktake) | **POST** /api/Stock/AddRollingStockTake | AddRollingStockTake
*StockApi* | [**addVariationItems**](docs/Api/StockApi.md#addvariationitems) | **POST** /api/Stock/AddVariationItems | AddVariationItems
*StockApi* | [**batchStockLevelDelta**](docs/Api/StockApi.md#batchstockleveldelta) | **POST** /api/Stock/BatchStockLevelDelta | BatchStockLevelDelta
*StockApi* | [**bookInStockBatch**](docs/Api/StockApi.md#bookinstockbatch) | **POST** /api/Stock/BookInStockBatch | BookInStockBatch
*StockApi* | [**bookInStockItem**](docs/Api/StockApi.md#bookinstockitem) | **POST** /api/Stock/BookInStockItem | BookInStockItem
*StockApi* | [**checkVariationParentSKUExists**](docs/Api/StockApi.md#checkvariationparentskuexists) | **GET** /api/Stock/CheckVariationParentSKUExists | CheckVariationParentSKUExists
*StockApi* | [**completeWarehouseMove**](docs/Api/StockApi.md#completewarehousemove) | **POST** /api/Stock/CompleteWarehouseMove | CompleteWarehouseMove
*StockApi* | [**createStockBatches**](docs/Api/StockApi.md#createstockbatches) | **POST** /api/Stock/CreateStockBatches | CreateStockBatches
*StockApi* | [**createVariationGroup**](docs/Api/StockApi.md#createvariationgroup) | **POST** /api/Stock/CreateVariationGroup | CreateVariationGroup
*StockApi* | [**createWarehouseMove**](docs/Api/StockApi.md#createwarehousemove) | **POST** /api/Stock/CreateWarehouseMove | CreateWarehouseMove
*StockApi* | [**deleteMove**](docs/Api/StockApi.md#deletemove) | **POST** /api/Stock/DeleteMove | DeleteMove
*StockApi* | [**deleteVariationGroup**](docs/Api/StockApi.md#deletevariationgroup) | **GET** /api/Stock/DeleteVariationGroup | DeleteVariationGroup
*StockApi* | [**deleteVariationGroups**](docs/Api/StockApi.md#deletevariationgroups) | **POST** /api/Stock/DeleteVariationGroups | DeleteVariationGroups
*StockApi* | [**deleteVariationItem**](docs/Api/StockApi.md#deletevariationitem) | **POST** /api/Stock/DeleteVariationItem | DeleteVariationItem
*StockApi* | [**deleteVariationItems**](docs/Api/StockApi.md#deletevariationitems) | **POST** /api/Stock/DeleteVariationItems | DeleteVariationItems
*StockApi* | [**getBinRacksById**](docs/Api/StockApi.md#getbinracksbyid) | **POST** /api/Stock/GetBinRacksById | GetBinRacksById
*StockApi* | [**getBinrackSkus**](docs/Api/StockApi.md#getbinrackskus) | **POST** /api/Stock/GetBinrackSkus | GetBinrackSkus
*StockApi* | [**getItemChangesHistory**](docs/Api/StockApi.md#getitemchangeshistory) | **GET** /api/Stock/GetItemChangesHistory | GetItemChangesHistory
*StockApi* | [**getItemChangesHistoryCSV**](docs/Api/StockApi.md#getitemchangeshistorycsv) | **GET** /api/Stock/GetItemChangesHistoryCSV | GetItemChangesHistoryCSV
*StockApi* | [**getSoldStat**](docs/Api/StockApi.md#getsoldstat) | **GET** /api/Stock/GetSoldStat | GetSoldStat
*StockApi* | [**getStockConsumption**](docs/Api/StockApi.md#getstockconsumption) | **GET** /api/Stock/GetStockConsumption | GetStockConsumption
*StockApi* | [**getStockDuePO**](docs/Api/StockApi.md#getstockduepo) | **GET** /api/Stock/GetStockDuePO | GetStockDuePO
*StockApi* | [**getStockItemReturnStat**](docs/Api/StockApi.md#getstockitemreturnstat) | **GET** /api/Stock/GetStockItemReturnStat | GetStockItemReturnStat
*StockApi* | [**getStockItemScrapStat**](docs/Api/StockApi.md#getstockitemscrapstat) | **GET** /api/Stock/GetStockItemScrapStat | GetStockItemScrapStat
*StockApi* | [**getStockItemTypeInfo**](docs/Api/StockApi.md#getstockitemtypeinfo) | **POST** /api/Stock/GetStockItemTypeInfo | GetStockItemTypeInfo
*StockApi* | [**getStockItems**](docs/Api/StockApi.md#getstockitems) | **GET** /api/Stock/GetStockItems | GetStockItems
*StockApi* | [**getStockItemsByIds**](docs/Api/StockApi.md#getstockitemsbyids) | **POST** /api/Stock/GetStockItemsByIds | GetStockItemsByIds
*StockApi* | [**getStockItemsByKey**](docs/Api/StockApi.md#getstockitemsbykey) | **POST** /api/Stock/GetStockItemsByKey | GetStockItemsByKey
*StockApi* | [**getStockItemsFull**](docs/Api/StockApi.md#getstockitemsfull) | **POST** /api/Stock/GetStockItemsFull | GetStockItemsFull
*StockApi* | [**getStockItemsFullByIds**](docs/Api/StockApi.md#getstockitemsfullbyids) | **POST** /api/Stock/GetStockItemsFullByIds | GetStockItemsFullByIds
*StockApi* | [**getStockItemsLocation**](docs/Api/StockApi.md#getstockitemslocation) | **POST** /api/Stock/GetStockItemsLocation | GetStockItemsLocation
*StockApi* | [**getStockLevel**](docs/Api/StockApi.md#getstocklevel) | **GET** /api/Stock/GetStockLevel | GetStockLevel
*StockApi* | [**getStockLevelBatch**](docs/Api/StockApi.md#getstocklevelbatch) | **POST** /api/Stock/GetStockLevel_Batch | GetStockLevel_Batch
*StockApi* | [**getStockLevelByLocation**](docs/Api/StockApi.md#getstocklevelbylocation) | **POST** /api/Stock/GetStockLevelByLocation | GetStockLevelByLocation
*StockApi* | [**getStockSold**](docs/Api/StockApi.md#getstocksold) | **GET** /api/Stock/GetStockSold | GetStockSold
*StockApi* | [**getVariationGroupByName**](docs/Api/StockApi.md#getvariationgroupbyname) | **GET** /api/Stock/GetVariationGroupByName | GetVariationGroupByName
*StockApi* | [**getVariationGroupByParentId**](docs/Api/StockApi.md#getvariationgroupbyparentid) | **GET** /api/Stock/GetVariationGroupByParentId | GetVariationGroupByParentId
*StockApi* | [**getVariationGroupSearchTypes**](docs/Api/StockApi.md#getvariationgroupsearchtypes) | **GET** /api/Stock/GetVariationGroupSearchTypes | GetVariationGroupSearchTypes
*StockApi* | [**getVariationItems**](docs/Api/StockApi.md#getvariationitems) | **GET** /api/Stock/GetVariationItems | GetVariationItems
*StockApi* | [**getWarehouseMove**](docs/Api/StockApi.md#getwarehousemove) | **POST** /api/Stock/GetWarehouseMove | GetWarehouseMove
*StockApi* | [**getWarehouseMovesByBinrack**](docs/Api/StockApi.md#getwarehousemovesbybinrack) | **POST** /api/Stock/GetWarehouseMovesByBinrack | GetWarehouseMovesByBinrack
*StockApi* | [**renameVariationGroup**](docs/Api/StockApi.md#renamevariationgroup) | **POST** /api/Stock/RenameVariationGroup | RenameVariationGroup
*StockApi* | [**sKUExists**](docs/Api/StockApi.md#skuexists) | **GET** /api/Stock/SKUExists | SKUExists
*StockApi* | [**searchBinracks**](docs/Api/StockApi.md#searchbinracks) | **POST** /api/Stock/SearchBinracks | SearchBinracks
*StockApi* | [**searchVariationGroups**](docs/Api/StockApi.md#searchvariationgroups) | **GET** /api/Stock/SearchVariationGroups | SearchVariationGroups
*StockApi* | [**setStockLevel**](docs/Api/StockApi.md#setstocklevel) | **POST** /api/Stock/SetStockLevel | SetStockLevel
*StockApi* | [**updateSkuGroupIdentifier**](docs/Api/StockApi.md#updateskugroupidentifier) | **POST** /api/Stock/UpdateSkuGroupIdentifier | UpdateSkuGroupIdentifier
*StockApi* | [**updateStockLevelsBulk**](docs/Api/StockApi.md#updatestocklevelsbulk) | **POST** /api/Stock/UpdateStockLevelsBulk | UpdateStockLevelsBulk
*StockApi* | [**updateStockLevelsBySKU**](docs/Api/StockApi.md#updatestocklevelsbysku) | **POST** /api/Stock/UpdateStockLevelsBySKU | UpdateStockLevelsBySKU
*StockApi* | [**updateStockMinimumLevel**](docs/Api/StockApi.md#updatestockminimumlevel) | **POST** /api/Stock/UpdateStockMinimumLevel | UpdateStockMinimumLevel
*StockApi* | [**updateWarehouseMove**](docs/Api/StockApi.md#updatewarehousemove) | **POST** /api/Stock/UpdateWarehouseMove | UpdateWarehouseMove

## Models

- [AddRollingStockTakeRequest](docs/Model/AddRollingStockTakeRequest.md)
- [AddRollingStockTakeResponse](docs/Model/AddRollingStockTakeResponse.md)
- [BatchPickingWaveStockItems](docs/Model/BatchPickingWaveStockItems.md)
- [BatchStockLevelDelta](docs/Model/BatchStockLevelDelta.md)
- [BatchStockLevelDeltaResponse](docs/Model/BatchStockLevelDeltaResponse.md)
- [BatchStockLevelDetaRequest](docs/Model/BatchStockLevelDetaRequest.md)
- [BatchedBookIn](docs/Model/BatchedBookIn.md)
- [BinrackSkuResponse](docs/Model/BinrackSkuResponse.md)
- [BinracksResponse](docs/Model/BinracksResponse.md)
- [BookInStockItem](docs/Model/BookInStockItem.md)
- [CreateWarehouseMoveRequest](docs/Model/CreateWarehouseMoveRequest.md)
- [DeleteMoveRequest](docs/Model/DeleteMoveRequest.md)
- [DeleteVariationGroupsRequest](docs/Model/DeleteVariationGroupsRequest.md)
- [DeleteVariationItemsRequest](docs/Model/DeleteVariationItemsRequest.md)
- [Dimension](docs/Model/Dimension.md)
- [GenericEnumDescriptor](docs/Model/GenericEnumDescriptor.md)
- [GenericPagedResultStockItem](docs/Model/GenericPagedResultStockItem.md)
- [GenericPagedResultStockItemChangeHistory](docs/Model/GenericPagedResultStockItemChangeHistory.md)
- [GenericPagedResultVariationGroup](docs/Model/GenericPagedResultVariationGroup.md)
- [GeoPosition](docs/Model/GeoPosition.md)
- [GetBinRackSkusRequest](docs/Model/GetBinRackSkusRequest.md)
- [GetBinrackByIdRequest](docs/Model/GetBinrackByIdRequest.md)
- [GetStockItemTypeInfoRequest](docs/Model/GetStockItemTypeInfoRequest.md)
- [GetStockItemTypeInfoResponse](docs/Model/GetStockItemTypeInfoResponse.md)
- [GetStockItemsByIdsRequest](docs/Model/GetStockItemsByIdsRequest.md)
- [GetStockItemsByIdsResponse](docs/Model/GetStockItemsByIdsResponse.md)
- [GetStockItemsFullByIdsRequest](docs/Model/GetStockItemsFullByIdsRequest.md)
- [GetStockItemsFullByIdsResponse](docs/Model/GetStockItemsFullByIdsResponse.md)
- [GetStockItemsLocationRequest](docs/Model/GetStockItemsLocationRequest.md)
- [GetStockItemsLocationResponse](docs/Model/GetStockItemsLocationResponse.md)
- [GetStockLevelBatchRequest](docs/Model/GetStockLevelBatchRequest.md)
- [GetStockLevelBatchResponse](docs/Model/GetStockLevelBatchResponse.md)
- [GetStockLevelByLocationRequest](docs/Model/GetStockLevelByLocationRequest.md)
- [GetStockLevelByLocationResponse](docs/Model/GetStockLevelByLocationResponse.md)
- [GetWarehouseMoveRequest](docs/Model/GetWarehouseMoveRequest.md)
- [GetWarehouseMoveResponse](docs/Model/GetWarehouseMoveResponse.md)
- [GetWarehouseMovesByBinrackRequest](docs/Model/GetWarehouseMovesByBinrackRequest.md)
- [GetWarehouseMovesByBinrackResponse](docs/Model/GetWarehouseMovesByBinrackResponse.md)
- [InventoryStockLocation](docs/Model/InventoryStockLocation.md)
- [SearchBinracksRequest](docs/Model/SearchBinracksRequest.md)
- [SearchStockByKey](docs/Model/SearchStockByKey.md)
- [StockAddVariationItemsRequest](docs/Model/StockAddVariationItemsRequest.md)
- [StockBatchStockLevelDeltaRequest](docs/Model/StockBatchStockLevelDeltaRequest.md)
- [StockBookInStockBatchRequest](docs/Model/StockBookInStockBatchRequest.md)
- [StockBookInStockItemRequest](docs/Model/StockBookInStockItemRequest.md)
- [StockCompleteWarehouseMoveRequest](docs/Model/StockCompleteWarehouseMoveRequest.md)
- [StockConsumption](docs/Model/StockConsumption.md)
- [StockCreateStockBatchesRequest](docs/Model/StockCreateStockBatchesRequest.md)
- [StockCreateVariationGroupRequest](docs/Model/StockCreateVariationGroupRequest.md)
- [StockDeleteVariationGroupsRequest](docs/Model/StockDeleteVariationGroupsRequest.md)
- [StockDeleteVariationItemRequest](docs/Model/StockDeleteVariationItemRequest.md)
- [StockDeleteVariationItemsRequest](docs/Model/StockDeleteVariationItemsRequest.md)
- [StockGetStockItemsByKeyRequest](docs/Model/StockGetStockItemsByKeyRequest.md)
- [StockGetStockItemsFullByIdsRequest](docs/Model/StockGetStockItemsFullByIdsRequest.md)
- [StockGetStockItemsFullRequest](docs/Model/StockGetStockItemsFullRequest.md)
- [StockGetStockItemsLocationRequest](docs/Model/StockGetStockItemsLocationRequest.md)
- [StockGetStockLevelBatchRequest](docs/Model/StockGetStockLevelBatchRequest.md)
- [StockGetStockLevelByLocationRequest](docs/Model/StockGetStockLevelByLocationRequest.md)
- [StockGetWarehouseMovesByBinrackRequest](docs/Model/StockGetWarehouseMovesByBinrackRequest.md)
- [StockItem](docs/Model/StockItem.md)
- [StockItemBatch](docs/Model/StockItemBatch.md)
- [StockItemBatchInventory](docs/Model/StockItemBatchInventory.md)
- [StockItemChangeHistory](docs/Model/StockItemChangeHistory.md)
- [StockItemDescription](docs/Model/StockItemDescription.md)
- [StockItemDuePO](docs/Model/StockItemDuePO.md)
- [StockItemExtendedProperty](docs/Model/StockItemExtendedProperty.md)
- [StockItemFull](docs/Model/StockItemFull.md)
- [StockItemFullExtended](docs/Model/StockItemFullExtended.md)
- [StockItemHeader](docs/Model/StockItemHeader.md)
- [StockItemImage](docs/Model/StockItemImage.md)
- [StockItemLevel](docs/Model/StockItemLevel.md)
- [StockItemLocation](docs/Model/StockItemLocation.md)
- [StockItemPrice](docs/Model/StockItemPrice.md)
- [StockItemPricingRule](docs/Model/StockItemPricingRule.md)
- [StockItemReturn](docs/Model/StockItemReturn.md)
- [StockItemScrap](docs/Model/StockItemScrap.md)
- [StockItemSold](docs/Model/StockItemSold.md)
- [StockItemSoldStat](docs/Model/StockItemSoldStat.md)
- [StockItemSoldStatDetail](docs/Model/StockItemSoldStatDetail.md)
- [StockItemSoldStatFinalDetail](docs/Model/StockItemSoldStatFinalDetail.md)
- [StockItemSupplierStat](docs/Model/StockItemSupplierStat.md)
- [StockItemTitle](docs/Model/StockItemTitle.md)
- [StockItemTypeInfo](docs/Model/StockItemTypeInfo.md)
- [StockLevelUpdate](docs/Model/StockLevelUpdate.md)
- [StockLocationStockItemId](docs/Model/StockLocationStockItemId.md)
- [StockRenameVariationGroupRequest](docs/Model/StockRenameVariationGroupRequest.md)
- [StockSearchBinracksRequest](docs/Model/StockSearchBinracksRequest.md)
- [StockSetStockLevelRequest](docs/Model/StockSetStockLevelRequest.md)
- [StockTakeItem](docs/Model/StockTakeItem.md)
- [StockTakeItemWithError](docs/Model/StockTakeItemWithError.md)
- [StockUpdateStockLevelsBySKURequest](docs/Model/StockUpdateStockLevelsBySKURequest.md)
- [StockUpdateStockMinimumLevelRequest](docs/Model/StockUpdateStockMinimumLevelRequest.md)
- [TempFile](docs/Model/TempFile.md)
- [UpdateSkuGroupIdentifierRequest](docs/Model/UpdateSkuGroupIdentifierRequest.md)
- [UpdateSkuGroupIdentifierRequestItems](docs/Model/UpdateSkuGroupIdentifierRequestItems.md)
- [UpdateStockLevelsBulkRequest](docs/Model/UpdateStockLevelsBulkRequest.md)
- [UpdateStockLevelsBulkRequestItem](docs/Model/UpdateStockLevelsBulkRequestItem.md)
- [UpdateStockLevelsBulkResponse](docs/Model/UpdateStockLevelsBulkResponse.md)
- [UpdateStockLevelsBulkResponseItem](docs/Model/UpdateStockLevelsBulkResponseItem.md)
- [UpdateWarehouseMoveRequest](docs/Model/UpdateWarehouseMoveRequest.md)
- [VariationGroup](docs/Model/VariationGroup.md)
- [VariationGroupTemplate](docs/Model/VariationGroupTemplate.md)
- [VariationItem](docs/Model/VariationItem.md)
- [WarehouseBinRack](docs/Model/WarehouseBinRack.md)
- [WarehouseBinRackItemsInfo](docs/Model/WarehouseBinRackItemsInfo.md)
- [WarehouseBinRackType](docs/Model/WarehouseBinRackType.md)
- [WarehouseMoveCollection](docs/Model/WarehouseMoveCollection.md)
- [WarehouseMoveCompleteRequest](docs/Model/WarehouseMoveCompleteRequest.md)
- [WarehouseMoveDetailed](docs/Model/WarehouseMoveDetailed.md)

## Authorization

Authentication schemes defined for the API:
### token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `stock`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
