<?php
/**
 * SettingsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Settings
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Settings API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: settings
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Settings\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Linnworks\Settings\ApiException;
use Linnworks\Settings\Configuration;
use Linnworks\Settings\HeaderSelector;
use Linnworks\Settings\ObjectSerializer;

/**
 * SettingsApi Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Settings
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SettingsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'deleteCurrencyConversionRates' => [
            'application/json',
        ],
        'getAvailableTimeZones' => [
            'application/json',
        ],
        'getCurrencyConversionRates' => [
            'application/json',
        ],
        'getLatestCurrencyRate' => [
            'application/json',
        ],
        'getMeasures' => [
            'application/json',
        ],
        'insertCurrencyConversionRates' => [
            'application/json',
        ],
        'updateCurrencyConversionRates' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteCurrencyConversionRates
     *
     * DeleteCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest $settings_delete_currency_conversion_rates_request settings_delete_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteCurrencyConversionRates($settings_delete_currency_conversion_rates_request, string $contentType = self::contentTypes['deleteCurrencyConversionRates'][0])
    {
        $this->deleteCurrencyConversionRatesWithHttpInfo($settings_delete_currency_conversion_rates_request, $contentType);
    }

    /**
     * Operation deleteCurrencyConversionRatesWithHttpInfo
     *
     * DeleteCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest $settings_delete_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCurrencyConversionRatesWithHttpInfo($settings_delete_currency_conversion_rates_request, string $contentType = self::contentTypes['deleteCurrencyConversionRates'][0])
    {
        $request = $this->deleteCurrencyConversionRatesRequest($settings_delete_currency_conversion_rates_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteCurrencyConversionRatesAsync
     *
     * DeleteCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest $settings_delete_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCurrencyConversionRatesAsync($settings_delete_currency_conversion_rates_request, string $contentType = self::contentTypes['deleteCurrencyConversionRates'][0])
    {
        return $this->deleteCurrencyConversionRatesAsyncWithHttpInfo($settings_delete_currency_conversion_rates_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCurrencyConversionRatesAsyncWithHttpInfo
     *
     * DeleteCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest $settings_delete_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCurrencyConversionRatesAsyncWithHttpInfo($settings_delete_currency_conversion_rates_request, string $contentType = self::contentTypes['deleteCurrencyConversionRates'][0])
    {
        $returnType = '';
        $request = $this->deleteCurrencyConversionRatesRequest($settings_delete_currency_conversion_rates_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCurrencyConversionRates'
     *
     * @param  \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest $settings_delete_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCurrencyConversionRatesRequest($settings_delete_currency_conversion_rates_request, string $contentType = self::contentTypes['deleteCurrencyConversionRates'][0])
    {

        // verify the required parameter 'settings_delete_currency_conversion_rates_request' is set
        if ($settings_delete_currency_conversion_rates_request === null || (is_array($settings_delete_currency_conversion_rates_request) && count($settings_delete_currency_conversion_rates_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $settings_delete_currency_conversion_rates_request when calling deleteCurrencyConversionRates'
            );
        }


        $resourcePath = '/api/Settings/DeleteCurrencyConversionRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($settings_delete_currency_conversion_rates_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($settings_delete_currency_conversion_rates_request));
            } else {
                $httpBody = $settings_delete_currency_conversion_rates_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAvailableTimeZones
     *
     * GetAvailableTimeZones
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableTimeZones'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Settings\Model\GetAvailableTimeZonesResponse
     */
    public function getAvailableTimeZones(string $contentType = self::contentTypes['getAvailableTimeZones'][0])
    {
        list($response) = $this->getAvailableTimeZonesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getAvailableTimeZonesWithHttpInfo
     *
     * GetAvailableTimeZones
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableTimeZones'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Settings\Model\GetAvailableTimeZonesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAvailableTimeZonesWithHttpInfo(string $contentType = self::contentTypes['getAvailableTimeZones'][0])
    {
        $request = $this->getAvailableTimeZonesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Settings\Model\GetAvailableTimeZonesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Settings\Model\GetAvailableTimeZonesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Settings\Model\GetAvailableTimeZonesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Settings\Model\GetAvailableTimeZonesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Settings\Model\GetAvailableTimeZonesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAvailableTimeZonesAsync
     *
     * GetAvailableTimeZones
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableTimeZones'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAvailableTimeZonesAsync(string $contentType = self::contentTypes['getAvailableTimeZones'][0])
    {
        return $this->getAvailableTimeZonesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAvailableTimeZonesAsyncWithHttpInfo
     *
     * GetAvailableTimeZones
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableTimeZones'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAvailableTimeZonesAsyncWithHttpInfo(string $contentType = self::contentTypes['getAvailableTimeZones'][0])
    {
        $returnType = '\Linnworks\Settings\Model\GetAvailableTimeZonesResponse';
        $request = $this->getAvailableTimeZonesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAvailableTimeZones'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAvailableTimeZones'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAvailableTimeZonesRequest(string $contentType = self::contentTypes['getAvailableTimeZones'][0])
    {


        $resourcePath = '/api/Settings/GetAvailableTimeZones';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCurrencyConversionRates
     *
     * GetCurrencyConversionRates
     *
     * @param  bool|null $get_currencies_from_orders If you want to get currencies from orders (optional)
     * @param  string|null $currency Currency (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Settings\Model\CurrencyConversionRate[]
     */
    public function getCurrencyConversionRates($get_currencies_from_orders = null, $currency = null, string $contentType = self::contentTypes['getCurrencyConversionRates'][0])
    {
        list($response) = $this->getCurrencyConversionRatesWithHttpInfo($get_currencies_from_orders, $currency, $contentType);
        return $response;
    }

    /**
     * Operation getCurrencyConversionRatesWithHttpInfo
     *
     * GetCurrencyConversionRates
     *
     * @param  bool|null $get_currencies_from_orders If you want to get currencies from orders (optional)
     * @param  string|null $currency Currency (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Settings\Model\CurrencyConversionRate[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getCurrencyConversionRatesWithHttpInfo($get_currencies_from_orders = null, $currency = null, string $contentType = self::contentTypes['getCurrencyConversionRates'][0])
    {
        $request = $this->getCurrencyConversionRatesRequest($get_currencies_from_orders, $currency, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Settings\Model\CurrencyConversionRate[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Settings\Model\CurrencyConversionRate[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Settings\Model\CurrencyConversionRate[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Settings\Model\CurrencyConversionRate[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Settings\Model\CurrencyConversionRate[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCurrencyConversionRatesAsync
     *
     * GetCurrencyConversionRates
     *
     * @param  bool|null $get_currencies_from_orders If you want to get currencies from orders (optional)
     * @param  string|null $currency Currency (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCurrencyConversionRatesAsync($get_currencies_from_orders = null, $currency = null, string $contentType = self::contentTypes['getCurrencyConversionRates'][0])
    {
        return $this->getCurrencyConversionRatesAsyncWithHttpInfo($get_currencies_from_orders, $currency, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCurrencyConversionRatesAsyncWithHttpInfo
     *
     * GetCurrencyConversionRates
     *
     * @param  bool|null $get_currencies_from_orders If you want to get currencies from orders (optional)
     * @param  string|null $currency Currency (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCurrencyConversionRatesAsyncWithHttpInfo($get_currencies_from_orders = null, $currency = null, string $contentType = self::contentTypes['getCurrencyConversionRates'][0])
    {
        $returnType = '\Linnworks\Settings\Model\CurrencyConversionRate[]';
        $request = $this->getCurrencyConversionRatesRequest($get_currencies_from_orders, $currency, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCurrencyConversionRates'
     *
     * @param  bool|null $get_currencies_from_orders If you want to get currencies from orders (optional)
     * @param  string|null $currency Currency (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCurrencyConversionRatesRequest($get_currencies_from_orders = null, $currency = null, string $contentType = self::contentTypes['getCurrencyConversionRates'][0])
    {




        $resourcePath = '/api/Settings/GetCurrencyConversionRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $get_currencies_from_orders,
            'getCurrenciesFromOrders', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $currency,
            'currency', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLatestCurrencyRate
     *
     * GetLatestCurrencyRate
     *
     * @param  string|null $base_currency Base currency for conversion rates, if null, USD is used (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLatestCurrencyRate'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Settings\Model\GetLatestCurrencyRateResponse
     */
    public function getLatestCurrencyRate($base_currency = null, string $contentType = self::contentTypes['getLatestCurrencyRate'][0])
    {
        list($response) = $this->getLatestCurrencyRateWithHttpInfo($base_currency, $contentType);
        return $response;
    }

    /**
     * Operation getLatestCurrencyRateWithHttpInfo
     *
     * GetLatestCurrencyRate
     *
     * @param  string|null $base_currency Base currency for conversion rates, if null, USD is used (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLatestCurrencyRate'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Settings\Model\GetLatestCurrencyRateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLatestCurrencyRateWithHttpInfo($base_currency = null, string $contentType = self::contentTypes['getLatestCurrencyRate'][0])
    {
        $request = $this->getLatestCurrencyRateRequest($base_currency, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Settings\Model\GetLatestCurrencyRateResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Settings\Model\GetLatestCurrencyRateResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Settings\Model\GetLatestCurrencyRateResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Settings\Model\GetLatestCurrencyRateResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Settings\Model\GetLatestCurrencyRateResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLatestCurrencyRateAsync
     *
     * GetLatestCurrencyRate
     *
     * @param  string|null $base_currency Base currency for conversion rates, if null, USD is used (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLatestCurrencyRate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLatestCurrencyRateAsync($base_currency = null, string $contentType = self::contentTypes['getLatestCurrencyRate'][0])
    {
        return $this->getLatestCurrencyRateAsyncWithHttpInfo($base_currency, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLatestCurrencyRateAsyncWithHttpInfo
     *
     * GetLatestCurrencyRate
     *
     * @param  string|null $base_currency Base currency for conversion rates, if null, USD is used (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLatestCurrencyRate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLatestCurrencyRateAsyncWithHttpInfo($base_currency = null, string $contentType = self::contentTypes['getLatestCurrencyRate'][0])
    {
        $returnType = '\Linnworks\Settings\Model\GetLatestCurrencyRateResponse';
        $request = $this->getLatestCurrencyRateRequest($base_currency, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLatestCurrencyRate'
     *
     * @param  string|null $base_currency Base currency for conversion rates, if null, USD is used (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getLatestCurrencyRate'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getLatestCurrencyRateRequest($base_currency = null, string $contentType = self::contentTypes['getLatestCurrencyRate'][0])
    {



        $resourcePath = '/api/Settings/GetLatestCurrencyRate';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $base_currency,
            'baseCurrency', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getMeasures
     *
     * GetMeasures
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getMeasures'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Settings\Model\Measures
     */
    public function getMeasures(string $contentType = self::contentTypes['getMeasures'][0])
    {
        list($response) = $this->getMeasuresWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getMeasuresWithHttpInfo
     *
     * GetMeasures
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getMeasures'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Settings\Model\Measures, HTTP status code, HTTP response headers (array of strings)
     */
    public function getMeasuresWithHttpInfo(string $contentType = self::contentTypes['getMeasures'][0])
    {
        $request = $this->getMeasuresRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Settings\Model\Measures' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Settings\Model\Measures' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Settings\Model\Measures', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Settings\Model\Measures';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Settings\Model\Measures',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getMeasuresAsync
     *
     * GetMeasures
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getMeasures'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getMeasuresAsync(string $contentType = self::contentTypes['getMeasures'][0])
    {
        return $this->getMeasuresAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getMeasuresAsyncWithHttpInfo
     *
     * GetMeasures
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getMeasures'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getMeasuresAsyncWithHttpInfo(string $contentType = self::contentTypes['getMeasures'][0])
    {
        $returnType = '\Linnworks\Settings\Model\Measures';
        $request = $this->getMeasuresRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getMeasures'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getMeasures'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getMeasuresRequest(string $contentType = self::contentTypes['getMeasures'][0])
    {


        $resourcePath = '/api/Settings/GetMeasures';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation insertCurrencyConversionRates
     *
     * InsertCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsInsertCurrencyConversionRatesRequest $settings_insert_currency_conversion_rates_request settings_insert_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['insertCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function insertCurrencyConversionRates($settings_insert_currency_conversion_rates_request, string $contentType = self::contentTypes['insertCurrencyConversionRates'][0])
    {
        $this->insertCurrencyConversionRatesWithHttpInfo($settings_insert_currency_conversion_rates_request, $contentType);
    }

    /**
     * Operation insertCurrencyConversionRatesWithHttpInfo
     *
     * InsertCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsInsertCurrencyConversionRatesRequest $settings_insert_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['insertCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function insertCurrencyConversionRatesWithHttpInfo($settings_insert_currency_conversion_rates_request, string $contentType = self::contentTypes['insertCurrencyConversionRates'][0])
    {
        $request = $this->insertCurrencyConversionRatesRequest($settings_insert_currency_conversion_rates_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation insertCurrencyConversionRatesAsync
     *
     * InsertCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsInsertCurrencyConversionRatesRequest $settings_insert_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['insertCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function insertCurrencyConversionRatesAsync($settings_insert_currency_conversion_rates_request, string $contentType = self::contentTypes['insertCurrencyConversionRates'][0])
    {
        return $this->insertCurrencyConversionRatesAsyncWithHttpInfo($settings_insert_currency_conversion_rates_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation insertCurrencyConversionRatesAsyncWithHttpInfo
     *
     * InsertCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsInsertCurrencyConversionRatesRequest $settings_insert_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['insertCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function insertCurrencyConversionRatesAsyncWithHttpInfo($settings_insert_currency_conversion_rates_request, string $contentType = self::contentTypes['insertCurrencyConversionRates'][0])
    {
        $returnType = '';
        $request = $this->insertCurrencyConversionRatesRequest($settings_insert_currency_conversion_rates_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'insertCurrencyConversionRates'
     *
     * @param  \Linnworks\Settings\Model\SettingsInsertCurrencyConversionRatesRequest $settings_insert_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['insertCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function insertCurrencyConversionRatesRequest($settings_insert_currency_conversion_rates_request, string $contentType = self::contentTypes['insertCurrencyConversionRates'][0])
    {

        // verify the required parameter 'settings_insert_currency_conversion_rates_request' is set
        if ($settings_insert_currency_conversion_rates_request === null || (is_array($settings_insert_currency_conversion_rates_request) && count($settings_insert_currency_conversion_rates_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $settings_insert_currency_conversion_rates_request when calling insertCurrencyConversionRates'
            );
        }


        $resourcePath = '/api/Settings/InsertCurrencyConversionRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($settings_insert_currency_conversion_rates_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($settings_insert_currency_conversion_rates_request));
            } else {
                $httpBody = $settings_insert_currency_conversion_rates_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateCurrencyConversionRates
     *
     * UpdateCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsUpdateCurrencyConversionRatesRequest $settings_update_currency_conversion_rates_request settings_update_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateCurrencyConversionRates($settings_update_currency_conversion_rates_request, string $contentType = self::contentTypes['updateCurrencyConversionRates'][0])
    {
        $this->updateCurrencyConversionRatesWithHttpInfo($settings_update_currency_conversion_rates_request, $contentType);
    }

    /**
     * Operation updateCurrencyConversionRatesWithHttpInfo
     *
     * UpdateCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsUpdateCurrencyConversionRatesRequest $settings_update_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \Linnworks\Settings\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCurrencyConversionRatesWithHttpInfo($settings_update_currency_conversion_rates_request, string $contentType = self::contentTypes['updateCurrencyConversionRates'][0])
    {
        $request = $this->updateCurrencyConversionRatesRequest($settings_update_currency_conversion_rates_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateCurrencyConversionRatesAsync
     *
     * UpdateCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsUpdateCurrencyConversionRatesRequest $settings_update_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCurrencyConversionRatesAsync($settings_update_currency_conversion_rates_request, string $contentType = self::contentTypes['updateCurrencyConversionRates'][0])
    {
        return $this->updateCurrencyConversionRatesAsyncWithHttpInfo($settings_update_currency_conversion_rates_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateCurrencyConversionRatesAsyncWithHttpInfo
     *
     * UpdateCurrencyConversionRates
     *
     * @param  \Linnworks\Settings\Model\SettingsUpdateCurrencyConversionRatesRequest $settings_update_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCurrencyConversionRatesAsyncWithHttpInfo($settings_update_currency_conversion_rates_request, string $contentType = self::contentTypes['updateCurrencyConversionRates'][0])
    {
        $returnType = '';
        $request = $this->updateCurrencyConversionRatesRequest($settings_update_currency_conversion_rates_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateCurrencyConversionRates'
     *
     * @param  \Linnworks\Settings\Model\SettingsUpdateCurrencyConversionRatesRequest $settings_update_currency_conversion_rates_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCurrencyConversionRates'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateCurrencyConversionRatesRequest($settings_update_currency_conversion_rates_request, string $contentType = self::contentTypes['updateCurrencyConversionRates'][0])
    {

        // verify the required parameter 'settings_update_currency_conversion_rates_request' is set
        if ($settings_update_currency_conversion_rates_request === null || (is_array($settings_update_currency_conversion_rates_request) && count($settings_update_currency_conversion_rates_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $settings_update_currency_conversion_rates_request when calling updateCurrencyConversionRates'
            );
        }


        $resourcePath = '/api/Settings/UpdateCurrencyConversionRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($settings_update_currency_conversion_rates_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($settings_update_currency_conversion_rates_request));
            } else {
                $httpBody = $settings_update_currency_conversion_rates_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
