# Linnworks\Settings\SettingsApi

All URIs are relative to https://eu-ext.linnworks.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**deleteCurrencyConversionRates()**](SettingsApi.md#deleteCurrencyConversionRates) | **POST** /api/Settings/DeleteCurrencyConversionRates | DeleteCurrencyConversionRates |
| [**getAvailableTimeZones()**](SettingsApi.md#getAvailableTimeZones) | **GET** /api/Settings/GetAvailableTimeZones | GetAvailableTimeZones |
| [**getCurrencyConversionRates()**](SettingsApi.md#getCurrencyConversionRates) | **GET** /api/Settings/GetCurrencyConversionRates | GetCurrencyConversionRates |
| [**getLatestCurrencyRate()**](SettingsApi.md#getLatestCurrencyRate) | **GET** /api/Settings/GetLatestCurrencyRate | GetLatestCurrencyRate |
| [**getMeasures()**](SettingsApi.md#getMeasures) | **GET** /api/Settings/GetMeasures | GetMeasures |
| [**insertCurrencyConversionRates()**](SettingsApi.md#insertCurrencyConversionRates) | **POST** /api/Settings/InsertCurrencyConversionRates | InsertCurrencyConversionRates |
| [**updateCurrencyConversionRates()**](SettingsApi.md#updateCurrencyConversionRates) | **POST** /api/Settings/UpdateCurrencyConversionRates | UpdateCurrencyConversionRates |


## `deleteCurrencyConversionRates()`

```php
deleteCurrencyConversionRates($settings_delete_currency_conversion_rates_request)
```

DeleteCurrencyConversionRates

Delete currency conversion rates <b>Permissions Required: </b> GlobalPermissions.Settings.CurrencyRates.EditCurrencyRatesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Settings\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$settings_delete_currency_conversion_rates_request = new \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest(); // \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest

try {
    $apiInstance->deleteCurrencyConversionRates($settings_delete_currency_conversion_rates_request);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->deleteCurrencyConversionRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **settings_delete_currency_conversion_rates_request** | [**\Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest**](../Model/SettingsDeleteCurrencyConversionRatesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAvailableTimeZones()`

```php
getAvailableTimeZones(): \Linnworks\Settings\Model\GetAvailableTimeZonesResponse
```

GetAvailableTimeZones

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Settings\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getAvailableTimeZones();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->getAvailableTimeZones: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Settings\Model\GetAvailableTimeZonesResponse**](../Model/GetAvailableTimeZonesResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCurrencyConversionRates()`

```php
getCurrencyConversionRates($get_currencies_from_orders, $currency): \Linnworks\Settings\Model\CurrencyConversionRate[]
```

GetCurrencyConversionRates

Get Currency Conversion Rates <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Settings\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$get_currencies_from_orders = True; // bool | If you want to get currencies from orders
$currency = 'currency_example'; // string | Currency

try {
    $result = $apiInstance->getCurrencyConversionRates($get_currencies_from_orders, $currency);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->getCurrencyConversionRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **get_currencies_from_orders** | **bool**| If you want to get currencies from orders | [optional] |
| **currency** | **string**| Currency | [optional] |

### Return type

[**\Linnworks\Settings\Model\CurrencyConversionRate[]**](../Model/CurrencyConversionRate.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getLatestCurrencyRate()`

```php
getLatestCurrencyRate($base_currency): \Linnworks\Settings\Model\GetLatestCurrencyRateResponse
```

GetLatestCurrencyRate

Gets latest conversion rates for all known currencies. The rate is updated every couple of hours. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Settings\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$base_currency = 'base_currency_example'; // string | Base currency for conversion rates, if null, USD is used

try {
    $result = $apiInstance->getLatestCurrencyRate($base_currency);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->getLatestCurrencyRate: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **base_currency** | **string**| Base currency for conversion rates, if null, USD is used | [optional] |

### Return type

[**\Linnworks\Settings\Model\GetLatestCurrencyRateResponse**](../Model/GetLatestCurrencyRateResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getMeasures()`

```php
getMeasures(): \Linnworks\Settings\Model\Measures
```

GetMeasures

Get user measures units from the database <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Settings\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getMeasures();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->getMeasures: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Settings\Model\Measures**](../Model/Measures.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `insertCurrencyConversionRates()`

```php
insertCurrencyConversionRates($settings_insert_currency_conversion_rates_request)
```

InsertCurrencyConversionRates

Insert currency conversion rates <b>Permissions Required: </b> GlobalPermissions.Settings.CurrencyRates.EditCurrencyRatesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Settings\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$settings_insert_currency_conversion_rates_request = new \Linnworks\Settings\Model\SettingsInsertCurrencyConversionRatesRequest(); // \Linnworks\Settings\Model\SettingsInsertCurrencyConversionRatesRequest

try {
    $apiInstance->insertCurrencyConversionRates($settings_insert_currency_conversion_rates_request);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->insertCurrencyConversionRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **settings_insert_currency_conversion_rates_request** | [**\Linnworks\Settings\Model\SettingsInsertCurrencyConversionRatesRequest**](../Model/SettingsInsertCurrencyConversionRatesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCurrencyConversionRates()`

```php
updateCurrencyConversionRates($settings_update_currency_conversion_rates_request)
```

UpdateCurrencyConversionRates

Update Currency Conversion Rates <b>Permissions Required: </b> GlobalPermissions.Settings.CurrencyRates.EditCurrencyRatesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Settings\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$settings_update_currency_conversion_rates_request = new \Linnworks\Settings\Model\SettingsUpdateCurrencyConversionRatesRequest(); // \Linnworks\Settings\Model\SettingsUpdateCurrencyConversionRatesRequest

try {
    $apiInstance->updateCurrencyConversionRates($settings_update_currency_conversion_rates_request);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->updateCurrencyConversionRates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **settings_update_currency_conversion_rates_request** | [**\Linnworks\Settings\Model\SettingsUpdateCurrencyConversionRatesRequest**](../Model/SettingsUpdateCurrencyConversionRatesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
