# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: token
$config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Settings\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Settings\Api\SettingsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$settings_delete_currency_conversion_rates_request = new \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest(); // \Linnworks\Settings\Model\SettingsDeleteCurrencyConversionRatesRequest

try {
    $apiInstance->deleteCurrencyConversionRates($settings_delete_currency_conversion_rates_request);
} catch (Exception $e) {
    echo 'Exception when calling SettingsApi->deleteCurrencyConversionRates: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://eu-ext.linnworks.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SettingsApi* | [**deleteCurrencyConversionRates**](docs/Api/SettingsApi.md#deletecurrencyconversionrates) | **POST** /api/Settings/DeleteCurrencyConversionRates | DeleteCurrencyConversionRates
*SettingsApi* | [**getAvailableTimeZones**](docs/Api/SettingsApi.md#getavailabletimezones) | **GET** /api/Settings/GetAvailableTimeZones | GetAvailableTimeZones
*SettingsApi* | [**getCurrencyConversionRates**](docs/Api/SettingsApi.md#getcurrencyconversionrates) | **GET** /api/Settings/GetCurrencyConversionRates | GetCurrencyConversionRates
*SettingsApi* | [**getLatestCurrencyRate**](docs/Api/SettingsApi.md#getlatestcurrencyrate) | **GET** /api/Settings/GetLatestCurrencyRate | GetLatestCurrencyRate
*SettingsApi* | [**getMeasures**](docs/Api/SettingsApi.md#getmeasures) | **GET** /api/Settings/GetMeasures | GetMeasures
*SettingsApi* | [**insertCurrencyConversionRates**](docs/Api/SettingsApi.md#insertcurrencyconversionrates) | **POST** /api/Settings/InsertCurrencyConversionRates | InsertCurrencyConversionRates
*SettingsApi* | [**updateCurrencyConversionRates**](docs/Api/SettingsApi.md#updatecurrencyconversionrates) | **POST** /api/Settings/UpdateCurrencyConversionRates | UpdateCurrencyConversionRates

## Models

- [AvailableTimeZone](docs/Model/AvailableTimeZone.md)
- [CurrencyConversionRate](docs/Model/CurrencyConversionRate.md)
- [CurrencyRate](docs/Model/CurrencyRate.md)
- [GetAvailableTimeZonesResponse](docs/Model/GetAvailableTimeZonesResponse.md)
- [GetConversionRatesRequest](docs/Model/GetConversionRatesRequest.md)
- [GetLatestCurrencyRateRequest](docs/Model/GetLatestCurrencyRateRequest.md)
- [GetLatestCurrencyRateResponse](docs/Model/GetLatestCurrencyRateResponse.md)
- [Measures](docs/Model/Measures.md)
- [SettingsDeleteCurrencyConversionRatesRequest](docs/Model/SettingsDeleteCurrencyConversionRatesRequest.md)
- [SettingsInsertCurrencyConversionRatesRequest](docs/Model/SettingsInsertCurrencyConversionRatesRequest.md)
- [SettingsUpdateCurrencyConversionRatesRequest](docs/Model/SettingsUpdateCurrencyConversionRatesRequest.md)

## Authorization

Authentication schemes defined for the API:
### token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `settings`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
