<?php
/**
 * VerifiedRefundItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * VerifiedRefundItem Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class VerifiedRefundItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'VerifiedRefundItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_item_row_id' => 'string',
        'return_row_id' => 'int',
        'item_sku' => 'string',
        'channel_sku' => 'string',
        'item_title' => 'string',
        'cost' => 'float',
        'cancelled_quantity' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_item_row_id' => 'uuid',
        'return_row_id' => 'int32',
        'item_sku' => null,
        'channel_sku' => null,
        'item_title' => null,
        'cost' => 'double',
        'cancelled_quantity' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_item_row_id' => false,
        'return_row_id' => false,
        'item_sku' => false,
        'channel_sku' => false,
        'item_title' => false,
        'cost' => false,
        'cancelled_quantity' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_item_row_id' => 'OrderItemRowId',
        'return_row_id' => 'ReturnRowId',
        'item_sku' => 'ItemSKU',
        'channel_sku' => 'ChannelSKU',
        'item_title' => 'ItemTitle',
        'cost' => 'Cost',
        'cancelled_quantity' => 'CancelledQuantity'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_item_row_id' => 'setOrderItemRowId',
        'return_row_id' => 'setReturnRowId',
        'item_sku' => 'setItemSku',
        'channel_sku' => 'setChannelSku',
        'item_title' => 'setItemTitle',
        'cost' => 'setCost',
        'cancelled_quantity' => 'setCancelledQuantity'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_item_row_id' => 'getOrderItemRowId',
        'return_row_id' => 'getReturnRowId',
        'item_sku' => 'getItemSku',
        'channel_sku' => 'getChannelSku',
        'item_title' => 'getItemTitle',
        'cost' => 'getCost',
        'cancelled_quantity' => 'getCancelledQuantity'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_item_row_id', $data ?? [], null);
        $this->setIfExists('return_row_id', $data ?? [], null);
        $this->setIfExists('item_sku', $data ?? [], null);
        $this->setIfExists('channel_sku', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('cancelled_quantity', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_item_row_id
     *
     * @return string|null
     */
    public function getOrderItemRowId()
    {
        return $this->container['order_item_row_id'];
    }

    /**
     * Sets order_item_row_id
     *
     * @param string|null $order_item_row_id The unique order item identifier
     *
     * @return self
     */
    public function setOrderItemRowId($order_item_row_id)
    {
        if (is_null($order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_row_id cannot be null');
        }
        $this->container['order_item_row_id'] = $order_item_row_id;

        return $this;
    }

    /**
     * Gets return_row_id
     *
     * @return int|null
     */
    public function getReturnRowId()
    {
        return $this->container['return_row_id'];
    }

    /**
     * Sets return_row_id
     *
     * @param int|null $return_row_id A unique identifier for the return line this refund relates to. If null, it is an independent refund
     *
     * @return self
     */
    public function setReturnRowId($return_row_id)
    {
        if (is_null($return_row_id)) {
            throw new \InvalidArgumentException('non-nullable return_row_id cannot be null');
        }
        $this->container['return_row_id'] = $return_row_id;

        return $this;
    }

    /**
     * Gets item_sku
     *
     * @return string|null
     */
    public function getItemSku()
    {
        return $this->container['item_sku'];
    }

    /**
     * Sets item_sku
     *
     * @param string|null $item_sku The Linnworks SKU for the item, assuming it is linked. If it is not, this matches the channel SKU
     *
     * @return self
     */
    public function setItemSku($item_sku)
    {
        if (is_null($item_sku)) {
            throw new \InvalidArgumentException('non-nullable item_sku cannot be null');
        }
        $this->container['item_sku'] = $item_sku;

        return $this;
    }

    /**
     * Gets channel_sku
     *
     * @return string|null
     */
    public function getChannelSku()
    {
        return $this->container['channel_sku'];
    }

    /**
     * Sets channel_sku
     *
     * @param string|null $channel_sku The channel's SKU for the item
     *
     * @return self
     */
    public function setChannelSku($channel_sku)
    {
        if (is_null($channel_sku)) {
            throw new \InvalidArgumentException('non-nullable channel_sku cannot be null');
        }
        $this->container['channel_sku'] = $channel_sku;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title For a linked item, the Linnworks item title for this channel (or the default item title where a specific channel title does not exist). For an unlinked item, this is the title  provided by the channel
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float|null $cost The tax-inclusive cost for this line
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets cancelled_quantity
     *
     * @return int|null
     */
    public function getCancelledQuantity()
    {
        return $this->container['cancelled_quantity'];
    }

    /**
     * Sets cancelled_quantity
     *
     * @param int|null $cancelled_quantity If a refund is linked to a cancellation request, this field denotes the amount of the item cancelled
     *
     * @return self
     */
    public function setCancelledQuantity($cancelled_quantity)
    {
        if (is_null($cancelled_quantity)) {
            throw new \InvalidArgumentException('non-nullable cancelled_quantity cannot be null');
        }
        $this->container['cancelled_quantity'] = $cancelled_quantity;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


