<?php
/**
 * VerifiedRefund
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * VerifiedRefund Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class VerifiedRefund implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'VerifiedRefund';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'refund_row_id' => 'string',
        'refund_header_id' => 'int',
        'status' => '\Linnworks\ReturnsRefunds\Model\PostSaleStatus',
        'refunded_unit' => 'string',
        'is_shipping_refund' => 'bool',
        'is_additional_refund' => 'bool',
        'is_cancellation' => 'bool',
        'refunded_item' => '\Linnworks\ReturnsRefunds\Model\VerifiedRefundItem',
        'validation_error' => 'string',
        'error' => 'string',
        'errors' => '\Linnworks\ReturnsRefunds\Model\RefundError[]',
        'actioned' => 'bool',
        'actioned_date' => '\DateTime',
        'channel_initiated' => 'bool',
        'internal' => 'bool',
        'deleted' => 'bool',
        'external_reference' => 'string',
        'is_free_text' => 'bool',
        'free_text_or_note' => 'string',
        'amount' => 'float',
        'quantity' => 'int',
        'reason_tag' => 'string',
        'sub_reason_tag' => 'string',
        'insufficient_refund_tag' => 'string',
        'insufficient_refund_note' => 'string',
        'reason_category' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'refund_row_id' => 'uuid',
        'refund_header_id' => 'int32',
        'status' => null,
        'refunded_unit' => null,
        'is_shipping_refund' => null,
        'is_additional_refund' => null,
        'is_cancellation' => null,
        'refunded_item' => null,
        'validation_error' => null,
        'error' => null,
        'errors' => null,
        'actioned' => null,
        'actioned_date' => 'date-time',
        'channel_initiated' => null,
        'internal' => null,
        'deleted' => null,
        'external_reference' => null,
        'is_free_text' => null,
        'free_text_or_note' => null,
        'amount' => 'double',
        'quantity' => 'int32',
        'reason_tag' => null,
        'sub_reason_tag' => null,
        'insufficient_refund_tag' => null,
        'insufficient_refund_note' => null,
        'reason_category' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'refund_row_id' => false,
        'refund_header_id' => false,
        'status' => false,
        'refunded_unit' => false,
        'is_shipping_refund' => false,
        'is_additional_refund' => false,
        'is_cancellation' => false,
        'refunded_item' => false,
        'validation_error' => false,
        'error' => false,
        'errors' => false,
        'actioned' => false,
        'actioned_date' => false,
        'channel_initiated' => false,
        'internal' => false,
        'deleted' => false,
        'external_reference' => false,
        'is_free_text' => false,
        'free_text_or_note' => false,
        'amount' => false,
        'quantity' => false,
        'reason_tag' => false,
        'sub_reason_tag' => false,
        'insufficient_refund_tag' => false,
        'insufficient_refund_note' => false,
        'reason_category' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'refund_row_id' => 'RefundRowId',
        'refund_header_id' => 'RefundHeaderId',
        'status' => 'Status',
        'refunded_unit' => 'RefundedUnit',
        'is_shipping_refund' => 'IsShippingRefund',
        'is_additional_refund' => 'IsAdditionalRefund',
        'is_cancellation' => 'IsCancellation',
        'refunded_item' => 'RefundedItem',
        'validation_error' => 'ValidationError',
        'error' => 'Error',
        'errors' => 'Errors',
        'actioned' => 'Actioned',
        'actioned_date' => 'ActionedDate',
        'channel_initiated' => 'ChannelInitiated',
        'internal' => 'Internal',
        'deleted' => 'Deleted',
        'external_reference' => 'ExternalReference',
        'is_free_text' => 'IsFreeText',
        'free_text_or_note' => 'FreeTextOrNote',
        'amount' => 'Amount',
        'quantity' => 'Quantity',
        'reason_tag' => 'ReasonTag',
        'sub_reason_tag' => 'SubReasonTag',
        'insufficient_refund_tag' => 'InsufficientRefundTag',
        'insufficient_refund_note' => 'InsufficientRefundNote',
        'reason_category' => 'ReasonCategory'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'refund_row_id' => 'setRefundRowId',
        'refund_header_id' => 'setRefundHeaderId',
        'status' => 'setStatus',
        'refunded_unit' => 'setRefundedUnit',
        'is_shipping_refund' => 'setIsShippingRefund',
        'is_additional_refund' => 'setIsAdditionalRefund',
        'is_cancellation' => 'setIsCancellation',
        'refunded_item' => 'setRefundedItem',
        'validation_error' => 'setValidationError',
        'error' => 'setError',
        'errors' => 'setErrors',
        'actioned' => 'setActioned',
        'actioned_date' => 'setActionedDate',
        'channel_initiated' => 'setChannelInitiated',
        'internal' => 'setInternal',
        'deleted' => 'setDeleted',
        'external_reference' => 'setExternalReference',
        'is_free_text' => 'setIsFreeText',
        'free_text_or_note' => 'setFreeTextOrNote',
        'amount' => 'setAmount',
        'quantity' => 'setQuantity',
        'reason_tag' => 'setReasonTag',
        'sub_reason_tag' => 'setSubReasonTag',
        'insufficient_refund_tag' => 'setInsufficientRefundTag',
        'insufficient_refund_note' => 'setInsufficientRefundNote',
        'reason_category' => 'setReasonCategory'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'refund_row_id' => 'getRefundRowId',
        'refund_header_id' => 'getRefundHeaderId',
        'status' => 'getStatus',
        'refunded_unit' => 'getRefundedUnit',
        'is_shipping_refund' => 'getIsShippingRefund',
        'is_additional_refund' => 'getIsAdditionalRefund',
        'is_cancellation' => 'getIsCancellation',
        'refunded_item' => 'getRefundedItem',
        'validation_error' => 'getValidationError',
        'error' => 'getError',
        'errors' => 'getErrors',
        'actioned' => 'getActioned',
        'actioned_date' => 'getActionedDate',
        'channel_initiated' => 'getChannelInitiated',
        'internal' => 'getInternal',
        'deleted' => 'getDeleted',
        'external_reference' => 'getExternalReference',
        'is_free_text' => 'getIsFreeText',
        'free_text_or_note' => 'getFreeTextOrNote',
        'amount' => 'getAmount',
        'quantity' => 'getQuantity',
        'reason_tag' => 'getReasonTag',
        'sub_reason_tag' => 'getSubReasonTag',
        'insufficient_refund_tag' => 'getInsufficientRefundTag',
        'insufficient_refund_note' => 'getInsufficientRefundNote',
        'reason_category' => 'getReasonCategory'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const REFUNDED_UNIT_ITEM = 'Item';
    public const REFUNDED_UNIT_SHIPPING = 'Shipping';
    public const REFUNDED_UNIT_SERVICE = 'Service';
    public const REFUNDED_UNIT_ADDITIONAL = 'Additional';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRefundedUnitAllowableValues()
    {
        return [
            self::REFUNDED_UNIT_ITEM,
            self::REFUNDED_UNIT_SHIPPING,
            self::REFUNDED_UNIT_SERVICE,
            self::REFUNDED_UNIT_ADDITIONAL,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('refund_row_id', $data ?? [], null);
        $this->setIfExists('refund_header_id', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('refunded_unit', $data ?? [], null);
        $this->setIfExists('is_shipping_refund', $data ?? [], null);
        $this->setIfExists('is_additional_refund', $data ?? [], null);
        $this->setIfExists('is_cancellation', $data ?? [], null);
        $this->setIfExists('refunded_item', $data ?? [], null);
        $this->setIfExists('validation_error', $data ?? [], null);
        $this->setIfExists('error', $data ?? [], null);
        $this->setIfExists('errors', $data ?? [], null);
        $this->setIfExists('actioned', $data ?? [], null);
        $this->setIfExists('actioned_date', $data ?? [], null);
        $this->setIfExists('channel_initiated', $data ?? [], null);
        $this->setIfExists('internal', $data ?? [], null);
        $this->setIfExists('deleted', $data ?? [], null);
        $this->setIfExists('external_reference', $data ?? [], null);
        $this->setIfExists('is_free_text', $data ?? [], null);
        $this->setIfExists('free_text_or_note', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('reason_tag', $data ?? [], null);
        $this->setIfExists('sub_reason_tag', $data ?? [], null);
        $this->setIfExists('insufficient_refund_tag', $data ?? [], null);
        $this->setIfExists('insufficient_refund_note', $data ?? [], null);
        $this->setIfExists('reason_category', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getRefundedUnitAllowableValues();
        if (!is_null($this->container['refunded_unit']) && !in_array($this->container['refunded_unit'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'refunded_unit', must be one of '%s'",
                $this->container['refunded_unit'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets refund_row_id
     *
     * @return string|null
     */
    public function getRefundRowId()
    {
        return $this->container['refund_row_id'];
    }

    /**
     * Sets refund_row_id
     *
     * @param string|null $refund_row_id A unique identifier for the refund line
     *
     * @return self
     */
    public function setRefundRowId($refund_row_id)
    {
        if (is_null($refund_row_id)) {
            throw new \InvalidArgumentException('non-nullable refund_row_id cannot be null');
        }
        $this->container['refund_row_id'] = $refund_row_id;

        return $this;
    }

    /**
     * Gets refund_header_id
     *
     * @return int|null
     */
    public function getRefundHeaderId()
    {
        return $this->container['refund_header_id'];
    }

    /**
     * Sets refund_header_id
     *
     * @param int|null $refund_header_id A unique identifier for the refund header this line belongs to
     *
     * @return self
     */
    public function setRefundHeaderId($refund_header_id)
    {
        if (is_null($refund_header_id)) {
            throw new \InvalidArgumentException('non-nullable refund_header_id cannot be null');
        }
        $this->container['refund_header_id'] = $refund_header_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \Linnworks\ReturnsRefunds\Model\PostSaleStatus|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \Linnworks\ReturnsRefunds\Model\PostSaleStatus|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets refunded_unit
     *
     * @return string|null
     */
    public function getRefundedUnit()
    {
        return $this->container['refunded_unit'];
    }

    /**
     * Sets refunded_unit
     *
     * @param string|null $refunded_unit Identifies the type of refund for this line
     *
     * @return self
     */
    public function setRefundedUnit($refunded_unit)
    {
        if (is_null($refunded_unit)) {
            throw new \InvalidArgumentException('non-nullable refunded_unit cannot be null');
        }
        $allowedValues = $this->getRefundedUnitAllowableValues();
        if (!in_array($refunded_unit, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'refunded_unit', must be one of '%s'",
                    $refunded_unit,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['refunded_unit'] = $refunded_unit;

        return $this;
    }

    /**
     * Gets is_shipping_refund
     *
     * @return bool|null
     */
    public function getIsShippingRefund()
    {
        return $this->container['is_shipping_refund'];
    }

    /**
     * Sets is_shipping_refund
     *
     * @param bool|null $is_shipping_refund Identifies whether the refund is a shipping refund
     *
     * @return self
     */
    public function setIsShippingRefund($is_shipping_refund)
    {
        if (is_null($is_shipping_refund)) {
            throw new \InvalidArgumentException('non-nullable is_shipping_refund cannot be null');
        }
        $this->container['is_shipping_refund'] = $is_shipping_refund;

        return $this;
    }

    /**
     * Gets is_additional_refund
     *
     * @return bool|null
     */
    public function getIsAdditionalRefund()
    {
        return $this->container['is_additional_refund'];
    }

    /**
     * Sets is_additional_refund
     *
     * @param bool|null $is_additional_refund Identifies whether the refund is an additional refund
     *
     * @return self
     */
    public function setIsAdditionalRefund($is_additional_refund)
    {
        if (is_null($is_additional_refund)) {
            throw new \InvalidArgumentException('non-nullable is_additional_refund cannot be null');
        }
        $this->container['is_additional_refund'] = $is_additional_refund;

        return $this;
    }

    /**
     * Gets is_cancellation
     *
     * @return bool|null
     */
    public function getIsCancellation()
    {
        return $this->container['is_cancellation'];
    }

    /**
     * Sets is_cancellation
     *
     * @param bool|null $is_cancellation Identifies whether the refund row is a cancellation
     *
     * @return self
     */
    public function setIsCancellation($is_cancellation)
    {
        if (is_null($is_cancellation)) {
            throw new \InvalidArgumentException('non-nullable is_cancellation cannot be null');
        }
        $this->container['is_cancellation'] = $is_cancellation;

        return $this;
    }

    /**
     * Gets refunded_item
     *
     * @return \Linnworks\ReturnsRefunds\Model\VerifiedRefundItem|null
     */
    public function getRefundedItem()
    {
        return $this->container['refunded_item'];
    }

    /**
     * Sets refunded_item
     *
     * @param \Linnworks\ReturnsRefunds\Model\VerifiedRefundItem|null $refunded_item refunded_item
     *
     * @return self
     */
    public function setRefundedItem($refunded_item)
    {
        if (is_null($refunded_item)) {
            throw new \InvalidArgumentException('non-nullable refunded_item cannot be null');
        }
        $this->container['refunded_item'] = $refunded_item;

        return $this;
    }

    /**
     * Gets validation_error
     *
     * @return string|null
     */
    public function getValidationError()
    {
        return $this->container['validation_error'];
    }

    /**
     * Sets validation_error
     *
     * @param string|null $validation_error If validation has failed for this item, the field will be populated with the appropriate error message
     *
     * @return self
     */
    public function setValidationError($validation_error)
    {
        if (is_null($validation_error)) {
            throw new \InvalidArgumentException('non-nullable validation_error cannot be null');
        }
        $this->container['validation_error'] = $validation_error;

        return $this;
    }

    /**
     * Gets error
     *
     * @return string|null
     */
    public function getError()
    {
        return $this->container['error'];
    }

    /**
     * Sets error
     *
     * @param string|null $error error
     *
     * @return self
     */
    public function setError($error)
    {
        if (is_null($error)) {
            throw new \InvalidArgumentException('non-nullable error cannot be null');
        }
        $this->container['error'] = $error;

        return $this;
    }

    /**
     * Gets errors
     *
     * @return \Linnworks\ReturnsRefunds\Model\RefundError[]|null
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     *
     * @param \Linnworks\ReturnsRefunds\Model\RefundError[]|null $errors errors
     *
     * @return self
     */
    public function setErrors($errors)
    {
        if (is_null($errors)) {
            throw new \InvalidArgumentException('non-nullable errors cannot be null');
        }
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets actioned
     *
     * @return bool|null
     */
    public function getActioned()
    {
        return $this->container['actioned'];
    }

    /**
     * Sets actioned
     *
     * @param bool|null $actioned Line-level indicator of whether the refund has been actioned
     *
     * @return self
     */
    public function setActioned($actioned)
    {
        if (is_null($actioned)) {
            throw new \InvalidArgumentException('non-nullable actioned cannot be null');
        }
        $this->container['actioned'] = $actioned;

        return $this;
    }

    /**
     * Gets actioned_date
     *
     * @return \DateTime|null
     */
    public function getActionedDate()
    {
        return $this->container['actioned_date'];
    }

    /**
     * Sets actioned_date
     *
     * @param \DateTime|null $actioned_date If a refund has been actioned, this denotes the date it was actioned. For not actioned lines, this value is null
     *
     * @return self
     */
    public function setActionedDate($actioned_date)
    {
        if (is_null($actioned_date)) {
            throw new \InvalidArgumentException('non-nullable actioned_date cannot be null');
        }
        $this->container['actioned_date'] = $actioned_date;

        return $this;
    }

    /**
     * Gets channel_initiated
     *
     * @return bool|null
     */
    public function getChannelInitiated()
    {
        return $this->container['channel_initiated'];
    }

    /**
     * Sets channel_initiated
     *
     * @param bool|null $channel_initiated Identifies whether the refund was created manually in Linnworks, or downloaded from the channel automatically
     *
     * @return self
     */
    public function setChannelInitiated($channel_initiated)
    {
        if (is_null($channel_initiated)) {
            throw new \InvalidArgumentException('non-nullable channel_initiated cannot be null');
        }
        $this->container['channel_initiated'] = $channel_initiated;

        return $this;
    }

    /**
     * Gets internal
     *
     * @return bool|null
     */
    public function getInternal()
    {
        return $this->container['internal'];
    }

    /**
     * Sets internal
     *
     * @param bool|null $internal Identifies whether the line is processed only internally or also on a third-party channel
     *
     * @return self
     */
    public function setInternal($internal)
    {
        if (is_null($internal)) {
            throw new \InvalidArgumentException('non-nullable internal cannot be null');
        }
        $this->container['internal'] = $internal;

        return $this;
    }

    /**
     * Gets deleted
     *
     * @return bool|null
     */
    public function getDeleted()
    {
        return $this->container['deleted'];
    }

    /**
     * Sets deleted
     *
     * @param bool|null $deleted Identifies whether the line has been removed from the refund, and is pending an update to the database to reflect this
     *
     * @return self
     */
    public function setDeleted($deleted)
    {
        if (is_null($deleted)) {
            throw new \InvalidArgumentException('non-nullable deleted cannot be null');
        }
        $this->container['deleted'] = $deleted;

        return $this;
    }

    /**
     * Gets external_reference
     *
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->container['external_reference'];
    }

    /**
     * Sets external_reference
     *
     * @param string|null $external_reference The channel reference number for this refund
     *
     * @return self
     */
    public function setExternalReference($external_reference)
    {
        if (is_null($external_reference)) {
            throw new \InvalidArgumentException('non-nullable external_reference cannot be null');
        }
        $this->container['external_reference'] = $external_reference;

        return $this;
    }

    /**
     * Gets is_free_text
     *
     * @return bool|null
     */
    public function getIsFreeText()
    {
        return $this->container['is_free_text'];
    }

    /**
     * Sets is_free_text
     *
     * @param bool|null $is_free_text Identifies whether the refund reason is provided in freetext, or as one of a predefined set of options
     *
     * @return self
     */
    public function setIsFreeText($is_free_text)
    {
        if (is_null($is_free_text)) {
            throw new \InvalidArgumentException('non-nullable is_free_text cannot be null');
        }
        $this->container['is_free_text'] = $is_free_text;

        return $this;
    }

    /**
     * Gets free_text_or_note
     *
     * @return string|null
     */
    public function getFreeTextOrNote()
    {
        return $this->container['free_text_or_note'];
    }

    /**
     * Sets free_text_or_note
     *
     * @param string|null $free_text_or_note For freetext refund reasons, this is the reason that will be sent to the channel. Otherwise, it is considered an internal note
     *
     * @return self
     */
    public function setFreeTextOrNote($free_text_or_note)
    {
        if (is_null($free_text_or_note)) {
            throw new \InvalidArgumentException('non-nullable free_text_or_note cannot be null');
        }
        $this->container['free_text_or_note'] = $free_text_or_note;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float|null $amount The amount to be refunded for this line
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Used when the refund is part of a return
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets reason_tag
     *
     * @return string|null
     */
    public function getReasonTag()
    {
        return $this->container['reason_tag'];
    }

    /**
     * Sets reason_tag
     *
     * @param string|null $reason_tag For channels that support predefined refund reasons, this is the tag that identifies a predefined reason
     *
     * @return self
     */
    public function setReasonTag($reason_tag)
    {
        if (is_null($reason_tag)) {
            throw new \InvalidArgumentException('non-nullable reason_tag cannot be null');
        }
        $this->container['reason_tag'] = $reason_tag;

        return $this;
    }

    /**
     * Gets sub_reason_tag
     *
     * @return string|null
     */
    public function getSubReasonTag()
    {
        return $this->container['sub_reason_tag'];
    }

    /**
     * Sets sub_reason_tag
     *
     * @param string|null $sub_reason_tag For channels that support a secondary predefined refund reason, this is the tag that identifies a predefined secondary reason
     *
     * @return self
     */
    public function setSubReasonTag($sub_reason_tag)
    {
        if (is_null($sub_reason_tag)) {
            throw new \InvalidArgumentException('non-nullable sub_reason_tag cannot be null');
        }
        $this->container['sub_reason_tag'] = $sub_reason_tag;

        return $this;
    }

    /**
     * Gets insufficient_refund_tag
     *
     * @return string|null
     */
    public function getInsufficientRefundTag()
    {
        return $this->container['insufficient_refund_tag'];
    }

    /**
     * Sets insufficient_refund_tag
     *
     * @param string|null $insufficient_refund_tag For channels that require a reason when the refund is lower than the full line amount, this is the tag that identifies a predefined insufficient refund reason
     *
     * @return self
     */
    public function setInsufficientRefundTag($insufficient_refund_tag)
    {
        if (is_null($insufficient_refund_tag)) {
            throw new \InvalidArgumentException('non-nullable insufficient_refund_tag cannot be null');
        }
        $this->container['insufficient_refund_tag'] = $insufficient_refund_tag;

        return $this;
    }

    /**
     * Gets insufficient_refund_note
     *
     * @return string|null
     */
    public function getInsufficientRefundNote()
    {
        return $this->container['insufficient_refund_note'];
    }

    /**
     * Sets insufficient_refund_note
     *
     * @param string|null $insufficient_refund_note For channels that require a reason when the refund is lower than the full line amount, and support a freetext note, this field populates that note
     *
     * @return self
     */
    public function setInsufficientRefundNote($insufficient_refund_note)
    {
        if (is_null($insufficient_refund_note)) {
            throw new \InvalidArgumentException('non-nullable insufficient_refund_note cannot be null');
        }
        $this->container['insufficient_refund_note'] = $insufficient_refund_note;

        return $this;
    }

    /**
     * Gets reason_category
     *
     * @return string|null
     */
    public function getReasonCategory()
    {
        return $this->container['reason_category'];
    }

    /**
     * Sets reason_category
     *
     * @param string|null $reason_category Internal reason category
     *
     * @return self
     */
    public function setReasonCategory($reason_category)
    {
        if (is_null($reason_category)) {
            throw new \InvalidArgumentException('non-nullable reason_category cannot be null');
        }
        $this->container['reason_category'] = $reason_category;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


