<?php
/**
 * UpdatedResendItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * UpdatedResendItem Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdatedResendItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdatedResendItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'rma_row_id' => 'int',
        'remove_from_booking' => 'bool',
        'resend_quantity' => 'int',
        'despatch_location_id' => 'string',
        'additional_cost' => 'float',
        'order_item_row_id' => 'string',
        'return_item_sku' => 'string',
        'return_item_title' => 'string',
        'batch_inventory_id' => 'int',
        'return_location' => 'string',
        'return_quantity' => 'int',
        'refund_amount' => 'float',
        'refund_row_id' => 'string',
        'scrap_quantity' => 'int',
        'reason_category' => 'string',
        'is_free_text' => 'bool',
        'reason' => 'string',
        'reason_tag' => 'string',
        'sub_reason_tag' => 'string',
        'status' => '\Linnworks\ReturnsRefunds\Model\PostSaleStatus',
        'binrack_override' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'rma_row_id' => 'int32',
        'remove_from_booking' => null,
        'resend_quantity' => 'int32',
        'despatch_location_id' => 'uuid',
        'additional_cost' => 'double',
        'order_item_row_id' => 'uuid',
        'return_item_sku' => null,
        'return_item_title' => null,
        'batch_inventory_id' => 'int32',
        'return_location' => 'uuid',
        'return_quantity' => 'int32',
        'refund_amount' => 'double',
        'refund_row_id' => 'uuid',
        'scrap_quantity' => 'int32',
        'reason_category' => null,
        'is_free_text' => null,
        'reason' => null,
        'reason_tag' => null,
        'sub_reason_tag' => null,
        'status' => null,
        'binrack_override' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'rma_row_id' => false,
        'remove_from_booking' => false,
        'resend_quantity' => false,
        'despatch_location_id' => false,
        'additional_cost' => false,
        'order_item_row_id' => false,
        'return_item_sku' => false,
        'return_item_title' => false,
        'batch_inventory_id' => false,
        'return_location' => false,
        'return_quantity' => false,
        'refund_amount' => false,
        'refund_row_id' => false,
        'scrap_quantity' => false,
        'reason_category' => false,
        'is_free_text' => false,
        'reason' => false,
        'reason_tag' => false,
        'sub_reason_tag' => false,
        'status' => false,
        'binrack_override' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'rma_row_id' => 'RMARowId',
        'remove_from_booking' => 'RemoveFromBooking',
        'resend_quantity' => 'ResendQuantity',
        'despatch_location_id' => 'DespatchLocationId',
        'additional_cost' => 'AdditionalCost',
        'order_item_row_id' => 'OrderItemRowId',
        'return_item_sku' => 'ReturnItemSKU',
        'return_item_title' => 'ReturnItemTitle',
        'batch_inventory_id' => 'BatchInventoryId',
        'return_location' => 'ReturnLocation',
        'return_quantity' => 'ReturnQuantity',
        'refund_amount' => 'RefundAmount',
        'refund_row_id' => 'RefundRowId',
        'scrap_quantity' => 'ScrapQuantity',
        'reason_category' => 'ReasonCategory',
        'is_free_text' => 'IsFreeText',
        'reason' => 'Reason',
        'reason_tag' => 'ReasonTag',
        'sub_reason_tag' => 'SubReasonTag',
        'status' => 'Status',
        'binrack_override' => 'BinrackOverride'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'rma_row_id' => 'setRmaRowId',
        'remove_from_booking' => 'setRemoveFromBooking',
        'resend_quantity' => 'setResendQuantity',
        'despatch_location_id' => 'setDespatchLocationId',
        'additional_cost' => 'setAdditionalCost',
        'order_item_row_id' => 'setOrderItemRowId',
        'return_item_sku' => 'setReturnItemSku',
        'return_item_title' => 'setReturnItemTitle',
        'batch_inventory_id' => 'setBatchInventoryId',
        'return_location' => 'setReturnLocation',
        'return_quantity' => 'setReturnQuantity',
        'refund_amount' => 'setRefundAmount',
        'refund_row_id' => 'setRefundRowId',
        'scrap_quantity' => 'setScrapQuantity',
        'reason_category' => 'setReasonCategory',
        'is_free_text' => 'setIsFreeText',
        'reason' => 'setReason',
        'reason_tag' => 'setReasonTag',
        'sub_reason_tag' => 'setSubReasonTag',
        'status' => 'setStatus',
        'binrack_override' => 'setBinrackOverride'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'rma_row_id' => 'getRmaRowId',
        'remove_from_booking' => 'getRemoveFromBooking',
        'resend_quantity' => 'getResendQuantity',
        'despatch_location_id' => 'getDespatchLocationId',
        'additional_cost' => 'getAdditionalCost',
        'order_item_row_id' => 'getOrderItemRowId',
        'return_item_sku' => 'getReturnItemSku',
        'return_item_title' => 'getReturnItemTitle',
        'batch_inventory_id' => 'getBatchInventoryId',
        'return_location' => 'getReturnLocation',
        'return_quantity' => 'getReturnQuantity',
        'refund_amount' => 'getRefundAmount',
        'refund_row_id' => 'getRefundRowId',
        'scrap_quantity' => 'getScrapQuantity',
        'reason_category' => 'getReasonCategory',
        'is_free_text' => 'getIsFreeText',
        'reason' => 'getReason',
        'reason_tag' => 'getReasonTag',
        'sub_reason_tag' => 'getSubReasonTag',
        'status' => 'getStatus',
        'binrack_override' => 'getBinrackOverride'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('rma_row_id', $data ?? [], null);
        $this->setIfExists('remove_from_booking', $data ?? [], null);
        $this->setIfExists('resend_quantity', $data ?? [], null);
        $this->setIfExists('despatch_location_id', $data ?? [], null);
        $this->setIfExists('additional_cost', $data ?? [], null);
        $this->setIfExists('order_item_row_id', $data ?? [], null);
        $this->setIfExists('return_item_sku', $data ?? [], null);
        $this->setIfExists('return_item_title', $data ?? [], null);
        $this->setIfExists('batch_inventory_id', $data ?? [], null);
        $this->setIfExists('return_location', $data ?? [], null);
        $this->setIfExists('return_quantity', $data ?? [], null);
        $this->setIfExists('refund_amount', $data ?? [], null);
        $this->setIfExists('refund_row_id', $data ?? [], null);
        $this->setIfExists('scrap_quantity', $data ?? [], null);
        $this->setIfExists('reason_category', $data ?? [], null);
        $this->setIfExists('is_free_text', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('reason_tag', $data ?? [], null);
        $this->setIfExists('sub_reason_tag', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('binrack_override', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets rma_row_id
     *
     * @return int|null
     */
    public function getRmaRowId()
    {
        return $this->container['rma_row_id'];
    }

    /**
     * Sets rma_row_id
     *
     * @param int|null $rma_row_id The RMA row identifier for this line
     *
     * @return self
     */
    public function setRmaRowId($rma_row_id)
    {
        if (is_null($rma_row_id)) {
            throw new \InvalidArgumentException('non-nullable rma_row_id cannot be null');
        }
        $this->container['rma_row_id'] = $rma_row_id;

        return $this;
    }

    /**
     * Gets remove_from_booking
     *
     * @return bool|null
     */
    public function getRemoveFromBooking()
    {
        return $this->container['remove_from_booking'];
    }

    /**
     * Sets remove_from_booking
     *
     * @param bool|null $remove_from_booking If set to true, will remove the line from the booking
     *
     * @return self
     */
    public function setRemoveFromBooking($remove_from_booking)
    {
        if (is_null($remove_from_booking)) {
            throw new \InvalidArgumentException('non-nullable remove_from_booking cannot be null');
        }
        $this->container['remove_from_booking'] = $remove_from_booking;

        return $this;
    }

    /**
     * Gets resend_quantity
     *
     * @return int|null
     */
    public function getResendQuantity()
    {
        return $this->container['resend_quantity'];
    }

    /**
     * Sets resend_quantity
     *
     * @param int|null $resend_quantity The quantity of the selected item to resend
     *
     * @return self
     */
    public function setResendQuantity($resend_quantity)
    {
        if (is_null($resend_quantity)) {
            throw new \InvalidArgumentException('non-nullable resend_quantity cannot be null');
        }
        $this->container['resend_quantity'] = $resend_quantity;

        return $this;
    }

    /**
     * Gets despatch_location_id
     *
     * @return string|null
     */
    public function getDespatchLocationId()
    {
        return $this->container['despatch_location_id'];
    }

    /**
     * Sets despatch_location_id
     *
     * @param string|null $despatch_location_id The identifier for the location to create the resend order in. This is where the item will have its stock deducted from
     *
     * @return self
     */
    public function setDespatchLocationId($despatch_location_id)
    {
        if (is_null($despatch_location_id)) {
            throw new \InvalidArgumentException('non-nullable despatch_location_id cannot be null');
        }
        $this->container['despatch_location_id'] = $despatch_location_id;

        return $this;
    }

    /**
     * Gets additional_cost
     *
     * @return float|null
     */
    public function getAdditionalCost()
    {
        return $this->container['additional_cost'];
    }

    /**
     * Sets additional_cost
     *
     * @param float|null $additional_cost This field denotes the additional cost that will be incurred to the customer for this resend
     *
     * @return self
     */
    public function setAdditionalCost($additional_cost)
    {
        if (is_null($additional_cost)) {
            throw new \InvalidArgumentException('non-nullable additional_cost cannot be null');
        }
        $this->container['additional_cost'] = $additional_cost;

        return $this;
    }

    /**
     * Gets order_item_row_id
     *
     * @return string|null
     */
    public function getOrderItemRowId()
    {
        return $this->container['order_item_row_id'];
    }

    /**
     * Sets order_item_row_id
     *
     * @param string|null $order_item_row_id The unique ID of the order item to be returned. Note: This field is ignored when part of an Update call
     *
     * @return self
     */
    public function setOrderItemRowId($order_item_row_id)
    {
        if (is_null($order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_row_id cannot be null');
        }
        $this->container['order_item_row_id'] = $order_item_row_id;

        return $this;
    }

    /**
     * Gets return_item_sku
     *
     * @return string|null
     */
    public function getReturnItemSku()
    {
        return $this->container['return_item_sku'];
    }

    /**
     * Sets return_item_sku
     *
     * @param string|null $return_item_sku The SKU of the order item to be returned. Read-only
     *
     * @return self
     */
    public function setReturnItemSku($return_item_sku)
    {
        if (is_null($return_item_sku)) {
            throw new \InvalidArgumentException('non-nullable return_item_sku cannot be null');
        }
        $this->container['return_item_sku'] = $return_item_sku;

        return $this;
    }

    /**
     * Gets return_item_title
     *
     * @return string|null
     */
    public function getReturnItemTitle()
    {
        return $this->container['return_item_title'];
    }

    /**
     * Sets return_item_title
     *
     * @param string|null $return_item_title The title of the order item to be returned. Read-only
     *
     * @return self
     */
    public function setReturnItemTitle($return_item_title)
    {
        if (is_null($return_item_title)) {
            throw new \InvalidArgumentException('non-nullable return_item_title cannot be null');
        }
        $this->container['return_item_title'] = $return_item_title;

        return $this;
    }

    /**
     * Gets batch_inventory_id
     *
     * @return int|null
     */
    public function getBatchInventoryId()
    {
        return $this->container['batch_inventory_id'];
    }

    /**
     * Sets batch_inventory_id
     *
     * @param int|null $batch_inventory_id If the item is batched, this identifies the batch inventory row the item will be returned to
     *
     * @return self
     */
    public function setBatchInventoryId($batch_inventory_id)
    {
        if (is_null($batch_inventory_id)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory_id cannot be null');
        }
        $this->container['batch_inventory_id'] = $batch_inventory_id;

        return $this;
    }

    /**
     * Gets return_location
     *
     * @return string|null
     */
    public function getReturnLocation()
    {
        return $this->container['return_location'];
    }

    /**
     * Sets return_location
     *
     * @param string|null $return_location The unique identifier for the Linnworks location to return the item to
     *
     * @return self
     */
    public function setReturnLocation($return_location)
    {
        if (is_null($return_location)) {
            throw new \InvalidArgumentException('non-nullable return_location cannot be null');
        }
        $this->container['return_location'] = $return_location;

        return $this;
    }

    /**
     * Gets return_quantity
     *
     * @return int|null
     */
    public function getReturnQuantity()
    {
        return $this->container['return_quantity'];
    }

    /**
     * Sets return_quantity
     *
     * @param int|null $return_quantity The amount of the item to be returned
     *
     * @return self
     */
    public function setReturnQuantity($return_quantity)
    {
        if (is_null($return_quantity)) {
            throw new \InvalidArgumentException('non-nullable return_quantity cannot be null');
        }
        $this->container['return_quantity'] = $return_quantity;

        return $this;
    }

    /**
     * Gets refund_amount
     *
     * @return float|null
     */
    public function getRefundAmount()
    {
        return $this->container['refund_amount'];
    }

    /**
     * Sets refund_amount
     *
     * @param float|null $refund_amount Where applicable, the amount to refund the customer as part of this RMA
     *
     * @return self
     */
    public function setRefundAmount($refund_amount)
    {
        if (is_null($refund_amount)) {
            throw new \InvalidArgumentException('non-nullable refund_amount cannot be null');
        }
        $this->container['refund_amount'] = $refund_amount;

        return $this;
    }

    /**
     * Gets refund_row_id
     *
     * @return string|null
     */
    public function getRefundRowId()
    {
        return $this->container['refund_row_id'];
    }

    /**
     * Sets refund_row_id
     *
     * @param string|null $refund_row_id Where applicable, the row id for the created refund line associated with this RMA
     *
     * @return self
     */
    public function setRefundRowId($refund_row_id)
    {
        if (is_null($refund_row_id)) {
            throw new \InvalidArgumentException('non-nullable refund_row_id cannot be null');
        }
        $this->container['refund_row_id'] = $refund_row_id;

        return $this;
    }

    /**
     * Gets scrap_quantity
     *
     * @return int|null
     */
    public function getScrapQuantity()
    {
        return $this->container['scrap_quantity'];
    }

    /**
     * Sets scrap_quantity
     *
     * @param int|null $scrap_quantity Where applicable, the amount of returned items to be scrapped
     *
     * @return self
     */
    public function setScrapQuantity($scrap_quantity)
    {
        if (is_null($scrap_quantity)) {
            throw new \InvalidArgumentException('non-nullable scrap_quantity cannot be null');
        }
        $this->container['scrap_quantity'] = $scrap_quantity;

        return $this;
    }

    /**
     * Gets reason_category
     *
     * @return string|null
     */
    public function getReasonCategory()
    {
        return $this->container['reason_category'];
    }

    /**
     * Sets reason_category
     *
     * @param string|null $reason_category The category for the return/exchange reason (e.g. Faulty Item)
     *
     * @return self
     */
    public function setReasonCategory($reason_category)
    {
        if (is_null($reason_category)) {
            throw new \InvalidArgumentException('non-nullable reason_category cannot be null');
        }
        $this->container['reason_category'] = $reason_category;

        return $this;
    }

    /**
     * Gets is_free_text
     *
     * @return bool|null
     */
    public function getIsFreeText()
    {
        return $this->container['is_free_text'];
    }

    /**
     * Sets is_free_text
     *
     * @param bool|null $is_free_text Defines whether the channel RMA reason is being sent as freetext (where supported). Automatically set
     *
     * @return self
     */
    public function setIsFreeText($is_free_text)
    {
        if (is_null($is_free_text)) {
            throw new \InvalidArgumentException('non-nullable is_free_text cannot be null');
        }
        $this->container['is_free_text'] = $is_free_text;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason A freetext internal reason for the return/exchange
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets reason_tag
     *
     * @return string|null
     */
    public function getReasonTag()
    {
        return $this->container['reason_tag'];
    }

    /**
     * Sets reason_tag
     *
     * @param string|null $reason_tag For channels that support predefined RMA reasons, this is the tag that identifies a predefined reason
     *
     * @return self
     */
    public function setReasonTag($reason_tag)
    {
        if (is_null($reason_tag)) {
            throw new \InvalidArgumentException('non-nullable reason_tag cannot be null');
        }
        $this->container['reason_tag'] = $reason_tag;

        return $this;
    }

    /**
     * Gets sub_reason_tag
     *
     * @return string|null
     */
    public function getSubReasonTag()
    {
        return $this->container['sub_reason_tag'];
    }

    /**
     * Sets sub_reason_tag
     *
     * @param string|null $sub_reason_tag For channels that support a secondary predefined RMA reason, this is the tag that identifies a predefined secondary reason
     *
     * @return self
     */
    public function setSubReasonTag($sub_reason_tag)
    {
        if (is_null($sub_reason_tag)) {
            throw new \InvalidArgumentException('non-nullable sub_reason_tag cannot be null');
        }
        $this->container['sub_reason_tag'] = $sub_reason_tag;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \Linnworks\ReturnsRefunds\Model\PostSaleStatus|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \Linnworks\ReturnsRefunds\Model\PostSaleStatus|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets binrack_override
     *
     * @return string|null
     */
    public function getBinrackOverride()
    {
        return $this->container['binrack_override'];
    }

    /**
     * Sets binrack_override
     *
     * @param string|null $binrack_override Used specifically with batch composite parents, this will ensure that all children are returned to the binrack of choice (acts the same as batchinventoryid for single items)
     *
     * @return self
     */
    public function setBinrackOverride($binrack_override)
    {
        if (is_null($binrack_override)) {
            throw new \InvalidArgumentException('non-nullable binrack_override cannot be null');
        }
        $this->container['binrack_override'] = $binrack_override;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


