<?php
/**
 * UpdateRMABookingRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * UpdateRMABookingRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateRMABookingRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'UpdateRMABookingRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_id' => 'string',
        'rma_header_id' => 'int',
        'return_items' => '\Linnworks\ReturnsRefunds\Model\UpdatedReturnItem[]',
        'exchange_items' => '\Linnworks\ReturnsRefunds\Model\UpdatedExchangeItem[]',
        'resend_items' => '\Linnworks\ReturnsRefunds\Model\UpdatedResendItem[]',
        'allow_creation_of_new_order' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_id' => 'uuid',
        'rma_header_id' => 'int32',
        'return_items' => null,
        'exchange_items' => null,
        'resend_items' => null,
        'allow_creation_of_new_order' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_id' => false,
        'rma_header_id' => false,
        'return_items' => false,
        'exchange_items' => false,
        'resend_items' => false,
        'allow_creation_of_new_order' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_id' => 'OrderId',
        'rma_header_id' => 'RMAHeaderId',
        'return_items' => 'ReturnItems',
        'exchange_items' => 'ExchangeItems',
        'resend_items' => 'ResendItems',
        'allow_creation_of_new_order' => 'AllowCreationOfNewOrder'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_id' => 'setOrderId',
        'rma_header_id' => 'setRmaHeaderId',
        'return_items' => 'setReturnItems',
        'exchange_items' => 'setExchangeItems',
        'resend_items' => 'setResendItems',
        'allow_creation_of_new_order' => 'setAllowCreationOfNewOrder'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_id' => 'getOrderId',
        'rma_header_id' => 'getRmaHeaderId',
        'return_items' => 'getReturnItems',
        'exchange_items' => 'getExchangeItems',
        'resend_items' => 'getResendItems',
        'allow_creation_of_new_order' => 'getAllowCreationOfNewOrder'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('rma_header_id', $data ?? [], null);
        $this->setIfExists('return_items', $data ?? [], null);
        $this->setIfExists('exchange_items', $data ?? [], null);
        $this->setIfExists('resend_items', $data ?? [], null);
        $this->setIfExists('allow_creation_of_new_order', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id The unique identifier for the order the return lines pertain to
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets rma_header_id
     *
     * @return int|null
     */
    public function getRmaHeaderId()
    {
        return $this->container['rma_header_id'];
    }

    /**
     * Sets rma_header_id
     *
     * @param int|null $rma_header_id The unique identifier for the RMA header to update
     *
     * @return self
     */
    public function setRmaHeaderId($rma_header_id)
    {
        if (is_null($rma_header_id)) {
            throw new \InvalidArgumentException('non-nullable rma_header_id cannot be null');
        }
        $this->container['rma_header_id'] = $rma_header_id;

        return $this;
    }

    /**
     * Gets return_items
     *
     * @return \Linnworks\ReturnsRefunds\Model\UpdatedReturnItem[]|null
     */
    public function getReturnItems()
    {
        return $this->container['return_items'];
    }

    /**
     * Sets return_items
     *
     * @param \Linnworks\ReturnsRefunds\Model\UpdatedReturnItem[]|null $return_items A collection of updated return items
     *
     * @return self
     */
    public function setReturnItems($return_items)
    {
        if (is_null($return_items)) {
            throw new \InvalidArgumentException('non-nullable return_items cannot be null');
        }
        $this->container['return_items'] = $return_items;

        return $this;
    }

    /**
     * Gets exchange_items
     *
     * @return \Linnworks\ReturnsRefunds\Model\UpdatedExchangeItem[]|null
     */
    public function getExchangeItems()
    {
        return $this->container['exchange_items'];
    }

    /**
     * Sets exchange_items
     *
     * @param \Linnworks\ReturnsRefunds\Model\UpdatedExchangeItem[]|null $exchange_items A collection of updated exchange items
     *
     * @return self
     */
    public function setExchangeItems($exchange_items)
    {
        if (is_null($exchange_items)) {
            throw new \InvalidArgumentException('non-nullable exchange_items cannot be null');
        }
        $this->container['exchange_items'] = $exchange_items;

        return $this;
    }

    /**
     * Gets resend_items
     *
     * @return \Linnworks\ReturnsRefunds\Model\UpdatedResendItem[]|null
     */
    public function getResendItems()
    {
        return $this->container['resend_items'];
    }

    /**
     * Sets resend_items
     *
     * @param \Linnworks\ReturnsRefunds\Model\UpdatedResendItem[]|null $resend_items A collection of updated resend items
     *
     * @return self
     */
    public function setResendItems($resend_items)
    {
        if (is_null($resend_items)) {
            throw new \InvalidArgumentException('non-nullable resend_items cannot be null');
        }
        $this->container['resend_items'] = $resend_items;

        return $this;
    }

    /**
     * Gets allow_creation_of_new_order
     *
     * @return bool|null
     */
    public function getAllowCreationOfNewOrder()
    {
        return $this->container['allow_creation_of_new_order'];
    }

    /**
     * Sets allow_creation_of_new_order
     *
     * @param bool|null $allow_creation_of_new_order If an existing RMA order has been deleted or cancelled, this flag determines whether a new one should be created, or an error should be returned
     *
     * @return self
     */
    public function setAllowCreationOfNewOrder($allow_creation_of_new_order)
    {
        if (is_null($allow_creation_of_new_order)) {
            throw new \InvalidArgumentException('non-nullable allow_creation_of_new_order cannot be null');
        }
        $this->container['allow_creation_of_new_order'] = $allow_creation_of_new_order;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


