<?php
/**
 * StockItemBoxConfiguration
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * StockItemBoxConfiguration Class Doc Comment
 *
 * @category Class
 * @description Stock item box configuration, dimennsions
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemBoxConfiguration implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemBoxConfiguration';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'box_id' => 'int',
        'stock_item_int_id' => 'int',
        'box_name' => 'string',
        'width' => 'float',
        'height' => 'float',
        'length' => 'float',
        'weight' => 'float',
        'value_percentage' => 'float',
        'barcode' => 'string',
        'packaging_type_id' => 'string',
        'logical_delete' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'box_id' => 'int32',
        'stock_item_int_id' => 'int32',
        'box_name' => null,
        'width' => 'double',
        'height' => 'double',
        'length' => 'double',
        'weight' => 'double',
        'value_percentage' => 'double',
        'barcode' => null,
        'packaging_type_id' => 'uuid',
        'logical_delete' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'box_id' => false,
        'stock_item_int_id' => false,
        'box_name' => false,
        'width' => false,
        'height' => false,
        'length' => false,
        'weight' => false,
        'value_percentage' => false,
        'barcode' => false,
        'packaging_type_id' => false,
        'logical_delete' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'box_id' => 'BoxId',
        'stock_item_int_id' => 'StockItemIntId',
        'box_name' => 'BoxName',
        'width' => 'Width',
        'height' => 'Height',
        'length' => 'Length',
        'weight' => 'Weight',
        'value_percentage' => 'ValuePercentage',
        'barcode' => 'Barcode',
        'packaging_type_id' => 'PackagingTypeId',
        'logical_delete' => 'LogicalDelete'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'box_id' => 'setBoxId',
        'stock_item_int_id' => 'setStockItemIntId',
        'box_name' => 'setBoxName',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'length' => 'setLength',
        'weight' => 'setWeight',
        'value_percentage' => 'setValuePercentage',
        'barcode' => 'setBarcode',
        'packaging_type_id' => 'setPackagingTypeId',
        'logical_delete' => 'setLogicalDelete'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'box_id' => 'getBoxId',
        'stock_item_int_id' => 'getStockItemIntId',
        'box_name' => 'getBoxName',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'length' => 'getLength',
        'weight' => 'getWeight',
        'value_percentage' => 'getValuePercentage',
        'barcode' => 'getBarcode',
        'packaging_type_id' => 'getPackagingTypeId',
        'logical_delete' => 'getLogicalDelete'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('box_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
        $this->setIfExists('box_name', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('length', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('value_percentage', $data ?? [], null);
        $this->setIfExists('barcode', $data ?? [], null);
        $this->setIfExists('packaging_type_id', $data ?? [], null);
        $this->setIfExists('logical_delete', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets box_id
     *
     * @return int|null
     */
    public function getBoxId()
    {
        return $this->container['box_id'];
    }

    /**
     * Sets box_id
     *
     * @param int|null $box_id Unique box id.
     *
     * @return self
     */
    public function setBoxId($box_id)
    {
        if (is_null($box_id)) {
            throw new \InvalidArgumentException('non-nullable box_id cannot be null');
        }
        $this->container['box_id'] = $box_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id 
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }

    /**
     * Gets box_name
     *
     * @return string|null
     */
    public function getBoxName()
    {
        return $this->container['box_name'];
    }

    /**
     * Sets box_name
     *
     * @param string|null $box_name Box name max 16 characters
     *
     * @return self
     */
    public function setBoxName($box_name)
    {
        if (is_null($box_name)) {
            throw new \InvalidArgumentException('non-nullable box_name cannot be null');
        }
        $this->container['box_name'] = $box_name;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width Width of the box
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height Height of the box
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            throw new \InvalidArgumentException('non-nullable height cannot be null');
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets length
     *
     * @return float|null
     */
    public function getLength()
    {
        return $this->container['length'];
    }

    /**
     * Sets length
     *
     * @param float|null $length Depth of the box
     *
     * @return self
     */
    public function setLength($length)
    {
        if (is_null($length)) {
            throw new \InvalidArgumentException('non-nullable length cannot be null');
        }
        $this->container['length'] = $length;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight Total weight of the box.
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets value_percentage
     *
     * @return float|null
     */
    public function getValuePercentage()
    {
        return $this->container['value_percentage'];
    }

    /**
     * Sets value_percentage
     *
     * @param float|null $value_percentage Value break down percentage
     *
     * @return self
     */
    public function setValuePercentage($value_percentage)
    {
        if (is_null($value_percentage)) {
            throw new \InvalidArgumentException('non-nullable value_percentage cannot be null');
        }
        $this->container['value_percentage'] = $value_percentage;

        return $this;
    }

    /**
     * Gets barcode
     *
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->container['barcode'];
    }

    /**
     * Sets barcode
     *
     * @param string|null $barcode Box barcode, max 64 characters.
     *
     * @return self
     */
    public function setBarcode($barcode)
    {
        if (is_null($barcode)) {
            throw new \InvalidArgumentException('non-nullable barcode cannot be null');
        }
        $this->container['barcode'] = $barcode;

        return $this;
    }

    /**
     * Gets packaging_type_id
     *
     * @return string|null
     */
    public function getPackagingTypeId()
    {
        return $this->container['packaging_type_id'];
    }

    /**
     * Sets packaging_type_id
     *
     * @param string|null $packaging_type_id Packaging type id
     *
     * @return self
     */
    public function setPackagingTypeId($packaging_type_id)
    {
        if (is_null($packaging_type_id)) {
            throw new \InvalidArgumentException('non-nullable packaging_type_id cannot be null');
        }
        $this->container['packaging_type_id'] = $packaging_type_id;

        return $this;
    }

    /**
     * Gets logical_delete
     *
     * @return bool|null
     */
    public function getLogicalDelete()
    {
        return $this->container['logical_delete'];
    }

    /**
     * Sets logical_delete
     *
     * @param bool|null $logical_delete IsDeleted flag.
     *
     * @return self
     */
    public function setLogicalDelete($logical_delete)
    {
        if (is_null($logical_delete)) {
            throw new \InvalidArgumentException('non-nullable logical_delete cannot be null');
        }
        $this->container['logical_delete'] = $logical_delete;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


