<?php
/**
 * ReturnsRefundsWeb
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * ReturnsRefundsWeb Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ReturnsRefundsWeb implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReturnsRefundsWeb';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'row' => 'int',
        'pk_order_id' => 'string',
        'c_shipping_address' => 'string',
        'd_processed_on' => '\DateTime',
        'f_postage_cost' => 'float',
        'f_total_charge' => 'float',
        'postage_cost_ex_tax' => 'float',
        'subtotal' => 'float',
        'f_tax' => 'float',
        'total_discount' => 'float',
        'country_tax_rate' => 'float',
        'n_order_id' => 'int',
        'c_currency' => 'string',
        'postal_tracking_number' => 'string',
        'c_country' => 'string',
        'source' => 'string',
        'postal_service_name' => 'string',
        'postal_service_code' => 'string',
        'vendor' => 'string',
        'reference_num' => 'string',
        'secondary_reference' => 'string',
        'external_reference' => 'string',
        'address1' => 'string',
        'address2' => 'string',
        'address3' => 'string',
        'town' => 'string',
        'region' => 'string',
        'buyer_phone_number' => 'string',
        'company' => 'string',
        'sub_source' => 'string',
        'channel_buyer_name' => 'string',
        'account_name' => 'string',
        'c_full_name' => 'string',
        'c_email_address' => 'string',
        'c_post_code' => 'string',
        'd_paid_on' => '\DateTime',
        'c_billing_address' => 'string',
        'billing_name' => 'string',
        'billing_company' => 'string',
        'billing_address1' => 'string',
        'billing_address2' => 'string',
        'billing_address3' => 'string',
        'billing_town' => 'string',
        'billing_region' => 'string',
        'billing_post_code' => 'string',
        'billing_country_name' => 'string',
        'billing_phone_number' => 'string',
        'c_item_number' => 'string',
        'c_item_name' => 'string',
        'pk_return_id' => 'int',
        'row_type' => 'string',
        'return_reference' => 'string',
        'pending_refund_amount' => 'float',
        'last_date' => '\DateTime',
        'reason' => 'string',
        'channel_reason' => 'string',
        'channel_reason_sec' => 'string',
        'category' => 'string',
        'return_qty' => 'int',
        'fk_return_location_id' => 'string',
        'scrapped' => 'bool',
        'scrap_qty' => 'int',
        'return_date' => '\DateTime',
        'location' => 'string',
        'item_number' => 'string',
        'item_title' => 'string',
        'new_qty' => 'int',
        'refund_reference' => 'string',
        'pk_refund_row_id' => 'string',
        'amount' => 'float',
        'create_date' => '\DateTime',
        'cancellation_quantity' => 'int',
        'fk_order_item_return_id' => 'string',
        'action_date' => '\DateTime',
        'refund_status' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'row' => 'int32',
        'pk_order_id' => 'uuid',
        'c_shipping_address' => null,
        'd_processed_on' => 'date-time',
        'f_postage_cost' => 'double',
        'f_total_charge' => 'double',
        'postage_cost_ex_tax' => 'double',
        'subtotal' => 'double',
        'f_tax' => 'double',
        'total_discount' => 'double',
        'country_tax_rate' => 'double',
        'n_order_id' => 'int32',
        'c_currency' => null,
        'postal_tracking_number' => null,
        'c_country' => null,
        'source' => null,
        'postal_service_name' => null,
        'postal_service_code' => null,
        'vendor' => null,
        'reference_num' => null,
        'secondary_reference' => null,
        'external_reference' => null,
        'address1' => null,
        'address2' => null,
        'address3' => null,
        'town' => null,
        'region' => null,
        'buyer_phone_number' => null,
        'company' => null,
        'sub_source' => null,
        'channel_buyer_name' => null,
        'account_name' => null,
        'c_full_name' => null,
        'c_email_address' => null,
        'c_post_code' => null,
        'd_paid_on' => 'date-time',
        'c_billing_address' => null,
        'billing_name' => null,
        'billing_company' => null,
        'billing_address1' => null,
        'billing_address2' => null,
        'billing_address3' => null,
        'billing_town' => null,
        'billing_region' => null,
        'billing_post_code' => null,
        'billing_country_name' => null,
        'billing_phone_number' => null,
        'c_item_number' => null,
        'c_item_name' => null,
        'pk_return_id' => 'int32',
        'row_type' => null,
        'return_reference' => null,
        'pending_refund_amount' => 'double',
        'last_date' => 'date-time',
        'reason' => null,
        'channel_reason' => null,
        'channel_reason_sec' => null,
        'category' => null,
        'return_qty' => 'int32',
        'fk_return_location_id' => 'uuid',
        'scrapped' => null,
        'scrap_qty' => 'int32',
        'return_date' => 'date-time',
        'location' => null,
        'item_number' => null,
        'item_title' => null,
        'new_qty' => 'int32',
        'refund_reference' => null,
        'pk_refund_row_id' => 'uuid',
        'amount' => 'double',
        'create_date' => 'date-time',
        'cancellation_quantity' => 'int32',
        'fk_order_item_return_id' => 'uuid',
        'action_date' => 'date-time',
        'refund_status' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'row' => false,
        'pk_order_id' => false,
        'c_shipping_address' => false,
        'd_processed_on' => false,
        'f_postage_cost' => false,
        'f_total_charge' => false,
        'postage_cost_ex_tax' => false,
        'subtotal' => false,
        'f_tax' => false,
        'total_discount' => false,
        'country_tax_rate' => false,
        'n_order_id' => false,
        'c_currency' => false,
        'postal_tracking_number' => false,
        'c_country' => false,
        'source' => false,
        'postal_service_name' => false,
        'postal_service_code' => false,
        'vendor' => false,
        'reference_num' => false,
        'secondary_reference' => false,
        'external_reference' => false,
        'address1' => false,
        'address2' => false,
        'address3' => false,
        'town' => false,
        'region' => false,
        'buyer_phone_number' => false,
        'company' => false,
        'sub_source' => false,
        'channel_buyer_name' => false,
        'account_name' => false,
        'c_full_name' => false,
        'c_email_address' => false,
        'c_post_code' => false,
        'd_paid_on' => false,
        'c_billing_address' => false,
        'billing_name' => false,
        'billing_company' => false,
        'billing_address1' => false,
        'billing_address2' => false,
        'billing_address3' => false,
        'billing_town' => false,
        'billing_region' => false,
        'billing_post_code' => false,
        'billing_country_name' => false,
        'billing_phone_number' => false,
        'c_item_number' => false,
        'c_item_name' => false,
        'pk_return_id' => false,
        'row_type' => false,
        'return_reference' => false,
        'pending_refund_amount' => false,
        'last_date' => false,
        'reason' => false,
        'channel_reason' => false,
        'channel_reason_sec' => false,
        'category' => false,
        'return_qty' => false,
        'fk_return_location_id' => false,
        'scrapped' => false,
        'scrap_qty' => false,
        'return_date' => false,
        'location' => false,
        'item_number' => false,
        'item_title' => false,
        'new_qty' => false,
        'refund_reference' => false,
        'pk_refund_row_id' => false,
        'amount' => false,
        'create_date' => false,
        'cancellation_quantity' => false,
        'fk_order_item_return_id' => false,
        'action_date' => false,
        'refund_status' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'row' => 'Row',
        'pk_order_id' => 'pkOrderID',
        'c_shipping_address' => 'cShippingAddress',
        'd_processed_on' => 'dProcessedOn',
        'f_postage_cost' => 'fPostageCost',
        'f_total_charge' => 'fTotalCharge',
        'postage_cost_ex_tax' => 'PostageCostExTax',
        'subtotal' => 'Subtotal',
        'f_tax' => 'fTax',
        'total_discount' => 'TotalDiscount',
        'country_tax_rate' => 'CountryTaxRate',
        'n_order_id' => 'nOrderId',
        'c_currency' => 'cCurrency',
        'postal_tracking_number' => 'PostalTrackingNumber',
        'c_country' => 'cCountry',
        'source' => 'Source',
        'postal_service_name' => 'PostalServiceName',
        'postal_service_code' => 'PostalServiceCode',
        'vendor' => 'Vendor',
        'reference_num' => 'ReferenceNum',
        'secondary_reference' => 'SecondaryReference',
        'external_reference' => 'ExternalReference',
        'address1' => 'Address1',
        'address2' => 'Address2',
        'address3' => 'Address3',
        'town' => 'Town',
        'region' => 'Region',
        'buyer_phone_number' => 'BuyerPhoneNumber',
        'company' => 'Company',
        'sub_source' => 'SubSource',
        'channel_buyer_name' => 'ChannelBuyerName',
        'account_name' => 'AccountName',
        'c_full_name' => 'cFullName',
        'c_email_address' => 'cEmailAddress',
        'c_post_code' => 'cPostCode',
        'd_paid_on' => 'dPaidOn',
        'c_billing_address' => 'cBillingAddress',
        'billing_name' => 'BillingName',
        'billing_company' => 'BillingCompany',
        'billing_address1' => 'BillingAddress1',
        'billing_address2' => 'BillingAddress2',
        'billing_address3' => 'BillingAddress3',
        'billing_town' => 'BillingTown',
        'billing_region' => 'BillingRegion',
        'billing_post_code' => 'BillingPostCode',
        'billing_country_name' => 'BillingCountryName',
        'billing_phone_number' => 'BillingPhoneNumber',
        'c_item_number' => 'cItemNumber',
        'c_item_name' => 'cItemName',
        'pk_return_id' => 'pkReturnId',
        'row_type' => 'RowType',
        'return_reference' => 'ReturnReference',
        'pending_refund_amount' => 'PendingRefundAmount',
        'last_date' => 'LastDate',
        'reason' => 'Reason',
        'channel_reason' => 'ChannelReason',
        'channel_reason_sec' => 'ChannelReasonSec',
        'category' => 'Category',
        'return_qty' => 'ReturnQty',
        'fk_return_location_id' => 'fkReturnLocationId',
        'scrapped' => 'Scrapped',
        'scrap_qty' => 'ScrapQty',
        'return_date' => 'ReturnDate',
        'location' => 'Location',
        'item_number' => 'ItemNumber',
        'item_title' => 'ItemTitle',
        'new_qty' => 'NewQty',
        'refund_reference' => 'RefundReference',
        'pk_refund_row_id' => 'pkRefundRowId',
        'amount' => 'Amount',
        'create_date' => 'CreateDate',
        'cancellation_quantity' => 'CancellationQuantity',
        'fk_order_item_return_id' => 'fkOrderItemReturnId',
        'action_date' => 'ActionDate',
        'refund_status' => 'RefundStatus'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'row' => 'setRow',
        'pk_order_id' => 'setPkOrderId',
        'c_shipping_address' => 'setCShippingAddress',
        'd_processed_on' => 'setDProcessedOn',
        'f_postage_cost' => 'setFPostageCost',
        'f_total_charge' => 'setFTotalCharge',
        'postage_cost_ex_tax' => 'setPostageCostExTax',
        'subtotal' => 'setSubtotal',
        'f_tax' => 'setFTax',
        'total_discount' => 'setTotalDiscount',
        'country_tax_rate' => 'setCountryTaxRate',
        'n_order_id' => 'setNOrderId',
        'c_currency' => 'setCCurrency',
        'postal_tracking_number' => 'setPostalTrackingNumber',
        'c_country' => 'setCCountry',
        'source' => 'setSource',
        'postal_service_name' => 'setPostalServiceName',
        'postal_service_code' => 'setPostalServiceCode',
        'vendor' => 'setVendor',
        'reference_num' => 'setReferenceNum',
        'secondary_reference' => 'setSecondaryReference',
        'external_reference' => 'setExternalReference',
        'address1' => 'setAddress1',
        'address2' => 'setAddress2',
        'address3' => 'setAddress3',
        'town' => 'setTown',
        'region' => 'setRegion',
        'buyer_phone_number' => 'setBuyerPhoneNumber',
        'company' => 'setCompany',
        'sub_source' => 'setSubSource',
        'channel_buyer_name' => 'setChannelBuyerName',
        'account_name' => 'setAccountName',
        'c_full_name' => 'setCFullName',
        'c_email_address' => 'setCEmailAddress',
        'c_post_code' => 'setCPostCode',
        'd_paid_on' => 'setDPaidOn',
        'c_billing_address' => 'setCBillingAddress',
        'billing_name' => 'setBillingName',
        'billing_company' => 'setBillingCompany',
        'billing_address1' => 'setBillingAddress1',
        'billing_address2' => 'setBillingAddress2',
        'billing_address3' => 'setBillingAddress3',
        'billing_town' => 'setBillingTown',
        'billing_region' => 'setBillingRegion',
        'billing_post_code' => 'setBillingPostCode',
        'billing_country_name' => 'setBillingCountryName',
        'billing_phone_number' => 'setBillingPhoneNumber',
        'c_item_number' => 'setCItemNumber',
        'c_item_name' => 'setCItemName',
        'pk_return_id' => 'setPkReturnId',
        'row_type' => 'setRowType',
        'return_reference' => 'setReturnReference',
        'pending_refund_amount' => 'setPendingRefundAmount',
        'last_date' => 'setLastDate',
        'reason' => 'setReason',
        'channel_reason' => 'setChannelReason',
        'channel_reason_sec' => 'setChannelReasonSec',
        'category' => 'setCategory',
        'return_qty' => 'setReturnQty',
        'fk_return_location_id' => 'setFkReturnLocationId',
        'scrapped' => 'setScrapped',
        'scrap_qty' => 'setScrapQty',
        'return_date' => 'setReturnDate',
        'location' => 'setLocation',
        'item_number' => 'setItemNumber',
        'item_title' => 'setItemTitle',
        'new_qty' => 'setNewQty',
        'refund_reference' => 'setRefundReference',
        'pk_refund_row_id' => 'setPkRefundRowId',
        'amount' => 'setAmount',
        'create_date' => 'setCreateDate',
        'cancellation_quantity' => 'setCancellationQuantity',
        'fk_order_item_return_id' => 'setFkOrderItemReturnId',
        'action_date' => 'setActionDate',
        'refund_status' => 'setRefundStatus'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'row' => 'getRow',
        'pk_order_id' => 'getPkOrderId',
        'c_shipping_address' => 'getCShippingAddress',
        'd_processed_on' => 'getDProcessedOn',
        'f_postage_cost' => 'getFPostageCost',
        'f_total_charge' => 'getFTotalCharge',
        'postage_cost_ex_tax' => 'getPostageCostExTax',
        'subtotal' => 'getSubtotal',
        'f_tax' => 'getFTax',
        'total_discount' => 'getTotalDiscount',
        'country_tax_rate' => 'getCountryTaxRate',
        'n_order_id' => 'getNOrderId',
        'c_currency' => 'getCCurrency',
        'postal_tracking_number' => 'getPostalTrackingNumber',
        'c_country' => 'getCCountry',
        'source' => 'getSource',
        'postal_service_name' => 'getPostalServiceName',
        'postal_service_code' => 'getPostalServiceCode',
        'vendor' => 'getVendor',
        'reference_num' => 'getReferenceNum',
        'secondary_reference' => 'getSecondaryReference',
        'external_reference' => 'getExternalReference',
        'address1' => 'getAddress1',
        'address2' => 'getAddress2',
        'address3' => 'getAddress3',
        'town' => 'getTown',
        'region' => 'getRegion',
        'buyer_phone_number' => 'getBuyerPhoneNumber',
        'company' => 'getCompany',
        'sub_source' => 'getSubSource',
        'channel_buyer_name' => 'getChannelBuyerName',
        'account_name' => 'getAccountName',
        'c_full_name' => 'getCFullName',
        'c_email_address' => 'getCEmailAddress',
        'c_post_code' => 'getCPostCode',
        'd_paid_on' => 'getDPaidOn',
        'c_billing_address' => 'getCBillingAddress',
        'billing_name' => 'getBillingName',
        'billing_company' => 'getBillingCompany',
        'billing_address1' => 'getBillingAddress1',
        'billing_address2' => 'getBillingAddress2',
        'billing_address3' => 'getBillingAddress3',
        'billing_town' => 'getBillingTown',
        'billing_region' => 'getBillingRegion',
        'billing_post_code' => 'getBillingPostCode',
        'billing_country_name' => 'getBillingCountryName',
        'billing_phone_number' => 'getBillingPhoneNumber',
        'c_item_number' => 'getCItemNumber',
        'c_item_name' => 'getCItemName',
        'pk_return_id' => 'getPkReturnId',
        'row_type' => 'getRowType',
        'return_reference' => 'getReturnReference',
        'pending_refund_amount' => 'getPendingRefundAmount',
        'last_date' => 'getLastDate',
        'reason' => 'getReason',
        'channel_reason' => 'getChannelReason',
        'channel_reason_sec' => 'getChannelReasonSec',
        'category' => 'getCategory',
        'return_qty' => 'getReturnQty',
        'fk_return_location_id' => 'getFkReturnLocationId',
        'scrapped' => 'getScrapped',
        'scrap_qty' => 'getScrapQty',
        'return_date' => 'getReturnDate',
        'location' => 'getLocation',
        'item_number' => 'getItemNumber',
        'item_title' => 'getItemTitle',
        'new_qty' => 'getNewQty',
        'refund_reference' => 'getRefundReference',
        'pk_refund_row_id' => 'getPkRefundRowId',
        'amount' => 'getAmount',
        'create_date' => 'getCreateDate',
        'cancellation_quantity' => 'getCancellationQuantity',
        'fk_order_item_return_id' => 'getFkOrderItemReturnId',
        'action_date' => 'getActionDate',
        'refund_status' => 'getRefundStatus'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const REFUND_STATUS_OPEN = 'OPEN';
    public const REFUND_STATUS_PROCESSED = 'PROCESSED';
    public const REFUND_STATUS_ERROR = 'ERROR';
    public const REFUND_STATUS_ERROR_ACKED = 'ERROR_ACKED';
    public const REFUND_STATUS_PENDING = 'PENDING';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRefundStatusAllowableValues()
    {
        return [
            self::REFUND_STATUS_OPEN,
            self::REFUND_STATUS_PROCESSED,
            self::REFUND_STATUS_ERROR,
            self::REFUND_STATUS_ERROR_ACKED,
            self::REFUND_STATUS_PENDING,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('row', $data ?? [], null);
        $this->setIfExists('pk_order_id', $data ?? [], null);
        $this->setIfExists('c_shipping_address', $data ?? [], null);
        $this->setIfExists('d_processed_on', $data ?? [], null);
        $this->setIfExists('f_postage_cost', $data ?? [], null);
        $this->setIfExists('f_total_charge', $data ?? [], null);
        $this->setIfExists('postage_cost_ex_tax', $data ?? [], null);
        $this->setIfExists('subtotal', $data ?? [], null);
        $this->setIfExists('f_tax', $data ?? [], null);
        $this->setIfExists('total_discount', $data ?? [], null);
        $this->setIfExists('country_tax_rate', $data ?? [], null);
        $this->setIfExists('n_order_id', $data ?? [], null);
        $this->setIfExists('c_currency', $data ?? [], null);
        $this->setIfExists('postal_tracking_number', $data ?? [], null);
        $this->setIfExists('c_country', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('postal_service_name', $data ?? [], null);
        $this->setIfExists('postal_service_code', $data ?? [], null);
        $this->setIfExists('vendor', $data ?? [], null);
        $this->setIfExists('reference_num', $data ?? [], null);
        $this->setIfExists('secondary_reference', $data ?? [], null);
        $this->setIfExists('external_reference', $data ?? [], null);
        $this->setIfExists('address1', $data ?? [], null);
        $this->setIfExists('address2', $data ?? [], null);
        $this->setIfExists('address3', $data ?? [], null);
        $this->setIfExists('town', $data ?? [], null);
        $this->setIfExists('region', $data ?? [], null);
        $this->setIfExists('buyer_phone_number', $data ?? [], null);
        $this->setIfExists('company', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('channel_buyer_name', $data ?? [], null);
        $this->setIfExists('account_name', $data ?? [], null);
        $this->setIfExists('c_full_name', $data ?? [], null);
        $this->setIfExists('c_email_address', $data ?? [], null);
        $this->setIfExists('c_post_code', $data ?? [], null);
        $this->setIfExists('d_paid_on', $data ?? [], null);
        $this->setIfExists('c_billing_address', $data ?? [], null);
        $this->setIfExists('billing_name', $data ?? [], null);
        $this->setIfExists('billing_company', $data ?? [], null);
        $this->setIfExists('billing_address1', $data ?? [], null);
        $this->setIfExists('billing_address2', $data ?? [], null);
        $this->setIfExists('billing_address3', $data ?? [], null);
        $this->setIfExists('billing_town', $data ?? [], null);
        $this->setIfExists('billing_region', $data ?? [], null);
        $this->setIfExists('billing_post_code', $data ?? [], null);
        $this->setIfExists('billing_country_name', $data ?? [], null);
        $this->setIfExists('billing_phone_number', $data ?? [], null);
        $this->setIfExists('c_item_number', $data ?? [], null);
        $this->setIfExists('c_item_name', $data ?? [], null);
        $this->setIfExists('pk_return_id', $data ?? [], null);
        $this->setIfExists('row_type', $data ?? [], null);
        $this->setIfExists('return_reference', $data ?? [], null);
        $this->setIfExists('pending_refund_amount', $data ?? [], null);
        $this->setIfExists('last_date', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('channel_reason', $data ?? [], null);
        $this->setIfExists('channel_reason_sec', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('return_qty', $data ?? [], null);
        $this->setIfExists('fk_return_location_id', $data ?? [], null);
        $this->setIfExists('scrapped', $data ?? [], null);
        $this->setIfExists('scrap_qty', $data ?? [], null);
        $this->setIfExists('return_date', $data ?? [], null);
        $this->setIfExists('location', $data ?? [], null);
        $this->setIfExists('item_number', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('new_qty', $data ?? [], null);
        $this->setIfExists('refund_reference', $data ?? [], null);
        $this->setIfExists('pk_refund_row_id', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('create_date', $data ?? [], null);
        $this->setIfExists('cancellation_quantity', $data ?? [], null);
        $this->setIfExists('fk_order_item_return_id', $data ?? [], null);
        $this->setIfExists('action_date', $data ?? [], null);
        $this->setIfExists('refund_status', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getRefundStatusAllowableValues();
        if (!is_null($this->container['refund_status']) && !in_array($this->container['refund_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'refund_status', must be one of '%s'",
                $this->container['refund_status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets row
     *
     * @return int|null
     */
    public function getRow()
    {
        return $this->container['row'];
    }

    /**
     * Sets row
     *
     * @param int|null $row row
     *
     * @return self
     */
    public function setRow($row)
    {
        if (is_null($row)) {
            throw new \InvalidArgumentException('non-nullable row cannot be null');
        }
        $this->container['row'] = $row;

        return $this;
    }

    /**
     * Gets pk_order_id
     *
     * @return string|null
     */
    public function getPkOrderId()
    {
        return $this->container['pk_order_id'];
    }

    /**
     * Sets pk_order_id
     *
     * @param string|null $pk_order_id pk_order_id
     *
     * @return self
     */
    public function setPkOrderId($pk_order_id)
    {
        if (is_null($pk_order_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_id cannot be null');
        }
        $this->container['pk_order_id'] = $pk_order_id;

        return $this;
    }

    /**
     * Gets c_shipping_address
     *
     * @return string|null
     */
    public function getCShippingAddress()
    {
        return $this->container['c_shipping_address'];
    }

    /**
     * Sets c_shipping_address
     *
     * @param string|null $c_shipping_address c_shipping_address
     *
     * @return self
     */
    public function setCShippingAddress($c_shipping_address)
    {
        if (is_null($c_shipping_address)) {
            throw new \InvalidArgumentException('non-nullable c_shipping_address cannot be null');
        }
        $this->container['c_shipping_address'] = $c_shipping_address;

        return $this;
    }

    /**
     * Gets d_processed_on
     *
     * @return \DateTime|null
     */
    public function getDProcessedOn()
    {
        return $this->container['d_processed_on'];
    }

    /**
     * Sets d_processed_on
     *
     * @param \DateTime|null $d_processed_on d_processed_on
     *
     * @return self
     */
    public function setDProcessedOn($d_processed_on)
    {
        if (is_null($d_processed_on)) {
            throw new \InvalidArgumentException('non-nullable d_processed_on cannot be null');
        }
        $this->container['d_processed_on'] = $d_processed_on;

        return $this;
    }

    /**
     * Gets f_postage_cost
     *
     * @return float|null
     */
    public function getFPostageCost()
    {
        return $this->container['f_postage_cost'];
    }

    /**
     * Sets f_postage_cost
     *
     * @param float|null $f_postage_cost f_postage_cost
     *
     * @return self
     */
    public function setFPostageCost($f_postage_cost)
    {
        if (is_null($f_postage_cost)) {
            throw new \InvalidArgumentException('non-nullable f_postage_cost cannot be null');
        }
        $this->container['f_postage_cost'] = $f_postage_cost;

        return $this;
    }

    /**
     * Gets f_total_charge
     *
     * @return float|null
     */
    public function getFTotalCharge()
    {
        return $this->container['f_total_charge'];
    }

    /**
     * Sets f_total_charge
     *
     * @param float|null $f_total_charge f_total_charge
     *
     * @return self
     */
    public function setFTotalCharge($f_total_charge)
    {
        if (is_null($f_total_charge)) {
            throw new \InvalidArgumentException('non-nullable f_total_charge cannot be null');
        }
        $this->container['f_total_charge'] = $f_total_charge;

        return $this;
    }

    /**
     * Gets postage_cost_ex_tax
     *
     * @return float|null
     */
    public function getPostageCostExTax()
    {
        return $this->container['postage_cost_ex_tax'];
    }

    /**
     * Sets postage_cost_ex_tax
     *
     * @param float|null $postage_cost_ex_tax postage_cost_ex_tax
     *
     * @return self
     */
    public function setPostageCostExTax($postage_cost_ex_tax)
    {
        if (is_null($postage_cost_ex_tax)) {
            throw new \InvalidArgumentException('non-nullable postage_cost_ex_tax cannot be null');
        }
        $this->container['postage_cost_ex_tax'] = $postage_cost_ex_tax;

        return $this;
    }

    /**
     * Gets subtotal
     *
     * @return float|null
     */
    public function getSubtotal()
    {
        return $this->container['subtotal'];
    }

    /**
     * Sets subtotal
     *
     * @param float|null $subtotal subtotal
     *
     * @return self
     */
    public function setSubtotal($subtotal)
    {
        if (is_null($subtotal)) {
            throw new \InvalidArgumentException('non-nullable subtotal cannot be null');
        }
        $this->container['subtotal'] = $subtotal;

        return $this;
    }

    /**
     * Gets f_tax
     *
     * @return float|null
     */
    public function getFTax()
    {
        return $this->container['f_tax'];
    }

    /**
     * Sets f_tax
     *
     * @param float|null $f_tax f_tax
     *
     * @return self
     */
    public function setFTax($f_tax)
    {
        if (is_null($f_tax)) {
            throw new \InvalidArgumentException('non-nullable f_tax cannot be null');
        }
        $this->container['f_tax'] = $f_tax;

        return $this;
    }

    /**
     * Gets total_discount
     *
     * @return float|null
     */
    public function getTotalDiscount()
    {
        return $this->container['total_discount'];
    }

    /**
     * Sets total_discount
     *
     * @param float|null $total_discount total_discount
     *
     * @return self
     */
    public function setTotalDiscount($total_discount)
    {
        if (is_null($total_discount)) {
            throw new \InvalidArgumentException('non-nullable total_discount cannot be null');
        }
        $this->container['total_discount'] = $total_discount;

        return $this;
    }

    /**
     * Gets country_tax_rate
     *
     * @return float|null
     */
    public function getCountryTaxRate()
    {
        return $this->container['country_tax_rate'];
    }

    /**
     * Sets country_tax_rate
     *
     * @param float|null $country_tax_rate country_tax_rate
     *
     * @return self
     */
    public function setCountryTaxRate($country_tax_rate)
    {
        if (is_null($country_tax_rate)) {
            throw new \InvalidArgumentException('non-nullable country_tax_rate cannot be null');
        }
        $this->container['country_tax_rate'] = $country_tax_rate;

        return $this;
    }

    /**
     * Gets n_order_id
     *
     * @return int|null
     */
    public function getNOrderId()
    {
        return $this->container['n_order_id'];
    }

    /**
     * Sets n_order_id
     *
     * @param int|null $n_order_id n_order_id
     *
     * @return self
     */
    public function setNOrderId($n_order_id)
    {
        if (is_null($n_order_id)) {
            throw new \InvalidArgumentException('non-nullable n_order_id cannot be null');
        }
        $this->container['n_order_id'] = $n_order_id;

        return $this;
    }

    /**
     * Gets c_currency
     *
     * @return string|null
     */
    public function getCCurrency()
    {
        return $this->container['c_currency'];
    }

    /**
     * Sets c_currency
     *
     * @param string|null $c_currency c_currency
     *
     * @return self
     */
    public function setCCurrency($c_currency)
    {
        if (is_null($c_currency)) {
            throw new \InvalidArgumentException('non-nullable c_currency cannot be null');
        }
        $this->container['c_currency'] = $c_currency;

        return $this;
    }

    /**
     * Gets postal_tracking_number
     *
     * @return string|null
     */
    public function getPostalTrackingNumber()
    {
        return $this->container['postal_tracking_number'];
    }

    /**
     * Sets postal_tracking_number
     *
     * @param string|null $postal_tracking_number postal_tracking_number
     *
     * @return self
     */
    public function setPostalTrackingNumber($postal_tracking_number)
    {
        if (is_null($postal_tracking_number)) {
            throw new \InvalidArgumentException('non-nullable postal_tracking_number cannot be null');
        }
        $this->container['postal_tracking_number'] = $postal_tracking_number;

        return $this;
    }

    /**
     * Gets c_country
     *
     * @return string|null
     */
    public function getCCountry()
    {
        return $this->container['c_country'];
    }

    /**
     * Sets c_country
     *
     * @param string|null $c_country c_country
     *
     * @return self
     */
    public function setCCountry($c_country)
    {
        if (is_null($c_country)) {
            throw new \InvalidArgumentException('non-nullable c_country cannot be null');
        }
        $this->container['c_country'] = $c_country;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source source
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets postal_service_name
     *
     * @return string|null
     */
    public function getPostalServiceName()
    {
        return $this->container['postal_service_name'];
    }

    /**
     * Sets postal_service_name
     *
     * @param string|null $postal_service_name postal_service_name
     *
     * @return self
     */
    public function setPostalServiceName($postal_service_name)
    {
        if (is_null($postal_service_name)) {
            throw new \InvalidArgumentException('non-nullable postal_service_name cannot be null');
        }
        $this->container['postal_service_name'] = $postal_service_name;

        return $this;
    }

    /**
     * Gets postal_service_code
     *
     * @return string|null
     */
    public function getPostalServiceCode()
    {
        return $this->container['postal_service_code'];
    }

    /**
     * Sets postal_service_code
     *
     * @param string|null $postal_service_code postal_service_code
     *
     * @return self
     */
    public function setPostalServiceCode($postal_service_code)
    {
        if (is_null($postal_service_code)) {
            throw new \InvalidArgumentException('non-nullable postal_service_code cannot be null');
        }
        $this->container['postal_service_code'] = $postal_service_code;

        return $this;
    }

    /**
     * Gets vendor
     *
     * @return string|null
     */
    public function getVendor()
    {
        return $this->container['vendor'];
    }

    /**
     * Sets vendor
     *
     * @param string|null $vendor vendor
     *
     * @return self
     */
    public function setVendor($vendor)
    {
        if (is_null($vendor)) {
            throw new \InvalidArgumentException('non-nullable vendor cannot be null');
        }
        $this->container['vendor'] = $vendor;

        return $this;
    }

    /**
     * Gets reference_num
     *
     * @return string|null
     */
    public function getReferenceNum()
    {
        return $this->container['reference_num'];
    }

    /**
     * Sets reference_num
     *
     * @param string|null $reference_num reference_num
     *
     * @return self
     */
    public function setReferenceNum($reference_num)
    {
        if (is_null($reference_num)) {
            throw new \InvalidArgumentException('non-nullable reference_num cannot be null');
        }
        $this->container['reference_num'] = $reference_num;

        return $this;
    }

    /**
     * Gets secondary_reference
     *
     * @return string|null
     */
    public function getSecondaryReference()
    {
        return $this->container['secondary_reference'];
    }

    /**
     * Sets secondary_reference
     *
     * @param string|null $secondary_reference secondary_reference
     *
     * @return self
     */
    public function setSecondaryReference($secondary_reference)
    {
        if (is_null($secondary_reference)) {
            throw new \InvalidArgumentException('non-nullable secondary_reference cannot be null');
        }
        $this->container['secondary_reference'] = $secondary_reference;

        return $this;
    }

    /**
     * Gets external_reference
     *
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->container['external_reference'];
    }

    /**
     * Sets external_reference
     *
     * @param string|null $external_reference external_reference
     *
     * @return self
     */
    public function setExternalReference($external_reference)
    {
        if (is_null($external_reference)) {
            throw new \InvalidArgumentException('non-nullable external_reference cannot be null');
        }
        $this->container['external_reference'] = $external_reference;

        return $this;
    }

    /**
     * Gets address1
     *
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->container['address1'];
    }

    /**
     * Sets address1
     *
     * @param string|null $address1 address1
     *
     * @return self
     */
    public function setAddress1($address1)
    {
        if (is_null($address1)) {
            throw new \InvalidArgumentException('non-nullable address1 cannot be null');
        }
        $this->container['address1'] = $address1;

        return $this;
    }

    /**
     * Gets address2
     *
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->container['address2'];
    }

    /**
     * Sets address2
     *
     * @param string|null $address2 address2
     *
     * @return self
     */
    public function setAddress2($address2)
    {
        if (is_null($address2)) {
            throw new \InvalidArgumentException('non-nullable address2 cannot be null');
        }
        $this->container['address2'] = $address2;

        return $this;
    }

    /**
     * Gets address3
     *
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->container['address3'];
    }

    /**
     * Sets address3
     *
     * @param string|null $address3 address3
     *
     * @return self
     */
    public function setAddress3($address3)
    {
        if (is_null($address3)) {
            throw new \InvalidArgumentException('non-nullable address3 cannot be null');
        }
        $this->container['address3'] = $address3;

        return $this;
    }

    /**
     * Gets town
     *
     * @return string|null
     */
    public function getTown()
    {
        return $this->container['town'];
    }

    /**
     * Sets town
     *
     * @param string|null $town town
     *
     * @return self
     */
    public function setTown($town)
    {
        if (is_null($town)) {
            throw new \InvalidArgumentException('non-nullable town cannot be null');
        }
        $this->container['town'] = $town;

        return $this;
    }

    /**
     * Gets region
     *
     * @return string|null
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param string|null $region region
     *
     * @return self
     */
    public function setRegion($region)
    {
        if (is_null($region)) {
            throw new \InvalidArgumentException('non-nullable region cannot be null');
        }
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets buyer_phone_number
     *
     * @return string|null
     */
    public function getBuyerPhoneNumber()
    {
        return $this->container['buyer_phone_number'];
    }

    /**
     * Sets buyer_phone_number
     *
     * @param string|null $buyer_phone_number buyer_phone_number
     *
     * @return self
     */
    public function setBuyerPhoneNumber($buyer_phone_number)
    {
        if (is_null($buyer_phone_number)) {
            throw new \InvalidArgumentException('non-nullable buyer_phone_number cannot be null');
        }
        $this->container['buyer_phone_number'] = $buyer_phone_number;

        return $this;
    }

    /**
     * Gets company
     *
     * @return string|null
     */
    public function getCompany()
    {
        return $this->container['company'];
    }

    /**
     * Sets company
     *
     * @param string|null $company company
     *
     * @return self
     */
    public function setCompany($company)
    {
        if (is_null($company)) {
            throw new \InvalidArgumentException('non-nullable company cannot be null');
        }
        $this->container['company'] = $company;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source sub_source
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets channel_buyer_name
     *
     * @return string|null
     */
    public function getChannelBuyerName()
    {
        return $this->container['channel_buyer_name'];
    }

    /**
     * Sets channel_buyer_name
     *
     * @param string|null $channel_buyer_name channel_buyer_name
     *
     * @return self
     */
    public function setChannelBuyerName($channel_buyer_name)
    {
        if (is_null($channel_buyer_name)) {
            throw new \InvalidArgumentException('non-nullable channel_buyer_name cannot be null');
        }
        $this->container['channel_buyer_name'] = $channel_buyer_name;

        return $this;
    }

    /**
     * Gets account_name
     *
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->container['account_name'];
    }

    /**
     * Sets account_name
     *
     * @param string|null $account_name account_name
     *
     * @return self
     */
    public function setAccountName($account_name)
    {
        if (is_null($account_name)) {
            throw new \InvalidArgumentException('non-nullable account_name cannot be null');
        }
        $this->container['account_name'] = $account_name;

        return $this;
    }

    /**
     * Gets c_full_name
     *
     * @return string|null
     */
    public function getCFullName()
    {
        return $this->container['c_full_name'];
    }

    /**
     * Sets c_full_name
     *
     * @param string|null $c_full_name c_full_name
     *
     * @return self
     */
    public function setCFullName($c_full_name)
    {
        if (is_null($c_full_name)) {
            throw new \InvalidArgumentException('non-nullable c_full_name cannot be null');
        }
        $this->container['c_full_name'] = $c_full_name;

        return $this;
    }

    /**
     * Gets c_email_address
     *
     * @return string|null
     */
    public function getCEmailAddress()
    {
        return $this->container['c_email_address'];
    }

    /**
     * Sets c_email_address
     *
     * @param string|null $c_email_address c_email_address
     *
     * @return self
     */
    public function setCEmailAddress($c_email_address)
    {
        if (is_null($c_email_address)) {
            throw new \InvalidArgumentException('non-nullable c_email_address cannot be null');
        }
        $this->container['c_email_address'] = $c_email_address;

        return $this;
    }

    /**
     * Gets c_post_code
     *
     * @return string|null
     */
    public function getCPostCode()
    {
        return $this->container['c_post_code'];
    }

    /**
     * Sets c_post_code
     *
     * @param string|null $c_post_code c_post_code
     *
     * @return self
     */
    public function setCPostCode($c_post_code)
    {
        if (is_null($c_post_code)) {
            throw new \InvalidArgumentException('non-nullable c_post_code cannot be null');
        }
        $this->container['c_post_code'] = $c_post_code;

        return $this;
    }

    /**
     * Gets d_paid_on
     *
     * @return \DateTime|null
     */
    public function getDPaidOn()
    {
        return $this->container['d_paid_on'];
    }

    /**
     * Sets d_paid_on
     *
     * @param \DateTime|null $d_paid_on d_paid_on
     *
     * @return self
     */
    public function setDPaidOn($d_paid_on)
    {
        if (is_null($d_paid_on)) {
            throw new \InvalidArgumentException('non-nullable d_paid_on cannot be null');
        }
        $this->container['d_paid_on'] = $d_paid_on;

        return $this;
    }

    /**
     * Gets c_billing_address
     *
     * @return string|null
     */
    public function getCBillingAddress()
    {
        return $this->container['c_billing_address'];
    }

    /**
     * Sets c_billing_address
     *
     * @param string|null $c_billing_address c_billing_address
     *
     * @return self
     */
    public function setCBillingAddress($c_billing_address)
    {
        if (is_null($c_billing_address)) {
            throw new \InvalidArgumentException('non-nullable c_billing_address cannot be null');
        }
        $this->container['c_billing_address'] = $c_billing_address;

        return $this;
    }

    /**
     * Gets billing_name
     *
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->container['billing_name'];
    }

    /**
     * Sets billing_name
     *
     * @param string|null $billing_name billing_name
     *
     * @return self
     */
    public function setBillingName($billing_name)
    {
        if (is_null($billing_name)) {
            throw new \InvalidArgumentException('non-nullable billing_name cannot be null');
        }
        $this->container['billing_name'] = $billing_name;

        return $this;
    }

    /**
     * Gets billing_company
     *
     * @return string|null
     */
    public function getBillingCompany()
    {
        return $this->container['billing_company'];
    }

    /**
     * Sets billing_company
     *
     * @param string|null $billing_company billing_company
     *
     * @return self
     */
    public function setBillingCompany($billing_company)
    {
        if (is_null($billing_company)) {
            throw new \InvalidArgumentException('non-nullable billing_company cannot be null');
        }
        $this->container['billing_company'] = $billing_company;

        return $this;
    }

    /**
     * Gets billing_address1
     *
     * @return string|null
     */
    public function getBillingAddress1()
    {
        return $this->container['billing_address1'];
    }

    /**
     * Sets billing_address1
     *
     * @param string|null $billing_address1 billing_address1
     *
     * @return self
     */
    public function setBillingAddress1($billing_address1)
    {
        if (is_null($billing_address1)) {
            throw new \InvalidArgumentException('non-nullable billing_address1 cannot be null');
        }
        $this->container['billing_address1'] = $billing_address1;

        return $this;
    }

    /**
     * Gets billing_address2
     *
     * @return string|null
     */
    public function getBillingAddress2()
    {
        return $this->container['billing_address2'];
    }

    /**
     * Sets billing_address2
     *
     * @param string|null $billing_address2 billing_address2
     *
     * @return self
     */
    public function setBillingAddress2($billing_address2)
    {
        if (is_null($billing_address2)) {
            throw new \InvalidArgumentException('non-nullable billing_address2 cannot be null');
        }
        $this->container['billing_address2'] = $billing_address2;

        return $this;
    }

    /**
     * Gets billing_address3
     *
     * @return string|null
     */
    public function getBillingAddress3()
    {
        return $this->container['billing_address3'];
    }

    /**
     * Sets billing_address3
     *
     * @param string|null $billing_address3 billing_address3
     *
     * @return self
     */
    public function setBillingAddress3($billing_address3)
    {
        if (is_null($billing_address3)) {
            throw new \InvalidArgumentException('non-nullable billing_address3 cannot be null');
        }
        $this->container['billing_address3'] = $billing_address3;

        return $this;
    }

    /**
     * Gets billing_town
     *
     * @return string|null
     */
    public function getBillingTown()
    {
        return $this->container['billing_town'];
    }

    /**
     * Sets billing_town
     *
     * @param string|null $billing_town billing_town
     *
     * @return self
     */
    public function setBillingTown($billing_town)
    {
        if (is_null($billing_town)) {
            throw new \InvalidArgumentException('non-nullable billing_town cannot be null');
        }
        $this->container['billing_town'] = $billing_town;

        return $this;
    }

    /**
     * Gets billing_region
     *
     * @return string|null
     */
    public function getBillingRegion()
    {
        return $this->container['billing_region'];
    }

    /**
     * Sets billing_region
     *
     * @param string|null $billing_region billing_region
     *
     * @return self
     */
    public function setBillingRegion($billing_region)
    {
        if (is_null($billing_region)) {
            throw new \InvalidArgumentException('non-nullable billing_region cannot be null');
        }
        $this->container['billing_region'] = $billing_region;

        return $this;
    }

    /**
     * Gets billing_post_code
     *
     * @return string|null
     */
    public function getBillingPostCode()
    {
        return $this->container['billing_post_code'];
    }

    /**
     * Sets billing_post_code
     *
     * @param string|null $billing_post_code billing_post_code
     *
     * @return self
     */
    public function setBillingPostCode($billing_post_code)
    {
        if (is_null($billing_post_code)) {
            throw new \InvalidArgumentException('non-nullable billing_post_code cannot be null');
        }
        $this->container['billing_post_code'] = $billing_post_code;

        return $this;
    }

    /**
     * Gets billing_country_name
     *
     * @return string|null
     */
    public function getBillingCountryName()
    {
        return $this->container['billing_country_name'];
    }

    /**
     * Sets billing_country_name
     *
     * @param string|null $billing_country_name billing_country_name
     *
     * @return self
     */
    public function setBillingCountryName($billing_country_name)
    {
        if (is_null($billing_country_name)) {
            throw new \InvalidArgumentException('non-nullable billing_country_name cannot be null');
        }
        $this->container['billing_country_name'] = $billing_country_name;

        return $this;
    }

    /**
     * Gets billing_phone_number
     *
     * @return string|null
     */
    public function getBillingPhoneNumber()
    {
        return $this->container['billing_phone_number'];
    }

    /**
     * Sets billing_phone_number
     *
     * @param string|null $billing_phone_number billing_phone_number
     *
     * @return self
     */
    public function setBillingPhoneNumber($billing_phone_number)
    {
        if (is_null($billing_phone_number)) {
            throw new \InvalidArgumentException('non-nullable billing_phone_number cannot be null');
        }
        $this->container['billing_phone_number'] = $billing_phone_number;

        return $this;
    }

    /**
     * Gets c_item_number
     *
     * @return string|null
     */
    public function getCItemNumber()
    {
        return $this->container['c_item_number'];
    }

    /**
     * Sets c_item_number
     *
     * @param string|null $c_item_number c_item_number
     *
     * @return self
     */
    public function setCItemNumber($c_item_number)
    {
        if (is_null($c_item_number)) {
            throw new \InvalidArgumentException('non-nullable c_item_number cannot be null');
        }
        $this->container['c_item_number'] = $c_item_number;

        return $this;
    }

    /**
     * Gets c_item_name
     *
     * @return string|null
     */
    public function getCItemName()
    {
        return $this->container['c_item_name'];
    }

    /**
     * Sets c_item_name
     *
     * @param string|null $c_item_name c_item_name
     *
     * @return self
     */
    public function setCItemName($c_item_name)
    {
        if (is_null($c_item_name)) {
            throw new \InvalidArgumentException('non-nullable c_item_name cannot be null');
        }
        $this->container['c_item_name'] = $c_item_name;

        return $this;
    }

    /**
     * Gets pk_return_id
     *
     * @return int|null
     */
    public function getPkReturnId()
    {
        return $this->container['pk_return_id'];
    }

    /**
     * Sets pk_return_id
     *
     * @param int|null $pk_return_id pk_return_id
     *
     * @return self
     */
    public function setPkReturnId($pk_return_id)
    {
        if (is_null($pk_return_id)) {
            throw new \InvalidArgumentException('non-nullable pk_return_id cannot be null');
        }
        $this->container['pk_return_id'] = $pk_return_id;

        return $this;
    }

    /**
     * Gets row_type
     *
     * @return string|null
     */
    public function getRowType()
    {
        return $this->container['row_type'];
    }

    /**
     * Sets row_type
     *
     * @param string|null $row_type row_type
     *
     * @return self
     */
    public function setRowType($row_type)
    {
        if (is_null($row_type)) {
            throw new \InvalidArgumentException('non-nullable row_type cannot be null');
        }
        $this->container['row_type'] = $row_type;

        return $this;
    }

    /**
     * Gets return_reference
     *
     * @return string|null
     */
    public function getReturnReference()
    {
        return $this->container['return_reference'];
    }

    /**
     * Sets return_reference
     *
     * @param string|null $return_reference return_reference
     *
     * @return self
     */
    public function setReturnReference($return_reference)
    {
        if (is_null($return_reference)) {
            throw new \InvalidArgumentException('non-nullable return_reference cannot be null');
        }
        $this->container['return_reference'] = $return_reference;

        return $this;
    }

    /**
     * Gets pending_refund_amount
     *
     * @return float|null
     */
    public function getPendingRefundAmount()
    {
        return $this->container['pending_refund_amount'];
    }

    /**
     * Sets pending_refund_amount
     *
     * @param float|null $pending_refund_amount pending_refund_amount
     *
     * @return self
     */
    public function setPendingRefundAmount($pending_refund_amount)
    {
        if (is_null($pending_refund_amount)) {
            throw new \InvalidArgumentException('non-nullable pending_refund_amount cannot be null');
        }
        $this->container['pending_refund_amount'] = $pending_refund_amount;

        return $this;
    }

    /**
     * Gets last_date
     *
     * @return \DateTime|null
     */
    public function getLastDate()
    {
        return $this->container['last_date'];
    }

    /**
     * Sets last_date
     *
     * @param \DateTime|null $last_date last_date
     *
     * @return self
     */
    public function setLastDate($last_date)
    {
        if (is_null($last_date)) {
            throw new \InvalidArgumentException('non-nullable last_date cannot be null');
        }
        $this->container['last_date'] = $last_date;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason reason
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets channel_reason
     *
     * @return string|null
     */
    public function getChannelReason()
    {
        return $this->container['channel_reason'];
    }

    /**
     * Sets channel_reason
     *
     * @param string|null $channel_reason channel_reason
     *
     * @return self
     */
    public function setChannelReason($channel_reason)
    {
        if (is_null($channel_reason)) {
            throw new \InvalidArgumentException('non-nullable channel_reason cannot be null');
        }
        $this->container['channel_reason'] = $channel_reason;

        return $this;
    }

    /**
     * Gets channel_reason_sec
     *
     * @return string|null
     */
    public function getChannelReasonSec()
    {
        return $this->container['channel_reason_sec'];
    }

    /**
     * Sets channel_reason_sec
     *
     * @param string|null $channel_reason_sec channel_reason_sec
     *
     * @return self
     */
    public function setChannelReasonSec($channel_reason_sec)
    {
        if (is_null($channel_reason_sec)) {
            throw new \InvalidArgumentException('non-nullable channel_reason_sec cannot be null');
        }
        $this->container['channel_reason_sec'] = $channel_reason_sec;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string|null $category category
     *
     * @return self
     */
    public function setCategory($category)
    {
        if (is_null($category)) {
            throw new \InvalidArgumentException('non-nullable category cannot be null');
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets return_qty
     *
     * @return int|null
     */
    public function getReturnQty()
    {
        return $this->container['return_qty'];
    }

    /**
     * Sets return_qty
     *
     * @param int|null $return_qty return_qty
     *
     * @return self
     */
    public function setReturnQty($return_qty)
    {
        if (is_null($return_qty)) {
            throw new \InvalidArgumentException('non-nullable return_qty cannot be null');
        }
        $this->container['return_qty'] = $return_qty;

        return $this;
    }

    /**
     * Gets fk_return_location_id
     *
     * @return string|null
     */
    public function getFkReturnLocationId()
    {
        return $this->container['fk_return_location_id'];
    }

    /**
     * Sets fk_return_location_id
     *
     * @param string|null $fk_return_location_id fk_return_location_id
     *
     * @return self
     */
    public function setFkReturnLocationId($fk_return_location_id)
    {
        if (is_null($fk_return_location_id)) {
            throw new \InvalidArgumentException('non-nullable fk_return_location_id cannot be null');
        }
        $this->container['fk_return_location_id'] = $fk_return_location_id;

        return $this;
    }

    /**
     * Gets scrapped
     *
     * @return bool|null
     */
    public function getScrapped()
    {
        return $this->container['scrapped'];
    }

    /**
     * Sets scrapped
     *
     * @param bool|null $scrapped scrapped
     *
     * @return self
     */
    public function setScrapped($scrapped)
    {
        if (is_null($scrapped)) {
            throw new \InvalidArgumentException('non-nullable scrapped cannot be null');
        }
        $this->container['scrapped'] = $scrapped;

        return $this;
    }

    /**
     * Gets scrap_qty
     *
     * @return int|null
     */
    public function getScrapQty()
    {
        return $this->container['scrap_qty'];
    }

    /**
     * Sets scrap_qty
     *
     * @param int|null $scrap_qty scrap_qty
     *
     * @return self
     */
    public function setScrapQty($scrap_qty)
    {
        if (is_null($scrap_qty)) {
            throw new \InvalidArgumentException('non-nullable scrap_qty cannot be null');
        }
        $this->container['scrap_qty'] = $scrap_qty;

        return $this;
    }

    /**
     * Gets return_date
     *
     * @return \DateTime|null
     */
    public function getReturnDate()
    {
        return $this->container['return_date'];
    }

    /**
     * Sets return_date
     *
     * @param \DateTime|null $return_date return_date
     *
     * @return self
     */
    public function setReturnDate($return_date)
    {
        if (is_null($return_date)) {
            throw new \InvalidArgumentException('non-nullable return_date cannot be null');
        }
        $this->container['return_date'] = $return_date;

        return $this;
    }

    /**
     * Gets location
     *
     * @return string|null
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     *
     * @param string|null $location location
     *
     * @return self
     */
    public function setLocation($location)
    {
        if (is_null($location)) {
            throw new \InvalidArgumentException('non-nullable location cannot be null');
        }
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets item_number
     *
     * @return string|null
     */
    public function getItemNumber()
    {
        return $this->container['item_number'];
    }

    /**
     * Sets item_number
     *
     * @param string|null $item_number item_number
     *
     * @return self
     */
    public function setItemNumber($item_number)
    {
        if (is_null($item_number)) {
            throw new \InvalidArgumentException('non-nullable item_number cannot be null');
        }
        $this->container['item_number'] = $item_number;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title item_title
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets new_qty
     *
     * @return int|null
     */
    public function getNewQty()
    {
        return $this->container['new_qty'];
    }

    /**
     * Sets new_qty
     *
     * @param int|null $new_qty new_qty
     *
     * @return self
     */
    public function setNewQty($new_qty)
    {
        if (is_null($new_qty)) {
            throw new \InvalidArgumentException('non-nullable new_qty cannot be null');
        }
        $this->container['new_qty'] = $new_qty;

        return $this;
    }

    /**
     * Gets refund_reference
     *
     * @return string|null
     */
    public function getRefundReference()
    {
        return $this->container['refund_reference'];
    }

    /**
     * Sets refund_reference
     *
     * @param string|null $refund_reference refund_reference
     *
     * @return self
     */
    public function setRefundReference($refund_reference)
    {
        if (is_null($refund_reference)) {
            throw new \InvalidArgumentException('non-nullable refund_reference cannot be null');
        }
        $this->container['refund_reference'] = $refund_reference;

        return $this;
    }

    /**
     * Gets pk_refund_row_id
     *
     * @return string|null
     */
    public function getPkRefundRowId()
    {
        return $this->container['pk_refund_row_id'];
    }

    /**
     * Sets pk_refund_row_id
     *
     * @param string|null $pk_refund_row_id pk_refund_row_id
     *
     * @return self
     */
    public function setPkRefundRowId($pk_refund_row_id)
    {
        if (is_null($pk_refund_row_id)) {
            throw new \InvalidArgumentException('non-nullable pk_refund_row_id cannot be null');
        }
        $this->container['pk_refund_row_id'] = $pk_refund_row_id;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float|null $amount amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets create_date
     *
     * @return \DateTime|null
     */
    public function getCreateDate()
    {
        return $this->container['create_date'];
    }

    /**
     * Sets create_date
     *
     * @param \DateTime|null $create_date create_date
     *
     * @return self
     */
    public function setCreateDate($create_date)
    {
        if (is_null($create_date)) {
            throw new \InvalidArgumentException('non-nullable create_date cannot be null');
        }
        $this->container['create_date'] = $create_date;

        return $this;
    }

    /**
     * Gets cancellation_quantity
     *
     * @return int|null
     */
    public function getCancellationQuantity()
    {
        return $this->container['cancellation_quantity'];
    }

    /**
     * Sets cancellation_quantity
     *
     * @param int|null $cancellation_quantity cancellation_quantity
     *
     * @return self
     */
    public function setCancellationQuantity($cancellation_quantity)
    {
        if (is_null($cancellation_quantity)) {
            throw new \InvalidArgumentException('non-nullable cancellation_quantity cannot be null');
        }
        $this->container['cancellation_quantity'] = $cancellation_quantity;

        return $this;
    }

    /**
     * Gets fk_order_item_return_id
     *
     * @return string|null
     */
    public function getFkOrderItemReturnId()
    {
        return $this->container['fk_order_item_return_id'];
    }

    /**
     * Sets fk_order_item_return_id
     *
     * @param string|null $fk_order_item_return_id fk_order_item_return_id
     *
     * @return self
     */
    public function setFkOrderItemReturnId($fk_order_item_return_id)
    {
        if (is_null($fk_order_item_return_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_item_return_id cannot be null');
        }
        $this->container['fk_order_item_return_id'] = $fk_order_item_return_id;

        return $this;
    }

    /**
     * Gets action_date
     *
     * @return \DateTime|null
     */
    public function getActionDate()
    {
        return $this->container['action_date'];
    }

    /**
     * Sets action_date
     *
     * @param \DateTime|null $action_date action_date
     *
     * @return self
     */
    public function setActionDate($action_date)
    {
        if (is_null($action_date)) {
            throw new \InvalidArgumentException('non-nullable action_date cannot be null');
        }
        $this->container['action_date'] = $action_date;

        return $this;
    }

    /**
     * Gets refund_status
     *
     * @return string|null
     */
    public function getRefundStatus()
    {
        return $this->container['refund_status'];
    }

    /**
     * Sets refund_status
     *
     * @param string|null $refund_status refund_status
     *
     * @return self
     */
    public function setRefundStatus($refund_status)
    {
        if (is_null($refund_status)) {
            throw new \InvalidArgumentException('non-nullable refund_status cannot be null');
        }
        $allowedValues = $this->getRefundStatusAllowableValues();
        if (!in_array($refund_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'refund_status', must be one of '%s'",
                    $refund_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['refund_status'] = $refund_status;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


