<?php
/**
 * ReturnOptions
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * ReturnOptions Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ReturnOptions implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ReturnOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'can_send_rejection_if_deleted' => 'bool',
        'can_return' => 'bool',
        'can_return_internally' => 'bool',
        'must_have_refund' => 'bool',
        'refund_auto_populated' => 'bool',
        'can_have_refund' => 'bool',
        'return_reasons' => '\Linnworks\ReturnsRefunds\Model\ChannelReason[]',
        'rejection_reasons' => '\Linnworks\ReturnsRefunds\Model\ChannelReason[]',
        'sub_statuses' => '\Linnworks\ReturnsRefunds\Model\PostSaleSubStatus[]',
        'refund_options' => '\Linnworks\ReturnsRefunds\Model\RefundOptions',
        'cannot_return_reason' => 'string',
        'order' => '\Linnworks\ReturnsRefunds\Model\OrderDetails',
        'rma_header' => '\Linnworks\ReturnsRefunds\Model\OrderRMAHeader',
        'all_existing_rmas' => '\Linnworks\ReturnsRefunds\Model\VerifiedRMAItem[]',
        'errors' => 'string[]',
        'info' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'can_send_rejection_if_deleted' => null,
        'can_return' => null,
        'can_return_internally' => null,
        'must_have_refund' => null,
        'refund_auto_populated' => null,
        'can_have_refund' => null,
        'return_reasons' => null,
        'rejection_reasons' => null,
        'sub_statuses' => null,
        'refund_options' => null,
        'cannot_return_reason' => null,
        'order' => null,
        'rma_header' => null,
        'all_existing_rmas' => null,
        'errors' => null,
        'info' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'can_send_rejection_if_deleted' => false,
        'can_return' => false,
        'can_return_internally' => false,
        'must_have_refund' => false,
        'refund_auto_populated' => false,
        'can_have_refund' => false,
        'return_reasons' => false,
        'rejection_reasons' => false,
        'sub_statuses' => false,
        'refund_options' => false,
        'cannot_return_reason' => false,
        'order' => false,
        'rma_header' => false,
        'all_existing_rmas' => false,
        'errors' => false,
        'info' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'can_send_rejection_if_deleted' => 'CanSendRejectionIfDeleted',
        'can_return' => 'CanReturn',
        'can_return_internally' => 'CanReturnInternally',
        'must_have_refund' => 'MustHaveRefund',
        'refund_auto_populated' => 'RefundAutoPopulated',
        'can_have_refund' => 'CanHaveRefund',
        'return_reasons' => 'ReturnReasons',
        'rejection_reasons' => 'RejectionReasons',
        'sub_statuses' => 'SubStatuses',
        'refund_options' => 'RefundOptions',
        'cannot_return_reason' => 'CannotReturnReason',
        'order' => 'Order',
        'rma_header' => 'RMAHeader',
        'all_existing_rmas' => 'AllExistingRMAs',
        'errors' => 'Errors',
        'info' => 'Info'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'can_send_rejection_if_deleted' => 'setCanSendRejectionIfDeleted',
        'can_return' => 'setCanReturn',
        'can_return_internally' => 'setCanReturnInternally',
        'must_have_refund' => 'setMustHaveRefund',
        'refund_auto_populated' => 'setRefundAutoPopulated',
        'can_have_refund' => 'setCanHaveRefund',
        'return_reasons' => 'setReturnReasons',
        'rejection_reasons' => 'setRejectionReasons',
        'sub_statuses' => 'setSubStatuses',
        'refund_options' => 'setRefundOptions',
        'cannot_return_reason' => 'setCannotReturnReason',
        'order' => 'setOrder',
        'rma_header' => 'setRmaHeader',
        'all_existing_rmas' => 'setAllExistingRmas',
        'errors' => 'setErrors',
        'info' => 'setInfo'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'can_send_rejection_if_deleted' => 'getCanSendRejectionIfDeleted',
        'can_return' => 'getCanReturn',
        'can_return_internally' => 'getCanReturnInternally',
        'must_have_refund' => 'getMustHaveRefund',
        'refund_auto_populated' => 'getRefundAutoPopulated',
        'can_have_refund' => 'getCanHaveRefund',
        'return_reasons' => 'getReturnReasons',
        'rejection_reasons' => 'getRejectionReasons',
        'sub_statuses' => 'getSubStatuses',
        'refund_options' => 'getRefundOptions',
        'cannot_return_reason' => 'getCannotReturnReason',
        'order' => 'getOrder',
        'rma_header' => 'getRmaHeader',
        'all_existing_rmas' => 'getAllExistingRmas',
        'errors' => 'getErrors',
        'info' => 'getInfo'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CANNOT_RETURN_REASON_NONE = 'None';
    public const CANNOT_RETURN_REASON_NOT_IMPLEMENTED = 'NotImplemented';
    public const CANNOT_RETURN_REASON_DISABLED_IN_CONFIG = 'DisabledInConfig';
    public const CANNOT_RETURN_REASON_MISSING_ORDER_IN_LINNWORKS = 'MissingOrderInLinnworks';
    public const CANNOT_RETURN_REASON_OPEN_ORDER_IN_LINNWORKS = 'OpenOrderInLinnworks';
    public const CANNOT_RETURN_REASON_ALREADY_RETURNED_ON_CHANNEL = 'AlreadyReturnedOnChannel';
    public const CANNOT_RETURN_REASON_ALREADY_RETURNED_IN_LINNWORKS = 'AlreadyReturnedInLinnworks';
    public const CANNOT_RETURN_REASON_NO_NEW_RMAS_SPECIFIED = 'NoNewRMAsSpecified';
    public const CANNOT_RETURN_REASON_SUB_STATUS_TAG_NOT_IN_THE_SYSTEM = 'SubStatusTagNotInTheSystem';
    public const CANNOT_RETURN_REASON_SUB_STATUS_TAG_IS_NOT_ACTIONABLE = 'SubStatusTagIsNotActionable';
    public const CANNOT_RETURN_REASON_MULTIPLE_SUB_STATUS_TAGS = 'MultipleSubStatusTags';
    public const CANNOT_RETURN_REASON_OTHER = 'Other';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCannotReturnReasonAllowableValues()
    {
        return [
            self::CANNOT_RETURN_REASON_NONE,
            self::CANNOT_RETURN_REASON_NOT_IMPLEMENTED,
            self::CANNOT_RETURN_REASON_DISABLED_IN_CONFIG,
            self::CANNOT_RETURN_REASON_MISSING_ORDER_IN_LINNWORKS,
            self::CANNOT_RETURN_REASON_OPEN_ORDER_IN_LINNWORKS,
            self::CANNOT_RETURN_REASON_ALREADY_RETURNED_ON_CHANNEL,
            self::CANNOT_RETURN_REASON_ALREADY_RETURNED_IN_LINNWORKS,
            self::CANNOT_RETURN_REASON_NO_NEW_RMAS_SPECIFIED,
            self::CANNOT_RETURN_REASON_SUB_STATUS_TAG_NOT_IN_THE_SYSTEM,
            self::CANNOT_RETURN_REASON_SUB_STATUS_TAG_IS_NOT_ACTIONABLE,
            self::CANNOT_RETURN_REASON_MULTIPLE_SUB_STATUS_TAGS,
            self::CANNOT_RETURN_REASON_OTHER,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('can_send_rejection_if_deleted', $data ?? [], null);
        $this->setIfExists('can_return', $data ?? [], null);
        $this->setIfExists('can_return_internally', $data ?? [], null);
        $this->setIfExists('must_have_refund', $data ?? [], null);
        $this->setIfExists('refund_auto_populated', $data ?? [], null);
        $this->setIfExists('can_have_refund', $data ?? [], null);
        $this->setIfExists('return_reasons', $data ?? [], null);
        $this->setIfExists('rejection_reasons', $data ?? [], null);
        $this->setIfExists('sub_statuses', $data ?? [], null);
        $this->setIfExists('refund_options', $data ?? [], null);
        $this->setIfExists('cannot_return_reason', $data ?? [], null);
        $this->setIfExists('order', $data ?? [], null);
        $this->setIfExists('rma_header', $data ?? [], null);
        $this->setIfExists('all_existing_rmas', $data ?? [], null);
        $this->setIfExists('errors', $data ?? [], null);
        $this->setIfExists('info', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getCannotReturnReasonAllowableValues();
        if (!is_null($this->container['cannot_return_reason']) && !in_array($this->container['cannot_return_reason'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'cannot_return_reason', must be one of '%s'",
                $this->container['cannot_return_reason'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets can_send_rejection_if_deleted
     *
     * @return bool|null
     */
    public function getCanSendRejectionIfDeleted()
    {
        return $this->container['can_send_rejection_if_deleted'];
    }

    /**
     * Sets can_send_rejection_if_deleted
     *
     * @param bool|null $can_send_rejection_if_deleted can_send_rejection_if_deleted
     *
     * @return self
     */
    public function setCanSendRejectionIfDeleted($can_send_rejection_if_deleted)
    {
        if (is_null($can_send_rejection_if_deleted)) {
            throw new \InvalidArgumentException('non-nullable can_send_rejection_if_deleted cannot be null');
        }
        $this->container['can_send_rejection_if_deleted'] = $can_send_rejection_if_deleted;

        return $this;
    }

    /**
     * Gets can_return
     *
     * @return bool|null
     */
    public function getCanReturn()
    {
        return $this->container['can_return'];
    }

    /**
     * Sets can_return
     *
     * @param bool|null $can_return can_return
     *
     * @return self
     */
    public function setCanReturn($can_return)
    {
        if (is_null($can_return)) {
            throw new \InvalidArgumentException('non-nullable can_return cannot be null');
        }
        $this->container['can_return'] = $can_return;

        return $this;
    }

    /**
     * Gets can_return_internally
     *
     * @return bool|null
     */
    public function getCanReturnInternally()
    {
        return $this->container['can_return_internally'];
    }

    /**
     * Sets can_return_internally
     *
     * @param bool|null $can_return_internally can_return_internally
     *
     * @return self
     */
    public function setCanReturnInternally($can_return_internally)
    {
        if (is_null($can_return_internally)) {
            throw new \InvalidArgumentException('non-nullable can_return_internally cannot be null');
        }
        $this->container['can_return_internally'] = $can_return_internally;

        return $this;
    }

    /**
     * Gets must_have_refund
     *
     * @return bool|null
     */
    public function getMustHaveRefund()
    {
        return $this->container['must_have_refund'];
    }

    /**
     * Sets must_have_refund
     *
     * @param bool|null $must_have_refund must_have_refund
     *
     * @return self
     */
    public function setMustHaveRefund($must_have_refund)
    {
        if (is_null($must_have_refund)) {
            throw new \InvalidArgumentException('non-nullable must_have_refund cannot be null');
        }
        $this->container['must_have_refund'] = $must_have_refund;

        return $this;
    }

    /**
     * Gets refund_auto_populated
     *
     * @return bool|null
     */
    public function getRefundAutoPopulated()
    {
        return $this->container['refund_auto_populated'];
    }

    /**
     * Sets refund_auto_populated
     *
     * @param bool|null $refund_auto_populated refund_auto_populated
     *
     * @return self
     */
    public function setRefundAutoPopulated($refund_auto_populated)
    {
        if (is_null($refund_auto_populated)) {
            throw new \InvalidArgumentException('non-nullable refund_auto_populated cannot be null');
        }
        $this->container['refund_auto_populated'] = $refund_auto_populated;

        return $this;
    }

    /**
     * Gets can_have_refund
     *
     * @return bool|null
     */
    public function getCanHaveRefund()
    {
        return $this->container['can_have_refund'];
    }

    /**
     * Sets can_have_refund
     *
     * @param bool|null $can_have_refund can_have_refund
     *
     * @return self
     */
    public function setCanHaveRefund($can_have_refund)
    {
        if (is_null($can_have_refund)) {
            throw new \InvalidArgumentException('non-nullable can_have_refund cannot be null');
        }
        $this->container['can_have_refund'] = $can_have_refund;

        return $this;
    }

    /**
     * Gets return_reasons
     *
     * @return \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null
     */
    public function getReturnReasons()
    {
        return $this->container['return_reasons'];
    }

    /**
     * Sets return_reasons
     *
     * @param \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null $return_reasons return_reasons
     *
     * @return self
     */
    public function setReturnReasons($return_reasons)
    {
        if (is_null($return_reasons)) {
            throw new \InvalidArgumentException('non-nullable return_reasons cannot be null');
        }
        $this->container['return_reasons'] = $return_reasons;

        return $this;
    }

    /**
     * Gets rejection_reasons
     *
     * @return \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null
     */
    public function getRejectionReasons()
    {
        return $this->container['rejection_reasons'];
    }

    /**
     * Sets rejection_reasons
     *
     * @param \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null $rejection_reasons rejection_reasons
     *
     * @return self
     */
    public function setRejectionReasons($rejection_reasons)
    {
        if (is_null($rejection_reasons)) {
            throw new \InvalidArgumentException('non-nullable rejection_reasons cannot be null');
        }
        $this->container['rejection_reasons'] = $rejection_reasons;

        return $this;
    }

    /**
     * Gets sub_statuses
     *
     * @return \Linnworks\ReturnsRefunds\Model\PostSaleSubStatus[]|null
     */
    public function getSubStatuses()
    {
        return $this->container['sub_statuses'];
    }

    /**
     * Sets sub_statuses
     *
     * @param \Linnworks\ReturnsRefunds\Model\PostSaleSubStatus[]|null $sub_statuses sub_statuses
     *
     * @return self
     */
    public function setSubStatuses($sub_statuses)
    {
        if (is_null($sub_statuses)) {
            throw new \InvalidArgumentException('non-nullable sub_statuses cannot be null');
        }
        $this->container['sub_statuses'] = $sub_statuses;

        return $this;
    }

    /**
     * Gets refund_options
     *
     * @return \Linnworks\ReturnsRefunds\Model\RefundOptions|null
     */
    public function getRefundOptions()
    {
        return $this->container['refund_options'];
    }

    /**
     * Sets refund_options
     *
     * @param \Linnworks\ReturnsRefunds\Model\RefundOptions|null $refund_options refund_options
     *
     * @return self
     */
    public function setRefundOptions($refund_options)
    {
        if (is_null($refund_options)) {
            throw new \InvalidArgumentException('non-nullable refund_options cannot be null');
        }
        $this->container['refund_options'] = $refund_options;

        return $this;
    }

    /**
     * Gets cannot_return_reason
     *
     * @return string|null
     */
    public function getCannotReturnReason()
    {
        return $this->container['cannot_return_reason'];
    }

    /**
     * Sets cannot_return_reason
     *
     * @param string|null $cannot_return_reason cannot_return_reason
     *
     * @return self
     */
    public function setCannotReturnReason($cannot_return_reason)
    {
        if (is_null($cannot_return_reason)) {
            throw new \InvalidArgumentException('non-nullable cannot_return_reason cannot be null');
        }
        $allowedValues = $this->getCannotReturnReasonAllowableValues();
        if (!in_array($cannot_return_reason, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'cannot_return_reason', must be one of '%s'",
                    $cannot_return_reason,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['cannot_return_reason'] = $cannot_return_reason;

        return $this;
    }

    /**
     * Gets order
     *
     * @return \Linnworks\ReturnsRefunds\Model\OrderDetails|null
     */
    public function getOrder()
    {
        return $this->container['order'];
    }

    /**
     * Sets order
     *
     * @param \Linnworks\ReturnsRefunds\Model\OrderDetails|null $order order
     *
     * @return self
     */
    public function setOrder($order)
    {
        if (is_null($order)) {
            throw new \InvalidArgumentException('non-nullable order cannot be null');
        }
        $this->container['order'] = $order;

        return $this;
    }

    /**
     * Gets rma_header
     *
     * @return \Linnworks\ReturnsRefunds\Model\OrderRMAHeader|null
     */
    public function getRmaHeader()
    {
        return $this->container['rma_header'];
    }

    /**
     * Sets rma_header
     *
     * @param \Linnworks\ReturnsRefunds\Model\OrderRMAHeader|null $rma_header rma_header
     *
     * @return self
     */
    public function setRmaHeader($rma_header)
    {
        if (is_null($rma_header)) {
            throw new \InvalidArgumentException('non-nullable rma_header cannot be null');
        }
        $this->container['rma_header'] = $rma_header;

        return $this;
    }

    /**
     * Gets all_existing_rmas
     *
     * @return \Linnworks\ReturnsRefunds\Model\VerifiedRMAItem[]|null
     */
    public function getAllExistingRmas()
    {
        return $this->container['all_existing_rmas'];
    }

    /**
     * Sets all_existing_rmas
     *
     * @param \Linnworks\ReturnsRefunds\Model\VerifiedRMAItem[]|null $all_existing_rmas all_existing_rmas
     *
     * @return self
     */
    public function setAllExistingRmas($all_existing_rmas)
    {
        if (is_null($all_existing_rmas)) {
            throw new \InvalidArgumentException('non-nullable all_existing_rmas cannot be null');
        }
        $this->container['all_existing_rmas'] = $all_existing_rmas;

        return $this;
    }

    /**
     * Gets errors
     *
     * @return string[]|null
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     *
     * @param string[]|null $errors errors
     *
     * @return self
     */
    public function setErrors($errors)
    {
        if (is_null($errors)) {
            throw new \InvalidArgumentException('non-nullable errors cannot be null');
        }
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets info
     *
     * @return string[]|null
     */
    public function getInfo()
    {
        return $this->container['info'];
    }

    /**
     * Sets info
     *
     * @param string[]|null $info info
     *
     * @return self
     */
    public function setInfo($info)
    {
        if (is_null($info)) {
            throw new \InvalidArgumentException('non-nullable info cannot be null');
        }
        $this->container['info'] = $info;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


