<?php
/**
 * RefundOrder
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * RefundOrder Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RefundOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RefundOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_order_id' => 'string',
        'n_order_id' => 'int',
        'c_full_name' => 'string',
        'source' => 'string',
        'sub_source' => 'string',
        'amount' => 'float',
        'issue_refund_url' => 'string',
        'c_currency' => 'string',
        'reference_num' => 'string',
        'secondary_reference' => 'string',
        'refund_reference' => 'string',
        'refund_date' => '\DateTime',
        'sub_total' => 'float',
        'total' => 'float',
        'tax_rate' => 'float'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_order_id' => 'uuid',
        'n_order_id' => 'int32',
        'c_full_name' => null,
        'source' => null,
        'sub_source' => null,
        'amount' => 'double',
        'issue_refund_url' => null,
        'c_currency' => null,
        'reference_num' => null,
        'secondary_reference' => null,
        'refund_reference' => null,
        'refund_date' => 'date-time',
        'sub_total' => 'double',
        'total' => 'double',
        'tax_rate' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_order_id' => false,
        'n_order_id' => false,
        'c_full_name' => false,
        'source' => false,
        'sub_source' => false,
        'amount' => false,
        'issue_refund_url' => false,
        'c_currency' => false,
        'reference_num' => false,
        'secondary_reference' => false,
        'refund_reference' => false,
        'refund_date' => false,
        'sub_total' => false,
        'total' => false,
        'tax_rate' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_order_id' => 'pkOrderID',
        'n_order_id' => 'nOrderId',
        'c_full_name' => 'cFullName',
        'source' => 'Source',
        'sub_source' => 'SubSource',
        'amount' => 'Amount',
        'issue_refund_url' => 'IssueRefundUrl',
        'c_currency' => 'cCurrency',
        'reference_num' => 'ReferenceNum',
        'secondary_reference' => 'SecondaryReference',
        'refund_reference' => 'RefundReference',
        'refund_date' => 'RefundDate',
        'sub_total' => 'SubTotal',
        'total' => 'Total',
        'tax_rate' => 'TaxRate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_order_id' => 'setPkOrderId',
        'n_order_id' => 'setNOrderId',
        'c_full_name' => 'setCFullName',
        'source' => 'setSource',
        'sub_source' => 'setSubSource',
        'amount' => 'setAmount',
        'issue_refund_url' => 'setIssueRefundUrl',
        'c_currency' => 'setCCurrency',
        'reference_num' => 'setReferenceNum',
        'secondary_reference' => 'setSecondaryReference',
        'refund_reference' => 'setRefundReference',
        'refund_date' => 'setRefundDate',
        'sub_total' => 'setSubTotal',
        'total' => 'setTotal',
        'tax_rate' => 'setTaxRate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_order_id' => 'getPkOrderId',
        'n_order_id' => 'getNOrderId',
        'c_full_name' => 'getCFullName',
        'source' => 'getSource',
        'sub_source' => 'getSubSource',
        'amount' => 'getAmount',
        'issue_refund_url' => 'getIssueRefundUrl',
        'c_currency' => 'getCCurrency',
        'reference_num' => 'getReferenceNum',
        'secondary_reference' => 'getSecondaryReference',
        'refund_reference' => 'getRefundReference',
        'refund_date' => 'getRefundDate',
        'sub_total' => 'getSubTotal',
        'total' => 'getTotal',
        'tax_rate' => 'getTaxRate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_order_id', $data ?? [], null);
        $this->setIfExists('n_order_id', $data ?? [], null);
        $this->setIfExists('c_full_name', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('amount', $data ?? [], null);
        $this->setIfExists('issue_refund_url', $data ?? [], null);
        $this->setIfExists('c_currency', $data ?? [], null);
        $this->setIfExists('reference_num', $data ?? [], null);
        $this->setIfExists('secondary_reference', $data ?? [], null);
        $this->setIfExists('refund_reference', $data ?? [], null);
        $this->setIfExists('refund_date', $data ?? [], null);
        $this->setIfExists('sub_total', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_order_id
     *
     * @return string|null
     */
    public function getPkOrderId()
    {
        return $this->container['pk_order_id'];
    }

    /**
     * Sets pk_order_id
     *
     * @param string|null $pk_order_id Order ID (unique order identifier)
     *
     * @return self
     */
    public function setPkOrderId($pk_order_id)
    {
        if (is_null($pk_order_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_id cannot be null');
        }
        $this->container['pk_order_id'] = $pk_order_id;

        return $this;
    }

    /**
     * Gets n_order_id
     *
     * @return int|null
     */
    public function getNOrderId()
    {
        return $this->container['n_order_id'];
    }

    /**
     * Sets n_order_id
     *
     * @param int|null $n_order_id Linnworks order ID
     *
     * @return self
     */
    public function setNOrderId($n_order_id)
    {
        if (is_null($n_order_id)) {
            throw new \InvalidArgumentException('non-nullable n_order_id cannot be null');
        }
        $this->container['n_order_id'] = $n_order_id;

        return $this;
    }

    /**
     * Gets c_full_name
     *
     * @return string|null
     */
    public function getCFullName()
    {
        return $this->container['c_full_name'];
    }

    /**
     * Sets c_full_name
     *
     * @param string|null $c_full_name Customer name
     *
     * @return self
     */
    public function setCFullName($c_full_name)
    {
        if (is_null($c_full_name)) {
            throw new \InvalidArgumentException('non-nullable c_full_name cannot be null');
        }
        $this->container['c_full_name'] = $c_full_name;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source ChannelName/Source (e.g. AMAZON)
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source sub_source
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float|null $amount Refund amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        if (is_null($amount)) {
            throw new \InvalidArgumentException('non-nullable amount cannot be null');
        }
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets issue_refund_url
     *
     * @return string|null
     */
    public function getIssueRefundUrl()
    {
        return $this->container['issue_refund_url'];
    }

    /**
     * Sets issue_refund_url
     *
     * @param string|null $issue_refund_url Refund URL
     *
     * @return self
     */
    public function setIssueRefundUrl($issue_refund_url)
    {
        if (is_null($issue_refund_url)) {
            throw new \InvalidArgumentException('non-nullable issue_refund_url cannot be null');
        }
        $this->container['issue_refund_url'] = $issue_refund_url;

        return $this;
    }

    /**
     * Gets c_currency
     *
     * @return string|null
     */
    public function getCCurrency()
    {
        return $this->container['c_currency'];
    }

    /**
     * Sets c_currency
     *
     * @param string|null $c_currency Refund currency
     *
     * @return self
     */
    public function setCCurrency($c_currency)
    {
        if (is_null($c_currency)) {
            throw new \InvalidArgumentException('non-nullable c_currency cannot be null');
        }
        $this->container['c_currency'] = $c_currency;

        return $this;
    }

    /**
     * Gets reference_num
     *
     * @return string|null
     */
    public function getReferenceNum()
    {
        return $this->container['reference_num'];
    }

    /**
     * Sets reference_num
     *
     * @param string|null $reference_num Order reference number
     *
     * @return self
     */
    public function setReferenceNum($reference_num)
    {
        if (is_null($reference_num)) {
            throw new \InvalidArgumentException('non-nullable reference_num cannot be null');
        }
        $this->container['reference_num'] = $reference_num;

        return $this;
    }

    /**
     * Gets secondary_reference
     *
     * @return string|null
     */
    public function getSecondaryReference()
    {
        return $this->container['secondary_reference'];
    }

    /**
     * Sets secondary_reference
     *
     * @param string|null $secondary_reference Order secondary reference number
     *
     * @return self
     */
    public function setSecondaryReference($secondary_reference)
    {
        if (is_null($secondary_reference)) {
            throw new \InvalidArgumentException('non-nullable secondary_reference cannot be null');
        }
        $this->container['secondary_reference'] = $secondary_reference;

        return $this;
    }

    /**
     * Gets refund_reference
     *
     * @return string|null
     */
    public function getRefundReference()
    {
        return $this->container['refund_reference'];
    }

    /**
     * Sets refund_reference
     *
     * @param string|null $refund_reference Refund reference number
     *
     * @return self
     */
    public function setRefundReference($refund_reference)
    {
        if (is_null($refund_reference)) {
            throw new \InvalidArgumentException('non-nullable refund_reference cannot be null');
        }
        $this->container['refund_reference'] = $refund_reference;

        return $this;
    }

    /**
     * Gets refund_date
     *
     * @return \DateTime|null
     */
    public function getRefundDate()
    {
        return $this->container['refund_date'];
    }

    /**
     * Sets refund_date
     *
     * @param \DateTime|null $refund_date Date when refund were made
     *
     * @return self
     */
    public function setRefundDate($refund_date)
    {
        if (is_null($refund_date)) {
            throw new \InvalidArgumentException('non-nullable refund_date cannot be null');
        }
        $this->container['refund_date'] = $refund_date;

        return $this;
    }

    /**
     * Gets sub_total
     *
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param float|null $sub_total sub_total
     *
     * @return self
     */
    public function setSubTotal($sub_total)
    {
        if (is_null($sub_total)) {
            throw new \InvalidArgumentException('non-nullable sub_total cannot be null');
        }
        $this->container['sub_total'] = $sub_total;

        return $this;
    }

    /**
     * Gets total
     *
     * @return float|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param float|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


