<?php
/**
 * RefundOptions
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * RefundOptions Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RefundOptions implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RefundOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'can_send_rejection_if_deleted' => 'bool',
        'can_refund' => 'bool',
        'can_refund_internally' => 'bool',
        'can_refund_items' => 'bool',
        'can_refund_services' => 'bool',
        'can_refund_shipping' => 'bool',
        'can_refund_shipping_independently' => 'bool',
        'can_refund_additionally' => 'bool',
        'can_refund_free_text' => 'bool',
        'can_insufficient_refund_free_text' => 'bool',
        'refund_free_text_or_note_max_length' => 'int',
        'sub_statuses' => '\Linnworks\ReturnsRefunds\Model\PostSaleSubStatus[]',
        'insufficient_refund_reasons' => '\Linnworks\ReturnsRefunds\Model\ChannelReason[]',
        'item_refund_reasons' => '\Linnworks\ReturnsRefunds\Model\ChannelReason[]',
        'service_refund_reasons' => '\Linnworks\ReturnsRefunds\Model\ChannelReason[]',
        'shipping_refund_reasons' => '\Linnworks\ReturnsRefunds\Model\ChannelReason[]',
        'itemized_refund_reasons' => '\Linnworks\ReturnsRefunds\Model\ItemizedRefundReason[]',
        'rejection_reasons' => '\Linnworks\ReturnsRefunds\Model\ChannelReason[]',
        'cannot_refund_reason' => 'string',
        'order' => '\Linnworks\ReturnsRefunds\Model\OrderDetails',
        'refund_header' => '\Linnworks\ReturnsRefunds\Model\OrderRefundHeader',
        'all_existing_refunds' => '\Linnworks\ReturnsRefunds\Model\VerifiedRefund[]',
        'errors' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'can_send_rejection_if_deleted' => null,
        'can_refund' => null,
        'can_refund_internally' => null,
        'can_refund_items' => null,
        'can_refund_services' => null,
        'can_refund_shipping' => null,
        'can_refund_shipping_independently' => null,
        'can_refund_additionally' => null,
        'can_refund_free_text' => null,
        'can_insufficient_refund_free_text' => null,
        'refund_free_text_or_note_max_length' => 'int32',
        'sub_statuses' => null,
        'insufficient_refund_reasons' => null,
        'item_refund_reasons' => null,
        'service_refund_reasons' => null,
        'shipping_refund_reasons' => null,
        'itemized_refund_reasons' => null,
        'rejection_reasons' => null,
        'cannot_refund_reason' => null,
        'order' => null,
        'refund_header' => null,
        'all_existing_refunds' => null,
        'errors' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'can_send_rejection_if_deleted' => false,
        'can_refund' => false,
        'can_refund_internally' => false,
        'can_refund_items' => false,
        'can_refund_services' => false,
        'can_refund_shipping' => false,
        'can_refund_shipping_independently' => false,
        'can_refund_additionally' => false,
        'can_refund_free_text' => false,
        'can_insufficient_refund_free_text' => false,
        'refund_free_text_or_note_max_length' => false,
        'sub_statuses' => false,
        'insufficient_refund_reasons' => false,
        'item_refund_reasons' => false,
        'service_refund_reasons' => false,
        'shipping_refund_reasons' => false,
        'itemized_refund_reasons' => false,
        'rejection_reasons' => false,
        'cannot_refund_reason' => false,
        'order' => false,
        'refund_header' => false,
        'all_existing_refunds' => false,
        'errors' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'can_send_rejection_if_deleted' => 'CanSendRejectionIfDeleted',
        'can_refund' => 'CanRefund',
        'can_refund_internally' => 'CanRefundInternally',
        'can_refund_items' => 'CanRefundItems',
        'can_refund_services' => 'CanRefundServices',
        'can_refund_shipping' => 'CanRefundShipping',
        'can_refund_shipping_independently' => 'CanRefundShippingIndependently',
        'can_refund_additionally' => 'CanRefundAdditionally',
        'can_refund_free_text' => 'CanRefundFreeText',
        'can_insufficient_refund_free_text' => 'CanInsufficientRefundFreeText',
        'refund_free_text_or_note_max_length' => 'RefundFreeTextOrNoteMaxLength',
        'sub_statuses' => 'SubStatuses',
        'insufficient_refund_reasons' => 'InsufficientRefundReasons',
        'item_refund_reasons' => 'ItemRefundReasons',
        'service_refund_reasons' => 'ServiceRefundReasons',
        'shipping_refund_reasons' => 'ShippingRefundReasons',
        'itemized_refund_reasons' => 'ItemizedRefundReasons',
        'rejection_reasons' => 'RejectionReasons',
        'cannot_refund_reason' => 'CannotRefundReason',
        'order' => 'Order',
        'refund_header' => 'RefundHeader',
        'all_existing_refunds' => 'AllExistingRefunds',
        'errors' => 'Errors'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'can_send_rejection_if_deleted' => 'setCanSendRejectionIfDeleted',
        'can_refund' => 'setCanRefund',
        'can_refund_internally' => 'setCanRefundInternally',
        'can_refund_items' => 'setCanRefundItems',
        'can_refund_services' => 'setCanRefundServices',
        'can_refund_shipping' => 'setCanRefundShipping',
        'can_refund_shipping_independently' => 'setCanRefundShippingIndependently',
        'can_refund_additionally' => 'setCanRefundAdditionally',
        'can_refund_free_text' => 'setCanRefundFreeText',
        'can_insufficient_refund_free_text' => 'setCanInsufficientRefundFreeText',
        'refund_free_text_or_note_max_length' => 'setRefundFreeTextOrNoteMaxLength',
        'sub_statuses' => 'setSubStatuses',
        'insufficient_refund_reasons' => 'setInsufficientRefundReasons',
        'item_refund_reasons' => 'setItemRefundReasons',
        'service_refund_reasons' => 'setServiceRefundReasons',
        'shipping_refund_reasons' => 'setShippingRefundReasons',
        'itemized_refund_reasons' => 'setItemizedRefundReasons',
        'rejection_reasons' => 'setRejectionReasons',
        'cannot_refund_reason' => 'setCannotRefundReason',
        'order' => 'setOrder',
        'refund_header' => 'setRefundHeader',
        'all_existing_refunds' => 'setAllExistingRefunds',
        'errors' => 'setErrors'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'can_send_rejection_if_deleted' => 'getCanSendRejectionIfDeleted',
        'can_refund' => 'getCanRefund',
        'can_refund_internally' => 'getCanRefundInternally',
        'can_refund_items' => 'getCanRefundItems',
        'can_refund_services' => 'getCanRefundServices',
        'can_refund_shipping' => 'getCanRefundShipping',
        'can_refund_shipping_independently' => 'getCanRefundShippingIndependently',
        'can_refund_additionally' => 'getCanRefundAdditionally',
        'can_refund_free_text' => 'getCanRefundFreeText',
        'can_insufficient_refund_free_text' => 'getCanInsufficientRefundFreeText',
        'refund_free_text_or_note_max_length' => 'getRefundFreeTextOrNoteMaxLength',
        'sub_statuses' => 'getSubStatuses',
        'insufficient_refund_reasons' => 'getInsufficientRefundReasons',
        'item_refund_reasons' => 'getItemRefundReasons',
        'service_refund_reasons' => 'getServiceRefundReasons',
        'shipping_refund_reasons' => 'getShippingRefundReasons',
        'itemized_refund_reasons' => 'getItemizedRefundReasons',
        'rejection_reasons' => 'getRejectionReasons',
        'cannot_refund_reason' => 'getCannotRefundReason',
        'order' => 'getOrder',
        'refund_header' => 'getRefundHeader',
        'all_existing_refunds' => 'getAllExistingRefunds',
        'errors' => 'getErrors'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CANNOT_REFUND_REASON_NONE = 'None';
    public const CANNOT_REFUND_REASON_NOT_IMPLEMENTED = 'NotImplemented';
    public const CANNOT_REFUND_REASON_DISABLED_IN_CONFIG = 'DisabledInConfig';
    public const CANNOT_REFUND_REASON_MISSING_ORDER_IN_LINNWORKS = 'MissingOrderInLinnworks';
    public const CANNOT_REFUND_REASON_OPEN_ORDER_IN_LINNWORKS = 'OpenOrderInLinnworks';
    public const CANNOT_REFUND_REASON_ORDER_IS_FULLY_REFUNDED_IN_LINNWORKS = 'OrderIsFullyRefundedInLinnworks';
    public const CANNOT_REFUND_REASON_NO_NEW_REFUNDS_SPECIFIED = 'NoNewRefundsSpecified';
    public const CANNOT_REFUND_REASON_NO_UPDATED_REFUNDS_SPECIFIED = 'NoUpdatedRefundsSpecified';
    public const CANNOT_REFUND_REASON_MULTIPLE_REFERENCES = 'MultipleReferences';
    public const CANNOT_REFUND_REASON_SUB_STATUS_TAG_NOT_IN_THE_SYSTEM = 'SubStatusTagNotInTheSystem';
    public const CANNOT_REFUND_REASON_SUB_STATUS_TAG_IS_NOT_ACTIONABLE = 'SubStatusTagIsNotActionable';
    public const CANNOT_REFUND_REASON_MULTIPLE_SUB_STATUS_TAGS = 'MultipleSubStatusTags';
    public const CANNOT_REFUND_REASON_REFUND_NOT_IN_SYSTEM = 'RefundNotInSystem';
    public const CANNOT_REFUND_REASON_OTHER = 'Other';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCannotRefundReasonAllowableValues()
    {
        return [
            self::CANNOT_REFUND_REASON_NONE,
            self::CANNOT_REFUND_REASON_NOT_IMPLEMENTED,
            self::CANNOT_REFUND_REASON_DISABLED_IN_CONFIG,
            self::CANNOT_REFUND_REASON_MISSING_ORDER_IN_LINNWORKS,
            self::CANNOT_REFUND_REASON_OPEN_ORDER_IN_LINNWORKS,
            self::CANNOT_REFUND_REASON_ORDER_IS_FULLY_REFUNDED_IN_LINNWORKS,
            self::CANNOT_REFUND_REASON_NO_NEW_REFUNDS_SPECIFIED,
            self::CANNOT_REFUND_REASON_NO_UPDATED_REFUNDS_SPECIFIED,
            self::CANNOT_REFUND_REASON_MULTIPLE_REFERENCES,
            self::CANNOT_REFUND_REASON_SUB_STATUS_TAG_NOT_IN_THE_SYSTEM,
            self::CANNOT_REFUND_REASON_SUB_STATUS_TAG_IS_NOT_ACTIONABLE,
            self::CANNOT_REFUND_REASON_MULTIPLE_SUB_STATUS_TAGS,
            self::CANNOT_REFUND_REASON_REFUND_NOT_IN_SYSTEM,
            self::CANNOT_REFUND_REASON_OTHER,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('can_send_rejection_if_deleted', $data ?? [], null);
        $this->setIfExists('can_refund', $data ?? [], null);
        $this->setIfExists('can_refund_internally', $data ?? [], null);
        $this->setIfExists('can_refund_items', $data ?? [], null);
        $this->setIfExists('can_refund_services', $data ?? [], null);
        $this->setIfExists('can_refund_shipping', $data ?? [], null);
        $this->setIfExists('can_refund_shipping_independently', $data ?? [], null);
        $this->setIfExists('can_refund_additionally', $data ?? [], null);
        $this->setIfExists('can_refund_free_text', $data ?? [], null);
        $this->setIfExists('can_insufficient_refund_free_text', $data ?? [], null);
        $this->setIfExists('refund_free_text_or_note_max_length', $data ?? [], null);
        $this->setIfExists('sub_statuses', $data ?? [], null);
        $this->setIfExists('insufficient_refund_reasons', $data ?? [], null);
        $this->setIfExists('item_refund_reasons', $data ?? [], null);
        $this->setIfExists('service_refund_reasons', $data ?? [], null);
        $this->setIfExists('shipping_refund_reasons', $data ?? [], null);
        $this->setIfExists('itemized_refund_reasons', $data ?? [], null);
        $this->setIfExists('rejection_reasons', $data ?? [], null);
        $this->setIfExists('cannot_refund_reason', $data ?? [], null);
        $this->setIfExists('order', $data ?? [], null);
        $this->setIfExists('refund_header', $data ?? [], null);
        $this->setIfExists('all_existing_refunds', $data ?? [], null);
        $this->setIfExists('errors', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getCannotRefundReasonAllowableValues();
        if (!is_null($this->container['cannot_refund_reason']) && !in_array($this->container['cannot_refund_reason'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'cannot_refund_reason', must be one of '%s'",
                $this->container['cannot_refund_reason'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets can_send_rejection_if_deleted
     *
     * @return bool|null
     */
    public function getCanSendRejectionIfDeleted()
    {
        return $this->container['can_send_rejection_if_deleted'];
    }

    /**
     * Sets can_send_rejection_if_deleted
     *
     * @param bool|null $can_send_rejection_if_deleted can_send_rejection_if_deleted
     *
     * @return self
     */
    public function setCanSendRejectionIfDeleted($can_send_rejection_if_deleted)
    {
        if (is_null($can_send_rejection_if_deleted)) {
            throw new \InvalidArgumentException('non-nullable can_send_rejection_if_deleted cannot be null');
        }
        $this->container['can_send_rejection_if_deleted'] = $can_send_rejection_if_deleted;

        return $this;
    }

    /**
     * Gets can_refund
     *
     * @return bool|null
     */
    public function getCanRefund()
    {
        return $this->container['can_refund'];
    }

    /**
     * Sets can_refund
     *
     * @param bool|null $can_refund can_refund
     *
     * @return self
     */
    public function setCanRefund($can_refund)
    {
        if (is_null($can_refund)) {
            throw new \InvalidArgumentException('non-nullable can_refund cannot be null');
        }
        $this->container['can_refund'] = $can_refund;

        return $this;
    }

    /**
     * Gets can_refund_internally
     *
     * @return bool|null
     */
    public function getCanRefundInternally()
    {
        return $this->container['can_refund_internally'];
    }

    /**
     * Sets can_refund_internally
     *
     * @param bool|null $can_refund_internally can_refund_internally
     *
     * @return self
     */
    public function setCanRefundInternally($can_refund_internally)
    {
        if (is_null($can_refund_internally)) {
            throw new \InvalidArgumentException('non-nullable can_refund_internally cannot be null');
        }
        $this->container['can_refund_internally'] = $can_refund_internally;

        return $this;
    }

    /**
     * Gets can_refund_items
     *
     * @return bool|null
     */
    public function getCanRefundItems()
    {
        return $this->container['can_refund_items'];
    }

    /**
     * Sets can_refund_items
     *
     * @param bool|null $can_refund_items can_refund_items
     *
     * @return self
     */
    public function setCanRefundItems($can_refund_items)
    {
        if (is_null($can_refund_items)) {
            throw new \InvalidArgumentException('non-nullable can_refund_items cannot be null');
        }
        $this->container['can_refund_items'] = $can_refund_items;

        return $this;
    }

    /**
     * Gets can_refund_services
     *
     * @return bool|null
     */
    public function getCanRefundServices()
    {
        return $this->container['can_refund_services'];
    }

    /**
     * Sets can_refund_services
     *
     * @param bool|null $can_refund_services can_refund_services
     *
     * @return self
     */
    public function setCanRefundServices($can_refund_services)
    {
        if (is_null($can_refund_services)) {
            throw new \InvalidArgumentException('non-nullable can_refund_services cannot be null');
        }
        $this->container['can_refund_services'] = $can_refund_services;

        return $this;
    }

    /**
     * Gets can_refund_shipping
     *
     * @return bool|null
     */
    public function getCanRefundShipping()
    {
        return $this->container['can_refund_shipping'];
    }

    /**
     * Sets can_refund_shipping
     *
     * @param bool|null $can_refund_shipping can_refund_shipping
     *
     * @return self
     */
    public function setCanRefundShipping($can_refund_shipping)
    {
        if (is_null($can_refund_shipping)) {
            throw new \InvalidArgumentException('non-nullable can_refund_shipping cannot be null');
        }
        $this->container['can_refund_shipping'] = $can_refund_shipping;

        return $this;
    }

    /**
     * Gets can_refund_shipping_independently
     *
     * @return bool|null
     */
    public function getCanRefundShippingIndependently()
    {
        return $this->container['can_refund_shipping_independently'];
    }

    /**
     * Sets can_refund_shipping_independently
     *
     * @param bool|null $can_refund_shipping_independently can_refund_shipping_independently
     *
     * @return self
     */
    public function setCanRefundShippingIndependently($can_refund_shipping_independently)
    {
        if (is_null($can_refund_shipping_independently)) {
            throw new \InvalidArgumentException('non-nullable can_refund_shipping_independently cannot be null');
        }
        $this->container['can_refund_shipping_independently'] = $can_refund_shipping_independently;

        return $this;
    }

    /**
     * Gets can_refund_additionally
     *
     * @return bool|null
     */
    public function getCanRefundAdditionally()
    {
        return $this->container['can_refund_additionally'];
    }

    /**
     * Sets can_refund_additionally
     *
     * @param bool|null $can_refund_additionally can_refund_additionally
     *
     * @return self
     */
    public function setCanRefundAdditionally($can_refund_additionally)
    {
        if (is_null($can_refund_additionally)) {
            throw new \InvalidArgumentException('non-nullable can_refund_additionally cannot be null');
        }
        $this->container['can_refund_additionally'] = $can_refund_additionally;

        return $this;
    }

    /**
     * Gets can_refund_free_text
     *
     * @return bool|null
     */
    public function getCanRefundFreeText()
    {
        return $this->container['can_refund_free_text'];
    }

    /**
     * Sets can_refund_free_text
     *
     * @param bool|null $can_refund_free_text can_refund_free_text
     *
     * @return self
     */
    public function setCanRefundFreeText($can_refund_free_text)
    {
        if (is_null($can_refund_free_text)) {
            throw new \InvalidArgumentException('non-nullable can_refund_free_text cannot be null');
        }
        $this->container['can_refund_free_text'] = $can_refund_free_text;

        return $this;
    }

    /**
     * Gets can_insufficient_refund_free_text
     *
     * @return bool|null
     */
    public function getCanInsufficientRefundFreeText()
    {
        return $this->container['can_insufficient_refund_free_text'];
    }

    /**
     * Sets can_insufficient_refund_free_text
     *
     * @param bool|null $can_insufficient_refund_free_text can_insufficient_refund_free_text
     *
     * @return self
     */
    public function setCanInsufficientRefundFreeText($can_insufficient_refund_free_text)
    {
        if (is_null($can_insufficient_refund_free_text)) {
            throw new \InvalidArgumentException('non-nullable can_insufficient_refund_free_text cannot be null');
        }
        $this->container['can_insufficient_refund_free_text'] = $can_insufficient_refund_free_text;

        return $this;
    }

    /**
     * Gets refund_free_text_or_note_max_length
     *
     * @return int|null
     */
    public function getRefundFreeTextOrNoteMaxLength()
    {
        return $this->container['refund_free_text_or_note_max_length'];
    }

    /**
     * Sets refund_free_text_or_note_max_length
     *
     * @param int|null $refund_free_text_or_note_max_length refund_free_text_or_note_max_length
     *
     * @return self
     */
    public function setRefundFreeTextOrNoteMaxLength($refund_free_text_or_note_max_length)
    {
        if (is_null($refund_free_text_or_note_max_length)) {
            throw new \InvalidArgumentException('non-nullable refund_free_text_or_note_max_length cannot be null');
        }
        $this->container['refund_free_text_or_note_max_length'] = $refund_free_text_or_note_max_length;

        return $this;
    }

    /**
     * Gets sub_statuses
     *
     * @return \Linnworks\ReturnsRefunds\Model\PostSaleSubStatus[]|null
     */
    public function getSubStatuses()
    {
        return $this->container['sub_statuses'];
    }

    /**
     * Sets sub_statuses
     *
     * @param \Linnworks\ReturnsRefunds\Model\PostSaleSubStatus[]|null $sub_statuses sub_statuses
     *
     * @return self
     */
    public function setSubStatuses($sub_statuses)
    {
        if (is_null($sub_statuses)) {
            throw new \InvalidArgumentException('non-nullable sub_statuses cannot be null');
        }
        $this->container['sub_statuses'] = $sub_statuses;

        return $this;
    }

    /**
     * Gets insufficient_refund_reasons
     *
     * @return \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null
     */
    public function getInsufficientRefundReasons()
    {
        return $this->container['insufficient_refund_reasons'];
    }

    /**
     * Sets insufficient_refund_reasons
     *
     * @param \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null $insufficient_refund_reasons insufficient_refund_reasons
     *
     * @return self
     */
    public function setInsufficientRefundReasons($insufficient_refund_reasons)
    {
        if (is_null($insufficient_refund_reasons)) {
            throw new \InvalidArgumentException('non-nullable insufficient_refund_reasons cannot be null');
        }
        $this->container['insufficient_refund_reasons'] = $insufficient_refund_reasons;

        return $this;
    }

    /**
     * Gets item_refund_reasons
     *
     * @return \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null
     */
    public function getItemRefundReasons()
    {
        return $this->container['item_refund_reasons'];
    }

    /**
     * Sets item_refund_reasons
     *
     * @param \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null $item_refund_reasons item_refund_reasons
     *
     * @return self
     */
    public function setItemRefundReasons($item_refund_reasons)
    {
        if (is_null($item_refund_reasons)) {
            throw new \InvalidArgumentException('non-nullable item_refund_reasons cannot be null');
        }
        $this->container['item_refund_reasons'] = $item_refund_reasons;

        return $this;
    }

    /**
     * Gets service_refund_reasons
     *
     * @return \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null
     */
    public function getServiceRefundReasons()
    {
        return $this->container['service_refund_reasons'];
    }

    /**
     * Sets service_refund_reasons
     *
     * @param \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null $service_refund_reasons service_refund_reasons
     *
     * @return self
     */
    public function setServiceRefundReasons($service_refund_reasons)
    {
        if (is_null($service_refund_reasons)) {
            throw new \InvalidArgumentException('non-nullable service_refund_reasons cannot be null');
        }
        $this->container['service_refund_reasons'] = $service_refund_reasons;

        return $this;
    }

    /**
     * Gets shipping_refund_reasons
     *
     * @return \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null
     */
    public function getShippingRefundReasons()
    {
        return $this->container['shipping_refund_reasons'];
    }

    /**
     * Sets shipping_refund_reasons
     *
     * @param \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null $shipping_refund_reasons shipping_refund_reasons
     *
     * @return self
     */
    public function setShippingRefundReasons($shipping_refund_reasons)
    {
        if (is_null($shipping_refund_reasons)) {
            throw new \InvalidArgumentException('non-nullable shipping_refund_reasons cannot be null');
        }
        $this->container['shipping_refund_reasons'] = $shipping_refund_reasons;

        return $this;
    }

    /**
     * Gets itemized_refund_reasons
     *
     * @return \Linnworks\ReturnsRefunds\Model\ItemizedRefundReason[]|null
     */
    public function getItemizedRefundReasons()
    {
        return $this->container['itemized_refund_reasons'];
    }

    /**
     * Sets itemized_refund_reasons
     *
     * @param \Linnworks\ReturnsRefunds\Model\ItemizedRefundReason[]|null $itemized_refund_reasons itemized_refund_reasons
     *
     * @return self
     */
    public function setItemizedRefundReasons($itemized_refund_reasons)
    {
        if (is_null($itemized_refund_reasons)) {
            throw new \InvalidArgumentException('non-nullable itemized_refund_reasons cannot be null');
        }
        $this->container['itemized_refund_reasons'] = $itemized_refund_reasons;

        return $this;
    }

    /**
     * Gets rejection_reasons
     *
     * @return \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null
     */
    public function getRejectionReasons()
    {
        return $this->container['rejection_reasons'];
    }

    /**
     * Sets rejection_reasons
     *
     * @param \Linnworks\ReturnsRefunds\Model\ChannelReason[]|null $rejection_reasons rejection_reasons
     *
     * @return self
     */
    public function setRejectionReasons($rejection_reasons)
    {
        if (is_null($rejection_reasons)) {
            throw new \InvalidArgumentException('non-nullable rejection_reasons cannot be null');
        }
        $this->container['rejection_reasons'] = $rejection_reasons;

        return $this;
    }

    /**
     * Gets cannot_refund_reason
     *
     * @return string|null
     */
    public function getCannotRefundReason()
    {
        return $this->container['cannot_refund_reason'];
    }

    /**
     * Sets cannot_refund_reason
     *
     * @param string|null $cannot_refund_reason cannot_refund_reason
     *
     * @return self
     */
    public function setCannotRefundReason($cannot_refund_reason)
    {
        if (is_null($cannot_refund_reason)) {
            throw new \InvalidArgumentException('non-nullable cannot_refund_reason cannot be null');
        }
        $allowedValues = $this->getCannotRefundReasonAllowableValues();
        if (!in_array($cannot_refund_reason, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'cannot_refund_reason', must be one of '%s'",
                    $cannot_refund_reason,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['cannot_refund_reason'] = $cannot_refund_reason;

        return $this;
    }

    /**
     * Gets order
     *
     * @return \Linnworks\ReturnsRefunds\Model\OrderDetails|null
     */
    public function getOrder()
    {
        return $this->container['order'];
    }

    /**
     * Sets order
     *
     * @param \Linnworks\ReturnsRefunds\Model\OrderDetails|null $order order
     *
     * @return self
     */
    public function setOrder($order)
    {
        if (is_null($order)) {
            throw new \InvalidArgumentException('non-nullable order cannot be null');
        }
        $this->container['order'] = $order;

        return $this;
    }

    /**
     * Gets refund_header
     *
     * @return \Linnworks\ReturnsRefunds\Model\OrderRefundHeader|null
     */
    public function getRefundHeader()
    {
        return $this->container['refund_header'];
    }

    /**
     * Sets refund_header
     *
     * @param \Linnworks\ReturnsRefunds\Model\OrderRefundHeader|null $refund_header refund_header
     *
     * @return self
     */
    public function setRefundHeader($refund_header)
    {
        if (is_null($refund_header)) {
            throw new \InvalidArgumentException('non-nullable refund_header cannot be null');
        }
        $this->container['refund_header'] = $refund_header;

        return $this;
    }

    /**
     * Gets all_existing_refunds
     *
     * @return \Linnworks\ReturnsRefunds\Model\VerifiedRefund[]|null
     */
    public function getAllExistingRefunds()
    {
        return $this->container['all_existing_refunds'];
    }

    /**
     * Sets all_existing_refunds
     *
     * @param \Linnworks\ReturnsRefunds\Model\VerifiedRefund[]|null $all_existing_refunds all_existing_refunds
     *
     * @return self
     */
    public function setAllExistingRefunds($all_existing_refunds)
    {
        if (is_null($all_existing_refunds)) {
            throw new \InvalidArgumentException('non-nullable all_existing_refunds cannot be null');
        }
        $this->container['all_existing_refunds'] = $all_existing_refunds;

        return $this;
    }

    /**
     * Gets errors
     *
     * @return string[]|null
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     *
     * @param string[]|null $errors errors
     *
     * @return self
     */
    public function setErrors($errors)
    {
        if (is_null($errors)) {
            throw new \InvalidArgumentException('non-nullable errors cannot be null');
        }
        $this->container['errors'] = $errors;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


