<?php
/**
 * PostSaleSubStatus
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * PostSaleSubStatus Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PostSaleSubStatus implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PostSaleSubStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'status_tag' => 'string',
        'status_description' => 'string',
        'actionable' => 'bool',
        'action_description' => 'string',
        'editable_fields' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'status_tag' => null,
        'status_description' => null,
        'actionable' => null,
        'action_description' => null,
        'editable_fields' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'status_tag' => false,
        'status_description' => false,
        'actionable' => false,
        'action_description' => false,
        'editable_fields' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'status_tag' => 'StatusTag',
        'status_description' => 'StatusDescription',
        'actionable' => 'Actionable',
        'action_description' => 'ActionDescription',
        'editable_fields' => 'EditableFields'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'status_tag' => 'setStatusTag',
        'status_description' => 'setStatusDescription',
        'actionable' => 'setActionable',
        'action_description' => 'setActionDescription',
        'editable_fields' => 'setEditableFields'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'status_tag' => 'getStatusTag',
        'status_description' => 'getStatusDescription',
        'actionable' => 'getActionable',
        'action_description' => 'getActionDescription',
        'editable_fields' => 'getEditableFields'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('status_tag', $data ?? [], null);
        $this->setIfExists('status_description', $data ?? [], null);
        $this->setIfExists('actionable', $data ?? [], null);
        $this->setIfExists('action_description', $data ?? [], null);
        $this->setIfExists('editable_fields', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets status_tag
     *
     * @return string|null
     */
    public function getStatusTag()
    {
        return $this->container['status_tag'];
    }

    /**
     * Sets status_tag
     *
     * @param string|null $status_tag For an individual refund line, this identifies the line's state on the channel. For the header, if all its lines have the same StatusTag, it will also have the same StatusTag. If not,  it will determine an appropriate StatusTag based on those of its lines
     *
     * @return self
     */
    public function setStatusTag($status_tag)
    {
        if (is_null($status_tag)) {
            throw new \InvalidArgumentException('non-nullable status_tag cannot be null');
        }
        $this->container['status_tag'] = $status_tag;

        return $this;
    }

    /**
     * Gets status_description
     *
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->container['status_description'];
    }

    /**
     * Sets status_description
     *
     * @param string|null $status_description A user-friendly descriptor of the StatusTag
     *
     * @return self
     */
    public function setStatusDescription($status_description)
    {
        if (is_null($status_description)) {
            throw new \InvalidArgumentException('non-nullable status_description cannot be null');
        }
        $this->container['status_description'] = $status_description;

        return $this;
    }

    /**
     * Gets actionable
     *
     * @return bool|null
     */
    public function getActionable()
    {
        return $this->container['actionable'];
    }

    /**
     * Sets actionable
     *
     * @param bool|null $actionable Determines whether the refund is in a state where it requires action from the user
     *
     * @return self
     */
    public function setActionable($actionable)
    {
        if (is_null($actionable)) {
            throw new \InvalidArgumentException('non-nullable actionable cannot be null');
        }
        $this->container['actionable'] = $actionable;

        return $this;
    }

    /**
     * Gets action_description
     *
     * @return string|null
     */
    public function getActionDescription()
    {
        return $this->container['action_description'];
    }

    /**
     * Sets action_description
     *
     * @param string|null $action_description A user-friendly descriptor of what \"actioning\" the refund will do on the channel
     *
     * @return self
     */
    public function setActionDescription($action_description)
    {
        if (is_null($action_description)) {
            throw new \InvalidArgumentException('non-nullable action_description cannot be null');
        }
        $this->container['action_description'] = $action_description;

        return $this;
    }

    /**
     * Gets editable_fields
     *
     * @return string[]|null
     */
    public function getEditableFields()
    {
        return $this->container['editable_fields'];
    }

    /**
     * Sets editable_fields
     *
     * @param string[]|null $editable_fields Where certain fields need to be modified for the refund to be successfully actioned, this list is populated with a list of the field names, allowing them to be edited as necessary
     *
     * @return self
     */
    public function setEditableFields($editable_fields)
    {
        if (is_null($editable_fields)) {
            throw new \InvalidArgumentException('non-nullable editable_fields cannot be null');
        }
        $this->container['editable_fields'] = $editable_fields;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


