<?php
/**
 * OrderGeneralInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * OrderGeneralInfo Class Doc Comment
 *
 * @category Class
 * @description Order General Info class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class OrderGeneralInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'OrderGeneralInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'status' => 'int',
        'label_printed' => 'bool',
        'label_error' => 'string',
        'invoice_printed' => 'bool',
        'invoice_print_error' => 'string',
        'pick_list_printed' => 'bool',
        'pick_list_print_error' => 'string',
        'is_rule_run' => 'bool',
        'notes' => 'int',
        'part_shipped' => 'bool',
        'marker' => 'int',
        'is_parked' => 'bool',
        'identifiers' => '\Linnworks\ReturnsRefunds\Model\Identifier[]',
        'reference_num' => 'string',
        'secondary_reference' => 'string',
        'external_reference_num' => 'string',
        'received_date' => '\DateTime',
        'source' => 'string',
        'sub_source' => 'string',
        'site_code' => 'string',
        'hold_or_cancel' => 'bool',
        'despatch_by_date' => '\DateTime',
        'scheduled_delivery' => '\Linnworks\ReturnsRefunds\Model\ScheduledDelivery',
        'has_scheduled_delivery' => 'bool',
        'location' => 'string',
        'num_items' => 'int',
        'pickwave_ids' => 'int[]',
        'stock_allocation_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'status' => 'int32',
        'label_printed' => null,
        'label_error' => null,
        'invoice_printed' => null,
        'invoice_print_error' => null,
        'pick_list_printed' => null,
        'pick_list_print_error' => null,
        'is_rule_run' => null,
        'notes' => 'int32',
        'part_shipped' => null,
        'marker' => 'int32',
        'is_parked' => null,
        'identifiers' => null,
        'reference_num' => null,
        'secondary_reference' => null,
        'external_reference_num' => null,
        'received_date' => 'date-time',
        'source' => null,
        'sub_source' => null,
        'site_code' => null,
        'hold_or_cancel' => null,
        'despatch_by_date' => 'date-time',
        'scheduled_delivery' => null,
        'has_scheduled_delivery' => null,
        'location' => 'uuid',
        'num_items' => 'int32',
        'pickwave_ids' => 'int32',
        'stock_allocation_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'status' => false,
        'label_printed' => false,
        'label_error' => false,
        'invoice_printed' => false,
        'invoice_print_error' => false,
        'pick_list_printed' => false,
        'pick_list_print_error' => false,
        'is_rule_run' => false,
        'notes' => false,
        'part_shipped' => false,
        'marker' => false,
        'is_parked' => false,
        'identifiers' => false,
        'reference_num' => false,
        'secondary_reference' => false,
        'external_reference_num' => false,
        'received_date' => false,
        'source' => false,
        'sub_source' => false,
        'site_code' => false,
        'hold_or_cancel' => false,
        'despatch_by_date' => false,
        'scheduled_delivery' => false,
        'has_scheduled_delivery' => false,
        'location' => false,
        'num_items' => false,
        'pickwave_ids' => false,
        'stock_allocation_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'status' => 'Status',
        'label_printed' => 'LabelPrinted',
        'label_error' => 'LabelError',
        'invoice_printed' => 'InvoicePrinted',
        'invoice_print_error' => 'InvoicePrintError',
        'pick_list_printed' => 'PickListPrinted',
        'pick_list_print_error' => 'PickListPrintError',
        'is_rule_run' => 'IsRuleRun',
        'notes' => 'Notes',
        'part_shipped' => 'PartShipped',
        'marker' => 'Marker',
        'is_parked' => 'IsParked',
        'identifiers' => 'Identifiers',
        'reference_num' => 'ReferenceNum',
        'secondary_reference' => 'SecondaryReference',
        'external_reference_num' => 'ExternalReferenceNum',
        'received_date' => 'ReceivedDate',
        'source' => 'Source',
        'sub_source' => 'SubSource',
        'site_code' => 'SiteCode',
        'hold_or_cancel' => 'HoldOrCancel',
        'despatch_by_date' => 'DespatchByDate',
        'scheduled_delivery' => 'ScheduledDelivery',
        'has_scheduled_delivery' => 'HasScheduledDelivery',
        'location' => 'Location',
        'num_items' => 'NumItems',
        'pickwave_ids' => 'PickwaveIds',
        'stock_allocation_type' => 'StockAllocationType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'status' => 'setStatus',
        'label_printed' => 'setLabelPrinted',
        'label_error' => 'setLabelError',
        'invoice_printed' => 'setInvoicePrinted',
        'invoice_print_error' => 'setInvoicePrintError',
        'pick_list_printed' => 'setPickListPrinted',
        'pick_list_print_error' => 'setPickListPrintError',
        'is_rule_run' => 'setIsRuleRun',
        'notes' => 'setNotes',
        'part_shipped' => 'setPartShipped',
        'marker' => 'setMarker',
        'is_parked' => 'setIsParked',
        'identifiers' => 'setIdentifiers',
        'reference_num' => 'setReferenceNum',
        'secondary_reference' => 'setSecondaryReference',
        'external_reference_num' => 'setExternalReferenceNum',
        'received_date' => 'setReceivedDate',
        'source' => 'setSource',
        'sub_source' => 'setSubSource',
        'site_code' => 'setSiteCode',
        'hold_or_cancel' => 'setHoldOrCancel',
        'despatch_by_date' => 'setDespatchByDate',
        'scheduled_delivery' => 'setScheduledDelivery',
        'has_scheduled_delivery' => 'setHasScheduledDelivery',
        'location' => 'setLocation',
        'num_items' => 'setNumItems',
        'pickwave_ids' => 'setPickwaveIds',
        'stock_allocation_type' => 'setStockAllocationType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'status' => 'getStatus',
        'label_printed' => 'getLabelPrinted',
        'label_error' => 'getLabelError',
        'invoice_printed' => 'getInvoicePrinted',
        'invoice_print_error' => 'getInvoicePrintError',
        'pick_list_printed' => 'getPickListPrinted',
        'pick_list_print_error' => 'getPickListPrintError',
        'is_rule_run' => 'getIsRuleRun',
        'notes' => 'getNotes',
        'part_shipped' => 'getPartShipped',
        'marker' => 'getMarker',
        'is_parked' => 'getIsParked',
        'identifiers' => 'getIdentifiers',
        'reference_num' => 'getReferenceNum',
        'secondary_reference' => 'getSecondaryReference',
        'external_reference_num' => 'getExternalReferenceNum',
        'received_date' => 'getReceivedDate',
        'source' => 'getSource',
        'sub_source' => 'getSubSource',
        'site_code' => 'getSiteCode',
        'hold_or_cancel' => 'getHoldOrCancel',
        'despatch_by_date' => 'getDespatchByDate',
        'scheduled_delivery' => 'getScheduledDelivery',
        'has_scheduled_delivery' => 'getHasScheduledDelivery',
        'location' => 'getLocation',
        'num_items' => 'getNumItems',
        'pickwave_ids' => 'getPickwaveIds',
        'stock_allocation_type' => 'getStockAllocationType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STOCK_ALLOCATION_TYPE_NOT_ALLOCATED = 'NotAllocated';
    public const STOCK_ALLOCATION_TYPE_INSUFFIENT = 'Insuffient';
    public const STOCK_ALLOCATION_TYPE_PARTIAL = 'Partial';
    public const STOCK_ALLOCATION_TYPE_FULL = 'Full';
    public const STOCK_ALLOCATION_TYPE_OVER_ALLOCATED = 'OverAllocated';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStockAllocationTypeAllowableValues()
    {
        return [
            self::STOCK_ALLOCATION_TYPE_NOT_ALLOCATED,
            self::STOCK_ALLOCATION_TYPE_INSUFFIENT,
            self::STOCK_ALLOCATION_TYPE_PARTIAL,
            self::STOCK_ALLOCATION_TYPE_FULL,
            self::STOCK_ALLOCATION_TYPE_OVER_ALLOCATED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('label_printed', $data ?? [], null);
        $this->setIfExists('label_error', $data ?? [], null);
        $this->setIfExists('invoice_printed', $data ?? [], null);
        $this->setIfExists('invoice_print_error', $data ?? [], null);
        $this->setIfExists('pick_list_printed', $data ?? [], null);
        $this->setIfExists('pick_list_print_error', $data ?? [], null);
        $this->setIfExists('is_rule_run', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('part_shipped', $data ?? [], null);
        $this->setIfExists('marker', $data ?? [], null);
        $this->setIfExists('is_parked', $data ?? [], null);
        $this->setIfExists('identifiers', $data ?? [], null);
        $this->setIfExists('reference_num', $data ?? [], null);
        $this->setIfExists('secondary_reference', $data ?? [], null);
        $this->setIfExists('external_reference_num', $data ?? [], null);
        $this->setIfExists('received_date', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('site_code', $data ?? [], null);
        $this->setIfExists('hold_or_cancel', $data ?? [], null);
        $this->setIfExists('despatch_by_date', $data ?? [], null);
        $this->setIfExists('scheduled_delivery', $data ?? [], null);
        $this->setIfExists('has_scheduled_delivery', $data ?? [], null);
        $this->setIfExists('location', $data ?? [], null);
        $this->setIfExists('num_items', $data ?? [], null);
        $this->setIfExists('pickwave_ids', $data ?? [], null);
        $this->setIfExists('stock_allocation_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getStockAllocationTypeAllowableValues();
        if (!is_null($this->container['stock_allocation_type']) && !in_array($this->container['stock_allocation_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'stock_allocation_type', must be one of '%s'",
                $this->container['stock_allocation_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets status
     *
     * @return int|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param int|null $status Order Status (0 = UNPAID, 1 = PAID,2 = RETURN,3 = PENDING,4 = RESEND)
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets label_printed
     *
     * @return bool|null
     */
    public function getLabelPrinted()
    {
        return $this->container['label_printed'];
    }

    /**
     * Sets label_printed
     *
     * @param bool|null $label_printed Is label printed
     *
     * @return self
     */
    public function setLabelPrinted($label_printed)
    {
        if (is_null($label_printed)) {
            throw new \InvalidArgumentException('non-nullable label_printed cannot be null');
        }
        $this->container['label_printed'] = $label_printed;

        return $this;
    }

    /**
     * Gets label_error
     *
     * @return string|null
     */
    public function getLabelError()
    {
        return $this->container['label_error'];
    }

    /**
     * Sets label_error
     *
     * @param string|null $label_error Is there a label error
     *
     * @return self
     */
    public function setLabelError($label_error)
    {
        if (is_null($label_error)) {
            throw new \InvalidArgumentException('non-nullable label_error cannot be null');
        }
        $this->container['label_error'] = $label_error;

        return $this;
    }

    /**
     * Gets invoice_printed
     *
     * @return bool|null
     */
    public function getInvoicePrinted()
    {
        return $this->container['invoice_printed'];
    }

    /**
     * Sets invoice_printed
     *
     * @param bool|null $invoice_printed Is invoice printed
     *
     * @return self
     */
    public function setInvoicePrinted($invoice_printed)
    {
        if (is_null($invoice_printed)) {
            throw new \InvalidArgumentException('non-nullable invoice_printed cannot be null');
        }
        $this->container['invoice_printed'] = $invoice_printed;

        return $this;
    }

    /**
     * Gets invoice_print_error
     *
     * @return string|null
     */
    public function getInvoicePrintError()
    {
        return $this->container['invoice_print_error'];
    }

    /**
     * Sets invoice_print_error
     *
     * @param string|null $invoice_print_error Is there invoice print error
     *
     * @return self
     */
    public function setInvoicePrintError($invoice_print_error)
    {
        if (is_null($invoice_print_error)) {
            throw new \InvalidArgumentException('non-nullable invoice_print_error cannot be null');
        }
        $this->container['invoice_print_error'] = $invoice_print_error;

        return $this;
    }

    /**
     * Gets pick_list_printed
     *
     * @return bool|null
     */
    public function getPickListPrinted()
    {
        return $this->container['pick_list_printed'];
    }

    /**
     * Sets pick_list_printed
     *
     * @param bool|null $pick_list_printed Is pick list printed
     *
     * @return self
     */
    public function setPickListPrinted($pick_list_printed)
    {
        if (is_null($pick_list_printed)) {
            throw new \InvalidArgumentException('non-nullable pick_list_printed cannot be null');
        }
        $this->container['pick_list_printed'] = $pick_list_printed;

        return $this;
    }

    /**
     * Gets pick_list_print_error
     *
     * @return string|null
     */
    public function getPickListPrintError()
    {
        return $this->container['pick_list_print_error'];
    }

    /**
     * Sets pick_list_print_error
     *
     * @param string|null $pick_list_print_error Is there pick list print error
     *
     * @return self
     */
    public function setPickListPrintError($pick_list_print_error)
    {
        if (is_null($pick_list_print_error)) {
            throw new \InvalidArgumentException('non-nullable pick_list_print_error cannot be null');
        }
        $this->container['pick_list_print_error'] = $pick_list_print_error;

        return $this;
    }

    /**
     * Gets is_rule_run
     *
     * @return bool|null
     */
    public function getIsRuleRun()
    {
        return $this->container['is_rule_run'];
    }

    /**
     * Sets is_rule_run
     *
     * @param bool|null $is_rule_run If rules engine rule ran on an order
     *
     * @return self
     */
    public function setIsRuleRun($is_rule_run)
    {
        if (is_null($is_rule_run)) {
            throw new \InvalidArgumentException('non-nullable is_rule_run cannot be null');
        }
        $this->container['is_rule_run'] = $is_rule_run;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return int|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param int|null $notes Quantity of order notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets part_shipped
     *
     * @return bool|null
     */
    public function getPartShipped()
    {
        return $this->container['part_shipped'];
    }

    /**
     * Sets part_shipped
     *
     * @param bool|null $part_shipped If order partly shipped
     *
     * @return self
     */
    public function setPartShipped($part_shipped)
    {
        if (is_null($part_shipped)) {
            throw new \InvalidArgumentException('non-nullable part_shipped cannot be null');
        }
        $this->container['part_shipped'] = $part_shipped;

        return $this;
    }

    /**
     * Gets marker
     *
     * @return int|null
     */
    public function getMarker()
    {
        return $this->container['marker'];
    }

    /**
     * Sets marker
     *
     * @param int|null $marker Order marker (0 = NOT TAG,1 = Tag 1,2 = Tag 2,3 = Tag 3,4 = Tag 4,5 = Tag 5,6 = Tag 6,7 = Parked)
     *
     * @return self
     */
    public function setMarker($marker)
    {
        if (is_null($marker)) {
            throw new \InvalidArgumentException('non-nullable marker cannot be null');
        }
        $this->container['marker'] = $marker;

        return $this;
    }

    /**
     * Gets is_parked
     *
     * @return bool|null
     */
    public function getIsParked()
    {
        return $this->container['is_parked'];
    }

    /**
     * Sets is_parked
     *
     * @param bool|null $is_parked Is the order parked?
     *
     * @return self
     */
    public function setIsParked($is_parked)
    {
        if (is_null($is_parked)) {
            throw new \InvalidArgumentException('non-nullable is_parked cannot be null');
        }
        $this->container['is_parked'] = $is_parked;

        return $this;
    }

    /**
     * Gets identifiers
     *
     * @return \Linnworks\ReturnsRefunds\Model\Identifier[]|null
     */
    public function getIdentifiers()
    {
        return $this->container['identifiers'];
    }

    /**
     * Sets identifiers
     *
     * @param \Linnworks\ReturnsRefunds\Model\Identifier[]|null $identifiers Order identifiers. [Prime | Scheduled]
     *
     * @return self
     */
    public function setIdentifiers($identifiers)
    {
        if (is_null($identifiers)) {
            throw new \InvalidArgumentException('non-nullable identifiers cannot be null');
        }
        $this->container['identifiers'] = $identifiers;

        return $this;
    }

    /**
     * Gets reference_num
     *
     * @return string|null
     */
    public function getReferenceNum()
    {
        return $this->container['reference_num'];
    }

    /**
     * Sets reference_num
     *
     * @param string|null $reference_num Order reference number (Channel defined)
     *
     * @return self
     */
    public function setReferenceNum($reference_num)
    {
        if (is_null($reference_num)) {
            throw new \InvalidArgumentException('non-nullable reference_num cannot be null');
        }
        $this->container['reference_num'] = $reference_num;

        return $this;
    }

    /**
     * Gets secondary_reference
     *
     * @return string|null
     */
    public function getSecondaryReference()
    {
        return $this->container['secondary_reference'];
    }

    /**
     * Sets secondary_reference
     *
     * @param string|null $secondary_reference An additional reference number for the orderr (Used by some channels)
     *
     * @return self
     */
    public function setSecondaryReference($secondary_reference)
    {
        if (is_null($secondary_reference)) {
            throw new \InvalidArgumentException('non-nullable secondary_reference cannot be null');
        }
        $this->container['secondary_reference'] = $secondary_reference;

        return $this;
    }

    /**
     * Gets external_reference_num
     *
     * @return string|null
     */
    public function getExternalReferenceNum()
    {
        return $this->container['external_reference_num'];
    }

    /**
     * Sets external_reference_num
     *
     * @param string|null $external_reference_num This is an additional reference number from the sales channel, typically used by eBay
     *
     * @return self
     */
    public function setExternalReferenceNum($external_reference_num)
    {
        if (is_null($external_reference_num)) {
            throw new \InvalidArgumentException('non-nullable external_reference_num cannot be null');
        }
        $this->container['external_reference_num'] = $external_reference_num;

        return $this;
    }

    /**
     * Gets received_date
     *
     * @return \DateTime|null
     */
    public function getReceivedDate()
    {
        return $this->container['received_date'];
    }

    /**
     * Sets received_date
     *
     * @param \DateTime|null $received_date The date and time at which the order was placed on the sales channel
     *
     * @return self
     */
    public function setReceivedDate($received_date)
    {
        if (is_null($received_date)) {
            throw new \InvalidArgumentException('non-nullable received_date cannot be null');
        }
        $this->container['received_date'] = $received_date;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source Order ChannelName/Source (e.g. EBAY)
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source Order Subsource (e.g. EBAY1)
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets site_code
     *
     * @return string|null
     */
    public function getSiteCode()
    {
        return $this->container['site_code'];
    }

    /**
     * Sets site_code
     *
     * @param string|null $site_code SiteCode used to differentiate between different sites from a single channel (eg. Amazon UK, Amazon US, Amazon FR...)
     *
     * @return self
     */
    public function setSiteCode($site_code)
    {
        if (is_null($site_code)) {
            throw new \InvalidArgumentException('non-nullable site_code cannot be null');
        }
        $this->container['site_code'] = $site_code;

        return $this;
    }

    /**
     * Gets hold_or_cancel
     *
     * @return bool|null
     */
    public function getHoldOrCancel()
    {
        return $this->container['hold_or_cancel'];
    }

    /**
     * Sets hold_or_cancel
     *
     * @param bool|null $hold_or_cancel This shows whether the order has been marked as on hold, for processed orders if the order has been cancelled OnHold = 1
     *
     * @return self
     */
    public function setHoldOrCancel($hold_or_cancel)
    {
        if (is_null($hold_or_cancel)) {
            throw new \InvalidArgumentException('non-nullable hold_or_cancel cannot be null');
        }
        $this->container['hold_or_cancel'] = $hold_or_cancel;

        return $this;
    }

    /**
     * Gets despatch_by_date
     *
     * @return \DateTime|null
     */
    public function getDespatchByDate()
    {
        return $this->container['despatch_by_date'];
    }

    /**
     * Sets despatch_by_date
     *
     * @param \DateTime|null $despatch_by_date Despatch by Date
     *
     * @return self
     */
    public function setDespatchByDate($despatch_by_date)
    {
        if (is_null($despatch_by_date)) {
            throw new \InvalidArgumentException('non-nullable despatch_by_date cannot be null');
        }
        $this->container['despatch_by_date'] = $despatch_by_date;

        return $this;
    }

    /**
     * Gets scheduled_delivery
     *
     * @return \Linnworks\ReturnsRefunds\Model\ScheduledDelivery|null
     */
    public function getScheduledDelivery()
    {
        return $this->container['scheduled_delivery'];
    }

    /**
     * Sets scheduled_delivery
     *
     * @param \Linnworks\ReturnsRefunds\Model\ScheduledDelivery|null $scheduled_delivery scheduled_delivery
     *
     * @return self
     */
    public function setScheduledDelivery($scheduled_delivery)
    {
        if (is_null($scheduled_delivery)) {
            throw new \InvalidArgumentException('non-nullable scheduled_delivery cannot be null');
        }
        $this->container['scheduled_delivery'] = $scheduled_delivery;

        return $this;
    }

    /**
     * Gets has_scheduled_delivery
     *
     * @return bool|null
     */
    public function getHasScheduledDelivery()
    {
        return $this->container['has_scheduled_delivery'];
    }

    /**
     * Sets has_scheduled_delivery
     *
     * @param bool|null $has_scheduled_delivery has_scheduled_delivery
     *
     * @return self
     */
    public function setHasScheduledDelivery($has_scheduled_delivery)
    {
        if (is_null($has_scheduled_delivery)) {
            throw new \InvalidArgumentException('non-nullable has_scheduled_delivery cannot be null');
        }
        $this->container['has_scheduled_delivery'] = $has_scheduled_delivery;

        return $this;
    }

    /**
     * Gets location
     *
     * @return string|null
     */
    public function getLocation()
    {
        return $this->container['location'];
    }

    /**
     * Sets location
     *
     * @param string|null $location Order location ID
     *
     * @return self
     */
    public function setLocation($location)
    {
        if (is_null($location)) {
            throw new \InvalidArgumentException('non-nullable location cannot be null');
        }
        $this->container['location'] = $location;

        return $this;
    }

    /**
     * Gets num_items
     *
     * @return int|null
     */
    public function getNumItems()
    {
        return $this->container['num_items'];
    }

    /**
     * Sets num_items
     *
     * @param int|null $num_items Quantity of order items
     *
     * @return self
     */
    public function setNumItems($num_items)
    {
        if (is_null($num_items)) {
            throw new \InvalidArgumentException('non-nullable num_items cannot be null');
        }
        $this->container['num_items'] = $num_items;

        return $this;
    }

    /**
     * Gets pickwave_ids
     *
     * @return int[]|null
     */
    public function getPickwaveIds()
    {
        return $this->container['pickwave_ids'];
    }

    /**
     * Sets pickwave_ids
     *
     * @param int[]|null $pickwave_ids All related Pickwave Ids
     *
     * @return self
     */
    public function setPickwaveIds($pickwave_ids)
    {
        if (is_null($pickwave_ids)) {
            throw new \InvalidArgumentException('non-nullable pickwave_ids cannot be null');
        }
        $this->container['pickwave_ids'] = $pickwave_ids;

        return $this;
    }

    /**
     * Gets stock_allocation_type
     *
     * @return string|null
     */
    public function getStockAllocationType()
    {
        return $this->container['stock_allocation_type'];
    }

    /**
     * Sets stock_allocation_type
     *
     * @param string|null $stock_allocation_type stock_allocation_type
     *
     * @return self
     */
    public function setStockAllocationType($stock_allocation_type)
    {
        if (is_null($stock_allocation_type)) {
            throw new \InvalidArgumentException('non-nullable stock_allocation_type cannot be null');
        }
        $allowedValues = $this->getStockAllocationTypeAllowableValues();
        if (!in_array($stock_allocation_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'stock_allocation_type', must be one of '%s'",
                    $stock_allocation_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['stock_allocation_type'] = $stock_allocation_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


