<?php
/**
 * CreateRMABookingRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * CreateRMABookingRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreateRMABookingRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CreateRMABookingRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'channel_initiated' => 'bool',
        'order_id' => 'string',
        'return_items' => '\Linnworks\ReturnsRefunds\Model\ReturnItem[]',
        'exchange_items' => '\Linnworks\ReturnsRefunds\Model\ExchangeItem[]',
        'resend_items' => '\Linnworks\ReturnsRefunds\Model\ResendItem[]',
        'reference' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'channel_initiated' => null,
        'order_id' => 'uuid',
        'return_items' => null,
        'exchange_items' => null,
        'resend_items' => null,
        'reference' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'channel_initiated' => false,
        'order_id' => false,
        'return_items' => false,
        'exchange_items' => false,
        'resend_items' => false,
        'reference' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'channel_initiated' => 'ChannelInitiated',
        'order_id' => 'OrderId',
        'return_items' => 'ReturnItems',
        'exchange_items' => 'ExchangeItems',
        'resend_items' => 'ResendItems',
        'reference' => 'Reference'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'channel_initiated' => 'setChannelInitiated',
        'order_id' => 'setOrderId',
        'return_items' => 'setReturnItems',
        'exchange_items' => 'setExchangeItems',
        'resend_items' => 'setResendItems',
        'reference' => 'setReference'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'channel_initiated' => 'getChannelInitiated',
        'order_id' => 'getOrderId',
        'return_items' => 'getReturnItems',
        'exchange_items' => 'getExchangeItems',
        'resend_items' => 'getResendItems',
        'reference' => 'getReference'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('channel_initiated', $data ?? [], null);
        $this->setIfExists('order_id', $data ?? [], null);
        $this->setIfExists('return_items', $data ?? [], null);
        $this->setIfExists('exchange_items', $data ?? [], null);
        $this->setIfExists('resend_items', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets channel_initiated
     *
     * @return bool|null
     */
    public function getChannelInitiated()
    {
        return $this->container['channel_initiated'];
    }

    /**
     * Sets channel_initiated
     *
     * @param bool|null $channel_initiated Determines whether the RMA request was initiated on the channel, or within Linnworks
     *
     * @return self
     */
    public function setChannelInitiated($channel_initiated)
    {
        if (is_null($channel_initiated)) {
            throw new \InvalidArgumentException('non-nullable channel_initiated cannot be null');
        }
        $this->container['channel_initiated'] = $channel_initiated;

        return $this;
    }

    /**
     * Gets order_id
     *
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->container['order_id'];
    }

    /**
     * Sets order_id
     *
     * @param string|null $order_id The unique identifier for the order a return booking is being created for
     *
     * @return self
     */
    public function setOrderId($order_id)
    {
        if (is_null($order_id)) {
            throw new \InvalidArgumentException('non-nullable order_id cannot be null');
        }
        $this->container['order_id'] = $order_id;

        return $this;
    }

    /**
     * Gets return_items
     *
     * @return \Linnworks\ReturnsRefunds\Model\ReturnItem[]|null
     */
    public function getReturnItems()
    {
        return $this->container['return_items'];
    }

    /**
     * Sets return_items
     *
     * @param \Linnworks\ReturnsRefunds\Model\ReturnItem[]|null $return_items A collection of items to be returned as part of this booking
     *
     * @return self
     */
    public function setReturnItems($return_items)
    {
        if (is_null($return_items)) {
            throw new \InvalidArgumentException('non-nullable return_items cannot be null');
        }
        $this->container['return_items'] = $return_items;

        return $this;
    }

    /**
     * Gets exchange_items
     *
     * @return \Linnworks\ReturnsRefunds\Model\ExchangeItem[]|null
     */
    public function getExchangeItems()
    {
        return $this->container['exchange_items'];
    }

    /**
     * Sets exchange_items
     *
     * @param \Linnworks\ReturnsRefunds\Model\ExchangeItem[]|null $exchange_items A collection of items to be exchanged as part of this booking
     *
     * @return self
     */
    public function setExchangeItems($exchange_items)
    {
        if (is_null($exchange_items)) {
            throw new \InvalidArgumentException('non-nullable exchange_items cannot be null');
        }
        $this->container['exchange_items'] = $exchange_items;

        return $this;
    }

    /**
     * Gets resend_items
     *
     * @return \Linnworks\ReturnsRefunds\Model\ResendItem[]|null
     */
    public function getResendItems()
    {
        return $this->container['resend_items'];
    }

    /**
     * Sets resend_items
     *
     * @param \Linnworks\ReturnsRefunds\Model\ResendItem[]|null $resend_items A collection of items to be resent as part of this booking
     *
     * @return self
     */
    public function setResendItems($resend_items)
    {
        if (is_null($resend_items)) {
            throw new \InvalidArgumentException('non-nullable resend_items cannot be null');
        }
        $this->container['resend_items'] = $resend_items;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference (Optional) If provided, sets the External Reference of the RMA header to the provided value. Otherwise, this value is automatically generated
     *
     * @return self
     */
    public function setReference($reference)
    {
        if (is_null($reference)) {
            throw new \InvalidArgumentException('non-nullable reference cannot be null');
        }
        $this->container['reference'] = $reference;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


