<?php
/**
 * BookedReturnsExchangeOrder
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * BookedReturnsExchangeOrder Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BookedReturnsExchangeOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BookedReturnsExchangeOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_order_id' => 'string',
        'n_order_id' => 'int',
        'reference_num' => 'string',
        'secondary_reference' => 'string',
        'c_full_name' => 'string',
        'return_date' => '\DateTime'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_order_id' => 'uuid',
        'n_order_id' => 'int32',
        'reference_num' => null,
        'secondary_reference' => null,
        'c_full_name' => null,
        'return_date' => 'date-time'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_order_id' => false,
        'n_order_id' => false,
        'reference_num' => false,
        'secondary_reference' => false,
        'c_full_name' => false,
        'return_date' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_order_id' => 'pkOrderID',
        'n_order_id' => 'nOrderId',
        'reference_num' => 'ReferenceNum',
        'secondary_reference' => 'SecondaryReference',
        'c_full_name' => 'cFullName',
        'return_date' => 'ReturnDate'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_order_id' => 'setPkOrderId',
        'n_order_id' => 'setNOrderId',
        'reference_num' => 'setReferenceNum',
        'secondary_reference' => 'setSecondaryReference',
        'c_full_name' => 'setCFullName',
        'return_date' => 'setReturnDate'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_order_id' => 'getPkOrderId',
        'n_order_id' => 'getNOrderId',
        'reference_num' => 'getReferenceNum',
        'secondary_reference' => 'getSecondaryReference',
        'c_full_name' => 'getCFullName',
        'return_date' => 'getReturnDate'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_order_id', $data ?? [], null);
        $this->setIfExists('n_order_id', $data ?? [], null);
        $this->setIfExists('reference_num', $data ?? [], null);
        $this->setIfExists('secondary_reference', $data ?? [], null);
        $this->setIfExists('c_full_name', $data ?? [], null);
        $this->setIfExists('return_date', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_order_id
     *
     * @return string|null
     */
    public function getPkOrderId()
    {
        return $this->container['pk_order_id'];
    }

    /**
     * Sets pk_order_id
     *
     * @param string|null $pk_order_id Order ID (unique order identifier)
     *
     * @return self
     */
    public function setPkOrderId($pk_order_id)
    {
        if (is_null($pk_order_id)) {
            throw new \InvalidArgumentException('non-nullable pk_order_id cannot be null');
        }
        $this->container['pk_order_id'] = $pk_order_id;

        return $this;
    }

    /**
     * Gets n_order_id
     *
     * @return int|null
     */
    public function getNOrderId()
    {
        return $this->container['n_order_id'];
    }

    /**
     * Sets n_order_id
     *
     * @param int|null $n_order_id Linnworks order number
     *
     * @return self
     */
    public function setNOrderId($n_order_id)
    {
        if (is_null($n_order_id)) {
            throw new \InvalidArgumentException('non-nullable n_order_id cannot be null');
        }
        $this->container['n_order_id'] = $n_order_id;

        return $this;
    }

    /**
     * Gets reference_num
     *
     * @return string|null
     */
    public function getReferenceNum()
    {
        return $this->container['reference_num'];
    }

    /**
     * Sets reference_num
     *
     * @param string|null $reference_num Order reference number
     *
     * @return self
     */
    public function setReferenceNum($reference_num)
    {
        if (is_null($reference_num)) {
            throw new \InvalidArgumentException('non-nullable reference_num cannot be null');
        }
        $this->container['reference_num'] = $reference_num;

        return $this;
    }

    /**
     * Gets secondary_reference
     *
     * @return string|null
     */
    public function getSecondaryReference()
    {
        return $this->container['secondary_reference'];
    }

    /**
     * Sets secondary_reference
     *
     * @param string|null $secondary_reference Order seconary reference (Comes from the channel)
     *
     * @return self
     */
    public function setSecondaryReference($secondary_reference)
    {
        if (is_null($secondary_reference)) {
            throw new \InvalidArgumentException('non-nullable secondary_reference cannot be null');
        }
        $this->container['secondary_reference'] = $secondary_reference;

        return $this;
    }

    /**
     * Gets c_full_name
     *
     * @return string|null
     */
    public function getCFullName()
    {
        return $this->container['c_full_name'];
    }

    /**
     * Sets c_full_name
     *
     * @param string|null $c_full_name Customer full name
     *
     * @return self
     */
    public function setCFullName($c_full_name)
    {
        if (is_null($c_full_name)) {
            throw new \InvalidArgumentException('non-nullable c_full_name cannot be null');
        }
        $this->container['c_full_name'] = $c_full_name;

        return $this;
    }

    /**
     * Gets return_date
     *
     * @return \DateTime|null
     */
    public function getReturnDate()
    {
        return $this->container['return_date'];
    }

    /**
     * Sets return_date
     *
     * @param \DateTime|null $return_date Return date time
     *
     * @return self
     */
    public function setReturnDate($return_date)
    {
        if (is_null($return_date)) {
            throw new \InvalidArgumentException('non-nullable return_date cannot be null');
        }
        $this->container['return_date'] = $return_date;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


