<?php
/**
 * BookedReturnsExchangeItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * BookedReturnsExchangeItem Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BookedReturnsExchangeItem implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BookedReturnsExchangeItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'fk_order_item_row_id' => 'string',
        'order_item_batch_id' => 'int',
        'stock_item_id' => 'string',
        'batch_inventory_id' => 'int',
        'batch_number' => 'string',
        'row_type' => 'string',
        'sku' => 'string',
        'item_title' => 'string',
        'return_qty' => 'int',
        'max_return_qty' => 'int',
        'new_qty' => 'int',
        'new_sku' => 'string',
        'new_title' => 'string',
        'fk_new_stock_item_id' => 'string',
        'category' => 'string',
        'reason' => 'string',
        'fk_return_location_id' => 'string',
        'return_location' => 'string',
        'pending_refund_amount' => 'float',
        'scrapped' => 'bool',
        'scrap_qty' => 'int',
        'parent_order_item_row_id' => 'string',
        'additional_cost' => 'float',
        'c_currency' => 'string',
        'pk_return_id' => 'int',
        'channel_reason' => 'string',
        'channel_reason_sec' => 'string',
        'return_date' => '\DateTime',
        'despatch_unit_value' => 'float',
        'batch_inventory' => '\Linnworks\ReturnsRefunds\Model\StockItemBatchInventory'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'fk_order_item_row_id' => 'uuid',
        'order_item_batch_id' => 'int32',
        'stock_item_id' => 'uuid',
        'batch_inventory_id' => 'int32',
        'batch_number' => null,
        'row_type' => null,
        'sku' => null,
        'item_title' => null,
        'return_qty' => 'int32',
        'max_return_qty' => 'int32',
        'new_qty' => 'int32',
        'new_sku' => null,
        'new_title' => null,
        'fk_new_stock_item_id' => 'uuid',
        'category' => null,
        'reason' => null,
        'fk_return_location_id' => 'uuid',
        'return_location' => null,
        'pending_refund_amount' => 'double',
        'scrapped' => null,
        'scrap_qty' => 'int32',
        'parent_order_item_row_id' => 'uuid',
        'additional_cost' => 'double',
        'c_currency' => null,
        'pk_return_id' => 'int32',
        'channel_reason' => null,
        'channel_reason_sec' => null,
        'return_date' => 'date-time',
        'despatch_unit_value' => 'double',
        'batch_inventory' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'fk_order_item_row_id' => false,
        'order_item_batch_id' => false,
        'stock_item_id' => false,
        'batch_inventory_id' => false,
        'batch_number' => false,
        'row_type' => false,
        'sku' => false,
        'item_title' => false,
        'return_qty' => false,
        'max_return_qty' => false,
        'new_qty' => false,
        'new_sku' => false,
        'new_title' => false,
        'fk_new_stock_item_id' => false,
        'category' => false,
        'reason' => false,
        'fk_return_location_id' => false,
        'return_location' => false,
        'pending_refund_amount' => false,
        'scrapped' => false,
        'scrap_qty' => false,
        'parent_order_item_row_id' => false,
        'additional_cost' => false,
        'c_currency' => false,
        'pk_return_id' => false,
        'channel_reason' => false,
        'channel_reason_sec' => false,
        'return_date' => false,
        'despatch_unit_value' => false,
        'batch_inventory' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'fk_order_item_row_id' => 'fkOrderItemRowId',
        'order_item_batch_id' => 'OrderItemBatchId',
        'stock_item_id' => 'StockItemId',
        'batch_inventory_id' => 'BatchInventoryId',
        'batch_number' => 'BatchNumber',
        'row_type' => 'RowType',
        'sku' => 'SKU',
        'item_title' => 'ItemTitle',
        'return_qty' => 'ReturnQty',
        'max_return_qty' => 'MaxReturnQty',
        'new_qty' => 'NewQty',
        'new_sku' => 'NewSKU',
        'new_title' => 'NewTitle',
        'fk_new_stock_item_id' => 'fkNewStockItemId',
        'category' => 'Category',
        'reason' => 'Reason',
        'fk_return_location_id' => 'fkReturnLocationId',
        'return_location' => 'ReturnLocation',
        'pending_refund_amount' => 'PendingRefundAmount',
        'scrapped' => 'Scrapped',
        'scrap_qty' => 'ScrapQty',
        'parent_order_item_row_id' => 'ParentOrderItemRowId',
        'additional_cost' => 'AdditionalCost',
        'c_currency' => 'cCurrency',
        'pk_return_id' => 'pkReturnId',
        'channel_reason' => 'ChannelReason',
        'channel_reason_sec' => 'ChannelReasonSec',
        'return_date' => 'ReturnDate',
        'despatch_unit_value' => 'DespatchUnitValue',
        'batch_inventory' => 'BatchInventory'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'fk_order_item_row_id' => 'setFkOrderItemRowId',
        'order_item_batch_id' => 'setOrderItemBatchId',
        'stock_item_id' => 'setStockItemId',
        'batch_inventory_id' => 'setBatchInventoryId',
        'batch_number' => 'setBatchNumber',
        'row_type' => 'setRowType',
        'sku' => 'setSku',
        'item_title' => 'setItemTitle',
        'return_qty' => 'setReturnQty',
        'max_return_qty' => 'setMaxReturnQty',
        'new_qty' => 'setNewQty',
        'new_sku' => 'setNewSku',
        'new_title' => 'setNewTitle',
        'fk_new_stock_item_id' => 'setFkNewStockItemId',
        'category' => 'setCategory',
        'reason' => 'setReason',
        'fk_return_location_id' => 'setFkReturnLocationId',
        'return_location' => 'setReturnLocation',
        'pending_refund_amount' => 'setPendingRefundAmount',
        'scrapped' => 'setScrapped',
        'scrap_qty' => 'setScrapQty',
        'parent_order_item_row_id' => 'setParentOrderItemRowId',
        'additional_cost' => 'setAdditionalCost',
        'c_currency' => 'setCCurrency',
        'pk_return_id' => 'setPkReturnId',
        'channel_reason' => 'setChannelReason',
        'channel_reason_sec' => 'setChannelReasonSec',
        'return_date' => 'setReturnDate',
        'despatch_unit_value' => 'setDespatchUnitValue',
        'batch_inventory' => 'setBatchInventory'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'fk_order_item_row_id' => 'getFkOrderItemRowId',
        'order_item_batch_id' => 'getOrderItemBatchId',
        'stock_item_id' => 'getStockItemId',
        'batch_inventory_id' => 'getBatchInventoryId',
        'batch_number' => 'getBatchNumber',
        'row_type' => 'getRowType',
        'sku' => 'getSku',
        'item_title' => 'getItemTitle',
        'return_qty' => 'getReturnQty',
        'max_return_qty' => 'getMaxReturnQty',
        'new_qty' => 'getNewQty',
        'new_sku' => 'getNewSku',
        'new_title' => 'getNewTitle',
        'fk_new_stock_item_id' => 'getFkNewStockItemId',
        'category' => 'getCategory',
        'reason' => 'getReason',
        'fk_return_location_id' => 'getFkReturnLocationId',
        'return_location' => 'getReturnLocation',
        'pending_refund_amount' => 'getPendingRefundAmount',
        'scrapped' => 'getScrapped',
        'scrap_qty' => 'getScrapQty',
        'parent_order_item_row_id' => 'getParentOrderItemRowId',
        'additional_cost' => 'getAdditionalCost',
        'c_currency' => 'getCCurrency',
        'pk_return_id' => 'getPkReturnId',
        'channel_reason' => 'getChannelReason',
        'channel_reason_sec' => 'getChannelReasonSec',
        'return_date' => 'getReturnDate',
        'despatch_unit_value' => 'getDespatchUnitValue',
        'batch_inventory' => 'getBatchInventory'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('fk_order_item_row_id', $data ?? [], null);
        $this->setIfExists('order_item_batch_id', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('batch_inventory_id', $data ?? [], null);
        $this->setIfExists('batch_number', $data ?? [], null);
        $this->setIfExists('row_type', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('return_qty', $data ?? [], null);
        $this->setIfExists('max_return_qty', $data ?? [], null);
        $this->setIfExists('new_qty', $data ?? [], null);
        $this->setIfExists('new_sku', $data ?? [], null);
        $this->setIfExists('new_title', $data ?? [], null);
        $this->setIfExists('fk_new_stock_item_id', $data ?? [], null);
        $this->setIfExists('category', $data ?? [], null);
        $this->setIfExists('reason', $data ?? [], null);
        $this->setIfExists('fk_return_location_id', $data ?? [], null);
        $this->setIfExists('return_location', $data ?? [], null);
        $this->setIfExists('pending_refund_amount', $data ?? [], null);
        $this->setIfExists('scrapped', $data ?? [], null);
        $this->setIfExists('scrap_qty', $data ?? [], null);
        $this->setIfExists('parent_order_item_row_id', $data ?? [], null);
        $this->setIfExists('additional_cost', $data ?? [], null);
        $this->setIfExists('c_currency', $data ?? [], null);
        $this->setIfExists('pk_return_id', $data ?? [], null);
        $this->setIfExists('channel_reason', $data ?? [], null);
        $this->setIfExists('channel_reason_sec', $data ?? [], null);
        $this->setIfExists('return_date', $data ?? [], null);
        $this->setIfExists('despatch_unit_value', $data ?? [], null);
        $this->setIfExists('batch_inventory', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets fk_order_item_row_id
     *
     * @return string|null
     */
    public function getFkOrderItemRowId()
    {
        return $this->container['fk_order_item_row_id'];
    }

    /**
     * Sets fk_order_item_row_id
     *
     * @param string|null $fk_order_item_row_id Order item record row ID
     *
     * @return self
     */
    public function setFkOrderItemRowId($fk_order_item_row_id)
    {
        if (is_null($fk_order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_order_item_row_id cannot be null');
        }
        $this->container['fk_order_item_row_id'] = $fk_order_item_row_id;

        return $this;
    }

    /**
     * Gets order_item_batch_id
     *
     * @return int|null
     */
    public function getOrderItemBatchId()
    {
        return $this->container['order_item_batch_id'];
    }

    /**
     * Sets order_item_batch_id
     *
     * @param int|null $order_item_batch_id Order item batch id
     *
     * @return self
     */
    public function setOrderItemBatchId($order_item_batch_id)
    {
        if (is_null($order_item_batch_id)) {
            throw new \InvalidArgumentException('non-nullable order_item_batch_id cannot be null');
        }
        $this->container['order_item_batch_id'] = $order_item_batch_id;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets batch_inventory_id
     *
     * @return int|null
     */
    public function getBatchInventoryId()
    {
        return $this->container['batch_inventory_id'];
    }

    /**
     * Sets batch_inventory_id
     *
     * @param int|null $batch_inventory_id Batch Inventory Id
     *
     * @return self
     */
    public function setBatchInventoryId($batch_inventory_id)
    {
        if (is_null($batch_inventory_id)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory_id cannot be null');
        }
        $this->container['batch_inventory_id'] = $batch_inventory_id;

        return $this;
    }

    /**
     * Gets batch_number
     *
     * @return string|null
     */
    public function getBatchNumber()
    {
        return $this->container['batch_number'];
    }

    /**
     * Sets batch_number
     *
     * @param string|null $batch_number Batch number
     *
     * @return self
     */
    public function setBatchNumber($batch_number)
    {
        if (is_null($batch_number)) {
            throw new \InvalidArgumentException('non-nullable batch_number cannot be null');
        }
        $this->container['batch_number'] = $batch_number;

        return $this;
    }

    /**
     * Gets row_type
     *
     * @return string|null
     */
    public function getRowType()
    {
        return $this->container['row_type'];
    }

    /**
     * Sets row_type
     *
     * @param string|null $row_type Record type
     *
     * @return self
     */
    public function setRowType($row_type)
    {
        if (is_null($row_type)) {
            throw new \InvalidArgumentException('non-nullable row_type cannot be null');
        }
        $this->container['row_type'] = $row_type;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title Product title
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets return_qty
     *
     * @return int|null
     */
    public function getReturnQty()
    {
        return $this->container['return_qty'];
    }

    /**
     * Sets return_qty
     *
     * @param int|null $return_qty Return quantity
     *
     * @return self
     */
    public function setReturnQty($return_qty)
    {
        if (is_null($return_qty)) {
            throw new \InvalidArgumentException('non-nullable return_qty cannot be null');
        }
        $this->container['return_qty'] = $return_qty;

        return $this;
    }

    /**
     * Gets max_return_qty
     *
     * @return int|null
     */
    public function getMaxReturnQty()
    {
        return $this->container['max_return_qty'];
    }

    /**
     * Sets max_return_qty
     *
     * @param int|null $max_return_qty Maximum returned quantity
     *
     * @return self
     */
    public function setMaxReturnQty($max_return_qty)
    {
        if (is_null($max_return_qty)) {
            throw new \InvalidArgumentException('non-nullable max_return_qty cannot be null');
        }
        $this->container['max_return_qty'] = $max_return_qty;

        return $this;
    }

    /**
     * Gets new_qty
     *
     * @return int|null
     */
    public function getNewQty()
    {
        return $this->container['new_qty'];
    }

    /**
     * Sets new_qty
     *
     * @param int|null $new_qty New quantity after return
     *
     * @return self
     */
    public function setNewQty($new_qty)
    {
        if (is_null($new_qty)) {
            throw new \InvalidArgumentException('non-nullable new_qty cannot be null');
        }
        $this->container['new_qty'] = $new_qty;

        return $this;
    }

    /**
     * Gets new_sku
     *
     * @return string|null
     */
    public function getNewSku()
    {
        return $this->container['new_sku'];
    }

    /**
     * Sets new_sku
     *
     * @param string|null $new_sku New product SKU after return
     *
     * @return self
     */
    public function setNewSku($new_sku)
    {
        if (is_null($new_sku)) {
            throw new \InvalidArgumentException('non-nullable new_sku cannot be null');
        }
        $this->container['new_sku'] = $new_sku;

        return $this;
    }

    /**
     * Gets new_title
     *
     * @return string|null
     */
    public function getNewTitle()
    {
        return $this->container['new_title'];
    }

    /**
     * Sets new_title
     *
     * @param string|null $new_title New product title after return
     *
     * @return self
     */
    public function setNewTitle($new_title)
    {
        if (is_null($new_title)) {
            throw new \InvalidArgumentException('non-nullable new_title cannot be null');
        }
        $this->container['new_title'] = $new_title;

        return $this;
    }

    /**
     * Gets fk_new_stock_item_id
     *
     * @return string|null
     */
    public function getFkNewStockItemId()
    {
        return $this->container['fk_new_stock_item_id'];
    }

    /**
     * Sets fk_new_stock_item_id
     *
     * @param string|null $fk_new_stock_item_id New returned stock item ID
     *
     * @return self
     */
    public function setFkNewStockItemId($fk_new_stock_item_id)
    {
        if (is_null($fk_new_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable fk_new_stock_item_id cannot be null');
        }
        $this->container['fk_new_stock_item_id'] = $fk_new_stock_item_id;

        return $this;
    }

    /**
     * Gets category
     *
     * @return string|null
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     *
     * @param string|null $category Product category
     *
     * @return self
     */
    public function setCategory($category)
    {
        if (is_null($category)) {
            throw new \InvalidArgumentException('non-nullable category cannot be null');
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets reason
     *
     * @return string|null
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     *
     * @param string|null $reason Return result
     *
     * @return self
     */
    public function setReason($reason)
    {
        if (is_null($reason)) {
            throw new \InvalidArgumentException('non-nullable reason cannot be null');
        }
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets fk_return_location_id
     *
     * @return string|null
     */
    public function getFkReturnLocationId()
    {
        return $this->container['fk_return_location_id'];
    }

    /**
     * Sets fk_return_location_id
     *
     * @param string|null $fk_return_location_id In which location item was returned (Location ID)
     *
     * @return self
     */
    public function setFkReturnLocationId($fk_return_location_id)
    {
        if (is_null($fk_return_location_id)) {
            throw new \InvalidArgumentException('non-nullable fk_return_location_id cannot be null');
        }
        $this->container['fk_return_location_id'] = $fk_return_location_id;

        return $this;
    }

    /**
     * Gets return_location
     *
     * @return string|null
     */
    public function getReturnLocation()
    {
        return $this->container['return_location'];
    }

    /**
     * Sets return_location
     *
     * @param string|null $return_location In which location item was returned (Location name)
     *
     * @return self
     */
    public function setReturnLocation($return_location)
    {
        if (is_null($return_location)) {
            throw new \InvalidArgumentException('non-nullable return_location cannot be null');
        }
        $this->container['return_location'] = $return_location;

        return $this;
    }

    /**
     * Gets pending_refund_amount
     *
     * @return float|null
     */
    public function getPendingRefundAmount()
    {
        return $this->container['pending_refund_amount'];
    }

    /**
     * Sets pending_refund_amount
     *
     * @param float|null $pending_refund_amount Refund amount still pending
     *
     * @return self
     */
    public function setPendingRefundAmount($pending_refund_amount)
    {
        if (is_null($pending_refund_amount)) {
            throw new \InvalidArgumentException('non-nullable pending_refund_amount cannot be null');
        }
        $this->container['pending_refund_amount'] = $pending_refund_amount;

        return $this;
    }

    /**
     * Gets scrapped
     *
     * @return bool|null
     */
    public function getScrapped()
    {
        return $this->container['scrapped'];
    }

    /**
     * Sets scrapped
     *
     * @param bool|null $scrapped If return scraped
     *
     * @return self
     */
    public function setScrapped($scrapped)
    {
        if (is_null($scrapped)) {
            throw new \InvalidArgumentException('non-nullable scrapped cannot be null');
        }
        $this->container['scrapped'] = $scrapped;

        return $this;
    }

    /**
     * Gets scrap_qty
     *
     * @return int|null
     */
    public function getScrapQty()
    {
        return $this->container['scrap_qty'];
    }

    /**
     * Sets scrap_qty
     *
     * @param int|null $scrap_qty Scraped quantity
     *
     * @return self
     */
    public function setScrapQty($scrap_qty)
    {
        if (is_null($scrap_qty)) {
            throw new \InvalidArgumentException('non-nullable scrap_qty cannot be null');
        }
        $this->container['scrap_qty'] = $scrap_qty;

        return $this;
    }

    /**
     * Gets parent_order_item_row_id
     *
     * @return string|null
     */
    public function getParentOrderItemRowId()
    {
        return $this->container['parent_order_item_row_id'];
    }

    /**
     * Sets parent_order_item_row_id
     *
     * @param string|null $parent_order_item_row_id Parent prder item record row ID
     *
     * @return self
     */
    public function setParentOrderItemRowId($parent_order_item_row_id)
    {
        if (is_null($parent_order_item_row_id)) {
            throw new \InvalidArgumentException('non-nullable parent_order_item_row_id cannot be null');
        }
        $this->container['parent_order_item_row_id'] = $parent_order_item_row_id;

        return $this;
    }

    /**
     * Gets additional_cost
     *
     * @return float|null
     */
    public function getAdditionalCost()
    {
        return $this->container['additional_cost'];
    }

    /**
     * Sets additional_cost
     *
     * @param float|null $additional_cost Additional cost value
     *
     * @return self
     */
    public function setAdditionalCost($additional_cost)
    {
        if (is_null($additional_cost)) {
            throw new \InvalidArgumentException('non-nullable additional_cost cannot be null');
        }
        $this->container['additional_cost'] = $additional_cost;

        return $this;
    }

    /**
     * Gets c_currency
     *
     * @return string|null
     */
    public function getCCurrency()
    {
        return $this->container['c_currency'];
    }

    /**
     * Sets c_currency
     *
     * @param string|null $c_currency Currency
     *
     * @return self
     */
    public function setCCurrency($c_currency)
    {
        if (is_null($c_currency)) {
            throw new \InvalidArgumentException('non-nullable c_currency cannot be null');
        }
        $this->container['c_currency'] = $c_currency;

        return $this;
    }

    /**
     * Gets pk_return_id
     *
     * @return int|null
     */
    public function getPkReturnId()
    {
        return $this->container['pk_return_id'];
    }

    /**
     * Sets pk_return_id
     *
     * @param int|null $pk_return_id Return ID
     *
     * @return self
     */
    public function setPkReturnId($pk_return_id)
    {
        if (is_null($pk_return_id)) {
            throw new \InvalidArgumentException('non-nullable pk_return_id cannot be null');
        }
        $this->container['pk_return_id'] = $pk_return_id;

        return $this;
    }

    /**
     * Gets channel_reason
     *
     * @return string|null
     */
    public function getChannelReason()
    {
        return $this->container['channel_reason'];
    }

    /**
     * Sets channel_reason
     *
     * @param string|null $channel_reason Channel return ID
     *
     * @return self
     */
    public function setChannelReason($channel_reason)
    {
        if (is_null($channel_reason)) {
            throw new \InvalidArgumentException('non-nullable channel_reason cannot be null');
        }
        $this->container['channel_reason'] = $channel_reason;

        return $this;
    }

    /**
     * Gets channel_reason_sec
     *
     * @return string|null
     */
    public function getChannelReasonSec()
    {
        return $this->container['channel_reason_sec'];
    }

    /**
     * Sets channel_reason_sec
     *
     * @param string|null $channel_reason_sec Channel secondary reason ID
     *
     * @return self
     */
    public function setChannelReasonSec($channel_reason_sec)
    {
        if (is_null($channel_reason_sec)) {
            throw new \InvalidArgumentException('non-nullable channel_reason_sec cannot be null');
        }
        $this->container['channel_reason_sec'] = $channel_reason_sec;

        return $this;
    }

    /**
     * Gets return_date
     *
     * @return \DateTime|null
     */
    public function getReturnDate()
    {
        return $this->container['return_date'];
    }

    /**
     * Sets return_date
     *
     * @param \DateTime|null $return_date When return was made
     *
     * @return self
     */
    public function setReturnDate($return_date)
    {
        if (is_null($return_date)) {
            throw new \InvalidArgumentException('non-nullable return_date cannot be null');
        }
        $this->container['return_date'] = $return_date;

        return $this;
    }

    /**
     * Gets despatch_unit_value
     *
     * @return float|null
     */
    public function getDespatchUnitValue()
    {
        return $this->container['despatch_unit_value'];
    }

    /**
     * Sets despatch_unit_value
     *
     * @param float|null $despatch_unit_value Unit value of item at time of despatch
     *
     * @return self
     */
    public function setDespatchUnitValue($despatch_unit_value)
    {
        if (is_null($despatch_unit_value)) {
            throw new \InvalidArgumentException('non-nullable despatch_unit_value cannot be null');
        }
        $this->container['despatch_unit_value'] = $despatch_unit_value;

        return $this;
    }

    /**
     * Gets batch_inventory
     *
     * @return \Linnworks\ReturnsRefunds\Model\StockItemBatchInventory|null
     */
    public function getBatchInventory()
    {
        return $this->container['batch_inventory'];
    }

    /**
     * Sets batch_inventory
     *
     * @param \Linnworks\ReturnsRefunds\Model\StockItemBatchInventory|null $batch_inventory batch_inventory
     *
     * @return self
     */
    public function setBatchInventory($batch_inventory)
    {
        if (is_null($batch_inventory)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory cannot be null');
        }
        $this->container['batch_inventory'] = $batch_inventory;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


