<?php
/**
 * AcknowledgeRefundErrorsResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Model;

use \ArrayAccess;
use \Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * AcknowledgeRefundErrorsResponse Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class AcknowledgeRefundErrorsResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AcknowledgeRefundErrorsResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'entire_refund_header_set_to_error_acked' => 'bool',
        'refund_header_id' => 'int',
        'refund_reference' => 'string',
        'status' => '\Linnworks\ReturnsRefunds\Model\PostSaleStatus',
        'cannot_refund_reason' => 'string',
        'errors' => 'string[]',
        'refund_lines' => '\Linnworks\ReturnsRefunds\Model\VerifiedRefund[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'entire_refund_header_set_to_error_acked' => null,
        'refund_header_id' => 'int32',
        'refund_reference' => null,
        'status' => null,
        'cannot_refund_reason' => null,
        'errors' => null,
        'refund_lines' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'entire_refund_header_set_to_error_acked' => false,
        'refund_header_id' => false,
        'refund_reference' => false,
        'status' => false,
        'cannot_refund_reason' => false,
        'errors' => false,
        'refund_lines' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'entire_refund_header_set_to_error_acked' => 'EntireRefundHeaderSetToErrorAcked',
        'refund_header_id' => 'RefundHeaderId',
        'refund_reference' => 'RefundReference',
        'status' => 'Status',
        'cannot_refund_reason' => 'CannotRefundReason',
        'errors' => 'Errors',
        'refund_lines' => 'RefundLines'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'entire_refund_header_set_to_error_acked' => 'setEntireRefundHeaderSetToErrorAcked',
        'refund_header_id' => 'setRefundHeaderId',
        'refund_reference' => 'setRefundReference',
        'status' => 'setStatus',
        'cannot_refund_reason' => 'setCannotRefundReason',
        'errors' => 'setErrors',
        'refund_lines' => 'setRefundLines'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'entire_refund_header_set_to_error_acked' => 'getEntireRefundHeaderSetToErrorAcked',
        'refund_header_id' => 'getRefundHeaderId',
        'refund_reference' => 'getRefundReference',
        'status' => 'getStatus',
        'cannot_refund_reason' => 'getCannotRefundReason',
        'errors' => 'getErrors',
        'refund_lines' => 'getRefundLines'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CANNOT_REFUND_REASON_NONE = 'None';
    public const CANNOT_REFUND_REASON_NOT_IMPLEMENTED = 'NotImplemented';
    public const CANNOT_REFUND_REASON_DISABLED_IN_CONFIG = 'DisabledInConfig';
    public const CANNOT_REFUND_REASON_MISSING_ORDER_IN_LINNWORKS = 'MissingOrderInLinnworks';
    public const CANNOT_REFUND_REASON_OPEN_ORDER_IN_LINNWORKS = 'OpenOrderInLinnworks';
    public const CANNOT_REFUND_REASON_ORDER_IS_FULLY_REFUNDED_IN_LINNWORKS = 'OrderIsFullyRefundedInLinnworks';
    public const CANNOT_REFUND_REASON_NO_NEW_REFUNDS_SPECIFIED = 'NoNewRefundsSpecified';
    public const CANNOT_REFUND_REASON_NO_UPDATED_REFUNDS_SPECIFIED = 'NoUpdatedRefundsSpecified';
    public const CANNOT_REFUND_REASON_MULTIPLE_REFERENCES = 'MultipleReferences';
    public const CANNOT_REFUND_REASON_SUB_STATUS_TAG_NOT_IN_THE_SYSTEM = 'SubStatusTagNotInTheSystem';
    public const CANNOT_REFUND_REASON_SUB_STATUS_TAG_IS_NOT_ACTIONABLE = 'SubStatusTagIsNotActionable';
    public const CANNOT_REFUND_REASON_MULTIPLE_SUB_STATUS_TAGS = 'MultipleSubStatusTags';
    public const CANNOT_REFUND_REASON_REFUND_NOT_IN_SYSTEM = 'RefundNotInSystem';
    public const CANNOT_REFUND_REASON_OTHER = 'Other';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCannotRefundReasonAllowableValues()
    {
        return [
            self::CANNOT_REFUND_REASON_NONE,
            self::CANNOT_REFUND_REASON_NOT_IMPLEMENTED,
            self::CANNOT_REFUND_REASON_DISABLED_IN_CONFIG,
            self::CANNOT_REFUND_REASON_MISSING_ORDER_IN_LINNWORKS,
            self::CANNOT_REFUND_REASON_OPEN_ORDER_IN_LINNWORKS,
            self::CANNOT_REFUND_REASON_ORDER_IS_FULLY_REFUNDED_IN_LINNWORKS,
            self::CANNOT_REFUND_REASON_NO_NEW_REFUNDS_SPECIFIED,
            self::CANNOT_REFUND_REASON_NO_UPDATED_REFUNDS_SPECIFIED,
            self::CANNOT_REFUND_REASON_MULTIPLE_REFERENCES,
            self::CANNOT_REFUND_REASON_SUB_STATUS_TAG_NOT_IN_THE_SYSTEM,
            self::CANNOT_REFUND_REASON_SUB_STATUS_TAG_IS_NOT_ACTIONABLE,
            self::CANNOT_REFUND_REASON_MULTIPLE_SUB_STATUS_TAGS,
            self::CANNOT_REFUND_REASON_REFUND_NOT_IN_SYSTEM,
            self::CANNOT_REFUND_REASON_OTHER,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('entire_refund_header_set_to_error_acked', $data ?? [], null);
        $this->setIfExists('refund_header_id', $data ?? [], null);
        $this->setIfExists('refund_reference', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('cannot_refund_reason', $data ?? [], null);
        $this->setIfExists('errors', $data ?? [], null);
        $this->setIfExists('refund_lines', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getCannotRefundReasonAllowableValues();
        if (!is_null($this->container['cannot_refund_reason']) && !in_array($this->container['cannot_refund_reason'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'cannot_refund_reason', must be one of '%s'",
                $this->container['cannot_refund_reason'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets entire_refund_header_set_to_error_acked
     *
     * @return bool|null
     */
    public function getEntireRefundHeaderSetToErrorAcked()
    {
        return $this->container['entire_refund_header_set_to_error_acked'];
    }

    /**
     * Sets entire_refund_header_set_to_error_acked
     *
     * @param bool|null $entire_refund_header_set_to_error_acked Determines whether the entire refund header was set to \"ERROR_ACKED\" state as a result of this call (will be found in the History tab)
     *
     * @return self
     */
    public function setEntireRefundHeaderSetToErrorAcked($entire_refund_header_set_to_error_acked)
    {
        if (is_null($entire_refund_header_set_to_error_acked)) {
            throw new \InvalidArgumentException('non-nullable entire_refund_header_set_to_error_acked cannot be null');
        }
        $this->container['entire_refund_header_set_to_error_acked'] = $entire_refund_header_set_to_error_acked;

        return $this;
    }

    /**
     * Gets refund_header_id
     *
     * @return int|null
     */
    public function getRefundHeaderId()
    {
        return $this->container['refund_header_id'];
    }

    /**
     * Sets refund_header_id
     *
     * @param int|null $refund_header_id The unique identifier for the refund header.
     *
     * @return self
     */
    public function setRefundHeaderId($refund_header_id)
    {
        if (is_null($refund_header_id)) {
            throw new \InvalidArgumentException('non-nullable refund_header_id cannot be null');
        }
        $this->container['refund_header_id'] = $refund_header_id;

        return $this;
    }

    /**
     * Gets refund_reference
     *
     * @return string|null
     */
    public function getRefundReference()
    {
        return $this->container['refund_reference'];
    }

    /**
     * Sets refund_reference
     *
     * @param string|null $refund_reference An automatically generated string to help identify the refund
     *
     * @return self
     */
    public function setRefundReference($refund_reference)
    {
        if (is_null($refund_reference)) {
            throw new \InvalidArgumentException('non-nullable refund_reference cannot be null');
        }
        $this->container['refund_reference'] = $refund_reference;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \Linnworks\ReturnsRefunds\Model\PostSaleStatus|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \Linnworks\ReturnsRefunds\Model\PostSaleStatus|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets cannot_refund_reason
     *
     * @return string|null
     */
    public function getCannotRefundReason()
    {
        return $this->container['cannot_refund_reason'];
    }

    /**
     * Sets cannot_refund_reason
     *
     * @param string|null $cannot_refund_reason If the validation has failed at any stage, this field identifies the cause of the failure
     *
     * @return self
     */
    public function setCannotRefundReason($cannot_refund_reason)
    {
        if (is_null($cannot_refund_reason)) {
            throw new \InvalidArgumentException('non-nullable cannot_refund_reason cannot be null');
        }
        $allowedValues = $this->getCannotRefundReasonAllowableValues();
        if (!in_array($cannot_refund_reason, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'cannot_refund_reason', must be one of '%s'",
                    $cannot_refund_reason,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['cannot_refund_reason'] = $cannot_refund_reason;

        return $this;
    }

    /**
     * Gets errors
     *
     * @return string[]|null
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     *
     * @param string[]|null $errors Any global validation errors are added to this list, as well as any errors from the RefundLines collection
     *
     * @return self
     */
    public function setErrors($errors)
    {
        if (is_null($errors)) {
            throw new \InvalidArgumentException('non-nullable errors cannot be null');
        }
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets refund_lines
     *
     * @return \Linnworks\ReturnsRefunds\Model\VerifiedRefund[]|null
     */
    public function getRefundLines()
    {
        return $this->container['refund_lines'];
    }

    /**
     * Sets refund_lines
     *
     * @param \Linnworks\ReturnsRefunds\Model\VerifiedRefund[]|null $refund_lines A collection of validated line-level refunds, with any applicable errors included
     *
     * @return self
     */
    public function setRefundLines($refund_lines)
    {
        if (is_null($refund_lines)) {
            throw new \InvalidArgumentException('non-nullable refund_lines cannot be null');
        }
        $this->container['refund_lines'] = $refund_lines;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


