<?php
/**
 * ReturnsRefundsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Returns and Refunds API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: returnsrefunds
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\ReturnsRefunds\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Linnworks\ReturnsRefunds\ApiException;
use Linnworks\ReturnsRefunds\Configuration;
use Linnworks\ReturnsRefunds\HeaderSelector;
use Linnworks\ReturnsRefunds\ObjectSerializer;

/**
 * ReturnsRefundsApi Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\ReturnsRefunds
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ReturnsRefundsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'acknowledgeRMAErrors' => [
            'application/json',
        ],
        'acknowledgeRefundErrors' => [
            'application/json',
        ],
        'actionBookedOrder' => [
            'application/json',
        ],
        'actionRMABooking' => [
            'application/json',
        ],
        'actionRefund' => [
            'application/json',
        ],
        'createRMABooking' => [
            'application/json',
        ],
        'createRefund' => [
            'application/json',
        ],
        'createReturnsRefundsCSV' => [
            'application/json',
        ],
        'deleteBookedItem' => [
            'application/json',
        ],
        'deleteBookedOrder' => [
            'application/json',
        ],
        'deletePendingRefundItem' => [
            'application/json',
        ],
        'deleteRMA' => [
            'application/json',
        ],
        'deleteRefund' => [
            'application/json',
        ],
        'editBookedItemInfo' => [
            'application/json',
        ],
        'getActionableRMAHeaders' => [
            'application/json',
        ],
        'getActionableRefundHeaders' => [
            'application/json',
        ],
        'getBookedReturnsExchangeOrders' => [
            'application/json',
        ],
        'getProcessedOrAckedErrorRMAHeaders' => [
            'application/json',
        ],
        'getProcessedOrAckedErrorRefundHeaders' => [
            'application/json',
        ],
        'getRMAHeadersByOrderId' => [
            'application/json',
        ],
        'getRefundHeadersByOrderId' => [
            'application/json',
        ],
        'getRefundLinesByHeaderId' => [
            'application/json',
        ],
        'getRefundOptions' => [
            'application/json',
        ],
        'getRefundOrders' => [
            'application/json',
        ],
        'getReturnOptions' => [
            'application/json',
        ],
        'getSearchTypes' => [
            'application/json',
        ],
        'getTotalRefunds' => [
            'application/json',
        ],
        'getWarehouseLocations' => [
            'application/json',
        ],
        'refundOrder' => [
            'application/json',
        ],
        'searchReturnsRefundsPaged' => [
            'application/json',
        ],
        'updateRMABooking' => [
            'application/json',
        ],
        'updateRefund' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation acknowledgeRMAErrors
     *
     * AcknowledgeRMAErrors
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest $returns_refunds_acknowledge_rma_errors_request returns_refunds_acknowledge_rma_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRMAErrors'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse
     */
    public function acknowledgeRMAErrors($returns_refunds_acknowledge_rma_errors_request, string $contentType = self::contentTypes['acknowledgeRMAErrors'][0])
    {
        list($response) = $this->acknowledgeRMAErrorsWithHttpInfo($returns_refunds_acknowledge_rma_errors_request, $contentType);
        return $response;
    }

    /**
     * Operation acknowledgeRMAErrorsWithHttpInfo
     *
     * AcknowledgeRMAErrors
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest $returns_refunds_acknowledge_rma_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRMAErrors'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function acknowledgeRMAErrorsWithHttpInfo($returns_refunds_acknowledge_rma_errors_request, string $contentType = self::contentTypes['acknowledgeRMAErrors'][0])
    {
        $request = $this->acknowledgeRMAErrorsRequest($returns_refunds_acknowledge_rma_errors_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation acknowledgeRMAErrorsAsync
     *
     * AcknowledgeRMAErrors
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest $returns_refunds_acknowledge_rma_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRMAErrors'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function acknowledgeRMAErrorsAsync($returns_refunds_acknowledge_rma_errors_request, string $contentType = self::contentTypes['acknowledgeRMAErrors'][0])
    {
        return $this->acknowledgeRMAErrorsAsyncWithHttpInfo($returns_refunds_acknowledge_rma_errors_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation acknowledgeRMAErrorsAsyncWithHttpInfo
     *
     * AcknowledgeRMAErrors
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest $returns_refunds_acknowledge_rma_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRMAErrors'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function acknowledgeRMAErrorsAsyncWithHttpInfo($returns_refunds_acknowledge_rma_errors_request, string $contentType = self::contentTypes['acknowledgeRMAErrors'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse';
        $request = $this->acknowledgeRMAErrorsRequest($returns_refunds_acknowledge_rma_errors_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'acknowledgeRMAErrors'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest $returns_refunds_acknowledge_rma_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRMAErrors'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function acknowledgeRMAErrorsRequest($returns_refunds_acknowledge_rma_errors_request, string $contentType = self::contentTypes['acknowledgeRMAErrors'][0])
    {

        // verify the required parameter 'returns_refunds_acknowledge_rma_errors_request' is set
        if ($returns_refunds_acknowledge_rma_errors_request === null || (is_array($returns_refunds_acknowledge_rma_errors_request) && count($returns_refunds_acknowledge_rma_errors_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_acknowledge_rma_errors_request when calling acknowledgeRMAErrors'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/AcknowledgeRMAErrors';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_acknowledge_rma_errors_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_acknowledge_rma_errors_request));
            } else {
                $httpBody = $returns_refunds_acknowledge_rma_errors_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation acknowledgeRefundErrors
     *
     * AcknowledgeRefundErrors
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRefundErrorsRequest $returns_refunds_acknowledge_refund_errors_request returns_refunds_acknowledge_refund_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRefundErrors'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse
     */
    public function acknowledgeRefundErrors($returns_refunds_acknowledge_refund_errors_request, string $contentType = self::contentTypes['acknowledgeRefundErrors'][0])
    {
        list($response) = $this->acknowledgeRefundErrorsWithHttpInfo($returns_refunds_acknowledge_refund_errors_request, $contentType);
        return $response;
    }

    /**
     * Operation acknowledgeRefundErrorsWithHttpInfo
     *
     * AcknowledgeRefundErrors
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRefundErrorsRequest $returns_refunds_acknowledge_refund_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRefundErrors'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function acknowledgeRefundErrorsWithHttpInfo($returns_refunds_acknowledge_refund_errors_request, string $contentType = self::contentTypes['acknowledgeRefundErrors'][0])
    {
        $request = $this->acknowledgeRefundErrorsRequest($returns_refunds_acknowledge_refund_errors_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation acknowledgeRefundErrorsAsync
     *
     * AcknowledgeRefundErrors
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRefundErrorsRequest $returns_refunds_acknowledge_refund_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRefundErrors'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function acknowledgeRefundErrorsAsync($returns_refunds_acknowledge_refund_errors_request, string $contentType = self::contentTypes['acknowledgeRefundErrors'][0])
    {
        return $this->acknowledgeRefundErrorsAsyncWithHttpInfo($returns_refunds_acknowledge_refund_errors_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation acknowledgeRefundErrorsAsyncWithHttpInfo
     *
     * AcknowledgeRefundErrors
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRefundErrorsRequest $returns_refunds_acknowledge_refund_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRefundErrors'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function acknowledgeRefundErrorsAsyncWithHttpInfo($returns_refunds_acknowledge_refund_errors_request, string $contentType = self::contentTypes['acknowledgeRefundErrors'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse';
        $request = $this->acknowledgeRefundErrorsRequest($returns_refunds_acknowledge_refund_errors_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'acknowledgeRefundErrors'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRefundErrorsRequest $returns_refunds_acknowledge_refund_errors_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['acknowledgeRefundErrors'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function acknowledgeRefundErrorsRequest($returns_refunds_acknowledge_refund_errors_request, string $contentType = self::contentTypes['acknowledgeRefundErrors'][0])
    {

        // verify the required parameter 'returns_refunds_acknowledge_refund_errors_request' is set
        if ($returns_refunds_acknowledge_refund_errors_request === null || (is_array($returns_refunds_acknowledge_refund_errors_request) && count($returns_refunds_acknowledge_refund_errors_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_acknowledge_refund_errors_request when calling acknowledgeRefundErrors'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/AcknowledgeRefundErrors';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_acknowledge_refund_errors_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_acknowledge_refund_errors_request));
            } else {
                $httpBody = $returns_refunds_acknowledge_refund_errors_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation actionBookedOrder
     *
     * ActionBookedOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionBookedOrderRequest $returns_refunds_action_booked_order_request returns_refunds_action_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionBookedOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function actionBookedOrder($returns_refunds_action_booked_order_request, string $contentType = self::contentTypes['actionBookedOrder'][0])
    {
        $this->actionBookedOrderWithHttpInfo($returns_refunds_action_booked_order_request, $contentType);
    }

    /**
     * Operation actionBookedOrderWithHttpInfo
     *
     * ActionBookedOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionBookedOrderRequest $returns_refunds_action_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionBookedOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function actionBookedOrderWithHttpInfo($returns_refunds_action_booked_order_request, string $contentType = self::contentTypes['actionBookedOrder'][0])
    {
        $request = $this->actionBookedOrderRequest($returns_refunds_action_booked_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation actionBookedOrderAsync
     *
     * ActionBookedOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionBookedOrderRequest $returns_refunds_action_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionBookedOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function actionBookedOrderAsync($returns_refunds_action_booked_order_request, string $contentType = self::contentTypes['actionBookedOrder'][0])
    {
        return $this->actionBookedOrderAsyncWithHttpInfo($returns_refunds_action_booked_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation actionBookedOrderAsyncWithHttpInfo
     *
     * ActionBookedOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionBookedOrderRequest $returns_refunds_action_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionBookedOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function actionBookedOrderAsyncWithHttpInfo($returns_refunds_action_booked_order_request, string $contentType = self::contentTypes['actionBookedOrder'][0])
    {
        $returnType = '';
        $request = $this->actionBookedOrderRequest($returns_refunds_action_booked_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'actionBookedOrder'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionBookedOrderRequest $returns_refunds_action_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionBookedOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function actionBookedOrderRequest($returns_refunds_action_booked_order_request, string $contentType = self::contentTypes['actionBookedOrder'][0])
    {

        // verify the required parameter 'returns_refunds_action_booked_order_request' is set
        if ($returns_refunds_action_booked_order_request === null || (is_array($returns_refunds_action_booked_order_request) && count($returns_refunds_action_booked_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_action_booked_order_request when calling actionBookedOrder'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/ActionBookedOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_action_booked_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_action_booked_order_request));
            } else {
                $httpBody = $returns_refunds_action_booked_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation actionRMABooking
     *
     * ActionRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRMABookingRequest $returns_refunds_action_rma_booking_request returns_refunds_action_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRMABooking'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse
     */
    public function actionRMABooking($returns_refunds_action_rma_booking_request, string $contentType = self::contentTypes['actionRMABooking'][0])
    {
        list($response) = $this->actionRMABookingWithHttpInfo($returns_refunds_action_rma_booking_request, $contentType);
        return $response;
    }

    /**
     * Operation actionRMABookingWithHttpInfo
     *
     * ActionRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRMABookingRequest $returns_refunds_action_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRMABooking'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function actionRMABookingWithHttpInfo($returns_refunds_action_rma_booking_request, string $contentType = self::contentTypes['actionRMABooking'][0])
    {
        $request = $this->actionRMABookingRequest($returns_refunds_action_rma_booking_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation actionRMABookingAsync
     *
     * ActionRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRMABookingRequest $returns_refunds_action_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function actionRMABookingAsync($returns_refunds_action_rma_booking_request, string $contentType = self::contentTypes['actionRMABooking'][0])
    {
        return $this->actionRMABookingAsyncWithHttpInfo($returns_refunds_action_rma_booking_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation actionRMABookingAsyncWithHttpInfo
     *
     * ActionRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRMABookingRequest $returns_refunds_action_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function actionRMABookingAsyncWithHttpInfo($returns_refunds_action_rma_booking_request, string $contentType = self::contentTypes['actionRMABooking'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse';
        $request = $this->actionRMABookingRequest($returns_refunds_action_rma_booking_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'actionRMABooking'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRMABookingRequest $returns_refunds_action_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function actionRMABookingRequest($returns_refunds_action_rma_booking_request, string $contentType = self::contentTypes['actionRMABooking'][0])
    {

        // verify the required parameter 'returns_refunds_action_rma_booking_request' is set
        if ($returns_refunds_action_rma_booking_request === null || (is_array($returns_refunds_action_rma_booking_request) && count($returns_refunds_action_rma_booking_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_action_rma_booking_request when calling actionRMABooking'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/ActionRMABooking';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_action_rma_booking_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_action_rma_booking_request));
            } else {
                $httpBody = $returns_refunds_action_rma_booking_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation actionRefund
     *
     * ActionRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRefundRequest $returns_refunds_action_refund_request returns_refunds_action_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\ActionRefundResponse
     */
    public function actionRefund($returns_refunds_action_refund_request, string $contentType = self::contentTypes['actionRefund'][0])
    {
        list($response) = $this->actionRefundWithHttpInfo($returns_refunds_action_refund_request, $contentType);
        return $response;
    }

    /**
     * Operation actionRefundWithHttpInfo
     *
     * ActionRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRefundRequest $returns_refunds_action_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\ActionRefundResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function actionRefundWithHttpInfo($returns_refunds_action_refund_request, string $contentType = self::contentTypes['actionRefund'][0])
    {
        $request = $this->actionRefundRequest($returns_refunds_action_refund_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\ActionRefundResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\ActionRefundResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\ActionRefundResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\ActionRefundResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\ActionRefundResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation actionRefundAsync
     *
     * ActionRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRefundRequest $returns_refunds_action_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function actionRefundAsync($returns_refunds_action_refund_request, string $contentType = self::contentTypes['actionRefund'][0])
    {
        return $this->actionRefundAsyncWithHttpInfo($returns_refunds_action_refund_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation actionRefundAsyncWithHttpInfo
     *
     * ActionRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRefundRequest $returns_refunds_action_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function actionRefundAsyncWithHttpInfo($returns_refunds_action_refund_request, string $contentType = self::contentTypes['actionRefund'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\ActionRefundResponse';
        $request = $this->actionRefundRequest($returns_refunds_action_refund_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'actionRefund'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRefundRequest $returns_refunds_action_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['actionRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function actionRefundRequest($returns_refunds_action_refund_request, string $contentType = self::contentTypes['actionRefund'][0])
    {

        // verify the required parameter 'returns_refunds_action_refund_request' is set
        if ($returns_refunds_action_refund_request === null || (is_array($returns_refunds_action_refund_request) && count($returns_refunds_action_refund_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_action_refund_request when calling actionRefund'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/ActionRefund';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_action_refund_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_action_refund_request));
            } else {
                $httpBody = $returns_refunds_action_refund_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createRMABooking
     *
     * CreateRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRMABookingRequest $returns_refunds_create_rma_booking_request returns_refunds_create_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRMABooking'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse
     */
    public function createRMABooking($returns_refunds_create_rma_booking_request, string $contentType = self::contentTypes['createRMABooking'][0])
    {
        list($response) = $this->createRMABookingWithHttpInfo($returns_refunds_create_rma_booking_request, $contentType);
        return $response;
    }

    /**
     * Operation createRMABookingWithHttpInfo
     *
     * CreateRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRMABookingRequest $returns_refunds_create_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRMABooking'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRMABookingWithHttpInfo($returns_refunds_create_rma_booking_request, string $contentType = self::contentTypes['createRMABooking'][0])
    {
        $request = $this->createRMABookingRequest($returns_refunds_create_rma_booking_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createRMABookingAsync
     *
     * CreateRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRMABookingRequest $returns_refunds_create_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRMABookingAsync($returns_refunds_create_rma_booking_request, string $contentType = self::contentTypes['createRMABooking'][0])
    {
        return $this->createRMABookingAsyncWithHttpInfo($returns_refunds_create_rma_booking_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createRMABookingAsyncWithHttpInfo
     *
     * CreateRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRMABookingRequest $returns_refunds_create_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRMABookingAsyncWithHttpInfo($returns_refunds_create_rma_booking_request, string $contentType = self::contentTypes['createRMABooking'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse';
        $request = $this->createRMABookingRequest($returns_refunds_create_rma_booking_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createRMABooking'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRMABookingRequest $returns_refunds_create_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRMABookingRequest($returns_refunds_create_rma_booking_request, string $contentType = self::contentTypes['createRMABooking'][0])
    {

        // verify the required parameter 'returns_refunds_create_rma_booking_request' is set
        if ($returns_refunds_create_rma_booking_request === null || (is_array($returns_refunds_create_rma_booking_request) && count($returns_refunds_create_rma_booking_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_create_rma_booking_request when calling createRMABooking'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/CreateRMABooking';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_create_rma_booking_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_create_rma_booking_request));
            } else {
                $httpBody = $returns_refunds_create_rma_booking_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createRefund
     *
     * CreateRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRefundRequest $returns_refunds_create_refund_request returns_refunds_create_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\CreateRefundResponse
     */
    public function createRefund($returns_refunds_create_refund_request, string $contentType = self::contentTypes['createRefund'][0])
    {
        list($response) = $this->createRefundWithHttpInfo($returns_refunds_create_refund_request, $contentType);
        return $response;
    }

    /**
     * Operation createRefundWithHttpInfo
     *
     * CreateRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRefundRequest $returns_refunds_create_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\CreateRefundResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRefundWithHttpInfo($returns_refunds_create_refund_request, string $contentType = self::contentTypes['createRefund'][0])
    {
        $request = $this->createRefundRequest($returns_refunds_create_refund_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\CreateRefundResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\CreateRefundResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\CreateRefundResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\CreateRefundResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\CreateRefundResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createRefundAsync
     *
     * CreateRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRefundRequest $returns_refunds_create_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRefundAsync($returns_refunds_create_refund_request, string $contentType = self::contentTypes['createRefund'][0])
    {
        return $this->createRefundAsyncWithHttpInfo($returns_refunds_create_refund_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createRefundAsyncWithHttpInfo
     *
     * CreateRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRefundRequest $returns_refunds_create_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRefundAsyncWithHttpInfo($returns_refunds_create_refund_request, string $contentType = self::contentTypes['createRefund'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\CreateRefundResponse';
        $request = $this->createRefundRequest($returns_refunds_create_refund_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createRefund'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRefundRequest $returns_refunds_create_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRefundRequest($returns_refunds_create_refund_request, string $contentType = self::contentTypes['createRefund'][0])
    {

        // verify the required parameter 'returns_refunds_create_refund_request' is set
        if ($returns_refunds_create_refund_request === null || (is_array($returns_refunds_create_refund_request) && count($returns_refunds_create_refund_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_create_refund_request when calling createRefund'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/CreateRefund';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_create_refund_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_create_refund_request));
            } else {
                $httpBody = $returns_refunds_create_refund_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReturnsRefundsCSV
     *
     * CreateReturnsRefundsCSV
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  string|null $sort_column The column to sort by (optional)
     * @param  bool|null $sort_direction The sort direction (true &#x3D; ascending, false &#x3D; descending). (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnsRefundsCSV'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function createReturnsRefundsCSV($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $sort_column = null, $sort_direction = null, $history_type = null, string $contentType = self::contentTypes['createReturnsRefundsCSV'][0])
    {
        list($response) = $this->createReturnsRefundsCSVWithHttpInfo($from, $to, $date_type, $search_field, $exact_match, $search_term, $sort_column, $sort_direction, $history_type, $contentType);
        return $response;
    }

    /**
     * Operation createReturnsRefundsCSVWithHttpInfo
     *
     * CreateReturnsRefundsCSV
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  string|null $sort_column The column to sort by (optional)
     * @param  bool|null $sort_direction The sort direction (true &#x3D; ascending, false &#x3D; descending). (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnsRefundsCSV'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReturnsRefundsCSVWithHttpInfo($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $sort_column = null, $sort_direction = null, $history_type = null, string $contentType = self::contentTypes['createReturnsRefundsCSV'][0])
    {
        $request = $this->createReturnsRefundsCSVRequest($from, $to, $date_type, $search_field, $exact_match, $search_term, $sort_column, $sort_direction, $history_type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createReturnsRefundsCSVAsync
     *
     * CreateReturnsRefundsCSV
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  string|null $sort_column The column to sort by (optional)
     * @param  bool|null $sort_direction The sort direction (true &#x3D; ascending, false &#x3D; descending). (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnsRefundsCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReturnsRefundsCSVAsync($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $sort_column = null, $sort_direction = null, $history_type = null, string $contentType = self::contentTypes['createReturnsRefundsCSV'][0])
    {
        return $this->createReturnsRefundsCSVAsyncWithHttpInfo($from, $to, $date_type, $search_field, $exact_match, $search_term, $sort_column, $sort_direction, $history_type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createReturnsRefundsCSVAsyncWithHttpInfo
     *
     * CreateReturnsRefundsCSV
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  string|null $sort_column The column to sort by (optional)
     * @param  bool|null $sort_direction The sort direction (true &#x3D; ascending, false &#x3D; descending). (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnsRefundsCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReturnsRefundsCSVAsyncWithHttpInfo($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $sort_column = null, $sort_direction = null, $history_type = null, string $contentType = self::contentTypes['createReturnsRefundsCSV'][0])
    {
        $returnType = 'string';
        $request = $this->createReturnsRefundsCSVRequest($from, $to, $date_type, $search_field, $exact_match, $search_term, $sort_column, $sort_direction, $history_type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReturnsRefundsCSV'
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  string|null $sort_column The column to sort by (optional)
     * @param  bool|null $sort_direction The sort direction (true &#x3D; ascending, false &#x3D; descending). (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createReturnsRefundsCSV'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createReturnsRefundsCSVRequest($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $sort_column = null, $sort_direction = null, $history_type = null, string $contentType = self::contentTypes['createReturnsRefundsCSV'][0])
    {











        $resourcePath = '/api/ReturnsRefunds/CreateReturnsRefundsCSV';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from,
            'from', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to,
            'to', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_type,
            'dateType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search_field,
            'searchField', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exact_match,
            'exactMatch', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search_term,
            'searchTerm', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_column,
            'sortColumn', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sort_direction,
            'sortDirection', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $history_type,
            'historyType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBookedItem
     *
     * DeleteBookedItem
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedItemRequest $returns_refunds_delete_booked_item_request returns_refunds_delete_booked_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBookedItem($returns_refunds_delete_booked_item_request, string $contentType = self::contentTypes['deleteBookedItem'][0])
    {
        $this->deleteBookedItemWithHttpInfo($returns_refunds_delete_booked_item_request, $contentType);
    }

    /**
     * Operation deleteBookedItemWithHttpInfo
     *
     * DeleteBookedItem
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedItemRequest $returns_refunds_delete_booked_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBookedItemWithHttpInfo($returns_refunds_delete_booked_item_request, string $contentType = self::contentTypes['deleteBookedItem'][0])
    {
        $request = $this->deleteBookedItemRequest($returns_refunds_delete_booked_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteBookedItemAsync
     *
     * DeleteBookedItem
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedItemRequest $returns_refunds_delete_booked_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBookedItemAsync($returns_refunds_delete_booked_item_request, string $contentType = self::contentTypes['deleteBookedItem'][0])
    {
        return $this->deleteBookedItemAsyncWithHttpInfo($returns_refunds_delete_booked_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBookedItemAsyncWithHttpInfo
     *
     * DeleteBookedItem
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedItemRequest $returns_refunds_delete_booked_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBookedItemAsyncWithHttpInfo($returns_refunds_delete_booked_item_request, string $contentType = self::contentTypes['deleteBookedItem'][0])
    {
        $returnType = '';
        $request = $this->deleteBookedItemRequest($returns_refunds_delete_booked_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBookedItem'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedItemRequest $returns_refunds_delete_booked_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBookedItemRequest($returns_refunds_delete_booked_item_request, string $contentType = self::contentTypes['deleteBookedItem'][0])
    {

        // verify the required parameter 'returns_refunds_delete_booked_item_request' is set
        if ($returns_refunds_delete_booked_item_request === null || (is_array($returns_refunds_delete_booked_item_request) && count($returns_refunds_delete_booked_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_delete_booked_item_request when calling deleteBookedItem'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/DeleteBookedItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_delete_booked_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_delete_booked_item_request));
            } else {
                $httpBody = $returns_refunds_delete_booked_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBookedOrder
     *
     * DeleteBookedOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedOrderRequest $returns_refunds_delete_booked_order_request returns_refunds_delete_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBookedOrder($returns_refunds_delete_booked_order_request, string $contentType = self::contentTypes['deleteBookedOrder'][0])
    {
        $this->deleteBookedOrderWithHttpInfo($returns_refunds_delete_booked_order_request, $contentType);
    }

    /**
     * Operation deleteBookedOrderWithHttpInfo
     *
     * DeleteBookedOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedOrderRequest $returns_refunds_delete_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBookedOrderWithHttpInfo($returns_refunds_delete_booked_order_request, string $contentType = self::contentTypes['deleteBookedOrder'][0])
    {
        $request = $this->deleteBookedOrderRequest($returns_refunds_delete_booked_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteBookedOrderAsync
     *
     * DeleteBookedOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedOrderRequest $returns_refunds_delete_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBookedOrderAsync($returns_refunds_delete_booked_order_request, string $contentType = self::contentTypes['deleteBookedOrder'][0])
    {
        return $this->deleteBookedOrderAsyncWithHttpInfo($returns_refunds_delete_booked_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBookedOrderAsyncWithHttpInfo
     *
     * DeleteBookedOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedOrderRequest $returns_refunds_delete_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBookedOrderAsyncWithHttpInfo($returns_refunds_delete_booked_order_request, string $contentType = self::contentTypes['deleteBookedOrder'][0])
    {
        $returnType = '';
        $request = $this->deleteBookedOrderRequest($returns_refunds_delete_booked_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBookedOrder'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedOrderRequest $returns_refunds_delete_booked_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBookedOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBookedOrderRequest($returns_refunds_delete_booked_order_request, string $contentType = self::contentTypes['deleteBookedOrder'][0])
    {

        // verify the required parameter 'returns_refunds_delete_booked_order_request' is set
        if ($returns_refunds_delete_booked_order_request === null || (is_array($returns_refunds_delete_booked_order_request) && count($returns_refunds_delete_booked_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_delete_booked_order_request when calling deleteBookedOrder'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/DeleteBookedOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_delete_booked_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_delete_booked_order_request));
            } else {
                $httpBody = $returns_refunds_delete_booked_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deletePendingRefundItem
     *
     * DeletePendingRefundItem
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeletePendingRefundItemRequest $returns_refunds_delete_pending_refund_item_request returns_refunds_delete_pending_refund_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePendingRefundItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     * @deprecated
     */
    public function deletePendingRefundItem($returns_refunds_delete_pending_refund_item_request, string $contentType = self::contentTypes['deletePendingRefundItem'][0])
    {
        $this->deletePendingRefundItemWithHttpInfo($returns_refunds_delete_pending_refund_item_request, $contentType);
    }

    /**
     * Operation deletePendingRefundItemWithHttpInfo
     *
     * DeletePendingRefundItem
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeletePendingRefundItemRequest $returns_refunds_delete_pending_refund_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePendingRefundItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function deletePendingRefundItemWithHttpInfo($returns_refunds_delete_pending_refund_item_request, string $contentType = self::contentTypes['deletePendingRefundItem'][0])
    {
        $request = $this->deletePendingRefundItemRequest($returns_refunds_delete_pending_refund_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deletePendingRefundItemAsync
     *
     * DeletePendingRefundItem
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeletePendingRefundItemRequest $returns_refunds_delete_pending_refund_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePendingRefundItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deletePendingRefundItemAsync($returns_refunds_delete_pending_refund_item_request, string $contentType = self::contentTypes['deletePendingRefundItem'][0])
    {
        return $this->deletePendingRefundItemAsyncWithHttpInfo($returns_refunds_delete_pending_refund_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deletePendingRefundItemAsyncWithHttpInfo
     *
     * DeletePendingRefundItem
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeletePendingRefundItemRequest $returns_refunds_delete_pending_refund_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePendingRefundItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deletePendingRefundItemAsyncWithHttpInfo($returns_refunds_delete_pending_refund_item_request, string $contentType = self::contentTypes['deletePendingRefundItem'][0])
    {
        $returnType = '';
        $request = $this->deletePendingRefundItemRequest($returns_refunds_delete_pending_refund_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deletePendingRefundItem'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeletePendingRefundItemRequest $returns_refunds_delete_pending_refund_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deletePendingRefundItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function deletePendingRefundItemRequest($returns_refunds_delete_pending_refund_item_request, string $contentType = self::contentTypes['deletePendingRefundItem'][0])
    {

        // verify the required parameter 'returns_refunds_delete_pending_refund_item_request' is set
        if ($returns_refunds_delete_pending_refund_item_request === null || (is_array($returns_refunds_delete_pending_refund_item_request) && count($returns_refunds_delete_pending_refund_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_delete_pending_refund_item_request when calling deletePendingRefundItem'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/DeletePendingRefundItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_delete_pending_refund_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_delete_pending_refund_item_request));
            } else {
                $httpBody = $returns_refunds_delete_pending_refund_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteRMA
     *
     * DeleteRMA
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRMARequest $returns_refunds_delete_rma_request returns_refunds_delete_rma_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRMA'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteRMA($returns_refunds_delete_rma_request, string $contentType = self::contentTypes['deleteRMA'][0])
    {
        list($response) = $this->deleteRMAWithHttpInfo($returns_refunds_delete_rma_request, $contentType);
        return $response;
    }

    /**
     * Operation deleteRMAWithHttpInfo
     *
     * DeleteRMA
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRMARequest $returns_refunds_delete_rma_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRMA'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRMAWithHttpInfo($returns_refunds_delete_rma_request, string $contentType = self::contentTypes['deleteRMA'][0])
    {
        $request = $this->deleteRMARequest($returns_refunds_delete_rma_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteRMAAsync
     *
     * DeleteRMA
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRMARequest $returns_refunds_delete_rma_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRMA'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteRMAAsync($returns_refunds_delete_rma_request, string $contentType = self::contentTypes['deleteRMA'][0])
    {
        return $this->deleteRMAAsyncWithHttpInfo($returns_refunds_delete_rma_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteRMAAsyncWithHttpInfo
     *
     * DeleteRMA
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRMARequest $returns_refunds_delete_rma_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRMA'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteRMAAsyncWithHttpInfo($returns_refunds_delete_rma_request, string $contentType = self::contentTypes['deleteRMA'][0])
    {
        $returnType = 'object';
        $request = $this->deleteRMARequest($returns_refunds_delete_rma_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteRMA'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRMARequest $returns_refunds_delete_rma_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRMA'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteRMARequest($returns_refunds_delete_rma_request, string $contentType = self::contentTypes['deleteRMA'][0])
    {

        // verify the required parameter 'returns_refunds_delete_rma_request' is set
        if ($returns_refunds_delete_rma_request === null || (is_array($returns_refunds_delete_rma_request) && count($returns_refunds_delete_rma_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_delete_rma_request when calling deleteRMA'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/DeleteRMA';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_delete_rma_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_delete_rma_request));
            } else {
                $httpBody = $returns_refunds_delete_rma_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteRefund
     *
     * DeleteRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRefundRequest $returns_refunds_delete_refund_request returns_refunds_delete_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteRefund($returns_refunds_delete_refund_request, string $contentType = self::contentTypes['deleteRefund'][0])
    {
        list($response) = $this->deleteRefundWithHttpInfo($returns_refunds_delete_refund_request, $contentType);
        return $response;
    }

    /**
     * Operation deleteRefundWithHttpInfo
     *
     * DeleteRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRefundRequest $returns_refunds_delete_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRefundWithHttpInfo($returns_refunds_delete_refund_request, string $contentType = self::contentTypes['deleteRefund'][0])
    {
        $request = $this->deleteRefundRequest($returns_refunds_delete_refund_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteRefundAsync
     *
     * DeleteRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRefundRequest $returns_refunds_delete_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteRefundAsync($returns_refunds_delete_refund_request, string $contentType = self::contentTypes['deleteRefund'][0])
    {
        return $this->deleteRefundAsyncWithHttpInfo($returns_refunds_delete_refund_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteRefundAsyncWithHttpInfo
     *
     * DeleteRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRefundRequest $returns_refunds_delete_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteRefundAsyncWithHttpInfo($returns_refunds_delete_refund_request, string $contentType = self::contentTypes['deleteRefund'][0])
    {
        $returnType = 'object';
        $request = $this->deleteRefundRequest($returns_refunds_delete_refund_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteRefund'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRefundRequest $returns_refunds_delete_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteRefundRequest($returns_refunds_delete_refund_request, string $contentType = self::contentTypes['deleteRefund'][0])
    {

        // verify the required parameter 'returns_refunds_delete_refund_request' is set
        if ($returns_refunds_delete_refund_request === null || (is_array($returns_refunds_delete_refund_request) && count($returns_refunds_delete_refund_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_delete_refund_request when calling deleteRefund'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/DeleteRefund';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_delete_refund_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_delete_refund_request));
            } else {
                $httpBody = $returns_refunds_delete_refund_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation editBookedItemInfo
     *
     * EditBookedItemInfo
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsEditBookedItemInfoRequest $returns_refunds_edit_booked_item_info_request returns_refunds_edit_booked_item_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editBookedItemInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function editBookedItemInfo($returns_refunds_edit_booked_item_info_request, string $contentType = self::contentTypes['editBookedItemInfo'][0])
    {
        $this->editBookedItemInfoWithHttpInfo($returns_refunds_edit_booked_item_info_request, $contentType);
    }

    /**
     * Operation editBookedItemInfoWithHttpInfo
     *
     * EditBookedItemInfo
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsEditBookedItemInfoRequest $returns_refunds_edit_booked_item_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editBookedItemInfo'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function editBookedItemInfoWithHttpInfo($returns_refunds_edit_booked_item_info_request, string $contentType = self::contentTypes['editBookedItemInfo'][0])
    {
        $request = $this->editBookedItemInfoRequest($returns_refunds_edit_booked_item_info_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation editBookedItemInfoAsync
     *
     * EditBookedItemInfo
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsEditBookedItemInfoRequest $returns_refunds_edit_booked_item_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editBookedItemInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function editBookedItemInfoAsync($returns_refunds_edit_booked_item_info_request, string $contentType = self::contentTypes['editBookedItemInfo'][0])
    {
        return $this->editBookedItemInfoAsyncWithHttpInfo($returns_refunds_edit_booked_item_info_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation editBookedItemInfoAsyncWithHttpInfo
     *
     * EditBookedItemInfo
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsEditBookedItemInfoRequest $returns_refunds_edit_booked_item_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editBookedItemInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function editBookedItemInfoAsyncWithHttpInfo($returns_refunds_edit_booked_item_info_request, string $contentType = self::contentTypes['editBookedItemInfo'][0])
    {
        $returnType = '';
        $request = $this->editBookedItemInfoRequest($returns_refunds_edit_booked_item_info_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'editBookedItemInfo'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsEditBookedItemInfoRequest $returns_refunds_edit_booked_item_info_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['editBookedItemInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function editBookedItemInfoRequest($returns_refunds_edit_booked_item_info_request, string $contentType = self::contentTypes['editBookedItemInfo'][0])
    {

        // verify the required parameter 'returns_refunds_edit_booked_item_info_request' is set
        if ($returns_refunds_edit_booked_item_info_request === null || (is_array($returns_refunds_edit_booked_item_info_request) && count($returns_refunds_edit_booked_item_info_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_edit_booked_item_info_request when calling editBookedItemInfo'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/EditBookedItemInfo';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_edit_booked_item_info_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_edit_booked_item_info_request));
            } else {
                $httpBody = $returns_refunds_edit_booked_item_info_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getActionableRMAHeaders
     *
     * GetActionableRMAHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRMAHeadersRequest $returns_refunds_get_actionable_rma_headers_request returns_refunds_get_actionable_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRMAHeaders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse
     */
    public function getActionableRMAHeaders($returns_refunds_get_actionable_rma_headers_request, string $contentType = self::contentTypes['getActionableRMAHeaders'][0])
    {
        list($response) = $this->getActionableRMAHeadersWithHttpInfo($returns_refunds_get_actionable_rma_headers_request, $contentType);
        return $response;
    }

    /**
     * Operation getActionableRMAHeadersWithHttpInfo
     *
     * GetActionableRMAHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRMAHeadersRequest $returns_refunds_get_actionable_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRMAHeaders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getActionableRMAHeadersWithHttpInfo($returns_refunds_get_actionable_rma_headers_request, string $contentType = self::contentTypes['getActionableRMAHeaders'][0])
    {
        $request = $this->getActionableRMAHeadersRequest($returns_refunds_get_actionable_rma_headers_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getActionableRMAHeadersAsync
     *
     * GetActionableRMAHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRMAHeadersRequest $returns_refunds_get_actionable_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRMAHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getActionableRMAHeadersAsync($returns_refunds_get_actionable_rma_headers_request, string $contentType = self::contentTypes['getActionableRMAHeaders'][0])
    {
        return $this->getActionableRMAHeadersAsyncWithHttpInfo($returns_refunds_get_actionable_rma_headers_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getActionableRMAHeadersAsyncWithHttpInfo
     *
     * GetActionableRMAHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRMAHeadersRequest $returns_refunds_get_actionable_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRMAHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getActionableRMAHeadersAsyncWithHttpInfo($returns_refunds_get_actionable_rma_headers_request, string $contentType = self::contentTypes['getActionableRMAHeaders'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse';
        $request = $this->getActionableRMAHeadersRequest($returns_refunds_get_actionable_rma_headers_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getActionableRMAHeaders'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRMAHeadersRequest $returns_refunds_get_actionable_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRMAHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getActionableRMAHeadersRequest($returns_refunds_get_actionable_rma_headers_request, string $contentType = self::contentTypes['getActionableRMAHeaders'][0])
    {

        // verify the required parameter 'returns_refunds_get_actionable_rma_headers_request' is set
        if ($returns_refunds_get_actionable_rma_headers_request === null || (is_array($returns_refunds_get_actionable_rma_headers_request) && count($returns_refunds_get_actionable_rma_headers_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_actionable_rma_headers_request when calling getActionableRMAHeaders'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetActionableRMAHeaders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_actionable_rma_headers_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_actionable_rma_headers_request));
            } else {
                $httpBody = $returns_refunds_get_actionable_rma_headers_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getActionableRefundHeaders
     *
     * GetActionableRefundHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRefundHeadersRequest $returns_refunds_get_actionable_refund_headers_request returns_refunds_get_actionable_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRefundHeaders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse
     */
    public function getActionableRefundHeaders($returns_refunds_get_actionable_refund_headers_request, string $contentType = self::contentTypes['getActionableRefundHeaders'][0])
    {
        list($response) = $this->getActionableRefundHeadersWithHttpInfo($returns_refunds_get_actionable_refund_headers_request, $contentType);
        return $response;
    }

    /**
     * Operation getActionableRefundHeadersWithHttpInfo
     *
     * GetActionableRefundHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRefundHeadersRequest $returns_refunds_get_actionable_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRefundHeaders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getActionableRefundHeadersWithHttpInfo($returns_refunds_get_actionable_refund_headers_request, string $contentType = self::contentTypes['getActionableRefundHeaders'][0])
    {
        $request = $this->getActionableRefundHeadersRequest($returns_refunds_get_actionable_refund_headers_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getActionableRefundHeadersAsync
     *
     * GetActionableRefundHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRefundHeadersRequest $returns_refunds_get_actionable_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRefundHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getActionableRefundHeadersAsync($returns_refunds_get_actionable_refund_headers_request, string $contentType = self::contentTypes['getActionableRefundHeaders'][0])
    {
        return $this->getActionableRefundHeadersAsyncWithHttpInfo($returns_refunds_get_actionable_refund_headers_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getActionableRefundHeadersAsyncWithHttpInfo
     *
     * GetActionableRefundHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRefundHeadersRequest $returns_refunds_get_actionable_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRefundHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getActionableRefundHeadersAsyncWithHttpInfo($returns_refunds_get_actionable_refund_headers_request, string $contentType = self::contentTypes['getActionableRefundHeaders'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse';
        $request = $this->getActionableRefundHeadersRequest($returns_refunds_get_actionable_refund_headers_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getActionableRefundHeaders'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRefundHeadersRequest $returns_refunds_get_actionable_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActionableRefundHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getActionableRefundHeadersRequest($returns_refunds_get_actionable_refund_headers_request, string $contentType = self::contentTypes['getActionableRefundHeaders'][0])
    {

        // verify the required parameter 'returns_refunds_get_actionable_refund_headers_request' is set
        if ($returns_refunds_get_actionable_refund_headers_request === null || (is_array($returns_refunds_get_actionable_refund_headers_request) && count($returns_refunds_get_actionable_refund_headers_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_actionable_refund_headers_request when calling getActionableRefundHeaders'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetActionableRefundHeaders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_actionable_refund_headers_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_actionable_refund_headers_request));
            } else {
                $httpBody = $returns_refunds_get_actionable_refund_headers_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBookedReturnsExchangeOrders
     *
     * GetBookedReturnsExchangeOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedReturnsExchangeOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]
     */
    public function getBookedReturnsExchangeOrders(string $contentType = self::contentTypes['getBookedReturnsExchangeOrders'][0])
    {
        list($response) = $this->getBookedReturnsExchangeOrdersWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getBookedReturnsExchangeOrdersWithHttpInfo
     *
     * GetBookedReturnsExchangeOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedReturnsExchangeOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getBookedReturnsExchangeOrdersWithHttpInfo(string $contentType = self::contentTypes['getBookedReturnsExchangeOrders'][0])
    {
        $request = $this->getBookedReturnsExchangeOrdersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBookedReturnsExchangeOrdersAsync
     *
     * GetBookedReturnsExchangeOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedReturnsExchangeOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBookedReturnsExchangeOrdersAsync(string $contentType = self::contentTypes['getBookedReturnsExchangeOrders'][0])
    {
        return $this->getBookedReturnsExchangeOrdersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBookedReturnsExchangeOrdersAsyncWithHttpInfo
     *
     * GetBookedReturnsExchangeOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedReturnsExchangeOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBookedReturnsExchangeOrdersAsyncWithHttpInfo(string $contentType = self::contentTypes['getBookedReturnsExchangeOrders'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]';
        $request = $this->getBookedReturnsExchangeOrdersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBookedReturnsExchangeOrders'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBookedReturnsExchangeOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBookedReturnsExchangeOrdersRequest(string $contentType = self::contentTypes['getBookedReturnsExchangeOrders'][0])
    {


        $resourcePath = '/api/ReturnsRefunds/GetBookedReturnsExchangeOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProcessedOrAckedErrorRMAHeaders
     *
     * GetProcessedOrAckedErrorRMAHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest $returns_refunds_get_processed_or_acked_error_rma_headers_request returns_refunds_get_processed_or_acked_error_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRMAHeaders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse
     */
    public function getProcessedOrAckedErrorRMAHeaders($returns_refunds_get_processed_or_acked_error_rma_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRMAHeaders'][0])
    {
        list($response) = $this->getProcessedOrAckedErrorRMAHeadersWithHttpInfo($returns_refunds_get_processed_or_acked_error_rma_headers_request, $contentType);
        return $response;
    }

    /**
     * Operation getProcessedOrAckedErrorRMAHeadersWithHttpInfo
     *
     * GetProcessedOrAckedErrorRMAHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest $returns_refunds_get_processed_or_acked_error_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRMAHeaders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProcessedOrAckedErrorRMAHeadersWithHttpInfo($returns_refunds_get_processed_or_acked_error_rma_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRMAHeaders'][0])
    {
        $request = $this->getProcessedOrAckedErrorRMAHeadersRequest($returns_refunds_get_processed_or_acked_error_rma_headers_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getProcessedOrAckedErrorRMAHeadersAsync
     *
     * GetProcessedOrAckedErrorRMAHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest $returns_refunds_get_processed_or_acked_error_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRMAHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedOrAckedErrorRMAHeadersAsync($returns_refunds_get_processed_or_acked_error_rma_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRMAHeaders'][0])
    {
        return $this->getProcessedOrAckedErrorRMAHeadersAsyncWithHttpInfo($returns_refunds_get_processed_or_acked_error_rma_headers_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProcessedOrAckedErrorRMAHeadersAsyncWithHttpInfo
     *
     * GetProcessedOrAckedErrorRMAHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest $returns_refunds_get_processed_or_acked_error_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRMAHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedOrAckedErrorRMAHeadersAsyncWithHttpInfo($returns_refunds_get_processed_or_acked_error_rma_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRMAHeaders'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse';
        $request = $this->getProcessedOrAckedErrorRMAHeadersRequest($returns_refunds_get_processed_or_acked_error_rma_headers_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProcessedOrAckedErrorRMAHeaders'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest $returns_refunds_get_processed_or_acked_error_rma_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRMAHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProcessedOrAckedErrorRMAHeadersRequest($returns_refunds_get_processed_or_acked_error_rma_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRMAHeaders'][0])
    {

        // verify the required parameter 'returns_refunds_get_processed_or_acked_error_rma_headers_request' is set
        if ($returns_refunds_get_processed_or_acked_error_rma_headers_request === null || (is_array($returns_refunds_get_processed_or_acked_error_rma_headers_request) && count($returns_refunds_get_processed_or_acked_error_rma_headers_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_processed_or_acked_error_rma_headers_request when calling getProcessedOrAckedErrorRMAHeaders'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetProcessedOrAckedErrorRMAHeaders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_processed_or_acked_error_rma_headers_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_processed_or_acked_error_rma_headers_request));
            } else {
                $httpBody = $returns_refunds_get_processed_or_acked_error_rma_headers_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getProcessedOrAckedErrorRefundHeaders
     *
     * GetProcessedOrAckedErrorRefundHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest $returns_refunds_get_processed_or_acked_error_refund_headers_request returns_refunds_get_processed_or_acked_error_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRefundHeaders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse
     */
    public function getProcessedOrAckedErrorRefundHeaders($returns_refunds_get_processed_or_acked_error_refund_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRefundHeaders'][0])
    {
        list($response) = $this->getProcessedOrAckedErrorRefundHeadersWithHttpInfo($returns_refunds_get_processed_or_acked_error_refund_headers_request, $contentType);
        return $response;
    }

    /**
     * Operation getProcessedOrAckedErrorRefundHeadersWithHttpInfo
     *
     * GetProcessedOrAckedErrorRefundHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest $returns_refunds_get_processed_or_acked_error_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRefundHeaders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProcessedOrAckedErrorRefundHeadersWithHttpInfo($returns_refunds_get_processed_or_acked_error_refund_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRefundHeaders'][0])
    {
        $request = $this->getProcessedOrAckedErrorRefundHeadersRequest($returns_refunds_get_processed_or_acked_error_refund_headers_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getProcessedOrAckedErrorRefundHeadersAsync
     *
     * GetProcessedOrAckedErrorRefundHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest $returns_refunds_get_processed_or_acked_error_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRefundHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedOrAckedErrorRefundHeadersAsync($returns_refunds_get_processed_or_acked_error_refund_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRefundHeaders'][0])
    {
        return $this->getProcessedOrAckedErrorRefundHeadersAsyncWithHttpInfo($returns_refunds_get_processed_or_acked_error_refund_headers_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getProcessedOrAckedErrorRefundHeadersAsyncWithHttpInfo
     *
     * GetProcessedOrAckedErrorRefundHeaders
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest $returns_refunds_get_processed_or_acked_error_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRefundHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getProcessedOrAckedErrorRefundHeadersAsyncWithHttpInfo($returns_refunds_get_processed_or_acked_error_refund_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRefundHeaders'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse';
        $request = $this->getProcessedOrAckedErrorRefundHeadersRequest($returns_refunds_get_processed_or_acked_error_refund_headers_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getProcessedOrAckedErrorRefundHeaders'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest $returns_refunds_get_processed_or_acked_error_refund_headers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getProcessedOrAckedErrorRefundHeaders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getProcessedOrAckedErrorRefundHeadersRequest($returns_refunds_get_processed_or_acked_error_refund_headers_request, string $contentType = self::contentTypes['getProcessedOrAckedErrorRefundHeaders'][0])
    {

        // verify the required parameter 'returns_refunds_get_processed_or_acked_error_refund_headers_request' is set
        if ($returns_refunds_get_processed_or_acked_error_refund_headers_request === null || (is_array($returns_refunds_get_processed_or_acked_error_refund_headers_request) && count($returns_refunds_get_processed_or_acked_error_refund_headers_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_processed_or_acked_error_refund_headers_request when calling getProcessedOrAckedErrorRefundHeaders'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetProcessedOrAckedErrorRefundHeaders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_processed_or_acked_error_refund_headers_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_processed_or_acked_error_refund_headers_request));
            } else {
                $httpBody = $returns_refunds_get_processed_or_acked_error_refund_headers_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRMAHeadersByOrderId
     *
     * GetRMAHeadersByOrderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRMAHeadersByOrderIdRequest $returns_refunds_get_rma_headers_by_order_id_request returns_refunds_get_rma_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRMAHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse
     */
    public function getRMAHeadersByOrderId($returns_refunds_get_rma_headers_by_order_id_request, string $contentType = self::contentTypes['getRMAHeadersByOrderId'][0])
    {
        list($response) = $this->getRMAHeadersByOrderIdWithHttpInfo($returns_refunds_get_rma_headers_by_order_id_request, $contentType);
        return $response;
    }

    /**
     * Operation getRMAHeadersByOrderIdWithHttpInfo
     *
     * GetRMAHeadersByOrderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRMAHeadersByOrderIdRequest $returns_refunds_get_rma_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRMAHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRMAHeadersByOrderIdWithHttpInfo($returns_refunds_get_rma_headers_by_order_id_request, string $contentType = self::contentTypes['getRMAHeadersByOrderId'][0])
    {
        $request = $this->getRMAHeadersByOrderIdRequest($returns_refunds_get_rma_headers_by_order_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRMAHeadersByOrderIdAsync
     *
     * GetRMAHeadersByOrderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRMAHeadersByOrderIdRequest $returns_refunds_get_rma_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRMAHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRMAHeadersByOrderIdAsync($returns_refunds_get_rma_headers_by_order_id_request, string $contentType = self::contentTypes['getRMAHeadersByOrderId'][0])
    {
        return $this->getRMAHeadersByOrderIdAsyncWithHttpInfo($returns_refunds_get_rma_headers_by_order_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRMAHeadersByOrderIdAsyncWithHttpInfo
     *
     * GetRMAHeadersByOrderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRMAHeadersByOrderIdRequest $returns_refunds_get_rma_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRMAHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRMAHeadersByOrderIdAsyncWithHttpInfo($returns_refunds_get_rma_headers_by_order_id_request, string $contentType = self::contentTypes['getRMAHeadersByOrderId'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse';
        $request = $this->getRMAHeadersByOrderIdRequest($returns_refunds_get_rma_headers_by_order_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRMAHeadersByOrderId'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRMAHeadersByOrderIdRequest $returns_refunds_get_rma_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRMAHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRMAHeadersByOrderIdRequest($returns_refunds_get_rma_headers_by_order_id_request, string $contentType = self::contentTypes['getRMAHeadersByOrderId'][0])
    {

        // verify the required parameter 'returns_refunds_get_rma_headers_by_order_id_request' is set
        if ($returns_refunds_get_rma_headers_by_order_id_request === null || (is_array($returns_refunds_get_rma_headers_by_order_id_request) && count($returns_refunds_get_rma_headers_by_order_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_rma_headers_by_order_id_request when calling getRMAHeadersByOrderId'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetRMAHeadersByOrderId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_rma_headers_by_order_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_rma_headers_by_order_id_request));
            } else {
                $httpBody = $returns_refunds_get_rma_headers_by_order_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRefundHeadersByOrderId
     *
     * GetRefundHeadersByOrderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundHeadersByOrderIdRequest $returns_refunds_get_refund_headers_by_order_id_request returns_refunds_get_refund_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse
     */
    public function getRefundHeadersByOrderId($returns_refunds_get_refund_headers_by_order_id_request, string $contentType = self::contentTypes['getRefundHeadersByOrderId'][0])
    {
        list($response) = $this->getRefundHeadersByOrderIdWithHttpInfo($returns_refunds_get_refund_headers_by_order_id_request, $contentType);
        return $response;
    }

    /**
     * Operation getRefundHeadersByOrderIdWithHttpInfo
     *
     * GetRefundHeadersByOrderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundHeadersByOrderIdRequest $returns_refunds_get_refund_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRefundHeadersByOrderIdWithHttpInfo($returns_refunds_get_refund_headers_by_order_id_request, string $contentType = self::contentTypes['getRefundHeadersByOrderId'][0])
    {
        $request = $this->getRefundHeadersByOrderIdRequest($returns_refunds_get_refund_headers_by_order_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRefundHeadersByOrderIdAsync
     *
     * GetRefundHeadersByOrderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundHeadersByOrderIdRequest $returns_refunds_get_refund_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundHeadersByOrderIdAsync($returns_refunds_get_refund_headers_by_order_id_request, string $contentType = self::contentTypes['getRefundHeadersByOrderId'][0])
    {
        return $this->getRefundHeadersByOrderIdAsyncWithHttpInfo($returns_refunds_get_refund_headers_by_order_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRefundHeadersByOrderIdAsyncWithHttpInfo
     *
     * GetRefundHeadersByOrderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundHeadersByOrderIdRequest $returns_refunds_get_refund_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundHeadersByOrderIdAsyncWithHttpInfo($returns_refunds_get_refund_headers_by_order_id_request, string $contentType = self::contentTypes['getRefundHeadersByOrderId'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse';
        $request = $this->getRefundHeadersByOrderIdRequest($returns_refunds_get_refund_headers_by_order_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRefundHeadersByOrderId'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundHeadersByOrderIdRequest $returns_refunds_get_refund_headers_by_order_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundHeadersByOrderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRefundHeadersByOrderIdRequest($returns_refunds_get_refund_headers_by_order_id_request, string $contentType = self::contentTypes['getRefundHeadersByOrderId'][0])
    {

        // verify the required parameter 'returns_refunds_get_refund_headers_by_order_id_request' is set
        if ($returns_refunds_get_refund_headers_by_order_id_request === null || (is_array($returns_refunds_get_refund_headers_by_order_id_request) && count($returns_refunds_get_refund_headers_by_order_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_refund_headers_by_order_id_request when calling getRefundHeadersByOrderId'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetRefundHeadersByOrderId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_refund_headers_by_order_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_refund_headers_by_order_id_request));
            } else {
                $httpBody = $returns_refunds_get_refund_headers_by_order_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRefundLinesByHeaderId
     *
     * GetRefundLinesByHeaderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundLinesByHeaderIdRequest $returns_refunds_get_refund_lines_by_header_id_request returns_refunds_get_refund_lines_by_header_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundLinesByHeaderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse
     */
    public function getRefundLinesByHeaderId($returns_refunds_get_refund_lines_by_header_id_request, string $contentType = self::contentTypes['getRefundLinesByHeaderId'][0])
    {
        list($response) = $this->getRefundLinesByHeaderIdWithHttpInfo($returns_refunds_get_refund_lines_by_header_id_request, $contentType);
        return $response;
    }

    /**
     * Operation getRefundLinesByHeaderIdWithHttpInfo
     *
     * GetRefundLinesByHeaderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundLinesByHeaderIdRequest $returns_refunds_get_refund_lines_by_header_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundLinesByHeaderId'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRefundLinesByHeaderIdWithHttpInfo($returns_refunds_get_refund_lines_by_header_id_request, string $contentType = self::contentTypes['getRefundLinesByHeaderId'][0])
    {
        $request = $this->getRefundLinesByHeaderIdRequest($returns_refunds_get_refund_lines_by_header_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRefundLinesByHeaderIdAsync
     *
     * GetRefundLinesByHeaderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundLinesByHeaderIdRequest $returns_refunds_get_refund_lines_by_header_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundLinesByHeaderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundLinesByHeaderIdAsync($returns_refunds_get_refund_lines_by_header_id_request, string $contentType = self::contentTypes['getRefundLinesByHeaderId'][0])
    {
        return $this->getRefundLinesByHeaderIdAsyncWithHttpInfo($returns_refunds_get_refund_lines_by_header_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRefundLinesByHeaderIdAsyncWithHttpInfo
     *
     * GetRefundLinesByHeaderId
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundLinesByHeaderIdRequest $returns_refunds_get_refund_lines_by_header_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundLinesByHeaderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundLinesByHeaderIdAsyncWithHttpInfo($returns_refunds_get_refund_lines_by_header_id_request, string $contentType = self::contentTypes['getRefundLinesByHeaderId'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse';
        $request = $this->getRefundLinesByHeaderIdRequest($returns_refunds_get_refund_lines_by_header_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRefundLinesByHeaderId'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundLinesByHeaderIdRequest $returns_refunds_get_refund_lines_by_header_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundLinesByHeaderId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRefundLinesByHeaderIdRequest($returns_refunds_get_refund_lines_by_header_id_request, string $contentType = self::contentTypes['getRefundLinesByHeaderId'][0])
    {

        // verify the required parameter 'returns_refunds_get_refund_lines_by_header_id_request' is set
        if ($returns_refunds_get_refund_lines_by_header_id_request === null || (is_array($returns_refunds_get_refund_lines_by_header_id_request) && count($returns_refunds_get_refund_lines_by_header_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_refund_lines_by_header_id_request when calling getRefundLinesByHeaderId'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetRefundLinesByHeaderId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_refund_lines_by_header_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_refund_lines_by_header_id_request));
            } else {
                $httpBody = $returns_refunds_get_refund_lines_by_header_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRefundOptions
     *
     * GetRefundOptions
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundOptionsRequest $returns_refunds_get_refund_options_request returns_refunds_get_refund_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse
     */
    public function getRefundOptions($returns_refunds_get_refund_options_request, string $contentType = self::contentTypes['getRefundOptions'][0])
    {
        list($response) = $this->getRefundOptionsWithHttpInfo($returns_refunds_get_refund_options_request, $contentType);
        return $response;
    }

    /**
     * Operation getRefundOptionsWithHttpInfo
     *
     * GetRefundOptions
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundOptionsRequest $returns_refunds_get_refund_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRefundOptionsWithHttpInfo($returns_refunds_get_refund_options_request, string $contentType = self::contentTypes['getRefundOptions'][0])
    {
        $request = $this->getRefundOptionsRequest($returns_refunds_get_refund_options_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRefundOptionsAsync
     *
     * GetRefundOptions
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundOptionsRequest $returns_refunds_get_refund_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundOptionsAsync($returns_refunds_get_refund_options_request, string $contentType = self::contentTypes['getRefundOptions'][0])
    {
        return $this->getRefundOptionsAsyncWithHttpInfo($returns_refunds_get_refund_options_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRefundOptionsAsyncWithHttpInfo
     *
     * GetRefundOptions
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundOptionsRequest $returns_refunds_get_refund_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundOptionsAsyncWithHttpInfo($returns_refunds_get_refund_options_request, string $contentType = self::contentTypes['getRefundOptions'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse';
        $request = $this->getRefundOptionsRequest($returns_refunds_get_refund_options_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRefundOptions'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundOptionsRequest $returns_refunds_get_refund_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRefundOptionsRequest($returns_refunds_get_refund_options_request, string $contentType = self::contentTypes['getRefundOptions'][0])
    {

        // verify the required parameter 'returns_refunds_get_refund_options_request' is set
        if ($returns_refunds_get_refund_options_request === null || (is_array($returns_refunds_get_refund_options_request) && count($returns_refunds_get_refund_options_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_refund_options_request when calling getRefundOptions'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetRefundOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_refund_options_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_refund_options_request));
            } else {
                $httpBody = $returns_refunds_get_refund_options_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRefundOrders
     *
     * GetRefundOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\RefundOrder[]
     */
    public function getRefundOrders(string $contentType = self::contentTypes['getRefundOrders'][0])
    {
        list($response) = $this->getRefundOrdersWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getRefundOrdersWithHttpInfo
     *
     * GetRefundOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOrders'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\RefundOrder[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getRefundOrdersWithHttpInfo(string $contentType = self::contentTypes['getRefundOrders'][0])
    {
        $request = $this->getRefundOrdersRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\RefundOrder[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\RefundOrder[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\RefundOrder[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\RefundOrder[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\RefundOrder[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRefundOrdersAsync
     *
     * GetRefundOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundOrdersAsync(string $contentType = self::contentTypes['getRefundOrders'][0])
    {
        return $this->getRefundOrdersAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRefundOrdersAsyncWithHttpInfo
     *
     * GetRefundOrders
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRefundOrdersAsyncWithHttpInfo(string $contentType = self::contentTypes['getRefundOrders'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\RefundOrder[]';
        $request = $this->getRefundOrdersRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRefundOrders'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRefundOrders'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRefundOrdersRequest(string $contentType = self::contentTypes['getRefundOrders'][0])
    {


        $resourcePath = '/api/ReturnsRefunds/GetRefundOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReturnOptions
     *
     * GetReturnOptions
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetReturnOptionsRequest $returns_refunds_get_return_options_request returns_refunds_get_return_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse
     */
    public function getReturnOptions($returns_refunds_get_return_options_request, string $contentType = self::contentTypes['getReturnOptions'][0])
    {
        list($response) = $this->getReturnOptionsWithHttpInfo($returns_refunds_get_return_options_request, $contentType);
        return $response;
    }

    /**
     * Operation getReturnOptionsWithHttpInfo
     *
     * GetReturnOptions
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetReturnOptionsRequest $returns_refunds_get_return_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReturnOptionsWithHttpInfo($returns_refunds_get_return_options_request, string $contentType = self::contentTypes['getReturnOptions'][0])
    {
        $request = $this->getReturnOptionsRequest($returns_refunds_get_return_options_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getReturnOptionsAsync
     *
     * GetReturnOptions
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetReturnOptionsRequest $returns_refunds_get_return_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnOptionsAsync($returns_refunds_get_return_options_request, string $contentType = self::contentTypes['getReturnOptions'][0])
    {
        return $this->getReturnOptionsAsyncWithHttpInfo($returns_refunds_get_return_options_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReturnOptionsAsyncWithHttpInfo
     *
     * GetReturnOptions
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetReturnOptionsRequest $returns_refunds_get_return_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReturnOptionsAsyncWithHttpInfo($returns_refunds_get_return_options_request, string $contentType = self::contentTypes['getReturnOptions'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse';
        $request = $this->getReturnOptionsRequest($returns_refunds_get_return_options_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReturnOptions'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetReturnOptionsRequest $returns_refunds_get_return_options_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getReturnOptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getReturnOptionsRequest($returns_refunds_get_return_options_request, string $contentType = self::contentTypes['getReturnOptions'][0])
    {

        // verify the required parameter 'returns_refunds_get_return_options_request' is set
        if ($returns_refunds_get_return_options_request === null || (is_array($returns_refunds_get_return_options_request) && count($returns_refunds_get_return_options_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_get_return_options_request when calling getReturnOptions'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/GetReturnOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_get_return_options_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_get_return_options_request));
            } else {
                $httpBody = $returns_refunds_get_return_options_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSearchTypes
     *
     * GetSearchTypes
     *
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSearchTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\SearchField[]
     */
    public function getSearchTypes($history_type = null, string $contentType = self::contentTypes['getSearchTypes'][0])
    {
        list($response) = $this->getSearchTypesWithHttpInfo($history_type, $contentType);
        return $response;
    }

    /**
     * Operation getSearchTypesWithHttpInfo
     *
     * GetSearchTypes
     *
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSearchTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\SearchField[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getSearchTypesWithHttpInfo($history_type = null, string $contentType = self::contentTypes['getSearchTypes'][0])
    {
        $request = $this->getSearchTypesRequest($history_type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\SearchField[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\SearchField[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\SearchField[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\SearchField[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\SearchField[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSearchTypesAsync
     *
     * GetSearchTypes
     *
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSearchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSearchTypesAsync($history_type = null, string $contentType = self::contentTypes['getSearchTypes'][0])
    {
        return $this->getSearchTypesAsyncWithHttpInfo($history_type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSearchTypesAsyncWithHttpInfo
     *
     * GetSearchTypes
     *
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSearchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSearchTypesAsyncWithHttpInfo($history_type = null, string $contentType = self::contentTypes['getSearchTypes'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\SearchField[]';
        $request = $this->getSearchTypesRequest($history_type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSearchTypes'
     *
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSearchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSearchTypesRequest($history_type = null, string $contentType = self::contentTypes['getSearchTypes'][0])
    {



        $resourcePath = '/api/ReturnsRefunds/GetSearchTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $history_type,
            'historyType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTotalRefunds
     *
     * GetTotalRefunds
     *
     * @param  string|null $fk_order_id unique order ID of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return float
     */
    public function getTotalRefunds($fk_order_id = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {
        list($response) = $this->getTotalRefundsWithHttpInfo($fk_order_id, $contentType);
        return $response;
    }

    /**
     * Operation getTotalRefundsWithHttpInfo
     *
     * GetTotalRefunds
     *
     * @param  string|null $fk_order_id unique order ID of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of float, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTotalRefundsWithHttpInfo($fk_order_id = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {
        $request = $this->getTotalRefundsRequest($fk_order_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('float' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('float' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'float', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'float';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'float',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTotalRefundsAsync
     *
     * GetTotalRefunds
     *
     * @param  string|null $fk_order_id unique order ID of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTotalRefundsAsync($fk_order_id = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {
        return $this->getTotalRefundsAsyncWithHttpInfo($fk_order_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTotalRefundsAsyncWithHttpInfo
     *
     * GetTotalRefunds
     *
     * @param  string|null $fk_order_id unique order ID of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTotalRefundsAsyncWithHttpInfo($fk_order_id = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {
        $returnType = 'float';
        $request = $this->getTotalRefundsRequest($fk_order_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTotalRefunds'
     *
     * @param  string|null $fk_order_id unique order ID of the order (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getTotalRefunds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getTotalRefundsRequest($fk_order_id = null, string $contentType = self::contentTypes['getTotalRefunds'][0])
    {



        $resourcePath = '/api/ReturnsRefunds/GetTotalRefunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $fk_order_id,
            'fkOrderId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getWarehouseLocations
     *
     * GetWarehouseLocations
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseLocations'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\WarehouseLocation[]
     */
    public function getWarehouseLocations(string $contentType = self::contentTypes['getWarehouseLocations'][0])
    {
        list($response) = $this->getWarehouseLocationsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getWarehouseLocationsWithHttpInfo
     *
     * GetWarehouseLocations
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseLocations'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\WarehouseLocation[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getWarehouseLocationsWithHttpInfo(string $contentType = self::contentTypes['getWarehouseLocations'][0])
    {
        $request = $this->getWarehouseLocationsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\WarehouseLocation[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\WarehouseLocation[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\WarehouseLocation[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\WarehouseLocation[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\WarehouseLocation[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getWarehouseLocationsAsync
     *
     * GetWarehouseLocations
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWarehouseLocationsAsync(string $contentType = self::contentTypes['getWarehouseLocations'][0])
    {
        return $this->getWarehouseLocationsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getWarehouseLocationsAsyncWithHttpInfo
     *
     * GetWarehouseLocations
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getWarehouseLocationsAsyncWithHttpInfo(string $contentType = self::contentTypes['getWarehouseLocations'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\WarehouseLocation[]';
        $request = $this->getWarehouseLocationsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getWarehouseLocations'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getWarehouseLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getWarehouseLocationsRequest(string $contentType = self::contentTypes['getWarehouseLocations'][0])
    {


        $resourcePath = '/api/ReturnsRefunds/GetWarehouseLocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation refundOrder
     *
     * RefundOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsRefundOrderRequest $returns_refunds_refund_order_request returns_refunds_refund_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function refundOrder($returns_refunds_refund_order_request, string $contentType = self::contentTypes['refundOrder'][0])
    {
        $this->refundOrderWithHttpInfo($returns_refunds_refund_order_request, $contentType);
    }

    /**
     * Operation refundOrderWithHttpInfo
     *
     * RefundOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsRefundOrderRequest $returns_refunds_refund_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundOrder'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function refundOrderWithHttpInfo($returns_refunds_refund_order_request, string $contentType = self::contentTypes['refundOrder'][0])
    {
        $request = $this->refundOrderRequest($returns_refunds_refund_order_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation refundOrderAsync
     *
     * RefundOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsRefundOrderRequest $returns_refunds_refund_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundOrderAsync($returns_refunds_refund_order_request, string $contentType = self::contentTypes['refundOrder'][0])
    {
        return $this->refundOrderAsyncWithHttpInfo($returns_refunds_refund_order_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation refundOrderAsyncWithHttpInfo
     *
     * RefundOrder
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsRefundOrderRequest $returns_refunds_refund_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function refundOrderAsyncWithHttpInfo($returns_refunds_refund_order_request, string $contentType = self::contentTypes['refundOrder'][0])
    {
        $returnType = '';
        $request = $this->refundOrderRequest($returns_refunds_refund_order_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'refundOrder'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsRefundOrderRequest $returns_refunds_refund_order_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['refundOrder'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function refundOrderRequest($returns_refunds_refund_order_request, string $contentType = self::contentTypes['refundOrder'][0])
    {

        // verify the required parameter 'returns_refunds_refund_order_request' is set
        if ($returns_refunds_refund_order_request === null || (is_array($returns_refunds_refund_order_request) && count($returns_refunds_refund_order_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_refund_order_request when calling refundOrder'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/RefundOrder';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_refund_order_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_refund_order_request));
            } else {
                $httpBody = $returns_refunds_refund_order_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation searchReturnsRefundsPaged
     *
     * SearchReturnsRefundsPaged
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  int|null $page_num The page number of the request. (optional)
     * @param  int|null $num_entries_per_page The number of entries required on a page. Maximum 200. (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturnsRefundsPaged'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb
     */
    public function searchReturnsRefundsPaged($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $page_num = null, $num_entries_per_page = null, $history_type = null, string $contentType = self::contentTypes['searchReturnsRefundsPaged'][0])
    {
        list($response) = $this->searchReturnsRefundsPagedWithHttpInfo($from, $to, $date_type, $search_field, $exact_match, $search_term, $page_num, $num_entries_per_page, $history_type, $contentType);
        return $response;
    }

    /**
     * Operation searchReturnsRefundsPagedWithHttpInfo
     *
     * SearchReturnsRefundsPaged
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  int|null $page_num The page number of the request. (optional)
     * @param  int|null $num_entries_per_page The number of entries required on a page. Maximum 200. (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturnsRefundsPaged'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb, HTTP status code, HTTP response headers (array of strings)
     */
    public function searchReturnsRefundsPagedWithHttpInfo($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $page_num = null, $num_entries_per_page = null, $history_type = null, string $contentType = self::contentTypes['searchReturnsRefundsPaged'][0])
    {
        $request = $this->searchReturnsRefundsPagedRequest($from, $to, $date_type, $search_field, $exact_match, $search_term, $page_num, $num_entries_per_page, $history_type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation searchReturnsRefundsPagedAsync
     *
     * SearchReturnsRefundsPaged
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  int|null $page_num The page number of the request. (optional)
     * @param  int|null $num_entries_per_page The number of entries required on a page. Maximum 200. (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturnsRefundsPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchReturnsRefundsPagedAsync($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $page_num = null, $num_entries_per_page = null, $history_type = null, string $contentType = self::contentTypes['searchReturnsRefundsPaged'][0])
    {
        return $this->searchReturnsRefundsPagedAsyncWithHttpInfo($from, $to, $date_type, $search_field, $exact_match, $search_term, $page_num, $num_entries_per_page, $history_type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation searchReturnsRefundsPagedAsyncWithHttpInfo
     *
     * SearchReturnsRefundsPaged
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  int|null $page_num The page number of the request. (optional)
     * @param  int|null $num_entries_per_page The number of entries required on a page. Maximum 200. (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturnsRefundsPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function searchReturnsRefundsPagedAsyncWithHttpInfo($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $page_num = null, $num_entries_per_page = null, $history_type = null, string $contentType = self::contentTypes['searchReturnsRefundsPaged'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb';
        $request = $this->searchReturnsRefundsPagedRequest($from, $to, $date_type, $search_field, $exact_match, $search_term, $page_num, $num_entries_per_page, $history_type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'searchReturnsRefundsPaged'
     *
     * @param  \DateTime|null $from The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  \DateTime|null $to The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. (optional)
     * @param  string|null $date_type The search type (e.g. ALLDATES) (optional)
     * @param  string|null $search_field The field to search by. Can be found by calling GetSearchTypes. (optional)
     * @param  bool|null $exact_match Set to true if an exact match is required for the search data. (optional)
     * @param  string|null $search_term The term which you are searching for. (optional)
     * @param  int|null $page_num The page number of the request. (optional)
     * @param  int|null $num_entries_per_page The number of entries required on a page. Maximum 200. (optional)
     * @param  string|null $history_type Search type. Allow RETURNS or REFUNDS (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['searchReturnsRefundsPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function searchReturnsRefundsPagedRequest($from = null, $to = null, $date_type = null, $search_field = null, $exact_match = null, $search_term = null, $page_num = null, $num_entries_per_page = null, $history_type = null, string $contentType = self::contentTypes['searchReturnsRefundsPaged'][0])
    {











        $resourcePath = '/api/ReturnsRefunds/SearchReturnsRefundsPaged';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $from,
            'from', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $to,
            'to', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date_type,
            'dateType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search_field,
            'searchField', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $exact_match,
            'exactMatch', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $search_term,
            'searchTerm', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_num,
            'pageNum', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $num_entries_per_page,
            'numEntriesPerPage', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $history_type,
            'historyType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateRMABooking
     *
     * UpdateRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRMABookingRequest $returns_refunds_update_rma_booking_request returns_refunds_update_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRMABooking'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse
     */
    public function updateRMABooking($returns_refunds_update_rma_booking_request, string $contentType = self::contentTypes['updateRMABooking'][0])
    {
        list($response) = $this->updateRMABookingWithHttpInfo($returns_refunds_update_rma_booking_request, $contentType);
        return $response;
    }

    /**
     * Operation updateRMABookingWithHttpInfo
     *
     * UpdateRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRMABookingRequest $returns_refunds_update_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRMABooking'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRMABookingWithHttpInfo($returns_refunds_update_rma_booking_request, string $contentType = self::contentTypes['updateRMABooking'][0])
    {
        $request = $this->updateRMABookingRequest($returns_refunds_update_rma_booking_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateRMABookingAsync
     *
     * UpdateRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRMABookingRequest $returns_refunds_update_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateRMABookingAsync($returns_refunds_update_rma_booking_request, string $contentType = self::contentTypes['updateRMABooking'][0])
    {
        return $this->updateRMABookingAsyncWithHttpInfo($returns_refunds_update_rma_booking_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateRMABookingAsyncWithHttpInfo
     *
     * UpdateRMABooking
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRMABookingRequest $returns_refunds_update_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateRMABookingAsyncWithHttpInfo($returns_refunds_update_rma_booking_request, string $contentType = self::contentTypes['updateRMABooking'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse';
        $request = $this->updateRMABookingRequest($returns_refunds_update_rma_booking_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateRMABooking'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRMABookingRequest $returns_refunds_update_rma_booking_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRMABooking'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateRMABookingRequest($returns_refunds_update_rma_booking_request, string $contentType = self::contentTypes['updateRMABooking'][0])
    {

        // verify the required parameter 'returns_refunds_update_rma_booking_request' is set
        if ($returns_refunds_update_rma_booking_request === null || (is_array($returns_refunds_update_rma_booking_request) && count($returns_refunds_update_rma_booking_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_update_rma_booking_request when calling updateRMABooking'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/UpdateRMABooking';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_update_rma_booking_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_update_rma_booking_request));
            } else {
                $httpBody = $returns_refunds_update_rma_booking_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateRefund
     *
     * UpdateRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRefundRequest $returns_refunds_update_refund_request returns_refunds_update_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\ReturnsRefunds\Model\UpdateRefundResponse
     */
    public function updateRefund($returns_refunds_update_refund_request, string $contentType = self::contentTypes['updateRefund'][0])
    {
        list($response) = $this->updateRefundWithHttpInfo($returns_refunds_update_refund_request, $contentType);
        return $response;
    }

    /**
     * Operation updateRefundWithHttpInfo
     *
     * UpdateRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRefundRequest $returns_refunds_update_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRefund'] to see the possible values for this operation
     *
     * @throws \Linnworks\ReturnsRefunds\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\ReturnsRefunds\Model\UpdateRefundResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRefundWithHttpInfo($returns_refunds_update_refund_request, string $contentType = self::contentTypes['updateRefund'][0])
    {
        $request = $this->updateRefundRequest($returns_refunds_update_refund_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\ReturnsRefunds\Model\UpdateRefundResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\ReturnsRefunds\Model\UpdateRefundResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\ReturnsRefunds\Model\UpdateRefundResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\ReturnsRefunds\Model\UpdateRefundResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\ReturnsRefunds\Model\UpdateRefundResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateRefundAsync
     *
     * UpdateRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRefundRequest $returns_refunds_update_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateRefundAsync($returns_refunds_update_refund_request, string $contentType = self::contentTypes['updateRefund'][0])
    {
        return $this->updateRefundAsyncWithHttpInfo($returns_refunds_update_refund_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateRefundAsyncWithHttpInfo
     *
     * UpdateRefund
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRefundRequest $returns_refunds_update_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateRefundAsyncWithHttpInfo($returns_refunds_update_refund_request, string $contentType = self::contentTypes['updateRefund'][0])
    {
        $returnType = '\Linnworks\ReturnsRefunds\Model\UpdateRefundResponse';
        $request = $this->updateRefundRequest($returns_refunds_update_refund_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateRefund'
     *
     * @param  \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRefundRequest $returns_refunds_update_refund_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRefund'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateRefundRequest($returns_refunds_update_refund_request, string $contentType = self::contentTypes['updateRefund'][0])
    {

        // verify the required parameter 'returns_refunds_update_refund_request' is set
        if ($returns_refunds_update_refund_request === null || (is_array($returns_refunds_update_refund_request) && count($returns_refunds_update_refund_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $returns_refunds_update_refund_request when calling updateRefund'
            );
        }


        $resourcePath = '/api/ReturnsRefunds/UpdateRefund';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($returns_refunds_update_refund_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($returns_refunds_update_refund_request));
            } else {
                $httpBody = $returns_refunds_update_refund_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
