# # VerifiedRefund

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**refund_row_id** | **string** | A unique identifier for the refund line | [optional]
**refund_header_id** | **int** | A unique identifier for the refund header this line belongs to | [optional]
**status** | [**\Linnworks\ReturnsRefunds\Model\PostSaleStatus**](PostSaleStatus.md) |  | [optional]
**refunded_unit** | **string** | Identifies the type of refund for this line | [optional]
**is_shipping_refund** | **bool** | Identifies whether the refund is a shipping refund | [optional] [readonly]
**is_additional_refund** | **bool** | Identifies whether the refund is an additional refund | [optional] [readonly]
**is_cancellation** | **bool** | Identifies whether the refund row is a cancellation | [optional] [readonly]
**refunded_item** | [**\Linnworks\ReturnsRefunds\Model\VerifiedRefundItem**](VerifiedRefundItem.md) |  | [optional]
**validation_error** | **string** | If validation has failed for this item, the field will be populated with the appropriate error message | [optional]
**error** | **string** |  | [optional]
**errors** | [**\Linnworks\ReturnsRefunds\Model\RefundError[]**](RefundError.md) |  | [optional]
**actioned** | **bool** | Line-level indicator of whether the refund has been actioned | [optional]
**actioned_date** | **\DateTime** | If a refund has been actioned, this denotes the date it was actioned. For not actioned lines, this value is null | [optional]
**channel_initiated** | **bool** | Identifies whether the refund was created manually in Linnworks, or downloaded from the channel automatically | [optional]
**internal** | **bool** | Identifies whether the line is processed only internally or also on a third-party channel | [optional]
**deleted** | **bool** | Identifies whether the line has been removed from the refund, and is pending an update to the database to reflect this | [optional]
**external_reference** | **string** | The channel reference number for this refund | [optional]
**is_free_text** | **bool** | Identifies whether the refund reason is provided in freetext, or as one of a predefined set of options | [optional] [readonly]
**free_text_or_note** | **string** | For freetext refund reasons, this is the reason that will be sent to the channel. Otherwise, it is considered an internal note | [optional]
**amount** | **float** | The amount to be refunded for this line | [optional]
**quantity** | **int** | Used when the refund is part of a return | [optional]
**reason_tag** | **string** | For channels that support predefined refund reasons, this is the tag that identifies a predefined reason | [optional]
**sub_reason_tag** | **string** | For channels that support a secondary predefined refund reason, this is the tag that identifies a predefined secondary reason | [optional]
**insufficient_refund_tag** | **string** | For channels that require a reason when the refund is lower than the full line amount, this is the tag that identifies a predefined insufficient refund reason | [optional]
**insufficient_refund_note** | **string** | For channels that require a reason when the refund is lower than the full line amount, and support a freetext note, this field populates that note | [optional]
**reason_category** | **string** | Internal reason category | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
