# Linnworks\ReturnsRefunds\ReturnsRefundsApi

All URIs are relative to https://eu-ext.linnworks.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**acknowledgeRMAErrors()**](ReturnsRefundsApi.md#acknowledgeRMAErrors) | **POST** /api/ReturnsRefunds/AcknowledgeRMAErrors | AcknowledgeRMAErrors |
| [**acknowledgeRefundErrors()**](ReturnsRefundsApi.md#acknowledgeRefundErrors) | **POST** /api/ReturnsRefunds/AcknowledgeRefundErrors | AcknowledgeRefundErrors |
| [**actionBookedOrder()**](ReturnsRefundsApi.md#actionBookedOrder) | **POST** /api/ReturnsRefunds/ActionBookedOrder | ActionBookedOrder |
| [**actionRMABooking()**](ReturnsRefundsApi.md#actionRMABooking) | **POST** /api/ReturnsRefunds/ActionRMABooking | ActionRMABooking |
| [**actionRefund()**](ReturnsRefundsApi.md#actionRefund) | **POST** /api/ReturnsRefunds/ActionRefund | ActionRefund |
| [**createRMABooking()**](ReturnsRefundsApi.md#createRMABooking) | **POST** /api/ReturnsRefunds/CreateRMABooking | CreateRMABooking |
| [**createRefund()**](ReturnsRefundsApi.md#createRefund) | **POST** /api/ReturnsRefunds/CreateRefund | CreateRefund |
| [**createReturnsRefundsCSV()**](ReturnsRefundsApi.md#createReturnsRefundsCSV) | **GET** /api/ReturnsRefunds/CreateReturnsRefundsCSV | CreateReturnsRefundsCSV |
| [**deleteBookedItem()**](ReturnsRefundsApi.md#deleteBookedItem) | **POST** /api/ReturnsRefunds/DeleteBookedItem | DeleteBookedItem |
| [**deleteBookedOrder()**](ReturnsRefundsApi.md#deleteBookedOrder) | **POST** /api/ReturnsRefunds/DeleteBookedOrder | DeleteBookedOrder |
| [**deletePendingRefundItem()**](ReturnsRefundsApi.md#deletePendingRefundItem) | **POST** /api/ReturnsRefunds/DeletePendingRefundItem | DeletePendingRefundItem |
| [**deleteRMA()**](ReturnsRefundsApi.md#deleteRMA) | **POST** /api/ReturnsRefunds/DeleteRMA | DeleteRMA |
| [**deleteRefund()**](ReturnsRefundsApi.md#deleteRefund) | **POST** /api/ReturnsRefunds/DeleteRefund | DeleteRefund |
| [**editBookedItemInfo()**](ReturnsRefundsApi.md#editBookedItemInfo) | **POST** /api/ReturnsRefunds/EditBookedItemInfo | EditBookedItemInfo |
| [**getActionableRMAHeaders()**](ReturnsRefundsApi.md#getActionableRMAHeaders) | **POST** /api/ReturnsRefunds/GetActionableRMAHeaders | GetActionableRMAHeaders |
| [**getActionableRefundHeaders()**](ReturnsRefundsApi.md#getActionableRefundHeaders) | **POST** /api/ReturnsRefunds/GetActionableRefundHeaders | GetActionableRefundHeaders |
| [**getBookedReturnsExchangeOrders()**](ReturnsRefundsApi.md#getBookedReturnsExchangeOrders) | **GET** /api/ReturnsRefunds/GetBookedReturnsExchangeOrders | GetBookedReturnsExchangeOrders |
| [**getProcessedOrAckedErrorRMAHeaders()**](ReturnsRefundsApi.md#getProcessedOrAckedErrorRMAHeaders) | **POST** /api/ReturnsRefunds/GetProcessedOrAckedErrorRMAHeaders | GetProcessedOrAckedErrorRMAHeaders |
| [**getProcessedOrAckedErrorRefundHeaders()**](ReturnsRefundsApi.md#getProcessedOrAckedErrorRefundHeaders) | **POST** /api/ReturnsRefunds/GetProcessedOrAckedErrorRefundHeaders | GetProcessedOrAckedErrorRefundHeaders |
| [**getRMAHeadersByOrderId()**](ReturnsRefundsApi.md#getRMAHeadersByOrderId) | **POST** /api/ReturnsRefunds/GetRMAHeadersByOrderId | GetRMAHeadersByOrderId |
| [**getRefundHeadersByOrderId()**](ReturnsRefundsApi.md#getRefundHeadersByOrderId) | **POST** /api/ReturnsRefunds/GetRefundHeadersByOrderId | GetRefundHeadersByOrderId |
| [**getRefundLinesByHeaderId()**](ReturnsRefundsApi.md#getRefundLinesByHeaderId) | **POST** /api/ReturnsRefunds/GetRefundLinesByHeaderId | GetRefundLinesByHeaderId |
| [**getRefundOptions()**](ReturnsRefundsApi.md#getRefundOptions) | **POST** /api/ReturnsRefunds/GetRefundOptions | GetRefundOptions |
| [**getRefundOrders()**](ReturnsRefundsApi.md#getRefundOrders) | **GET** /api/ReturnsRefunds/GetRefundOrders | GetRefundOrders |
| [**getReturnOptions()**](ReturnsRefundsApi.md#getReturnOptions) | **POST** /api/ReturnsRefunds/GetReturnOptions | GetReturnOptions |
| [**getSearchTypes()**](ReturnsRefundsApi.md#getSearchTypes) | **GET** /api/ReturnsRefunds/GetSearchTypes | GetSearchTypes |
| [**getTotalRefunds()**](ReturnsRefundsApi.md#getTotalRefunds) | **GET** /api/ReturnsRefunds/GetTotalRefunds | GetTotalRefunds |
| [**getWarehouseLocations()**](ReturnsRefundsApi.md#getWarehouseLocations) | **GET** /api/ReturnsRefunds/GetWarehouseLocations | GetWarehouseLocations |
| [**refundOrder()**](ReturnsRefundsApi.md#refundOrder) | **POST** /api/ReturnsRefunds/RefundOrder | RefundOrder |
| [**searchReturnsRefundsPaged()**](ReturnsRefundsApi.md#searchReturnsRefundsPaged) | **GET** /api/ReturnsRefunds/SearchReturnsRefundsPaged | SearchReturnsRefundsPaged |
| [**updateRMABooking()**](ReturnsRefundsApi.md#updateRMABooking) | **POST** /api/ReturnsRefunds/UpdateRMABooking | UpdateRMABooking |
| [**updateRefund()**](ReturnsRefundsApi.md#updateRefund) | **POST** /api/ReturnsRefunds/UpdateRefund | UpdateRefund |


## `acknowledgeRMAErrors()`

```php
acknowledgeRMAErrors($returns_refunds_acknowledge_rma_errors_request): \Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse
```

AcknowledgeRMAErrors

Acknowledges all error responses for a given RMA header <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.AcceptReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_acknowledge_rma_errors_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest

try {
    $result = $apiInstance->acknowledgeRMAErrors($returns_refunds_acknowledge_rma_errors_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->acknowledgeRMAErrors: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_acknowledge_rma_errors_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRMAErrorsRequest**](../Model/ReturnsRefundsAcknowledgeRMAErrorsRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\AcknowledgeRMAErrorsResponse**](../Model/AcknowledgeRMAErrorsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `acknowledgeRefundErrors()`

```php
acknowledgeRefundErrors($returns_refunds_acknowledge_refund_errors_request): \Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse
```

AcknowledgeRefundErrors

Acknowledges error responses for a given refund header <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.ApproveRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_acknowledge_refund_errors_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRefundErrorsRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRefundErrorsRequest

try {
    $result = $apiInstance->acknowledgeRefundErrors($returns_refunds_acknowledge_refund_errors_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->acknowledgeRefundErrors: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_acknowledge_refund_errors_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsAcknowledgeRefundErrorsRequest**](../Model/ReturnsRefundsAcknowledgeRefundErrorsRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\AcknowledgeRefundErrorsResponse**](../Model/AcknowledgeRefundErrorsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `actionBookedOrder()`

```php
actionBookedOrder($returns_refunds_action_booked_order_request)
```

ActionBookedOrder

Action list of booked returns/exchange items for a given order ID. If the return is for a batched item, the batch must be booked in manually. <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_action_booked_order_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionBookedOrderRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionBookedOrderRequest

try {
    $apiInstance->actionBookedOrder($returns_refunds_action_booked_order_request);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->actionBookedOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_action_booked_order_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionBookedOrderRequest**](../Model/ReturnsRefundsActionBookedOrderRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `actionRMABooking()`

```php
actionRMABooking($returns_refunds_action_rma_booking_request): \Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse
```

ActionRMABooking

Accepts a booked return or exchange in the system <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.AcceptReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_action_rma_booking_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRMABookingRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRMABookingRequest

try {
    $result = $apiInstance->actionRMABooking($returns_refunds_action_rma_booking_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->actionRMABooking: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_action_rma_booking_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRMABookingRequest**](../Model/ReturnsRefundsActionRMABookingRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\ActionRMABookingResponse**](../Model/ActionRMABookingResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `actionRefund()`

```php
actionRefund($returns_refunds_action_refund_request): \Linnworks\ReturnsRefunds\Model\ActionRefundResponse
```

ActionRefund

Sends a refund to the channel for actioning <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.ApproveRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_action_refund_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRefundRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRefundRequest

try {
    $result = $apiInstance->actionRefund($returns_refunds_action_refund_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->actionRefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_action_refund_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsActionRefundRequest**](../Model/ReturnsRefundsActionRefundRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\ActionRefundResponse**](../Model/ActionRefundResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createRMABooking()`

```php
createRMABooking($returns_refunds_create_rma_booking_request): \Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse
```

CreateRMABooking

Creates an RMA booking in the system <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.CreateReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_create_rma_booking_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRMABookingRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRMABookingRequest

try {
    $result = $apiInstance->createRMABooking($returns_refunds_create_rma_booking_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->createRMABooking: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_create_rma_booking_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRMABookingRequest**](../Model/ReturnsRefundsCreateRMABookingRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\CreateRMABookingResponse**](../Model/CreateRMABookingResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createRefund()`

```php
createRefund($returns_refunds_create_refund_request): \Linnworks\ReturnsRefunds\Model\CreateRefundResponse
```

CreateRefund

Creates a refund in the system for approval <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.CreateRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_create_refund_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRefundRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRefundRequest

try {
    $result = $apiInstance->createRefund($returns_refunds_create_refund_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->createRefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_create_refund_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsCreateRefundRequest**](../Model/ReturnsRefundsCreateRefundRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\CreateRefundResponse**](../Model/CreateRefundResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createReturnsRefundsCSV()`

```php
createReturnsRefundsCSV($from, $to, $date_type, $search_field, $exact_match, $search_term, $sort_column, $sort_direction, $history_type): string
```

CreateReturnsRefundsCSV

Creates a CSV file of the search result for download <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$from = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The lower end of the date range to search. Can be null if searching for 'all dates'. Maximum range is 3 months.
$to = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The upper end of the date range to search. Can be null if searching for 'all dates'. Maximum range is 3 months.
$date_type = 'date_type_example'; // string | The search type (e.g. ALLDATES)
$search_field = 'search_field_example'; // string | The field to search by. Can be found by calling GetSearchTypes.
$exact_match = True; // bool | Set to true if an exact match is required for the search data.
$search_term = 'search_term_example'; // string | The term which you are searching for.
$sort_column = 'sort_column_example'; // string | The column to sort by
$sort_direction = True; // bool | The sort direction (true = ascending, false = descending).
$history_type = 'history_type_example'; // string | Search type. Allow RETURNS or REFUNDS

try {
    $result = $apiInstance->createReturnsRefundsCSV($from, $to, $date_type, $search_field, $exact_match, $search_term, $sort_column, $sort_direction, $history_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->createReturnsRefundsCSV: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **from** | **\DateTime**| The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. | [optional] |
| **to** | **\DateTime**| The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. | [optional] |
| **date_type** | **string**| The search type (e.g. ALLDATES) | [optional] |
| **search_field** | **string**| The field to search by. Can be found by calling GetSearchTypes. | [optional] |
| **exact_match** | **bool**| Set to true if an exact match is required for the search data. | [optional] |
| **search_term** | **string**| The term which you are searching for. | [optional] |
| **sort_column** | **string**| The column to sort by | [optional] |
| **sort_direction** | **bool**| The sort direction (true &#x3D; ascending, false &#x3D; descending). | [optional] |
| **history_type** | **string**| Search type. Allow RETURNS or REFUNDS | [optional] |

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteBookedItem()`

```php
deleteBookedItem($returns_refunds_delete_booked_item_request)
```

DeleteBookedItem

Delete a booked returns/exchange order item <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.DeleteReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_delete_booked_item_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedItemRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedItemRequest

try {
    $apiInstance->deleteBookedItem($returns_refunds_delete_booked_item_request);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->deleteBookedItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_delete_booked_item_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedItemRequest**](../Model/ReturnsRefundsDeleteBookedItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteBookedOrder()`

```php
deleteBookedOrder($returns_refunds_delete_booked_order_request)
```

DeleteBookedOrder

Deletes a returns/exchange order <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.DeleteReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_delete_booked_order_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedOrderRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedOrderRequest

try {
    $apiInstance->deleteBookedOrder($returns_refunds_delete_booked_order_request);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->deleteBookedOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_delete_booked_order_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteBookedOrderRequest**](../Model/ReturnsRefundsDeleteBookedOrderRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deletePendingRefundItem()`

```php
deletePendingRefundItem($returns_refunds_delete_pending_refund_item_request)
```

DeletePendingRefundItem

Delete a refund item <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.DeleteRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_delete_pending_refund_item_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeletePendingRefundItemRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeletePendingRefundItemRequest

try {
    $apiInstance->deletePendingRefundItem($returns_refunds_delete_pending_refund_item_request);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->deletePendingRefundItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_delete_pending_refund_item_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeletePendingRefundItemRequest**](../Model/ReturnsRefundsDeletePendingRefundItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteRMA()`

```php
deleteRMA($returns_refunds_delete_rma_request): object
```

DeleteRMA

Deletes all lines from the given RMA header that have not yet been processed, or acknowledged as errors, removing it from the \"RMA Bookings\" screen. If no lines are left, the header row is deleted <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.DeleteReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_delete_rma_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRMARequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRMARequest

try {
    $result = $apiInstance->deleteRMA($returns_refunds_delete_rma_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->deleteRMA: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_delete_rma_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRMARequest**](../Model/ReturnsRefundsDeleteRMARequest.md)|  | |

### Return type

**object**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteRefund()`

```php
deleteRefund($returns_refunds_delete_refund_request): object
```

DeleteRefund

Deletes all lines from the given refund header that have not yet been processed, or acknowledged as errors, removing it from the \"Actionable Refunds\" screen. If no lines are left, the header row is deleted <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.DeleteRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_delete_refund_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRefundRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRefundRequest

try {
    $result = $apiInstance->deleteRefund($returns_refunds_delete_refund_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->deleteRefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_delete_refund_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsDeleteRefundRequest**](../Model/ReturnsRefundsDeleteRefundRequest.md)|  | |

### Return type

**object**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `editBookedItemInfo()`

```php
editBookedItemInfo($returns_refunds_edit_booked_item_info_request)
```

EditBookedItemInfo

Edit booked exchange/return item <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_edit_booked_item_info_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsEditBookedItemInfoRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsEditBookedItemInfoRequest

try {
    $apiInstance->editBookedItemInfo($returns_refunds_edit_booked_item_info_request);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->editBookedItemInfo: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_edit_booked_item_info_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsEditBookedItemInfoRequest**](../Model/ReturnsRefundsEditBookedItemInfoRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getActionableRMAHeaders()`

```php
getActionableRMAHeaders($returns_refunds_get_actionable_rma_headers_request): \Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse
```

GetActionableRMAHeaders

Returns a paged list of booked refund headers <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.ViewReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_actionable_rma_headers_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRMAHeadersRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRMAHeadersRequest

try {
    $result = $apiInstance->getActionableRMAHeaders($returns_refunds_get_actionable_rma_headers_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getActionableRMAHeaders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_actionable_rma_headers_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRMAHeadersRequest**](../Model/ReturnsRefundsGetActionableRMAHeadersRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetActionableRMAHeadersResponse**](../Model/GetActionableRMAHeadersResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getActionableRefundHeaders()`

```php
getActionableRefundHeaders($returns_refunds_get_actionable_refund_headers_request): \Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse
```

GetActionableRefundHeaders

Returns a paged list of booked refund headers <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.ViewRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_actionable_refund_headers_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRefundHeadersRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRefundHeadersRequest

try {
    $result = $apiInstance->getActionableRefundHeaders($returns_refunds_get_actionable_refund_headers_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getActionableRefundHeaders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_actionable_refund_headers_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetActionableRefundHeadersRequest**](../Model/ReturnsRefundsGetActionableRefundHeadersRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetActionableRefundHeadersResponse**](../Model/GetActionableRefundHeadersResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBookedReturnsExchangeOrders()`

```php
getBookedReturnsExchangeOrders(): \Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]
```

GetBookedReturnsExchangeOrders

Gets all booked returns/exchange orders <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getBookedReturnsExchangeOrders();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getBookedReturnsExchangeOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\ReturnsRefunds\Model\BookedReturnsExchangeOrder[]**](../Model/BookedReturnsExchangeOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProcessedOrAckedErrorRMAHeaders()`

```php
getProcessedOrAckedErrorRMAHeaders($returns_refunds_get_processed_or_acked_error_rma_headers_request): \Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse
```

GetProcessedOrAckedErrorRMAHeaders

Returns a paged list of processed or acknowledged error RMA headers <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.ViewReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_processed_or_acked_error_rma_headers_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest

try {
    $result = $apiInstance->getProcessedOrAckedErrorRMAHeaders($returns_refunds_get_processed_or_acked_error_rma_headers_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getProcessedOrAckedErrorRMAHeaders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_processed_or_acked_error_rma_headers_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest**](../Model/ReturnsRefundsGetProcessedOrAckedErrorRMAHeadersRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRMAHeadersResponse**](../Model/GetProcessedOrAckedErrorRMAHeadersResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProcessedOrAckedErrorRefundHeaders()`

```php
getProcessedOrAckedErrorRefundHeaders($returns_refunds_get_processed_or_acked_error_refund_headers_request): \Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse
```

GetProcessedOrAckedErrorRefundHeaders

Returns a paged list of processed or acknowledged error refund headers <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.ViewRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_processed_or_acked_error_refund_headers_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest

try {
    $result = $apiInstance->getProcessedOrAckedErrorRefundHeaders($returns_refunds_get_processed_or_acked_error_refund_headers_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getProcessedOrAckedErrorRefundHeaders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_processed_or_acked_error_refund_headers_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest**](../Model/ReturnsRefundsGetProcessedOrAckedErrorRefundHeadersRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetProcessedOrAckedErrorRefundHeadersResponse**](../Model/GetProcessedOrAckedErrorRefundHeadersResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRMAHeadersByOrderId()`

```php
getRMAHeadersByOrderId($returns_refunds_get_rma_headers_by_order_id_request): \Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse
```

GetRMAHeadersByOrderId

Returns all RMA headers associated with the given order ID <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.ViewRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_rma_headers_by_order_id_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRMAHeadersByOrderIdRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRMAHeadersByOrderIdRequest

try {
    $result = $apiInstance->getRMAHeadersByOrderId($returns_refunds_get_rma_headers_by_order_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getRMAHeadersByOrderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_rma_headers_by_order_id_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRMAHeadersByOrderIdRequest**](../Model/ReturnsRefundsGetRMAHeadersByOrderIdRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetRMAHeadersByOrderIdResponse**](../Model/GetRMAHeadersByOrderIdResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefundHeadersByOrderId()`

```php
getRefundHeadersByOrderId($returns_refunds_get_refund_headers_by_order_id_request): \Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse
```

GetRefundHeadersByOrderId

Returns all refund headers associated with the given order ID <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.ViewRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_refund_headers_by_order_id_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundHeadersByOrderIdRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundHeadersByOrderIdRequest

try {
    $result = $apiInstance->getRefundHeadersByOrderId($returns_refunds_get_refund_headers_by_order_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getRefundHeadersByOrderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_refund_headers_by_order_id_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundHeadersByOrderIdRequest**](../Model/ReturnsRefundsGetRefundHeadersByOrderIdRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetRefundHeadersByOrderIdResponse**](../Model/GetRefundHeadersByOrderIdResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefundLinesByHeaderId()`

```php
getRefundLinesByHeaderId($returns_refunds_get_refund_lines_by_header_id_request): \Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse
```

GetRefundLinesByHeaderId

Returns a refund, given its header ID <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.ViewRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_refund_lines_by_header_id_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundLinesByHeaderIdRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundLinesByHeaderIdRequest

try {
    $result = $apiInstance->getRefundLinesByHeaderId($returns_refunds_get_refund_lines_by_header_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getRefundLinesByHeaderId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_refund_lines_by_header_id_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundLinesByHeaderIdRequest**](../Model/ReturnsRefundsGetRefundLinesByHeaderIdRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetRefundLinesByHeaderIdResponse**](../Model/GetRefundLinesByHeaderIdResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefundOptions()`

```php
getRefundOptions($returns_refunds_get_refund_options_request): \Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse
```

GetRefundOptions

Returns channel-specific information regarding the types of refund that can be applied to the given order <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.ViewRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_refund_options_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundOptionsRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundOptionsRequest

try {
    $result = $apiInstance->getRefundOptions($returns_refunds_get_refund_options_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getRefundOptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_refund_options_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetRefundOptionsRequest**](../Model/ReturnsRefundsGetRefundOptionsRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetRefundOptionsResponse**](../Model/GetRefundOptionsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRefundOrders()`

```php
getRefundOrders(): \Linnworks\ReturnsRefunds\Model\RefundOrder[]
```

GetRefundOrders

Gets all refund order items for all orders <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getRefundOrders();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getRefundOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\ReturnsRefunds\Model\RefundOrder[]**](../Model/RefundOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getReturnOptions()`

```php
getReturnOptions($returns_refunds_get_return_options_request): \Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse
```

GetReturnOptions

Returns channel-specific information regarding the types of refund that can be applied to the given order <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.ViewReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_get_return_options_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetReturnOptionsRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetReturnOptionsRequest

try {
    $result = $apiInstance->getReturnOptions($returns_refunds_get_return_options_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getReturnOptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_get_return_options_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsGetReturnOptionsRequest**](../Model/ReturnsRefundsGetReturnOptionsRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GetReturnOptionsResponse**](../Model/GetReturnOptionsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSearchTypes()`

```php
getSearchTypes($history_type): \Linnworks\ReturnsRefunds\Model\SearchField[]
```

GetSearchTypes

Gets a list of valid search types. These are needed to search processed orders. <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$history_type = 'history_type_example'; // string | Search type. Allow RETURNS or REFUNDS

try {
    $result = $apiInstance->getSearchTypes($history_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getSearchTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **history_type** | **string**| Search type. Allow RETURNS or REFUNDS | [optional] |

### Return type

[**\Linnworks\ReturnsRefunds\Model\SearchField[]**](../Model/SearchField.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTotalRefunds()`

```php
getTotalRefunds($fk_order_id): float
```

GetTotalRefunds

Gets the refundable amount of an order <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$fk_order_id = 'fk_order_id_example'; // string | unique order ID of the order

try {
    $result = $apiInstance->getTotalRefunds($fk_order_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getTotalRefunds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **fk_order_id** | **string**| unique order ID of the order | [optional] |

### Return type

**float**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getWarehouseLocations()`

```php
getWarehouseLocations(): \Linnworks\ReturnsRefunds\Model\WarehouseLocation[]
```

GetWarehouseLocations

Gets all warehouse locations <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getWarehouseLocations();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->getWarehouseLocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\ReturnsRefunds\Model\WarehouseLocation[]**](../Model/WarehouseLocation.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `refundOrder()`

```php
refundOrder($returns_refunds_refund_order_request)
```

RefundOrder

Refund an order given the order ID <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_refund_order_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsRefundOrderRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsRefundOrderRequest

try {
    $apiInstance->refundOrder($returns_refunds_refund_order_request);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->refundOrder: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_refund_order_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsRefundOrderRequest**](../Model/ReturnsRefundsRefundOrderRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchReturnsRefundsPaged()`

```php
searchReturnsRefundsPaged($from, $to, $date_type, $search_field, $exact_match, $search_term, $page_num, $num_entries_per_page, $history_type): \Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb
```

SearchReturnsRefundsPaged

Searches through returns/refunds history that meets the parameters' criteria <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$from = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The lower end of the date range to search. Can be null if searching for 'all dates'. Maximum range is 3 months.
$to = new \DateTime('2013-10-20T19:20:30+01:00'); // \DateTime | The upper end of the date range to search. Can be null if searching for 'all dates'. Maximum range is 3 months.
$date_type = 'date_type_example'; // string | The search type (e.g. ALLDATES)
$search_field = 'search_field_example'; // string | The field to search by. Can be found by calling GetSearchTypes.
$exact_match = True; // bool | Set to true if an exact match is required for the search data.
$search_term = 'search_term_example'; // string | The term which you are searching for.
$page_num = 56; // int | The page number of the request.
$num_entries_per_page = 56; // int | The number of entries required on a page. Maximum 200.
$history_type = 'history_type_example'; // string | Search type. Allow RETURNS or REFUNDS

try {
    $result = $apiInstance->searchReturnsRefundsPaged($from, $to, $date_type, $search_field, $exact_match, $search_term, $page_num, $num_entries_per_page, $history_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->searchReturnsRefundsPaged: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **from** | **\DateTime**| The lower end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. | [optional] |
| **to** | **\DateTime**| The upper end of the date range to search. Can be null if searching for &#39;all dates&#39;. Maximum range is 3 months. | [optional] |
| **date_type** | **string**| The search type (e.g. ALLDATES) | [optional] |
| **search_field** | **string**| The field to search by. Can be found by calling GetSearchTypes. | [optional] |
| **exact_match** | **bool**| Set to true if an exact match is required for the search data. | [optional] |
| **search_term** | **string**| The term which you are searching for. | [optional] |
| **page_num** | **int**| The page number of the request. | [optional] |
| **num_entries_per_page** | **int**| The number of entries required on a page. Maximum 200. | [optional] |
| **history_type** | **string**| Search type. Allow RETURNS or REFUNDS | [optional] |

### Return type

[**\Linnworks\ReturnsRefunds\Model\GenericPagedResultReturnsRefundsWeb**](../Model/GenericPagedResultReturnsRefundsWeb.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateRMABooking()`

```php
updateRMABooking($returns_refunds_update_rma_booking_request): \Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse
```

UpdateRMABooking

Updates an RMA booking in the system. Requires create and delete permissions <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.ReturnsExchanges.CreateReturnsExchangesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_update_rma_booking_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRMABookingRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRMABookingRequest

try {
    $result = $apiInstance->updateRMABooking($returns_refunds_update_rma_booking_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->updateRMABooking: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_update_rma_booking_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRMABookingRequest**](../Model/ReturnsRefundsUpdateRMABookingRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\UpdateRMABookingResponse**](../Model/UpdateRMABookingResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateRefund()`

```php
updateRefund($returns_refunds_update_refund_request): \Linnworks\ReturnsRefunds\Model\UpdateRefundResponse
```

UpdateRefund

Updates an existing refund in the system. Requires create and delete permissions <b>Permissions Required: </b> GlobalPermissions.OrderBook.ReturnsRefunds.Refunds.CreateRefundsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\ReturnsRefunds\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\ReturnsRefunds\Api\ReturnsRefundsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$returns_refunds_update_refund_request = new \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRefundRequest(); // \Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRefundRequest

try {
    $result = $apiInstance->updateRefund($returns_refunds_update_refund_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ReturnsRefundsApi->updateRefund: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **returns_refunds_update_refund_request** | [**\Linnworks\ReturnsRefunds\Model\ReturnsRefundsUpdateRefundRequest**](../Model/ReturnsRefundsUpdateRefundRequest.md)|  | |

### Return type

[**\Linnworks\ReturnsRefunds\Model\UpdateRefundResponse**](../Model/UpdateRefundResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
